/*	AppDelegate.h - Handles launch and termination of application

	$Id: AppDelegate.h,v 1.9 2006/02/02 00:30:16 willthimbleby Exp $
	
	Copyright 2002 Will Thimbleby (wjt100@york.ac.uk)
	
	This program is free software; you can redistribute it and/or modify it under the terms of the
	GNU General Public License as published by the Free Software Foundation version 2.
	
	This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	General Public License for more details. (http://www.gnu.org/licenses/gpl.html)
*/

#import <Cocoa/Cocoa.h>

extern NSCursor	*linkCursor;

#define DragDropSimplePboardType 	@"MyCustomOutlineViewPboardType"
#define	DragDropVerseListPboardType	@"MyVerseListOutlineViewPboardType"

@class ModuleManager, PrefHandler;

@interface AppDelegate : NSObject {
	IBOutlet id aboutTextBox;
	IBOutlet id	versionTextBox;
	
	IBOutlet PrefHandler *prefHandler;
    
    /** the module manager */
    ModuleManager *moduleManager;
}

- (void)applicationDidFinishLaunching:(NSNotification *)notification;
- (void)applicationWillTerminate:(NSNotification *)aNotification;

- (void)todaysDevotion:(id)sender;
- (void)loadManager;
- (BOOL)setupFolders;

- (BOOL)applicationShouldHandleReopen:(NSApplication *)theApplication hasVisibleWindows:(BOOL)flag;
- (BOOL)applicationShouldOpenUntitledFile:(NSApplication *)sender;

// actions
- (IBAction)openModuleInstaller:(id)sender;
- (IBAction)menuGiveFeedback:(id)sender;
- (IBAction)menuVisitWebsite:(id)sender;

@end
