//
//  MBLogger.h
//  CocoLogger
//
//  Created by Manfred Bergmann on 02.06.05.
//  Copyright 2005 mabe. All rights reserved.
//

// $Author: asrael $
// $HeadURL: file:///REPOSITORY/private/cocoa/CocoLogger/releases/CocoLogger-0.4/src/MBLogger.h $
// $LastChangedBy: asrael $
// $LastChangedDate: 2006-01-11 02:05:48 +0100 (Wed, 11 Jan 2006) $
// $Rev: 477 $

#import <Cocoa/Cocoa.h>
#import <unistd.h>
#import <syslog.h>

// define for logging
#define MBLOG(LEVEL,MSG)			[MBLogger log:MSG level:LEVEL]
#define MBLOGV(LEVEL,MSG,ARGS...)	[MBLogger log:[NSString stringWithFormat:MSG,ARGS] level:LEVEL]

typedef enum
{
	MBLOG_OFF = 1,
	MBLOG_CRIT,
	MBLOG_ERR,
	MBLOG_WARN,
	MBLOG_INFO,
	MBLOG_DEBUG
}MBLoggingLevel;

// forward declaration of mblog function
void MBLog(MBLoggingLevel level, NSString *msg, ...);

@interface MBLogger : NSObject 
{
	
}

// init or close the logger
+ (int)initLogger:(NSString *)logPath
		logPrefix:(NSString *)aPrefix
   logFilterLevel:(int)aLevel
	 appendToFile:(BOOL)fileAppend
	 logToConsole:(BOOL)consoleLogging;

+ (int)closeLogger;

// set or get the logfilter level
+ (void)setLogFilterLevel:(int)aLevel;
+ (int)logFilterLevel;

// set or get logPrefix
+ (void)setLogPrefix:(NSString *)aPrefix;
+ (NSString *)logPrefix;

// make logoutput
+ (int)log:(NSString *)message level:(int)aLevel;

@end
