//
//  GPGSingleKeySelectionPanel.m
//  GPGAppKit
//
//  Created by Simon Stapleton on Mon Feb 18 2002.
//
//  Copyright (C) 2001-2002 Mac GPG Project.
//
//  This code is free software; you can redistribute it and/or modify it under
//  the terms of the GNU General Public License as published by the Free
//  Software Foundation; either version 2 of the License, or any later version.
//
//  This code is distributed in the hope that it will be useful, but WITHOUT ANY
//  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
//  FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
//  details.
//
//  For a copy of the GNU General Public License, visit <http://www.gnu.org/> or
//  write to the Free Software Foundation, Inc., 59 Temple Place--Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  More info at <http://macgpg.sourceforge.net/> or <macgpg@rbisland.cx>
//

#import "GPGKeySelectionPanel.h"
#import "GPGSingleKeySelectionPanel.h"
#import "GPGAppKitDefines.h"
#import "GPGDummyPanelOwner.h"

static GPGSingleKeySelectionPanel * sharedGPGSingleKeySelectionPanel = nil;


@implementation GPGSingleKeySelectionPanel

+ (id) panel {
    if (sharedGPGSingleKeySelectionPanel == nil)
        [[GPGDummyPanelOwner alloc] initWithNibNamed:@"GPGSingleKeySelectionPanel"];
    return sharedGPGSingleKeySelectionPanel;
}

- (void)awakeFromNib
{
    sharedGPGSingleKeySelectionPanel = self;
    [self resetToDefaults];
}

- (void) resetToDefaults {
    NSBundle * mybundle = [NSBundle bundleForClass:[self class]];
    [self setTitle:[mybundle localizedStringForKey:GPGAppKitSingleKeySelectionPanelTitle
                                             value:@"Arse"
                                             table:nil]];
    [self setPrompt:[mybundle localizedStringForKey:GPGAppKitSingleKeySelectionPanelPrompt
                                              value:@"Arse"
                                              table:nil]];
    [self setListsSecretKeys:NO];
    [self setListsAllNames:NO];
    [self setMinimumKeyValidity:GPGValidityMarginal];
    [self setOkPressed:NO];
}

- (void) resetKeyListForWildcard: (NSString *) wildcard
                    usingContext: (GPGContext *) context
{
    [keySelector removeAllItems];
    [super resetKeyListForWildcard: wildcard
                      usingContext: context];
}

- (void) addObjectToSelectorTitled:(NSString *)title {
    [keySelector addItemWithTitle:title];
}

- (GPGKey *) selectedKey {
    if ([self okPressed]) {
        return [[self keys] objectAtIndex:[keySelector indexOfSelectedItem]];
    } else {
        return nil;
    }
}

- (void) setPrompt: (NSString *) prompt {
    [promptTextField setStringValue:prompt];
}

@end
