
/*
 * Copyright (c) 2002 Packet Design, LLC.
 * All rights reserved.
 * 
 * Subject to the following obligations and disclaimer of warranty,
 * use and redistribution of this software, in source or object code
 * forms, with or without modifications are expressly permitted by
 * Packet Design; provided, however, that:
 * 
 *    (i)  Any and all reproductions of the source or object code
 *         must include the copyright notice above and the following
 *         disclaimer of warranties; and
 *    (ii) No rights are granted, in any manner or form, to use
 *         Packet Design trademarks, including the mark "PACKET DESIGN"
 *         on advertising, endorsements, or otherwise except as such
 *         appears in the above copyright notice or in the software.
 * 
 * THIS SOFTWARE IS BEING PROVIDED BY PACKET DESIGN "AS IS", AND
 * TO THE MAXIMUM EXTENT PERMITTED BY LAW, PACKET DESIGN MAKES NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, REGARDING
 * THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY AND ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT.  PACKET DESIGN DOES NOT WARRANT, GUARANTEE,
 * OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF, OR THE RESULTS
 * OF THE USE OF THIS SOFTWARE IN TERMS OF ITS CORRECTNESS, ACCURACY,
 * RELIABILITY OR OTHERWISE.  IN NO EVENT SHALL PACKET DESIGN BE
 * LIABLE FOR ANY DAMAGES RESULTING FROM OR ARISING OUT OF ANY USE
 * OF THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE, OR CONSEQUENTIAL
 * DAMAGES, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, LOSS OF
 * USE, DATA OR PROFITS, HOWEVER CAUSED AND UNDER ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF PACKET DESIGN IS ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Author: Archie Cobbs <archie@packetdesign.com>
 */

#include "lws_global.h"
#include "lws_tmpl.h"
#include "lws_tmpl_passwd.h"
#include <pwd.h>

/***********************************************************************
			PASSWD OBJECT
***********************************************************************/

#define LWS_PASSWD_OBJECT_MTYPE	"passwd"

#define PASSWD_FIELD(n, t)	STRUCTS_STRUCT_FIELD2(passwd, pw_ ## n, #n, t)

/* Structs type for 'passwd' entry */
static const struct structs_field passwd_fields[] = {
	PASSWD_FIELD(name, &structs_type_string),
	PASSWD_FIELD(passwd, &structs_type_string),
	PASSWD_FIELD(uid, &structs_type_uint32),
	PASSWD_FIELD(gid, &structs_type_uint32),
#ifndef __linux__
	PASSWD_FIELD(change, &structs_type_time_abs),
	PASSWD_FIELD(class, &structs_type_string),
#endif
	PASSWD_FIELD(gecos, &structs_type_string),
	PASSWD_FIELD(dir, &structs_type_string),
	PASSWD_FIELD(shell, &structs_type_string),
#ifndef __linux__
	PASSWD_FIELD(expire, &structs_type_time_abs),
#endif
	{ NULL }
};
static const struct structs_type passwd_type
	= STRUCTS_STRUCT_TYPE(passwd, passwd_fields);

struct tinfo lws_tmpl_passwd_tinfo
	= TINFO_INIT(&passwd_type, LWS_PASSWD_OBJECT_MTYPE, NULL);

