
/*
 * Copyright (c) 2002 Packet Design, LLC.
 * All rights reserved.
 * 
 * Subject to the following obligations and disclaimer of warranty,
 * use and redistribution of this software, in source or object code
 * forms, with or without modifications are expressly permitted by
 * Packet Design; provided, however, that:
 * 
 *    (i)  Any and all reproductions of the source or object code
 *         must include the copyright notice above and the following
 *         disclaimer of warranties; and
 *    (ii) No rights are granted, in any manner or form, to use
 *         Packet Design trademarks, including the mark "PACKET DESIGN"
 *         on advertising, endorsements, or otherwise except as such
 *         appears in the above copyright notice or in the software.
 * 
 * THIS SOFTWARE IS BEING PROVIDED BY PACKET DESIGN "AS IS", AND
 * TO THE MAXIMUM EXTENT PERMITTED BY LAW, PACKET DESIGN MAKES NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, REGARDING
 * THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY AND ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT.  PACKET DESIGN DOES NOT WARRANT, GUARANTEE,
 * OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF, OR THE RESULTS
 * OF THE USE OF THIS SOFTWARE IN TERMS OF ITS CORRECTNESS, ACCURACY,
 * RELIABILITY OR OTHERWISE.  IN NO EVENT SHALL PACKET DESIGN BE
 * LIABLE FOR ANY DAMAGES RESULTING FROM OR ARISING OUT OF ANY USE
 * OF THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE, OR CONSEQUENTIAL
 * DAMAGES, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, LOSS OF
 * USE, DATA OR PROFITS, HOWEVER CAUSED AND UNDER ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF PACKET DESIGN IS ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Author: Archie Cobbs <archie@packetdesign.com>
 */

#ifndef _LWS_TMPL_H_
#define _LWS_TMPL_H_

/* Information passed to tmpl servlet user-defined functions */
struct lws_tmpl_info {
	const struct lws_server		*server;
	const struct lws_file_info	*fileinfo;
	int				sidx;		/* server index */
	int				vidx;		/* vhost index */
	int				lidx;		/* servlet index */
};

/* Descriptor for an LWS template function */
struct lws_tmpl_func {
	struct tmpl_func	func;		/* the usual info */
	const char		*params;	/* parameter names */
	const char		*desc;		/* description */
};

#define LWS_TMPL_FUNC2(name, prefix, min, max, params, desc)	\
	{ { (#name), (min), (max), (prefix ## name) }, (params), (desc) }
#define LWS_TMPL_FUNC(name, min, max, params, desc)	\
	LWS_TMPL_FUNC2(name, lws_tf_, min, max, params, desc)

/* Template function list per-thread object */
extern struct	tinfo lws_tmpl_funclist_tinfo;

/* Tmpl servlet handler and error formatter functions */
extern tmpl_handler_t	lws_tmpl_handler;
extern tmpl_errfmtr_t	lws_tmpl_errfmtr;

/* Template function list setup/teardown */
extern int	lws_tmpl_funcs_init(void);
extern void	lws_tmpl_funcs_uninit(void);

#endif	/* !_LWS_TMPL_H_ */
