
/*
 * Copyright (c) 2002 Packet Design, LLC.
 * All rights reserved.
 * 
 * Subject to the following obligations and disclaimer of warranty,
 * use and redistribution of this software, in source or object code
 * forms, with or without modifications are expressly permitted by
 * Packet Design; provided, however, that:
 * 
 *    (i)  Any and all reproductions of the source or object code
 *         must include the copyright notice above and the following
 *         disclaimer of warranties; and
 *    (ii) No rights are granted, in any manner or form, to use
 *         Packet Design trademarks, including the mark "PACKET DESIGN"
 *         on advertising, endorsements, or otherwise except as such
 *         appears in the above copyright notice or in the software.
 * 
 * THIS SOFTWARE IS BEING PROVIDED BY PACKET DESIGN "AS IS", AND
 * TO THE MAXIMUM EXTENT PERMITTED BY LAW, PACKET DESIGN MAKES NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, REGARDING
 * THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY AND ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT.  PACKET DESIGN DOES NOT WARRANT, GUARANTEE,
 * OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF, OR THE RESULTS
 * OF THE USE OF THIS SOFTWARE IN TERMS OF ITS CORRECTNESS, ACCURACY,
 * RELIABILITY OR OTHERWISE.  IN NO EVENT SHALL PACKET DESIGN BE
 * LIABLE FOR ANY DAMAGES RESULTING FROM OR ARISING OUT OF ANY USE
 * OF THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE, OR CONSEQUENTIAL
 * DAMAGES, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, LOSS OF
 * USE, DATA OR PROFITS, HOWEVER CAUSED AND UNDER ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF PACKET DESIGN IS ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Author: Archie Cobbs <archie@packetdesign.com>
 */

#ifndef _LWS_GLOBAL_H_
#define _LWS_GLOBAL_H_

/* Includes for everyone */

#include <sys/types.h>
#include <sys/param.h>
#include <sys/stat.h>

#include <netinet/in.h>
#include <arpa/inet.h>

#include <openssl/ssl.h>

#include <stdio.h>
#include <stddef.h>
#include <stdarg.h>
#include <syslog.h>
#include <pthread.h>
#include <errno.h>
#include <string.h>
#include <assert.h>
#include <regex.h>
#include <unistd.h>
#include <fcntl.h>
#include <ctype.h>
#include <signal.h>
#include <time.h>
#include <err.h>

#include <pdel/version.h>
#include <pdel/structs/structs.h>
#include <pdel/structs/type/array.h>
#include <pdel/structs/type/boolean.h>
#include <pdel/structs/type/id.h>
#include <pdel/structs/type/int.h>
#include <pdel/structs/type/ip4.h>
#include <pdel/structs/type/regex.h>
#include <pdel/structs/type/string.h>
#include <pdel/structs/type/struct.h>
#include <pdel/structs/type/time.h>
#include <pdel/structs/type/union.h>
#include <pdel/structs/xml.h>

#include <pdel/tmpl/tmpl.h>
#include <pdel/util/typed_mem.h>
#include <pdel/util/tinfo.h>
#include <pdel/util/pevent.h>
#include <pdel/config/app_config.h>
#include <pdel/sys/alog.h>
#include <pdel/io/string_fp.h>
#include <pdel/io/base64.h>

#include <pdel/http/http_defs.h>
#include <pdel/http/http_server.h>
#include <pdel/http/servlet/basicauth.h>
#include <pdel/http/servlet/cookieauth.h>
#include <pdel/http/servlet/redirect.h>
#include <pdel/http/servlet/tmpl.h>
#include <pdel/http/servlet/file.h>

#if PDEL_VERSION < 000003003
#error "libpdel version 0.3.3 or later is required"
#endif

/* Definitions */

#define DEFAULT_CONFIG_FILE	"default-config.xml"
#define CONFIG_FILE		"config.xml"

/* Memory type used by all template strings */
#define TMPL_MEM_TYPE		"lws_tmpl"

/* Variables */

extern pid_t	pid;
extern int	debug_level;
extern struct	pevent_ctx *lws_event_ctx;

#endif	/* !_LWS_GLOBAL_H_ */
