
/*
 * Copyright (c) 2002 Packet Design, LLC.
 * All rights reserved.
 * 
 * Subject to the following obligations and disclaimer of warranty,
 * use and redistribution of this software, in source or object code
 * forms, with or without modifications are expressly permitted by
 * Packet Design; provided, however, that:
 * 
 *    (i)  Any and all reproductions of the source or object code
 *         must include the copyright notice above and the following
 *         disclaimer of warranties; and
 *    (ii) No rights are granted, in any manner or form, to use
 *         Packet Design trademarks, including the mark "PACKET DESIGN"
 *         on advertising, endorsements, or otherwise except as such
 *         appears in the above copyright notice or in the software.
 * 
 * THIS SOFTWARE IS BEING PROVIDED BY PACKET DESIGN "AS IS", AND
 * TO THE MAXIMUM EXTENT PERMITTED BY LAW, PACKET DESIGN MAKES NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, REGARDING
 * THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY AND ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT.  PACKET DESIGN DOES NOT WARRANT, GUARANTEE,
 * OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF, OR THE RESULTS
 * OF THE USE OF THIS SOFTWARE IN TERMS OF ITS CORRECTNESS, ACCURACY,
 * RELIABILITY OR OTHERWISE.  IN NO EVENT SHALL PACKET DESIGN BE
 * LIABLE FOR ANY DAMAGES RESULTING FROM OR ARISING OUT OF ANY USE
 * OF THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE, OR CONSEQUENTIAL
 * DAMAGES, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, LOSS OF
 * USE, DATA OR PROFITS, HOWEVER CAUSED AND UNDER ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF PACKET DESIGN IS ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Author: Archie Cobbs <archie@freebsd.org>
 */

#ifndef _LWS_CONFIG_H_
#define _LWS_CONFIG_H_

/* Information for a file servlet */
struct lws_file_info {
	char			*docroot;
	u_char			allow_escape;
	u_char			allow_templates;
	char			*filename;
	char			*prefix;
	char			*mime_type;
	char			*mime_encoding;
};

/* Information for a redirect servlet */
struct lws_redirect_info {
	char			*url;
	int			method;
};

/* Information for a basic auth servlet */
struct lws_basicauth_info {
	char			*realm;
	char			*username_property;
	char			*password_property;
};

/* Information for a cookieauth servlet */
struct lws_cookieauth_info {
	char			*resource_name;
	char			*logon_url;
	char			*cookie_name;
	u_char			allow_exceptions;
	struct structs_regex	exceptions_pattern;
};

union lws_servlet_info {
	struct lws_file_info		file;
	struct lws_redirect_info	redirect;
	struct lws_basicauth_info	basicauth;
	struct lws_cookieauth_info	cookieauth;
};

DEFINE_STRUCTS_UNION(lws_servlet_info_union, lws_servlet_info);

struct lws_servlet {
	struct structs_regex		url_pattern;
	int				ordering;
	struct lws_servlet_info_union	info;
};

DEFINE_STRUCTS_ARRAY(lws_servlet_ary, struct lws_servlet);

struct lws_virthost {
	char			*server_name;
	u_char			default_virtual_host;
	struct lws_servlet_ary	servlets;
};

DEFINE_STRUCTS_ARRAY(lws_virthost_ary, struct lws_virthost);

struct lws_server_ssl {
	u_char			enabled;
	char			*private_key;
	char			*certificate;
};

struct lws_server {
	struct in_addr		ip;
	u_int16_t		port;
	struct lws_server_ssl	ssl;
	struct lws_virthost_ary	virtual_hosts;
};

DEFINE_STRUCTS_ARRAY(lws_server_ary, struct lws_server);

/* Name, value pairs for use by the servlets */
struct lws_property {
	char			*name;
	char			*value;
};

DEFINE_STRUCTS_ARRAY(lws_property_ary, struct lws_property);

/* Configuration object for the lws application */
struct lws_config {
	char			*pidfile;
	struct alog_config	error_log;
	struct lws_server_ary	servers;
	struct lws_property_ary	properties;
};

/* Variables */
extern const	struct structs_type lws_config_type;
extern struct	app_config_ctx *lws_config_ctx;
extern const	struct lws_config *const lws_curconf;

/* Functions */
extern int	lws_config_init(struct pevent_ctx *ctx, const char *path);

#endif	/* !_LWS_CONFIG_H_ */
