local math_utils = require('radio.utilities.math_utils')

describe("math_utils", function ()
    it("ceil_log2()", function ()
        assert.is.equal(0, math_utils.ceil_log2(1))
        assert.is.equal(1, math_utils.ceil_log2(2))
        assert.is.equal(6, math_utils.ceil_log2(50))
        assert.is.equal(6, math_utils.ceil_log2(64))
        assert.is.equal(7, math_utils.ceil_log2(65))
        assert.is.equal(7, math_utils.ceil_log2(128))
    end)

    it("is_pow2()", function ()
        assert.is.equal(true, math_utils.is_pow2(1))
        assert.is.equal(true, math_utils.is_pow2(2))
        assert.is.equal(true, math_utils.is_pow2(4))
        assert.is.equal(true, math_utils.is_pow2(8))
        assert.is.equal(true, math_utils.is_pow2(16))
        assert.is.equal(true, math_utils.is_pow2(32))
        assert.is.equal(true, math_utils.is_pow2(64))
        assert.is.equal(true, math_utils.is_pow2(128))
        assert.is.equal(false, math_utils.is_pow2(0))
        assert.is.equal(false, math_utils.is_pow2(3))
        assert.is.equal(false, math_utils.is_pow2(5))
        assert.is.equal(false, math_utils.is_pow2(12))
        assert.is.equal(false, math_utils.is_pow2(24))
        assert.is.equal(false, math_utils.is_pow2(31))
        assert.is.equal(false, math_utils.is_pow2(60))
        assert.is.equal(false, math_utils.is_pow2(120))
    end)
end)
