# Installation

LuaRadio can be installed from the AUR on Arch Linux, from Homebrew on Mac OS
X, or from source.

Packaging for other distributions and platforms is a work in progress.

To try LuaRadio without installation, you can run it [directly from the
repository](../README.md#quickstart), provided LuaJIT is installed. The
real-time dependencies described [below](#real-time-dependencies) will also be
necessary for real-time applications.

## Arch Linux AUR

LuaRadio is available in the Arch Linux AUR under the package
[`luaradio`](https://aur.archlinux.org/packages/luaradio).

## macOS Homebrew

LuaRadio is available in [Homebrew](http://brew.sh/) for macOS / Mac OS X:

```
brew install luaradio
```

## Source

Install LuaJIT 2.0.4 or greater and prerequisites:

* Arch Linux: `luajit`
* macOS (Homebrew): `luajit`, `pkg-config`
* macOS/Darwin (MacPorts): `luajit`, `pkgconfig`
* Ubuntu/Debian: `luajit`, `libluajit-5.1-dev`,`pkg-config`
* Fedora, CentOS/RHEL/SL 7 or up: `luajit`, `luajit-devel`

Build and install LuaRadio:

```
git clone https://github.com/vsergeev/luaradio.git
cd luaradio/embed
make lib
sudo make install
```

### Real-time Dependencies

LuaRadio has no hard dependencies outside of LuaJIT, but for real-time
applications, the [liquid-dsp](https://github.com/jgaeddert/liquid-dsp) or
[VOLK](https://github.com/gnuradio/volk), and [fftw](http://www.fftw.org/)
libraries are strongly encouraged for appreciable performance.

### Optional Dependencies

Desktop users should also install the `gnuplot` package for plotting support.

Some I/O blocks, like SDR and audio sources/sinks, may require external
libraries. For example, the RTL-SDR requires the `librtlsdr` library.

### Check Installation

Check the installation by dumping the platform information:

```
$ luaradio --platform
luajit          LuaJIT 2.0.5
os              Linux
arch            x64
page size       4096
cpu count       4
cpu model       Intel(R) Core(TM) i5-4570T CPU @ 2.90GHz
features
    fftw3f      true    fftw-3.3.8-sse2-avx
    volk        true    2.1 (avx2_64_mmx_orc)
    liquid      true    1.3.2
$
```

The `liquid`, `volk`, and `fftw3f` features should be marked true, if the
respective libraries were found by LuaRadio.
