# Applications

LuaRadio comes with a collection of built-in command-line applications,
including analog radio receivers like AM and Narrowband FM, digital radio
receivers like AX.25 and POCSAG, and utilities like an IQ file converter. The
applications accept a variety of inputs, including all the SDR sources
supported by the framework, as well as IQ file and network sources. The
applications also support a variety of outputs, like audio and WAV file for
analog receivers, or text and JSON for digital receivers.

## Usage

Built-in applications can be selected using the `-a` option with the `luaradio`
runner:

```
$ luaradio
Usage: luaradio [options] <script> [args]

Options:
  -h, --help            Print help and exit
  --version             Print version and exit
  --platform            Dump platform and exit
  -v, --verbose         Enable debug verbosity
  -a, --application     Run built-in application

Application Usage: ./luaradio -a <application> [args]

Built-in Applications:
  rx_raw                Raw Receiver
  rx_wbfm               Wideband FM Receiver
  rx_nbfm               Narrowband FM Receiver
  rx_am                 AM Receiver
  rx_ssb                SSB Receiver
  rx_rds                RDS Receiver
  rx_ax25               AX.25 Receiver
  rx_pocsag             POCSAG Receiver
  rx_ert                ERT Receiver (IDM, SCM, SCM+)
  iq_converter          IQ File Converter
$
```

For example, to run the `rx_wbfm` application:

```
luaradio -a rx_wbfm
```

## Application Options

Most applications require specifying an input (e.g. an SDR source) with the
`-i` option, sometimes an output with the `-o` option, and positional arguments
like frequency or sample rate. By default, the first supported output will be
used if one is not specified.

Check the application usage to get a list of supported inputs, outputs, and
other application-specific options:

```
$ luaradio -a rx_wbfm
Usage: luaradio -a rx_wbfm -i <input> [-o <output>] [options] <frequency>

Wideband FM Receiver

Supported Inputs:
  rtlsdr                rtlsdr
  airspy                airspy
  airspyhf              airspyhf
  bladerf               bladerf
  hackrf                hackrf
  sdrplay               sdrplay
  uhd                   uhd:<device>
  soapysdr              soapysdr:<driver>,<rate>
  networkclient         networkclient:<rate>,<format>,<tcp/unix>,<address>
  networkserver         networkserver:<rate>,<format>,<tcp/unix>,<address>
  iqfile                iqfile:<filename>,<format>,<rate>

Supported Outputs:
  pulseaudio            pulseaudio
  portaudio             portaudio
  wavfile               wavfile:<filename>

Options:
  -h, --help            Print application help and exit
  -i, --input           Input, in format <input>[:<options>]
  -o, --output          Output, in format <output>[:<options>]
  --mono                Mono receiver (default stereo)

Arguments:
  frequency             Station frequency in Hz, e.g. 104.3e6

Options for inputs and outputs can be specified
with comma delimited key-value pairs. Example:

  rtlsdr:biastee=true,freq_correction=10
$ 
```

For example, to run the Wideband FM receiver application with the `rtlsdr`
input and the default `pulseaudio` output, tuned to 105.3 MHz:

```
luaradio -a rx_wbfm -i rtlsdr 105.3e6
```

For example, to run the POCSAG receiver application with the `rtlsdr` source
and the `json` output, tuned to 152.840 MHz:

```
luaradio -a rx_pocsag -i rtlsdr -o json 152.840e6
```

## Input and Output Options

Input and output options can be specified with the following syntax:

```
<name>:<arg 1>,<arg 2>,...,<key 1>=<value>,<key 2>=<value>,...
```

Supported positional arguments will be documented in the application usage.

For example, to specify the `networkclient` source with the positional
arguments of `<rate>,<format>,<tcp/unix>,<address>` for 1 MHz sample rate,
unsigned 8-bit samples, a TCP connection, and the address `192.168.1.100:1234`:

```
networkclient:1e6,u8,tcp,192.168.1.100:1234
```

For example, to specify the `iqfile` source with the positional arguments of
`<filename>,<format>,<rate>` for file `test.iq`, little endian 32-bit float
samples, and 1 MHz sample rate:

```
iqfile:test.iq,f32le,1e6
```

## Key-Value Pair Options

Key-value pair options can be used to specify additional source-specific
options that are available in the underlying LuaRadio source block. For
example, to specify the `biastee` and `freq_corection` options for the `rtlsdr`
input available with the [RtlSdrSource](0.reference-manual.md#rtlsdrsource):

```
rtlsdr:biastee=true,freq_correction=10
```
