# Supported Hardware

## Hardware SDR Sources and Sinks

Hardware SDRs source and sink digital I/Q samples through USB, PCI, or other
high speed interfaces.

### Sources

* [SoapySDR](https://github.com/pothosware/SoapySDR/wiki) with [`SoapySDRSource`](0.reference-manual.md#soapysdrsource) via [libSoapySDR](https://github.com/pothosware/SoapySDR)
* [RTL-SDR](http://www.rtl-sdr.com/about-rtl-sdr/) with [`RtlSdrSource`](0.reference-manual.md#rtlsdrsource) via [librtlsdr](http://sdr.osmocom.org/trac/wiki/rtl-sdr)
* [Airspy R2 and Mini](http://airspy.com/) with [`AirspySource`](0.reference-manual.md#airspysource) via [libairspy](https://github.com/airspy/airspyone_host)
* [Airspy HF+ Dual Port and Discovery](http://airspy.com/) with [`AirspyHFSource`](0.reference-manual.md#airspyhfsource) via [libairspyhf](https://github.com/airspy/airspyhf)
* [HackRF One](https://greatscottgadgets.com/hackrf/) with [`HackRFSource`](0.reference-manual.md#hackrfsource) via [libhackrf](https://github.com/mossmann/hackrf)
* [SDRplay RSP](http://sdrplay.com/) with [`SDRplaySource`](0.reference-manual.md#sdrplaysource) via [libmirsdrapi-rsp](https://www.sdrplay.com/downloads/)
* [USRP](https://www.ettus.com/) with [`UHDSource`](0.reference-manual.md#uhdsource) via [libuhd](https://github.com/EttusResearch/uhd)

* [BladeRF](https://www.nuand.com/) with [`BladeRFSource`](0.reference-manual.md#bladerfsource) via [libbladeRF](https://github.com/Nuand/bladeRF/tree/master/host/libraries/libbladeRF)

### Sinks

* [SoapySDR](https://github.com/pothosware/SoapySDR/wiki) with [`SoapySDRSink`](0.reference-manual.md#soapysdrsink) via [libSoapySDR](https://github.com/pothosware/SoapySDR)
* [HackRF One](https://greatscottgadgets.com/hackrf/) with [`HackRFSink`](0.reference-manual.md#hackrfsink) via [libhackrf](https://github.com/mossmann/hackrf)
* [USRP](https://www.ettus.com/) with [`UHDSink`](0.reference-manual.md#uhdsink) via [libuhd](https://github.com/EttusResearch/uhd)

* [BladeRF](https://www.nuand.com/) with [`BladeRFSink`](0.reference-manual.md#bladerfsink) via [libbladeRF](https://github.com/Nuand/bladeRF/tree/master/host/libraries/libbladeRF)

## Sound card SDR Sources and Sinks

Sound card SDRs, like the [SoftRock](http://fivedash.com/), source and sink
analog I/Q signals through sound card stereo channels. Transceiver "digimode"
interfaces, like the [SignaLink](http://www.tigertronics.com/), source and sink
demodulated audio signals through sound card mono channels.

### Sources

* [`PulseAudioSource`](0.reference-manual.md#pulseaudiosource) via [libpulse](https://freedesktop.org/software/pulseaudio/doxygen/)
* [`PortAudioSource`](0.reference-manual.md#portaudiosource) via [libportaudio](http://www.portaudio.com/)

### Sinks

* [`PulseAudioSink`](0.reference-manual.md#pulseaudiosink) via [libpulse](https://freedesktop.org/software/pulseaudio/doxygen/)
* [`PortAudioSink`](0.reference-manual.md#portaudiosink) via [libportaudio](http://www.portaudio.com/)

## File Sources and Sinks

File sources and sinks source and sink samples with ordinary files. They can
indirectly support SDR hardware by reading/writing a named pipe shared with an
external utility that interfaces with the SDR hardware.

### Sources

* [`IQFileSource`](0.reference-manual.md#iqfilesource) for binary I/Q files
* [`RealFileSource`](0.reference-manual.md#realfilesource) for binary real-valued files
* [`WAVFileSource`](0.reference-manual.md#wavfilesource) for WAV files

### Sinks

* [`IQFileSink`](0.reference-manual.md#iqfilesink) for binary I/Q files
* [`RealFileSink`](0.reference-manual.md#realfilesink) for binary real-valued files
* [`WAVFileSink`](0.reference-manual.md#wavfilesink) for WAV files

