/* {=================================================================
 *
 * rng.h
 * Random number generator (RNG) library for Lua [header file]
 * Luis Carvalho (lexcarvalho@gmail.com)
 * See Copyright Notice in numlua.h
 *
 * ==================================================================} */

#ifndef rng_h
#define rng_h

#include <lua.h>
#include "numlua.h"

/* Uniform deviates are generated by Mersenne Twister method,
 * algorithm mt19937 by Makoto Matsumoto and Takuji Nishimura.
 * Check mt.c for details. */

/* Struct to hold state vector and current position */
#define RNG_MAXSTATES (624)  /* _N_ in mt19937ar.c */
typedef struct {
  unsigned long v[RNG_MAXSTATES];  /* the array for the state vector */
  int i;  /* i==N+1 means v[N] is not initialized */
} nl_RNG;

#define RNG_SEED (5489UL)  /* default initial seed in mt199937ar.c */
void init_genrand(nl_RNG *o, unsigned long s);
void init_by_array(nl_RNG *o, unsigned long init_key[], int key_length);
unsigned long genrand_int32(nl_RNG *o);
long genrand_int31(nl_RNG *o);
double genrand_real1(nl_RNG *o);
double genrand_real2(nl_RNG *o);
double genrand_real3(nl_RNG *o);
double genrand_res53(nl_RNG *o); 

/* All other deviates are computed from an adapted ranlib.c from Netlib */
#define ranf(o) genrand_real3(o)
#define ignlgi(o) genrand_int31(o)
double genbet(nl_RNG *o,double aa,double bb);
double genchi(nl_RNG *o,double df);
double genexp(nl_RNG *o,double av);
double genf(nl_RNG *o,double dfn,double dfd);
double gengam(nl_RNG *o,double a,double r);
void genmul(nl_RNG *o,long n,double *p,long ncat,long *ix);
double gennch(nl_RNG *o,double df,double xnonc);
double gennf(nl_RNG *o,double dfn,double dfd,double xnonc);
double gennor(nl_RNG *o,double av,double sd);
void genprm(nl_RNG *o,long *iarray,int larray);
double genunf(nl_RNG *o,double low,double high);
long ignbin(nl_RNG *o,long n,double pp);
long ignnbn(nl_RNG *o,long n,double p);
long ignpoi(nl_RNG *o,double mu);
long ignuin(nl_RNG *o,long low,long high);

#endif
