# lua-language-server

![build](https://github.com/sumneko/lua-language-server/workflows/build/badge.svg)
![version](https://vsmarketplacebadge.apphb.com/version-short/sumneko.lua.svg)
![installs](https://vsmarketplacebadge.apphb.com/installs-short/sumneko.lua.svg)
![downloads](https://vsmarketplacebadge.apphb.com/downloads-short/sumneko.lua.svg)

## Install In VSCode
https://marketplace.visualstudio.com/items?itemName=sumneko.lua

![avatar](https://github.com/sumneko/vscode-lua/raw/master/images//Install%20In%20VSCode.gif)

## Change Log
https://github.com/sumneko/lua-language-server/blob/master/changelog.md

## Wiki
https://github.com/sumneko/lua-language-server/wiki

## Feature

- [x] Goto Definition
- [x] Find All References
- [x] Hover
- [x] Diagnostics
- [x] Rename
- [x] Auto Completion
- [x] IntelliSense
- [x] Signature Help
- [x] Document Symbols
- [x] Workspace Symbols
- [x] Syntax Check
- [x] Highlight
- [x] Code Action
- [x] EmmyLua Annotation
- [x] Multi Workspace
- [x] Semantic Tokens
- [x] Formatter

## Version

- [x] Lua 5.1
- [x] Lua 5.2
- [x] Lua 5.3
- [x] Lua 5.4
- [x] LuaJIT

If you find any mistakes, please [tell me][issues] or use [Pull Requests][@meta] to fix them directly.

如果你发现了任何错误，请[告诉我][issues]或使用[Pull Requests][@meta]来直接修复。

[issues]: https://github.com/sumneko/lua-language-server/issues
[@meta]: https://github.com/sumneko/lua-language-server/tree/master/meta/template

## Locale

- [x] en-us
- [x] zh-cn
- [x] zh-tw (thanks [AlexCai2019](https://github.com/AlexCai2019))
- [x] pt-br (thanks [Jeferson Ferreira](https://github.com/jefersonf))

Please [help me][en-US] improve the quality of `en-US`.

[en-US]: https://github.com/sumneko/lua-language-server/tree/master/locale/en-us

## Build
The extensions in the VSCode market already come with pre-compiled binary files, usually you don't need to compile them.

Other clients can first try to download and use [pre-compiled binary files](https://github.com/sumneko/lua-language-server/wiki/PreCompiled-Binaries).

If you need to compile by yourself, please refer to [here](https://github.com/sumneko/lua-language-server/wiki/Build-and-Run)

## Setting

* In VSCode: Just use the setting of VSCode.
* Standalone: See https://github.com/sumneko/lua-language-server/wiki/Setting

## Credit

* [bee.lua](https://github.com/actboy168/bee.lua)
* [luamake](https://github.com/actboy168/luamake)
* [LPegLabel](https://github.com/sqmedeiros/lpeglabel)
* [LuaParser](https://github.com/sumneko/LuaParser)
* [ScreenToGif](https://github.com/NickeManarin/ScreenToGif)
* [vscode-languageclient](https://github.com/microsoft/vscode-languageserver-node)
* [lua.tmbundle](https://github.com/textmate/lua.tmbundle)
* [EmmyLua](https://emmylua.github.io)
* [lua-glob](https://github.com/sumneko/lua-glob)
* [utility](https://github.com/sumneko/utility)
* [vscode-lua-doc](https://github.com/actboy168/vscode-lua-doc)
* [json.lua](https://github.com/actboy168/json.lua)
* [EmmyLuaCodeStyle](https://github.com/CppCXY/EmmyLuaCodeStyle)
* [inspect.lua](https://github.com/kikito/inspect.lua)

## Acknowledgement

* [actboy168](https://github.com/actboy168)
* [Dmitry Sannikov](https://github.com/dasannikov)
* [Jayden Charbonneau](https://github.com/Reshiram110)
* [Stjepan Bakrac](https://github.com/z16)
* [Peter Young](https://github.com/young40)
* [Li Xiaobin](https://github.com/Xiaobin0860)
* [Fedora7](https://github.com/Fedora7)
* [Allen Shaw](https://github.com/shuxiao9058)
* [Bartel](https://github.com/Letrab)
* [Ruin0x11](https://github.com/Ruin0x11)
* [uhziel](https://github.com/uhziel)
* [火凌之](https://github.com/PhoenixZeng)
* [CppCXY](https://github.com/CppCXY)
* [Ketho](https://github.com/Ketho)
* [Folke Lemaitre](https://github.com/folke)
* [Vikas Raj](https://github.com/numToStr)
* [kevinhwang91](https://github.com/kevinhwang91)
* [Cassolette](https://github.com/Cassolette)

## Telemetry

This language server collects usage data and sends it to the development team to help improve the extension. Read our [privacy policy](https://github.com/sumneko/lua-language-server/wiki/Privacy-Policy) to learn more and how to disable any telemetry.
