/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.es;

import java.util.Calendar;
import java.util.Locale;

class DateFilterHelper {
    DateFilterHelper() {
    }

    protected Calendar getCalendar() {
        return Calendar.getInstance(Locale.FRANCE);
    }

    protected int getDayOfWeek(String dayStr) {
        String day = dayStr.toLowerCase();
        if (day.equals("do") || day.equals("domingo")) {
            return 1;
        }
        if (day.equals("lu") || day.equals("lunes")) {
            return 2;
        }
        if (day.equals("ma") || day.equals("martes")) {
            return 3;
        }
        if (day.equals("mi") || day.equals("mi\u00e9rcoles")) {
            return 4;
        }
        if (day.equals("ju") || day.equals("jueves")) {
            return 5;
        }
        if (day.equals("vi") || day.equals("viernes")) {
            return 6;
        }
        if (day.equals("sa") || day.equals("s\u00e1bado")) {
            return 7;
        }
        throw new RuntimeException("Could not find day of week for '" + dayStr + "'");
    }

    protected String getDayOfWeek(Calendar date) {
        String englishDay = date.getDisplayName(7, 2, Locale.UK);
        if (englishDay.equals("Sunday")) {
            return "domingo";
        }
        if (englishDay.equals("Monday")) {
            return "lunes";
        }
        if (englishDay.equals("Tuesday")) {
            return "martes";
        }
        if (englishDay.equals("Wednesday")) {
            return "mi\u00e9rcoles";
        }
        if (englishDay.equals("Thursday")) {
            return "jueves";
        }
        if (englishDay.equals("Friday")) {
            return "viernes";
        }
        if (englishDay.equals("Saturday")) {
            return "s\u00e1bado";
        }
        return "";
    }

    protected int getMonth(String monthStr) {
        String mon = monthStr.toLowerCase();
        if (mon.startsWith("en")) {
            return 1;
        }
        if (mon.startsWith("fe")) {
            return 2;
        }
        if (mon.startsWith("mar") || mon.startsWith("mzo")) {
            return 3;
        }
        if (mon.startsWith("ab")) {
            return 4;
        }
        if (mon.startsWith("may") || mon.startsWith("my")) {
            return 5;
        }
        if (mon.startsWith("jun") || mon.equals("jn")) {
            return 6;
        }
        if (mon.startsWith("jul") || mon.equals("jl")) {
            return 7;
        }
        if (mon.startsWith("ag")) {
            return 8;
        }
        if (mon.startsWith("se") || mon.startsWith("sep")) {
            return 9;
        }
        if (mon.startsWith("oc")) {
            return 10;
        }
        if (mon.startsWith("no")) {
            return 11;
        }
        if (mon.startsWith("di")) {
            return 12;
        }
        throw new RuntimeException("Could not find month '" + monthStr + "'");
    }
}

