/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.classification.corpus;

import com.hankcs.hanlp.classification.collections.FrequencyMap;
import com.hankcs.hanlp.classification.corpus.AbstractDataSet;
import com.hankcs.hanlp.classification.corpus.Document;
import com.hankcs.hanlp.classification.corpus.IDataSet;
import com.hankcs.hanlp.classification.models.AbstractModel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MemoryDataSet
extends AbstractDataSet {
    List<Document> documentList = new LinkedList<Document>();
    boolean editMode;

    public MemoryDataSet() {
    }

    public MemoryDataSet(AbstractModel model) {
        super(model);
    }

    @Override
    public Document add(String category, String text) {
        if (this.editMode) {
            return null;
        }
        Document document = this.convert(category, text);
        this.documentList.add(document);
        return document;
    }

    @Override
    public int size() {
        return this.documentList.size();
    }

    @Override
    public void clear() {
        this.documentList.clear();
    }

    @Override
    public IDataSet shrink(int[] idMap) {
        Iterator<Document> iterator = this.iterator();
        while (iterator.hasNext()) {
            Document document = iterator.next();
            FrequencyMap<Integer> tfMap = new FrequencyMap<Integer>();
            for (Map.Entry entry : document.tfMap.entrySet()) {
                Integer feature = (Integer)entry.getKey();
                if (idMap[feature] == -1) continue;
                tfMap.put(idMap[feature], entry.getValue());
            }
            if (tfMap.size() == 0) {
                iterator.remove();
                continue;
            }
            document.tfMap = tfMap;
        }
        return this;
    }

    @Override
    public Iterator<Document> iterator() {
        return this.documentList.iterator();
    }
}

