/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.lspcli.tools;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bsplines.lspcli.tools.FileIo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J!\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J'\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u00122\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0002\u0010\u0013J-\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\f\u0018\u00010\u00152\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0002\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/bsplines/lspcli/tools/LspCliSettings;", "", "settingsFilePath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "jsonSettings", "Lcom/google/gson/JsonObject;", "getJsonSettings", "()Lcom/google/gson/JsonObject;", "getSettingsFilePath", "()Ljava/nio/file/Path;", "getValue", "Lcom/google/gson/JsonElement;", "keys", "", "", "([Ljava/lang/String;)Lcom/google/gson/JsonElement;", "getValueAsListOfString", "", "([Ljava/lang/String;)Ljava/util/List;", "getValueAsMap", "", "([Ljava/lang/String;)Ljava/util/Map;", "lspcli"})
public final class LspCliSettings {
    @Nullable
    private final Path settingsFilePath;
    @NotNull
    private final JsonObject jsonSettings;

    public LspCliSettings(@Nullable Path settingsFilePath) {
        JsonObject jsonObject;
        this.settingsFilePath = settingsFilePath;
        if (this.settingsFilePath != null) {
            JsonObject jsonObject2 = JsonParser.parseString((String)FileIo.INSTANCE.readFileWithException(this.settingsFilePath)).getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"{\n    JsonParser.parseSt\u2026lePath)).asJsonObject\n  }");
            jsonObject = jsonObject2;
        } else {
            jsonObject = new JsonObject();
        }
        this.jsonSettings = jsonObject;
    }

    public /* synthetic */ LspCliSettings(Path path, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            path = null;
        }
        this(path);
    }

    @Nullable
    public final Path getSettingsFilePath() {
        return this.settingsFilePath;
    }

    @NotNull
    public final JsonObject getJsonSettings() {
        return this.jsonSettings;
    }

    @Nullable
    public final JsonElement getValue(String ... keys) {
        Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
        JsonElement jsonElement = (JsonElement)this.jsonSettings;
        for (String key : keys) {
            JsonObject jsonObject;
            JsonObject jsonObject2 = jsonObject = jsonElement.isJsonObject() ? jsonElement.getAsJsonObject() : null;
            if (jsonObject2 == null ? false : jsonObject2.has(key)) {
                JsonElement jsonElement2 = jsonObject.get(key);
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement2, (String)"jsonObject.get(key)");
                jsonElement = jsonElement2;
                continue;
            }
            return null;
        }
        return jsonElement;
    }

    @Nullable
    public final List<String> getValueAsListOfString(String ... keys) {
        Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
        JsonElement jsonElement = this.getValue(Arrays.copyOf(keys, keys.length));
        if (jsonElement == null) {
            return null;
        }
        JsonElement jsonElement2 = jsonElement;
        ArrayList<String> list = new ArrayList<String>();
        for (Object e : jsonElement2.getAsJsonArray()) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"jsonElement.asJsonArray");
            JsonElement entryElement = (JsonElement)e;
            list.add(entryElement.getAsString());
        }
        return list;
    }

    @Nullable
    public final Map<String, JsonElement> getValueAsMap(String ... keys) {
        Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
        JsonElement jsonElement = this.getValue(Arrays.copyOf(keys, keys.length));
        if (jsonElement == null) {
            return null;
        }
        JsonElement jsonElement2 = jsonElement;
        HashMap map = new HashMap();
        for (Map.Entry entry : jsonElement2.getAsJsonObject().entrySet()) {
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"jsonElement.asJsonObject.entrySet()");
            String mapKey = (String)entry.getKey();
            JsonElement mapValueElement = (JsonElement)entry.getValue();
            Map map2 = map;
            Intrinsics.checkNotNullExpressionValue((Object)mapKey, (String)"mapKey");
            Intrinsics.checkNotNullExpressionValue((Object)mapValueElement, (String)"mapValueElement");
            map2.put(mapKey, mapValueElement);
        }
        return map;
    }

    public LspCliSettings() {
        this(null, 1, null);
    }
}

