/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.lspcli.client;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.bsplines.lspcli.client.LspCliLanguageClient;
import org.bsplines.lspcli.client.LspCliTextDocumentItem;
import org.bsplines.lspcli.tools.FileIo;
import org.bsplines.lspcli.tools.I18n;
import org.bsplines.lspcli.tools.Logging;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000b\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/bsplines/lspcli/client/Checker;", "", "languageClient", "Lorg/bsplines/lspcli/client/LspCliLanguageClient;", "hideCommands", "", "(Lorg/bsplines/lspcli/client/LspCliLanguageClient;Z)V", "getHideCommands", "()Z", "getLanguageClient", "()Lorg/bsplines/lspcli/client/LspCliLanguageClient;", "check", "", "path", "Ljava/nio/file/Path;", "paths", "", "checkDirectory", "checkFile", "languageId", "", "text", "Companion", "lspcli"})
public final class Checker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LspCliLanguageClient languageClient;
    private final boolean hideCommands;
    @NotNull
    private static final Regex TRAILING_WHITESPACE_REGEX = new Regex("[ \t\r\n]+$");
    private static final int STANDARD_INPUT_BUFFER_SIZE = 1024;
    private static final long WAIT_FOR_DIAGNOSTIC_MILLISECONDS = 50L;
    private static final int TAB_SIZE = 8;

    public Checker(@NotNull LspCliLanguageClient languageClient, boolean hideCommands) {
        Intrinsics.checkNotNullParameter((Object)languageClient, (String)"languageClient");
        this.languageClient = languageClient;
        this.hideCommands = hideCommands;
    }

    public /* synthetic */ Checker(LspCliLanguageClient lspCliLanguageClient, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(lspCliLanguageClient, bl);
    }

    @NotNull
    public final LspCliLanguageClient getLanguageClient() {
        return this.languageClient;
    }

    public final boolean getHideCommands() {
        return this.hideCommands;
    }

    public final int check(@NotNull List<? extends Path> paths) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        int numberOfMatches = 0;
        for (Path path : paths) {
            numberOfMatches += this.check(path);
        }
        return numberOfMatches;
    }

    public final int check(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String text = null;
        String codeLanguageId = null;
        if (Intrinsics.areEqual((Object)((Object)path).toString(), (Object)"-")) {
            int length;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = System.in.read(buffer)) != -1) {
                outputStream.write(buffer, 0, length);
            }
            String string = outputStream.toString(StandardCharsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"outputStream.toString(StandardCharsets.UTF_8)");
            text = string;
            codeLanguageId = "plaintext";
        } else {
            if (path.toFile().isDirectory()) {
                return this.checkDirectory(path);
            }
            text = FileIo.INSTANCE.readFileWithException(path);
            String string = FileIo.INSTANCE.getCodeLanguageIdFromPath(path);
            if (string == null) {
                string = "plaintext";
            }
            codeLanguageId = string;
        }
        return this.checkFile(path, codeLanguageId, text);
    }

    private final int checkDirectory(Path path) {
        int numberOfMatches = 0;
        for (Object t : Files.walk(path, new FileVisitOption[0]).collect(Collectors.toList())) {
            String curCodeLanguageId;
            Intrinsics.checkNotNullExpressionValue(t, (String)"Files.walk(path).collect(Collectors.toList())");
            Path childPath = (Path)t;
            if (!childPath.toFile().isFile() || (curCodeLanguageId = FileIo.INSTANCE.getCodeLanguageIdFromPath(childPath)) == null) continue;
            numberOfMatches += this.check(childPath);
        }
        return numberOfMatches;
    }

    private final int checkFile(Path path, String languageId, String text) {
        List<Diagnostic> curDiagnostics;
        String string = path.toUri().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path.toUri().toString()");
        String uri = string;
        LspCliTextDocumentItem document = new LspCliTextDocumentItem(uri, languageId, 1, text);
        Object[] objectArray = new Object[]{((Object)path).toString()};
        Logging.INSTANCE.getLogger().info(I18n.INSTANCE.format("checkingFile", objectArray));
        this.languageClient.getLanguageServer().getTextDocumentService().didOpen(new DidOpenTextDocumentParams((TextDocumentItem)document));
        objectArray = new Object[]{((Object)path).toString()};
        Logging.INSTANCE.getLogger().info(I18n.INSTANCE.format("waitingForDiagnosticsForFile", objectArray));
        List<Diagnostic> diagnostics = null;
        while (true) {
            if ((curDiagnostics = this.languageClient.getDiagnosticsMap().get(uri)) != null) break;
            Thread.sleep(50L);
        }
        diagnostics = curDiagnostics;
        TextDocumentIdentifier documentId = new TextDocumentIdentifier(uri);
        Checker $this$checkFile_u24lambda_u2d0 = this;
        boolean bl = false;
        int terminalWidth = AnsiConsole.getTerminalWidth();
        int terminalWidth2 = terminalWidth >= 2 ? terminalWidth : Integer.MAX_VALUE;
        for (Diagnostic diagnostic : diagnostics) {
            ArrayList<String> codeActionTitles = new ArrayList<String>();
            Object t = this.languageClient.getLanguageServer().getTextDocumentService().codeAction(new CodeActionParams(documentId, diagnostic.getRange(), new CodeActionContext(CollectionsKt.listOf((Object)diagnostic)))).get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"this.languageClient.lang\u2026tic))),\n          ).get()");
            List codeActionResult = (List)t;
            for (Either entry : codeActionResult) {
                Command command = (Command)entry.getLeft();
                CodeAction codeAction = (CodeAction)entry.getRight();
                if (command != null && !this.hideCommands) {
                    codeActionTitles.add(command.getTitle());
                    continue;
                }
                if (codeAction == null || codeAction.getCommand() != null && this.hideCommands) continue;
                codeActionTitles.add(codeAction.getTitle());
            }
            Checker.Companion.printDiagnostic(path, document, diagnostic, codeActionTitles, terminalWidth2);
        }
        return diagnostics.size();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J6\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u00192\u0006\u0010\u000f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/bsplines/lspcli/client/Checker$Companion;", "", "()V", "STANDARD_INPUT_BUFFER_SIZE", "", "TAB_SIZE", "TRAILING_WHITESPACE_REGEX", "Lkotlin/text/Regex;", "WAIT_FOR_DIAGNOSTIC_MILLISECONDS", "", "guessIndentationSize", "text", "", "lineStartPos", "fromPos", "terminalWidth", "printDiagnostic", "", "path", "Ljava/nio/file/Path;", "document", "Lorg/bsplines/lspcli/client/LspCliTextDocumentItem;", "diagnostic", "Lorg/eclipse/lsp4j/Diagnostic;", "codeActionTitles", "", "lspcli"})
    public static final class Companion {
        private Companion() {
        }

        private final void printDiagnostic(Path path, LspCliTextDocumentItem document, Diagnostic diagnostic, List<String> codeActionTitles, int terminalWidth) {
            String string;
            String string2;
            Ansi.Color color;
            String string3 = document.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"document.text");
            String text = string3;
            Position position = diagnostic.getRange().getStart();
            Intrinsics.checkNotNullExpressionValue((Object)position, (String)"diagnostic.range.start");
            Position fromPosition = position;
            Position position2 = diagnostic.getRange().getEnd();
            Intrinsics.checkNotNullExpressionValue((Object)position2, (String)"diagnostic.range.end");
            Position toPosition = position2;
            int fromPos = document.convertPosition(fromPosition);
            int toPos = document.convertPosition(toPosition);
            DiagnosticSeverity diagnosticSeverity = diagnostic.getSeverity();
            switch (diagnosticSeverity == null ? -1 : WhenMappings.$EnumSwitchMapping$0[diagnosticSeverity.ordinal()]) {
                case 1: {
                    color = Ansi.Color.RED;
                    break;
                }
                case 2: {
                    color = Ansi.Color.YELLOW;
                    break;
                }
                case 3: {
                    color = Ansi.Color.BLUE;
                    break;
                }
                case 4: {
                    color = Ansi.Color.BLUE;
                    break;
                }
                default: {
                    color = Ansi.Color.BLUE;
                }
            }
            Ansi.Color color2 = color;
            DiagnosticSeverity diagnosticSeverity2 = diagnostic.getSeverity();
            switch (diagnosticSeverity2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[diagnosticSeverity2.ordinal()]) {
                case 1: {
                    string2 = "error";
                    break;
                }
                case 2: {
                    string2 = "warning";
                    break;
                }
                case 3: {
                    string2 = "info";
                    break;
                }
                case 4: {
                    string2 = "hint";
                    break;
                }
                default: {
                    string2 = "info";
                }
            }
            String typeString = string2;
            Either either = diagnostic.getCode();
            if (either == null) {
                string = "";
            } else {
                Object object = either.get();
                if (object == null) {
                    string = "";
                } else {
                    string = object.toString();
                    if (string == null) {
                        string = "";
                    }
                }
            }
            String diagnosticCode = string;
            Ansi ansi = Ansi.ansi().bold().a(((Object)path).toString()).a(":").a(fromPosition.getLine() + 1).a(":").a(fromPosition.getCharacter() + 1).a(": ").fg(color2).a(typeString).a(":").reset().bold().a(" ").a(diagnostic.getMessage());
            Intrinsics.checkNotNullExpressionValue((Object)ansi, (String)"ansi().bold().a(path.toS\u2026 \").a(diagnostic.message)");
            Ansi ansi2 = ansi;
            if (((CharSequence)diagnosticCode).length() > 0) {
                ansi2.a(" [").a(diagnosticCode).a("]");
            }
            ansi2.reset();
            System.out.println(ansi2);
            int lineStartPos = document.convertPosition(new Position(fromPosition.getLine(), 0));
            int lineEndPos = document.convertPosition(new Position(fromPosition.getLine() + 1, 0));
            String string4 = text.substring(lineStartPos, lineEndPos);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String line = string4;
            Ansi ansi3 = Ansi.ansi();
            CharSequence charSequence = line;
            int n = 0;
            int n2 = fromPos - lineStartPos;
            String string5 = charSequence.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Ansi ansi4 = ansi3.a(string5).bold().fg(color2);
            charSequence = line;
            n = fromPos - lineStartPos;
            n2 = toPos - lineStartPos;
            string5 = charSequence.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Ansi ansi5 = ansi4.a(string5).reset();
            charSequence = line;
            n = toPos - lineStartPos;
            Object object = charSequence.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String).substring(startIndex)");
            charSequence = (CharSequence)object;
            Regex regex = TRAILING_WHITESPACE_REGEX;
            object = "";
            charSequence = ansi5.a(regex.replaceFirst(charSequence, (String)object));
            System.out.println(charSequence);
            int indentationSize = this.guessIndentationSize(text, lineStartPos, fromPos, terminalWidth);
            for (String codeActionTitle : codeActionTitles) {
                if (indentationSize + codeActionTitle.length() <= terminalWidth) continue;
                indentationSize = 0;
            }
            String indentation = StringsKt.repeat((CharSequence)" ", (int)indentationSize);
            for (String codeActionTitle : codeActionTitles) {
                Ansi ansi6 = Ansi.ansi().a(indentation).fg(Ansi.Color.GREEN).a(codeActionTitle).reset();
                System.out.println(ansi6);
            }
        }

        private final int guessIndentationSize(String text, int lineStartPos, int fromPos, int terminalWidth) {
            int indentationSize = 0;
            int n = lineStartPos;
            while (n < fromPos) {
                int pos;
                if (text.charAt(pos = n++) == '\t') {
                    indentationSize = (int)(Math.ceil(((double)indentationSize + 1.0) / (double)8) * (double)8);
                } else {
                    int n2 = indentationSize;
                    indentationSize = n2 + 1;
                }
                if (indentationSize < terminalWidth) continue;
                indentationSize = 0;
            }
            return indentationSize;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[DiagnosticSeverity.values().length];
                nArray[DiagnosticSeverity.Error.ordinal()] = 1;
                nArray[DiagnosticSeverity.Warning.ordinal()] = 2;
                nArray[DiagnosticSeverity.Information.ordinal()] = 3;
                nArray[DiagnosticSeverity.Hint.ordinal()] = 4;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

