/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.tools;

import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016J \u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/bsplines/ltexls/tools/TeeInputStream;", "Ljava/io/InputStream;", "inputStream", "teedOutputStream", "Ljava/io/OutputStream;", "(Ljava/io/InputStream;Ljava/io/OutputStream;)V", "getInputStream", "()Ljava/io/InputStream;", "getTeedOutputStream", "()Ljava/io/OutputStream;", "available", "", "close", "", "read", "bytes", "", "offset", "length", "readAllBytes", "readNBytes", "skip", "", "ltexls"})
public final class TeeInputStream
extends InputStream {
    @NotNull
    private final InputStream inputStream;
    @NotNull
    private final OutputStream teedOutputStream;

    public TeeInputStream(@NotNull InputStream inputStream, @NotNull OutputStream teedOutputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)teedOutputStream, (String)"teedOutputStream");
        this.inputStream = inputStream;
        this.teedOutputStream = teedOutputStream;
    }

    @NotNull
    public final InputStream getInputStream() {
        return this.inputStream;
    }

    @NotNull
    public final OutputStream getTeedOutputStream() {
        return this.teedOutputStream;
    }

    @Override
    public int read() {
        int b = this.inputStream.read();
        if (b != -1) {
            this.teedOutputStream.write(b);
        }
        return b;
    }

    @Override
    public int read(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        int length = this.inputStream.read(bytes);
        if (length != -1) {
            this.teedOutputStream.write(bytes);
        }
        return length;
    }

    @Override
    public int read(@NotNull byte[] bytes, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        int actualLength = this.inputStream.read(bytes, offset, length);
        if (actualLength != -1) {
            this.teedOutputStream.write(bytes, offset, actualLength);
        }
        return actualLength;
    }

    @Override
    @NotNull
    public byte[] readAllBytes() {
        byte[] byArray = this.inputStream.readAllBytes();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this.inputStream.readAllBytes()");
        byte[] bytes = byArray;
        this.teedOutputStream.write(bytes);
        return bytes;
    }

    @Override
    @NotNull
    public byte[] readNBytes(int length) {
        byte[] byArray = this.inputStream.readNBytes(length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this.inputStream.readNBytes(length)");
        byte[] bytes = byArray;
        this.teedOutputStream.write(bytes);
        return bytes;
    }

    @Override
    public int readNBytes(@NotNull byte[] bytes, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        int actualLength = this.inputStream.readNBytes(bytes, offset, length);
        if (actualLength != -1) {
            this.teedOutputStream.write(bytes, offset, actualLength);
        }
        return actualLength;
    }

    @Override
    public long skip(long length) {
        return this.inputStream.skip(length);
    }

    @Override
    public int available() {
        return this.inputStream.available();
    }

    @Override
    public void close() {
        this.inputStream.close();
        this.teedOutputStream.close();
    }
}

