/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.tools;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bsplines.ltexls.tools.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\tJ+\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0016\u0010\u000b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\f\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\rJ7\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\u0016\u0010\u000b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\f\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/bsplines/ltexls/tools/I18n;", "", "()V", "messages", "Ljava/util/ResourceBundle;", "format", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "key", "messageArguments", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "(Ljava/lang/String;Ljava/lang/Exception;[Ljava/lang/Object;)Ljava/lang/String;", "setDefaultLocale", "", "setLocale", "locale", "Ljava/util/Locale;", "log", "", "ltexls"})
public final class I18n {
    @NotNull
    public static final I18n INSTANCE = new I18n();
    @Nullable
    private static ResourceBundle messages;

    private I18n() {
    }

    public final void setDefaultLocale() {
        try {
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            this.setLocale(locale, false);
        }
        catch (MissingResourceException e) {
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            this.setLocale(locale, false);
        }
    }

    public final void setLocale(@NotNull Locale locale, boolean log) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        if (log) {
            Object[] objectArray = new Object[]{locale.getLanguage()};
            Logging.INSTANCE.getLOGGER().info(this.format("settingLocale", objectArray));
        }
        messages = ResourceBundle.getBundle("LtexLsMessagesBundle", locale);
    }

    public static /* synthetic */ void setLocale$default(I18n i18n, Locale locale, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        i18n.setLocale(locale, bl);
    }

    @NotNull
    public final String format(@NotNull String key, Object ... messageArguments) {
        int i;
        int n;
        String string;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)messageArguments, (String)"messageArguments");
        ResourceBundle messages = I18n.messages;
        if (messages != null && messages.containsKey(key)) {
            String string2 = messages.getString(key);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n      messages.getString(key)\n    }");
        } else {
            StringBuilder builder = new StringBuilder();
            if (messages == null) {
                builder.append("MessagesBundle is null while trying to get i18n message with key '");
                builder.append(key);
                builder.append("'");
            } else {
                builder.append("i18n message with key '");
                builder.append(key);
                builder.append("' not found");
            }
            builder.append(", message arguments: ");
            n = messageArguments.length;
            for (i = 0; i < n; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append("'{");
                builder.append(String.valueOf(i));
                builder.append("}'");
            }
            String string3 = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n      val builder = St\u2026 builder.toString()\n    }");
            string = string3;
        }
        String message = string;
        MessageFormat formatter = new MessageFormat("");
        formatter.applyPattern(StringsKt.replace$default((String)message, (String)"'", (String)"''", (boolean)false, (int)4, null));
        i = 0;
        n = messageArguments.length;
        String[] stringArray = new String[n];
        while (i < n) {
            int n2 = i++;
            stringArray[n2] = "";
        }
        String[] stringArguments = stringArray;
        for (Object object : messageArguments) {
            if (object == null || (object = object.toString()) == null) {
                object = "null";
            }
            stringArguments[i] = object;
        }
        String string4 = formatter.format(stringArguments);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"formatter.format(stringArguments)");
        return string4;
    }

    @NotNull
    public final String format(@NotNull String key, @NotNull Exception e, Object ... messageArguments) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)messageArguments, (String)"messageArguments");
        StringBuilder builder = new StringBuilder();
        Object[] objectArray = new Object[]{messageArguments};
        builder.append(this.format(key, objectArray));
        builder.append(". ");
        builder.append(this.format(e));
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    @NotNull
    public final String format(@NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        StringWriter writer = new StringWriter();
        writer.write(this.format("followingExceptionOccurred", new Object[0]));
        writer.write("\n");
        e.printStackTrace(new PrintWriter(writer));
        String string = writer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writer.toString()");
        return string;
    }

    static {
        INSTANCE.setDefaultLocale();
    }
}

