/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.server;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.text.StringEscapeUtils;
import org.bsplines.ltexls.languagetool.LanguageToolInterface;
import org.bsplines.ltexls.languagetool.LanguageToolRuleMatch;
import org.bsplines.ltexls.parsing.AnnotatedTextFragment;
import org.bsplines.ltexls.parsing.CodeAnnotatedTextBuilder;
import org.bsplines.ltexls.parsing.CodeFragment;
import org.bsplines.ltexls.parsing.CodeFragmentizer;
import org.bsplines.ltexls.parsing.plaintext.PlaintextAnnotatedTextBuilder;
import org.bsplines.ltexls.parsing.program.ProgramCommentRegexs;
import org.bsplines.ltexls.server.LtexTextDocumentItem;
import org.bsplines.ltexls.settings.HiddenFalsePositive;
import org.bsplines.ltexls.settings.Settings;
import org.bsplines.ltexls.settings.SettingsManager;
import org.bsplines.ltexls.tools.I18n;
import org.bsplines.ltexls.tools.Logging;
import org.bsplines.ltexls.tools.Tools;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.DetectedLanguage;
import org.languagetool.language.identifier.SimpleLanguageIdentifier;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.markup.TextPart;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 42\u00020\u0001:\u00014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f2\u0006\u0010\u0013\u001a\u00020\u00062\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0002J2\u0010\u0016\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u00172\u0006\u0010\u0013\u001a\u00020\u00062\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ'\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u000f2\u0006\u0010\u001c\u001a\u00020\u00102\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fJ-\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00180\u000f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002\u00a2\u0006\u0002\u0010\"J\"\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f2\u0006\u0010\u0013\u001a\u00020\u00062\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0016\u0010*\u001a\u00020%2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00180,H\u0002J&\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/2\f\u00101\u001a\b\u0012\u0004\u0012\u00020302H\u0002R\"\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/bsplines/ltexls/server/DocumentChecker;", "", "settingsManager", "Lorg/bsplines/ltexls/settings/SettingsManager;", "(Lorg/bsplines/ltexls/settings/SettingsManager;)V", "<set-?>", "Lorg/bsplines/ltexls/server/LtexTextDocumentItem;", "lastCheckedDocument", "getLastCheckedDocument", "()Lorg/bsplines/ltexls/server/LtexTextDocumentItem;", "getSettingsManager", "()Lorg/bsplines/ltexls/settings/SettingsManager;", "simpleLanguageIdentifier", "Lorg/languagetool/language/identifier/SimpleLanguageIdentifier;", "buildAnnotatedTextFragments", "", "Lorg/bsplines/ltexls/parsing/AnnotatedTextFragment;", "codeFragments", "Lorg/bsplines/ltexls/parsing/CodeFragment;", "document", "hasRange", "", "check", "Lkotlin/Pair;", "Lorg/bsplines/ltexls/languagetool/LanguageToolRuleMatch;", "range", "Lorg/eclipse/lsp4j/Range;", "checkAnnotatedTextFragment", "annotatedTextFragment", "rangeStartPos", "", "(Lorg/bsplines/ltexls/parsing/AnnotatedTextFragment;Ljava/lang/Integer;)Ljava/util/List;", "checkAnnotatedTextFragments", "annotatedTextFragments", "(Ljava/util/List;Ljava/lang/Integer;)Ljava/util/List;", "fragmentizeDocument", "logTextToBeChecked", "", "annotatedText", "Lorg/languagetool/markup/AnnotatedText;", "settings", "Lorg/bsplines/ltexls/settings/Settings;", "removeIgnoredMatches", "matches", "", "searchMatchInHiddenFalsePositives", "ruleId", "", "sentence", "hiddenFalsePositives", "", "Lorg/bsplines/ltexls/settings/HiddenFalsePositive;", "Companion", "ltexls"})
public final class DocumentChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SettingsManager settingsManager;
    @Nullable
    private LtexTextDocumentItem lastCheckedDocument;
    @NotNull
    private final SimpleLanguageIdentifier simpleLanguageIdentifier;
    private static final int MAX_LOG_TEXT_LENGTH = 100;

    public DocumentChecker(@NotNull SettingsManager settingsManager) {
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        this.settingsManager = settingsManager;
        this.simpleLanguageIdentifier = new SimpleLanguageIdentifier();
    }

    @NotNull
    public final SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    @Nullable
    public final LtexTextDocumentItem getLastCheckedDocument() {
        return this.lastCheckedDocument;
    }

    private final List<CodeFragment> fragmentizeDocument(LtexTextDocumentItem document, Range range) {
        String string = document.getLanguageId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"document.languageId");
        CodeFragmentizer codeFragmentizer = CodeFragmentizer.Companion.create(string);
        String string2 = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"document.text");
        String code = string2;
        if (range != null) {
            String string3 = code;
            Position position = range.getStart();
            Intrinsics.checkNotNullExpressionValue((Object)position, (String)"range.start");
            int n = document.convertPosition(position);
            Position position2 = range.getEnd();
            Intrinsics.checkNotNullExpressionValue((Object)position2, (String)"range.end");
            int n2 = document.convertPosition(position2);
            String string4 = string3.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            code = string4;
        }
        return codeFragmentizer.fragmentize(code, this.settingsManager.getSettings());
    }

    static /* synthetic */ List fragmentizeDocument$default(DocumentChecker documentChecker, LtexTextDocumentItem ltexTextDocumentItem, Range range, int n, Object object) {
        if ((n & 2) != 0) {
            range = null;
        }
        return documentChecker.fragmentizeDocument(ltexTextDocumentItem, range);
    }

    private final List<AnnotatedTextFragment> buildAnnotatedTextFragments(List<CodeFragment> codeFragments, LtexTextDocumentItem document, boolean hasRange) {
        ArrayList<AnnotatedTextFragment> annotatedTextFragments = new ArrayList<AnnotatedTextFragment>();
        for (CodeFragment codeFragment : codeFragments) {
            AnnotatedText curAnnotatedText;
            CodeAnnotatedTextBuilder builder = hasRange && ProgramCommentRegexs.Companion.isSupportedCodeLanguageId(codeFragment.getCodeLanguageId()) ? (CodeAnnotatedTextBuilder)new PlaintextAnnotatedTextBuilder(codeFragment.getCodeLanguageId()) : CodeAnnotatedTextBuilder.Companion.create(codeFragment.getCodeLanguageId());
            builder.setSettings(codeFragment.getSettings());
            builder.addCode(codeFragment.getCode());
            Intrinsics.checkNotNullExpressionValue((Object)builder.build(), (String)"builder.build()");
            annotatedTextFragments.add(new AnnotatedTextFragment(curAnnotatedText, codeFragment, document));
        }
        return annotatedTextFragments;
    }

    static /* synthetic */ List buildAnnotatedTextFragments$default(DocumentChecker documentChecker, List list, LtexTextDocumentItem ltexTextDocumentItem, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return documentChecker.buildAnnotatedTextFragments(list, ltexTextDocumentItem, bl);
    }

    private final List<LanguageToolRuleMatch> checkAnnotatedTextFragments(List<AnnotatedTextFragment> annotatedTextFragments, Integer rangeStartPos) {
        ArrayList matches2 = new ArrayList();
        for (AnnotatedTextFragment annotatedTextFragment : annotatedTextFragments) {
            matches2.addAll(this.checkAnnotatedTextFragment(annotatedTextFragment, rangeStartPos));
        }
        return matches2;
    }

    static /* synthetic */ List checkAnnotatedTextFragments$default(DocumentChecker documentChecker, List list, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return documentChecker.checkAnnotatedTextFragments(list, n);
    }

    private final List<LanguageToolRuleMatch> checkAnnotatedTextFragment(AnnotatedTextFragment annotatedTextFragment, Integer rangeStartPos) {
        String string;
        Object[] objectArray32;
        Object[] languageShortCode;
        CodeFragment codeFragment = annotatedTextFragment.getCodeFragment();
        Settings settings = codeFragment.getSettings();
        if (Intrinsics.areEqual((Object)settings.getLanguageShortCode(), (Object)"auto")) {
            Object[] objectArray;
            String string2 = this.simpleLanguageIdentifier.cleanAndShortenText(annotatedTextFragment.getAnnotatedText().getPlainText());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this.simpleLanguageIdent\u2026edText.plainText,\n      )");
            String cleanText = string2;
            DetectedLanguage detectedLanguage = this.simpleLanguageIdentifier.detectLanguage(cleanText, CollectionsKt.emptyList(), CollectionsKt.emptyList());
            DetectedLanguage detectedLanguage2 = detectedLanguage;
            if ((detectedLanguage2 != null && (detectedLanguage2 = detectedLanguage2.getDetectedLanguage()) != null ? detectedLanguage2.getShortCodeWithCountryAndVariant() : (objectArray = null)) == null) {
                objectArray = "en-US";
            }
            languageShortCode = objectArray;
            annotatedTextFragment.getCodeFragment().setLanguageShortCode((String)languageShortCode);
            settings = Settings.copy$default(settings, null, (String)languageShortCode, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0x3FFFFD, null);
        }
        this.settingsManager.setSettings(settings);
        LanguageToolInterface languageToolInterface = this.settingsManager.getLanguageToolInterface();
        if (languageToolInterface == null) {
            DocumentChecker $this$checkAnnotatedTextFragment_u24lambda_u240 = this;
            boolean objectArray32 = false;
            Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format("skippingTextCheckAsLanguageToolHasNotBeenInitialized", new Object[0]));
            return CollectionsKt.emptyList();
        }
        LanguageToolInterface languageToolInterface2 = languageToolInterface;
        String codeLanguageId = codeFragment.getCodeLanguageId();
        if (DocumentChecker.Companion.shouldSkipCheck(codeLanguageId, settings, rangeStartPos)) {
            languageShortCode = new Object[]{codeLanguageId};
            Logging.INSTANCE.getLOGGER().fine(I18n.INSTANCE.format("skippingTextCheckAsLtexHasBeenDisabled", languageShortCode));
            return CollectionsKt.emptyList();
        }
        if (settings.getDictionary().contains("BsPlInEs")) {
            languageToolInterface2.enableEasterEgg();
        }
        this.logTextToBeChecked(annotatedTextFragment.getAnnotatedText(), settings);
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        Instant beforeCheckingInstant = instant;
        try {
            objectArray32 = new ArrayList((Collection)languageToolInterface2.check(annotatedTextFragment));
        }
        catch (RuntimeException e) {
            Tools.INSTANCE.rethrowCancellationException(e);
            Logging.INSTANCE.getLOGGER().severe(I18n.INSTANCE.format("languageToolFailed", e, new Object[0]));
            return CollectionsKt.emptyList();
        }
        Object[] matches2 = objectArray32;
        if (Logging.INSTANCE.getLOGGER().isLoggable(Level.FINER)) {
            objectArray32 = new Object[]{Duration.between(beforeCheckingInstant, Instant.now()).toMillis()};
            Logging.INSTANCE.getLOGGER().finer(I18n.INSTANCE.format("checkingDone", objectArray32));
        }
        Logger logger = Logging.INSTANCE.getLOGGER();
        if (matches2.size() == 1) {
            string = I18n.INSTANCE.format("obtainedRuleMatch", new Object[0]);
        } else {
            objectArray32 = new Object[]{matches2.size()};
            string = I18n.INSTANCE.format("obtainedRuleMatches", objectArray32);
        }
        logger.fine(string);
        this.removeIgnoredMatches((List)matches2);
        ArrayList<LanguageToolRuleMatch> result = new ArrayList<LanguageToolRuleMatch>();
        for (Object e : matches2) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"matches");
            LanguageToolRuleMatch match = (LanguageToolRuleMatch)e;
            Integer n2 = rangeStartPos;
            n2 = rangeStartPos;
            result.add(LanguageToolRuleMatch.copy$default(match, null, null, match.getFromPos() + annotatedTextFragment.getCodeFragment().getFromPos() + (n != null ? n : 0), match.getToPos() + annotatedTextFragment.getCodeFragment().getFromPos() + (n2 != null ? n2 : 0), null, null, null, null, 243, null));
        }
        return result;
    }

    static /* synthetic */ List checkAnnotatedTextFragment$default(DocumentChecker documentChecker, AnnotatedTextFragment annotatedTextFragment, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return documentChecker.checkAnnotatedTextFragment(annotatedTextFragment, n);
    }

    private final void logTextToBeChecked(AnnotatedText annotatedText, Settings settings) {
        if (Logging.INSTANCE.getLOGGER().isLoggable(Level.FINER)) {
            Object[] objectArray = new Object[]{settings.getLanguageShortCode(), StringEscapeUtils.escapeJava((String)annotatedText.getPlainText()), ""};
            Logging.INSTANCE.getLOGGER().finer(I18n.INSTANCE.format("checkingText", objectArray));
            if (Logging.INSTANCE.getLOGGER().isLoggable(Level.FINEST)) {
                StringBuilder builder = new StringBuilder();
                for (Object e : annotatedText.getParts()) {
                    Intrinsics.checkNotNullExpressionValue(e, (String)"annotatedText.parts");
                    TextPart textPart = (TextPart)e;
                    builder.append(((CharSequence)builder).length() == 0 ? "annotatedTextParts = [" : ", ");
                    builder.append(textPart.getType().toString());
                    builder.append("(\"");
                    builder.append(StringEscapeUtils.escapeJava((String)textPart.getPart()));
                    builder.append("\")");
                }
                builder.append("]");
                Logging.INSTANCE.getLOGGER().finest(builder.toString());
            }
        } else if (Logging.INSTANCE.getLOGGER().isLoggable(Level.FINE)) {
            Object[] objectArray;
            String string = annotatedText.getPlainText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"annotatedText.plainText");
            String logText = string;
            String postfix = "";
            if (logText.length() > 100) {
                String string2 = logText.substring(0, 100);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                logText = string2;
                objectArray = new Object[]{100};
                postfix = I18n.INSTANCE.format("truncatedPostfix", objectArray);
            }
            objectArray = new Object[]{settings.getLanguageShortCode(), StringEscapeUtils.escapeJava((String)logText), postfix};
            Logging.INSTANCE.getLOGGER().fine(I18n.INSTANCE.format("checkingText", objectArray));
        }
    }

    private final boolean searchMatchInHiddenFalsePositives(String ruleId, String sentence, Set<HiddenFalsePositive> hiddenFalsePositives) {
        for (HiddenFalsePositive pair : hiddenFalsePositives) {
            if (!Intrinsics.areEqual((Object)pair.getRuleId(), (Object)ruleId) || Regex.find$default((Regex)pair.getSentenceRegex(), (CharSequence)sentence, (int)0, (int)2, null) == null) continue;
            return true;
        }
        return false;
    }

    private final void removeIgnoredMatches(List<LanguageToolRuleMatch> matches2) {
        Settings settings = this.settingsManager.getSettings();
        Set<HiddenFalsePositive> hiddenFalsePositives = settings.getHiddenFalsePositives();
        if (matches2.isEmpty() || hiddenFalsePositives.isEmpty()) {
            return;
        }
        ArrayList<LanguageToolRuleMatch> ignoreMatches = new ArrayList<LanguageToolRuleMatch>();
        for (LanguageToolRuleMatch match : matches2) {
            String sentence;
            String ruleId = match.getRuleId();
            String string2 = match.getSentence();
            string2 = sentence = string2 != null ? ((Object)StringsKt.trim((CharSequence)string2)).toString() : null;
            if (ruleId == null || sentence == null || !this.searchMatchInHiddenFalsePositives(ruleId, sentence, hiddenFalsePositives)) continue;
            Object[] objectArray = new Object[]{ruleId, sentence};
            Logging.INSTANCE.getLOGGER().fine(I18n.INSTANCE.format("hidingFalsePositive", objectArray));
            ignoreMatches.add(match);
        }
        if (!((Collection)ignoreMatches).isEmpty()) {
            String string;
            Logger logger = Logging.INSTANCE.getLOGGER();
            if (ignoreMatches.size() == 1) {
                string = I18n.INSTANCE.format("hidFalsePositive", new Object[0]);
            } else {
                Object[] objectArray = new Object[]{ignoreMatches.size()};
                string = I18n.INSTANCE.format("hidFalsePositives", objectArray);
            }
            logger.fine(string);
            for (Object e : ignoreMatches) {
                LanguageToolRuleMatch match;
                Intrinsics.checkNotNullExpressionValue(e, (String)"ignoreMatches");
                match = (LanguageToolRuleMatch)e;
                matches2.remove(match);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Pair<List<LanguageToolRuleMatch>, List<AnnotatedTextFragment>> check(@NotNull LtexTextDocumentItem document, @Nullable Range range) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)((Object)document), (String)"document");
        this.lastCheckedDocument = document;
        Settings originalSettings = this.settingsManager.getSettings();
        Range range2 = range;
        if (range2 != null) {
            Position position = range2.getStart();
            Intrinsics.checkNotNullExpressionValue((Object)position, (String)"range.start");
            n = document.convertPosition(position);
        } else {
            n = null;
        }
        Integer rangeStartPos = n;
        try {
            List<CodeFragment> codeFragments = this.fragmentizeDocument(document, range);
            List<AnnotatedTextFragment> annotatedTextFragments = this.buildAnnotatedTextFragments(codeFragments, document, range != null);
            List<LanguageToolRuleMatch> matches2 = this.checkAnnotatedTextFragments(annotatedTextFragments, rangeStartPos);
            Pair pair = new Pair(matches2, annotatedTextFragments);
            return pair;
        }
        finally {
            this.settingsManager.setSettings(originalSettings);
        }
    }

    public static /* synthetic */ Pair check$default(DocumentChecker documentChecker, LtexTextDocumentItem ltexTextDocumentItem, Range range, int n, Object object) {
        if ((n & 2) != 0) {
            range = null;
        }
        return documentChecker.check(ltexTextDocumentItem, range);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/bsplines/ltexls/server/DocumentChecker$Companion;", "", "()V", "MAX_LOG_TEXT_LENGTH", "", "shouldSkipCheck", "", "codeLanguageId", "", "settings", "Lorg/bsplines/ltexls/settings/Settings;", "rangeStartPos", "(Ljava/lang/String;Lorg/bsplines/ltexls/settings/Settings;Ljava/lang/Integer;)Z", "ltexls"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean shouldSkipCheck(String codeLanguageId, Settings settings, Integer rangeStartPos) {
            return rangeStartPos == null && !settings.getEnabled().contains(codeLanguageId) && !Intrinsics.areEqual((Object)codeLanguageId, (Object)"nop") && !Intrinsics.areEqual((Object)codeLanguageId, (Object)"plaintext");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

