/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.parsing.latex;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.bsplines.ltexls.parsing.latex.LatexCommandSignature;
import org.bsplines.ltexls.parsing.latex.LatexCommandSignatureMatch;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J(\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fH\u0002J\b\u0010\u0017\u001a\u0004\u0018\u00010\u0014J\u001c\u0010\u0018\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/bsplines/ltexls/parsing/latex/LatexCommandSignatureMatcher;", "", "commandSignatures", "", "Lorg/bsplines/ltexls/parsing/latex/LatexCommandSignature;", "escapeCommandPrefixes", "", "(Ljava/util/List;Z)V", "code", "", "commandRegex", "Lkotlin/text/Regex;", "getCommandSignatures", "()Ljava/util/List;", "ignoreCommandPrototypes", "", "matchResultIterator", "", "Lkotlin/text/MatchResult;", "findBestMatchingCommandSignature", "Lorg/bsplines/ltexls/parsing/latex/LatexCommandSignatureMatch;", "fromPos", "", "findNextMatch", "startMatching", "", "Companion", "ltexls"})
public final class LatexCommandSignatureMatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<LatexCommandSignature> commandSignatures;
    @NotNull
    private final Regex commandRegex;
    @Nullable
    private String code;
    @Nullable
    private Iterator<? extends MatchResult> matchResultIterator;
    @Nullable
    private Set<String> ignoreCommandPrototypes;
    @NotNull
    private static final Regex COMMENT_REGEX = new Regex("(?<!\\\\)(?:\\\\\\\\)*%");

    public LatexCommandSignatureMatcher(@NotNull List<? extends LatexCommandSignature> commandSignatures, boolean escapeCommandPrefixes) {
        Intrinsics.checkNotNullParameter(commandSignatures, (String)"commandSignatures");
        this.commandSignatures = commandSignatures;
        StringBuilder commandPatternStringBuilder = new StringBuilder();
        boolean first = true;
        for (LatexCommandSignature commandSignature : this.commandSignatures) {
            if (first) {
                first = false;
            } else {
                commandPatternStringBuilder.append("|");
            }
            String commandPrefix = commandSignature.getPrefix();
            commandPatternStringBuilder.append(escapeCommandPrefixes ? Regex.Companion.escape(commandPrefix) : commandPrefix);
        }
        String string = commandPatternStringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"commandPatternStringBuilder.toString()");
        this.commandRegex = new Regex(string);
    }

    public /* synthetic */ LatexCommandSignatureMatcher(List list, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(list, bl);
    }

    @NotNull
    public final List<LatexCommandSignature> getCommandSignatures() {
        return this.commandSignatures;
    }

    public final void startMatching(@NotNull String code, @NotNull Set<String> ignoreCommandPrototypes) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter(ignoreCommandPrototypes, (String)"ignoreCommandPrototypes");
        this.code = code;
        this.matchResultIterator = Regex.findAll$default((Regex)this.commandRegex, (CharSequence)code, (int)0, (int)2, null).iterator();
        this.ignoreCommandPrototypes = ignoreCommandPrototypes;
    }

    @Nullable
    public final LatexCommandSignatureMatch findNextMatch() {
        String code = this.code;
        Iterator<? extends MatchResult> matchResultIterator = this.matchResultIterator;
        Set<String> ignoreCommandPrototypes = this.ignoreCommandPrototypes;
        if (code == null || matchResultIterator == null || ignoreCommandPrototypes == null) {
            return null;
        }
        while (matchResultIterator.hasNext()) {
            LatexCommandSignatureMatch bestMatch;
            String precedingPartOfLine;
            MatchResult matchResult = matchResultIterator.next();
            int fromPos = matchResult.getRange().getFirst();
            int lineStartPos = StringsKt.lastIndexOf$default((CharSequence)code, (char)'\n', (int)fromPos, (boolean)false, (int)4, null) + 1;
            Intrinsics.checkNotNullExpressionValue((Object)code.substring(lineStartPos, fromPos), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            if (Regex.find$default((Regex)COMMENT_REGEX, (CharSequence)precedingPartOfLine, (int)0, (int)2, null) != null) continue;
            LatexCommandSignatureMatch latexCommandSignatureMatch = bestMatch = this.findBestMatchingCommandSignature(code, fromPos, ignoreCommandPrototypes);
            if (latexCommandSignatureMatch == null) continue;
            return latexCommandSignatureMatch;
        }
        return null;
    }

    private final LatexCommandSignatureMatch findBestMatchingCommandSignature(String code, int fromPos, Set<String> ignoreCommandPrototypes) {
        LatexCommandSignatureMatch bestMatch = null;
        for (LatexCommandSignature commandSignature : this.commandSignatures) {
            List<Pair<Integer, Integer>> arguments;
            if (ignoreCommandPrototypes.contains(commandSignature.getCommandPrototype()) || (arguments = commandSignature.matchArgumentsFromPosition(code, fromPos)) == null) continue;
            LatexCommandSignatureMatch match = new LatexCommandSignatureMatch(commandSignature, code, fromPos, arguments);
            if (bestMatch != null && match.getToPos() <= bestMatch.getToPos()) continue;
            bestMatch = match;
        }
        return bestMatch;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/bsplines/ltexls/parsing/latex/LatexCommandSignatureMatcher$Companion;", "", "()V", "COMMENT_REGEX", "Lkotlin/text/Regex;", "ltexls"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

