/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.parsing.html;

import java.io.StringReader;
import java.util.Collection;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.bsplines.ltexls.parsing.CodeAnnotatedTextBuilder;
import org.bsplines.ltexls.tools.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0003H\u0016J\u001c\u0010\u0010\u001a\u00020\u00002\b\u0010\u0011\u001a\u0004\u0018\u00010\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\u0013\u001a\u00020\u00002\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0003H\u0002R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/bsplines/ltexls/parsing/html/HtmlAnnotatedTextBuilder;", "Lorg/bsplines/ltexls/parsing/CodeAnnotatedTextBuilder;", "codeLanguageId", "", "(Ljava/lang/String;)V", "code", "elementNameStack", "Lkotlin/collections/ArrayDeque;", "lastSpace", "nextText", "pos", "", "xmlInputFactory", "Ljavax/xml/stream/XMLInputFactory;", "kotlin.jvm.PlatformType", "addCode", "addMarkup", "markup", "interpretAs", "addText", "text", "addTextWithWhitespace", "processXmlStreamReaderEvent", "", "xmlStreamReader", "Ljavax/xml/stream/XMLStreamReader;", "textAdded", "Companion", "ltexls"})
public final class HtmlAnnotatedTextBuilder
extends CodeAnnotatedTextBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final XMLInputFactory xmlInputFactory;
    @NotNull
    private String code;
    private int pos;
    @NotNull
    private final ArrayDeque<String> elementNameStack;
    @NotNull
    private String nextText;
    @NotNull
    private String lastSpace;
    @NotNull
    private static final Regex WHITESPACE_REGEX = new Regex("(?: |\r?\n)+");

    public HtmlAnnotatedTextBuilder(@NotNull String codeLanguageId) {
        Intrinsics.checkNotNullParameter((Object)codeLanguageId, (String)"codeLanguageId");
        super(codeLanguageId);
        this.xmlInputFactory = XMLInputFactory.newInstance();
        this.code = "";
        this.elementNameStack = new ArrayDeque((Collection)CollectionsKt.listOf((Object)"html"));
        this.nextText = "";
        this.lastSpace = "";
        this.xmlInputFactory.setProperty("com.ctc.wstx.minTextSegment", 1);
        this.xmlInputFactory.setProperty("com.ctc.wstx.treatCharRefsAsEnts", true);
        this.xmlInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", true);
        this.xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        this.xmlInputFactory.setProperty("javax.xml.stream.isValidating", false);
        this.xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
    }

    @NotNull
    public HtmlAnnotatedTextBuilder addText(@Nullable String text) {
        super.addText(text);
        String string = text;
        boolean bl = string != null ? ((CharSequence)string).length() > 0 : false;
        if (bl) {
            this.textAdded(text);
        }
        return this;
    }

    @NotNull
    public HtmlAnnotatedTextBuilder addMarkup(@Nullable String markup, @Nullable String interpretAs) {
        super.addMarkup(markup, interpretAs);
        String string = interpretAs;
        boolean bl = string != null ? ((CharSequence)string).length() > 0 : false;
        if (bl) {
            this.textAdded(interpretAs);
        }
        return this;
    }

    private final void textAdded(String text) {
        if (((CharSequence)text).length() == 0) {
            return;
        }
        char c = text.charAt(text.length() - 1);
        this.lastSpace = ((c == ' ' ? true : c == '\n') ? true : c == '\r') ? " " : "";
    }

    @Override
    @NotNull
    public CodeAnnotatedTextBuilder addCode(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this.code = code;
        this.pos = 0;
        try {
            XMLStreamReader xMLStreamReader = this.xmlInputFactory.createXMLStreamReader(new StringReader(code));
            Intrinsics.checkNotNullExpressionValue((Object)xMLStreamReader, (String)"this.xmlInputFactory.cre\u2026eader(StringReader(code))");
            XMLStreamReader xmlStreamReader = xMLStreamReader;
            while (xmlStreamReader.hasNext()) {
                this.processXmlStreamReaderEvent(xmlStreamReader);
            }
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
        if (this.pos < code.length()) {
            String string = code.substring(this.pos);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            this.addTextWithWhitespace(string);
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    private final void processXmlStreamReaderEvent(XMLStreamReader xmlStreamReader) {
        eventType = xmlStreamReader.next();
        oldPos = this.pos;
        this.pos = xmlStreamReader.getLocation().getCharacterOffset();
        v0 = this.code.substring(oldPos, this.pos);
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        skippedCode = v0;
        interpretAs = "";
        Logging.INSTANCE.getLOGGER().finest("Position " + this.pos + " (" + xmlStreamReader.getLocation().getLineNumber() + "," + xmlStreamReader.getLocation().getColumnNumber() + "): Event type = " + eventType + ", skippedCode = '" + skippedCode + "'");
        if (((CharSequence)this.nextText).length() > 0) {
            if (Intrinsics.areEqual((Object)StringsKt.replace$default((String)this.nextText, (String)"\r\n", (String)"\n", (boolean)false, (int)4, null), (Object)StringsKt.replace$default((String)skippedCode, (String)"\r\n", (String)"\n", (boolean)false, (int)4, null))) {
                this.addTextWithWhitespace(skippedCode);
            } else {
                this.addMarkup(skippedCode, this.nextText);
            }
            skippedCode = "";
            this.nextText = "";
        }
        switch (eventType) {
            case 1: {
                v1 = xmlStreamReader.getLocalName();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"xmlStreamReader.localName");
                elementName = v1;
                this.elementNameStack.addLast((Object)elementName);
                Logging.INSTANCE.getLOGGER().finest("START_ELEMENT: elementName = '" + xmlStreamReader.getLocalName() + "'");
                var7_8 = elementName;
                switch (var7_8.hashCode()) {
                    case 3273: {
                        if (!var7_8.equals("h1")) {
                            ** break;
                        }
                        ** GOTO lbl75
                    }
                    case 3274: {
                        if (!var7_8.equals("h2")) {
                            ** break;
                        }
                        ** GOTO lbl75
                    }
                    case 3275: {
                        if (!var7_8.equals("h3")) {
                            ** break;
                        }
                        ** GOTO lbl75
                    }
                    case 3029410: {
                        if (!var7_8.equals("body")) {
                            ** break;
                        }
                        ** GOTO lbl75
                    }
                    case 3276: {
                        if (!var7_8.equals("h4")) {
                            ** break;
                        }
                        ** GOTO lbl75
                    }
                    case 3277: {
                        if (!var7_8.equals("h5")) {
                            ** break;
                        }
                        ** GOTO lbl75
                    }
                    case 3278: {
                        if (!var7_8.equals("h6")) {
                            ** break;
                        }
                        ** GOTO lbl75
                    }
                    case 99473: {
                        if (!var7_8.equals("div")) {
                            ** break;
                        }
                        ** GOTO lbl75
                    }
                    case 112: {
                        if (!var7_8.equals("p")) {
                            ** break;
                        }
                        ** GOTO lbl75
                    }
                    case 3152: {
                        if (var7_8.equals("br")) break;
                        ** break;
                    }
                    case 3453: {
                        if (var7_8.equals("li")) break;
                        ** break;
                    }
                    case 110115790: {
                        if (!var7_8.equals("table")) {
                            ** break;
                        }
                        ** GOTO lbl75
                    }
                    case 3710: {
                        if (!var7_8.equals("tr")) ** break;
lbl75:
                        // 11 sources

                        interpretAs = (String)interpretAs + "\n\n";
                        ** break;
                    }
                }
                interpretAs = (String)interpretAs + "\n";
lbl78:
                // 16 sources

                break;
            }
            case 2: {
                Logging.INSTANCE.getLOGGER().finest("END_ELEMENT");
                this.elementNameStack.removeLastOrNull();
                break;
            }
            case 4: {
                elementName = this.elementNameStack.isEmpty() != false ? "" : (String)this.elementNameStack.last();
                v2 = xmlStreamReader.getText();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"xmlStreamReader.text");
                text = v2;
                Logging.INSTANCE.getLOGGER().finest("CHARACTERS: text = '" + text + "'");
                if (Intrinsics.areEqual((Object)elementName, (Object)"script") || Intrinsics.areEqual((Object)elementName, (Object)"style")) break;
                this.nextText = text;
                break;
            }
            case 9: {
                v3 = xmlStreamReader.getText();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"xmlStreamReader.text");
                this.nextText = v3;
                Logging.INSTANCE.getLOGGER().finest("ENTITY_REFERENCE: text = '" + this.nextText + "'");
            }
        }
        this.addMarkup(skippedCode, (String)interpretAs);
    }

    private final CodeAnnotatedTextBuilder addTextWithWhitespace(String text) {
        int pos = 0;
        for (MatchResult matchResult : Regex.findAll$default((Regex)WHITESPACE_REGEX, (CharSequence)text, (int)0, (int)2, null)) {
            if (matchResult.getRange().getFirst() > pos) {
                String string = text.substring(pos, matchResult.getRange().getFirst());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                this.addText(string);
            }
            String space = ((CharSequence)this.lastSpace).length() == 0 ? " " : "";
            this.addMarkup(matchResult.getValue(), space);
            pos = matchResult.getRange().getLast() + 1;
        }
        if (pos < text.length()) {
            String string = text.substring(pos);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            this.addText(string);
        }
        return this;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/bsplines/ltexls/parsing/html/HtmlAnnotatedTextBuilder$Companion;", "", "()V", "WHITESPACE_REGEX", "Lkotlin/text/Regex;", "ltexls"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

