/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.parsing;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bsplines.ltexls.parsing.CodeFragment;
import org.bsplines.ltexls.parsing.bibtex.BibtexFragmentizer;
import org.bsplines.ltexls.parsing.gitcommit.GitCommitFragmentizer;
import org.bsplines.ltexls.parsing.html.HtmlFragmentizer;
import org.bsplines.ltexls.parsing.latex.LatexFragmentizer;
import org.bsplines.ltexls.parsing.markdown.MarkdownFragmentizer;
import org.bsplines.ltexls.parsing.nop.NopFragmentizer;
import org.bsplines.ltexls.parsing.org.OrgFragmentizer;
import org.bsplines.ltexls.parsing.plaintext.PlaintextFragmentizer;
import org.bsplines.ltexls.parsing.program.ProgramCommentRegexs;
import org.bsplines.ltexls.parsing.program.ProgramFragmentizer;
import org.bsplines.ltexls.parsing.restructuredtext.RestructuredtextFragmentizer;
import org.bsplines.ltexls.settings.Settings;
import org.bsplines.ltexls.tools.I18n;
import org.bsplines.ltexls.tools.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH&J\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/bsplines/ltexls/parsing/CodeFragmentizer;", "", "codeLanguageId", "", "(Ljava/lang/String;)V", "getCodeLanguageId", "()Ljava/lang/String;", "fragmentize", "", "Lorg/bsplines/ltexls/parsing/CodeFragment;", "code", "originalSettings", "Lorg/bsplines/ltexls/settings/Settings;", "fragments", "Companion", "ltexls"})
public abstract class CodeFragmentizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String codeLanguageId;

    public CodeFragmentizer(@NotNull String codeLanguageId) {
        Intrinsics.checkNotNullParameter((Object)codeLanguageId, (String)"codeLanguageId");
        this.codeLanguageId = codeLanguageId;
    }

    @NotNull
    public final String getCodeLanguageId() {
        return this.codeLanguageId;
    }

    @NotNull
    public abstract List<CodeFragment> fragmentize(@NotNull String var1, @NotNull Settings var2);

    @NotNull
    public final List<CodeFragment> fragmentize(@NotNull List<CodeFragment> fragments) {
        Intrinsics.checkNotNullParameter(fragments, (String)"fragments");
        ArrayList<CodeFragment> newFragments = new ArrayList<CodeFragment>();
        for (CodeFragment oldFragment : fragments) {
            List<CodeFragment> curNewFragments = this.fragmentize(oldFragment.getCode(), oldFragment.getSettings());
            for (CodeFragment newFragment : curNewFragments) {
                newFragments.add(CodeFragment.copy$default(newFragment, null, null, newFragment.getFromPos() + oldFragment.getFromPos(), null, null, 27, null));
            }
        }
        return newFragments;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/bsplines/ltexls/parsing/CodeFragmentizer$Companion;", "", "()V", "create", "Lorg/bsplines/ltexls/parsing/CodeFragmentizer;", "codeLanguageId", "", "ltexls"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CodeFragmentizer create(@NotNull String codeLanguageId) {
            CodeFragmentizer codeFragmentizer;
            Intrinsics.checkNotNullParameter((Object)codeLanguageId, (String)"codeLanguageId");
            switch (codeLanguageId) {
                case "bib": 
                case "bibtex": {
                    codeFragmentizer = new BibtexFragmentizer(codeLanguageId);
                    break;
                }
                case "git-commit": 
                case "gitcommit": {
                    codeFragmentizer = new GitCommitFragmentizer(codeLanguageId);
                    break;
                }
                case "xhtml": 
                case "html": {
                    codeFragmentizer = new HtmlFragmentizer(codeLanguageId);
                    break;
                }
                case "rsweave": 
                case "context.tex": 
                case "tex": 
                case "latex": 
                case "context": 
                case "plaintex": {
                    codeFragmentizer = new LatexFragmentizer(codeLanguageId);
                    break;
                }
                case "quarto": 
                case "rmd": 
                case "markdown": {
                    codeFragmentizer = new MarkdownFragmentizer(codeLanguageId);
                    break;
                }
                case "nop": {
                    codeFragmentizer = new NopFragmentizer(codeLanguageId);
                    break;
                }
                case "org": {
                    codeFragmentizer = new OrgFragmentizer(codeLanguageId);
                    break;
                }
                case "plaintext": {
                    codeFragmentizer = new PlaintextFragmentizer(codeLanguageId);
                    break;
                }
                case "restructuredtext": {
                    codeFragmentizer = new RestructuredtextFragmentizer(codeLanguageId);
                    break;
                }
                default: {
                    if (ProgramCommentRegexs.Companion.isSupportedCodeLanguageId(codeLanguageId)) {
                        codeFragmentizer = new ProgramFragmentizer(codeLanguageId);
                        break;
                    }
                    Object[] objectArray = new Object[]{codeLanguageId};
                    Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format("unsupportedCodeLanguageId", objectArray));
                    codeFragmentizer = new PlaintextFragmentizer("plaintext");
                }
            }
            return codeFragmentizer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

