/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bsplines.ltexls.client.LtexLanguageClient;
import org.bsplines.ltexls.server.LtexLanguageServer;
import org.bsplines.ltexls.server.NonServerChecker;
import org.bsplines.ltexls.tools.I18n;
import org.bsplines.ltexls.tools.Logging;
import org.bsplines.ltexls.tools.TeeInputStream;
import org.bsplines.ltexls.tools.TeeOutputStream;
import org.bsplines.ltexls.tools.VersionProvider;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.launch.LSPLauncher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.fusesource.jansi.AnsiConsole;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;

@CommandLine.Command(name="ltex-ls", versionProvider=VersionProvider.class, mixinStandardHelpOptions=true, description={"LTeX LS - LTeX Language Server"}, showDefaultValues=true)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0003J\r\u0010\u0010\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0011J+\u0010\u0012\u001a\u0004\u0018\u00010\u00022\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\f\u001a\u00020\u0002H\u0002\u00a2\u0006\u0002\u0010\u0017J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0016H\u0002R\u0012\u0010\u0004\u001a\u00020\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u0004\u0018\u00010\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\u00028\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000e8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u0004\u0018\u00010\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/bsplines/ltexls/LtexLanguageServerLauncher;", "Ljava/util/concurrent/Callable;", "", "()V", "endless", "", "host", "", "inputDocuments", "", "Ljava/nio/file/Path;", "logFile", "port", "serverType", "Lorg/bsplines/ltexls/LtexLanguageServerLauncher$ServerType;", "settingsFile", "call", "()Ljava/lang/Integer;", "launchServer", "serverSocket", "Ljava/net/ServerSocket;", "logOutputStream", "Ljava/io/OutputStream;", "(Ljava/net/ServerSocket;Ljava/io/OutputStream;I)Ljava/lang/Integer;", "setupLogFileOutput", "Companion", "ServerType", "ltexls"})
public final class LtexLanguageServerLauncher
implements Callable<Integer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @CommandLine.Option(names={"--endless"}, description={"Keep server alive when client terminates."}, negatable=true)
    private boolean endless;
    @CommandLine.Option(names={"--input-documents"}, description={"Instead of running as server, check the documents at the paths <inputDocuments>, print the results to standard output, and exit. Directories are traversed recursively. If - is given, standard input will be checked as plain text."}, arity="1..*", hidden=true)
    @Nullable
    private List<? extends Path> inputDocuments;
    @CommandLine.Option(names={"--settings-file"}, description={"Use the settings stored in the JSON file <settingsFile> (only relevant when using --input-documents). The format is either nested JSON objects ({\"latex\": {\"commands\": ...}}) or a flattened JSON object ({\"latex.commands\": ...}). Setting names may be prefixed by a top level named `ltex` (e.g., {\"ltex.latex.commands\": ...} is accepted as well)."}, hidden=true)
    @Nullable
    private Path settingsFile;
    @CommandLine.Option(names={"--server-type"}, description={"Run the server as type <serverType>. Valid values: ${COMPLETION-CANDIDATES}"})
    @NotNull
    private ServerType serverType = ServerType.StandardStream;
    @CommandLine.Option(names={"--host"}, description={"Listen for TCP connections on host <host> (IP address or hostname; only relevant if server type is tcpSocket)."})
    @NotNull
    private String host = "localhost";
    @CommandLine.Option(names={"--port"}, description={"Listen for TCP connections on port <port> (only relevant if server type is tcpSocket). A value of 0 will have the system automatically determine a free port (the actual port number will be printed to the log)."})
    private int port;
    @CommandLine.Option(names={"--log-file"}, description={"Tee server/client communication and server log to <logFile>. $${PID} is replaced by the process ID of LTeX LS. The parent directory of <logFile> must exist. If <logFile> is an existing directory, then ltex-ls-$${PID}.log is used as filename."})
    @Nullable
    private Path logFile;
    private static final int EXIT_CODE_MATCHES_FOUND = 3;
    private static final int SERVER_SOCKET_BACKLOG_SIZE = 50;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Integer call() {
        ServerSocket serverSocket = null;
        OutputStream logOutputStream = null;
        try {
            int port;
            int n;
            if (this.logFile != null) {
                logOutputStream = this.setupLogFileOutput();
            }
            if (this.serverType == ServerType.TcpSocket) {
                serverSocket = new ServerSocket(this.port, 50, InetAddress.getByName(this.host));
                n = serverSocket.getLocalPort();
            } else {
                n = port = this.port;
            }
            do {
                Integer exitCode;
                if ((exitCode = this.launchServer(serverSocket, logOutputStream, port)) == null) continue;
                Integer n2 = exitCode;
                return n2;
            } while (this.endless);
        }
        finally {
            ServerSocket serverSocket2 = serverSocket;
            if (serverSocket2 != null) {
                serverSocket2.close();
            }
            if (logOutputStream != null) {
                logOutputStream.flush();
                logOutputStream.close();
            }
        }
        return 0;
    }

    private final OutputStream setupLogFileOutput() {
        Path path = this.logFile;
        File file = path != null ? path.toFile() : null;
        if (file == null) {
            return null;
        }
        File logFile = file;
        if (logFile.exists() && logFile.isDirectory()) {
            logFile = new File(logFile, "ltex-ls-${PID}.log");
        }
        String string = logFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"logFile.absolutePath");
        String logFileString = StringsKt.replace$default((String)string, (String)"${PID}", (String)String.valueOf(ProcessHandle.current().pid()), (boolean)false, (int)4, null);
        OutputStream logOutputStream = new FileOutputStream(logFileString, true);
        PrintStream printStream = System.err;
        Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"err");
        System.setErr(new PrintStream((OutputStream)new TeeOutputStream(printStream, logOutputStream), true, StandardCharsets.UTF_8));
        return logOutputStream;
    }

    private final Integer launchServer(ServerSocket serverSocket, OutputStream logOutputStream, int port) {
        List<? extends Path> inputDocuments = this.inputDocuments;
        if (inputDocuments != null) {
            int numberOfMatches;
            Logging.INSTANCE.getLOGGER().warning(I18n.INSTANCE.format("inputDocumentsAndSettingsFileAreDeprecated", new Object[0]));
            NonServerChecker nonServerChecker = new NonServerChecker();
            Path settingsFile = this.settingsFile;
            if (settingsFile != null) {
                nonServerChecker.loadSettings(settingsFile);
            }
            return (numberOfMatches = nonServerChecker.check(inputDocuments)) == 0 ? Integer.valueOf(0) : Integer.valueOf(3);
        }
        InputStream inputStream = System.in;
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"`in`");
        InputStream inputStream2 = inputStream;
        PrintStream printStream = System.out;
        Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"out");
        OutputStream outputStream = printStream;
        if (this.serverType == ServerType.TcpSocket) {
            if (serverSocket == null) {
                throw new NullPointerException("serverSocket");
            }
            Object[] numberOfMatches = new Object[]{port};
            Logging.INSTANCE.getLOGGER().info(I18n.INSTANCE.format("waitingForClientToConnectOnPort", numberOfMatches));
            Socket socket = serverSocket.accept();
            Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"serverSocket.accept()");
            Socket clientSocket = socket;
            Object[] objectArray = new Object[]{port};
            Logging.INSTANCE.getLOGGER().info(I18n.INSTANCE.format("connectedToClientOnPort", objectArray));
            InputStream inputStream3 = clientSocket.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream3, (String)"clientSocket.getInputStream()");
            inputStream2 = inputStream3;
            OutputStream outputStream2 = clientSocket.getOutputStream();
            Intrinsics.checkNotNullExpressionValue((Object)outputStream2, (String)"clientSocket.getOutputStream()");
            outputStream = outputStream2;
        }
        if (logOutputStream != null) {
            inputStream2 = new TeeInputStream(inputStream2, logOutputStream);
            outputStream = new TeeOutputStream(outputStream, logOutputStream);
        }
        Companion.launch(inputStream2, outputStream);
        return null;
    }

    @JvmStatic
    public static final void main(@NotNull String[] arguments) {
        Companion.main(arguments);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001b\u0010\f\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0007\u00a2\u0006\u0002\u0010\u0010J\u0019\u0010\u0011\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/bsplines/ltexls/LtexLanguageServerLauncher$Companion;", "", "()V", "EXIT_CODE_MATCHES_FOUND", "", "SERVER_SOCKET_BACKLOG_SIZE", "launch", "", "inputStream", "Ljava/io/InputStream;", "outputStream", "Ljava/io/OutputStream;", "main", "arguments", "", "", "([Ljava/lang/String;)V", "mainWithoutExit", "([Ljava/lang/String;)I", "ltexls"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] arguments) {
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            AnsiConsole.systemInstall();
            CommandLine commandLine = new CommandLine((Object)new LtexLanguageServerLauncher()).setCaseInsensitiveEnumValuesAllowed(true);
            int exitCode = commandLine.execute(Arrays.copyOf(arguments, arguments.length));
            if (exitCode != 0) {
                System.exit(exitCode);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
        }

        public final int mainWithoutExit(@NotNull String[] arguments) {
            int n;
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            LtexLanguageServerLauncher launcher = new LtexLanguageServerLauncher();
            CommandLine commandLine = new CommandLine((Object)launcher).setCaseInsensitiveEnumValuesAllowed(true);
            commandLine.parseArgs(Arrays.copyOf(arguments, arguments.length));
            if (commandLine.isUsageHelpRequested()) {
                commandLine.usage(commandLine.getOut());
                n = commandLine.getCommandSpec().exitCodeOnUsageHelp();
            } else if (commandLine.isVersionHelpRequested()) {
                commandLine.printVersionHelp(commandLine.getOut());
                n = commandLine.getCommandSpec().exitCodeOnVersionHelp();
            } else {
                int exitCode = launcher.call();
                commandLine.setExecutionResult((Object)exitCode);
                n = commandLine.getCommandSpec().exitCodeOnSuccess();
            }
            return n;
        }

        public final void launch(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            LtexLanguageServer server = new LtexLanguageServer();
            ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newSingleThreadScheduledExecutor()");
            ExecutorService executorService = scheduledExecutorService;
            LSPLauncher.Builder launcherBuilder = new LSPLauncher.Builder();
            launcherBuilder.setLocalService((Object)server);
            launcherBuilder.setRemoteInterface(LtexLanguageClient.class);
            launcherBuilder.setInput(inputStream);
            launcherBuilder.setOutput(outputStream);
            launcherBuilder.setExecutorService(executorService);
            Launcher launcher = launcherBuilder.create();
            Intrinsics.checkNotNullExpressionValue((Object)launcher, (String)"launcherBuilder.create()");
            Launcher launcher2 = launcher;
            Object object = launcher2.getRemoteProxy();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"launcher.remoteProxy");
            LanguageClient client = (LanguageClient)object;
            server.connect(client);
            Future future = launcher2.startListening();
            Intrinsics.checkNotNullExpressionValue((Object)future, (String)"launcher.startListening()");
            Future listener = future;
            executorService.shutdown();
            listener.get();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/bsplines/ltexls/LtexLanguageServerLauncher$ServerType;", "", "(Ljava/lang/String;I)V", "StandardStream", "TcpSocket", "ltexls"})
    public static final class ServerType
    extends Enum<ServerType> {
        public static final /* enum */ ServerType StandardStream = new ServerType();
        public static final /* enum */ ServerType TcpSocket = new ServerType();
        private static final /* synthetic */ ServerType[] $VALUES;

        public static ServerType[] values() {
            return (ServerType[])$VALUES.clone();
        }

        public static ServerType valueOf(String value) {
            return Enum.valueOf(ServerType.class, value);
        }

        static {
            $VALUES = serverTypeArray = new ServerType[]{ServerType.StandardStream, ServerType.TcpSocket};
        }
    }
}

