/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.ngrams.Probability;
import org.languagetool.tools.StringTools;

public class UpperCaseNgramRule
extends Rule {
    private static final int THRESHOLD = 50;
    private static final Set<String> relevantWords = new HashSet<String>(Arrays.asList("tage", "tagen", "Tage", "Tagen"));
    private final LanguageModel lm;

    public UpperCaseNgramRule(ResourceBundle messages, LanguageModel lm, Language lang) {
        super(messages);
        super.setCategory(Categories.CASING.getCategory(messages));
        this.lm = Objects.requireNonNull(lm);
        this.setDefaultTempOff();
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.addExamplePair(Example.wrong((String)"Die Suche endete nach 15 <marker>tagen</marker>."), Example.fixed((String)"Die Suche endete nach 15 <marker>Tagen</marker>."));
    }

    public final String getId() {
        return "DE_UPPER_CASE_NGRAM";
    }

    public String getDescription() {
        return "Pr\u00fcft W\u00f6rter, ob sie f\u00e4lschlich gro\u00df- oder f\u00e4lschlich kleingeschrieben sind";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = this.getSentenceWithImmunization(sentence).getTokensWithoutWhitespace();
        for (int i = 1; i < tokens.length; ++i) {
            RuleMatch match;
            String msg;
            double ratio;
            AnalyzedTokenReadings token = tokens[i];
            String tokenStr = token.getToken();
            if (i + 1 >= tokens.length || !relevantWords.contains(tokenStr) || StringTools.isAllUppercase((String)tokenStr)) continue;
            String ucToken = StringTools.uppercaseFirstChar((String)tokenStr);
            String lcToken = StringTools.lowercaseFirstChar((String)tokenStr);
            List<String> ucList = Arrays.asList(tokens[i - 1].getToken(), ucToken, tokens[i + 1].getToken());
            List<String> lcList = Arrays.asList(tokens[i - 1].getToken(), lcToken, tokens[i + 1].getToken());
            Probability ucProb = this.lm.getPseudoProbability(ucList);
            Probability lcProb = this.lm.getPseudoProbability(lcList);
            if (StringTools.startsWithUppercase((String)tokenStr)) {
                ratio = lcProb.getProb() / ucProb.getProb();
                if (!(ratio > 50.0)) continue;
                msg = "Meinten Sie das Verb '" + lcToken + "'? Nur Nomen und Eigennamen werden gro\u00dfgeschrieben.";
                match = new RuleMatch((Rule)this, sentence, token.getStartPos(), token.getEndPos(), msg);
                match.setSuggestedReplacement(lcToken);
                matches.add(match);
                continue;
            }
            ratio = ucProb.getProb() / lcProb.getProb();
            if (!(ratio > 50.0)) continue;
            msg = "Meinten Sie das Nomen '" + ucToken + "'? Nomen und Eigennamen werden gro\u00dfgeschrieben.";
            match = new RuleMatch((Rule)this, sentence, token.getStartPos(), token.getEndPos(), msg);
            match.setSuggestedReplacement(ucToken);
            matches.add(match);
        }
        return this.toRuleMatchArray(matches);
    }
}

