/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.tagging.de.GermanTagger;

public class InsertCommaFilter
extends RuleFilter {
    @Nullable
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens) {
        RuleMatch ruleMatch = new RuleMatch(match.getRule(), match.getSentence(), match.getFromPos(), match.getToPos(), match.getMessage(), match.getShortMessage());
        ArrayList<String> suggestions = new ArrayList<String>();
        for (String replacement : match.getSuggestedReplacements()) {
            String[] parts = replacement.split("\\s");
            try {
                List<AnalyzedTokenReadings> tags3;
                List<AnalyzedTokenReadings> tags2;
                List<AnalyzedTokenReadings> tags1;
                if (parts.length == 2) {
                    suggestions.add(parts[0] + ", " + parts[1]);
                    continue;
                }
                if (parts.length == 3) {
                    tags1 = InsertCommaFilter.getTag(0, parts);
                    tags2 = InsertCommaFilter.getTag(1, parts);
                    tags3 = InsertCommaFilter.getTag(2, parts);
                    if (this.hasTag(tags1, "VER:") && this.hasTag(tags2, "PRO:PER:")) {
                        suggestions.add(parts[0] + ", " + parts[1] + " " + parts[2]);
                        continue;
                    }
                    if (parts[0].matches("[Ss]agt?") && parts[1].matches("mal") && this.hasTag(tags3, "VER:")) {
                        suggestions.add(parts[0] + " " + parts[1] + ", " + parts[2]);
                        continue;
                    }
                    if (!this.hasTag(tags1, "VER:") || !this.hasTag(tags2, "ADV:") || !this.hasTag(tags3, "VER:")) continue;
                    suggestions.add(parts[0] + ", " + parts[1] + " " + parts[2]);
                    continue;
                }
                if (parts.length < 4 || parts.length > 7) continue;
                tags1 = InsertCommaFilter.getTag(0, parts);
                tags2 = InsertCommaFilter.getTag(1, parts);
                tags3 = InsertCommaFilter.getTag(2, parts);
                List<AnalyzedTokenReadings> tags4 = InsertCommaFilter.getTag(3, parts);
                String rest1 = String.join((CharSequence)" ", Arrays.asList(parts).subList(1, parts.length));
                if (patternTokenPos > 2 && (patternTokenPos != 3 || match.getSentence().getTokens().length < 1 || !match.getSentence().getTokens()[1].hasPosTagStartingWith("ADV:"))) continue;
                if (parts.length == 5 && this.hasTag(tags1, "VER:") && this.hasTag(tags2, "ART:") && this.hasTag(tags3, "SUB:") && this.hasTag(InsertCommaFilter.getTag(3, parts), "SUB:") && this.hasTag(InsertCommaFilter.getTag(4, parts), "VER:")) {
                    suggestions.add(parts[0] + " " + parts[1] + " " + parts[2] + " " + parts[3] + ",");
                    continue;
                }
                if (parts.length == 4 && patternTokens[0].hasPosTagStartingWith("VER:") && patternTokens[1].getToken().matches("der|die|das|seine|ihre|deine|unsere|meine|folgender|dieser")) {
                    suggestions.add(parts[0] + ", " + rest1);
                    continue;
                }
                if (this.hasTag(tags1, "VER:") && this.hasTag(tags2, "PRO:POS:") && this.hasTag(tags3, "SUB:")) {
                    suggestions.add(parts[0] + ", " + rest1);
                    continue;
                }
                if (this.hasTag(tags1, "VER:") && this.hasTag(tags2, "PRO:PER:") && this.hasTag(tags3, "ADV:INR")) {
                    String rest2 = String.join((CharSequence)" ", Arrays.asList(parts).subList(2, parts.length));
                    suggestions.add(parts[0] + " " + parts[1] + ", " + rest2);
                    continue;
                }
                if (this.hasTag(tags1, "VER:") && this.hasTag(tags2, "PRO:POS:") && this.hasTag(tags3, "ADJ:")) {
                    suggestions.add(parts[0] + ", " + rest1);
                    continue;
                }
                if (parts[0].matches("denke|dachte|glaube|sch\u00e4tze|vermute|behaupte") && this.hasTag(tags2, "PRO:DEM:") && this.hasTag(tags3, "SUB:")) {
                    suggestions.add(parts[0] + ", " + rest1);
                    continue;
                }
                if (patternTokenPos != 1 || !parts[1].matches("bei|f\u00fcr|mit") || !parts[2].matches("[Di]ir|[Dd]ich|[Ee]uer|[Ee]uch") || !this.hasTag(tags4, "VER:")) continue;
                suggestions.add(parts[0] + ", " + rest1);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ruleMatch.setSuggestedReplacements(suggestions);
        ruleMatch.setType(match.getType());
        return ruleMatch;
    }

    private static List<AnalyzedTokenReadings> getTag(int i, String[] parts) throws IOException {
        return GermanTagger.INSTANCE.tag(Collections.singletonList(parts[i]));
    }

    private boolean hasTag(List<AnalyzedTokenReadings> tags, String tagStart) {
        return tags.stream().anyMatch(k -> k.hasPosTagStartingWith(tagStart));
    }
}

