%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  This file is part of Logtalk <https://logtalk.org/>
%  Copyright 1998-2020 Paulo Moura <pmoura@logtalk.org>
%
%  Licensed under the Apache License, Version 2.0 (the "License");
%  you may not use this file except in compliance with the License.
%  You may obtain a copy of the License at
%
%      http://www.apache.org/licenses/LICENSE-2.0
%
%  Unless required by applicable law or agreed to in writing, software
%  distributed under the License is distributed on an "AS IS" BASIS,
%  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%  See the License for the specific language governing permissions and
%  limitations under the License.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


:- object(tests,
	extends(lgtunit)).

	:- info([
		version is 1:0:0,
		author is 'Paulo Moura',
		date is 2012-11-28,
		comment is 'Unit tests for the dynamic/0 built-in directive.'
	]).

	:- (dynamic).

	test(dynamic_0_1) :-
		this(This),
		object_property(This, (dynamic)).

	test(dynamic_0_2) :-
		this(This),
		\+ object_property(This, static).

	% all predicates in a dynamic entity are implicitly dynamic

	:- private(p/0).

	test(dynamic_0_3) :-
		predicate_property(p, private),
		predicate_property(p, (dynamic)).

:- end_object.
