________________________________________________________________________

This file is part of Logtalk <https://logtalk.org/>  
Copyright 1998-2018 Paulo Moura <pmoura@logtalk.org>

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
________________________________________________________________________


Sublime Text is a text editor for Windows, Mac OS X, and Linux.
It's available from:

	http://www.sublimetext.com/

Sublime Text supports TextMate syntax files and TextMate snippets. See the
`../textmate` folder and the Sublime Text documentation for more information.

For basic installation, copy the following files to the Sublime Text Packages
directory, which is operating-system specific:

Mac OS X:
	~/Library/Application Support/Sublime Text 3/Packages/Logtalk/
Linux:
	~/.config/sublime-text-3/Packages/Logtalk
Windows:
	%APPDATA%\Sublime Text 3\Packages\Logtalk

Create the `Logtalk` subdirectory if it doesn't exist. The files to be
copied are:

1. File `Logtalk.sublime-syntax` (this file is generated by converting the
`../textmate2/Logtalk.tmbundle/Syntaxes/Logtalk.plist` file; if you're using
an old version of Sublime Text that doesn't support the new `.sublime-syntax`
format, copy instead the TextMate file renamed to `Logtalk.tmLanguage`).

2. All files in the `../textmate2/Logtalk.tmbundle/Snippets` directory

3. File `logtalk.sublime-completions`

4. File `Logtalk.sublime-build` (edit it to change the used integration
script)

Create a `Sublime Text 3/Packages/SublimeREPL/config/Logtalk` subdirectory
if it doesn't exist and copy the following two files there:

	Default.sublime-commands
	Main.sublime-menu

The build and REPL support are experimental and currently not available on
Windows. It requires that you first run the `logtalk_backend_select` shell
script to set your default backend compiler. In alternative, edit the
`Logtalk.sublime-build` and `Main.sublime-menu` files and change the names
of the integration scripts.

For code navigation, install ctags Logtalk support (see the `../ctags` folder)
and the Sublime Text `ctags` package. On Mac OS X, you may also need to install
the `Fix Mac Path` package in order to use a recent `ctags` version (that you
can install using e.g. Homebrew or MacPorts).

Logtalk source files (including the library entities and the programming
examples) are formatted using tabs (the recommended setting is a tab width
equivalent to 4 spaces); you may set the tab width on the editor preference
panel.

The `Logtalk.sublime-syntax` file is generated from the TextMate 2 syntax file
using the Sublime syntax convertor available from:

https://github.com/aziz/SublimeSyntaxConvertor

