________________________________________________________________________

This file is part of Logtalk <https://logtalk.org/>  
Copyright 1998-2018 Paulo Moura <pmoura@logtalk.org>

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
________________________________________________________________________


About
-----

Redis client library. Supports GNU Prolog, Qu-Prolog, SICStus Prolog,
SWI-Prolog, and XSB. Support for ECLiPSe is also included but requires
a fix for an ECLiPSe bug that is expected in a forthcoming version of
this Prolog system.

For general information on Redis, including a list of the available
commands, visit:

	https://redis.io


API documentation
-----------------

Open the [../docs/index.html](../docs/index.html) file in a web browser
and choose the library index.


Loading
-------

To load this library, load the `redis_loader.lgt` utility file:

	| ?- logtalk_load(library(redis_loader)).


Know issues
-----------

Recent version of macOS seem to disable the mapping of `localhost` to
`127.0.0.1`. This issue may prevent running this library unit tests
and the `redis::connect/1` from working. This can be fixed either by
editing the `/etc/hosts file or by using in alternative the predicate
`redis::connect/3` with `'127.0.0.1'` as fist argument.
