%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  
%  This file is part of Logtalk <http://logtalk.org/>
%  
%  Logtalk is free software. You can redistribute it and/or modify it under
%  the terms of the FSF GNU General Public License 3  (plus some additional
%  terms per section 7).        Consult the `LICENSE.txt` file for details.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


:- object(tests,
	extends(lgtunit)).

	:- info([
		version is 1.1,
		author is 'Paulo Moura',
		date is 2015/04/05,
		comment is 'Unit tests for the ISO Prolog standard (<<)/1 built-in function.'
	]).

	% tests from the ISO/IEC 13211-1:1995(E) standard, section 9.4.2.4

	succeeds(iso_bitwise_left_shift_2_01) :-
		{X is '<<'(16, 2)},
		X == 64.

	succeeds(iso_bitwise_left_shift_2_02) :-
		{X is '<<'(19, 2)},
		X == 76.

	succeeds(iso_bitwise_left_shift_2_03) :-
		% assumes two's complement representation for negative integers
		{X is '<<'(-16, 2)},
		X == -64.

	throws(iso_bitwise_left_shift_1_04, error(instantiation_error,_)) :-
		% try to delay the error to runtime
		variable(N),
		{_X is '<<'(77, N)}.

	throws(iso_bitwise_left_shift_2_05, error(type_error(evaluable,foo/0),_)) :-
		% example fixed in ISO/IEC 13211-1:1995/Cor.1:2007
		% try to delay the error to runtime
		foo(0, Foo),
		{_X is '<<'(Foo, 2)}.

	throws(iso_bitwise_left_shift_2_06, error(type_error(integer,1.0),_)) :-
		{_X is '<<'(1.0, 2)}.

	% tests from the Logtalk portability work

	throws(lgt_bitwise_left_shift_2_07, error(type_error(integer,2.0),_)) :-
		{_X is '<<'(1, 2.0)}.

	throws(lgt_bitwise_left_shift_1_08, error(instantiation_error,_)) :-
		% try to delay the error to runtime
		variable(N),
		{_X is '<<'(N, 77)}.

	throws(lgt_bitwise_left_shift_2_09, error(type_error(evaluable,foo/0),_)) :-
		% try to delay the error to runtime
		foo(0, Foo),
		{_X is '<<'(2, Foo)}.

	throws(lgt_bitwise_left_shift_2_10, error(type_error(evaluable,foo/1),_)) :-
		% try to delay the error to runtime
		foo(1, Foo),
		{_X is '<<'(Foo, 2)}.

	throws(lgt_bitwise_left_shift_2_11, error(type_error(evaluable,foo/1),_)) :-
		% try to delay the error to runtime
		foo(1, Foo),
		{_X is '<<'(2, Foo)}.

	throws(lgt_bitwise_left_shift_2_12, error(type_error(evaluable,foo/2),_)) :-
		% try to delay the error to runtime
		foo(2, Foo),
		{_X is '<<'(Foo, 2)}.

	throws(lgt_bitwise_left_shift_2_13, error(type_error(evaluable,foo/2),_)) :-
		% try to delay the error to runtime
		foo(2, Foo),
		{_X is '<<'(2, Foo)}.

	variable(_).

	foo(0, foo).
	foo(1, foo(1)).
	foo(2, foo(1,2)).

:- end_object.
