________________________________________________________________________

This file is part of Logtalk <http://logtalk.org/>  

Logtalk is free software. You can redistribute it and/or modify it under
the terms of the FSF GNU General Public License 3  (plus some additional
terms per section 7).        Consult the `LICENSE.txt` file for details.
________________________________________________________________________


To load this example and for sample queries, please see the `SCRIPT.txt`
file.

This is a very simple example of using the new, experimental `encoding/1`
directive, which is fully based on the directive with the same name found 
on recent development releases of SWI-Prolog and YAP. Currently, this 
example requires Logtalk to be run with the latest versions of the YAP, 
SWI-Prolog, SICStus Prolog, CxProlog, Lean Prolog, or K-Prolog compilers.

The following encodings are used in the source file:

- `asian.lgt`     - UTF-16 (with a BOM)
- `babel.lgt`     - UTF-8 (with a BOM)
- `latin.lgt`     - ISO-8859-1 (Latin 1)
- `mythology.lgt` - UTF-32 (with a BOM)

As of the release date of this Logtalk version, only SICStus Prolog and 
CxProlog support UTF-32 encodings. Attempting to compile the `mythology.lgt` 
source file with either YAP or SWI-Prolog results in a misleading syntax 
error.

JIProlog and Lean Prolog default encoding is UTF-8. Therefore, only the
`babel.lgt` file can be used with these systems.

K-Prolog 6.0.x supports US-ASCII, UTF-8, EUC-JP, and Shift_JIS encodings. 
Thus, only the `babel.lgt` file can be used with this compiler.

Be sure to use a text editor that supports these encodings when opening 
these files. In addition, you may need to configure your text editor to 
open the source file using the declared encoding. Be sure to use a font 
that supports Unicode characters (both for your text editor and for the 
shell running your Prolog compiler interpreter).

See the documentation of the Logtalk `encoding/1` directive for its possible 
arguments. The Prolog and XML files generated by the Logtalk compiler use 
the same encoding as the compiled source files.
