________________________________________________________________________

This file is part of Logtalk <http://logtalk.org/>  
Copyright (c) 1998-2015 Paulo Moura <pmoura@logtalk.org>

Notes on supported backend Prolog compilers  
Last updated on January 4, 2015

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.

Additional licensing terms apply per Section 7 of the GNU General
Public License 3. Consult the `LICENSE.txt` file for details.
________________________________________________________________________


This file contains some notes about the adapter files provided. The folder
`unsupported` contains adapter files for Prolog compilers that are not yet
or no longer officially supported.

If you improve or correct some of these files, or write new ones for other
Prolog compilers, please send me a copy. It is simply not feasible to 
individually test Logtalk under all possible combinations of compatible
Prolog versions and operating-system versions.

As a general rule, always try to use the latest version of your Prolog 
compiler of choice. For Prolog compilers with long release cycles, this 
may require use of development versions. Most Prolog compilers are moving 
towards better compatibility with de facto and official standards and thus
improved Logtalk compatibility.

For details on how to integrate Logtalk with specific Prolog compilers,
see the files in the `integration` directory of the Logtalk distribution.

The adapter files may include hacked definitions for official and de-facto
Prolog standard built-in predicates. These definitions aim only to fulfill
the requirements of the Logtalk compiler and runtime and are not intended
as a full replacement for missing functionality.

The adapter files define shorthands to often used Logtalk built-in
predicates such as `logtalk_load/1` and `logtalk_make/1`:

* `{*}`  
	shorthand for `logtalk_make(all)`;
	reloads all modified Logtalk source files since last loaded
* `{!}`  
	shorthand for `logtalk_make(clean)`;
	deletes (cuts) all intermediate files generated by the compilation of Logtalk source files
* `{File}`  
	shorthand for `logtalk_load(File)`;
	compiles and loads a single Logtalk source file (using default flags)
* `{File1, File2, ...}`  
	shorthand for `logtalk_load([File1, File2, ...])`;
	compiles and loads several Logtalk source files (using default flags)

Note, however, that these shorthands, which should only be used for
iterative development at the top-level interpreter, are not part of
the Logtalk language specification and can be commented out in case
of conflict with backend Prolog compiler features or third-party
libraries.


Optional features support per backend Prolog compiler
-----------------------------------------------------

Some Logtalk features are optional and require compatible support for specific
(and sometimes not yet standard) features by the backend Prolog compilers. The
following table summarizes the availability of these features:

|  Compiler        |    Tabling    |  Coinduction  |    Unicode    |    Threads    |  
| :--------------: | :-----------: | :-----------: | :-----------: | :-----------: |  
|  B-Prolog        |      yes      |       no      |       no      |       no      |  
|  CxProlog        |       no      |      yes      |      yes      |       no      |  
|  ECLiPSe         |       no      |      yes      |       no      |       no      |  
|  GNU Prolog      |       no      |       no      |       no      |       no      |  
|  Lean Prolog     |       no      |       no      |      yes      |       no      |  
|  Qu-Prolog       |       no      |       no      |       no      |       no      |  
|  Quintus Prolog  |       no      |       no      |       no      |       no      |  
|  SICStus Prolog  |       no      |      yes      |      yes      |       no      |  
|  SWI-Prolog      |       no      |      yes      |      yes      |      yes      |  
|  XSB             |      yes      |       no      |       no      |      yes      |  
|  YAP             |      yes      |      yes      |      yes      |      yes      |  

A value of "yes" means at least partial support (but some limitations may
be present). A value of "no" just means that the backend Prolog compiler
doesn't provide a *compatible* implementation of the required features.


template adapter file
---------------------

	template.pl

If a adapter file for your favorite Prolog is not available, use this 
file as a template for writing one. For each predicate in the file, 
check if it is built-in in your Prolog, available in a library, or if 
you can write a better definition.


B-Prolog 7.8 and later versions
-------------------------------

	b.pl

For B-Prolog 7.8 and later versions. Note that this adapter file
redefines the B-Prolog `::/2` finite-domain built-in predicate
(you may use the alternative `in/2` built-in predicate instead).

Some of the B-Prolog built-in predicates (e.g. `set_to_list/2` or `(@=)/2`) 
are not core predicates and can be redefined by the user. The predicate 
`predicate_property/2` does not return the property `built_in` for these 
predicates. The solution is to encapsulate calls to these predicates 
within objects and categories using the Logtalk `{}/1` control construct.

You may need to increase the sizes of the code areas on the integration
scripts if you run into out-of-memory errors with complex applications.

Matching clauses and action rules are currently not supported.

On Windows, the environment variable `BPDIR` must be defined and pointing
to the B-Prolog installation directory for the installer to detect it.


CxProlog 0.97.7 or later versions
---------------------------------

	cx.pl

Developed and tested with the help of the CxProlog author, Artur Miguel Dias.

Due to the long release cycle of CxProlog, you may need to use its development
version if the recommended version is not yet available as a stable release.


ECLiPSe 6.1#143 or later versions
---------------------------------

	eclipse.pl

There is a clash between Logtalk and ECLiPSe regarding the `::/2` operator.
You may still use the `::/2` operator defined on the ECLiPSe constraint 
solver libraries by using explicit module qualification by writing 
`{library:(Var::Domain)}` (replace `library` by the actual library name; 
the `{}/1` control construct allows you to bypass the Logtalk compiler).

ECLiPSe defines an alias `in_set_range/2` for `::/2` that can be used to
avoid conflicts with Logtalk `::/2` message sending operator.

Adopted from a adapter file written and tested with help of Taner Bilgic 
for Logtalk 1.x.

With this Prolog compiler, avoid reloading Logtalk source files defining
dynamic predicates. Due to the semantics of the ECLiPSe built-in predicate
`compile/1`, new clauses for dynamic predicates are appended to the old ones
instead of replacing them.

The Logtalk flag `prolog_compiler` is not usable due to lack of ECLiPSe
built-in predicates for separate compilation and loading. To generate
`.eco` files when compiling Logtalk source files, set the Logtalk `clean`
flag to `off` and add the option `output:eco` to the Logtalk `prolog_loader`
flag.


GNU Prolog 1.4.2 and later versions
-----------------------------------

	gnu.pl

GNU Prolog supports the ISO Prolog standard. No problems expected.

You can generate a new Prolog top level that embeds Logtalk by following
the steps (exemplified for POSIX systems):

	$ gplgt
	...
	| ?- logtalk_compile([
			core(expanding),
			core(monitoring),
			core(forwarding),
			core(user),
			core(logtalk),
			core(core_messages)],
			[scratch_directory('$HOME/collect')]).

	$ cp $LOGTALKHOME/adapters/gnu.pl $HOME/collect/gnu.pl
	$ cp $LOGTALKHOME/paths/paths.pl $HOME/collect/paths.pl
	$ cp $LOGTALKHOME/core/core.pl $HOME/collect/core.pl

Edit the `$HOME/collect/core.pl` file and add the line `:- built_in.` to
the top. Then:

	$ cd $HOME/collect
	$ gplc -o logtalk gnu.pl paths.pl expanding_lgt.pl monitoring_lgt.pl forwarding_lgt.pl user_lgt.pl logtalk_lgt.pl core_messages_lgt.pl core.pl

Note that the order of the files when calling `gplc` is important. Finally,
move the new executable to a directory in your system PATH. For example:

	$ mv logtalk /usr/local/bin/

This way, every time you want to work with Logtalk you will just need 
to type:

	$ logtalk


Lean Prolog 3.8.8 and later versions
------------------------------------

	lean.pl

Experimental. Lean Prolog lacks compliance with both official and de facto
standards. Notably, it lacks support for stream aliases, for the `0'Char`
notation, for escape sequences in atoms, and its limited parser often
requires atoms to be quoted and/or write between ()'s. Moreover, due to
Lean Prolog limitation of compiling more than one file per session, the
compilation of Logtalk source files generates intermediate Prolog files
that are consulted (i.e. interpreted) instead of being compiled, severely
hurting performance. Thus, practical use requires embedding Logtalk and the
Logtalk application in Lean Prolog by including all necessary files in a
single file than can then be compiled. For example, you can collect all
Logtalk core files in a single file by following the steps (exemplified
for POSIX systems):

	$ lplgt
	...
	| ?- logtalk_compile([
			core(expanding),
			core(monitoring),
			core(forwarding),
			core(user),
			core(logtalk),
			core(core_messages)],
			[scratch_directory('$HOME/collect')]).

	$ cp $LOGTALKHOME/adapters/lean.pl $HOME/collect/lean.pl
	$ cp $LOGTALKHOME/paths/paths.pl $HOME/collect/paths.pl
	$ cp $LOGTALKHOME/core/core.pl $HOME/collect/core.pl

	$ cd $HOME/collect
	$ cat $(ls -t *.pl) > logtalk_core.pl


Qu-Prolog 9.0 and later versions
--------------------------------

	qp.pl

Know issues in Qu-Prolog 9.0: (1) this version doesn't support static
multifile predicates. This limitation may be fixed in later versions;
(2) a bug in the Windows version of Qu-Prolog in the expansion of file
paths containing environment variables prevents using it with Logtalk
in this operating-system.

Written and tested with the help of Peter Robinson.


Quintus Prolog 3.3~3.5
----------------------

	quintus.pl

Experimental. Quintus Prolog is still maintained but (apparently) no
longer developed and thus it lacks compliance with current official and
de facto standards. Notably, the `open/4` and `read_term/2-3` built-in
predicates use a different argument order and there are also significant
differences in arithmetic functions support. This adapter file copes with
some of these issues using the dialect-level goal-expansion mechanism.

The original version of this adapter file was written and tested with help
of a friend of mine, Paulo Urbano, for a previous version. Adopted for the
current release using version 3.5 for Windows for testing.


SICStus Prolog 4.1.0 and later versions
---------------------------------------

	sicstus.pl

Adapter file for SICStus Prolog. Use of the latest SICStus Prolog version
is recommended due to improved standards compliance. No problems expected.
Please report any problem found (with a solution if possible).


SWI-Prolog 6.6.0 and later versions
-----------------------------------

	swi.pl
	swihooks.pl

No problems expected. Please report any problem found (with a solution 
if possible).

To improve the integration between Logtalk and SWI-Prolog, the file
`swihooks.pl` allows loading of Logtalk source files using SWI-Prolog
`load_files/2` and `consult/1` predicates and adds support for the `edit/1`
and `make/0` predicates, the XPCE profiler, and the XPCE graphical tracer.
Note, however, that in the case of syntax errors in a Logtalk source file,
the `make/0` predicate will not detect the fixed file as no intermediate
Prolog file was generated in the first loading attempt (use instead the
`logtalk_make/0-1` predicates in this case).

The adapter file may set the `iso` SWI-Prolog flag to `true`. This setting
may improve compatibility of Logtalk code across different back-end 
Prolog compilers buy may also cause compatibility problems with some 
SWI-Prolog libraries. Comment out the corresponding `set_prolog_flag/2` 
directive if necessary.

For using XPCE from Logtalk, see the `xpce` example in the Logtalk
distribution.

With multi-threading support turned on, you may get an harmless message
when halting the system regarding threads that wouldn't die: you can 
suppress the message on POSIX systems by using `% swilgt 2> /dev/null`.

The definition of the predicate `{}/1` at the end of the adapter files
conflicts with e.g. the `clpq` and `clpr` SWI-Prolog constraint libraries.
The `{}/1` predicate is used in Logtalk as a shortcut to the `logtalk_load/1`
and  `logtalk_make/1` built-in predicates. Comment out the definition in the
adapter file if necessary. Note that Logtalk also defines a `{}/1` control
construct but this is only used within objects and categories.

Logtalk doesn't rely on the SWI-Prolog auto-loading mechanism for library
predicates. Calls of these predicates within objects and categories must
be explicitly qualified or implicit qualified by listing the predicates
in `use_module/2` directives). You may also set the Logtalk `portability`,
and `unknown_predicates` compiler flags to `warning` in order to detect
unqualified calls to library predicates. All the module libraries should
be loaded prior to compilation of object and categories containing calls
to the library predicates.

MacOS X users of the `SWI-Prolog.app` application, must add the definitions
for the `LOGTALKHOME` and `LOGTALKUSER` environment variables to their
`~/.plrc` init file (as Mac OS X GUI applications *don't* inherit environment
variable values):

	:- setenv('LOGTALKHOME', ...).
	:- setenv('LOGTALKUSER', ...).

To load Logtalk when using the `SWI-Prolog.app` application, you can use
the goal:

	?- ['$LOGTALKHOME/integration/logtalk_swi.pl'].

In alternative, if you want to be able to use Logtalk using both the shell
integration script and the GUI application, you can also add to the `.plrc`
init file the lines:

	:- if((current_prolog_flag(home,HOME), sub_atom(HOME,_,_,0,'SWI-Prolog.app/Contents/swipl'))).
		:- ['$LOGTALKHOME/integration/logtalk_swi.pl'].
	:- endif.

The Logtalk flag `prolog_compiler` is not usable due to lack of SWI-Prolog
built-in predicates for separate compilation and loading. To generate
`.qlf` files when compiling Logtalk source files, set the Logtalk `clean`
flag to `off` and add the option `qcompile(auto)` to the Logtalk flag
`prolog_loader`.

To use the SWI-Prolog graphical tracer for debugging Logtalk source code,
see the `settings-sample.lgt` file for the necessary settings. Note that
those settings result in large intermediate Prolog files as in addition
to the information collected for Logtalk own reflection features, all file
terms are decorated with additional source file location information for
integration with the SWI-Prolog own development tools.


XSB 3.5.0 and later versions
--------------------------

	xsb.pl

XSB generates intermediate files (with a `.xwam` extension) when compiling
Prolog source files (thus including the Logtalk core files). Thus, you
must either install Logtalk on on a location where you have write access
or perform the first run of the integration scripts from a user with the
required privileges (e.g. using `sudo` on POSIX systems or choosing `Run as
administrator` on Windows systems).

Due to the relative long release cycle of XSB, you may need to use its
development version if the recommended version is not yet available as
a stable release.

A know issue in XSB 3.5.0 is that this version doesn't support static
multifile predicates. This limitation may be fixed in later versions.

The definition of the `as` operator used in Logtalk when declaring predicate
(or non-terminal) aliases conflicts with the definition of this operator in
XSB due to the use of a different priority. XSB uses this operator within
`table/1` directives to represent tabling options. In practice there's only
a conflict when, in the same `table/1` directive, more than one predicate is
declared as tabled and/or when more than one tabling option is specified.
This cases are not common, however. The workaround is to use parenthesis
around the predicates and/or the tabling options.

To generate `.xwam` files from Logtalk source files, set the `prolog_compiler`
flag to the list of options that will be passed to the XSB `compile/2` built-in
predicate and use either the built-in predicates `logtalk_compile/1-2` or the
built-in predicates `logtalk_load/1-2` with the `clean` flag turned off.


YAP 6.3.4 and later versions
----------------------------

	yap.pl
	yaphooks.pl

The adapter file may set the flag `language` to `iso`, but that is only
recommended and should not be needed to run Logtalk as some of the YAP
libraries may not be compatible with this flag setting. Comment out the
corresponding `set_prolog_flag/2` directive if necessary.

The `yaphooks.pl` file defines YAP hook predicates for improving the
integration between Logtalk and YAP.

Note that YAP can be compiled with or without support for features like
tabling or threads.
