/*
 * Decompiled with CFR 0.152.
 */
package it.cnr.imaa.essi.lablib.gui.checkboxtree.examples;

import it.cnr.imaa.essi.lablib.gui.checkboxtree.CheckboxTree;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingEvent;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingListener;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingModel;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CheckboxTreeApplet
extends JApplet {
    private void createGUI() {
        final CheckboxTree tree = new CheckboxTree();
        tree.getSelectionModel().setSelectionMode(4);
        JPanel eventsPanel = new JPanel();
        TitledBorder eventsBorder = BorderFactory.createTitledBorder("Events");
        eventsPanel.setBorder(eventsBorder);
        final JTextArea textArea = new JTextArea(7, 20);
        textArea.setLineWrap(true);
        JScrollPane textPane = new JScrollPane(textArea);
        tree.addTreeCheckingListener(new TreeCheckingListener(){

            public void valueChanged(TreeCheckingEvent e) {
                textArea.append("Checking event source: " + e.getPath().getLastPathComponent() + "\n");
            }
        });
        eventsPanel.add(textPane);
        JPanel modesPanel = new JPanel(new GridLayout(0, 1));
        TitledBorder border = BorderFactory.createTitledBorder("Checking Mode");
        modesPanel.setBorder(border);
        ButtonGroup group = new ButtonGroup();
        AbstractButton aRadioButton = null;
        final TreeCheckingModel.CheckingMode[] modes = new TreeCheckingModel.CheckingMode[]{TreeCheckingModel.CheckingMode.SIMPLE, TreeCheckingModel.CheckingMode.PROPAGATE, TreeCheckingModel.CheckingMode.PROPAGATE_PRESERVING_UNCHECK, TreeCheckingModel.CheckingMode.PROPAGATE_PRESERVING_CHECK};
        int n = modes.length;
        for (int i = 0; i < n; ++i) {
            final int g = i;
            ActionListener modeListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    tree.getCheckingModel().clearChecking();
                    tree.getCheckingModel().setCheckingMode(modes[g]);
                }
            };
            aRadioButton = new JRadioButton(modes[i].toString());
            modesPanel.add(aRadioButton);
            group.add(aRadioButton);
            aRadioButton.addActionListener(modeListener);
        }
        aRadioButton.setSelected(true);
        tree.getCheckingModel().setCheckingMode(TreeCheckingModel.CheckingMode.PROPAGATE_PRESERVING_CHECK);
        JPanel commandsPanel = new JPanel(new GridLayout(0, 1));
        TitledBorder commandsBorder = BorderFactory.createTitledBorder("Actions");
        commandsPanel.setBorder(commandsBorder);
        JButton actionButton = new JButton("Expand all");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                tree.expandAll();
            }
        };
        actionButton.addActionListener(actionListener);
        commandsPanel.add(actionButton);
        JButton clearButton = new JButton("Clear checking");
        ActionListener clearListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                tree.clearChecking();
            }
        };
        clearButton.addActionListener(clearListener);
        commandsPanel.add(clearButton);
        JButton addButton = new JButton("Add child");
        ActionListener addListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreePath selected = tree.getSelectionPath();
                if (selected != null) {
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode)selected.getLastPathComponent();
                    DefaultMutableTreeNode child = new DefaultMutableTreeNode("child " + (parent.getChildCount() + 1));
                    parent.add(child);
                    DefaultTreeModel dtm = (DefaultTreeModel)tree.getModel();
                    dtm.nodesWereInserted(parent, new int[]{parent.getIndex(child)});
                    tree.expandPath(selected);
                }
            }
        };
        addButton.addActionListener(addListener);
        commandsPanel.add(addButton);
        JButton removeButton = new JButton("Remove selected node");
        ActionListener removeListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultMutableTreeNode child;
                DefaultMutableTreeNode parent;
                TreePath selected = tree.getSelectionPath();
                if (selected != null && (parent = (DefaultMutableTreeNode)(child = (DefaultMutableTreeNode)selected.getLastPathComponent()).getParent()) != null) {
                    int index = parent.getIndex(child);
                    child.removeFromParent();
                    DefaultTreeModel dtm = (DefaultTreeModel)tree.getModel();
                    dtm.nodesWereRemoved(parent, new int[]{index}, new TreeNode[]{child});
                }
            }
        };
        removeButton.addActionListener(removeListener);
        commandsPanel.add(removeButton);
        JPanel rightPanel = new JPanel(new GridLayout(0, 1));
        rightPanel.add(modesPanel);
        rightPanel.add(commandsPanel);
        rightPanel.add(eventsPanel);
        JSplitPane mainPanel = new JSplitPane(1);
        mainPanel.add(new JScrollPane(tree));
        mainPanel.add(rightPanel);
        mainPanel.setSize(640, 480);
        mainPanel.setDividerLocation(0.55);
        mainPanel.setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().add(mainPanel);
        this.setSize(640, 480);
    }

    public void init() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    CheckboxTreeApplet.this.createGUI();
                }
            });
        }
        catch (Exception e) {
            System.err.println("createGUI didn't successfully complete");
        }
    }
}

