/**
 * This file is part of logisim-evolution.
 *
 * Logisim-evolution is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 *
 * Logisim-evolution is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along 
 * with logisim-evolution. If not, see <http://www.gnu.org/licenses/>.
 *
 * Original code by Carl Burch (http://www.cburch.com), 2011.
 * Subsequent modifications by:
 *   + College of the Holy Cross
 *     http://www.holycross.edu
 *   + Haute École Spécialisée Bernoise/Berner Fachhochschule
 *     http://www.bfh.ch
 *   + Haute École du paysage, d'ingénierie et d'architecture de Genève
 *     http://hepia.hesge.ch/
 *   + Haute École d'Ingénierie et de Gestion du Canton de Vaud
 *     http://www.heig-vd.ch/
 */

package com.cburch.logisim.gui.icons;

import java.awt.Color;
import java.awt.Graphics2D;

import com.cburch.logisim.prefs.AppPreferences;

public class RunIcon extends AbstractIcon {

  @Override
  protected void paintIcon(Graphics2D g2) {
    g2.setColor(Color.GREEN.darker());
    g2.fillOval(AppPreferences.getScaled(2), AppPreferences.getScaled(2), AppPreferences.getScaled(13), AppPreferences.getScaled(13));
    int[] xpos = new int[] {AppPreferences.getScaled(6),AppPreferences.getScaled(11),AppPreferences.getScaled(6)};
    int[] ypos = new int[] {AppPreferences.getScaled(5),AppPreferences.getScaled(8),AppPreferences.getScaled(11)};
    g2.setColor(Color.WHITE);
    g2.fillPolygon(xpos, ypos, 3);
  }

}
