/**
 * Copyright (c) 2007-2012, Timothy Stack
 *
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * * Neither the name of Timothy Stack nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ''AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>

#include <string>
#include <vector>

#include "line_buffer.hh"

using namespace std;

int main(int argc, char *argv[])
{
    int retval = EXIT_SUCCESS;
    vector<off_t> index;
    auto_fd fd;
    
    if (argc < 2) {
	fprintf(stderr, "error: expecting file argument\n");
	retval = EXIT_FAILURE;
    }
    else if ((fd = open(argv[1], O_RDONLY)) == -1) {
	perror("open");
	retval = EXIT_FAILURE;
    }
    else {
	int line_number, start, end;
	off_t offset = 0;
	line_buffer lb;
	char *line;
	size_t len;
	
	lb.set_fd(fd);
	index.push_back(offset);
	while ((line = lb.read_line(offset, len)) != NULL) {
	    index.push_back(offset);
	}
	index.pop_back();

	try {
	    while (scanf("%d:%d:%d", &line_number, &start, &end) == 3) {
		string str;
		
		offset = index[line_number];
		line = lb.read_line(offset, len);
		str = string(line, len);
		str = str.substr(start, end);
		printf("%s\n", str.c_str());
	    }
	}
	catch (line_buffer::error &e) {
	    fprintf(stderr, "error: line buffer %s\n", strerror(e.e_err));
	}
    }

    return retval;
}
