; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2   | FileCheck %s --check-prefixes=ALL,SSE,SSE2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse4.1 | FileCheck %s --check-prefixes=ALL,SSE,SSE41
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx    | FileCheck %s --check-prefixes=ALL,AVX,AVX1OR2,AVX1
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2   | FileCheck %s --check-prefixes=ALL,AVX,AVX1OR2,AVX2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512f,+avx512vl  | FileCheck %s --check-prefixes=ALL,AVX,AVX512,AVX512F
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512bw,+avx512vl | FileCheck %s --check-prefixes=ALL,AVX,AVX512,AVX512BW

define <16 x i8> @undef_index(i8 %x) nounwind {
; ALL-LABEL: undef_index:
; ALL:       # %bb.0:
; ALL-NEXT:    retq
  %ins = insertelement <16 x i8> undef, i8 %x, i64 undef
  ret <16 x i8> %ins
}

define <16 x i8> @undef_scalar(<16 x i8> %x, i32 %index) nounwind {
; ALL-LABEL: undef_scalar:
; ALL:       # %bb.0:
; ALL-NEXT:    retq
  %ins = insertelement <16 x i8> %x, i8 undef, i32 %index
  ret <16 x i8> %ins
}

;
; Insertion into undef vectors
;

define <16 x i8> @arg_i8_v16i8_undef(i8 %x, i32 %y) nounwind {
; SSE2-LABEL: arg_i8_v16i8_undef:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd %edi, %xmm0
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,0,0,4,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE2-NEXT:    retq
;
; SSE41-LABEL: arg_i8_v16i8_undef:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movd %edi, %xmm0
; SSE41-NEXT:    pxor %xmm1, %xmm1
; SSE41-NEXT:    pshufb %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: arg_i8_v16i8_undef:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovd %edi, %xmm0
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: arg_i8_v16i8_undef:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm0
; AVX2-NEXT:    vpbroadcastb %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: arg_i8_v16i8_undef:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovd %edi, %xmm0
; AVX512F-NEXT:    vpbroadcastb %xmm0, %xmm0
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: arg_i8_v16i8_undef:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastb %edi, %xmm0
; AVX512BW-NEXT:    retq
  %ins = insertelement <16 x i8> undef, i8 %x, i32 %y
  ret <16 x i8> %ins
}

define <8 x i16> @arg_i16_v8i16_undef(i16 %x, i32 %y) nounwind {
; SSE-LABEL: arg_i16_v8i16_undef:
; SSE:       # %bb.0:
; SSE-NEXT:    movd %edi, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,0,0,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE-NEXT:    retq
;
; AVX1-LABEL: arg_i16_v8i16_undef:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovd %edi, %xmm0
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,0,0,0,4,5,6,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: arg_i16_v8i16_undef:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm0
; AVX2-NEXT:    vpbroadcastw %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: arg_i16_v8i16_undef:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovd %edi, %xmm0
; AVX512F-NEXT:    vpbroadcastw %xmm0, %xmm0
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: arg_i16_v8i16_undef:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastw %edi, %xmm0
; AVX512BW-NEXT:    retq
  %ins = insertelement <8 x i16> undef, i16 %x, i32 %y
  ret <8 x i16> %ins
}

define <4 x i32> @arg_i32_v4i32_undef(i32 %x, i32 %y) nounwind {
; SSE-LABEL: arg_i32_v4i32_undef:
; SSE:       # %bb.0:
; SSE-NEXT:    movd %edi, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE-NEXT:    retq
;
; AVX1-LABEL: arg_i32_v4i32_undef:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovd %edi, %xmm0
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: arg_i32_v4i32_undef:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm0
; AVX2-NEXT:    vpbroadcastd %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: arg_i32_v4i32_undef:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastd %edi, %xmm0
; AVX512-NEXT:    retq
  %ins = insertelement <4 x i32> undef, i32 %x, i32 %y
  ret <4 x i32> %ins
}

define <2 x i64> @arg_i64_v2i64_undef(i64 %x, i32 %y) nounwind {
; SSE-LABEL: arg_i64_v2i64_undef:
; SSE:       # %bb.0:
; SSE-NEXT:    movq %rdi, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,0,1]
; SSE-NEXT:    retq
;
; AVX1-LABEL: arg_i64_v2i64_undef:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovq %rdi, %xmm0
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,1,0,1]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: arg_i64_v2i64_undef:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovq %rdi, %xmm0
; AVX2-NEXT:    vpbroadcastq %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: arg_i64_v2i64_undef:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastq %rdi, %xmm0
; AVX512-NEXT:    retq
  %ins = insertelement <2 x i64> undef, i64 %x, i32 %y
  ret <2 x i64> %ins
}

define <4 x float> @arg_f32_v4f32_undef(float %x, i32 %y) nounwind {
; SSE-LABEL: arg_f32_v4f32_undef:
; SSE:       # %bb.0:
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE-NEXT:    retq
;
; AVX1-LABEL: arg_f32_v4f32_undef:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,0,0]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: arg_f32_v4f32_undef:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vbroadcastss %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: arg_f32_v4f32_undef:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vbroadcastss %xmm0, %xmm0
; AVX512-NEXT:    retq
  %ins = insertelement <4 x float> undef, float %x, i32 %y
  ret <4 x float> %ins
}

define <2 x double> @arg_f64_v2f64_undef(double %x, i32 %y) nounwind {
; SSE2-LABEL: arg_f64_v2f64_undef:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0,0]
; SSE2-NEXT:    retq
;
; SSE41-LABEL: arg_f64_v2f64_undef:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movddup {{.*#+}} xmm0 = xmm0[0,0]
; SSE41-NEXT:    retq
;
; AVX-LABEL: arg_f64_v2f64_undef:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovddup {{.*#+}} xmm0 = xmm0[0,0]
; AVX-NEXT:    retq
  %ins = insertelement <2 x double> undef, double %x, i32 %y
  ret <2 x double> %ins
}

define <16 x i8> @load_i8_v16i8_undef(i8* %p, i32 %y) nounwind {
; SSE2-LABEL: load_i8_v16i8_undef:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movzbl (%rdi), %eax
; SSE2-NEXT:    movd %eax, %xmm0
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,0,0,4,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE2-NEXT:    retq
;
; SSE41-LABEL: load_i8_v16i8_undef:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movzbl (%rdi), %eax
; SSE41-NEXT:    movd %eax, %xmm0
; SSE41-NEXT:    pxor %xmm1, %xmm1
; SSE41-NEXT:    pshufb %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: load_i8_v16i8_undef:
; AVX1:       # %bb.0:
; AVX1-NEXT:    movzbl (%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_i8_v16i8_undef:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb (%rdi), %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: load_i8_v16i8_undef:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastb (%rdi), %xmm0
; AVX512-NEXT:    retq
  %x = load i8, i8* %p
  %ins = insertelement <16 x i8> undef, i8 %x, i32 %y
  ret <16 x i8> %ins
}

define <8 x i16> @load_i16_v8i16_undef(i16* %p, i32 %y) nounwind {
; SSE-LABEL: load_i16_v8i16_undef:
; SSE:       # %bb.0:
; SSE-NEXT:    movzwl (%rdi), %eax
; SSE-NEXT:    movd %eax, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,0,0,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE-NEXT:    retq
;
; AVX1-LABEL: load_i16_v8i16_undef:
; AVX1:       # %bb.0:
; AVX1-NEXT:    movzwl (%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,0,0,0,4,5,6,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_i16_v8i16_undef:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastw (%rdi), %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: load_i16_v8i16_undef:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastw (%rdi), %xmm0
; AVX512-NEXT:    retq
  %x = load i16, i16* %p
  %ins = insertelement <8 x i16> undef, i16 %x, i32 %y
  ret <8 x i16> %ins
}

define <4 x i32> @load_i32_v4i32_undef(i32* %p, i32 %y) nounwind {
; SSE-LABEL: load_i32_v4i32_undef:
; SSE:       # %bb.0:
; SSE-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i32_v4i32_undef:
; AVX:       # %bb.0:
; AVX-NEXT:    vbroadcastss (%rdi), %xmm0
; AVX-NEXT:    retq
  %x = load i32, i32* %p
  %ins = insertelement <4 x i32> undef, i32 %x, i32 %y
  ret <4 x i32> %ins
}

define <2 x i64> @load_i64_v2i64_undef(i64* %p, i32 %y) nounwind {
; SSE-LABEL: load_i64_v2i64_undef:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,0,1]
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i64_v2i64_undef:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovddup {{.*#+}} xmm0 = mem[0,0]
; AVX-NEXT:    retq
  %x = load i64, i64* %p
  %ins = insertelement <2 x i64> undef, i64 %x, i32 %y
  ret <2 x i64> %ins
}

define <4 x float> @load_f32_v4f32_undef(float* %p, i32 %y) nounwind {
; SSE-LABEL: load_f32_v4f32_undef:
; SSE:       # %bb.0:
; SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE-NEXT:    retq
;
; AVX-LABEL: load_f32_v4f32_undef:
; AVX:       # %bb.0:
; AVX-NEXT:    vbroadcastss (%rdi), %xmm0
; AVX-NEXT:    retq
  %x = load float, float* %p
  %ins = insertelement <4 x float> undef, float %x, i32 %y
  ret <4 x float> %ins
}

define <2 x double> @load_f64_v2f64_undef(double* %p, i32 %y) nounwind {
; SSE2-LABEL: load_f64_v2f64_undef:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE2-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0,0]
; SSE2-NEXT:    retq
;
; SSE41-LABEL: load_f64_v2f64_undef:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movddup {{.*#+}} xmm0 = mem[0,0]
; SSE41-NEXT:    retq
;
; AVX-LABEL: load_f64_v2f64_undef:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovddup {{.*#+}} xmm0 = mem[0,0]
; AVX-NEXT:    retq
  %x = load double, double* %p
  %ins = insertelement <2 x double> undef, double %x, i32 %y
  ret <2 x double> %ins
}

define <32 x i8> @arg_i8_v32i8_undef(i8 %x, i32 %y) nounwind {
; SSE-LABEL: arg_i8_v32i8_undef:
; SSE:       # %bb.0:
; SSE-NEXT:    # kill: def $esi killed $esi def $rsi
; SSE-NEXT:    andl $31, %esi
; SSE-NEXT:    movb %dil, -40(%rsp,%rsi)
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: arg_i8_v32i8_undef:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovd %edi, %xmm0
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: arg_i8_v32i8_undef:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm0
; AVX2-NEXT:    vpbroadcastb %xmm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: arg_i8_v32i8_undef:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovd %edi, %xmm0
; AVX512F-NEXT:    vpbroadcastb %xmm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: arg_i8_v32i8_undef:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastb %edi, %ymm0
; AVX512BW-NEXT:    retq
  %ins = insertelement <32 x i8> undef, i8 %x, i32 %y
  ret <32 x i8> %ins
}

define <16 x i16> @arg_i16_v16i16_undef(i16 %x, i32 %y) nounwind {
; SSE-LABEL: arg_i16_v16i16_undef:
; SSE:       # %bb.0:
; SSE-NEXT:    # kill: def $esi killed $esi def $rsi
; SSE-NEXT:    andl $15, %esi
; SSE-NEXT:    movw %di, -40(%rsp,%rsi,2)
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: arg_i16_v16i16_undef:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovd %edi, %xmm0
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,0,0,0,4,5,6,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: arg_i16_v16i16_undef:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm0
; AVX2-NEXT:    vpbroadcastw %xmm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: arg_i16_v16i16_undef:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovd %edi, %xmm0
; AVX512F-NEXT:    vpbroadcastw %xmm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: arg_i16_v16i16_undef:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastw %edi, %ymm0
; AVX512BW-NEXT:    retq
  %ins = insertelement <16 x i16> undef, i16 %x, i32 %y
  ret <16 x i16> %ins
}

define <8 x i32> @arg_i32_v8i32_undef(i32 %x, i32 %y) nounwind {
; SSE-LABEL: arg_i32_v8i32_undef:
; SSE:       # %bb.0:
; SSE-NEXT:    # kill: def $esi killed $esi def $rsi
; SSE-NEXT:    andl $7, %esi
; SSE-NEXT:    movl %edi, -40(%rsp,%rsi,4)
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: arg_i32_v8i32_undef:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovd %edi, %xmm0
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: arg_i32_v8i32_undef:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm0
; AVX2-NEXT:    vpbroadcastd %xmm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: arg_i32_v8i32_undef:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastd %edi, %ymm0
; AVX512-NEXT:    retq
  %ins = insertelement <8 x i32> undef, i32 %x, i32 %y
  ret <8 x i32> %ins
}

define <4 x i64> @arg_i64_v4i64_undef(i64 %x, i32 %y) nounwind {
; SSE-LABEL: arg_i64_v4i64_undef:
; SSE:       # %bb.0:
; SSE-NEXT:    # kill: def $esi killed $esi def $rsi
; SSE-NEXT:    andl $3, %esi
; SSE-NEXT:    movq %rdi, -40(%rsp,%rsi,8)
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: arg_i64_v4i64_undef:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovq %rdi, %xmm0
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,1,0,1]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: arg_i64_v4i64_undef:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovq %rdi, %xmm0
; AVX2-NEXT:    vpbroadcastq %xmm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: arg_i64_v4i64_undef:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastq %rdi, %ymm0
; AVX512-NEXT:    retq
  %ins = insertelement <4 x i64> undef, i64 %x, i32 %y
  ret <4 x i64> %ins
}

define <8 x float> @arg_f32_v8f32_undef(float %x, i32 %y) nounwind {
; SSE-LABEL: arg_f32_v8f32_undef:
; SSE:       # %bb.0:
; SSE-NEXT:    # kill: def $edi killed $edi def $rdi
; SSE-NEXT:    andl $7, %edi
; SSE-NEXT:    movss %xmm0, -40(%rsp,%rdi,4)
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: arg_f32_v8f32_undef:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,0,0]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: arg_f32_v8f32_undef:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vbroadcastss %xmm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: arg_f32_v8f32_undef:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vbroadcastss %xmm0, %ymm0
; AVX512-NEXT:    retq
  %ins = insertelement <8 x float> undef, float %x, i32 %y
  ret <8 x float> %ins
}

define <4 x double> @arg_f64_v4f64_undef(double %x, i32 %y) nounwind {
; SSE-LABEL: arg_f64_v4f64_undef:
; SSE:       # %bb.0:
; SSE-NEXT:    # kill: def $edi killed $edi def $rdi
; SSE-NEXT:    andl $3, %edi
; SSE-NEXT:    movsd %xmm0, -40(%rsp,%rdi,8)
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: arg_f64_v4f64_undef:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovddup {{.*#+}} xmm0 = xmm0[0,0]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: arg_f64_v4f64_undef:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: arg_f64_v4f64_undef:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX512-NEXT:    retq
  %ins = insertelement <4 x double> undef, double %x, i32 %y
  ret <4 x double> %ins
}

define <32 x i8> @load_i8_v32i8_undef(i8* %p, i32 %y) nounwind {
; SSE-LABEL: load_i8_v32i8_undef:
; SSE:       # %bb.0:
; SSE-NEXT:    # kill: def $esi killed $esi def $rsi
; SSE-NEXT:    movb (%rdi), %al
; SSE-NEXT:    andl $31, %esi
; SSE-NEXT:    movb %al, -40(%rsp,%rsi)
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: load_i8_v32i8_undef:
; AVX1:       # %bb.0:
; AVX1-NEXT:    movzbl (%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_i8_v32i8_undef:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb (%rdi), %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: load_i8_v32i8_undef:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastb (%rdi), %ymm0
; AVX512-NEXT:    retq
  %x = load i8, i8* %p
  %ins = insertelement <32 x i8> undef, i8 %x, i32 %y
  ret <32 x i8> %ins
}

define <16 x i16> @load_i16_v16i16_undef(i16* %p, i32 %y) nounwind {
; SSE-LABEL: load_i16_v16i16_undef:
; SSE:       # %bb.0:
; SSE-NEXT:    # kill: def $esi killed $esi def $rsi
; SSE-NEXT:    movzwl (%rdi), %eax
; SSE-NEXT:    andl $15, %esi
; SSE-NEXT:    movw %ax, -40(%rsp,%rsi,2)
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: load_i16_v16i16_undef:
; AVX1:       # %bb.0:
; AVX1-NEXT:    movzwl (%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,0,0,0,4,5,6,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_i16_v16i16_undef:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastw (%rdi), %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: load_i16_v16i16_undef:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastw (%rdi), %ymm0
; AVX512-NEXT:    retq
  %x = load i16, i16* %p
  %ins = insertelement <16 x i16> undef, i16 %x, i32 %y
  ret <16 x i16> %ins
}

define <8 x i32> @load_i32_v8i32_undef(i32* %p, i32 %y) nounwind {
; SSE-LABEL: load_i32_v8i32_undef:
; SSE:       # %bb.0:
; SSE-NEXT:    # kill: def $esi killed $esi def $rsi
; SSE-NEXT:    movl (%rdi), %eax
; SSE-NEXT:    andl $7, %esi
; SSE-NEXT:    movl %eax, -40(%rsp,%rsi,4)
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i32_v8i32_undef:
; AVX:       # %bb.0:
; AVX-NEXT:    vbroadcastss (%rdi), %ymm0
; AVX-NEXT:    retq
  %x = load i32, i32* %p
  %ins = insertelement <8 x i32> undef, i32 %x, i32 %y
  ret <8 x i32> %ins
}

define <4 x i64> @load_i64_v4i64_undef(i64* %p, i32 %y) nounwind {
; SSE-LABEL: load_i64_v4i64_undef:
; SSE:       # %bb.0:
; SSE-NEXT:    # kill: def $esi killed $esi def $rsi
; SSE-NEXT:    movq (%rdi), %rax
; SSE-NEXT:    andl $3, %esi
; SSE-NEXT:    movq %rax, -40(%rsp,%rsi,8)
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i64_v4i64_undef:
; AVX:       # %bb.0:
; AVX-NEXT:    vbroadcastsd (%rdi), %ymm0
; AVX-NEXT:    retq
  %x = load i64, i64* %p
  %ins = insertelement <4 x i64> undef, i64 %x, i32 %y
  ret <4 x i64> %ins
}

define <8 x float> @load_f32_v8f32_undef(float* %p, i32 %y) nounwind {
; SSE-LABEL: load_f32_v8f32_undef:
; SSE:       # %bb.0:
; SSE-NEXT:    # kill: def $esi killed $esi def $rsi
; SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:    andl $7, %esi
; SSE-NEXT:    movss %xmm0, -40(%rsp,%rsi,4)
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: load_f32_v8f32_undef:
; AVX:       # %bb.0:
; AVX-NEXT:    vbroadcastss (%rdi), %ymm0
; AVX-NEXT:    retq
  %x = load float, float* %p
  %ins = insertelement <8 x float> undef, float %x, i32 %y
  ret <8 x float> %ins
}

define <4 x double> @load_f64_v4f64_undef(double* %p, i32 %y) nounwind {
; SSE-LABEL: load_f64_v4f64_undef:
; SSE:       # %bb.0:
; SSE-NEXT:    # kill: def $esi killed $esi def $rsi
; SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    andl $3, %esi
; SSE-NEXT:    movsd %xmm0, -40(%rsp,%rsi,8)
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: load_f64_v4f64_undef:
; AVX:       # %bb.0:
; AVX-NEXT:    vbroadcastsd (%rdi), %ymm0
; AVX-NEXT:    retq
  %x = load double, double* %p
  %ins = insertelement <4 x double> undef, double %x, i32 %y
  ret <4 x double> %ins
}

;
; Insertion into arg vectors
;

define <16 x i8> @arg_i8_v16i8(<16 x i8> %v, i8 %x, i32 %y) nounwind {
; SSE-LABEL: arg_i8_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    # kill: def $esi killed $esi def $rsi
; SSE-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    andl $15, %esi
; SSE-NEXT:    movb %dil, -24(%rsp,%rsi)
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    retq
;
; AVX1OR2-LABEL: arg_i8_v16i8:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    # kill: def $esi killed $esi def $rsi
; AVX1OR2-NEXT:    vmovaps %xmm0, -{{[0-9]+}}(%rsp)
; AVX1OR2-NEXT:    andl $15, %esi
; AVX1OR2-NEXT:    movb %dil, -24(%rsp,%rsi)
; AVX1OR2-NEXT:    vmovaps -{{[0-9]+}}(%rsp), %xmm0
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: arg_i8_v16i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $esi killed $esi def $rsi
; AVX512F-NEXT:    vmovaps %xmm0, -{{[0-9]+}}(%rsp)
; AVX512F-NEXT:    andl $15, %esi
; AVX512F-NEXT:    movb %dil, -24(%rsp,%rsi)
; AVX512F-NEXT:    vmovaps -{{[0-9]+}}(%rsp), %xmm0
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: arg_i8_v16i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastb %esi, %xmm1
; AVX512BW-NEXT:    vpcmpeqb {{.*}}(%rip), %xmm1, %k1
; AVX512BW-NEXT:    vpbroadcastb %edi, %xmm0 {%k1}
; AVX512BW-NEXT:    retq
  %ins = insertelement <16 x i8> %v, i8 %x, i32 %y
  ret <16 x i8> %ins
}

define <8 x i16> @arg_i16_v8i16(<8 x i16> %v, i16 %x, i32 %y) nounwind {
; SSE-LABEL: arg_i16_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    # kill: def $esi killed $esi def $rsi
; SSE-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    andl $7, %esi
; SSE-NEXT:    movw %di, -24(%rsp,%rsi,2)
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    retq
;
; AVX1OR2-LABEL: arg_i16_v8i16:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    # kill: def $esi killed $esi def $rsi
; AVX1OR2-NEXT:    vmovaps %xmm0, -{{[0-9]+}}(%rsp)
; AVX1OR2-NEXT:    andl $7, %esi
; AVX1OR2-NEXT:    movw %di, -24(%rsp,%rsi,2)
; AVX1OR2-NEXT:    vmovaps -{{[0-9]+}}(%rsp), %xmm0
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: arg_i16_v8i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $esi killed $esi def $rsi
; AVX512F-NEXT:    vmovaps %xmm0, -{{[0-9]+}}(%rsp)
; AVX512F-NEXT:    andl $7, %esi
; AVX512F-NEXT:    movw %di, -24(%rsp,%rsi,2)
; AVX512F-NEXT:    vmovaps -{{[0-9]+}}(%rsp), %xmm0
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: arg_i16_v8i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastw %esi, %xmm1
; AVX512BW-NEXT:    vpcmpeqw {{.*}}(%rip), %xmm1, %k1
; AVX512BW-NEXT:    vpbroadcastw %edi, %xmm0 {%k1}
; AVX512BW-NEXT:    retq
  %ins = insertelement <8 x i16> %v, i16 %x, i32 %y
  ret <8 x i16> %ins
}

define <4 x i32> @arg_i32_v4i32(<4 x i32> %v, i32 %x, i32 %y) nounwind {
; SSE-LABEL: arg_i32_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    # kill: def $esi killed $esi def $rsi
; SSE-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    andl $3, %esi
; SSE-NEXT:    movl %edi, -24(%rsp,%rsi,4)
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    retq
;
; AVX1OR2-LABEL: arg_i32_v4i32:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    # kill: def $esi killed $esi def $rsi
; AVX1OR2-NEXT:    vmovaps %xmm0, -{{[0-9]+}}(%rsp)
; AVX1OR2-NEXT:    andl $3, %esi
; AVX1OR2-NEXT:    movl %edi, -24(%rsp,%rsi,4)
; AVX1OR2-NEXT:    vmovaps -{{[0-9]+}}(%rsp), %xmm0
; AVX1OR2-NEXT:    retq
;
; AVX512-LABEL: arg_i32_v4i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastd %esi, %xmm1
; AVX512-NEXT:    vpcmpeqd {{.*}}(%rip), %xmm1, %k1
; AVX512-NEXT:    vpbroadcastd %edi, %xmm0 {%k1}
; AVX512-NEXT:    retq
  %ins = insertelement <4 x i32> %v, i32 %x, i32 %y
  ret <4 x i32> %ins
}

define <2 x i64> @arg_i64_v2i64(<2 x i64> %v, i64 %x, i32 %y) nounwind {
; SSE-LABEL: arg_i64_v2i64:
; SSE:       # %bb.0:
; SSE-NEXT:    # kill: def $esi killed $esi def $rsi
; SSE-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    andl $1, %esi
; SSE-NEXT:    movq %rdi, -24(%rsp,%rsi,8)
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    retq
;
; AVX1OR2-LABEL: arg_i64_v2i64:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    # kill: def $esi killed $esi def $rsi
; AVX1OR2-NEXT:    vmovaps %xmm0, -{{[0-9]+}}(%rsp)
; AVX1OR2-NEXT:    andl $1, %esi
; AVX1OR2-NEXT:    movq %rdi, -24(%rsp,%rsi,8)
; AVX1OR2-NEXT:    vmovaps -{{[0-9]+}}(%rsp), %xmm0
; AVX1OR2-NEXT:    retq
;
; AVX512-LABEL: arg_i64_v2i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movslq %esi, %rax
; AVX512-NEXT:    vpbroadcastq %rax, %xmm1
; AVX512-NEXT:    vpcmpeqq {{.*}}(%rip), %xmm1, %k1
; AVX512-NEXT:    vpbroadcastq %rdi, %xmm0 {%k1}
; AVX512-NEXT:    retq
  %ins = insertelement <2 x i64> %v, i64 %x, i32 %y
  ret <2 x i64> %ins
}

define <4 x float> @arg_f32_v4f32(<4 x float> %v, float %x, i32 %y) nounwind {
; SSE2-LABEL: arg_f32_v4f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    # kill: def $edi killed $edi def $rdi
; SSE2-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; SSE2-NEXT:    andl $3, %edi
; SSE2-NEXT:    movss %xmm1, -24(%rsp,%rdi,4)
; SSE2-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: arg_f32_v4f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movaps %xmm0, %xmm2
; SSE41-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,0,0,0]
; SSE41-NEXT:    movd %edi, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE41-NEXT:    pcmpeqd {{.*}}(%rip), %xmm0
; SSE41-NEXT:    blendvps %xmm0, %xmm1, %xmm2
; SSE41-NEXT:    movaps %xmm2, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: arg_f32_v4f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[0,0,0,0]
; AVX1-NEXT:    vmovd %edi, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,0,0,0]
; AVX1-NEXT:    vpcmpeqd {{.*}}(%rip), %xmm2, %xmm2
; AVX1-NEXT:    vblendvps %xmm2, %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: arg_f32_v4f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vbroadcastss %xmm1, %xmm1
; AVX2-NEXT:    vmovd %edi, %xmm2
; AVX2-NEXT:    vpbroadcastd %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqd {{.*}}(%rip), %xmm2, %xmm2
; AVX2-NEXT:    vblendvps %xmm2, %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: arg_f32_v4f32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastd %edi, %xmm2
; AVX512-NEXT:    vpcmpeqd {{.*}}(%rip), %xmm2, %k1
; AVX512-NEXT:    vbroadcastss %xmm1, %xmm0 {%k1}
; AVX512-NEXT:    retq
  %ins = insertelement <4 x float> %v, float %x, i32 %y
  ret <4 x float> %ins
}

define <2 x double> @arg_f64_v2f64(<2 x double> %v, double %x, i32 %y) nounwind {
; SSE2-LABEL: arg_f64_v2f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    # kill: def $edi killed $edi def $rdi
; SSE2-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; SSE2-NEXT:    andl $1, %edi
; SSE2-NEXT:    movsd %xmm1, -24(%rsp,%rdi,8)
; SSE2-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: arg_f64_v2f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movapd %xmm0, %xmm2
; SSE41-NEXT:    movddup {{.*#+}} xmm1 = xmm1[0,0]
; SSE41-NEXT:    movslq %edi, %rax
; SSE41-NEXT:    movq %rax, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,0,1]
; SSE41-NEXT:    pcmpeqq {{.*}}(%rip), %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm2
; SSE41-NEXT:    movapd %xmm2, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: arg_f64_v2f64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovddup {{.*#+}} xmm1 = xmm1[0,0]
; AVX1-NEXT:    movslq %edi, %rax
; AVX1-NEXT:    vmovq %rax, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,1,0,1]
; AVX1-NEXT:    vpcmpeqq {{.*}}(%rip), %xmm2, %xmm2
; AVX1-NEXT:    vblendvpd %xmm2, %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: arg_f64_v2f64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovddup {{.*#+}} xmm1 = xmm1[0,0]
; AVX2-NEXT:    movslq %edi, %rax
; AVX2-NEXT:    vmovq %rax, %xmm2
; AVX2-NEXT:    vpbroadcastq %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqq {{.*}}(%rip), %xmm2, %xmm2
; AVX2-NEXT:    vblendvpd %xmm2, %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: arg_f64_v2f64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movslq %edi, %rax
; AVX512-NEXT:    vpbroadcastq %rax, %xmm2
; AVX512-NEXT:    vpcmpeqq {{.*}}(%rip), %xmm2, %k1
; AVX512-NEXT:    vmovddup {{.*#+}} xmm0 {%k1} = xmm1[0,0]
; AVX512-NEXT:    retq
  %ins = insertelement <2 x double> %v, double %x, i32 %y
  ret <2 x double> %ins
}

define <16 x i8> @load_i8_v16i8(<16 x i8> %v, i8* %p, i32 %y) nounwind {
; SSE-LABEL: load_i8_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    # kill: def $esi killed $esi def $rsi
; SSE-NEXT:    movb (%rdi), %al
; SSE-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    andl $15, %esi
; SSE-NEXT:    movb %al, -24(%rsp,%rsi)
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    retq
;
; AVX1OR2-LABEL: load_i8_v16i8:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    # kill: def $esi killed $esi def $rsi
; AVX1OR2-NEXT:    movb (%rdi), %al
; AVX1OR2-NEXT:    vmovaps %xmm0, -{{[0-9]+}}(%rsp)
; AVX1OR2-NEXT:    andl $15, %esi
; AVX1OR2-NEXT:    movb %al, -24(%rsp,%rsi)
; AVX1OR2-NEXT:    vmovaps -{{[0-9]+}}(%rsp), %xmm0
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: load_i8_v16i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $esi killed $esi def $rsi
; AVX512F-NEXT:    movb (%rdi), %al
; AVX512F-NEXT:    vmovaps %xmm0, -{{[0-9]+}}(%rsp)
; AVX512F-NEXT:    andl $15, %esi
; AVX512F-NEXT:    movb %al, -24(%rsp,%rsi)
; AVX512F-NEXT:    vmovaps -{{[0-9]+}}(%rsp), %xmm0
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: load_i8_v16i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastb %esi, %xmm1
; AVX512BW-NEXT:    vpcmpeqb {{.*}}(%rip), %xmm1, %k1
; AVX512BW-NEXT:    vpbroadcastb (%rdi), %xmm0 {%k1}
; AVX512BW-NEXT:    retq
  %x = load i8, i8* %p
  %ins = insertelement <16 x i8> %v, i8 %x, i32 %y
  ret <16 x i8> %ins
}

define <8 x i16> @load_i16_v8i16(<8 x i16> %v, i16* %p, i32 %y) nounwind {
; SSE-LABEL: load_i16_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    # kill: def $esi killed $esi def $rsi
; SSE-NEXT:    movzwl (%rdi), %eax
; SSE-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    andl $7, %esi
; SSE-NEXT:    movw %ax, -24(%rsp,%rsi,2)
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    retq
;
; AVX1OR2-LABEL: load_i16_v8i16:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    # kill: def $esi killed $esi def $rsi
; AVX1OR2-NEXT:    movzwl (%rdi), %eax
; AVX1OR2-NEXT:    vmovaps %xmm0, -{{[0-9]+}}(%rsp)
; AVX1OR2-NEXT:    andl $7, %esi
; AVX1OR2-NEXT:    movw %ax, -24(%rsp,%rsi,2)
; AVX1OR2-NEXT:    vmovaps -{{[0-9]+}}(%rsp), %xmm0
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: load_i16_v8i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $esi killed $esi def $rsi
; AVX512F-NEXT:    movzwl (%rdi), %eax
; AVX512F-NEXT:    vmovaps %xmm0, -{{[0-9]+}}(%rsp)
; AVX512F-NEXT:    andl $7, %esi
; AVX512F-NEXT:    movw %ax, -24(%rsp,%rsi,2)
; AVX512F-NEXT:    vmovaps -{{[0-9]+}}(%rsp), %xmm0
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: load_i16_v8i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastw %esi, %xmm1
; AVX512BW-NEXT:    vpcmpeqw {{.*}}(%rip), %xmm1, %k1
; AVX512BW-NEXT:    vpbroadcastw (%rdi), %xmm0 {%k1}
; AVX512BW-NEXT:    retq
  %x = load i16, i16* %p
  %ins = insertelement <8 x i16> %v, i16 %x, i32 %y
  ret <8 x i16> %ins
}

define <4 x i32> @load_i32_v4i32(<4 x i32> %v, i32* %p, i32 %y) nounwind {
; SSE-LABEL: load_i32_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    # kill: def $esi killed $esi def $rsi
; SSE-NEXT:    movl (%rdi), %eax
; SSE-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    andl $3, %esi
; SSE-NEXT:    movl %eax, -24(%rsp,%rsi,4)
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    retq
;
; AVX1OR2-LABEL: load_i32_v4i32:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    # kill: def $esi killed $esi def $rsi
; AVX1OR2-NEXT:    movl (%rdi), %eax
; AVX1OR2-NEXT:    vmovaps %xmm0, -{{[0-9]+}}(%rsp)
; AVX1OR2-NEXT:    andl $3, %esi
; AVX1OR2-NEXT:    movl %eax, -24(%rsp,%rsi,4)
; AVX1OR2-NEXT:    vmovaps -{{[0-9]+}}(%rsp), %xmm0
; AVX1OR2-NEXT:    retq
;
; AVX512-LABEL: load_i32_v4i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastd %esi, %xmm1
; AVX512-NEXT:    vpcmpeqd {{.*}}(%rip), %xmm1, %k1
; AVX512-NEXT:    vpbroadcastd (%rdi), %xmm0 {%k1}
; AVX512-NEXT:    retq
  %x = load i32, i32* %p
  %ins = insertelement <4 x i32> %v, i32 %x, i32 %y
  ret <4 x i32> %ins
}

define <2 x i64> @load_i64_v2i64(<2 x i64> %v, i64* %p, i32 %y) nounwind {
; SSE-LABEL: load_i64_v2i64:
; SSE:       # %bb.0:
; SSE-NEXT:    # kill: def $esi killed $esi def $rsi
; SSE-NEXT:    movq (%rdi), %rax
; SSE-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    andl $1, %esi
; SSE-NEXT:    movq %rax, -24(%rsp,%rsi,8)
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    retq
;
; AVX1OR2-LABEL: load_i64_v2i64:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    # kill: def $esi killed $esi def $rsi
; AVX1OR2-NEXT:    movq (%rdi), %rax
; AVX1OR2-NEXT:    vmovaps %xmm0, -{{[0-9]+}}(%rsp)
; AVX1OR2-NEXT:    andl $1, %esi
; AVX1OR2-NEXT:    movq %rax, -24(%rsp,%rsi,8)
; AVX1OR2-NEXT:    vmovaps -{{[0-9]+}}(%rsp), %xmm0
; AVX1OR2-NEXT:    retq
;
; AVX512-LABEL: load_i64_v2i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movslq %esi, %rax
; AVX512-NEXT:    vpbroadcastq %rax, %xmm1
; AVX512-NEXT:    vpcmpeqq {{.*}}(%rip), %xmm1, %k1
; AVX512-NEXT:    vpbroadcastq (%rdi), %xmm0 {%k1}
; AVX512-NEXT:    retq
  %x = load i64, i64* %p
  %ins = insertelement <2 x i64> %v, i64 %x, i32 %y
  ret <2 x i64> %ins
}

define <4 x float> @load_f32_v4f32(<4 x float> %v, float* %p, i32 %y) nounwind {
; SSE2-LABEL: load_f32_v4f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    # kill: def $esi killed $esi def $rsi
; SSE2-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE2-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; SSE2-NEXT:    andl $3, %esi
; SSE2-NEXT:    movss %xmm1, -24(%rsp,%rsi,4)
; SSE2-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: load_f32_v4f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movaps %xmm0, %xmm1
; SSE41-NEXT:    movss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE41-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,0,0,0]
; SSE41-NEXT:    movd %esi, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE41-NEXT:    pcmpeqd {{.*}}(%rip), %xmm0
; SSE41-NEXT:    blendvps %xmm0, %xmm2, %xmm1
; SSE41-NEXT:    movaps %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: load_f32_v4f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vbroadcastss (%rdi), %xmm1
; AVX1-NEXT:    vmovd %esi, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,0,0,0]
; AVX1-NEXT:    vpcmpeqd {{.*}}(%rip), %xmm2, %xmm2
; AVX1-NEXT:    vblendvps %xmm2, %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_f32_v4f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vbroadcastss (%rdi), %xmm1
; AVX2-NEXT:    vmovd %esi, %xmm2
; AVX2-NEXT:    vpbroadcastd %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqd {{.*}}(%rip), %xmm2, %xmm2
; AVX2-NEXT:    vblendvps %xmm2, %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: load_f32_v4f32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastd %esi, %xmm1
; AVX512-NEXT:    vpcmpeqd {{.*}}(%rip), %xmm1, %k1
; AVX512-NEXT:    vbroadcastss (%rdi), %xmm0 {%k1}
; AVX512-NEXT:    retq
  %x = load float, float* %p
  %ins = insertelement <4 x float> %v, float %x, i32 %y
  ret <4 x float> %ins
}

define <2 x double> @load_f64_v2f64(<2 x double> %v, double* %p, i32 %y) nounwind {
; SSE2-LABEL: load_f64_v2f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    # kill: def $esi killed $esi def $rsi
; SSE2-NEXT:    movsd {{.*#+}} xmm1 = mem[0],zero
; SSE2-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; SSE2-NEXT:    andl $1, %esi
; SSE2-NEXT:    movsd %xmm1, -24(%rsp,%rsi,8)
; SSE2-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: load_f64_v2f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movapd %xmm0, %xmm1
; SSE41-NEXT:    movddup {{.*#+}} xmm2 = mem[0,0]
; SSE41-NEXT:    movslq %esi, %rax
; SSE41-NEXT:    movq %rax, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,0,1]
; SSE41-NEXT:    pcmpeqq {{.*}}(%rip), %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm1
; SSE41-NEXT:    movapd %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: load_f64_v2f64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX1-NEXT:    movslq %esi, %rax
; AVX1-NEXT:    vmovq %rax, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,1,0,1]
; AVX1-NEXT:    vpcmpeqq {{.*}}(%rip), %xmm2, %xmm2
; AVX1-NEXT:    vblendvpd %xmm2, %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_f64_v2f64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-NEXT:    movslq %esi, %rax
; AVX2-NEXT:    vmovq %rax, %xmm2
; AVX2-NEXT:    vpbroadcastq %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqq {{.*}}(%rip), %xmm2, %xmm2
; AVX2-NEXT:    vblendvpd %xmm2, %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: load_f64_v2f64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movslq %esi, %rax
; AVX512-NEXT:    vpbroadcastq %rax, %xmm1
; AVX512-NEXT:    vpcmpeqq {{.*}}(%rip), %xmm1, %k1
; AVX512-NEXT:    vmovddup {{.*#+}} xmm0 {%k1} = mem[0,0]
; AVX512-NEXT:    retq
  %x = load double, double* %p
  %ins = insertelement <2 x double> %v, double %x, i32 %y
  ret <2 x double> %ins
}

define <32 x i8> @arg_i8_v32i8(<32 x i8> %v, i8 %x, i32 %y) nounwind {
; SSE-LABEL: arg_i8_v32i8:
; SSE:       # %bb.0:
; SSE-NEXT:    # kill: def $esi killed $esi def $rsi
; SSE-NEXT:    movaps %xmm1, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    andl $31, %esi
; SSE-NEXT:    movb %dil, -40(%rsp,%rsi)
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    retq
;
; AVX1OR2-LABEL: arg_i8_v32i8:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    pushq %rbp
; AVX1OR2-NEXT:    movq %rsp, %rbp
; AVX1OR2-NEXT:    andq $-32, %rsp
; AVX1OR2-NEXT:    subq $64, %rsp
; AVX1OR2-NEXT:    # kill: def $esi killed $esi def $rsi
; AVX1OR2-NEXT:    vmovaps %ymm0, (%rsp)
; AVX1OR2-NEXT:    andl $31, %esi
; AVX1OR2-NEXT:    movb %dil, (%rsp,%rsi)
; AVX1OR2-NEXT:    vmovaps (%rsp), %ymm0
; AVX1OR2-NEXT:    movq %rbp, %rsp
; AVX1OR2-NEXT:    popq %rbp
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: arg_i8_v32i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    pushq %rbp
; AVX512F-NEXT:    movq %rsp, %rbp
; AVX512F-NEXT:    andq $-32, %rsp
; AVX512F-NEXT:    subq $64, %rsp
; AVX512F-NEXT:    # kill: def $esi killed $esi def $rsi
; AVX512F-NEXT:    vmovaps %ymm0, (%rsp)
; AVX512F-NEXT:    andl $31, %esi
; AVX512F-NEXT:    movb %dil, (%rsp,%rsi)
; AVX512F-NEXT:    vmovaps (%rsp), %ymm0
; AVX512F-NEXT:    movq %rbp, %rsp
; AVX512F-NEXT:    popq %rbp
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: arg_i8_v32i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastb %esi, %ymm1
; AVX512BW-NEXT:    vpcmpeqb {{.*}}(%rip), %ymm1, %k1
; AVX512BW-NEXT:    vpbroadcastb %edi, %ymm0 {%k1}
; AVX512BW-NEXT:    retq
  %ins = insertelement <32 x i8> %v, i8 %x, i32 %y
  ret <32 x i8> %ins
}

define <16 x i16> @arg_i16_v16i16(<16 x i16> %v, i16 %x, i32 %y) nounwind {
; SSE-LABEL: arg_i16_v16i16:
; SSE:       # %bb.0:
; SSE-NEXT:    # kill: def $esi killed $esi def $rsi
; SSE-NEXT:    movaps %xmm1, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    andl $15, %esi
; SSE-NEXT:    movw %di, -40(%rsp,%rsi,2)
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    retq
;
; AVX1OR2-LABEL: arg_i16_v16i16:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    pushq %rbp
; AVX1OR2-NEXT:    movq %rsp, %rbp
; AVX1OR2-NEXT:    andq $-32, %rsp
; AVX1OR2-NEXT:    subq $64, %rsp
; AVX1OR2-NEXT:    # kill: def $esi killed $esi def $rsi
; AVX1OR2-NEXT:    vmovaps %ymm0, (%rsp)
; AVX1OR2-NEXT:    andl $15, %esi
; AVX1OR2-NEXT:    movw %di, (%rsp,%rsi,2)
; AVX1OR2-NEXT:    vmovaps (%rsp), %ymm0
; AVX1OR2-NEXT:    movq %rbp, %rsp
; AVX1OR2-NEXT:    popq %rbp
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: arg_i16_v16i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    pushq %rbp
; AVX512F-NEXT:    movq %rsp, %rbp
; AVX512F-NEXT:    andq $-32, %rsp
; AVX512F-NEXT:    subq $64, %rsp
; AVX512F-NEXT:    # kill: def $esi killed $esi def $rsi
; AVX512F-NEXT:    vmovaps %ymm0, (%rsp)
; AVX512F-NEXT:    andl $15, %esi
; AVX512F-NEXT:    movw %di, (%rsp,%rsi,2)
; AVX512F-NEXT:    vmovaps (%rsp), %ymm0
; AVX512F-NEXT:    movq %rbp, %rsp
; AVX512F-NEXT:    popq %rbp
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: arg_i16_v16i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastw %esi, %ymm1
; AVX512BW-NEXT:    vpcmpeqw {{.*}}(%rip), %ymm1, %k1
; AVX512BW-NEXT:    vpbroadcastw %edi, %ymm0 {%k1}
; AVX512BW-NEXT:    retq
  %ins = insertelement <16 x i16> %v, i16 %x, i32 %y
  ret <16 x i16> %ins
}

define <8 x i32> @arg_i32_v8i32(<8 x i32> %v, i32 %x, i32 %y) nounwind {
; SSE-LABEL: arg_i32_v8i32:
; SSE:       # %bb.0:
; SSE-NEXT:    # kill: def $esi killed $esi def $rsi
; SSE-NEXT:    movaps %xmm1, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    andl $7, %esi
; SSE-NEXT:    movl %edi, -40(%rsp,%rsi,4)
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    retq
;
; AVX1OR2-LABEL: arg_i32_v8i32:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    pushq %rbp
; AVX1OR2-NEXT:    movq %rsp, %rbp
; AVX1OR2-NEXT:    andq $-32, %rsp
; AVX1OR2-NEXT:    subq $64, %rsp
; AVX1OR2-NEXT:    # kill: def $esi killed $esi def $rsi
; AVX1OR2-NEXT:    vmovaps %ymm0, (%rsp)
; AVX1OR2-NEXT:    andl $7, %esi
; AVX1OR2-NEXT:    movl %edi, (%rsp,%rsi,4)
; AVX1OR2-NEXT:    vmovaps (%rsp), %ymm0
; AVX1OR2-NEXT:    movq %rbp, %rsp
; AVX1OR2-NEXT:    popq %rbp
; AVX1OR2-NEXT:    retq
;
; AVX512-LABEL: arg_i32_v8i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastd %esi, %ymm1
; AVX512-NEXT:    vpcmpeqd {{.*}}(%rip), %ymm1, %k1
; AVX512-NEXT:    vpbroadcastd %edi, %ymm0 {%k1}
; AVX512-NEXT:    retq
  %ins = insertelement <8 x i32> %v, i32 %x, i32 %y
  ret <8 x i32> %ins
}

define <4 x i64> @arg_i64_v4i64(<4 x i64> %v, i64 %x, i32 %y) nounwind {
; SSE-LABEL: arg_i64_v4i64:
; SSE:       # %bb.0:
; SSE-NEXT:    # kill: def $esi killed $esi def $rsi
; SSE-NEXT:    movaps %xmm1, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    andl $3, %esi
; SSE-NEXT:    movq %rdi, -40(%rsp,%rsi,8)
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    retq
;
; AVX1OR2-LABEL: arg_i64_v4i64:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    pushq %rbp
; AVX1OR2-NEXT:    movq %rsp, %rbp
; AVX1OR2-NEXT:    andq $-32, %rsp
; AVX1OR2-NEXT:    subq $64, %rsp
; AVX1OR2-NEXT:    # kill: def $esi killed $esi def $rsi
; AVX1OR2-NEXT:    vmovaps %ymm0, (%rsp)
; AVX1OR2-NEXT:    andl $3, %esi
; AVX1OR2-NEXT:    movq %rdi, (%rsp,%rsi,8)
; AVX1OR2-NEXT:    vmovaps (%rsp), %ymm0
; AVX1OR2-NEXT:    movq %rbp, %rsp
; AVX1OR2-NEXT:    popq %rbp
; AVX1OR2-NEXT:    retq
;
; AVX512-LABEL: arg_i64_v4i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movslq %esi, %rax
; AVX512-NEXT:    vpbroadcastq %rax, %ymm1
; AVX512-NEXT:    vpcmpeqq {{.*}}(%rip), %ymm1, %k1
; AVX512-NEXT:    vpbroadcastq %rdi, %ymm0 {%k1}
; AVX512-NEXT:    retq
  %ins = insertelement <4 x i64> %v, i64 %x, i32 %y
  ret <4 x i64> %ins
}

define <8 x float> @arg_f32_v8f32(<8 x float> %v, float %x, i32 %y) nounwind {
; SSE-LABEL: arg_f32_v8f32:
; SSE:       # %bb.0:
; SSE-NEXT:    # kill: def $edi killed $edi def $rdi
; SSE-NEXT:    movaps %xmm1, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    andl $7, %edi
; SSE-NEXT:    movss %xmm2, -40(%rsp,%rdi,4)
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: arg_f32_v8f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[0,0,0,0]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm1, %ymm1
; AVX1-NEXT:    vmovd %edi, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,0,0,0]
; AVX1-NEXT:    vpcmpeqd {{.*}}(%rip), %xmm2, %xmm3
; AVX1-NEXT:    vpcmpeqd {{\.LCPI[0-9]+_[0-9]+}}+{{.*}}(%rip), %xmm2, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX1-NEXT:    vblendvps %ymm2, %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: arg_f32_v8f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vbroadcastss %xmm1, %ymm1
; AVX2-NEXT:    vmovd %edi, %xmm2
; AVX2-NEXT:    vpbroadcastd %xmm2, %ymm2
; AVX2-NEXT:    vpcmpeqd {{.*}}(%rip), %ymm2, %ymm2
; AVX2-NEXT:    vblendvps %ymm2, %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: arg_f32_v8f32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastd %edi, %ymm2
; AVX512-NEXT:    vpcmpeqd {{.*}}(%rip), %ymm2, %k1
; AVX512-NEXT:    vbroadcastss %xmm1, %ymm0 {%k1}
; AVX512-NEXT:    retq
  %ins = insertelement <8 x float> %v, float %x, i32 %y
  ret <8 x float> %ins
}

define <4 x double> @arg_f64_v4f64(<4 x double> %v, double %x, i32 %y) nounwind {
; SSE-LABEL: arg_f64_v4f64:
; SSE:       # %bb.0:
; SSE-NEXT:    # kill: def $edi killed $edi def $rdi
; SSE-NEXT:    movaps %xmm1, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    andl $3, %edi
; SSE-NEXT:    movsd %xmm2, -40(%rsp,%rdi,8)
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: arg_f64_v4f64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovddup {{.*#+}} xmm1 = xmm1[0,0]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm1, %ymm1
; AVX1-NEXT:    movslq %edi, %rax
; AVX1-NEXT:    vmovq %rax, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,1,0,1]
; AVX1-NEXT:    vpcmpeqq {{.*}}(%rip), %xmm2, %xmm3
; AVX1-NEXT:    vpcmpeqq {{\.LCPI[0-9]+_[0-9]+}}+{{.*}}(%rip), %xmm2, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX1-NEXT:    vblendvpd %ymm2, %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: arg_f64_v4f64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vbroadcastsd %xmm1, %ymm1
; AVX2-NEXT:    movslq %edi, %rax
; AVX2-NEXT:    vmovq %rax, %xmm2
; AVX2-NEXT:    vpbroadcastq %xmm2, %ymm2
; AVX2-NEXT:    vpcmpeqq {{.*}}(%rip), %ymm2, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: arg_f64_v4f64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movslq %edi, %rax
; AVX512-NEXT:    vpbroadcastq %rax, %ymm2
; AVX512-NEXT:    vpcmpeqq {{.*}}(%rip), %ymm2, %k1
; AVX512-NEXT:    vbroadcastsd %xmm1, %ymm0 {%k1}
; AVX512-NEXT:    retq
  %ins = insertelement <4 x double> %v, double %x, i32 %y
  ret <4 x double> %ins
}

define <32 x i8> @load_i8_v32i8(<32 x i8> %v, i8* %p, i32 %y) nounwind {
; SSE-LABEL: load_i8_v32i8:
; SSE:       # %bb.0:
; SSE-NEXT:    # kill: def $esi killed $esi def $rsi
; SSE-NEXT:    movb (%rdi), %al
; SSE-NEXT:    movaps %xmm1, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    andl $31, %esi
; SSE-NEXT:    movb %al, -40(%rsp,%rsi)
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    retq
;
; AVX1OR2-LABEL: load_i8_v32i8:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    pushq %rbp
; AVX1OR2-NEXT:    movq %rsp, %rbp
; AVX1OR2-NEXT:    andq $-32, %rsp
; AVX1OR2-NEXT:    subq $64, %rsp
; AVX1OR2-NEXT:    # kill: def $esi killed $esi def $rsi
; AVX1OR2-NEXT:    movb (%rdi), %al
; AVX1OR2-NEXT:    vmovaps %ymm0, (%rsp)
; AVX1OR2-NEXT:    andl $31, %esi
; AVX1OR2-NEXT:    movb %al, (%rsp,%rsi)
; AVX1OR2-NEXT:    vmovaps (%rsp), %ymm0
; AVX1OR2-NEXT:    movq %rbp, %rsp
; AVX1OR2-NEXT:    popq %rbp
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: load_i8_v32i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    pushq %rbp
; AVX512F-NEXT:    movq %rsp, %rbp
; AVX512F-NEXT:    andq $-32, %rsp
; AVX512F-NEXT:    subq $64, %rsp
; AVX512F-NEXT:    # kill: def $esi killed $esi def $rsi
; AVX512F-NEXT:    movb (%rdi), %al
; AVX512F-NEXT:    vmovaps %ymm0, (%rsp)
; AVX512F-NEXT:    andl $31, %esi
; AVX512F-NEXT:    movb %al, (%rsp,%rsi)
; AVX512F-NEXT:    vmovaps (%rsp), %ymm0
; AVX512F-NEXT:    movq %rbp, %rsp
; AVX512F-NEXT:    popq %rbp
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: load_i8_v32i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastb %esi, %ymm1
; AVX512BW-NEXT:    vpcmpeqb {{.*}}(%rip), %ymm1, %k1
; AVX512BW-NEXT:    vpbroadcastb (%rdi), %ymm0 {%k1}
; AVX512BW-NEXT:    retq
  %x = load i8, i8* %p
  %ins = insertelement <32 x i8> %v, i8 %x, i32 %y
  ret <32 x i8> %ins
}

define <16 x i16> @load_i16_v16i16(<16 x i16> %v, i16* %p, i32 %y) nounwind {
; SSE-LABEL: load_i16_v16i16:
; SSE:       # %bb.0:
; SSE-NEXT:    # kill: def $esi killed $esi def $rsi
; SSE-NEXT:    movzwl (%rdi), %eax
; SSE-NEXT:    movaps %xmm1, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    andl $15, %esi
; SSE-NEXT:    movw %ax, -40(%rsp,%rsi,2)
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    retq
;
; AVX1OR2-LABEL: load_i16_v16i16:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    pushq %rbp
; AVX1OR2-NEXT:    movq %rsp, %rbp
; AVX1OR2-NEXT:    andq $-32, %rsp
; AVX1OR2-NEXT:    subq $64, %rsp
; AVX1OR2-NEXT:    # kill: def $esi killed $esi def $rsi
; AVX1OR2-NEXT:    movzwl (%rdi), %eax
; AVX1OR2-NEXT:    vmovaps %ymm0, (%rsp)
; AVX1OR2-NEXT:    andl $15, %esi
; AVX1OR2-NEXT:    movw %ax, (%rsp,%rsi,2)
; AVX1OR2-NEXT:    vmovaps (%rsp), %ymm0
; AVX1OR2-NEXT:    movq %rbp, %rsp
; AVX1OR2-NEXT:    popq %rbp
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: load_i16_v16i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    pushq %rbp
; AVX512F-NEXT:    movq %rsp, %rbp
; AVX512F-NEXT:    andq $-32, %rsp
; AVX512F-NEXT:    subq $64, %rsp
; AVX512F-NEXT:    # kill: def $esi killed $esi def $rsi
; AVX512F-NEXT:    movzwl (%rdi), %eax
; AVX512F-NEXT:    vmovaps %ymm0, (%rsp)
; AVX512F-NEXT:    andl $15, %esi
; AVX512F-NEXT:    movw %ax, (%rsp,%rsi,2)
; AVX512F-NEXT:    vmovaps (%rsp), %ymm0
; AVX512F-NEXT:    movq %rbp, %rsp
; AVX512F-NEXT:    popq %rbp
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: load_i16_v16i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastw %esi, %ymm1
; AVX512BW-NEXT:    vpcmpeqw {{.*}}(%rip), %ymm1, %k1
; AVX512BW-NEXT:    vpbroadcastw (%rdi), %ymm0 {%k1}
; AVX512BW-NEXT:    retq
  %x = load i16, i16* %p
  %ins = insertelement <16 x i16> %v, i16 %x, i32 %y
  ret <16 x i16> %ins
}

define <8 x i32> @load_i32_v8i32(<8 x i32> %v, i32* %p, i32 %y) nounwind {
; SSE-LABEL: load_i32_v8i32:
; SSE:       # %bb.0:
; SSE-NEXT:    # kill: def $esi killed $esi def $rsi
; SSE-NEXT:    movl (%rdi), %eax
; SSE-NEXT:    movaps %xmm1, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    andl $7, %esi
; SSE-NEXT:    movl %eax, -40(%rsp,%rsi,4)
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    retq
;
; AVX1OR2-LABEL: load_i32_v8i32:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    pushq %rbp
; AVX1OR2-NEXT:    movq %rsp, %rbp
; AVX1OR2-NEXT:    andq $-32, %rsp
; AVX1OR2-NEXT:    subq $64, %rsp
; AVX1OR2-NEXT:    # kill: def $esi killed $esi def $rsi
; AVX1OR2-NEXT:    movl (%rdi), %eax
; AVX1OR2-NEXT:    vmovaps %ymm0, (%rsp)
; AVX1OR2-NEXT:    andl $7, %esi
; AVX1OR2-NEXT:    movl %eax, (%rsp,%rsi,4)
; AVX1OR2-NEXT:    vmovaps (%rsp), %ymm0
; AVX1OR2-NEXT:    movq %rbp, %rsp
; AVX1OR2-NEXT:    popq %rbp
; AVX1OR2-NEXT:    retq
;
; AVX512-LABEL: load_i32_v8i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastd %esi, %ymm1
; AVX512-NEXT:    vpcmpeqd {{.*}}(%rip), %ymm1, %k1
; AVX512-NEXT:    vpbroadcastd (%rdi), %ymm0 {%k1}
; AVX512-NEXT:    retq
  %x = load i32, i32* %p
  %ins = insertelement <8 x i32> %v, i32 %x, i32 %y
  ret <8 x i32> %ins
}

define <4 x i64> @load_i64_v4i64(<4 x i64> %v, i64* %p, i32 %y) nounwind {
; SSE-LABEL: load_i64_v4i64:
; SSE:       # %bb.0:
; SSE-NEXT:    # kill: def $esi killed $esi def $rsi
; SSE-NEXT:    movq (%rdi), %rax
; SSE-NEXT:    movaps %xmm1, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    andl $3, %esi
; SSE-NEXT:    movq %rax, -40(%rsp,%rsi,8)
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    retq
;
; AVX1OR2-LABEL: load_i64_v4i64:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    pushq %rbp
; AVX1OR2-NEXT:    movq %rsp, %rbp
; AVX1OR2-NEXT:    andq $-32, %rsp
; AVX1OR2-NEXT:    subq $64, %rsp
; AVX1OR2-NEXT:    # kill: def $esi killed $esi def $rsi
; AVX1OR2-NEXT:    movq (%rdi), %rax
; AVX1OR2-NEXT:    vmovaps %ymm0, (%rsp)
; AVX1OR2-NEXT:    andl $3, %esi
; AVX1OR2-NEXT:    movq %rax, (%rsp,%rsi,8)
; AVX1OR2-NEXT:    vmovaps (%rsp), %ymm0
; AVX1OR2-NEXT:    movq %rbp, %rsp
; AVX1OR2-NEXT:    popq %rbp
; AVX1OR2-NEXT:    retq
;
; AVX512-LABEL: load_i64_v4i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movslq %esi, %rax
; AVX512-NEXT:    vpbroadcastq %rax, %ymm1
; AVX512-NEXT:    vpcmpeqq {{.*}}(%rip), %ymm1, %k1
; AVX512-NEXT:    vpbroadcastq (%rdi), %ymm0 {%k1}
; AVX512-NEXT:    retq
  %x = load i64, i64* %p
  %ins = insertelement <4 x i64> %v, i64 %x, i32 %y
  ret <4 x i64> %ins
}

define <8 x float> @load_f32_v8f32(<8 x float> %v, float* %p, i32 %y) nounwind {
; SSE-LABEL: load_f32_v8f32:
; SSE:       # %bb.0:
; SSE-NEXT:    # kill: def $esi killed $esi def $rsi
; SSE-NEXT:    movss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE-NEXT:    movaps %xmm1, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    andl $7, %esi
; SSE-NEXT:    movss %xmm2, -40(%rsp,%rsi,4)
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: load_f32_v8f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovd %esi, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,0,0,0]
; AVX1-NEXT:    vpcmpeqd {{.*}}(%rip), %xmm1, %xmm2
; AVX1-NEXT:    vpcmpeqd {{\.LCPI[0-9]+_[0-9]+}}+{{.*}}(%rip), %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-NEXT:    vbroadcastss (%rdi), %ymm2
; AVX1-NEXT:    vblendvps %ymm1, %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_f32_v8f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vbroadcastss (%rdi), %ymm1
; AVX2-NEXT:    vmovd %esi, %xmm2
; AVX2-NEXT:    vpbroadcastd %xmm2, %ymm2
; AVX2-NEXT:    vpcmpeqd {{.*}}(%rip), %ymm2, %ymm2
; AVX2-NEXT:    vblendvps %ymm2, %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: load_f32_v8f32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastd %esi, %ymm1
; AVX512-NEXT:    vpcmpeqd {{.*}}(%rip), %ymm1, %k1
; AVX512-NEXT:    vbroadcastss (%rdi), %ymm0 {%k1}
; AVX512-NEXT:    retq
  %x = load float, float* %p
  %ins = insertelement <8 x float> %v, float %x, i32 %y
  ret <8 x float> %ins
}

define <4 x double> @load_f64_v4f64(<4 x double> %v, double* %p, i32 %y) nounwind {
; SSE-LABEL: load_f64_v4f64:
; SSE:       # %bb.0:
; SSE-NEXT:    # kill: def $esi killed $esi def $rsi
; SSE-NEXT:    movsd {{.*#+}} xmm2 = mem[0],zero
; SSE-NEXT:    movaps %xmm1, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; SSE-NEXT:    andl $3, %esi
; SSE-NEXT:    movsd %xmm2, -40(%rsp,%rsi,8)
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: load_f64_v4f64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    movslq %esi, %rax
; AVX1-NEXT:    vmovq %rax, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,1,0,1]
; AVX1-NEXT:    vpcmpeqq {{.*}}(%rip), %xmm1, %xmm2
; AVX1-NEXT:    vpcmpeqq {{\.LCPI[0-9]+_[0-9]+}}+{{.*}}(%rip), %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-NEXT:    vbroadcastsd (%rdi), %ymm2
; AVX1-NEXT:    vblendvpd %ymm1, %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_f64_v4f64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vbroadcastsd (%rdi), %ymm1
; AVX2-NEXT:    movslq %esi, %rax
; AVX2-NEXT:    vmovq %rax, %xmm2
; AVX2-NEXT:    vpbroadcastq %xmm2, %ymm2
; AVX2-NEXT:    vpcmpeqq {{.*}}(%rip), %ymm2, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: load_f64_v4f64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movslq %esi, %rax
; AVX512-NEXT:    vpbroadcastq %rax, %ymm1
; AVX512-NEXT:    vpcmpeqq {{.*}}(%rip), %ymm1, %k1
; AVX512-NEXT:    vbroadcastsd (%rdi), %ymm0 {%k1}
; AVX512-NEXT:    retq
  %x = load double, double* %p
  %ins = insertelement <4 x double> %v, double %x, i32 %y
  ret <4 x double> %ins
}

; Don't die trying to insert to an invalid index.

define i32 @PR44139(<16 x i64>* %p) {
; ALL-LABEL: PR44139:
; ALL:       # %bb.0:
; ALL-NEXT:    movl (%rdi), %eax
; ALL-NEXT:    leal 2147483647(%rax), %ecx
; ALL-NEXT:    testl %eax, %eax
; ALL-NEXT:    cmovnsl %eax, %ecx
; ALL-NEXT:    andl $-2147483648, %ecx # imm = 0x80000000
; ALL-NEXT:    addl %eax, %ecx
; ALL-NEXT:    # kill: def $eax killed $eax killed $rax
; ALL-NEXT:    xorl %edx, %edx
; ALL-NEXT:    divl %ecx
; ALL-NEXT:    retq
  %L = load <16 x i64>, <16 x i64>* %p
  %E1 = extractelement <16 x i64> %L, i64 0
  %tempvector = insertelement <16 x i64> undef, i64 %E1, i32 0
  %vector = shufflevector <16 x i64> %tempvector, <16 x i64> undef, <16 x i32> zeroinitializer
  %C3 = icmp sgt i64 9223372036854775807, -9223372036854775808
  %t0 = trunc <16 x i64> %vector to <16 x i32>
  %I4 = insertelement <16 x i64> %vector, i64 %E1, i1 %C3
  store <16 x i64> %I4, <16 x i64>* %p
  %elt = extractelement <16 x i32> %t0, i32 0
  %B = srem i32 %elt, -2147483648
  %B9 = udiv i32 %elt, %B
  ret i32 %B9
}
