; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+experimental-zfh,+experimental-v -target-abi=ilp32d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefix=RV32
; RUN: llc -mtriple=riscv64 -mattr=+d,+experimental-zfh,+experimental-v -target-abi=lp64d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefix=RV64

define <vscale x 1 x i8> @vfptosi_nxv1f16_nxv1i8(<vscale x 1 x half> %va) {
; RV32-LABEL: vfptosi_nxv1f16_nxv1i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e8,mf8,ta,mu
; RV32-NEXT:    vfncvt.rtz.x.f.w v25, v8
; RV32-NEXT:    vmv1r.v v8, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv1f16_nxv1i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e8,mf8,ta,mu
; RV64-NEXT:    vfncvt.rtz.x.f.w v25, v8
; RV64-NEXT:    vmv1r.v v8, v25
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 1 x half> %va to <vscale x 1 x i8>
  ret <vscale x 1 x i8> %evec
}

define <vscale x 1 x i8> @vfptoui_nxv1f16_nxv1i8(<vscale x 1 x half> %va) {
; RV32-LABEL: vfptoui_nxv1f16_nxv1i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e8,mf8,ta,mu
; RV32-NEXT:    vfncvt.rtz.xu.f.w v25, v8
; RV32-NEXT:    vmv1r.v v8, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv1f16_nxv1i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e8,mf8,ta,mu
; RV64-NEXT:    vfncvt.rtz.xu.f.w v25, v8
; RV64-NEXT:    vmv1r.v v8, v25
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 1 x half> %va to <vscale x 1 x i8>
  ret <vscale x 1 x i8> %evec
}

define <vscale x 1 x i16> @vfptosi_nxv1f16_nxv1i16(<vscale x 1 x half> %va) {
; RV32-LABEL: vfptosi_nxv1f16_nxv1i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,mf4,ta,mu
; RV32-NEXT:    vfcvt.rtz.x.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv1f16_nxv1i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,mf4,ta,mu
; RV64-NEXT:    vfcvt.rtz.x.f.v v8, v8
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 1 x half> %va to <vscale x 1 x i16>
  ret <vscale x 1 x i16> %evec
}

define <vscale x 1 x i16> @vfptoui_nxv1f16_nxv1i16(<vscale x 1 x half> %va) {
; RV32-LABEL: vfptoui_nxv1f16_nxv1i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,mf4,ta,mu
; RV32-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv1f16_nxv1i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,mf4,ta,mu
; RV64-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 1 x half> %va to <vscale x 1 x i16>
  ret <vscale x 1 x i16> %evec
}

define <vscale x 1 x i32> @vfptosi_nxv1f16_nxv1i32(<vscale x 1 x half> %va) {
; RV32-LABEL: vfptosi_nxv1f16_nxv1i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,mf4,ta,mu
; RV32-NEXT:    vfwcvt.rtz.x.f.v v25, v8
; RV32-NEXT:    vmv1r.v v8, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv1f16_nxv1i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,mf4,ta,mu
; RV64-NEXT:    vfwcvt.rtz.x.f.v v25, v8
; RV64-NEXT:    vmv1r.v v8, v25
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 1 x half> %va to <vscale x 1 x i32>
  ret <vscale x 1 x i32> %evec
}

define <vscale x 1 x i32> @vfptoui_nxv1f16_nxv1i32(<vscale x 1 x half> %va) {
; RV32-LABEL: vfptoui_nxv1f16_nxv1i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,mf4,ta,mu
; RV32-NEXT:    vfwcvt.rtz.xu.f.v v25, v8
; RV32-NEXT:    vmv1r.v v8, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv1f16_nxv1i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,mf4,ta,mu
; RV64-NEXT:    vfwcvt.rtz.xu.f.v v25, v8
; RV64-NEXT:    vmv1r.v v8, v25
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 1 x half> %va to <vscale x 1 x i32>
  ret <vscale x 1 x i32> %evec
}

define <vscale x 1 x i64> @vfptosi_nxv1f16_nxv1i64(<vscale x 1 x half> %va) {
; RV32-LABEL: vfptosi_nxv1f16_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,mf4,ta,mu
; RV32-NEXT:    vfwcvt.f.f.v v25, v8
; RV32-NEXT:    vsetvli a0, zero, e32,mf2,ta,mu
; RV32-NEXT:    vfwcvt.rtz.x.f.v v8, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv1f16_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,mf4,ta,mu
; RV64-NEXT:    vfwcvt.f.f.v v25, v8
; RV64-NEXT:    vsetvli a0, zero, e32,mf2,ta,mu
; RV64-NEXT:    vfwcvt.rtz.x.f.v v8, v25
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 1 x half> %va to <vscale x 1 x i64>
  ret <vscale x 1 x i64> %evec
}

define <vscale x 1 x i64> @vfptoui_nxv1f16_nxv1i64(<vscale x 1 x half> %va) {
; RV32-LABEL: vfptoui_nxv1f16_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,mf4,ta,mu
; RV32-NEXT:    vfwcvt.f.f.v v25, v8
; RV32-NEXT:    vsetvli a0, zero, e32,mf2,ta,mu
; RV32-NEXT:    vfwcvt.rtz.xu.f.v v8, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv1f16_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,mf4,ta,mu
; RV64-NEXT:    vfwcvt.f.f.v v25, v8
; RV64-NEXT:    vsetvli a0, zero, e32,mf2,ta,mu
; RV64-NEXT:    vfwcvt.rtz.xu.f.v v8, v25
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 1 x half> %va to <vscale x 1 x i64>
  ret <vscale x 1 x i64> %evec
}

define <vscale x 2 x i8> @vfptosi_nxv2f16_nxv2i8(<vscale x 2 x half> %va) {
; RV32-LABEL: vfptosi_nxv2f16_nxv2i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e8,mf4,ta,mu
; RV32-NEXT:    vfncvt.rtz.x.f.w v25, v8
; RV32-NEXT:    vmv1r.v v8, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv2f16_nxv2i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e8,mf4,ta,mu
; RV64-NEXT:    vfncvt.rtz.x.f.w v25, v8
; RV64-NEXT:    vmv1r.v v8, v25
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 2 x half> %va to <vscale x 2 x i8>
  ret <vscale x 2 x i8> %evec
}

define <vscale x 2 x i8> @vfptoui_nxv2f16_nxv2i8(<vscale x 2 x half> %va) {
; RV32-LABEL: vfptoui_nxv2f16_nxv2i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e8,mf4,ta,mu
; RV32-NEXT:    vfncvt.rtz.xu.f.w v25, v8
; RV32-NEXT:    vmv1r.v v8, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv2f16_nxv2i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e8,mf4,ta,mu
; RV64-NEXT:    vfncvt.rtz.xu.f.w v25, v8
; RV64-NEXT:    vmv1r.v v8, v25
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 2 x half> %va to <vscale x 2 x i8>
  ret <vscale x 2 x i8> %evec
}

define <vscale x 2 x i16> @vfptosi_nxv2f16_nxv2i16(<vscale x 2 x half> %va) {
; RV32-LABEL: vfptosi_nxv2f16_nxv2i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,mf2,ta,mu
; RV32-NEXT:    vfcvt.rtz.x.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv2f16_nxv2i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,mf2,ta,mu
; RV64-NEXT:    vfcvt.rtz.x.f.v v8, v8
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 2 x half> %va to <vscale x 2 x i16>
  ret <vscale x 2 x i16> %evec
}

define <vscale x 2 x i16> @vfptoui_nxv2f16_nxv2i16(<vscale x 2 x half> %va) {
; RV32-LABEL: vfptoui_nxv2f16_nxv2i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,mf2,ta,mu
; RV32-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv2f16_nxv2i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,mf2,ta,mu
; RV64-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 2 x half> %va to <vscale x 2 x i16>
  ret <vscale x 2 x i16> %evec
}

define <vscale x 2 x i32> @vfptosi_nxv2f16_nxv2i32(<vscale x 2 x half> %va) {
; RV32-LABEL: vfptosi_nxv2f16_nxv2i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,mf2,ta,mu
; RV32-NEXT:    vfwcvt.rtz.x.f.v v25, v8
; RV32-NEXT:    vmv1r.v v8, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv2f16_nxv2i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,mf2,ta,mu
; RV64-NEXT:    vfwcvt.rtz.x.f.v v25, v8
; RV64-NEXT:    vmv1r.v v8, v25
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 2 x half> %va to <vscale x 2 x i32>
  ret <vscale x 2 x i32> %evec
}

define <vscale x 2 x i32> @vfptoui_nxv2f16_nxv2i32(<vscale x 2 x half> %va) {
; RV32-LABEL: vfptoui_nxv2f16_nxv2i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,mf2,ta,mu
; RV32-NEXT:    vfwcvt.rtz.xu.f.v v25, v8
; RV32-NEXT:    vmv1r.v v8, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv2f16_nxv2i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,mf2,ta,mu
; RV64-NEXT:    vfwcvt.rtz.xu.f.v v25, v8
; RV64-NEXT:    vmv1r.v v8, v25
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 2 x half> %va to <vscale x 2 x i32>
  ret <vscale x 2 x i32> %evec
}

define <vscale x 2 x i64> @vfptosi_nxv2f16_nxv2i64(<vscale x 2 x half> %va) {
; RV32-LABEL: vfptosi_nxv2f16_nxv2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,mf2,ta,mu
; RV32-NEXT:    vfwcvt.f.f.v v25, v8
; RV32-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; RV32-NEXT:    vfwcvt.rtz.x.f.v v8, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv2f16_nxv2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,mf2,ta,mu
; RV64-NEXT:    vfwcvt.f.f.v v25, v8
; RV64-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; RV64-NEXT:    vfwcvt.rtz.x.f.v v8, v25
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 2 x half> %va to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %evec
}

define <vscale x 2 x i64> @vfptoui_nxv2f16_nxv2i64(<vscale x 2 x half> %va) {
; RV32-LABEL: vfptoui_nxv2f16_nxv2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,mf2,ta,mu
; RV32-NEXT:    vfwcvt.f.f.v v25, v8
; RV32-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; RV32-NEXT:    vfwcvt.rtz.xu.f.v v8, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv2f16_nxv2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,mf2,ta,mu
; RV64-NEXT:    vfwcvt.f.f.v v25, v8
; RV64-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; RV64-NEXT:    vfwcvt.rtz.xu.f.v v8, v25
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 2 x half> %va to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %evec
}

define <vscale x 4 x i8> @vfptosi_nxv4f16_nxv4i8(<vscale x 4 x half> %va) {
; RV32-LABEL: vfptosi_nxv4f16_nxv4i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e8,mf2,ta,mu
; RV32-NEXT:    vfncvt.rtz.x.f.w v25, v8
; RV32-NEXT:    vmv1r.v v8, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv4f16_nxv4i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e8,mf2,ta,mu
; RV64-NEXT:    vfncvt.rtz.x.f.w v25, v8
; RV64-NEXT:    vmv1r.v v8, v25
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 4 x half> %va to <vscale x 4 x i8>
  ret <vscale x 4 x i8> %evec
}

define <vscale x 4 x i8> @vfptoui_nxv4f16_nxv4i8(<vscale x 4 x half> %va) {
; RV32-LABEL: vfptoui_nxv4f16_nxv4i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e8,mf2,ta,mu
; RV32-NEXT:    vfncvt.rtz.xu.f.w v25, v8
; RV32-NEXT:    vmv1r.v v8, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv4f16_nxv4i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e8,mf2,ta,mu
; RV64-NEXT:    vfncvt.rtz.xu.f.w v25, v8
; RV64-NEXT:    vmv1r.v v8, v25
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 4 x half> %va to <vscale x 4 x i8>
  ret <vscale x 4 x i8> %evec
}

define <vscale x 4 x i16> @vfptosi_nxv4f16_nxv4i16(<vscale x 4 x half> %va) {
; RV32-LABEL: vfptosi_nxv4f16_nxv4i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; RV32-NEXT:    vfcvt.rtz.x.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv4f16_nxv4i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; RV64-NEXT:    vfcvt.rtz.x.f.v v8, v8
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 4 x half> %va to <vscale x 4 x i16>
  ret <vscale x 4 x i16> %evec
}

define <vscale x 4 x i16> @vfptoui_nxv4f16_nxv4i16(<vscale x 4 x half> %va) {
; RV32-LABEL: vfptoui_nxv4f16_nxv4i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; RV32-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv4f16_nxv4i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; RV64-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 4 x half> %va to <vscale x 4 x i16>
  ret <vscale x 4 x i16> %evec
}

define <vscale x 4 x i32> @vfptosi_nxv4f16_nxv4i32(<vscale x 4 x half> %va) {
; RV32-LABEL: vfptosi_nxv4f16_nxv4i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; RV32-NEXT:    vfwcvt.rtz.x.f.v v26, v8
; RV32-NEXT:    vmv2r.v v8, v26
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv4f16_nxv4i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; RV64-NEXT:    vfwcvt.rtz.x.f.v v26, v8
; RV64-NEXT:    vmv2r.v v8, v26
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 4 x half> %va to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %evec
}

define <vscale x 4 x i32> @vfptoui_nxv4f16_nxv4i32(<vscale x 4 x half> %va) {
; RV32-LABEL: vfptoui_nxv4f16_nxv4i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; RV32-NEXT:    vfwcvt.rtz.xu.f.v v26, v8
; RV32-NEXT:    vmv2r.v v8, v26
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv4f16_nxv4i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; RV64-NEXT:    vfwcvt.rtz.xu.f.v v26, v8
; RV64-NEXT:    vmv2r.v v8, v26
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 4 x half> %va to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %evec
}

define <vscale x 4 x i64> @vfptosi_nxv4f16_nxv4i64(<vscale x 4 x half> %va) {
; RV32-LABEL: vfptosi_nxv4f16_nxv4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; RV32-NEXT:    vfwcvt.f.f.v v26, v8
; RV32-NEXT:    vsetvli a0, zero, e32,m2,ta,mu
; RV32-NEXT:    vfwcvt.rtz.x.f.v v8, v26
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv4f16_nxv4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; RV64-NEXT:    vfwcvt.f.f.v v26, v8
; RV64-NEXT:    vsetvli a0, zero, e32,m2,ta,mu
; RV64-NEXT:    vfwcvt.rtz.x.f.v v8, v26
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 4 x half> %va to <vscale x 4 x i64>
  ret <vscale x 4 x i64> %evec
}

define <vscale x 4 x i64> @vfptoui_nxv4f16_nxv4i64(<vscale x 4 x half> %va) {
; RV32-LABEL: vfptoui_nxv4f16_nxv4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; RV32-NEXT:    vfwcvt.f.f.v v26, v8
; RV32-NEXT:    vsetvli a0, zero, e32,m2,ta,mu
; RV32-NEXT:    vfwcvt.rtz.xu.f.v v8, v26
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv4f16_nxv4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; RV64-NEXT:    vfwcvt.f.f.v v26, v8
; RV64-NEXT:    vsetvli a0, zero, e32,m2,ta,mu
; RV64-NEXT:    vfwcvt.rtz.xu.f.v v8, v26
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 4 x half> %va to <vscale x 4 x i64>
  ret <vscale x 4 x i64> %evec
}

define <vscale x 8 x i8> @vfptosi_nxv8f16_nxv8i8(<vscale x 8 x half> %va) {
; RV32-LABEL: vfptosi_nxv8f16_nxv8i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; RV32-NEXT:    vfncvt.rtz.x.f.w v25, v8
; RV32-NEXT:    vmv1r.v v8, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv8f16_nxv8i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; RV64-NEXT:    vfncvt.rtz.x.f.w v25, v8
; RV64-NEXT:    vmv1r.v v8, v25
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 8 x half> %va to <vscale x 8 x i8>
  ret <vscale x 8 x i8> %evec
}

define <vscale x 8 x i8> @vfptoui_nxv8f16_nxv8i8(<vscale x 8 x half> %va) {
; RV32-LABEL: vfptoui_nxv8f16_nxv8i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; RV32-NEXT:    vfncvt.rtz.xu.f.w v25, v8
; RV32-NEXT:    vmv1r.v v8, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv8f16_nxv8i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; RV64-NEXT:    vfncvt.rtz.xu.f.w v25, v8
; RV64-NEXT:    vmv1r.v v8, v25
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 8 x half> %va to <vscale x 8 x i8>
  ret <vscale x 8 x i8> %evec
}

define <vscale x 8 x i16> @vfptosi_nxv8f16_nxv8i16(<vscale x 8 x half> %va) {
; RV32-LABEL: vfptosi_nxv8f16_nxv8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; RV32-NEXT:    vfcvt.rtz.x.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv8f16_nxv8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; RV64-NEXT:    vfcvt.rtz.x.f.v v8, v8
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 8 x half> %va to <vscale x 8 x i16>
  ret <vscale x 8 x i16> %evec
}

define <vscale x 8 x i16> @vfptoui_nxv8f16_nxv8i16(<vscale x 8 x half> %va) {
; RV32-LABEL: vfptoui_nxv8f16_nxv8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; RV32-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv8f16_nxv8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; RV64-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 8 x half> %va to <vscale x 8 x i16>
  ret <vscale x 8 x i16> %evec
}

define <vscale x 8 x i32> @vfptosi_nxv8f16_nxv8i32(<vscale x 8 x half> %va) {
; RV32-LABEL: vfptosi_nxv8f16_nxv8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; RV32-NEXT:    vfwcvt.rtz.x.f.v v28, v8
; RV32-NEXT:    vmv4r.v v8, v28
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv8f16_nxv8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; RV64-NEXT:    vfwcvt.rtz.x.f.v v28, v8
; RV64-NEXT:    vmv4r.v v8, v28
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 8 x half> %va to <vscale x 8 x i32>
  ret <vscale x 8 x i32> %evec
}

define <vscale x 8 x i32> @vfptoui_nxv8f16_nxv8i32(<vscale x 8 x half> %va) {
; RV32-LABEL: vfptoui_nxv8f16_nxv8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; RV32-NEXT:    vfwcvt.rtz.xu.f.v v28, v8
; RV32-NEXT:    vmv4r.v v8, v28
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv8f16_nxv8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; RV64-NEXT:    vfwcvt.rtz.xu.f.v v28, v8
; RV64-NEXT:    vmv4r.v v8, v28
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 8 x half> %va to <vscale x 8 x i32>
  ret <vscale x 8 x i32> %evec
}

define <vscale x 8 x i64> @vfptosi_nxv8f16_nxv8i64(<vscale x 8 x half> %va) {
; RV32-LABEL: vfptosi_nxv8f16_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; RV32-NEXT:    vfwcvt.f.f.v v28, v8
; RV32-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; RV32-NEXT:    vfwcvt.rtz.x.f.v v8, v28
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv8f16_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; RV64-NEXT:    vfwcvt.f.f.v v28, v8
; RV64-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; RV64-NEXT:    vfwcvt.rtz.x.f.v v8, v28
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 8 x half> %va to <vscale x 8 x i64>
  ret <vscale x 8 x i64> %evec
}

define <vscale x 8 x i64> @vfptoui_nxv8f16_nxv8i64(<vscale x 8 x half> %va) {
; RV32-LABEL: vfptoui_nxv8f16_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; RV32-NEXT:    vfwcvt.f.f.v v28, v8
; RV32-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; RV32-NEXT:    vfwcvt.rtz.xu.f.v v8, v28
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv8f16_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; RV64-NEXT:    vfwcvt.f.f.v v28, v8
; RV64-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; RV64-NEXT:    vfwcvt.rtz.xu.f.v v8, v28
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 8 x half> %va to <vscale x 8 x i64>
  ret <vscale x 8 x i64> %evec
}

define <vscale x 16 x i8> @vfptosi_nxv16f16_nxv16i8(<vscale x 16 x half> %va) {
; RV32-LABEL: vfptosi_nxv16f16_nxv16i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e8,m2,ta,mu
; RV32-NEXT:    vfncvt.rtz.x.f.w v26, v8
; RV32-NEXT:    vmv2r.v v8, v26
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv16f16_nxv16i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e8,m2,ta,mu
; RV64-NEXT:    vfncvt.rtz.x.f.w v26, v8
; RV64-NEXT:    vmv2r.v v8, v26
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 16 x half> %va to <vscale x 16 x i8>
  ret <vscale x 16 x i8> %evec
}

define <vscale x 16 x i8> @vfptoui_nxv16f16_nxv16i8(<vscale x 16 x half> %va) {
; RV32-LABEL: vfptoui_nxv16f16_nxv16i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e8,m2,ta,mu
; RV32-NEXT:    vfncvt.rtz.xu.f.w v26, v8
; RV32-NEXT:    vmv2r.v v8, v26
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv16f16_nxv16i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e8,m2,ta,mu
; RV64-NEXT:    vfncvt.rtz.xu.f.w v26, v8
; RV64-NEXT:    vmv2r.v v8, v26
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 16 x half> %va to <vscale x 16 x i8>
  ret <vscale x 16 x i8> %evec
}

define <vscale x 16 x i16> @vfptosi_nxv16f16_nxv16i16(<vscale x 16 x half> %va) {
; RV32-LABEL: vfptosi_nxv16f16_nxv16i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,m4,ta,mu
; RV32-NEXT:    vfcvt.rtz.x.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv16f16_nxv16i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,m4,ta,mu
; RV64-NEXT:    vfcvt.rtz.x.f.v v8, v8
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 16 x half> %va to <vscale x 16 x i16>
  ret <vscale x 16 x i16> %evec
}

define <vscale x 16 x i16> @vfptoui_nxv16f16_nxv16i16(<vscale x 16 x half> %va) {
; RV32-LABEL: vfptoui_nxv16f16_nxv16i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,m4,ta,mu
; RV32-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv16f16_nxv16i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,m4,ta,mu
; RV64-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 16 x half> %va to <vscale x 16 x i16>
  ret <vscale x 16 x i16> %evec
}

define <vscale x 16 x i32> @vfptosi_nxv16f16_nxv16i32(<vscale x 16 x half> %va) {
; RV32-LABEL: vfptosi_nxv16f16_nxv16i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,m4,ta,mu
; RV32-NEXT:    vfwcvt.rtz.x.f.v v16, v8
; RV32-NEXT:    vmv8r.v v8, v16
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv16f16_nxv16i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,m4,ta,mu
; RV64-NEXT:    vfwcvt.rtz.x.f.v v16, v8
; RV64-NEXT:    vmv8r.v v8, v16
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 16 x half> %va to <vscale x 16 x i32>
  ret <vscale x 16 x i32> %evec
}

define <vscale x 16 x i32> @vfptoui_nxv16f16_nxv16i32(<vscale x 16 x half> %va) {
; RV32-LABEL: vfptoui_nxv16f16_nxv16i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,m4,ta,mu
; RV32-NEXT:    vfwcvt.rtz.xu.f.v v16, v8
; RV32-NEXT:    vmv8r.v v8, v16
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv16f16_nxv16i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,m4,ta,mu
; RV64-NEXT:    vfwcvt.rtz.xu.f.v v16, v8
; RV64-NEXT:    vmv8r.v v8, v16
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 16 x half> %va to <vscale x 16 x i32>
  ret <vscale x 16 x i32> %evec
}

define <vscale x 32 x i8> @vfptosi_nxv32f16_nxv32i8(<vscale x 32 x half> %va) {
; RV32-LABEL: vfptosi_nxv32f16_nxv32i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e8,m4,ta,mu
; RV32-NEXT:    vfncvt.rtz.x.f.w v28, v8
; RV32-NEXT:    vmv4r.v v8, v28
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv32f16_nxv32i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e8,m4,ta,mu
; RV64-NEXT:    vfncvt.rtz.x.f.w v28, v8
; RV64-NEXT:    vmv4r.v v8, v28
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 32 x half> %va to <vscale x 32 x i8>
  ret <vscale x 32 x i8> %evec
}

define <vscale x 32 x i8> @vfptoui_nxv32f16_nxv32i8(<vscale x 32 x half> %va) {
; RV32-LABEL: vfptoui_nxv32f16_nxv32i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e8,m4,ta,mu
; RV32-NEXT:    vfncvt.rtz.xu.f.w v28, v8
; RV32-NEXT:    vmv4r.v v8, v28
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv32f16_nxv32i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e8,m4,ta,mu
; RV64-NEXT:    vfncvt.rtz.xu.f.w v28, v8
; RV64-NEXT:    vmv4r.v v8, v28
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 32 x half> %va to <vscale x 32 x i8>
  ret <vscale x 32 x i8> %evec
}

define <vscale x 32 x i16> @vfptosi_nxv32f16_nxv32i16(<vscale x 32 x half> %va) {
; RV32-LABEL: vfptosi_nxv32f16_nxv32i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,m8,ta,mu
; RV32-NEXT:    vfcvt.rtz.x.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv32f16_nxv32i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,m8,ta,mu
; RV64-NEXT:    vfcvt.rtz.x.f.v v8, v8
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 32 x half> %va to <vscale x 32 x i16>
  ret <vscale x 32 x i16> %evec
}

define <vscale x 32 x i16> @vfptoui_nxv32f16_nxv32i16(<vscale x 32 x half> %va) {
; RV32-LABEL: vfptoui_nxv32f16_nxv32i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,m8,ta,mu
; RV32-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv32f16_nxv32i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,m8,ta,mu
; RV64-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 32 x half> %va to <vscale x 32 x i16>
  ret <vscale x 32 x i16> %evec
}

define <vscale x 1 x i8> @vfptosi_nxv1f32_nxv1i8(<vscale x 1 x float> %va) {
; RV32-LABEL: vfptosi_nxv1f32_nxv1i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,mf4,ta,mu
; RV32-NEXT:    vfncvt.rtz.x.f.w v25, v8
; RV32-NEXT:    vsetvli a0, zero, e8,mf8,ta,mu
; RV32-NEXT:    vnsrl.wi v8, v25, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv1f32_nxv1i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,mf4,ta,mu
; RV64-NEXT:    vfncvt.rtz.x.f.w v25, v8
; RV64-NEXT:    vsetvli a0, zero, e8,mf8,ta,mu
; RV64-NEXT:    vnsrl.wi v8, v25, 0
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 1 x float> %va to <vscale x 1 x i8>
  ret <vscale x 1 x i8> %evec
}

define <vscale x 1 x i8> @vfptoui_nxv1f32_nxv1i8(<vscale x 1 x float> %va) {
; RV32-LABEL: vfptoui_nxv1f32_nxv1i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,mf4,ta,mu
; RV32-NEXT:    vfncvt.rtz.xu.f.w v25, v8
; RV32-NEXT:    vsetvli a0, zero, e8,mf8,ta,mu
; RV32-NEXT:    vnsrl.wi v8, v25, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv1f32_nxv1i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,mf4,ta,mu
; RV64-NEXT:    vfncvt.rtz.xu.f.w v25, v8
; RV64-NEXT:    vsetvli a0, zero, e8,mf8,ta,mu
; RV64-NEXT:    vnsrl.wi v8, v25, 0
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 1 x float> %va to <vscale x 1 x i8>
  ret <vscale x 1 x i8> %evec
}

define <vscale x 1 x i16> @vfptosi_nxv1f32_nxv1i16(<vscale x 1 x float> %va) {
; RV32-LABEL: vfptosi_nxv1f32_nxv1i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,mf4,ta,mu
; RV32-NEXT:    vfncvt.rtz.x.f.w v25, v8
; RV32-NEXT:    vmv1r.v v8, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv1f32_nxv1i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,mf4,ta,mu
; RV64-NEXT:    vfncvt.rtz.x.f.w v25, v8
; RV64-NEXT:    vmv1r.v v8, v25
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 1 x float> %va to <vscale x 1 x i16>
  ret <vscale x 1 x i16> %evec
}

define <vscale x 1 x i16> @vfptoui_nxv1f32_nxv1i16(<vscale x 1 x float> %va) {
; RV32-LABEL: vfptoui_nxv1f32_nxv1i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,mf4,ta,mu
; RV32-NEXT:    vfncvt.rtz.xu.f.w v25, v8
; RV32-NEXT:    vmv1r.v v8, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv1f32_nxv1i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,mf4,ta,mu
; RV64-NEXT:    vfncvt.rtz.xu.f.w v25, v8
; RV64-NEXT:    vmv1r.v v8, v25
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 1 x float> %va to <vscale x 1 x i16>
  ret <vscale x 1 x i16> %evec
}

define <vscale x 1 x i32> @vfptosi_nxv1f32_nxv1i32(<vscale x 1 x float> %va) {
; RV32-LABEL: vfptosi_nxv1f32_nxv1i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,mf2,ta,mu
; RV32-NEXT:    vfcvt.rtz.x.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv1f32_nxv1i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,mf2,ta,mu
; RV64-NEXT:    vfcvt.rtz.x.f.v v8, v8
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 1 x float> %va to <vscale x 1 x i32>
  ret <vscale x 1 x i32> %evec
}

define <vscale x 1 x i32> @vfptoui_nxv1f32_nxv1i32(<vscale x 1 x float> %va) {
; RV32-LABEL: vfptoui_nxv1f32_nxv1i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,mf2,ta,mu
; RV32-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv1f32_nxv1i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,mf2,ta,mu
; RV64-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 1 x float> %va to <vscale x 1 x i32>
  ret <vscale x 1 x i32> %evec
}

define <vscale x 1 x i64> @vfptosi_nxv1f32_nxv1i64(<vscale x 1 x float> %va) {
; RV32-LABEL: vfptosi_nxv1f32_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,mf2,ta,mu
; RV32-NEXT:    vfwcvt.rtz.x.f.v v25, v8
; RV32-NEXT:    vmv1r.v v8, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv1f32_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,mf2,ta,mu
; RV64-NEXT:    vfwcvt.rtz.x.f.v v25, v8
; RV64-NEXT:    vmv1r.v v8, v25
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 1 x float> %va to <vscale x 1 x i64>
  ret <vscale x 1 x i64> %evec
}

define <vscale x 1 x i64> @vfptoui_nxv1f32_nxv1i64(<vscale x 1 x float> %va) {
; RV32-LABEL: vfptoui_nxv1f32_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,mf2,ta,mu
; RV32-NEXT:    vfwcvt.rtz.xu.f.v v25, v8
; RV32-NEXT:    vmv1r.v v8, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv1f32_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,mf2,ta,mu
; RV64-NEXT:    vfwcvt.rtz.xu.f.v v25, v8
; RV64-NEXT:    vmv1r.v v8, v25
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 1 x float> %va to <vscale x 1 x i64>
  ret <vscale x 1 x i64> %evec
}

define <vscale x 2 x i8> @vfptosi_nxv2f32_nxv2i8(<vscale x 2 x float> %va) {
; RV32-LABEL: vfptosi_nxv2f32_nxv2i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,mf2,ta,mu
; RV32-NEXT:    vfncvt.rtz.x.f.w v25, v8
; RV32-NEXT:    vsetvli a0, zero, e8,mf4,ta,mu
; RV32-NEXT:    vnsrl.wi v8, v25, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv2f32_nxv2i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,mf2,ta,mu
; RV64-NEXT:    vfncvt.rtz.x.f.w v25, v8
; RV64-NEXT:    vsetvli a0, zero, e8,mf4,ta,mu
; RV64-NEXT:    vnsrl.wi v8, v25, 0
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 2 x float> %va to <vscale x 2 x i8>
  ret <vscale x 2 x i8> %evec
}

define <vscale x 2 x i8> @vfptoui_nxv2f32_nxv2i8(<vscale x 2 x float> %va) {
; RV32-LABEL: vfptoui_nxv2f32_nxv2i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,mf2,ta,mu
; RV32-NEXT:    vfncvt.rtz.xu.f.w v25, v8
; RV32-NEXT:    vsetvli a0, zero, e8,mf4,ta,mu
; RV32-NEXT:    vnsrl.wi v8, v25, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv2f32_nxv2i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,mf2,ta,mu
; RV64-NEXT:    vfncvt.rtz.xu.f.w v25, v8
; RV64-NEXT:    vsetvli a0, zero, e8,mf4,ta,mu
; RV64-NEXT:    vnsrl.wi v8, v25, 0
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 2 x float> %va to <vscale x 2 x i8>
  ret <vscale x 2 x i8> %evec
}

define <vscale x 2 x i16> @vfptosi_nxv2f32_nxv2i16(<vscale x 2 x float> %va) {
; RV32-LABEL: vfptosi_nxv2f32_nxv2i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,mf2,ta,mu
; RV32-NEXT:    vfncvt.rtz.x.f.w v25, v8
; RV32-NEXT:    vmv1r.v v8, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv2f32_nxv2i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,mf2,ta,mu
; RV64-NEXT:    vfncvt.rtz.x.f.w v25, v8
; RV64-NEXT:    vmv1r.v v8, v25
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 2 x float> %va to <vscale x 2 x i16>
  ret <vscale x 2 x i16> %evec
}

define <vscale x 2 x i16> @vfptoui_nxv2f32_nxv2i16(<vscale x 2 x float> %va) {
; RV32-LABEL: vfptoui_nxv2f32_nxv2i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,mf2,ta,mu
; RV32-NEXT:    vfncvt.rtz.xu.f.w v25, v8
; RV32-NEXT:    vmv1r.v v8, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv2f32_nxv2i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,mf2,ta,mu
; RV64-NEXT:    vfncvt.rtz.xu.f.w v25, v8
; RV64-NEXT:    vmv1r.v v8, v25
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 2 x float> %va to <vscale x 2 x i16>
  ret <vscale x 2 x i16> %evec
}

define <vscale x 2 x i32> @vfptosi_nxv2f32_nxv2i32(<vscale x 2 x float> %va) {
; RV32-LABEL: vfptosi_nxv2f32_nxv2i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; RV32-NEXT:    vfcvt.rtz.x.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv2f32_nxv2i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; RV64-NEXT:    vfcvt.rtz.x.f.v v8, v8
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 2 x float> %va to <vscale x 2 x i32>
  ret <vscale x 2 x i32> %evec
}

define <vscale x 2 x i32> @vfptoui_nxv2f32_nxv2i32(<vscale x 2 x float> %va) {
; RV32-LABEL: vfptoui_nxv2f32_nxv2i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; RV32-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv2f32_nxv2i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; RV64-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 2 x float> %va to <vscale x 2 x i32>
  ret <vscale x 2 x i32> %evec
}

define <vscale x 2 x i64> @vfptosi_nxv2f32_nxv2i64(<vscale x 2 x float> %va) {
; RV32-LABEL: vfptosi_nxv2f32_nxv2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; RV32-NEXT:    vfwcvt.rtz.x.f.v v26, v8
; RV32-NEXT:    vmv2r.v v8, v26
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv2f32_nxv2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; RV64-NEXT:    vfwcvt.rtz.x.f.v v26, v8
; RV64-NEXT:    vmv2r.v v8, v26
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 2 x float> %va to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %evec
}

define <vscale x 2 x i64> @vfptoui_nxv2f32_nxv2i64(<vscale x 2 x float> %va) {
; RV32-LABEL: vfptoui_nxv2f32_nxv2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; RV32-NEXT:    vfwcvt.rtz.xu.f.v v26, v8
; RV32-NEXT:    vmv2r.v v8, v26
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv2f32_nxv2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; RV64-NEXT:    vfwcvt.rtz.xu.f.v v26, v8
; RV64-NEXT:    vmv2r.v v8, v26
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 2 x float> %va to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %evec
}

define <vscale x 4 x i8> @vfptosi_nxv4f32_nxv4i8(<vscale x 4 x float> %va) {
; RV32-LABEL: vfptosi_nxv4f32_nxv4i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; RV32-NEXT:    vfncvt.rtz.x.f.w v25, v8
; RV32-NEXT:    vsetvli a0, zero, e8,mf2,ta,mu
; RV32-NEXT:    vnsrl.wi v8, v25, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv4f32_nxv4i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; RV64-NEXT:    vfncvt.rtz.x.f.w v25, v8
; RV64-NEXT:    vsetvli a0, zero, e8,mf2,ta,mu
; RV64-NEXT:    vnsrl.wi v8, v25, 0
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 4 x float> %va to <vscale x 4 x i8>
  ret <vscale x 4 x i8> %evec
}

define <vscale x 4 x i8> @vfptoui_nxv4f32_nxv4i8(<vscale x 4 x float> %va) {
; RV32-LABEL: vfptoui_nxv4f32_nxv4i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; RV32-NEXT:    vfncvt.rtz.xu.f.w v25, v8
; RV32-NEXT:    vsetvli a0, zero, e8,mf2,ta,mu
; RV32-NEXT:    vnsrl.wi v8, v25, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv4f32_nxv4i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; RV64-NEXT:    vfncvt.rtz.xu.f.w v25, v8
; RV64-NEXT:    vsetvli a0, zero, e8,mf2,ta,mu
; RV64-NEXT:    vnsrl.wi v8, v25, 0
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 4 x float> %va to <vscale x 4 x i8>
  ret <vscale x 4 x i8> %evec
}

define <vscale x 4 x i16> @vfptosi_nxv4f32_nxv4i16(<vscale x 4 x float> %va) {
; RV32-LABEL: vfptosi_nxv4f32_nxv4i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; RV32-NEXT:    vfncvt.rtz.x.f.w v25, v8
; RV32-NEXT:    vmv1r.v v8, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv4f32_nxv4i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; RV64-NEXT:    vfncvt.rtz.x.f.w v25, v8
; RV64-NEXT:    vmv1r.v v8, v25
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 4 x float> %va to <vscale x 4 x i16>
  ret <vscale x 4 x i16> %evec
}

define <vscale x 4 x i16> @vfptoui_nxv4f32_nxv4i16(<vscale x 4 x float> %va) {
; RV32-LABEL: vfptoui_nxv4f32_nxv4i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; RV32-NEXT:    vfncvt.rtz.xu.f.w v25, v8
; RV32-NEXT:    vmv1r.v v8, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv4f32_nxv4i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; RV64-NEXT:    vfncvt.rtz.xu.f.w v25, v8
; RV64-NEXT:    vmv1r.v v8, v25
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 4 x float> %va to <vscale x 4 x i16>
  ret <vscale x 4 x i16> %evec
}

define <vscale x 4 x i32> @vfptosi_nxv4f32_nxv4i32(<vscale x 4 x float> %va) {
; RV32-LABEL: vfptosi_nxv4f32_nxv4i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,m2,ta,mu
; RV32-NEXT:    vfcvt.rtz.x.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv4f32_nxv4i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,m2,ta,mu
; RV64-NEXT:    vfcvt.rtz.x.f.v v8, v8
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 4 x float> %va to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %evec
}

define <vscale x 4 x i32> @vfptoui_nxv4f32_nxv4i32(<vscale x 4 x float> %va) {
; RV32-LABEL: vfptoui_nxv4f32_nxv4i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,m2,ta,mu
; RV32-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv4f32_nxv4i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,m2,ta,mu
; RV64-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 4 x float> %va to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %evec
}

define <vscale x 4 x i64> @vfptosi_nxv4f32_nxv4i64(<vscale x 4 x float> %va) {
; RV32-LABEL: vfptosi_nxv4f32_nxv4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,m2,ta,mu
; RV32-NEXT:    vfwcvt.rtz.x.f.v v28, v8
; RV32-NEXT:    vmv4r.v v8, v28
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv4f32_nxv4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,m2,ta,mu
; RV64-NEXT:    vfwcvt.rtz.x.f.v v28, v8
; RV64-NEXT:    vmv4r.v v8, v28
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 4 x float> %va to <vscale x 4 x i64>
  ret <vscale x 4 x i64> %evec
}

define <vscale x 4 x i64> @vfptoui_nxv4f32_nxv4i64(<vscale x 4 x float> %va) {
; RV32-LABEL: vfptoui_nxv4f32_nxv4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,m2,ta,mu
; RV32-NEXT:    vfwcvt.rtz.xu.f.v v28, v8
; RV32-NEXT:    vmv4r.v v8, v28
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv4f32_nxv4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,m2,ta,mu
; RV64-NEXT:    vfwcvt.rtz.xu.f.v v28, v8
; RV64-NEXT:    vmv4r.v v8, v28
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 4 x float> %va to <vscale x 4 x i64>
  ret <vscale x 4 x i64> %evec
}

define <vscale x 8 x i8> @vfptosi_nxv8f32_nxv8i8(<vscale x 8 x float> %va) {
; RV32-LABEL: vfptosi_nxv8f32_nxv8i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; RV32-NEXT:    vfncvt.rtz.x.f.w v26, v8
; RV32-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; RV32-NEXT:    vnsrl.wi v8, v26, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv8f32_nxv8i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; RV64-NEXT:    vfncvt.rtz.x.f.w v26, v8
; RV64-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; RV64-NEXT:    vnsrl.wi v8, v26, 0
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 8 x float> %va to <vscale x 8 x i8>
  ret <vscale x 8 x i8> %evec
}

define <vscale x 8 x i8> @vfptoui_nxv8f32_nxv8i8(<vscale x 8 x float> %va) {
; RV32-LABEL: vfptoui_nxv8f32_nxv8i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; RV32-NEXT:    vfncvt.rtz.xu.f.w v26, v8
; RV32-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; RV32-NEXT:    vnsrl.wi v8, v26, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv8f32_nxv8i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; RV64-NEXT:    vfncvt.rtz.xu.f.w v26, v8
; RV64-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; RV64-NEXT:    vnsrl.wi v8, v26, 0
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 8 x float> %va to <vscale x 8 x i8>
  ret <vscale x 8 x i8> %evec
}

define <vscale x 8 x i16> @vfptosi_nxv8f32_nxv8i16(<vscale x 8 x float> %va) {
; RV32-LABEL: vfptosi_nxv8f32_nxv8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; RV32-NEXT:    vfncvt.rtz.x.f.w v26, v8
; RV32-NEXT:    vmv2r.v v8, v26
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv8f32_nxv8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; RV64-NEXT:    vfncvt.rtz.x.f.w v26, v8
; RV64-NEXT:    vmv2r.v v8, v26
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 8 x float> %va to <vscale x 8 x i16>
  ret <vscale x 8 x i16> %evec
}

define <vscale x 8 x i16> @vfptoui_nxv8f32_nxv8i16(<vscale x 8 x float> %va) {
; RV32-LABEL: vfptoui_nxv8f32_nxv8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; RV32-NEXT:    vfncvt.rtz.xu.f.w v26, v8
; RV32-NEXT:    vmv2r.v v8, v26
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv8f32_nxv8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; RV64-NEXT:    vfncvt.rtz.xu.f.w v26, v8
; RV64-NEXT:    vmv2r.v v8, v26
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 8 x float> %va to <vscale x 8 x i16>
  ret <vscale x 8 x i16> %evec
}

define <vscale x 8 x i32> @vfptosi_nxv8f32_nxv8i32(<vscale x 8 x float> %va) {
; RV32-LABEL: vfptosi_nxv8f32_nxv8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; RV32-NEXT:    vfcvt.rtz.x.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv8f32_nxv8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; RV64-NEXT:    vfcvt.rtz.x.f.v v8, v8
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 8 x float> %va to <vscale x 8 x i32>
  ret <vscale x 8 x i32> %evec
}

define <vscale x 8 x i32> @vfptoui_nxv8f32_nxv8i32(<vscale x 8 x float> %va) {
; RV32-LABEL: vfptoui_nxv8f32_nxv8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; RV32-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv8f32_nxv8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; RV64-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 8 x float> %va to <vscale x 8 x i32>
  ret <vscale x 8 x i32> %evec
}

define <vscale x 8 x i64> @vfptosi_nxv8f32_nxv8i64(<vscale x 8 x float> %va) {
; RV32-LABEL: vfptosi_nxv8f32_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; RV32-NEXT:    vfwcvt.rtz.x.f.v v16, v8
; RV32-NEXT:    vmv8r.v v8, v16
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv8f32_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; RV64-NEXT:    vfwcvt.rtz.x.f.v v16, v8
; RV64-NEXT:    vmv8r.v v8, v16
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 8 x float> %va to <vscale x 8 x i64>
  ret <vscale x 8 x i64> %evec
}

define <vscale x 8 x i64> @vfptoui_nxv8f32_nxv8i64(<vscale x 8 x float> %va) {
; RV32-LABEL: vfptoui_nxv8f32_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; RV32-NEXT:    vfwcvt.rtz.xu.f.v v16, v8
; RV32-NEXT:    vmv8r.v v8, v16
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv8f32_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; RV64-NEXT:    vfwcvt.rtz.xu.f.v v16, v8
; RV64-NEXT:    vmv8r.v v8, v16
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 8 x float> %va to <vscale x 8 x i64>
  ret <vscale x 8 x i64> %evec
}

define <vscale x 16 x i8> @vfptosi_nxv16f32_nxv16i8(<vscale x 16 x float> %va) {
; RV32-LABEL: vfptosi_nxv16f32_nxv16i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,m4,ta,mu
; RV32-NEXT:    vfncvt.rtz.x.f.w v28, v8
; RV32-NEXT:    vsetvli a0, zero, e8,m2,ta,mu
; RV32-NEXT:    vnsrl.wi v8, v28, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv16f32_nxv16i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,m4,ta,mu
; RV64-NEXT:    vfncvt.rtz.x.f.w v28, v8
; RV64-NEXT:    vsetvli a0, zero, e8,m2,ta,mu
; RV64-NEXT:    vnsrl.wi v8, v28, 0
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 16 x float> %va to <vscale x 16 x i8>
  ret <vscale x 16 x i8> %evec
}

define <vscale x 16 x i8> @vfptoui_nxv16f32_nxv16i8(<vscale x 16 x float> %va) {
; RV32-LABEL: vfptoui_nxv16f32_nxv16i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,m4,ta,mu
; RV32-NEXT:    vfncvt.rtz.xu.f.w v28, v8
; RV32-NEXT:    vsetvli a0, zero, e8,m2,ta,mu
; RV32-NEXT:    vnsrl.wi v8, v28, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv16f32_nxv16i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,m4,ta,mu
; RV64-NEXT:    vfncvt.rtz.xu.f.w v28, v8
; RV64-NEXT:    vsetvli a0, zero, e8,m2,ta,mu
; RV64-NEXT:    vnsrl.wi v8, v28, 0
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 16 x float> %va to <vscale x 16 x i8>
  ret <vscale x 16 x i8> %evec
}

define <vscale x 16 x i16> @vfptosi_nxv16f32_nxv16i16(<vscale x 16 x float> %va) {
; RV32-LABEL: vfptosi_nxv16f32_nxv16i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,m4,ta,mu
; RV32-NEXT:    vfncvt.rtz.x.f.w v28, v8
; RV32-NEXT:    vmv4r.v v8, v28
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv16f32_nxv16i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,m4,ta,mu
; RV64-NEXT:    vfncvt.rtz.x.f.w v28, v8
; RV64-NEXT:    vmv4r.v v8, v28
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 16 x float> %va to <vscale x 16 x i16>
  ret <vscale x 16 x i16> %evec
}

define <vscale x 16 x i16> @vfptoui_nxv16f32_nxv16i16(<vscale x 16 x float> %va) {
; RV32-LABEL: vfptoui_nxv16f32_nxv16i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16,m4,ta,mu
; RV32-NEXT:    vfncvt.rtz.xu.f.w v28, v8
; RV32-NEXT:    vmv4r.v v8, v28
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv16f32_nxv16i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16,m4,ta,mu
; RV64-NEXT:    vfncvt.rtz.xu.f.w v28, v8
; RV64-NEXT:    vmv4r.v v8, v28
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 16 x float> %va to <vscale x 16 x i16>
  ret <vscale x 16 x i16> %evec
}

define <vscale x 16 x i32> @vfptosi_nxv16f32_nxv16i32(<vscale x 16 x float> %va) {
; RV32-LABEL: vfptosi_nxv16f32_nxv16i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,m8,ta,mu
; RV32-NEXT:    vfcvt.rtz.x.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv16f32_nxv16i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,m8,ta,mu
; RV64-NEXT:    vfcvt.rtz.x.f.v v8, v8
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 16 x float> %va to <vscale x 16 x i32>
  ret <vscale x 16 x i32> %evec
}

define <vscale x 16 x i32> @vfptoui_nxv16f32_nxv16i32(<vscale x 16 x float> %va) {
; RV32-LABEL: vfptoui_nxv16f32_nxv16i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,m8,ta,mu
; RV32-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv16f32_nxv16i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,m8,ta,mu
; RV64-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 16 x float> %va to <vscale x 16 x i32>
  ret <vscale x 16 x i32> %evec
}

define <vscale x 1 x i8> @vfptosi_nxv1f64_nxv1i8(<vscale x 1 x double> %va) {
; RV32-LABEL: vfptosi_nxv1f64_nxv1i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,mf2,ta,mu
; RV32-NEXT:    vfncvt.rtz.x.f.w v25, v8
; RV32-NEXT:    vsetvli a0, zero, e16,mf4,ta,mu
; RV32-NEXT:    vnsrl.wi v26, v25, 0
; RV32-NEXT:    vsetvli a0, zero, e8,mf8,ta,mu
; RV32-NEXT:    vnsrl.wi v8, v26, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv1f64_nxv1i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,mf2,ta,mu
; RV64-NEXT:    vfncvt.rtz.x.f.w v25, v8
; RV64-NEXT:    vsetvli a0, zero, e16,mf4,ta,mu
; RV64-NEXT:    vnsrl.wi v26, v25, 0
; RV64-NEXT:    vsetvli a0, zero, e8,mf8,ta,mu
; RV64-NEXT:    vnsrl.wi v8, v26, 0
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 1 x double> %va to <vscale x 1 x i8>
  ret <vscale x 1 x i8> %evec
}

define <vscale x 1 x i8> @vfptoui_nxv1f64_nxv1i8(<vscale x 1 x double> %va) {
; RV32-LABEL: vfptoui_nxv1f64_nxv1i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,mf2,ta,mu
; RV32-NEXT:    vfncvt.rtz.xu.f.w v25, v8
; RV32-NEXT:    vsetvli a0, zero, e16,mf4,ta,mu
; RV32-NEXT:    vnsrl.wi v26, v25, 0
; RV32-NEXT:    vsetvli a0, zero, e8,mf8,ta,mu
; RV32-NEXT:    vnsrl.wi v8, v26, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv1f64_nxv1i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,mf2,ta,mu
; RV64-NEXT:    vfncvt.rtz.xu.f.w v25, v8
; RV64-NEXT:    vsetvli a0, zero, e16,mf4,ta,mu
; RV64-NEXT:    vnsrl.wi v26, v25, 0
; RV64-NEXT:    vsetvli a0, zero, e8,mf8,ta,mu
; RV64-NEXT:    vnsrl.wi v8, v26, 0
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 1 x double> %va to <vscale x 1 x i8>
  ret <vscale x 1 x i8> %evec
}

define <vscale x 1 x i16> @vfptosi_nxv1f64_nxv1i16(<vscale x 1 x double> %va) {
; RV32-LABEL: vfptosi_nxv1f64_nxv1i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,mf2,ta,mu
; RV32-NEXT:    vfncvt.rtz.x.f.w v25, v8
; RV32-NEXT:    vsetvli a0, zero, e16,mf4,ta,mu
; RV32-NEXT:    vnsrl.wi v8, v25, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv1f64_nxv1i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,mf2,ta,mu
; RV64-NEXT:    vfncvt.rtz.x.f.w v25, v8
; RV64-NEXT:    vsetvli a0, zero, e16,mf4,ta,mu
; RV64-NEXT:    vnsrl.wi v8, v25, 0
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 1 x double> %va to <vscale x 1 x i16>
  ret <vscale x 1 x i16> %evec
}

define <vscale x 1 x i16> @vfptoui_nxv1f64_nxv1i16(<vscale x 1 x double> %va) {
; RV32-LABEL: vfptoui_nxv1f64_nxv1i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,mf2,ta,mu
; RV32-NEXT:    vfncvt.rtz.xu.f.w v25, v8
; RV32-NEXT:    vsetvli a0, zero, e16,mf4,ta,mu
; RV32-NEXT:    vnsrl.wi v8, v25, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv1f64_nxv1i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,mf2,ta,mu
; RV64-NEXT:    vfncvt.rtz.xu.f.w v25, v8
; RV64-NEXT:    vsetvli a0, zero, e16,mf4,ta,mu
; RV64-NEXT:    vnsrl.wi v8, v25, 0
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 1 x double> %va to <vscale x 1 x i16>
  ret <vscale x 1 x i16> %evec
}

define <vscale x 1 x i32> @vfptosi_nxv1f64_nxv1i32(<vscale x 1 x double> %va) {
; RV32-LABEL: vfptosi_nxv1f64_nxv1i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,mf2,ta,mu
; RV32-NEXT:    vfncvt.rtz.x.f.w v25, v8
; RV32-NEXT:    vmv1r.v v8, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv1f64_nxv1i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,mf2,ta,mu
; RV64-NEXT:    vfncvt.rtz.x.f.w v25, v8
; RV64-NEXT:    vmv1r.v v8, v25
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 1 x double> %va to <vscale x 1 x i32>
  ret <vscale x 1 x i32> %evec
}

define <vscale x 1 x i32> @vfptoui_nxv1f64_nxv1i32(<vscale x 1 x double> %va) {
; RV32-LABEL: vfptoui_nxv1f64_nxv1i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,mf2,ta,mu
; RV32-NEXT:    vfncvt.rtz.xu.f.w v25, v8
; RV32-NEXT:    vmv1r.v v8, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv1f64_nxv1i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,mf2,ta,mu
; RV64-NEXT:    vfncvt.rtz.xu.f.w v25, v8
; RV64-NEXT:    vmv1r.v v8, v25
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 1 x double> %va to <vscale x 1 x i32>
  ret <vscale x 1 x i32> %evec
}

define <vscale x 1 x i64> @vfptosi_nxv1f64_nxv1i64(<vscale x 1 x double> %va) {
; RV32-LABEL: vfptosi_nxv1f64_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vfcvt.rtz.x.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv1f64_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vfcvt.rtz.x.f.v v8, v8
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 1 x double> %va to <vscale x 1 x i64>
  ret <vscale x 1 x i64> %evec
}

define <vscale x 1 x i64> @vfptoui_nxv1f64_nxv1i64(<vscale x 1 x double> %va) {
; RV32-LABEL: vfptoui_nxv1f64_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv1f64_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 1 x double> %va to <vscale x 1 x i64>
  ret <vscale x 1 x i64> %evec
}

define <vscale x 2 x i8> @vfptosi_nxv2f64_nxv2i8(<vscale x 2 x double> %va) {
; RV32-LABEL: vfptosi_nxv2f64_nxv2i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; RV32-NEXT:    vfncvt.rtz.x.f.w v25, v8
; RV32-NEXT:    vsetvli a0, zero, e16,mf2,ta,mu
; RV32-NEXT:    vnsrl.wi v26, v25, 0
; RV32-NEXT:    vsetvli a0, zero, e8,mf4,ta,mu
; RV32-NEXT:    vnsrl.wi v8, v26, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv2f64_nxv2i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; RV64-NEXT:    vfncvt.rtz.x.f.w v25, v8
; RV64-NEXT:    vsetvli a0, zero, e16,mf2,ta,mu
; RV64-NEXT:    vnsrl.wi v26, v25, 0
; RV64-NEXT:    vsetvli a0, zero, e8,mf4,ta,mu
; RV64-NEXT:    vnsrl.wi v8, v26, 0
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 2 x double> %va to <vscale x 2 x i8>
  ret <vscale x 2 x i8> %evec
}

define <vscale x 2 x i8> @vfptoui_nxv2f64_nxv2i8(<vscale x 2 x double> %va) {
; RV32-LABEL: vfptoui_nxv2f64_nxv2i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; RV32-NEXT:    vfncvt.rtz.xu.f.w v25, v8
; RV32-NEXT:    vsetvli a0, zero, e16,mf2,ta,mu
; RV32-NEXT:    vnsrl.wi v26, v25, 0
; RV32-NEXT:    vsetvli a0, zero, e8,mf4,ta,mu
; RV32-NEXT:    vnsrl.wi v8, v26, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv2f64_nxv2i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; RV64-NEXT:    vfncvt.rtz.xu.f.w v25, v8
; RV64-NEXT:    vsetvli a0, zero, e16,mf2,ta,mu
; RV64-NEXT:    vnsrl.wi v26, v25, 0
; RV64-NEXT:    vsetvli a0, zero, e8,mf4,ta,mu
; RV64-NEXT:    vnsrl.wi v8, v26, 0
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 2 x double> %va to <vscale x 2 x i8>
  ret <vscale x 2 x i8> %evec
}

define <vscale x 2 x i16> @vfptosi_nxv2f64_nxv2i16(<vscale x 2 x double> %va) {
; RV32-LABEL: vfptosi_nxv2f64_nxv2i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; RV32-NEXT:    vfncvt.rtz.x.f.w v25, v8
; RV32-NEXT:    vsetvli a0, zero, e16,mf2,ta,mu
; RV32-NEXT:    vnsrl.wi v8, v25, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv2f64_nxv2i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; RV64-NEXT:    vfncvt.rtz.x.f.w v25, v8
; RV64-NEXT:    vsetvli a0, zero, e16,mf2,ta,mu
; RV64-NEXT:    vnsrl.wi v8, v25, 0
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 2 x double> %va to <vscale x 2 x i16>
  ret <vscale x 2 x i16> %evec
}

define <vscale x 2 x i16> @vfptoui_nxv2f64_nxv2i16(<vscale x 2 x double> %va) {
; RV32-LABEL: vfptoui_nxv2f64_nxv2i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; RV32-NEXT:    vfncvt.rtz.xu.f.w v25, v8
; RV32-NEXT:    vsetvli a0, zero, e16,mf2,ta,mu
; RV32-NEXT:    vnsrl.wi v8, v25, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv2f64_nxv2i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; RV64-NEXT:    vfncvt.rtz.xu.f.w v25, v8
; RV64-NEXT:    vsetvli a0, zero, e16,mf2,ta,mu
; RV64-NEXT:    vnsrl.wi v8, v25, 0
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 2 x double> %va to <vscale x 2 x i16>
  ret <vscale x 2 x i16> %evec
}

define <vscale x 2 x i32> @vfptosi_nxv2f64_nxv2i32(<vscale x 2 x double> %va) {
; RV32-LABEL: vfptosi_nxv2f64_nxv2i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; RV32-NEXT:    vfncvt.rtz.x.f.w v25, v8
; RV32-NEXT:    vmv1r.v v8, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv2f64_nxv2i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; RV64-NEXT:    vfncvt.rtz.x.f.w v25, v8
; RV64-NEXT:    vmv1r.v v8, v25
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 2 x double> %va to <vscale x 2 x i32>
  ret <vscale x 2 x i32> %evec
}

define <vscale x 2 x i32> @vfptoui_nxv2f64_nxv2i32(<vscale x 2 x double> %va) {
; RV32-LABEL: vfptoui_nxv2f64_nxv2i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; RV32-NEXT:    vfncvt.rtz.xu.f.w v25, v8
; RV32-NEXT:    vmv1r.v v8, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv2f64_nxv2i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; RV64-NEXT:    vfncvt.rtz.xu.f.w v25, v8
; RV64-NEXT:    vmv1r.v v8, v25
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 2 x double> %va to <vscale x 2 x i32>
  ret <vscale x 2 x i32> %evec
}

define <vscale x 2 x i64> @vfptosi_nxv2f64_nxv2i64(<vscale x 2 x double> %va) {
; RV32-LABEL: vfptosi_nxv2f64_nxv2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e64,m2,ta,mu
; RV32-NEXT:    vfcvt.rtz.x.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv2f64_nxv2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64,m2,ta,mu
; RV64-NEXT:    vfcvt.rtz.x.f.v v8, v8
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 2 x double> %va to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %evec
}

define <vscale x 2 x i64> @vfptoui_nxv2f64_nxv2i64(<vscale x 2 x double> %va) {
; RV32-LABEL: vfptoui_nxv2f64_nxv2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e64,m2,ta,mu
; RV32-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv2f64_nxv2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64,m2,ta,mu
; RV64-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 2 x double> %va to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %evec
}

define <vscale x 4 x i8> @vfptosi_nxv4f64_nxv4i8(<vscale x 4 x double> %va) {
; RV32-LABEL: vfptosi_nxv4f64_nxv4i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,m2,ta,mu
; RV32-NEXT:    vfncvt.rtz.x.f.w v26, v8
; RV32-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; RV32-NEXT:    vnsrl.wi v25, v26, 0
; RV32-NEXT:    vsetvli a0, zero, e8,mf2,ta,mu
; RV32-NEXT:    vnsrl.wi v8, v25, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv4f64_nxv4i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,m2,ta,mu
; RV64-NEXT:    vfncvt.rtz.x.f.w v26, v8
; RV64-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; RV64-NEXT:    vnsrl.wi v25, v26, 0
; RV64-NEXT:    vsetvli a0, zero, e8,mf2,ta,mu
; RV64-NEXT:    vnsrl.wi v8, v25, 0
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 4 x double> %va to <vscale x 4 x i8>
  ret <vscale x 4 x i8> %evec
}

define <vscale x 4 x i8> @vfptoui_nxv4f64_nxv4i8(<vscale x 4 x double> %va) {
; RV32-LABEL: vfptoui_nxv4f64_nxv4i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,m2,ta,mu
; RV32-NEXT:    vfncvt.rtz.xu.f.w v26, v8
; RV32-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; RV32-NEXT:    vnsrl.wi v25, v26, 0
; RV32-NEXT:    vsetvli a0, zero, e8,mf2,ta,mu
; RV32-NEXT:    vnsrl.wi v8, v25, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv4f64_nxv4i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,m2,ta,mu
; RV64-NEXT:    vfncvt.rtz.xu.f.w v26, v8
; RV64-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; RV64-NEXT:    vnsrl.wi v25, v26, 0
; RV64-NEXT:    vsetvli a0, zero, e8,mf2,ta,mu
; RV64-NEXT:    vnsrl.wi v8, v25, 0
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 4 x double> %va to <vscale x 4 x i8>
  ret <vscale x 4 x i8> %evec
}

define <vscale x 4 x i16> @vfptosi_nxv4f64_nxv4i16(<vscale x 4 x double> %va) {
; RV32-LABEL: vfptosi_nxv4f64_nxv4i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,m2,ta,mu
; RV32-NEXT:    vfncvt.rtz.x.f.w v26, v8
; RV32-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; RV32-NEXT:    vnsrl.wi v8, v26, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv4f64_nxv4i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,m2,ta,mu
; RV64-NEXT:    vfncvt.rtz.x.f.w v26, v8
; RV64-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; RV64-NEXT:    vnsrl.wi v8, v26, 0
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 4 x double> %va to <vscale x 4 x i16>
  ret <vscale x 4 x i16> %evec
}

define <vscale x 4 x i16> @vfptoui_nxv4f64_nxv4i16(<vscale x 4 x double> %va) {
; RV32-LABEL: vfptoui_nxv4f64_nxv4i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,m2,ta,mu
; RV32-NEXT:    vfncvt.rtz.xu.f.w v26, v8
; RV32-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; RV32-NEXT:    vnsrl.wi v8, v26, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv4f64_nxv4i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,m2,ta,mu
; RV64-NEXT:    vfncvt.rtz.xu.f.w v26, v8
; RV64-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; RV64-NEXT:    vnsrl.wi v8, v26, 0
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 4 x double> %va to <vscale x 4 x i16>
  ret <vscale x 4 x i16> %evec
}

define <vscale x 4 x i32> @vfptosi_nxv4f64_nxv4i32(<vscale x 4 x double> %va) {
; RV32-LABEL: vfptosi_nxv4f64_nxv4i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,m2,ta,mu
; RV32-NEXT:    vfncvt.rtz.x.f.w v26, v8
; RV32-NEXT:    vmv2r.v v8, v26
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv4f64_nxv4i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,m2,ta,mu
; RV64-NEXT:    vfncvt.rtz.x.f.w v26, v8
; RV64-NEXT:    vmv2r.v v8, v26
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 4 x double> %va to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %evec
}

define <vscale x 4 x i32> @vfptoui_nxv4f64_nxv4i32(<vscale x 4 x double> %va) {
; RV32-LABEL: vfptoui_nxv4f64_nxv4i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,m2,ta,mu
; RV32-NEXT:    vfncvt.rtz.xu.f.w v26, v8
; RV32-NEXT:    vmv2r.v v8, v26
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv4f64_nxv4i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,m2,ta,mu
; RV64-NEXT:    vfncvt.rtz.xu.f.w v26, v8
; RV64-NEXT:    vmv2r.v v8, v26
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 4 x double> %va to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %evec
}

define <vscale x 4 x i64> @vfptosi_nxv4f64_nxv4i64(<vscale x 4 x double> %va) {
; RV32-LABEL: vfptosi_nxv4f64_nxv4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e64,m4,ta,mu
; RV32-NEXT:    vfcvt.rtz.x.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv4f64_nxv4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64,m4,ta,mu
; RV64-NEXT:    vfcvt.rtz.x.f.v v8, v8
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 4 x double> %va to <vscale x 4 x i64>
  ret <vscale x 4 x i64> %evec
}

define <vscale x 4 x i64> @vfptoui_nxv4f64_nxv4i64(<vscale x 4 x double> %va) {
; RV32-LABEL: vfptoui_nxv4f64_nxv4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e64,m4,ta,mu
; RV32-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv4f64_nxv4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64,m4,ta,mu
; RV64-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 4 x double> %va to <vscale x 4 x i64>
  ret <vscale x 4 x i64> %evec
}

define <vscale x 8 x i8> @vfptosi_nxv8f64_nxv8i8(<vscale x 8 x double> %va) {
; RV32-LABEL: vfptosi_nxv8f64_nxv8i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; RV32-NEXT:    vfncvt.rtz.x.f.w v28, v8
; RV32-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; RV32-NEXT:    vnsrl.wi v26, v28, 0
; RV32-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; RV32-NEXT:    vnsrl.wi v8, v26, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv8f64_nxv8i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; RV64-NEXT:    vfncvt.rtz.x.f.w v28, v8
; RV64-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; RV64-NEXT:    vnsrl.wi v26, v28, 0
; RV64-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; RV64-NEXT:    vnsrl.wi v8, v26, 0
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 8 x double> %va to <vscale x 8 x i8>
  ret <vscale x 8 x i8> %evec
}

define <vscale x 8 x i8> @vfptoui_nxv8f64_nxv8i8(<vscale x 8 x double> %va) {
; RV32-LABEL: vfptoui_nxv8f64_nxv8i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; RV32-NEXT:    vfncvt.rtz.xu.f.w v28, v8
; RV32-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; RV32-NEXT:    vnsrl.wi v26, v28, 0
; RV32-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; RV32-NEXT:    vnsrl.wi v8, v26, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv8f64_nxv8i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; RV64-NEXT:    vfncvt.rtz.xu.f.w v28, v8
; RV64-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; RV64-NEXT:    vnsrl.wi v26, v28, 0
; RV64-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; RV64-NEXT:    vnsrl.wi v8, v26, 0
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 8 x double> %va to <vscale x 8 x i8>
  ret <vscale x 8 x i8> %evec
}

define <vscale x 8 x i16> @vfptosi_nxv8f64_nxv8i16(<vscale x 8 x double> %va) {
; RV32-LABEL: vfptosi_nxv8f64_nxv8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; RV32-NEXT:    vfncvt.rtz.x.f.w v28, v8
; RV32-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; RV32-NEXT:    vnsrl.wi v8, v28, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv8f64_nxv8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; RV64-NEXT:    vfncvt.rtz.x.f.w v28, v8
; RV64-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; RV64-NEXT:    vnsrl.wi v8, v28, 0
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 8 x double> %va to <vscale x 8 x i16>
  ret <vscale x 8 x i16> %evec
}

define <vscale x 8 x i16> @vfptoui_nxv8f64_nxv8i16(<vscale x 8 x double> %va) {
; RV32-LABEL: vfptoui_nxv8f64_nxv8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; RV32-NEXT:    vfncvt.rtz.xu.f.w v28, v8
; RV32-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; RV32-NEXT:    vnsrl.wi v8, v28, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv8f64_nxv8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; RV64-NEXT:    vfncvt.rtz.xu.f.w v28, v8
; RV64-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; RV64-NEXT:    vnsrl.wi v8, v28, 0
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 8 x double> %va to <vscale x 8 x i16>
  ret <vscale x 8 x i16> %evec
}

define <vscale x 8 x i32> @vfptosi_nxv8f64_nxv8i32(<vscale x 8 x double> %va) {
; RV32-LABEL: vfptosi_nxv8f64_nxv8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; RV32-NEXT:    vfncvt.rtz.x.f.w v28, v8
; RV32-NEXT:    vmv4r.v v8, v28
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv8f64_nxv8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; RV64-NEXT:    vfncvt.rtz.x.f.w v28, v8
; RV64-NEXT:    vmv4r.v v8, v28
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 8 x double> %va to <vscale x 8 x i32>
  ret <vscale x 8 x i32> %evec
}

define <vscale x 8 x i32> @vfptoui_nxv8f64_nxv8i32(<vscale x 8 x double> %va) {
; RV32-LABEL: vfptoui_nxv8f64_nxv8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; RV32-NEXT:    vfncvt.rtz.xu.f.w v28, v8
; RV32-NEXT:    vmv4r.v v8, v28
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv8f64_nxv8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; RV64-NEXT:    vfncvt.rtz.xu.f.w v28, v8
; RV64-NEXT:    vmv4r.v v8, v28
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 8 x double> %va to <vscale x 8 x i32>
  ret <vscale x 8 x i32> %evec
}

define <vscale x 8 x i64> @vfptosi_nxv8f64_nxv8i64(<vscale x 8 x double> %va) {
; RV32-LABEL: vfptosi_nxv8f64_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; RV32-NEXT:    vfcvt.rtz.x.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptosi_nxv8f64_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; RV64-NEXT:    vfcvt.rtz.x.f.v v8, v8
; RV64-NEXT:    ret
  %evec = fptosi <vscale x 8 x double> %va to <vscale x 8 x i64>
  ret <vscale x 8 x i64> %evec
}

define <vscale x 8 x i64> @vfptoui_nxv8f64_nxv8i64(<vscale x 8 x double> %va) {
; RV32-LABEL: vfptoui_nxv8f64_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; RV32-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vfptoui_nxv8f64_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; RV64-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; RV64-NEXT:    ret
  %evec = fptoui <vscale x 8 x double> %va to <vscale x 8 x i64>
  ret <vscale x 8 x i64> %evec
}

