; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-P10,CHECK-P10-LE
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-P10,CHECK-P10-BE
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-PREP10
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-PREP10

@GlobLd128 = dso_local local_unnamed_addr global [20 x fp128] zeroinitializer, align 16
@GlobSt128 = dso_local local_unnamed_addr global [20 x fp128] zeroinitializer, align 16

; Function Attrs: norecurse nounwind readonly willreturn
define dso_local fp128 @ld_0___float128___float128(i64 %ptr) {
; CHECK-LABEL: ld_0___float128___float128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lxv v2, 0(r3)
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to fp128*
  %1 = load fp128, fp128* %0, align 16
  ret fp128 %1
}

; Function Attrs: norecurse nounwind readonly willreturn
define dso_local fp128 @ld_unalign16___float128___float128(i8* nocapture readonly %ptr) {
; CHECK-LABEL: ld_unalign16___float128___float128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi r3, r3, 1
; CHECK-NEXT:    lxvx v2, 0, r3
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1
  %0 = bitcast i8* %add.ptr to fp128*
  %1 = load fp128, fp128* %0, align 16
  ret fp128 %1
}

; Function Attrs: norecurse nounwind readonly willreturn
define dso_local fp128 @ld_align16___float128___float128(i8* nocapture readonly %ptr) {
; CHECK-LABEL: ld_align16___float128___float128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi r3, r3, 8
; CHECK-NEXT:    lxvx v2, 0, r3
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 8
  %0 = bitcast i8* %add.ptr to fp128*
  %1 = load fp128, fp128* %0, align 16
  ret fp128 %1
}

; Function Attrs: norecurse nounwind readonly willreturn
define dso_local fp128 @ld_unalign32___float128___float128(i8* nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_unalign32___float128___float128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 99999
; CHECK-P10-NEXT:    lxvx v2, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_unalign32___float128___float128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1
; CHECK-PREP10-NEXT:    ori r4, r4, 34463
; CHECK-PREP10-NEXT:    lxvx v2, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 99999
  %0 = bitcast i8* %add.ptr to fp128*
  %1 = load fp128, fp128* %0, align 16
  ret fp128 %1
}

; Function Attrs: norecurse nounwind readonly willreturn
define dso_local fp128 @ld_align32___float128___float128(i8* nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32___float128___float128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    lxvx v2, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align32___float128___float128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    lxvx v2, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 99999000
  %0 = bitcast i8* %add.ptr to fp128*
  %1 = load fp128, fp128* %0, align 16
  ret fp128 %1
}

; Function Attrs: norecurse nounwind readonly willreturn
define dso_local fp128 @ld_unalign64___float128___float128(i8* nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_unalign64___float128___float128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    lxvx v2, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_unalign64___float128___float128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    lxvx v2, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1000000000001
  %0 = bitcast i8* %add.ptr to fp128*
  %1 = load fp128, fp128* %0, align 16
  ret fp128 %1
}

; Function Attrs: norecurse nounwind readonly willreturn
define dso_local fp128 @ld_align64___float128___float128(i8* nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64___float128___float128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lxvx v2, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align64___float128___float128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lxvx v2, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1000000000000
  %0 = bitcast i8* %add.ptr to fp128*
  %1 = load fp128, fp128* %0, align 16
  ret fp128 %1
}

; Function Attrs: norecurse nounwind readonly willreturn
define dso_local fp128 @ld_reg___float128___float128(i8* nocapture readonly %ptr, i64 %off) {
; CHECK-LABEL: ld_reg___float128___float128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lxvx v2, r3, r4
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 %off
  %0 = bitcast i8* %add.ptr to fp128*
  %1 = load fp128, fp128* %0, align 16
  ret fp128 %1
}

; Function Attrs: norecurse nounwind readonly willreturn
define dso_local fp128 @ld_or___float128___float128(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or___float128___float128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    lxvx v2, 0, r3
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to fp128*
  %1 = load fp128, fp128* %0, align 16
  ret fp128 %1
}

; Function Attrs: norecurse nounwind readonly willreturn
define dso_local fp128 @ld_or2___float128___float128(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or2___float128___float128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    lxvx v2, r3, r4
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = zext i8 %off to i64
  %or = or i64 %and, %conv
  %0 = inttoptr i64 %or to fp128*
  %1 = load fp128, fp128* %0, align 16
  ret fp128 %1
}

; Function Attrs: norecurse nounwind readonly willreturn
define dso_local fp128 @ld_not_disjoint16___float128___float128(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint16___float128___float128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    lxvx v2, 0, r3
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to fp128*
  %1 = load fp128, fp128* %0, align 16
  ret fp128 %1
}

; Function Attrs: norecurse nounwind readonly willreturn
define dso_local fp128 @ld_disjoint_unalign16___float128___float128(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_unalign16___float128___float128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    lxvx v2, 0, r3
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 6
  %0 = inttoptr i64 %or to fp128*
  %1 = load fp128, fp128* %0, align 16
  ret fp128 %1
}

; Function Attrs: norecurse nounwind readonly willreturn
define dso_local fp128 @ld_disjoint_align16___float128___float128(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_align16___float128___float128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    ori r3, r3, 24
; CHECK-NEXT:    lxvx v2, 0, r3
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to fp128*
  %1 = load fp128, fp128* %0, align 16
  ret fp128 %1
}

; Function Attrs: norecurse nounwind readonly willreturn
define dso_local fp128 @ld_not_disjoint32___float128___float128(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint32___float128___float128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    lxvx v2, 0, r3
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to fp128*
  %1 = load fp128, fp128* %0, align 16
  ret fp128 %1
}

; Function Attrs: norecurse nounwind readonly willreturn
define dso_local fp128 @ld_disjoint_unalign32___float128___float128(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_unalign32___float128___float128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 43
; CHECK-P10-NEXT:    pli r4, 99999
; CHECK-P10-NEXT:    lxvx v2, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_unalign32___float128___float128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 43
; CHECK-PREP10-NEXT:    ori r4, r4, 34463
; CHECK-PREP10-NEXT:    lxvx v2, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1048576
  %or = or i64 %and, 99999
  %0 = inttoptr i64 %or to fp128*
  %1 = load fp128, fp128* %0, align 16
  ret fp128 %1
}

; Function Attrs: norecurse nounwind readonly willreturn
define dso_local fp128 @ld_disjoint_align32___float128___float128(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32___float128___float128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    lxvx v2, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align32___float128___float128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, -15264
; CHECK-PREP10-NEXT:    and r3, r3, r4
; CHECK-PREP10-NEXT:    lis r4, 15258
; CHECK-PREP10-NEXT:    ori r4, r4, 41712
; CHECK-PREP10-NEXT:    lxvx v2, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to fp128*
  %1 = load fp128, fp128* %0, align 16
  ret fp128 %1
}

; Function Attrs: norecurse nounwind readonly willreturn
define dso_local fp128 @ld_not_disjoint64___float128___float128(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64___float128___float128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lxvx v2, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_not_disjoint64___float128___float128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    lxvx v2, 0, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to fp128*
  %1 = load fp128, fp128* %0, align 16
  ret fp128 %1
}

; Function Attrs: norecurse nounwind readonly willreturn
define dso_local fp128 @ld_disjoint_unalign64___float128___float128(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_unalign64___float128___float128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    lxvx v2, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_unalign64___float128___float128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    lxvx v2, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000001
  %0 = inttoptr i64 %or to fp128*
  %1 = load fp128, fp128* %0, align 16
  ret fp128 %1
}

; Function Attrs: norecurse nounwind readonly willreturn
define dso_local fp128 @ld_disjoint_align64___float128___float128(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64___float128___float128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lxvx v2, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align64___float128___float128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lxvx v2, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to fp128*
  %1 = load fp128, fp128* %0, align 4096
  ret fp128 %1
}

; Function Attrs: norecurse nounwind readonly willreturn
define dso_local fp128 @ld_cst_unalign16___float128___float128() {
; CHECK-LABEL: ld_cst_unalign16___float128___float128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    li r3, 255
; CHECK-NEXT:    lxvx v2, 0, r3
; CHECK-NEXT:    blr
entry:
  %0 = load fp128, fp128* inttoptr (i64 255 to fp128*), align 16
  ret fp128 %0
}

; Function Attrs: norecurse nounwind readonly willreturn
define dso_local fp128 @ld_cst_align16___float128___float128() {
; CHECK-LABEL: ld_cst_align16___float128___float128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lxv v2, 4080(0)
; CHECK-NEXT:    blr
entry:
  %0 = load fp128, fp128* inttoptr (i64 4080 to fp128*), align 16
  ret fp128 %0
}

; Function Attrs: norecurse nounwind readonly willreturn
define dso_local fp128 @ld_cst_unalign32___float128___float128() {
; CHECK-P10-LABEL: ld_cst_unalign32___float128___float128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 99999
; CHECK-P10-NEXT:    lxvx v2, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_unalign32___float128___float128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 1
; CHECK-PREP10-NEXT:    ori r3, r3, 34463
; CHECK-PREP10-NEXT:    lxvx v2, 0, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load fp128, fp128* inttoptr (i64 99999 to fp128*), align 16
  ret fp128 %0
}

; Function Attrs: norecurse nounwind readonly willreturn
define dso_local fp128 @ld_cst_align32___float128___float128() {
; CHECK-P10-LABEL: ld_cst_align32___float128___float128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 9999900
; CHECK-P10-NEXT:    lxvx v2, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align32___float128___float128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 152
; CHECK-PREP10-NEXT:    ori r3, r3, 38428
; CHECK-PREP10-NEXT:    lxvx v2, 0, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load fp128, fp128* inttoptr (i64 9999900 to fp128*), align 16
  ret fp128 %0
}

; Function Attrs: norecurse nounwind readonly willreturn
define dso_local fp128 @ld_cst_unalign64___float128___float128() {
; CHECK-P10-LABEL: ld_cst_unalign64___float128___float128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 232
; CHECK-P10-NEXT:    pli r4, 3567587329
; CHECK-P10-NEXT:    rldimi r4, r3, 32, 0
; CHECK-P10-NEXT:    lxvx v2, 0, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_unalign64___float128___float128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r3, 29
; CHECK-PREP10-NEXT:    rldic r3, r3, 35, 24
; CHECK-PREP10-NEXT:    oris r3, r3, 54437
; CHECK-PREP10-NEXT:    ori r3, r3, 4097
; CHECK-PREP10-NEXT:    lxvx v2, 0, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load fp128, fp128* inttoptr (i64 1000000000001 to fp128*), align 16
  ret fp128 %0
}

; Function Attrs: norecurse nounwind readonly willreturn
define dso_local fp128 @ld_cst_align64___float128___float128() {
; CHECK-P10-LABEL: ld_cst_align64___float128___float128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lxvx v2, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align64___float128___float128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    lxvx v2, 0, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load fp128, fp128* inttoptr (i64 1000000000000 to fp128*), align 4096
  ret fp128 %0
}

; Function Attrs: nofree norecurse nounwind willreturn writeonly
define dso_local void @st_0___float128___float128(i64 %ptr, fp128 %str) {
; CHECK-LABEL: st_0___float128___float128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stxv v2, 0(r3)
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to fp128*
  store fp128 %str, fp128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind willreturn writeonly
define dso_local void @st_unalign16___float128___float128(i8* nocapture %ptr, fp128 %str) {
; CHECK-LABEL: st_unalign16___float128___float128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi r3, r3, 1
; CHECK-NEXT:    stxvx v2, 0, r3
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1
  %0 = bitcast i8* %add.ptr to fp128*
  store fp128 %str, fp128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind willreturn writeonly
define dso_local void @st_align16___float128___float128(i8* nocapture %ptr, fp128 %str) {
; CHECK-LABEL: st_align16___float128___float128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi r3, r3, 8
; CHECK-NEXT:    stxvx v2, 0, r3
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 8
  %0 = bitcast i8* %add.ptr to fp128*
  store fp128 %str, fp128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind willreturn writeonly
define dso_local void @st_unalign32___float128___float128(i8* nocapture %ptr, fp128 %str) {
; CHECK-P10-LABEL: st_unalign32___float128___float128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 99999
; CHECK-P10-NEXT:    stxvx v2, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_unalign32___float128___float128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1
; CHECK-PREP10-NEXT:    ori r4, r4, 34463
; CHECK-PREP10-NEXT:    stxvx v2, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 99999
  %0 = bitcast i8* %add.ptr to fp128*
  store fp128 %str, fp128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind willreturn writeonly
define dso_local void @st_align32___float128___float128(i8* nocapture %ptr, fp128 %str) {
; CHECK-P10-LABEL: st_align32___float128___float128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    stxvx v2, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align32___float128___float128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    stxvx v2, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 99999000
  %0 = bitcast i8* %add.ptr to fp128*
  store fp128 %str, fp128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind willreturn writeonly
define dso_local void @st_unalign64___float128___float128(i8* nocapture %ptr, fp128 %str) {
; CHECK-P10-LABEL: st_unalign64___float128___float128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    stxvx v2, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_unalign64___float128___float128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    stxvx v2, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1000000000001
  %0 = bitcast i8* %add.ptr to fp128*
  store fp128 %str, fp128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind willreturn writeonly
define dso_local void @st_align64___float128___float128(i8* nocapture %ptr, fp128 %str) {
; CHECK-P10-LABEL: st_align64___float128___float128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stxvx v2, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align64___float128___float128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    stxvx v2, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1000000000000
  %0 = bitcast i8* %add.ptr to fp128*
  store fp128 %str, fp128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind willreturn writeonly
define dso_local void @st_reg___float128___float128(i8* nocapture %ptr, i64 %off, fp128 %str) {
; CHECK-LABEL: st_reg___float128___float128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stxvx v2, r3, r4
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 %off
  %0 = bitcast i8* %add.ptr to fp128*
  store fp128 %str, fp128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind willreturn writeonly
define dso_local void @st_or1___float128___float128(i64 %ptr, i8 zeroext %off, fp128 %str) {
; CHECK-LABEL: st_or1___float128___float128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    stxvx v2, 0, r3
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to fp128*
  store fp128 %str, fp128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind willreturn writeonly
define dso_local void @st_or2___float128___float128(i64 %ptr, i8 zeroext %off, fp128 %str) {
; CHECK-LABEL: st_or2___float128___float128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    stxvx v2, r3, r4
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = zext i8 %off to i64
  %or = or i64 %and, %conv
  %0 = inttoptr i64 %or to fp128*
  store fp128 %str, fp128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind willreturn writeonly
define dso_local void @st_not_disjoint16___float128___float128(i64 %ptr, fp128 %str) {
; CHECK-LABEL: st_not_disjoint16___float128___float128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    stxvx v2, 0, r3
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to fp128*
  store fp128 %str, fp128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind willreturn writeonly
define dso_local void @st_disjoint_unalign16___float128___float128(i64 %ptr, fp128 %str) {
; CHECK-LABEL: st_disjoint_unalign16___float128___float128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    stxvx v2, 0, r3
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 6
  %0 = inttoptr i64 %or to fp128*
  store fp128 %str, fp128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind willreturn writeonly
define dso_local void @st_disjoint_align16___float128___float128(i64 %ptr, fp128 %str) {
; CHECK-LABEL: st_disjoint_align16___float128___float128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    ori r3, r3, 24
; CHECK-NEXT:    stxvx v2, 0, r3
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to fp128*
  store fp128 %str, fp128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind willreturn writeonly
define dso_local void @st_not_disjoint32___float128___float128(i64 %ptr, fp128 %str) {
; CHECK-LABEL: st_not_disjoint32___float128___float128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    stxvx v2, 0, r3
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to fp128*
  store fp128 %str, fp128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind willreturn writeonly
define dso_local void @st_disjoint_unalign32___float128___float128(i64 %ptr, fp128 %str) {
; CHECK-P10-LABEL: st_disjoint_unalign32___float128___float128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 43
; CHECK-P10-NEXT:    pli r4, 99999
; CHECK-P10-NEXT:    stxvx v2, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_unalign32___float128___float128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 43
; CHECK-PREP10-NEXT:    ori r4, r4, 34463
; CHECK-PREP10-NEXT:    stxvx v2, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1048576
  %or = or i64 %and, 99999
  %0 = inttoptr i64 %or to fp128*
  store fp128 %str, fp128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind willreturn writeonly
define dso_local void @st_disjoint_align32___float128___float128(i64 %ptr, fp128 %str) {
; CHECK-P10-LABEL: st_disjoint_align32___float128___float128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    stxvx v2, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_align32___float128___float128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, -15264
; CHECK-PREP10-NEXT:    and r3, r3, r4
; CHECK-PREP10-NEXT:    lis r4, 15258
; CHECK-PREP10-NEXT:    ori r4, r4, 41712
; CHECK-PREP10-NEXT:    stxvx v2, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to fp128*
  store fp128 %str, fp128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind willreturn writeonly
define dso_local void @st_not_disjoint64___float128___float128(i64 %ptr, fp128 %str) {
; CHECK-P10-LABEL: st_not_disjoint64___float128___float128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    stxvx v2, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_not_disjoint64___float128___float128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    stxvx v2, 0, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to fp128*
  store fp128 %str, fp128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind willreturn writeonly
define dso_local void @st_disjoint_unalign64___float128___float128(i64 %ptr, fp128 %str) {
; CHECK-P10-LABEL: st_disjoint_unalign64___float128___float128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    stxvx v2, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_unalign64___float128___float128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    stxvx v2, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000001
  %0 = inttoptr i64 %or to fp128*
  store fp128 %str, fp128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind willreturn writeonly
define dso_local void @st_disjoint_align64___float128___float128(i64 %ptr, fp128 %str) {
; CHECK-P10-LABEL: st_disjoint_align64___float128___float128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stxvx v2, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_align64___float128___float128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    stxvx v2, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to fp128*
  store fp128 %str, fp128* %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind willreturn writeonly
define dso_local void @st_cst_unalign16___float128___float128(fp128 %str) {
; CHECK-LABEL: st_cst_unalign16___float128___float128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    li r3, 255
; CHECK-NEXT:    stxvx v2, 0, r3
; CHECK-NEXT:    blr
entry:
  store fp128 %str, fp128* inttoptr (i64 255 to fp128*), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind willreturn writeonly
define dso_local void @st_cst_align16___float128___float128(fp128 %str) {
; CHECK-LABEL: st_cst_align16___float128___float128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stxv v2, 4080(0)
; CHECK-NEXT:    blr
entry:
  store fp128 %str, fp128* inttoptr (i64 4080 to fp128*), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind willreturn writeonly
define dso_local void @st_cst_unalign32___float128___float128(fp128 %str) {
; CHECK-P10-LABEL: st_cst_unalign32___float128___float128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 99999
; CHECK-P10-NEXT:    stxvx v2, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_cst_unalign32___float128___float128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 1
; CHECK-PREP10-NEXT:    ori r3, r3, 34463
; CHECK-PREP10-NEXT:    stxvx v2, 0, r3
; CHECK-PREP10-NEXT:    blr
entry:
  store fp128 %str, fp128* inttoptr (i64 99999 to fp128*), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind willreturn writeonly
define dso_local void @st_cst_align32___float128___float128(fp128 %str) {
; CHECK-P10-LABEL: st_cst_align32___float128___float128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 9999900
; CHECK-P10-NEXT:    stxvx v2, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_cst_align32___float128___float128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 152
; CHECK-PREP10-NEXT:    ori r3, r3, 38428
; CHECK-PREP10-NEXT:    stxvx v2, 0, r3
; CHECK-PREP10-NEXT:    blr
entry:
  store fp128 %str, fp128* inttoptr (i64 9999900 to fp128*), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind willreturn writeonly
define dso_local void @st_cst_unalign64___float128___float128(fp128 %str) {
; CHECK-P10-LABEL: st_cst_unalign64___float128___float128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 232
; CHECK-P10-NEXT:    pli r4, 3567587329
; CHECK-P10-NEXT:    rldimi r4, r3, 32, 0
; CHECK-P10-NEXT:    stxvx v2, 0, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_cst_unalign64___float128___float128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r3, 29
; CHECK-PREP10-NEXT:    rldic r3, r3, 35, 24
; CHECK-PREP10-NEXT:    oris r3, r3, 54437
; CHECK-PREP10-NEXT:    ori r3, r3, 4097
; CHECK-PREP10-NEXT:    stxvx v2, 0, r3
; CHECK-PREP10-NEXT:    blr
entry:
  store fp128 %str, fp128* inttoptr (i64 1000000000001 to fp128*), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind willreturn writeonly
define dso_local void @st_cst_align64___float128___float128(fp128 %str) {
; CHECK-P10-LABEL: st_cst_align64___float128___float128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    stxvx v2, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_cst_align64___float128___float128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    stxvx v2, 0, r3
; CHECK-PREP10-NEXT:    blr
entry:
  store fp128 %str, fp128* inttoptr (i64 1000000000000 to fp128*), align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind willreturn
define dso_local void @testGlob128PtrPlus0() {
; CHECK-P10-LE-LABEL: testGlob128PtrPlus0:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plxv vs0, GlobLd128@PCREL(0), 1
; CHECK-P10-LE-NEXT:    pstxv vs0, GlobSt128@PCREL(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob128PtrPlus0:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd128@toc@ha
; CHECK-P10-BE-NEXT:    addi r3, r3, GlobLd128@toc@l
; CHECK-P10-BE-NEXT:    lxvx vs0, 0, r3
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobSt128@toc@ha
; CHECK-P10-BE-NEXT:    addi r3, r3, GlobSt128@toc@l
; CHECK-P10-BE-NEXT:    stxvx vs0, 0, r3
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-PREP10-LABEL: testGlob128PtrPlus0:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    addis r3, r2, GlobLd128@toc@ha
; CHECK-PREP10-NEXT:    addi r3, r3, GlobLd128@toc@l
; CHECK-PREP10-NEXT:    lxvx vs0, 0, r3
; CHECK-PREP10-NEXT:    addis r3, r2, GlobSt128@toc@ha
; CHECK-PREP10-NEXT:    addi r3, r3, GlobSt128@toc@l
; CHECK-PREP10-NEXT:    stxvx vs0, 0, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load fp128, fp128* getelementptr inbounds ([20 x fp128], [20 x fp128]* @GlobLd128, i64 0, i64 0), align 16
  store fp128 %0, fp128* getelementptr inbounds ([20 x fp128], [20 x fp128]* @GlobSt128, i64 0, i64 0), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind willreturn
define dso_local void @testGlob128PtrPlus3() {
; CHECK-P10-LE-LABEL: testGlob128PtrPlus3:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plxv vs0, GlobLd128@PCREL+3(0), 1
; CHECK-P10-LE-NEXT:    pstxv vs0, GlobSt128@PCREL+3(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob128PtrPlus3:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd128@toc@ha
; CHECK-P10-BE-NEXT:    li r4, 3
; CHECK-P10-BE-NEXT:    addi r3, r3, GlobLd128@toc@l
; CHECK-P10-BE-NEXT:    lxvx vs0, r3, r4
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobSt128@toc@ha
; CHECK-P10-BE-NEXT:    addi r3, r3, GlobSt128@toc@l
; CHECK-P10-BE-NEXT:    stxvx vs0, r3, r4
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-PREP10-LABEL: testGlob128PtrPlus3:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    addis r3, r2, GlobLd128@toc@ha
; CHECK-PREP10-NEXT:    li r4, 3
; CHECK-PREP10-NEXT:    addi r3, r3, GlobLd128@toc@l
; CHECK-PREP10-NEXT:    lxvx vs0, r3, r4
; CHECK-PREP10-NEXT:    addis r3, r2, GlobSt128@toc@ha
; CHECK-PREP10-NEXT:    addi r3, r3, GlobSt128@toc@l
; CHECK-PREP10-NEXT:    stxvx vs0, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load fp128, fp128* bitcast (i8* getelementptr inbounds (i8, i8* bitcast ([20 x fp128]* @GlobLd128 to i8*), i64 3) to fp128*), align 16
  store fp128 %0, fp128* bitcast (i8* getelementptr inbounds (i8, i8* bitcast ([20 x fp128]* @GlobSt128 to i8*), i64 3) to fp128*), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind willreturn
define dso_local void @testGlob128PtrPlus4() {
; CHECK-P10-LE-LABEL: testGlob128PtrPlus4:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plxv vs0, GlobLd128@PCREL+4(0), 1
; CHECK-P10-LE-NEXT:    pstxv vs0, GlobSt128@PCREL+4(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob128PtrPlus4:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd128@toc@ha
; CHECK-P10-BE-NEXT:    li r4, 4
; CHECK-P10-BE-NEXT:    addi r3, r3, GlobLd128@toc@l
; CHECK-P10-BE-NEXT:    lxvx vs0, r3, r4
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobSt128@toc@ha
; CHECK-P10-BE-NEXT:    addi r3, r3, GlobSt128@toc@l
; CHECK-P10-BE-NEXT:    stxvx vs0, r3, r4
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-PREP10-LABEL: testGlob128PtrPlus4:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    addis r3, r2, GlobLd128@toc@ha
; CHECK-PREP10-NEXT:    li r4, 4
; CHECK-PREP10-NEXT:    addi r3, r3, GlobLd128@toc@l
; CHECK-PREP10-NEXT:    lxvx vs0, r3, r4
; CHECK-PREP10-NEXT:    addis r3, r2, GlobSt128@toc@ha
; CHECK-PREP10-NEXT:    addi r3, r3, GlobSt128@toc@l
; CHECK-PREP10-NEXT:    stxvx vs0, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load fp128, fp128* bitcast (i8* getelementptr inbounds (i8, i8* bitcast ([20 x fp128]* @GlobLd128 to i8*), i64 4) to fp128*), align 16
  store fp128 %0, fp128* bitcast (i8* getelementptr inbounds (i8, i8* bitcast ([20 x fp128]* @GlobSt128 to i8*), i64 4) to fp128*), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind willreturn
define dso_local void @testGlob128PtrPlus16() {
; CHECK-P10-LE-LABEL: testGlob128PtrPlus16:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plxv vs0, GlobLd128@PCREL+16(0), 1
; CHECK-P10-LE-NEXT:    pstxv vs0, GlobSt128@PCREL+16(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob128PtrPlus16:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd128@toc@ha
; CHECK-P10-BE-NEXT:    addi r3, r3, GlobLd128@toc@l
; CHECK-P10-BE-NEXT:    lxv vs0, 16(r3)
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobSt128@toc@ha
; CHECK-P10-BE-NEXT:    addi r3, r3, GlobSt128@toc@l
; CHECK-P10-BE-NEXT:    stxv vs0, 16(r3)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-PREP10-LABEL: testGlob128PtrPlus16:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    addis r3, r2, GlobLd128@toc@ha
; CHECK-PREP10-NEXT:    addi r3, r3, GlobLd128@toc@l
; CHECK-PREP10-NEXT:    lxv vs0, 16(r3)
; CHECK-PREP10-NEXT:    addis r3, r2, GlobSt128@toc@ha
; CHECK-PREP10-NEXT:    addi r3, r3, GlobSt128@toc@l
; CHECK-PREP10-NEXT:    stxv vs0, 16(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load fp128, fp128* getelementptr inbounds ([20 x fp128], [20 x fp128]* @GlobLd128, i64 0, i64 1), align 16
  store fp128 %0, fp128* getelementptr inbounds ([20 x fp128], [20 x fp128]* @GlobSt128, i64 0, i64 1), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind willreturn
define dso_local void @testGlob128PtrPlusVar(i64 %Idx) {
; CHECK-P10-LE-LABEL: testGlob128PtrPlusVar:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    sldi r3, r3, 4
; CHECK-P10-LE-NEXT:    paddi r4, 0, GlobLd128@PCREL, 1
; CHECK-P10-LE-NEXT:    lxvx vs0, r4, r3
; CHECK-P10-LE-NEXT:    paddi r4, 0, GlobSt128@PCREL, 1
; CHECK-P10-LE-NEXT:    stxvx vs0, r4, r3
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob128PtrPlusVar:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobLd128@toc@ha
; CHECK-P10-BE-NEXT:    sldi r3, r3, 4
; CHECK-P10-BE-NEXT:    addi r4, r4, GlobLd128@toc@l
; CHECK-P10-BE-NEXT:    lxvx vs0, r4, r3
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt128@toc@ha
; CHECK-P10-BE-NEXT:    addi r4, r4, GlobSt128@toc@l
; CHECK-P10-BE-NEXT:    stxvx vs0, r4, r3
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-PREP10-LABEL: testGlob128PtrPlusVar:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    addis r4, r2, GlobLd128@toc@ha
; CHECK-PREP10-NEXT:    sldi r3, r3, 4
; CHECK-PREP10-NEXT:    addi r4, r4, GlobLd128@toc@l
; CHECK-PREP10-NEXT:    lxvx vs0, r4, r3
; CHECK-PREP10-NEXT:    addis r4, r2, GlobSt128@toc@ha
; CHECK-PREP10-NEXT:    addi r4, r4, GlobSt128@toc@l
; CHECK-PREP10-NEXT:    stxvx vs0, r4, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds [20 x fp128], [20 x fp128]* @GlobLd128, i64 0, i64 %Idx
  %0 = load fp128, fp128* %arrayidx, align 16
  %arrayidx1 = getelementptr inbounds [20 x fp128], [20 x fp128]* @GlobSt128, i64 0, i64 %Idx
  store fp128 %0, fp128* %arrayidx1, align 16
  ret void
}

