; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -march=amdgcn -mcpu=verde -verify-machineinstrs < %s | FileCheck -check-prefixes=VERDE %s
; RUN: llc -march=amdgcn -mcpu=fiji -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck -check-prefixes=FIJI %s
; RUN: llc -march=amdgcn -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX6789 %s
; RUN: llc -march=amdgcn -mcpu=gfx900 -mattr=-enable-prt-strict-null -verify-machineinstrs < %s | FileCheck -check-prefixes=NOPRT %s
; RUN: llc -march=amdgcn -mcpu=gfx1010 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10PLUS,GFX10 %s
; RUN: llc -march=amdgcn -mcpu=gfx1100 -amdgpu-enable-delay-alu=0 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10PLUS,GFX11 %s

define amdgpu_ps <4 x float> @load_1d(<8 x i32> inreg %rsrc, i32 %s) {
; VERDE-LABEL: load_1d:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_load v[0:3], v0, s[0:7] dmask:0xf unorm
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_1d:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_load v[0:3], v0, s[0:7] dmask:0xf unorm
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_1d:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_load v[0:3], v0, s[0:7] dmask:0xf unorm
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_1d:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_load v[0:3], v0, s[0:7] dmask:0xf unorm
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: load_1d:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    image_load v[0:3], v0, s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D unorm
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.load.1d.v4f32.i32(i32 15, i32 %s, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @load_1d_tfe(<8 x i32> inreg %rsrc, i32 addrspace(1)* inreg %out, i32 %s) {
; VERDE-LABEL: load_1d_tfe:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    v_mov_b32_e32 v5, v0
; VERDE-NEXT:    v_mov_b32_e32 v0, 0
; VERDE-NEXT:    v_mov_b32_e32 v1, v0
; VERDE-NEXT:    v_mov_b32_e32 v2, v0
; VERDE-NEXT:    v_mov_b32_e32 v3, v0
; VERDE-NEXT:    v_mov_b32_e32 v4, v0
; VERDE-NEXT:    image_load v[0:4], v5, s[0:7] dmask:0xf unorm tfe
; VERDE-NEXT:    s_mov_b32 s11, 0xf000
; VERDE-NEXT:    s_mov_b32 s10, -1
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    buffer_store_dword v4, off, s[8:11], 0
; VERDE-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_1d_tfe:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    v_mov_b32_e32 v5, v0
; FIJI-NEXT:    v_mov_b32_e32 v0, 0
; FIJI-NEXT:    v_mov_b32_e32 v1, v0
; FIJI-NEXT:    v_mov_b32_e32 v2, v0
; FIJI-NEXT:    v_mov_b32_e32 v3, v0
; FIJI-NEXT:    v_mov_b32_e32 v4, v0
; FIJI-NEXT:    image_load v[0:4], v5, s[0:7] dmask:0xf unorm tfe
; FIJI-NEXT:    s_mov_b32 s11, 0xf000
; FIJI-NEXT:    s_mov_b32 s10, -1
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    buffer_store_dword v4, off, s[8:11], 0
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_1d_tfe:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    v_mov_b32_e32 v6, 0
; GFX6789-NEXT:    v_mov_b32_e32 v5, v0
; GFX6789-NEXT:    v_mov_b32_e32 v7, v6
; GFX6789-NEXT:    v_mov_b32_e32 v8, v6
; GFX6789-NEXT:    v_mov_b32_e32 v9, v6
; GFX6789-NEXT:    v_mov_b32_e32 v10, v6
; GFX6789-NEXT:    v_mov_b32_e32 v0, v6
; GFX6789-NEXT:    v_mov_b32_e32 v1, v7
; GFX6789-NEXT:    v_mov_b32_e32 v2, v8
; GFX6789-NEXT:    v_mov_b32_e32 v3, v9
; GFX6789-NEXT:    v_mov_b32_e32 v4, v10
; GFX6789-NEXT:    image_load v[0:4], v5, s[0:7] dmask:0xf unorm tfe
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    global_store_dword v6, v4, s[8:9]
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_1d_tfe:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    v_mov_b32_e32 v4, 0
; NOPRT-NEXT:    image_load v[0:4], v0, s[0:7] dmask:0xf unorm tfe
; NOPRT-NEXT:    v_mov_b32_e32 v5, 0
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    global_store_dword v5, v4, s[8:9]
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: load_1d_tfe:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    v_mov_b32_e32 v6, 0
; GFX10-NEXT:    v_mov_b32_e32 v5, v0
; GFX10-NEXT:    v_mov_b32_e32 v7, v6
; GFX10-NEXT:    v_mov_b32_e32 v8, v6
; GFX10-NEXT:    v_mov_b32_e32 v9, v6
; GFX10-NEXT:    v_mov_b32_e32 v10, v6
; GFX10-NEXT:    v_mov_b32_e32 v0, v6
; GFX10-NEXT:    v_mov_b32_e32 v1, v7
; GFX10-NEXT:    v_mov_b32_e32 v2, v8
; GFX10-NEXT:    v_mov_b32_e32 v3, v9
; GFX10-NEXT:    v_mov_b32_e32 v4, v10
; GFX10-NEXT:    image_load v[0:4], v5, s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D unorm tfe
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    global_store_dword v6, v4, s[8:9]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: load_1d_tfe:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v6, 0
; GFX11-NEXT:    v_mov_b32_e32 v5, v0
; GFX11-NEXT:    v_mov_b32_e32 v7, v6
; GFX11-NEXT:    v_mov_b32_e32 v8, v6
; GFX11-NEXT:    v_mov_b32_e32 v9, v6
; GFX11-NEXT:    v_mov_b32_e32 v10, v6
; GFX11-NEXT:    v_mov_b32_e32 v0, v6
; GFX11-NEXT:    v_mov_b32_e32 v1, v7
; GFX11-NEXT:    v_mov_b32_e32 v2, v8
; GFX11-NEXT:    v_mov_b32_e32 v3, v9
; GFX11-NEXT:    v_mov_b32_e32 v4, v10
; GFX11-NEXT:    image_load v[0:4], v5, s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D unorm tfe
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b32 v6, v4, s[8:9]
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ; return to shader part epilog
main_body:
  %v = call {<4 x float>,i32} @llvm.amdgcn.image.load.1d.v4f32i32.i32(i32 15, i32 %s, <8 x i32> %rsrc, i32 1, i32 0)
  %v.vec = extractvalue {<4 x float>, i32} %v, 0
  %v.err = extractvalue {<4 x float>, i32} %v, 1
  store i32 %v.err, i32 addrspace(1)* %out, align 4
  ret <4 x float> %v.vec
}

define amdgpu_ps <4 x float> @load_1d_lwe(<8 x i32> inreg %rsrc, i32 addrspace(1)* inreg %out, i32 %s) {
; VERDE-LABEL: load_1d_lwe:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    v_mov_b32_e32 v5, v0
; VERDE-NEXT:    v_mov_b32_e32 v0, 0
; VERDE-NEXT:    v_mov_b32_e32 v1, v0
; VERDE-NEXT:    v_mov_b32_e32 v2, v0
; VERDE-NEXT:    v_mov_b32_e32 v3, v0
; VERDE-NEXT:    v_mov_b32_e32 v4, v0
; VERDE-NEXT:    image_load v[0:4], v5, s[0:7] dmask:0xf unorm lwe
; VERDE-NEXT:    s_mov_b32 s11, 0xf000
; VERDE-NEXT:    s_mov_b32 s10, -1
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    buffer_store_dword v4, off, s[8:11], 0
; VERDE-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_1d_lwe:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    v_mov_b32_e32 v5, v0
; FIJI-NEXT:    v_mov_b32_e32 v0, 0
; FIJI-NEXT:    v_mov_b32_e32 v1, v0
; FIJI-NEXT:    v_mov_b32_e32 v2, v0
; FIJI-NEXT:    v_mov_b32_e32 v3, v0
; FIJI-NEXT:    v_mov_b32_e32 v4, v0
; FIJI-NEXT:    image_load v[0:4], v5, s[0:7] dmask:0xf unorm lwe
; FIJI-NEXT:    s_mov_b32 s11, 0xf000
; FIJI-NEXT:    s_mov_b32 s10, -1
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    buffer_store_dword v4, off, s[8:11], 0
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_1d_lwe:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    v_mov_b32_e32 v6, 0
; GFX6789-NEXT:    v_mov_b32_e32 v5, v0
; GFX6789-NEXT:    v_mov_b32_e32 v7, v6
; GFX6789-NEXT:    v_mov_b32_e32 v8, v6
; GFX6789-NEXT:    v_mov_b32_e32 v9, v6
; GFX6789-NEXT:    v_mov_b32_e32 v10, v6
; GFX6789-NEXT:    v_mov_b32_e32 v0, v6
; GFX6789-NEXT:    v_mov_b32_e32 v1, v7
; GFX6789-NEXT:    v_mov_b32_e32 v2, v8
; GFX6789-NEXT:    v_mov_b32_e32 v3, v9
; GFX6789-NEXT:    v_mov_b32_e32 v4, v10
; GFX6789-NEXT:    image_load v[0:4], v5, s[0:7] dmask:0xf unorm lwe
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    global_store_dword v6, v4, s[8:9]
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_1d_lwe:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    v_mov_b32_e32 v4, 0
; NOPRT-NEXT:    image_load v[0:4], v0, s[0:7] dmask:0xf unorm lwe
; NOPRT-NEXT:    v_mov_b32_e32 v5, 0
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    global_store_dword v5, v4, s[8:9]
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: load_1d_lwe:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    v_mov_b32_e32 v6, 0
; GFX10-NEXT:    v_mov_b32_e32 v5, v0
; GFX10-NEXT:    v_mov_b32_e32 v7, v6
; GFX10-NEXT:    v_mov_b32_e32 v8, v6
; GFX10-NEXT:    v_mov_b32_e32 v9, v6
; GFX10-NEXT:    v_mov_b32_e32 v10, v6
; GFX10-NEXT:    v_mov_b32_e32 v0, v6
; GFX10-NEXT:    v_mov_b32_e32 v1, v7
; GFX10-NEXT:    v_mov_b32_e32 v2, v8
; GFX10-NEXT:    v_mov_b32_e32 v3, v9
; GFX10-NEXT:    v_mov_b32_e32 v4, v10
; GFX10-NEXT:    image_load v[0:4], v5, s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D unorm lwe
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    global_store_dword v6, v4, s[8:9]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: load_1d_lwe:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v6, 0
; GFX11-NEXT:    v_mov_b32_e32 v5, v0
; GFX11-NEXT:    v_mov_b32_e32 v7, v6
; GFX11-NEXT:    v_mov_b32_e32 v8, v6
; GFX11-NEXT:    v_mov_b32_e32 v9, v6
; GFX11-NEXT:    v_mov_b32_e32 v10, v6
; GFX11-NEXT:    v_mov_b32_e32 v0, v6
; GFX11-NEXT:    v_mov_b32_e32 v1, v7
; GFX11-NEXT:    v_mov_b32_e32 v2, v8
; GFX11-NEXT:    v_mov_b32_e32 v3, v9
; GFX11-NEXT:    v_mov_b32_e32 v4, v10
; GFX11-NEXT:    image_load v[0:4], v5, s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D unorm lwe
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b32 v6, v4, s[8:9]
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ; return to shader part epilog
main_body:
  %v = call {<4 x float>, i32} @llvm.amdgcn.image.load.1d.v4f32i32.i32(i32 15, i32 %s, <8 x i32> %rsrc, i32 2, i32 0)
  %v.vec = extractvalue {<4 x float>, i32} %v, 0
  %v.err = extractvalue {<4 x float>, i32} %v, 1
  store i32 %v.err, i32 addrspace(1)* %out, align 4
  ret <4 x float> %v.vec
}

define amdgpu_ps <4 x float> @load_2d(<8 x i32> inreg %rsrc, i32 %s, i32 %t) {
; VERDE-LABEL: load_2d:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_load v[0:3], v[0:1], s[0:7] dmask:0xf unorm
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_2d:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_load v[0:3], v[0:1], s[0:7] dmask:0xf unorm
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_2d:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_load v[0:3], v[0:1], s[0:7] dmask:0xf unorm
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_2d:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_load v[0:3], v[0:1], s[0:7] dmask:0xf unorm
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: load_2d:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    image_load v[0:3], v[0:1], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_2D unorm
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.load.2d.v4f32.i32(i32 15, i32 %s, i32 %t, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @load_2d_tfe(<8 x i32> inreg %rsrc, i32 addrspace(1)* inreg %out, i32 %s, i32 %t) {
; VERDE-LABEL: load_2d_tfe:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    v_mov_b32_e32 v5, v0
; VERDE-NEXT:    v_mov_b32_e32 v0, 0
; VERDE-NEXT:    v_mov_b32_e32 v6, v1
; VERDE-NEXT:    v_mov_b32_e32 v1, v0
; VERDE-NEXT:    v_mov_b32_e32 v2, v0
; VERDE-NEXT:    v_mov_b32_e32 v3, v0
; VERDE-NEXT:    v_mov_b32_e32 v4, v0
; VERDE-NEXT:    image_load v[0:4], v[5:6], s[0:7] dmask:0xf unorm tfe
; VERDE-NEXT:    s_mov_b32 s11, 0xf000
; VERDE-NEXT:    s_mov_b32 s10, -1
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    buffer_store_dword v4, off, s[8:11], 0
; VERDE-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_2d_tfe:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    v_mov_b32_e32 v5, v0
; FIJI-NEXT:    v_mov_b32_e32 v0, 0
; FIJI-NEXT:    v_mov_b32_e32 v6, v1
; FIJI-NEXT:    v_mov_b32_e32 v1, v0
; FIJI-NEXT:    v_mov_b32_e32 v2, v0
; FIJI-NEXT:    v_mov_b32_e32 v3, v0
; FIJI-NEXT:    v_mov_b32_e32 v4, v0
; FIJI-NEXT:    image_load v[0:4], v[5:6], s[0:7] dmask:0xf unorm tfe
; FIJI-NEXT:    s_mov_b32 s11, 0xf000
; FIJI-NEXT:    s_mov_b32 s10, -1
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    buffer_store_dword v4, off, s[8:11], 0
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_2d_tfe:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    v_mov_b32_e32 v7, 0
; GFX6789-NEXT:    v_mov_b32_e32 v6, v1
; GFX6789-NEXT:    v_mov_b32_e32 v5, v0
; GFX6789-NEXT:    v_mov_b32_e32 v8, v7
; GFX6789-NEXT:    v_mov_b32_e32 v9, v7
; GFX6789-NEXT:    v_mov_b32_e32 v10, v7
; GFX6789-NEXT:    v_mov_b32_e32 v11, v7
; GFX6789-NEXT:    v_mov_b32_e32 v0, v7
; GFX6789-NEXT:    v_mov_b32_e32 v1, v8
; GFX6789-NEXT:    v_mov_b32_e32 v2, v9
; GFX6789-NEXT:    v_mov_b32_e32 v3, v10
; GFX6789-NEXT:    v_mov_b32_e32 v4, v11
; GFX6789-NEXT:    image_load v[0:4], v[5:6], s[0:7] dmask:0xf unorm tfe
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    global_store_dword v7, v4, s[8:9]
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_2d_tfe:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    v_mov_b32_e32 v4, 0
; NOPRT-NEXT:    image_load v[0:4], v[0:1], s[0:7] dmask:0xf unorm tfe
; NOPRT-NEXT:    v_mov_b32_e32 v5, 0
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    global_store_dword v5, v4, s[8:9]
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: load_2d_tfe:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    v_mov_b32_e32 v7, 0
; GFX10-NEXT:    v_mov_b32_e32 v6, v1
; GFX10-NEXT:    v_mov_b32_e32 v5, v0
; GFX10-NEXT:    v_mov_b32_e32 v8, v7
; GFX10-NEXT:    v_mov_b32_e32 v9, v7
; GFX10-NEXT:    v_mov_b32_e32 v10, v7
; GFX10-NEXT:    v_mov_b32_e32 v11, v7
; GFX10-NEXT:    v_mov_b32_e32 v0, v7
; GFX10-NEXT:    v_mov_b32_e32 v1, v8
; GFX10-NEXT:    v_mov_b32_e32 v2, v9
; GFX10-NEXT:    v_mov_b32_e32 v3, v10
; GFX10-NEXT:    v_mov_b32_e32 v4, v11
; GFX10-NEXT:    image_load v[0:4], v[5:6], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_2D unorm tfe
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    global_store_dword v7, v4, s[8:9]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: load_2d_tfe:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v7, 0
; GFX11-NEXT:    v_mov_b32_e32 v6, v1
; GFX11-NEXT:    v_mov_b32_e32 v5, v0
; GFX11-NEXT:    v_mov_b32_e32 v8, v7
; GFX11-NEXT:    v_mov_b32_e32 v9, v7
; GFX11-NEXT:    v_mov_b32_e32 v10, v7
; GFX11-NEXT:    v_mov_b32_e32 v11, v7
; GFX11-NEXT:    v_mov_b32_e32 v0, v7
; GFX11-NEXT:    v_mov_b32_e32 v1, v8
; GFX11-NEXT:    v_mov_b32_e32 v2, v9
; GFX11-NEXT:    v_mov_b32_e32 v3, v10
; GFX11-NEXT:    v_mov_b32_e32 v4, v11
; GFX11-NEXT:    image_load v[0:4], v[5:6], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_2D unorm tfe
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b32 v7, v4, s[8:9]
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ; return to shader part epilog
main_body:
  %v = call {<4 x float>,i32} @llvm.amdgcn.image.load.2d.v4f32i32.i32(i32 15, i32 %s, i32 %t, <8 x i32> %rsrc, i32 1, i32 0)
  %v.vec = extractvalue {<4 x float>, i32} %v, 0
  %v.err = extractvalue {<4 x float>, i32} %v, 1
  store i32 %v.err, i32 addrspace(1)* %out, align 4
  ret <4 x float> %v.vec
}

define amdgpu_ps <4 x float> @load_3d(<8 x i32> inreg %rsrc, i32 %s, i32 %t, i32 %r) {
; VERDE-LABEL: load_3d:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_load v[0:3], v[0:2], s[0:7] dmask:0xf unorm
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_3d:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_load v[0:3], v[0:2], s[0:7] dmask:0xf unorm
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_3d:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_load v[0:3], v[0:2], s[0:7] dmask:0xf unorm
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_3d:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_load v[0:3], v[0:2], s[0:7] dmask:0xf unorm
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: load_3d:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    image_load v[0:3], v[0:2], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_3D unorm
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.load.3d.v4f32.i32(i32 15, i32 %s, i32 %t, i32 %r, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @load_3d_tfe_lwe(<8 x i32> inreg %rsrc, i32 addrspace(1)* inreg %out, i32 %s, i32 %t, i32 %r) {
; VERDE-LABEL: load_3d_tfe_lwe:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    v_mov_b32_e32 v5, v0
; VERDE-NEXT:    v_mov_b32_e32 v0, 0
; VERDE-NEXT:    v_mov_b32_e32 v7, v2
; VERDE-NEXT:    v_mov_b32_e32 v6, v1
; VERDE-NEXT:    v_mov_b32_e32 v1, v0
; VERDE-NEXT:    v_mov_b32_e32 v2, v0
; VERDE-NEXT:    v_mov_b32_e32 v3, v0
; VERDE-NEXT:    v_mov_b32_e32 v4, v0
; VERDE-NEXT:    image_load v[0:4], v[5:7], s[0:7] dmask:0xf unorm tfe lwe
; VERDE-NEXT:    s_mov_b32 s11, 0xf000
; VERDE-NEXT:    s_mov_b32 s10, -1
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    buffer_store_dword v4, off, s[8:11], 0
; VERDE-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_3d_tfe_lwe:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    v_mov_b32_e32 v5, v0
; FIJI-NEXT:    v_mov_b32_e32 v0, 0
; FIJI-NEXT:    v_mov_b32_e32 v7, v2
; FIJI-NEXT:    v_mov_b32_e32 v6, v1
; FIJI-NEXT:    v_mov_b32_e32 v1, v0
; FIJI-NEXT:    v_mov_b32_e32 v2, v0
; FIJI-NEXT:    v_mov_b32_e32 v3, v0
; FIJI-NEXT:    v_mov_b32_e32 v4, v0
; FIJI-NEXT:    image_load v[0:4], v[5:7], s[0:7] dmask:0xf unorm tfe lwe
; FIJI-NEXT:    s_mov_b32 s11, 0xf000
; FIJI-NEXT:    s_mov_b32 s10, -1
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    buffer_store_dword v4, off, s[8:11], 0
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_3d_tfe_lwe:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    v_mov_b32_e32 v8, 0
; GFX6789-NEXT:    v_mov_b32_e32 v7, v2
; GFX6789-NEXT:    v_mov_b32_e32 v6, v1
; GFX6789-NEXT:    v_mov_b32_e32 v5, v0
; GFX6789-NEXT:    v_mov_b32_e32 v9, v8
; GFX6789-NEXT:    v_mov_b32_e32 v10, v8
; GFX6789-NEXT:    v_mov_b32_e32 v11, v8
; GFX6789-NEXT:    v_mov_b32_e32 v12, v8
; GFX6789-NEXT:    v_mov_b32_e32 v0, v8
; GFX6789-NEXT:    v_mov_b32_e32 v1, v9
; GFX6789-NEXT:    v_mov_b32_e32 v2, v10
; GFX6789-NEXT:    v_mov_b32_e32 v3, v11
; GFX6789-NEXT:    v_mov_b32_e32 v4, v12
; GFX6789-NEXT:    image_load v[0:4], v[5:7], s[0:7] dmask:0xf unorm tfe lwe
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    global_store_dword v8, v4, s[8:9]
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_3d_tfe_lwe:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    v_mov_b32_e32 v4, 0
; NOPRT-NEXT:    image_load v[0:4], v[0:2], s[0:7] dmask:0xf unorm tfe lwe
; NOPRT-NEXT:    v_mov_b32_e32 v5, 0
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    global_store_dword v5, v4, s[8:9]
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: load_3d_tfe_lwe:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    v_mov_b32_e32 v8, 0
; GFX10-NEXT:    v_mov_b32_e32 v7, v2
; GFX10-NEXT:    v_mov_b32_e32 v6, v1
; GFX10-NEXT:    v_mov_b32_e32 v5, v0
; GFX10-NEXT:    v_mov_b32_e32 v9, v8
; GFX10-NEXT:    v_mov_b32_e32 v10, v8
; GFX10-NEXT:    v_mov_b32_e32 v11, v8
; GFX10-NEXT:    v_mov_b32_e32 v12, v8
; GFX10-NEXT:    v_mov_b32_e32 v0, v8
; GFX10-NEXT:    v_mov_b32_e32 v1, v9
; GFX10-NEXT:    v_mov_b32_e32 v2, v10
; GFX10-NEXT:    v_mov_b32_e32 v3, v11
; GFX10-NEXT:    v_mov_b32_e32 v4, v12
; GFX10-NEXT:    image_load v[0:4], v[5:7], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_3D unorm tfe lwe
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    global_store_dword v8, v4, s[8:9]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: load_3d_tfe_lwe:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v8, 0
; GFX11-NEXT:    v_mov_b32_e32 v7, v2
; GFX11-NEXT:    v_mov_b32_e32 v6, v1
; GFX11-NEXT:    v_mov_b32_e32 v5, v0
; GFX11-NEXT:    v_mov_b32_e32 v9, v8
; GFX11-NEXT:    v_mov_b32_e32 v10, v8
; GFX11-NEXT:    v_mov_b32_e32 v11, v8
; GFX11-NEXT:    v_mov_b32_e32 v12, v8
; GFX11-NEXT:    v_mov_b32_e32 v0, v8
; GFX11-NEXT:    v_mov_b32_e32 v1, v9
; GFX11-NEXT:    v_mov_b32_e32 v2, v10
; GFX11-NEXT:    v_mov_b32_e32 v3, v11
; GFX11-NEXT:    v_mov_b32_e32 v4, v12
; GFX11-NEXT:    image_load v[0:4], v[5:7], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_3D unorm tfe lwe
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b32 v8, v4, s[8:9]
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ; return to shader part epilog
main_body:
  %v = call {<4 x float>,i32} @llvm.amdgcn.image.load.3d.v4f32i32.i32(i32 15, i32 %s, i32 %t, i32 %r, <8 x i32> %rsrc, i32 3, i32 0)
  %v.vec = extractvalue {<4 x float>, i32} %v, 0
  %v.err = extractvalue {<4 x float>, i32} %v, 1
  store i32 %v.err, i32 addrspace(1)* %out, align 4
  ret <4 x float> %v.vec
}

define amdgpu_ps <4 x float> @load_cube(<8 x i32> inreg %rsrc, i32 %s, i32 %t, i32 %slice) {
; VERDE-LABEL: load_cube:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_load v[0:3], v[0:2], s[0:7] dmask:0xf unorm da
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_cube:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_load v[0:3], v[0:2], s[0:7] dmask:0xf unorm da
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_cube:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_load v[0:3], v[0:2], s[0:7] dmask:0xf unorm da
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_cube:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_load v[0:3], v[0:2], s[0:7] dmask:0xf unorm da
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: load_cube:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    image_load v[0:3], v[0:2], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_CUBE unorm
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.load.cube.v4f32.i32(i32 15, i32 %s, i32 %t, i32 %slice, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @load_cube_lwe(<8 x i32> inreg %rsrc, i32 addrspace(1)* inreg %out, i32 %s, i32 %t, i32 %slice) {
; VERDE-LABEL: load_cube_lwe:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    v_mov_b32_e32 v5, v0
; VERDE-NEXT:    v_mov_b32_e32 v0, 0
; VERDE-NEXT:    v_mov_b32_e32 v7, v2
; VERDE-NEXT:    v_mov_b32_e32 v6, v1
; VERDE-NEXT:    v_mov_b32_e32 v1, v0
; VERDE-NEXT:    v_mov_b32_e32 v2, v0
; VERDE-NEXT:    v_mov_b32_e32 v3, v0
; VERDE-NEXT:    v_mov_b32_e32 v4, v0
; VERDE-NEXT:    image_load v[0:4], v[5:7], s[0:7] dmask:0xf unorm lwe da
; VERDE-NEXT:    s_mov_b32 s11, 0xf000
; VERDE-NEXT:    s_mov_b32 s10, -1
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    buffer_store_dword v4, off, s[8:11], 0
; VERDE-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_cube_lwe:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    v_mov_b32_e32 v5, v0
; FIJI-NEXT:    v_mov_b32_e32 v0, 0
; FIJI-NEXT:    v_mov_b32_e32 v7, v2
; FIJI-NEXT:    v_mov_b32_e32 v6, v1
; FIJI-NEXT:    v_mov_b32_e32 v1, v0
; FIJI-NEXT:    v_mov_b32_e32 v2, v0
; FIJI-NEXT:    v_mov_b32_e32 v3, v0
; FIJI-NEXT:    v_mov_b32_e32 v4, v0
; FIJI-NEXT:    image_load v[0:4], v[5:7], s[0:7] dmask:0xf unorm lwe da
; FIJI-NEXT:    s_mov_b32 s11, 0xf000
; FIJI-NEXT:    s_mov_b32 s10, -1
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    buffer_store_dword v4, off, s[8:11], 0
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_cube_lwe:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    v_mov_b32_e32 v8, 0
; GFX6789-NEXT:    v_mov_b32_e32 v7, v2
; GFX6789-NEXT:    v_mov_b32_e32 v6, v1
; GFX6789-NEXT:    v_mov_b32_e32 v5, v0
; GFX6789-NEXT:    v_mov_b32_e32 v9, v8
; GFX6789-NEXT:    v_mov_b32_e32 v10, v8
; GFX6789-NEXT:    v_mov_b32_e32 v11, v8
; GFX6789-NEXT:    v_mov_b32_e32 v12, v8
; GFX6789-NEXT:    v_mov_b32_e32 v0, v8
; GFX6789-NEXT:    v_mov_b32_e32 v1, v9
; GFX6789-NEXT:    v_mov_b32_e32 v2, v10
; GFX6789-NEXT:    v_mov_b32_e32 v3, v11
; GFX6789-NEXT:    v_mov_b32_e32 v4, v12
; GFX6789-NEXT:    image_load v[0:4], v[5:7], s[0:7] dmask:0xf unorm lwe da
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    global_store_dword v8, v4, s[8:9]
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_cube_lwe:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    v_mov_b32_e32 v4, 0
; NOPRT-NEXT:    image_load v[0:4], v[0:2], s[0:7] dmask:0xf unorm lwe da
; NOPRT-NEXT:    v_mov_b32_e32 v5, 0
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    global_store_dword v5, v4, s[8:9]
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: load_cube_lwe:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    v_mov_b32_e32 v8, 0
; GFX10-NEXT:    v_mov_b32_e32 v7, v2
; GFX10-NEXT:    v_mov_b32_e32 v6, v1
; GFX10-NEXT:    v_mov_b32_e32 v5, v0
; GFX10-NEXT:    v_mov_b32_e32 v9, v8
; GFX10-NEXT:    v_mov_b32_e32 v10, v8
; GFX10-NEXT:    v_mov_b32_e32 v11, v8
; GFX10-NEXT:    v_mov_b32_e32 v12, v8
; GFX10-NEXT:    v_mov_b32_e32 v0, v8
; GFX10-NEXT:    v_mov_b32_e32 v1, v9
; GFX10-NEXT:    v_mov_b32_e32 v2, v10
; GFX10-NEXT:    v_mov_b32_e32 v3, v11
; GFX10-NEXT:    v_mov_b32_e32 v4, v12
; GFX10-NEXT:    image_load v[0:4], v[5:7], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_CUBE unorm lwe
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    global_store_dword v8, v4, s[8:9]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: load_cube_lwe:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v8, 0
; GFX11-NEXT:    v_mov_b32_e32 v7, v2
; GFX11-NEXT:    v_mov_b32_e32 v6, v1
; GFX11-NEXT:    v_mov_b32_e32 v5, v0
; GFX11-NEXT:    v_mov_b32_e32 v9, v8
; GFX11-NEXT:    v_mov_b32_e32 v10, v8
; GFX11-NEXT:    v_mov_b32_e32 v11, v8
; GFX11-NEXT:    v_mov_b32_e32 v12, v8
; GFX11-NEXT:    v_mov_b32_e32 v0, v8
; GFX11-NEXT:    v_mov_b32_e32 v1, v9
; GFX11-NEXT:    v_mov_b32_e32 v2, v10
; GFX11-NEXT:    v_mov_b32_e32 v3, v11
; GFX11-NEXT:    v_mov_b32_e32 v4, v12
; GFX11-NEXT:    image_load v[0:4], v[5:7], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_CUBE unorm lwe
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b32 v8, v4, s[8:9]
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ; return to shader part epilog
main_body:
  %v = call {<4 x float>,i32} @llvm.amdgcn.image.load.cube.v4f32i32.i32(i32 15, i32 %s, i32 %t, i32 %slice, <8 x i32> %rsrc, i32 2, i32 0)
  %v.vec = extractvalue {<4 x float>, i32} %v, 0
  %v.err = extractvalue {<4 x float>, i32} %v, 1
  store i32 %v.err, i32 addrspace(1)* %out, align 4
  ret <4 x float> %v.vec
}

define amdgpu_ps <4 x float> @load_1darray(<8 x i32> inreg %rsrc, i32 %s, i32 %slice) {
; VERDE-LABEL: load_1darray:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_load v[0:3], v[0:1], s[0:7] dmask:0xf unorm da
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_1darray:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_load v[0:3], v[0:1], s[0:7] dmask:0xf unorm da
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_1darray:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_load v[0:3], v[0:1], s[0:7] dmask:0xf unorm da
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_1darray:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_load v[0:3], v[0:1], s[0:7] dmask:0xf unorm da
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: load_1darray:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    image_load v[0:3], v[0:1], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D_ARRAY unorm
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.load.1darray.v4f32.i32(i32 15, i32 %s, i32 %slice, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @load_1darray_tfe(<8 x i32> inreg %rsrc, i32 addrspace(1)* inreg %out, i32 %s, i32 %slice) {
; VERDE-LABEL: load_1darray_tfe:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    v_mov_b32_e32 v5, v0
; VERDE-NEXT:    v_mov_b32_e32 v0, 0
; VERDE-NEXT:    v_mov_b32_e32 v6, v1
; VERDE-NEXT:    v_mov_b32_e32 v1, v0
; VERDE-NEXT:    v_mov_b32_e32 v2, v0
; VERDE-NEXT:    v_mov_b32_e32 v3, v0
; VERDE-NEXT:    v_mov_b32_e32 v4, v0
; VERDE-NEXT:    image_load v[0:4], v[5:6], s[0:7] dmask:0xf unorm tfe da
; VERDE-NEXT:    s_mov_b32 s11, 0xf000
; VERDE-NEXT:    s_mov_b32 s10, -1
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    buffer_store_dword v4, off, s[8:11], 0
; VERDE-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_1darray_tfe:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    v_mov_b32_e32 v5, v0
; FIJI-NEXT:    v_mov_b32_e32 v0, 0
; FIJI-NEXT:    v_mov_b32_e32 v6, v1
; FIJI-NEXT:    v_mov_b32_e32 v1, v0
; FIJI-NEXT:    v_mov_b32_e32 v2, v0
; FIJI-NEXT:    v_mov_b32_e32 v3, v0
; FIJI-NEXT:    v_mov_b32_e32 v4, v0
; FIJI-NEXT:    image_load v[0:4], v[5:6], s[0:7] dmask:0xf unorm tfe da
; FIJI-NEXT:    s_mov_b32 s11, 0xf000
; FIJI-NEXT:    s_mov_b32 s10, -1
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    buffer_store_dword v4, off, s[8:11], 0
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_1darray_tfe:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    v_mov_b32_e32 v7, 0
; GFX6789-NEXT:    v_mov_b32_e32 v6, v1
; GFX6789-NEXT:    v_mov_b32_e32 v5, v0
; GFX6789-NEXT:    v_mov_b32_e32 v8, v7
; GFX6789-NEXT:    v_mov_b32_e32 v9, v7
; GFX6789-NEXT:    v_mov_b32_e32 v10, v7
; GFX6789-NEXT:    v_mov_b32_e32 v11, v7
; GFX6789-NEXT:    v_mov_b32_e32 v0, v7
; GFX6789-NEXT:    v_mov_b32_e32 v1, v8
; GFX6789-NEXT:    v_mov_b32_e32 v2, v9
; GFX6789-NEXT:    v_mov_b32_e32 v3, v10
; GFX6789-NEXT:    v_mov_b32_e32 v4, v11
; GFX6789-NEXT:    image_load v[0:4], v[5:6], s[0:7] dmask:0xf unorm tfe da
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    global_store_dword v7, v4, s[8:9]
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_1darray_tfe:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    v_mov_b32_e32 v4, 0
; NOPRT-NEXT:    image_load v[0:4], v[0:1], s[0:7] dmask:0xf unorm tfe da
; NOPRT-NEXT:    v_mov_b32_e32 v5, 0
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    global_store_dword v5, v4, s[8:9]
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: load_1darray_tfe:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    v_mov_b32_e32 v7, 0
; GFX10-NEXT:    v_mov_b32_e32 v6, v1
; GFX10-NEXT:    v_mov_b32_e32 v5, v0
; GFX10-NEXT:    v_mov_b32_e32 v8, v7
; GFX10-NEXT:    v_mov_b32_e32 v9, v7
; GFX10-NEXT:    v_mov_b32_e32 v10, v7
; GFX10-NEXT:    v_mov_b32_e32 v11, v7
; GFX10-NEXT:    v_mov_b32_e32 v0, v7
; GFX10-NEXT:    v_mov_b32_e32 v1, v8
; GFX10-NEXT:    v_mov_b32_e32 v2, v9
; GFX10-NEXT:    v_mov_b32_e32 v3, v10
; GFX10-NEXT:    v_mov_b32_e32 v4, v11
; GFX10-NEXT:    image_load v[0:4], v[5:6], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D_ARRAY unorm tfe
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    global_store_dword v7, v4, s[8:9]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: load_1darray_tfe:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v7, 0
; GFX11-NEXT:    v_mov_b32_e32 v6, v1
; GFX11-NEXT:    v_mov_b32_e32 v5, v0
; GFX11-NEXT:    v_mov_b32_e32 v8, v7
; GFX11-NEXT:    v_mov_b32_e32 v9, v7
; GFX11-NEXT:    v_mov_b32_e32 v10, v7
; GFX11-NEXT:    v_mov_b32_e32 v11, v7
; GFX11-NEXT:    v_mov_b32_e32 v0, v7
; GFX11-NEXT:    v_mov_b32_e32 v1, v8
; GFX11-NEXT:    v_mov_b32_e32 v2, v9
; GFX11-NEXT:    v_mov_b32_e32 v3, v10
; GFX11-NEXT:    v_mov_b32_e32 v4, v11
; GFX11-NEXT:    image_load v[0:4], v[5:6], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D_ARRAY unorm tfe
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b32 v7, v4, s[8:9]
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ; return to shader part epilog
main_body:
  %v = call {<4 x float>,i32} @llvm.amdgcn.image.load.1darray.v4f32i32.i32(i32 15, i32 %s, i32 %slice, <8 x i32> %rsrc, i32 1, i32 0)
  %v.vec = extractvalue {<4 x float>, i32} %v, 0
  %v.err = extractvalue {<4 x float>, i32} %v, 1
  store i32 %v.err, i32 addrspace(1)* %out, align 4
  ret <4 x float> %v.vec
}

define amdgpu_ps <4 x float> @load_2darray(<8 x i32> inreg %rsrc, i32 %s, i32 %t, i32 %slice) {
; VERDE-LABEL: load_2darray:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_load v[0:3], v[0:2], s[0:7] dmask:0xf unorm da
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_2darray:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_load v[0:3], v[0:2], s[0:7] dmask:0xf unorm da
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_2darray:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_load v[0:3], v[0:2], s[0:7] dmask:0xf unorm da
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_2darray:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_load v[0:3], v[0:2], s[0:7] dmask:0xf unorm da
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: load_2darray:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    image_load v[0:3], v[0:2], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY unorm
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.load.2darray.v4f32.i32(i32 15, i32 %s, i32 %t, i32 %slice, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @load_2darray_lwe(<8 x i32> inreg %rsrc, i32 addrspace(1)* inreg %out, i32 %s, i32 %t, i32 %slice) {
; VERDE-LABEL: load_2darray_lwe:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    v_mov_b32_e32 v5, v0
; VERDE-NEXT:    v_mov_b32_e32 v0, 0
; VERDE-NEXT:    v_mov_b32_e32 v7, v2
; VERDE-NEXT:    v_mov_b32_e32 v6, v1
; VERDE-NEXT:    v_mov_b32_e32 v1, v0
; VERDE-NEXT:    v_mov_b32_e32 v2, v0
; VERDE-NEXT:    v_mov_b32_e32 v3, v0
; VERDE-NEXT:    v_mov_b32_e32 v4, v0
; VERDE-NEXT:    image_load v[0:4], v[5:7], s[0:7] dmask:0xf unorm lwe da
; VERDE-NEXT:    s_mov_b32 s11, 0xf000
; VERDE-NEXT:    s_mov_b32 s10, -1
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    buffer_store_dword v4, off, s[8:11], 0
; VERDE-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_2darray_lwe:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    v_mov_b32_e32 v5, v0
; FIJI-NEXT:    v_mov_b32_e32 v0, 0
; FIJI-NEXT:    v_mov_b32_e32 v7, v2
; FIJI-NEXT:    v_mov_b32_e32 v6, v1
; FIJI-NEXT:    v_mov_b32_e32 v1, v0
; FIJI-NEXT:    v_mov_b32_e32 v2, v0
; FIJI-NEXT:    v_mov_b32_e32 v3, v0
; FIJI-NEXT:    v_mov_b32_e32 v4, v0
; FIJI-NEXT:    image_load v[0:4], v[5:7], s[0:7] dmask:0xf unorm lwe da
; FIJI-NEXT:    s_mov_b32 s11, 0xf000
; FIJI-NEXT:    s_mov_b32 s10, -1
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    buffer_store_dword v4, off, s[8:11], 0
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_2darray_lwe:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    v_mov_b32_e32 v8, 0
; GFX6789-NEXT:    v_mov_b32_e32 v7, v2
; GFX6789-NEXT:    v_mov_b32_e32 v6, v1
; GFX6789-NEXT:    v_mov_b32_e32 v5, v0
; GFX6789-NEXT:    v_mov_b32_e32 v9, v8
; GFX6789-NEXT:    v_mov_b32_e32 v10, v8
; GFX6789-NEXT:    v_mov_b32_e32 v11, v8
; GFX6789-NEXT:    v_mov_b32_e32 v12, v8
; GFX6789-NEXT:    v_mov_b32_e32 v0, v8
; GFX6789-NEXT:    v_mov_b32_e32 v1, v9
; GFX6789-NEXT:    v_mov_b32_e32 v2, v10
; GFX6789-NEXT:    v_mov_b32_e32 v3, v11
; GFX6789-NEXT:    v_mov_b32_e32 v4, v12
; GFX6789-NEXT:    image_load v[0:4], v[5:7], s[0:7] dmask:0xf unorm lwe da
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    global_store_dword v8, v4, s[8:9]
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_2darray_lwe:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    v_mov_b32_e32 v4, 0
; NOPRT-NEXT:    image_load v[0:4], v[0:2], s[0:7] dmask:0xf unorm lwe da
; NOPRT-NEXT:    v_mov_b32_e32 v5, 0
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    global_store_dword v5, v4, s[8:9]
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: load_2darray_lwe:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    v_mov_b32_e32 v8, 0
; GFX10-NEXT:    v_mov_b32_e32 v7, v2
; GFX10-NEXT:    v_mov_b32_e32 v6, v1
; GFX10-NEXT:    v_mov_b32_e32 v5, v0
; GFX10-NEXT:    v_mov_b32_e32 v9, v8
; GFX10-NEXT:    v_mov_b32_e32 v10, v8
; GFX10-NEXT:    v_mov_b32_e32 v11, v8
; GFX10-NEXT:    v_mov_b32_e32 v12, v8
; GFX10-NEXT:    v_mov_b32_e32 v0, v8
; GFX10-NEXT:    v_mov_b32_e32 v1, v9
; GFX10-NEXT:    v_mov_b32_e32 v2, v10
; GFX10-NEXT:    v_mov_b32_e32 v3, v11
; GFX10-NEXT:    v_mov_b32_e32 v4, v12
; GFX10-NEXT:    image_load v[0:4], v[5:7], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY unorm lwe
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    global_store_dword v8, v4, s[8:9]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: load_2darray_lwe:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v8, 0
; GFX11-NEXT:    v_mov_b32_e32 v7, v2
; GFX11-NEXT:    v_mov_b32_e32 v6, v1
; GFX11-NEXT:    v_mov_b32_e32 v5, v0
; GFX11-NEXT:    v_mov_b32_e32 v9, v8
; GFX11-NEXT:    v_mov_b32_e32 v10, v8
; GFX11-NEXT:    v_mov_b32_e32 v11, v8
; GFX11-NEXT:    v_mov_b32_e32 v12, v8
; GFX11-NEXT:    v_mov_b32_e32 v0, v8
; GFX11-NEXT:    v_mov_b32_e32 v1, v9
; GFX11-NEXT:    v_mov_b32_e32 v2, v10
; GFX11-NEXT:    v_mov_b32_e32 v3, v11
; GFX11-NEXT:    v_mov_b32_e32 v4, v12
; GFX11-NEXT:    image_load v[0:4], v[5:7], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY unorm lwe
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b32 v8, v4, s[8:9]
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ; return to shader part epilog
main_body:
  %v = call {<4 x float>,i32} @llvm.amdgcn.image.load.2darray.v4f32i32.i32(i32 15, i32 %s, i32 %t, i32 %slice, <8 x i32> %rsrc, i32 2, i32 0)
  %v.vec = extractvalue {<4 x float>, i32} %v, 0
  %v.err = extractvalue {<4 x float>, i32} %v, 1
  store i32 %v.err, i32 addrspace(1)* %out, align 4
  ret <4 x float> %v.vec
}

define amdgpu_ps <4 x float> @load_2dmsaa(<8 x i32> inreg %rsrc, i32 %s, i32 %t, i32 %fragid) {
; VERDE-LABEL: load_2dmsaa:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_load v[0:3], v[0:2], s[0:7] dmask:0xf unorm
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_2dmsaa:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_load v[0:3], v[0:2], s[0:7] dmask:0xf unorm
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_2dmsaa:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_load v[0:3], v[0:2], s[0:7] dmask:0xf unorm
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_2dmsaa:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_load v[0:3], v[0:2], s[0:7] dmask:0xf unorm
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: load_2dmsaa:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    image_load v[0:3], v[0:2], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_2D_MSAA unorm
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.load.2dmsaa.v4f32.i32(i32 15, i32 %s, i32 %t, i32 %fragid, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @load_2dmsaa_both(<8 x i32> inreg %rsrc, i32 addrspace(1)* inreg %out, i32 %s, i32 %t, i32 %fragid) {
; VERDE-LABEL: load_2dmsaa_both:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    v_mov_b32_e32 v5, v0
; VERDE-NEXT:    v_mov_b32_e32 v0, 0
; VERDE-NEXT:    v_mov_b32_e32 v7, v2
; VERDE-NEXT:    v_mov_b32_e32 v6, v1
; VERDE-NEXT:    v_mov_b32_e32 v1, v0
; VERDE-NEXT:    v_mov_b32_e32 v2, v0
; VERDE-NEXT:    v_mov_b32_e32 v3, v0
; VERDE-NEXT:    v_mov_b32_e32 v4, v0
; VERDE-NEXT:    image_load v[0:4], v[5:7], s[0:7] dmask:0xf unorm tfe lwe
; VERDE-NEXT:    s_mov_b32 s11, 0xf000
; VERDE-NEXT:    s_mov_b32 s10, -1
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    buffer_store_dword v4, off, s[8:11], 0
; VERDE-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_2dmsaa_both:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    v_mov_b32_e32 v5, v0
; FIJI-NEXT:    v_mov_b32_e32 v0, 0
; FIJI-NEXT:    v_mov_b32_e32 v7, v2
; FIJI-NEXT:    v_mov_b32_e32 v6, v1
; FIJI-NEXT:    v_mov_b32_e32 v1, v0
; FIJI-NEXT:    v_mov_b32_e32 v2, v0
; FIJI-NEXT:    v_mov_b32_e32 v3, v0
; FIJI-NEXT:    v_mov_b32_e32 v4, v0
; FIJI-NEXT:    image_load v[0:4], v[5:7], s[0:7] dmask:0xf unorm tfe lwe
; FIJI-NEXT:    s_mov_b32 s11, 0xf000
; FIJI-NEXT:    s_mov_b32 s10, -1
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    buffer_store_dword v4, off, s[8:11], 0
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_2dmsaa_both:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    v_mov_b32_e32 v8, 0
; GFX6789-NEXT:    v_mov_b32_e32 v7, v2
; GFX6789-NEXT:    v_mov_b32_e32 v6, v1
; GFX6789-NEXT:    v_mov_b32_e32 v5, v0
; GFX6789-NEXT:    v_mov_b32_e32 v9, v8
; GFX6789-NEXT:    v_mov_b32_e32 v10, v8
; GFX6789-NEXT:    v_mov_b32_e32 v11, v8
; GFX6789-NEXT:    v_mov_b32_e32 v12, v8
; GFX6789-NEXT:    v_mov_b32_e32 v0, v8
; GFX6789-NEXT:    v_mov_b32_e32 v1, v9
; GFX6789-NEXT:    v_mov_b32_e32 v2, v10
; GFX6789-NEXT:    v_mov_b32_e32 v3, v11
; GFX6789-NEXT:    v_mov_b32_e32 v4, v12
; GFX6789-NEXT:    image_load v[0:4], v[5:7], s[0:7] dmask:0xf unorm tfe lwe
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    global_store_dword v8, v4, s[8:9]
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_2dmsaa_both:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    v_mov_b32_e32 v4, 0
; NOPRT-NEXT:    image_load v[0:4], v[0:2], s[0:7] dmask:0xf unorm tfe lwe
; NOPRT-NEXT:    v_mov_b32_e32 v5, 0
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    global_store_dword v5, v4, s[8:9]
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: load_2dmsaa_both:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    v_mov_b32_e32 v8, 0
; GFX10-NEXT:    v_mov_b32_e32 v7, v2
; GFX10-NEXT:    v_mov_b32_e32 v6, v1
; GFX10-NEXT:    v_mov_b32_e32 v5, v0
; GFX10-NEXT:    v_mov_b32_e32 v9, v8
; GFX10-NEXT:    v_mov_b32_e32 v10, v8
; GFX10-NEXT:    v_mov_b32_e32 v11, v8
; GFX10-NEXT:    v_mov_b32_e32 v12, v8
; GFX10-NEXT:    v_mov_b32_e32 v0, v8
; GFX10-NEXT:    v_mov_b32_e32 v1, v9
; GFX10-NEXT:    v_mov_b32_e32 v2, v10
; GFX10-NEXT:    v_mov_b32_e32 v3, v11
; GFX10-NEXT:    v_mov_b32_e32 v4, v12
; GFX10-NEXT:    image_load v[0:4], v[5:7], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_2D_MSAA unorm tfe lwe
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    global_store_dword v8, v4, s[8:9]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: load_2dmsaa_both:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v8, 0
; GFX11-NEXT:    v_mov_b32_e32 v7, v2
; GFX11-NEXT:    v_mov_b32_e32 v6, v1
; GFX11-NEXT:    v_mov_b32_e32 v5, v0
; GFX11-NEXT:    v_mov_b32_e32 v9, v8
; GFX11-NEXT:    v_mov_b32_e32 v10, v8
; GFX11-NEXT:    v_mov_b32_e32 v11, v8
; GFX11-NEXT:    v_mov_b32_e32 v12, v8
; GFX11-NEXT:    v_mov_b32_e32 v0, v8
; GFX11-NEXT:    v_mov_b32_e32 v1, v9
; GFX11-NEXT:    v_mov_b32_e32 v2, v10
; GFX11-NEXT:    v_mov_b32_e32 v3, v11
; GFX11-NEXT:    v_mov_b32_e32 v4, v12
; GFX11-NEXT:    image_load v[0:4], v[5:7], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_2D_MSAA unorm tfe lwe
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b32 v8, v4, s[8:9]
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ; return to shader part epilog
main_body:
  %v = call {<4 x float>,i32} @llvm.amdgcn.image.load.2dmsaa.v4f32i32.i32(i32 15, i32 %s, i32 %t, i32 %fragid, <8 x i32> %rsrc, i32 3, i32 0)
  %v.vec = extractvalue {<4 x float>, i32} %v, 0
  %v.err = extractvalue {<4 x float>, i32} %v, 1
  store i32 %v.err, i32 addrspace(1)* %out, align 4
  ret <4 x float> %v.vec
}

define amdgpu_ps <4 x float> @load_2darraymsaa(<8 x i32> inreg %rsrc, i32 %s, i32 %t, i32 %slice, i32 %fragid) {
; VERDE-LABEL: load_2darraymsaa:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_load v[0:3], v[0:3], s[0:7] dmask:0xf unorm da
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_2darraymsaa:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_load v[0:3], v[0:3], s[0:7] dmask:0xf unorm da
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_2darraymsaa:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_load v[0:3], v[0:3], s[0:7] dmask:0xf unorm da
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_2darraymsaa:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_load v[0:3], v[0:3], s[0:7] dmask:0xf unorm da
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: load_2darraymsaa:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    image_load v[0:3], v[0:3], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.load.2darraymsaa.v4f32.i32(i32 15, i32 %s, i32 %t, i32 %slice, i32 %fragid, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @load_2darraymsaa_tfe(<8 x i32> inreg %rsrc, i32 addrspace(1)* inreg %out, i32 %s, i32 %t, i32 %slice, i32 %fragid) {
; VERDE-LABEL: load_2darraymsaa_tfe:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    v_mov_b32_e32 v5, v0
; VERDE-NEXT:    v_mov_b32_e32 v0, 0
; VERDE-NEXT:    v_mov_b32_e32 v8, v3
; VERDE-NEXT:    v_mov_b32_e32 v7, v2
; VERDE-NEXT:    v_mov_b32_e32 v6, v1
; VERDE-NEXT:    v_mov_b32_e32 v1, v0
; VERDE-NEXT:    v_mov_b32_e32 v2, v0
; VERDE-NEXT:    v_mov_b32_e32 v3, v0
; VERDE-NEXT:    v_mov_b32_e32 v4, v0
; VERDE-NEXT:    image_load v[0:4], v[5:8], s[0:7] dmask:0xf unorm tfe da
; VERDE-NEXT:    s_mov_b32 s11, 0xf000
; VERDE-NEXT:    s_mov_b32 s10, -1
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    buffer_store_dword v4, off, s[8:11], 0
; VERDE-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_2darraymsaa_tfe:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    v_mov_b32_e32 v5, v0
; FIJI-NEXT:    v_mov_b32_e32 v0, 0
; FIJI-NEXT:    v_mov_b32_e32 v8, v3
; FIJI-NEXT:    v_mov_b32_e32 v7, v2
; FIJI-NEXT:    v_mov_b32_e32 v6, v1
; FIJI-NEXT:    v_mov_b32_e32 v1, v0
; FIJI-NEXT:    v_mov_b32_e32 v2, v0
; FIJI-NEXT:    v_mov_b32_e32 v3, v0
; FIJI-NEXT:    v_mov_b32_e32 v4, v0
; FIJI-NEXT:    image_load v[0:4], v[5:8], s[0:7] dmask:0xf unorm tfe da
; FIJI-NEXT:    s_mov_b32 s11, 0xf000
; FIJI-NEXT:    s_mov_b32 s10, -1
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    buffer_store_dword v4, off, s[8:11], 0
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_2darraymsaa_tfe:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    v_mov_b32_e32 v9, 0
; GFX6789-NEXT:    v_mov_b32_e32 v8, v3
; GFX6789-NEXT:    v_mov_b32_e32 v7, v2
; GFX6789-NEXT:    v_mov_b32_e32 v6, v1
; GFX6789-NEXT:    v_mov_b32_e32 v5, v0
; GFX6789-NEXT:    v_mov_b32_e32 v10, v9
; GFX6789-NEXT:    v_mov_b32_e32 v11, v9
; GFX6789-NEXT:    v_mov_b32_e32 v12, v9
; GFX6789-NEXT:    v_mov_b32_e32 v13, v9
; GFX6789-NEXT:    v_mov_b32_e32 v0, v9
; GFX6789-NEXT:    v_mov_b32_e32 v1, v10
; GFX6789-NEXT:    v_mov_b32_e32 v2, v11
; GFX6789-NEXT:    v_mov_b32_e32 v3, v12
; GFX6789-NEXT:    v_mov_b32_e32 v4, v13
; GFX6789-NEXT:    image_load v[0:4], v[5:8], s[0:7] dmask:0xf unorm tfe da
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    global_store_dword v9, v4, s[8:9]
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_2darraymsaa_tfe:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    v_mov_b32_e32 v4, 0
; NOPRT-NEXT:    image_load v[0:4], v[0:3], s[0:7] dmask:0xf unorm tfe da
; NOPRT-NEXT:    v_mov_b32_e32 v5, 0
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    global_store_dword v5, v4, s[8:9]
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: load_2darraymsaa_tfe:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    v_mov_b32_e32 v9, 0
; GFX10-NEXT:    v_mov_b32_e32 v8, v3
; GFX10-NEXT:    v_mov_b32_e32 v7, v2
; GFX10-NEXT:    v_mov_b32_e32 v6, v1
; GFX10-NEXT:    v_mov_b32_e32 v5, v0
; GFX10-NEXT:    v_mov_b32_e32 v10, v9
; GFX10-NEXT:    v_mov_b32_e32 v11, v9
; GFX10-NEXT:    v_mov_b32_e32 v12, v9
; GFX10-NEXT:    v_mov_b32_e32 v13, v9
; GFX10-NEXT:    v_mov_b32_e32 v0, v9
; GFX10-NEXT:    v_mov_b32_e32 v1, v10
; GFX10-NEXT:    v_mov_b32_e32 v2, v11
; GFX10-NEXT:    v_mov_b32_e32 v3, v12
; GFX10-NEXT:    v_mov_b32_e32 v4, v13
; GFX10-NEXT:    image_load v[0:4], v[5:8], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm tfe
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    global_store_dword v9, v4, s[8:9]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: load_2darraymsaa_tfe:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v9, 0
; GFX11-NEXT:    v_mov_b32_e32 v8, v3
; GFX11-NEXT:    v_mov_b32_e32 v7, v2
; GFX11-NEXT:    v_mov_b32_e32 v6, v1
; GFX11-NEXT:    v_mov_b32_e32 v5, v0
; GFX11-NEXT:    v_mov_b32_e32 v10, v9
; GFX11-NEXT:    v_mov_b32_e32 v11, v9
; GFX11-NEXT:    v_mov_b32_e32 v12, v9
; GFX11-NEXT:    v_mov_b32_e32 v13, v9
; GFX11-NEXT:    v_mov_b32_e32 v0, v9
; GFX11-NEXT:    v_mov_b32_e32 v1, v10
; GFX11-NEXT:    v_mov_b32_e32 v2, v11
; GFX11-NEXT:    v_mov_b32_e32 v3, v12
; GFX11-NEXT:    v_mov_b32_e32 v4, v13
; GFX11-NEXT:    image_load v[0:4], v[5:8], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm tfe
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b32 v9, v4, s[8:9]
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ; return to shader part epilog
main_body:
  %v = call {<4 x float>,i32} @llvm.amdgcn.image.load.2darraymsaa.v4f32i32.i32(i32 15, i32 %s, i32 %t, i32 %slice, i32 %fragid, <8 x i32> %rsrc, i32 1, i32 0)
  %v.vec = extractvalue {<4 x float>, i32} %v, 0
  %v.err = extractvalue {<4 x float>, i32} %v, 1
  store i32 %v.err, i32 addrspace(1)* %out, align 4
  ret <4 x float> %v.vec
}

define amdgpu_ps <4 x float> @load_mip_1d(<8 x i32> inreg %rsrc, i32 %s, i32 %mip) {
; VERDE-LABEL: load_mip_1d:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_load_mip v[0:3], v[0:1], s[0:7] dmask:0xf unorm
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_mip_1d:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_load_mip v[0:3], v[0:1], s[0:7] dmask:0xf unorm
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_mip_1d:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_load_mip v[0:3], v[0:1], s[0:7] dmask:0xf unorm
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_mip_1d:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_load_mip v[0:3], v[0:1], s[0:7] dmask:0xf unorm
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: load_mip_1d:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    image_load_mip v[0:3], v[0:1], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D unorm
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.load.mip.1d.v4f32.i32(i32 15, i32 %s, i32 %mip, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @load_mip_1d_lwe(<8 x i32> inreg %rsrc, i32 addrspace(1)* inreg %out, i32 %s, i32 %mip) {
; VERDE-LABEL: load_mip_1d_lwe:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    v_mov_b32_e32 v5, v0
; VERDE-NEXT:    v_mov_b32_e32 v0, 0
; VERDE-NEXT:    v_mov_b32_e32 v6, v1
; VERDE-NEXT:    v_mov_b32_e32 v1, v0
; VERDE-NEXT:    v_mov_b32_e32 v2, v0
; VERDE-NEXT:    v_mov_b32_e32 v3, v0
; VERDE-NEXT:    v_mov_b32_e32 v4, v0
; VERDE-NEXT:    image_load_mip v[0:4], v[5:6], s[0:7] dmask:0xf unorm lwe
; VERDE-NEXT:    s_mov_b32 s11, 0xf000
; VERDE-NEXT:    s_mov_b32 s10, -1
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    buffer_store_dword v4, off, s[8:11], 0
; VERDE-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_mip_1d_lwe:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    v_mov_b32_e32 v5, v0
; FIJI-NEXT:    v_mov_b32_e32 v0, 0
; FIJI-NEXT:    v_mov_b32_e32 v6, v1
; FIJI-NEXT:    v_mov_b32_e32 v1, v0
; FIJI-NEXT:    v_mov_b32_e32 v2, v0
; FIJI-NEXT:    v_mov_b32_e32 v3, v0
; FIJI-NEXT:    v_mov_b32_e32 v4, v0
; FIJI-NEXT:    image_load_mip v[0:4], v[5:6], s[0:7] dmask:0xf unorm lwe
; FIJI-NEXT:    s_mov_b32 s11, 0xf000
; FIJI-NEXT:    s_mov_b32 s10, -1
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    buffer_store_dword v4, off, s[8:11], 0
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_mip_1d_lwe:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    v_mov_b32_e32 v7, 0
; GFX6789-NEXT:    v_mov_b32_e32 v6, v1
; GFX6789-NEXT:    v_mov_b32_e32 v5, v0
; GFX6789-NEXT:    v_mov_b32_e32 v8, v7
; GFX6789-NEXT:    v_mov_b32_e32 v9, v7
; GFX6789-NEXT:    v_mov_b32_e32 v10, v7
; GFX6789-NEXT:    v_mov_b32_e32 v11, v7
; GFX6789-NEXT:    v_mov_b32_e32 v0, v7
; GFX6789-NEXT:    v_mov_b32_e32 v1, v8
; GFX6789-NEXT:    v_mov_b32_e32 v2, v9
; GFX6789-NEXT:    v_mov_b32_e32 v3, v10
; GFX6789-NEXT:    v_mov_b32_e32 v4, v11
; GFX6789-NEXT:    image_load_mip v[0:4], v[5:6], s[0:7] dmask:0xf unorm lwe
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    global_store_dword v7, v4, s[8:9]
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_mip_1d_lwe:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    v_mov_b32_e32 v4, 0
; NOPRT-NEXT:    image_load_mip v[0:4], v[0:1], s[0:7] dmask:0xf unorm lwe
; NOPRT-NEXT:    v_mov_b32_e32 v5, 0
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    global_store_dword v5, v4, s[8:9]
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: load_mip_1d_lwe:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    v_mov_b32_e32 v7, 0
; GFX10-NEXT:    v_mov_b32_e32 v6, v1
; GFX10-NEXT:    v_mov_b32_e32 v5, v0
; GFX10-NEXT:    v_mov_b32_e32 v8, v7
; GFX10-NEXT:    v_mov_b32_e32 v9, v7
; GFX10-NEXT:    v_mov_b32_e32 v10, v7
; GFX10-NEXT:    v_mov_b32_e32 v11, v7
; GFX10-NEXT:    v_mov_b32_e32 v0, v7
; GFX10-NEXT:    v_mov_b32_e32 v1, v8
; GFX10-NEXT:    v_mov_b32_e32 v2, v9
; GFX10-NEXT:    v_mov_b32_e32 v3, v10
; GFX10-NEXT:    v_mov_b32_e32 v4, v11
; GFX10-NEXT:    image_load_mip v[0:4], v[5:6], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D unorm lwe
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    global_store_dword v7, v4, s[8:9]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: load_mip_1d_lwe:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v7, 0
; GFX11-NEXT:    v_mov_b32_e32 v6, v1
; GFX11-NEXT:    v_mov_b32_e32 v5, v0
; GFX11-NEXT:    v_mov_b32_e32 v8, v7
; GFX11-NEXT:    v_mov_b32_e32 v9, v7
; GFX11-NEXT:    v_mov_b32_e32 v10, v7
; GFX11-NEXT:    v_mov_b32_e32 v11, v7
; GFX11-NEXT:    v_mov_b32_e32 v0, v7
; GFX11-NEXT:    v_mov_b32_e32 v1, v8
; GFX11-NEXT:    v_mov_b32_e32 v2, v9
; GFX11-NEXT:    v_mov_b32_e32 v3, v10
; GFX11-NEXT:    v_mov_b32_e32 v4, v11
; GFX11-NEXT:    image_load_mip v[0:4], v[5:6], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D unorm lwe
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b32 v7, v4, s[8:9]
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ; return to shader part epilog
main_body:
  %v = call {<4 x float>,i32} @llvm.amdgcn.image.load.mip.1d.v4f32i32.i32(i32 15, i32 %s, i32 %mip, <8 x i32> %rsrc, i32 2, i32 0)
  %v.vec = extractvalue {<4 x float>, i32} %v, 0
  %v.err = extractvalue {<4 x float>, i32} %v, 1
  store i32 %v.err, i32 addrspace(1)* %out, align 4
  ret <4 x float> %v.vec
}

define amdgpu_ps <4 x float> @load_mip_2d(<8 x i32> inreg %rsrc, i32 %s, i32 %t, i32 %mip) {
; VERDE-LABEL: load_mip_2d:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_load_mip v[0:3], v[0:2], s[0:7] dmask:0xf unorm
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_mip_2d:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_load_mip v[0:3], v[0:2], s[0:7] dmask:0xf unorm
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_mip_2d:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_load_mip v[0:3], v[0:2], s[0:7] dmask:0xf unorm
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_mip_2d:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_load_mip v[0:3], v[0:2], s[0:7] dmask:0xf unorm
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: load_mip_2d:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    image_load_mip v[0:3], v[0:2], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_2D unorm
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.load.mip.2d.v4f32.i32(i32 15, i32 %s, i32 %t, i32 %mip, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @load_mip_2d_tfe(<8 x i32> inreg %rsrc, i32 addrspace(1)* inreg %out, i32 %s, i32 %t, i32 %mip) {
; VERDE-LABEL: load_mip_2d_tfe:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    v_mov_b32_e32 v5, v0
; VERDE-NEXT:    v_mov_b32_e32 v0, 0
; VERDE-NEXT:    v_mov_b32_e32 v7, v2
; VERDE-NEXT:    v_mov_b32_e32 v6, v1
; VERDE-NEXT:    v_mov_b32_e32 v1, v0
; VERDE-NEXT:    v_mov_b32_e32 v2, v0
; VERDE-NEXT:    v_mov_b32_e32 v3, v0
; VERDE-NEXT:    v_mov_b32_e32 v4, v0
; VERDE-NEXT:    image_load_mip v[0:4], v[5:7], s[0:7] dmask:0xf unorm tfe
; VERDE-NEXT:    s_mov_b32 s11, 0xf000
; VERDE-NEXT:    s_mov_b32 s10, -1
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    buffer_store_dword v4, off, s[8:11], 0
; VERDE-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_mip_2d_tfe:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    v_mov_b32_e32 v5, v0
; FIJI-NEXT:    v_mov_b32_e32 v0, 0
; FIJI-NEXT:    v_mov_b32_e32 v7, v2
; FIJI-NEXT:    v_mov_b32_e32 v6, v1
; FIJI-NEXT:    v_mov_b32_e32 v1, v0
; FIJI-NEXT:    v_mov_b32_e32 v2, v0
; FIJI-NEXT:    v_mov_b32_e32 v3, v0
; FIJI-NEXT:    v_mov_b32_e32 v4, v0
; FIJI-NEXT:    image_load_mip v[0:4], v[5:7], s[0:7] dmask:0xf unorm tfe
; FIJI-NEXT:    s_mov_b32 s11, 0xf000
; FIJI-NEXT:    s_mov_b32 s10, -1
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    buffer_store_dword v4, off, s[8:11], 0
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_mip_2d_tfe:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    v_mov_b32_e32 v8, 0
; GFX6789-NEXT:    v_mov_b32_e32 v7, v2
; GFX6789-NEXT:    v_mov_b32_e32 v6, v1
; GFX6789-NEXT:    v_mov_b32_e32 v5, v0
; GFX6789-NEXT:    v_mov_b32_e32 v9, v8
; GFX6789-NEXT:    v_mov_b32_e32 v10, v8
; GFX6789-NEXT:    v_mov_b32_e32 v11, v8
; GFX6789-NEXT:    v_mov_b32_e32 v12, v8
; GFX6789-NEXT:    v_mov_b32_e32 v0, v8
; GFX6789-NEXT:    v_mov_b32_e32 v1, v9
; GFX6789-NEXT:    v_mov_b32_e32 v2, v10
; GFX6789-NEXT:    v_mov_b32_e32 v3, v11
; GFX6789-NEXT:    v_mov_b32_e32 v4, v12
; GFX6789-NEXT:    image_load_mip v[0:4], v[5:7], s[0:7] dmask:0xf unorm tfe
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    global_store_dword v8, v4, s[8:9]
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_mip_2d_tfe:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    v_mov_b32_e32 v4, 0
; NOPRT-NEXT:    image_load_mip v[0:4], v[0:2], s[0:7] dmask:0xf unorm tfe
; NOPRT-NEXT:    v_mov_b32_e32 v5, 0
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    global_store_dword v5, v4, s[8:9]
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: load_mip_2d_tfe:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    v_mov_b32_e32 v8, 0
; GFX10-NEXT:    v_mov_b32_e32 v7, v2
; GFX10-NEXT:    v_mov_b32_e32 v6, v1
; GFX10-NEXT:    v_mov_b32_e32 v5, v0
; GFX10-NEXT:    v_mov_b32_e32 v9, v8
; GFX10-NEXT:    v_mov_b32_e32 v10, v8
; GFX10-NEXT:    v_mov_b32_e32 v11, v8
; GFX10-NEXT:    v_mov_b32_e32 v12, v8
; GFX10-NEXT:    v_mov_b32_e32 v0, v8
; GFX10-NEXT:    v_mov_b32_e32 v1, v9
; GFX10-NEXT:    v_mov_b32_e32 v2, v10
; GFX10-NEXT:    v_mov_b32_e32 v3, v11
; GFX10-NEXT:    v_mov_b32_e32 v4, v12
; GFX10-NEXT:    image_load_mip v[0:4], v[5:7], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_2D unorm tfe
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    global_store_dword v8, v4, s[8:9]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: load_mip_2d_tfe:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v8, 0
; GFX11-NEXT:    v_mov_b32_e32 v7, v2
; GFX11-NEXT:    v_mov_b32_e32 v6, v1
; GFX11-NEXT:    v_mov_b32_e32 v5, v0
; GFX11-NEXT:    v_mov_b32_e32 v9, v8
; GFX11-NEXT:    v_mov_b32_e32 v10, v8
; GFX11-NEXT:    v_mov_b32_e32 v11, v8
; GFX11-NEXT:    v_mov_b32_e32 v12, v8
; GFX11-NEXT:    v_mov_b32_e32 v0, v8
; GFX11-NEXT:    v_mov_b32_e32 v1, v9
; GFX11-NEXT:    v_mov_b32_e32 v2, v10
; GFX11-NEXT:    v_mov_b32_e32 v3, v11
; GFX11-NEXT:    v_mov_b32_e32 v4, v12
; GFX11-NEXT:    image_load_mip v[0:4], v[5:7], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_2D unorm tfe
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b32 v8, v4, s[8:9]
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ; return to shader part epilog
main_body:
  %v = call {<4 x float>,i32} @llvm.amdgcn.image.load.mip.2d.v4f32i32.i32(i32 15, i32 %s, i32 %t, i32 %mip, <8 x i32> %rsrc, i32 1, i32 0)
  %v.vec = extractvalue {<4 x float>, i32} %v, 0
  %v.err = extractvalue {<4 x float>, i32} %v, 1
  store i32 %v.err, i32 addrspace(1)* %out, align 4
  ret <4 x float> %v.vec
}

define amdgpu_ps float @load_1d_V2_tfe_dmask0(<8 x i32> inreg %rsrc, i32 %s) {
; VERDE-LABEL: load_1d_V2_tfe_dmask0:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    v_mov_b32_e32 v1, 0
; VERDE-NEXT:    v_mov_b32_e32 v2, v1
; VERDE-NEXT:    image_load v[1:2], v0, s[0:7] dmask:0x1 unorm tfe
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    v_mov_b32_e32 v0, v2
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_1d_V2_tfe_dmask0:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    v_mov_b32_e32 v1, 0
; FIJI-NEXT:    v_mov_b32_e32 v2, v1
; FIJI-NEXT:    image_load v[1:2], v0, s[0:7] dmask:0x1 unorm tfe
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    v_mov_b32_e32 v0, v2
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_1d_V2_tfe_dmask0:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    v_mov_b32_e32 v1, 0
; GFX6789-NEXT:    v_mov_b32_e32 v2, v1
; GFX6789-NEXT:    image_load v[1:2], v0, s[0:7] dmask:0x1 unorm tfe
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    v_mov_b32_e32 v0, v2
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_1d_V2_tfe_dmask0:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    v_mov_b32_e32 v1, 0
; NOPRT-NEXT:    image_load v[0:1], v0, s[0:7] dmask:0x1 unorm tfe
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    v_mov_b32_e32 v0, v1
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: load_1d_V2_tfe_dmask0:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    v_mov_b32_e32 v1, 0
; GFX10PLUS-NEXT:    v_mov_b32_e32 v2, v1
; GFX10PLUS-NEXT:    image_load v[1:2], v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D unorm tfe
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    v_mov_b32_e32 v0, v2
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %v = call {<2 x float>,i32} @llvm.amdgcn.image.load.1d.v2f32i32.i32(i32 0, i32 %s, <8 x i32> %rsrc, i32 1, i32 0)
  %v.err = extractvalue {<2 x float>, i32} %v, 1
  %vv = bitcast i32 %v.err to float
  ret float %vv
}

define amdgpu_ps float @load_1d_V1_tfe_dmask0(<8 x i32> inreg %rsrc, i32 %s) {
; VERDE-LABEL: load_1d_V1_tfe_dmask0:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    v_mov_b32_e32 v1, 0
; VERDE-NEXT:    v_mov_b32_e32 v2, v1
; VERDE-NEXT:    image_load v[1:2], v0, s[0:7] dmask:0x1 unorm tfe
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    v_mov_b32_e32 v0, v2
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_1d_V1_tfe_dmask0:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    v_mov_b32_e32 v1, 0
; FIJI-NEXT:    v_mov_b32_e32 v2, v1
; FIJI-NEXT:    image_load v[1:2], v0, s[0:7] dmask:0x1 unorm tfe
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    v_mov_b32_e32 v0, v2
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_1d_V1_tfe_dmask0:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    v_mov_b32_e32 v1, 0
; GFX6789-NEXT:    v_mov_b32_e32 v2, v1
; GFX6789-NEXT:    image_load v[1:2], v0, s[0:7] dmask:0x1 unorm tfe
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    v_mov_b32_e32 v0, v2
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_1d_V1_tfe_dmask0:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    v_mov_b32_e32 v1, 0
; NOPRT-NEXT:    image_load v[0:1], v0, s[0:7] dmask:0x1 unorm tfe
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    v_mov_b32_e32 v0, v1
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: load_1d_V1_tfe_dmask0:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    v_mov_b32_e32 v1, 0
; GFX10PLUS-NEXT:    v_mov_b32_e32 v2, v1
; GFX10PLUS-NEXT:    image_load v[1:2], v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D unorm tfe
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    v_mov_b32_e32 v0, v2
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %v = call {float,i32} @llvm.amdgcn.image.load.1d.f32i32.i32(i32 0, i32 %s, <8 x i32> %rsrc, i32 1, i32 0)
  %v.err = extractvalue {float, i32} %v, 1
  %vv = bitcast i32 %v.err to float
  ret float %vv
}

define amdgpu_ps float @load_mip_2d_tfe_dmask0(<8 x i32> inreg %rsrc, i32 %s, i32 %t, i32 %mip) {
; VERDE-LABEL: load_mip_2d_tfe_dmask0:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    v_mov_b32_e32 v3, 0
; VERDE-NEXT:    v_mov_b32_e32 v4, v3
; VERDE-NEXT:    image_load_mip v[3:4], v[0:2], s[0:7] dmask:0x1 unorm tfe
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    v_mov_b32_e32 v0, v4
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_mip_2d_tfe_dmask0:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    v_mov_b32_e32 v3, 0
; FIJI-NEXT:    v_mov_b32_e32 v4, v3
; FIJI-NEXT:    image_load_mip v[3:4], v[0:2], s[0:7] dmask:0x1 unorm tfe
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    v_mov_b32_e32 v0, v4
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_mip_2d_tfe_dmask0:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    v_mov_b32_e32 v3, 0
; GFX6789-NEXT:    v_mov_b32_e32 v4, v3
; GFX6789-NEXT:    image_load_mip v[3:4], v[0:2], s[0:7] dmask:0x1 unorm tfe
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    v_mov_b32_e32 v0, v4
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_mip_2d_tfe_dmask0:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    v_mov_b32_e32 v3, 0
; NOPRT-NEXT:    image_load_mip v[2:3], v[0:2], s[0:7] dmask:0x1 unorm tfe
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    v_mov_b32_e32 v0, v3
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: load_mip_2d_tfe_dmask0:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    v_mov_b32_e32 v3, 0
; GFX10PLUS-NEXT:    v_mov_b32_e32 v4, v3
; GFX10PLUS-NEXT:    image_load_mip v[3:4], v[0:2], s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_2D unorm tfe
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    v_mov_b32_e32 v0, v4
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %v = call {<4 x float>,i32} @llvm.amdgcn.image.load.mip.2d.v4f32i32.i32(i32 0, i32 %s, i32 %t, i32 %mip, <8 x i32> %rsrc, i32 1, i32 0)
  %v.err = extractvalue {<4 x float>, i32} %v, 1
  %vv = bitcast i32 %v.err to float
  ret float %vv
}

define amdgpu_ps float @load_mip_2d_tfe_nouse(<8 x i32> inreg %rsrc, i32 %s, i32 %t, i32 %mip) {
; VERDE-LABEL: load_mip_2d_tfe_nouse:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    v_mov_b32_e32 v3, 0
; VERDE-NEXT:    v_mov_b32_e32 v4, v3
; VERDE-NEXT:    image_load_mip v[3:4], v[0:2], s[0:7] dmask:0x1 unorm tfe
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    v_mov_b32_e32 v0, v4
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_mip_2d_tfe_nouse:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    v_mov_b32_e32 v3, 0
; FIJI-NEXT:    v_mov_b32_e32 v4, v3
; FIJI-NEXT:    image_load_mip v[3:4], v[0:2], s[0:7] dmask:0x1 unorm tfe
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    v_mov_b32_e32 v0, v4
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_mip_2d_tfe_nouse:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    v_mov_b32_e32 v3, 0
; GFX6789-NEXT:    v_mov_b32_e32 v4, v3
; GFX6789-NEXT:    image_load_mip v[3:4], v[0:2], s[0:7] dmask:0x1 unorm tfe
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    v_mov_b32_e32 v0, v4
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_mip_2d_tfe_nouse:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    v_mov_b32_e32 v3, 0
; NOPRT-NEXT:    image_load_mip v[2:3], v[0:2], s[0:7] dmask:0x1 unorm tfe
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    v_mov_b32_e32 v0, v3
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: load_mip_2d_tfe_nouse:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    v_mov_b32_e32 v3, 0
; GFX10PLUS-NEXT:    v_mov_b32_e32 v4, v3
; GFX10PLUS-NEXT:    image_load_mip v[3:4], v[0:2], s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_2D unorm tfe
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    v_mov_b32_e32 v0, v4
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %v = call {<4 x float>,i32} @llvm.amdgcn.image.load.mip.2d.v4f32i32.i32(i32 15, i32 %s, i32 %t, i32 %mip, <8 x i32> %rsrc, i32 1, i32 0)
  %v.err = extractvalue {<4 x float>, i32} %v, 1
  %vv = bitcast i32 %v.err to float
  ret float %vv
}

define amdgpu_ps float @load_mip_2d_tfe_nouse_V2(<8 x i32> inreg %rsrc, i32 %s, i32 %t, i32 %mip) {
; VERDE-LABEL: load_mip_2d_tfe_nouse_V2:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    v_mov_b32_e32 v3, 0
; VERDE-NEXT:    v_mov_b32_e32 v4, v3
; VERDE-NEXT:    image_load_mip v[3:4], v[0:2], s[0:7] dmask:0x1 unorm tfe
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    v_mov_b32_e32 v0, v4
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_mip_2d_tfe_nouse_V2:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    v_mov_b32_e32 v3, 0
; FIJI-NEXT:    v_mov_b32_e32 v4, v3
; FIJI-NEXT:    image_load_mip v[3:4], v[0:2], s[0:7] dmask:0x1 unorm tfe
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    v_mov_b32_e32 v0, v4
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_mip_2d_tfe_nouse_V2:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    v_mov_b32_e32 v3, 0
; GFX6789-NEXT:    v_mov_b32_e32 v4, v3
; GFX6789-NEXT:    image_load_mip v[3:4], v[0:2], s[0:7] dmask:0x1 unorm tfe
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    v_mov_b32_e32 v0, v4
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_mip_2d_tfe_nouse_V2:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    v_mov_b32_e32 v3, 0
; NOPRT-NEXT:    image_load_mip v[2:3], v[0:2], s[0:7] dmask:0x1 unorm tfe
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    v_mov_b32_e32 v0, v3
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: load_mip_2d_tfe_nouse_V2:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    v_mov_b32_e32 v3, 0
; GFX10PLUS-NEXT:    v_mov_b32_e32 v4, v3
; GFX10PLUS-NEXT:    image_load_mip v[3:4], v[0:2], s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_2D unorm tfe
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    v_mov_b32_e32 v0, v4
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %v = call {<2 x float>,i32} @llvm.amdgcn.image.load.mip.2d.v2f32i32.i32(i32 6, i32 %s, i32 %t, i32 %mip, <8 x i32> %rsrc, i32 1, i32 0)
  %v.err = extractvalue {<2 x float>, i32} %v, 1
  %vv = bitcast i32 %v.err to float
  ret float %vv
}

define amdgpu_ps float @load_mip_2d_tfe_nouse_V1(<8 x i32> inreg %rsrc, i32 %s, i32 %t, i32 %mip) {
; VERDE-LABEL: load_mip_2d_tfe_nouse_V1:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    v_mov_b32_e32 v3, 0
; VERDE-NEXT:    v_mov_b32_e32 v4, v3
; VERDE-NEXT:    image_load_mip v[3:4], v[0:2], s[0:7] dmask:0x2 unorm tfe
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    v_mov_b32_e32 v0, v4
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_mip_2d_tfe_nouse_V1:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    v_mov_b32_e32 v3, 0
; FIJI-NEXT:    v_mov_b32_e32 v4, v3
; FIJI-NEXT:    image_load_mip v[3:4], v[0:2], s[0:7] dmask:0x2 unorm tfe
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    v_mov_b32_e32 v0, v4
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_mip_2d_tfe_nouse_V1:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    v_mov_b32_e32 v3, 0
; GFX6789-NEXT:    v_mov_b32_e32 v4, v3
; GFX6789-NEXT:    image_load_mip v[3:4], v[0:2], s[0:7] dmask:0x2 unorm tfe
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    v_mov_b32_e32 v0, v4
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_mip_2d_tfe_nouse_V1:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    v_mov_b32_e32 v3, 0
; NOPRT-NEXT:    image_load_mip v[2:3], v[0:2], s[0:7] dmask:0x2 unorm tfe
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    v_mov_b32_e32 v0, v3
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: load_mip_2d_tfe_nouse_V1:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    v_mov_b32_e32 v3, 0
; GFX10PLUS-NEXT:    v_mov_b32_e32 v4, v3
; GFX10PLUS-NEXT:    image_load_mip v[3:4], v[0:2], s[0:7] dmask:0x2 dim:SQ_RSRC_IMG_2D unorm tfe
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    v_mov_b32_e32 v0, v4
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %v = call {float, i32} @llvm.amdgcn.image.load.mip.2d.f32i32.i32(i32 2, i32 %s, i32 %t, i32 %mip, <8 x i32> %rsrc, i32 1, i32 0)
  %v.err = extractvalue {float, i32} %v, 1
  %vv = bitcast i32 %v.err to float
  ret float %vv
}

define amdgpu_ps <4 x float> @load_1d_tfe_V4_dmask3(<8 x i32> inreg %rsrc, i32 addrspace(1)* inreg %out, i32 %s) {
; VERDE-LABEL: load_1d_tfe_V4_dmask3:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    v_mov_b32_e32 v4, v0
; VERDE-NEXT:    v_mov_b32_e32 v0, 0
; VERDE-NEXT:    v_mov_b32_e32 v1, v0
; VERDE-NEXT:    v_mov_b32_e32 v2, v0
; VERDE-NEXT:    v_mov_b32_e32 v3, v0
; VERDE-NEXT:    image_load v[0:3], v4, s[0:7] dmask:0x7 unorm tfe
; VERDE-NEXT:    s_mov_b32 s11, 0xf000
; VERDE-NEXT:    s_mov_b32 s10, -1
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    buffer_store_dword v3, off, s[8:11], 0
; VERDE-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_1d_tfe_V4_dmask3:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    v_mov_b32_e32 v4, v0
; FIJI-NEXT:    v_mov_b32_e32 v0, 0
; FIJI-NEXT:    v_mov_b32_e32 v1, v0
; FIJI-NEXT:    v_mov_b32_e32 v2, v0
; FIJI-NEXT:    v_mov_b32_e32 v3, v0
; FIJI-NEXT:    image_load v[0:3], v4, s[0:7] dmask:0x7 unorm tfe
; FIJI-NEXT:    s_mov_b32 s11, 0xf000
; FIJI-NEXT:    s_mov_b32 s10, -1
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    buffer_store_dword v3, off, s[8:11], 0
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_1d_tfe_V4_dmask3:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    v_mov_b32_e32 v5, 0
; GFX6789-NEXT:    v_mov_b32_e32 v4, v0
; GFX6789-NEXT:    v_mov_b32_e32 v6, v5
; GFX6789-NEXT:    v_mov_b32_e32 v7, v5
; GFX6789-NEXT:    v_mov_b32_e32 v8, v5
; GFX6789-NEXT:    v_mov_b32_e32 v0, v5
; GFX6789-NEXT:    v_mov_b32_e32 v1, v6
; GFX6789-NEXT:    v_mov_b32_e32 v2, v7
; GFX6789-NEXT:    v_mov_b32_e32 v3, v8
; GFX6789-NEXT:    image_load v[0:3], v4, s[0:7] dmask:0x7 unorm tfe
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    global_store_dword v5, v3, s[8:9]
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_1d_tfe_V4_dmask3:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    v_mov_b32_e32 v3, 0
; NOPRT-NEXT:    image_load v[0:3], v0, s[0:7] dmask:0x7 unorm tfe
; NOPRT-NEXT:    v_mov_b32_e32 v4, 0
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    global_store_dword v4, v3, s[8:9]
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: load_1d_tfe_V4_dmask3:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    v_mov_b32_e32 v5, 0
; GFX10-NEXT:    v_mov_b32_e32 v4, v0
; GFX10-NEXT:    v_mov_b32_e32 v6, v5
; GFX10-NEXT:    v_mov_b32_e32 v7, v5
; GFX10-NEXT:    v_mov_b32_e32 v8, v5
; GFX10-NEXT:    v_mov_b32_e32 v0, v5
; GFX10-NEXT:    v_mov_b32_e32 v1, v6
; GFX10-NEXT:    v_mov_b32_e32 v2, v7
; GFX10-NEXT:    v_mov_b32_e32 v3, v8
; GFX10-NEXT:    image_load v[0:3], v4, s[0:7] dmask:0x7 dim:SQ_RSRC_IMG_1D unorm tfe
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    global_store_dword v5, v3, s[8:9]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: load_1d_tfe_V4_dmask3:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v5, 0
; GFX11-NEXT:    v_mov_b32_e32 v4, v0
; GFX11-NEXT:    v_mov_b32_e32 v6, v5
; GFX11-NEXT:    v_mov_b32_e32 v7, v5
; GFX11-NEXT:    v_mov_b32_e32 v8, v5
; GFX11-NEXT:    v_mov_b32_e32 v0, v5
; GFX11-NEXT:    v_mov_b32_e32 v1, v6
; GFX11-NEXT:    v_mov_b32_e32 v2, v7
; GFX11-NEXT:    v_mov_b32_e32 v3, v8
; GFX11-NEXT:    image_load v[0:3], v4, s[0:7] dmask:0x7 dim:SQ_RSRC_IMG_1D unorm tfe
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b32 v5, v3, s[8:9]
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ; return to shader part epilog
main_body:
  %v = call {<4 x float>,i32} @llvm.amdgcn.image.load.1d.v4f32i32.i32(i32 7, i32 %s, <8 x i32> %rsrc, i32 1, i32 0)
  %v.vec = extractvalue {<4 x float>, i32} %v, 0
  %v.err = extractvalue {<4 x float>, i32} %v, 1
  store i32 %v.err, i32 addrspace(1)* %out, align 4
  ret <4 x float> %v.vec
}

define amdgpu_ps <4 x float> @load_1d_tfe_V4_dmask2(<8 x i32> inreg %rsrc, i32 addrspace(1)* inreg %out, i32 %s) {
; VERDE-LABEL: load_1d_tfe_V4_dmask2:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    v_mov_b32_e32 v3, v0
; VERDE-NEXT:    v_mov_b32_e32 v0, 0
; VERDE-NEXT:    v_mov_b32_e32 v1, v0
; VERDE-NEXT:    v_mov_b32_e32 v2, v0
; VERDE-NEXT:    image_load v[0:2], v3, s[0:7] dmask:0x6 unorm tfe
; VERDE-NEXT:    s_mov_b32 s11, 0xf000
; VERDE-NEXT:    s_mov_b32 s10, -1
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    buffer_store_dword v2, off, s[8:11], 0
; VERDE-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_1d_tfe_V4_dmask2:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    v_mov_b32_e32 v3, v0
; FIJI-NEXT:    v_mov_b32_e32 v0, 0
; FIJI-NEXT:    v_mov_b32_e32 v1, v0
; FIJI-NEXT:    v_mov_b32_e32 v2, v0
; FIJI-NEXT:    image_load v[0:2], v3, s[0:7] dmask:0x6 unorm tfe
; FIJI-NEXT:    s_mov_b32 s11, 0xf000
; FIJI-NEXT:    s_mov_b32 s10, -1
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    buffer_store_dword v2, off, s[8:11], 0
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_1d_tfe_V4_dmask2:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    v_mov_b32_e32 v4, 0
; GFX6789-NEXT:    v_mov_b32_e32 v3, v0
; GFX6789-NEXT:    v_mov_b32_e32 v5, v4
; GFX6789-NEXT:    v_mov_b32_e32 v6, v4
; GFX6789-NEXT:    v_mov_b32_e32 v0, v4
; GFX6789-NEXT:    v_mov_b32_e32 v1, v5
; GFX6789-NEXT:    v_mov_b32_e32 v2, v6
; GFX6789-NEXT:    image_load v[0:2], v3, s[0:7] dmask:0x6 unorm tfe
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    global_store_dword v4, v2, s[8:9]
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_1d_tfe_V4_dmask2:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    v_mov_b32_e32 v2, 0
; NOPRT-NEXT:    image_load v[0:2], v0, s[0:7] dmask:0x6 unorm tfe
; NOPRT-NEXT:    v_mov_b32_e32 v3, 0
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    global_store_dword v3, v2, s[8:9]
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: load_1d_tfe_V4_dmask2:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-NEXT:    v_mov_b32_e32 v3, v0
; GFX10-NEXT:    v_mov_b32_e32 v5, v4
; GFX10-NEXT:    v_mov_b32_e32 v6, v4
; GFX10-NEXT:    v_mov_b32_e32 v0, v4
; GFX10-NEXT:    v_mov_b32_e32 v1, v5
; GFX10-NEXT:    v_mov_b32_e32 v2, v6
; GFX10-NEXT:    image_load v[0:2], v3, s[0:7] dmask:0x6 dim:SQ_RSRC_IMG_1D unorm tfe
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    global_store_dword v4, v2, s[8:9]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: load_1d_tfe_V4_dmask2:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v4, 0
; GFX11-NEXT:    v_mov_b32_e32 v3, v0
; GFX11-NEXT:    v_mov_b32_e32 v5, v4
; GFX11-NEXT:    v_mov_b32_e32 v6, v4
; GFX11-NEXT:    v_mov_b32_e32 v0, v4
; GFX11-NEXT:    v_mov_b32_e32 v1, v5
; GFX11-NEXT:    v_mov_b32_e32 v2, v6
; GFX11-NEXT:    image_load v[0:2], v3, s[0:7] dmask:0x6 dim:SQ_RSRC_IMG_1D unorm tfe
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b32 v4, v2, s[8:9]
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ; return to shader part epilog
main_body:
  %v = call {<4 x float>,i32} @llvm.amdgcn.image.load.1d.v4f32i32.i32(i32 6, i32 %s, <8 x i32> %rsrc, i32 1, i32 0)
  %v.vec = extractvalue {<4 x float>, i32} %v, 0
  %v.err = extractvalue {<4 x float>, i32} %v, 1
  store i32 %v.err, i32 addrspace(1)* %out, align 4
  ret <4 x float> %v.vec
}

define amdgpu_ps <4 x float> @load_1d_tfe_V4_dmask1(<8 x i32> inreg %rsrc, i32 addrspace(1)* inreg %out, i32 %s) {
; VERDE-LABEL: load_1d_tfe_V4_dmask1:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    v_mov_b32_e32 v2, v0
; VERDE-NEXT:    v_mov_b32_e32 v0, 0
; VERDE-NEXT:    v_mov_b32_e32 v1, v0
; VERDE-NEXT:    image_load v[0:1], v2, s[0:7] dmask:0x8 unorm tfe
; VERDE-NEXT:    s_mov_b32 s11, 0xf000
; VERDE-NEXT:    s_mov_b32 s10, -1
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    buffer_store_dword v1, off, s[8:11], 0
; VERDE-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_1d_tfe_V4_dmask1:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    v_mov_b32_e32 v2, v0
; FIJI-NEXT:    v_mov_b32_e32 v0, 0
; FIJI-NEXT:    v_mov_b32_e32 v1, v0
; FIJI-NEXT:    image_load v[0:1], v2, s[0:7] dmask:0x8 unorm tfe
; FIJI-NEXT:    s_mov_b32 s11, 0xf000
; FIJI-NEXT:    s_mov_b32 s10, -1
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    buffer_store_dword v1, off, s[8:11], 0
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_1d_tfe_V4_dmask1:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    v_mov_b32_e32 v3, 0
; GFX6789-NEXT:    v_mov_b32_e32 v2, v0
; GFX6789-NEXT:    v_mov_b32_e32 v4, v3
; GFX6789-NEXT:    v_mov_b32_e32 v0, v3
; GFX6789-NEXT:    v_mov_b32_e32 v1, v4
; GFX6789-NEXT:    image_load v[0:1], v2, s[0:7] dmask:0x8 unorm tfe
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    global_store_dword v3, v1, s[8:9]
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_1d_tfe_V4_dmask1:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    v_mov_b32_e32 v1, 0
; NOPRT-NEXT:    image_load v[0:1], v0, s[0:7] dmask:0x8 unorm tfe
; NOPRT-NEXT:    v_mov_b32_e32 v2, 0
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    global_store_dword v2, v1, s[8:9]
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: load_1d_tfe_V4_dmask1:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    v_mov_b32_e32 v3, 0
; GFX10-NEXT:    v_mov_b32_e32 v2, v0
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-NEXT:    v_mov_b32_e32 v1, v4
; GFX10-NEXT:    image_load v[0:1], v2, s[0:7] dmask:0x8 dim:SQ_RSRC_IMG_1D unorm tfe
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    global_store_dword v3, v1, s[8:9]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: load_1d_tfe_V4_dmask1:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v3, 0
; GFX11-NEXT:    v_mov_b32_e32 v2, v0
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    v_mov_b32_e32 v1, v4
; GFX11-NEXT:    image_load v[0:1], v2, s[0:7] dmask:0x8 dim:SQ_RSRC_IMG_1D unorm tfe
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b32 v3, v1, s[8:9]
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ; return to shader part epilog
main_body:
  %v = call {<4 x float>,i32} @llvm.amdgcn.image.load.1d.v4f32i32.i32(i32 8, i32 %s, <8 x i32> %rsrc, i32 1, i32 0)
  %v.vec = extractvalue {<4 x float>, i32} %v, 0
  %v.err = extractvalue {<4 x float>, i32} %v, 1
  store i32 %v.err, i32 addrspace(1)* %out, align 4
  ret <4 x float> %v.vec
}

define amdgpu_ps <2 x float> @load_1d_tfe_V2_dmask1(<8 x i32> inreg %rsrc, i32 addrspace(1)* inreg %out, i32 %s) {
; VERDE-LABEL: load_1d_tfe_V2_dmask1:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    v_mov_b32_e32 v2, v0
; VERDE-NEXT:    v_mov_b32_e32 v0, 0
; VERDE-NEXT:    v_mov_b32_e32 v1, v0
; VERDE-NEXT:    image_load v[0:1], v2, s[0:7] dmask:0x8 unorm tfe
; VERDE-NEXT:    s_mov_b32 s11, 0xf000
; VERDE-NEXT:    s_mov_b32 s10, -1
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    buffer_store_dword v1, off, s[8:11], 0
; VERDE-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_1d_tfe_V2_dmask1:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    v_mov_b32_e32 v2, v0
; FIJI-NEXT:    v_mov_b32_e32 v0, 0
; FIJI-NEXT:    v_mov_b32_e32 v1, v0
; FIJI-NEXT:    image_load v[0:1], v2, s[0:7] dmask:0x8 unorm tfe
; FIJI-NEXT:    s_mov_b32 s11, 0xf000
; FIJI-NEXT:    s_mov_b32 s10, -1
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    buffer_store_dword v1, off, s[8:11], 0
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_1d_tfe_V2_dmask1:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    v_mov_b32_e32 v3, 0
; GFX6789-NEXT:    v_mov_b32_e32 v2, v0
; GFX6789-NEXT:    v_mov_b32_e32 v4, v3
; GFX6789-NEXT:    v_mov_b32_e32 v0, v3
; GFX6789-NEXT:    v_mov_b32_e32 v1, v4
; GFX6789-NEXT:    image_load v[0:1], v2, s[0:7] dmask:0x8 unorm tfe
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    global_store_dword v3, v1, s[8:9]
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_1d_tfe_V2_dmask1:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    v_mov_b32_e32 v1, 0
; NOPRT-NEXT:    image_load v[0:1], v0, s[0:7] dmask:0x8 unorm tfe
; NOPRT-NEXT:    v_mov_b32_e32 v2, 0
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    global_store_dword v2, v1, s[8:9]
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: load_1d_tfe_V2_dmask1:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    v_mov_b32_e32 v3, 0
; GFX10-NEXT:    v_mov_b32_e32 v2, v0
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-NEXT:    v_mov_b32_e32 v1, v4
; GFX10-NEXT:    image_load v[0:1], v2, s[0:7] dmask:0x8 dim:SQ_RSRC_IMG_1D unorm tfe
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    global_store_dword v3, v1, s[8:9]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: load_1d_tfe_V2_dmask1:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v3, 0
; GFX11-NEXT:    v_mov_b32_e32 v2, v0
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    v_mov_b32_e32 v1, v4
; GFX11-NEXT:    image_load v[0:1], v2, s[0:7] dmask:0x8 dim:SQ_RSRC_IMG_1D unorm tfe
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b32 v3, v1, s[8:9]
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    ; return to shader part epilog
main_body:
  %v = call {<2 x float>,i32} @llvm.amdgcn.image.load.1d.v2f32i32.i32(i32 8, i32 %s, <8 x i32> %rsrc, i32 1, i32 0)
  %v.vec = extractvalue {<2 x float>, i32} %v, 0
  %v.err = extractvalue {<2 x float>, i32} %v, 1
  store i32 %v.err, i32 addrspace(1)* %out, align 4
  ret <2 x float> %v.vec
}


define amdgpu_ps <4 x float> @load_mip_3d(<8 x i32> inreg %rsrc, i32 %s, i32 %t, i32 %r, i32 %mip) {
; VERDE-LABEL: load_mip_3d:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_load_mip v[0:3], v[0:3], s[0:7] dmask:0xf unorm
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_mip_3d:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_load_mip v[0:3], v[0:3], s[0:7] dmask:0xf unorm
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_mip_3d:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_load_mip v[0:3], v[0:3], s[0:7] dmask:0xf unorm
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_mip_3d:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_load_mip v[0:3], v[0:3], s[0:7] dmask:0xf unorm
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: load_mip_3d:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    image_load_mip v[0:3], v[0:3], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_3D unorm
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.load.mip.3d.v4f32.i32(i32 15, i32 %s, i32 %t, i32 %r, i32 %mip, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @load_mip_cube(<8 x i32> inreg %rsrc, i32 %s, i32 %t, i32 %slice, i32 %mip) {
; VERDE-LABEL: load_mip_cube:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_load_mip v[0:3], v[0:3], s[0:7] dmask:0xf unorm da
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_mip_cube:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_load_mip v[0:3], v[0:3], s[0:7] dmask:0xf unorm da
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_mip_cube:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_load_mip v[0:3], v[0:3], s[0:7] dmask:0xf unorm da
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_mip_cube:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_load_mip v[0:3], v[0:3], s[0:7] dmask:0xf unorm da
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: load_mip_cube:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    image_load_mip v[0:3], v[0:3], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_CUBE unorm
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.load.mip.cube.v4f32.i32(i32 15, i32 %s, i32 %t, i32 %slice, i32 %mip, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @load_mip_1darray(<8 x i32> inreg %rsrc, i32 %s, i32 %slice, i32 %mip) {
; VERDE-LABEL: load_mip_1darray:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_load_mip v[0:3], v[0:2], s[0:7] dmask:0xf unorm da
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_mip_1darray:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_load_mip v[0:3], v[0:2], s[0:7] dmask:0xf unorm da
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_mip_1darray:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_load_mip v[0:3], v[0:2], s[0:7] dmask:0xf unorm da
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_mip_1darray:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_load_mip v[0:3], v[0:2], s[0:7] dmask:0xf unorm da
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: load_mip_1darray:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    image_load_mip v[0:3], v[0:2], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D_ARRAY unorm
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.load.mip.1darray.v4f32.i32(i32 15, i32 %s, i32 %slice, i32 %mip, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @load_mip_2darray(<8 x i32> inreg %rsrc, i32 %s, i32 %t, i32 %slice, i32 %mip) {
; VERDE-LABEL: load_mip_2darray:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_load_mip v[0:3], v[0:3], s[0:7] dmask:0xf unorm da
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_mip_2darray:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_load_mip v[0:3], v[0:3], s[0:7] dmask:0xf unorm da
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_mip_2darray:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_load_mip v[0:3], v[0:3], s[0:7] dmask:0xf unorm da
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_mip_2darray:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_load_mip v[0:3], v[0:3], s[0:7] dmask:0xf unorm da
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: load_mip_2darray:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    image_load_mip v[0:3], v[0:3], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY unorm
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.load.mip.2darray.v4f32.i32(i32 15, i32 %s, i32 %t, i32 %slice, i32 %mip, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps void @store_1d(<8 x i32> inreg %rsrc, <4 x float> %vdata, i32 %s) {
; VERDE-LABEL: store_1d:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_store v[0:3], v4, s[0:7] dmask:0xf unorm
; VERDE-NEXT:    s_endpgm
;
; FIJI-LABEL: store_1d:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_store v[0:3], v4, s[0:7] dmask:0xf unorm
; FIJI-NEXT:    s_endpgm
;
; GFX6789-LABEL: store_1d:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_store v[0:3], v4, s[0:7] dmask:0xf unorm
; GFX6789-NEXT:    s_endpgm
;
; NOPRT-LABEL: store_1d:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_store v[0:3], v4, s[0:7] dmask:0xf unorm
; NOPRT-NEXT:    s_endpgm
;
; GFX10-LABEL: store_1d:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    image_store v[0:3], v4, s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D unorm
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_1d:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    image_store v[0:3], v4, s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D unorm
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.image.store.1d.v4f32.i32(<4 x float> %vdata, i32 15, i32 %s, <8 x i32> %rsrc, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @store_2d(<8 x i32> inreg %rsrc, <4 x float> %vdata, i32 %s, i32 %t) {
; VERDE-LABEL: store_2d:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_store v[0:3], v[4:5], s[0:7] dmask:0xf unorm
; VERDE-NEXT:    s_endpgm
;
; FIJI-LABEL: store_2d:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_store v[0:3], v[4:5], s[0:7] dmask:0xf unorm
; FIJI-NEXT:    s_endpgm
;
; GFX6789-LABEL: store_2d:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_store v[0:3], v[4:5], s[0:7] dmask:0xf unorm
; GFX6789-NEXT:    s_endpgm
;
; NOPRT-LABEL: store_2d:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_store v[0:3], v[4:5], s[0:7] dmask:0xf unorm
; NOPRT-NEXT:    s_endpgm
;
; GFX10-LABEL: store_2d:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    image_store v[0:3], v[4:5], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_2D unorm
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_2d:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    image_store v[0:3], v[4:5], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_2D unorm
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.image.store.2d.v4f32.i32(<4 x float> %vdata, i32 15, i32 %s, i32 %t, <8 x i32> %rsrc, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @store_3d(<8 x i32> inreg %rsrc, <4 x float> %vdata, i32 %s, i32 %t, i32 %r) {
; VERDE-LABEL: store_3d:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_store v[0:3], v[4:6], s[0:7] dmask:0xf unorm
; VERDE-NEXT:    s_endpgm
;
; FIJI-LABEL: store_3d:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_store v[0:3], v[4:6], s[0:7] dmask:0xf unorm
; FIJI-NEXT:    s_endpgm
;
; GFX6789-LABEL: store_3d:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_store v[0:3], v[4:6], s[0:7] dmask:0xf unorm
; GFX6789-NEXT:    s_endpgm
;
; NOPRT-LABEL: store_3d:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_store v[0:3], v[4:6], s[0:7] dmask:0xf unorm
; NOPRT-NEXT:    s_endpgm
;
; GFX10-LABEL: store_3d:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    image_store v[0:3], v[4:6], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_3D unorm
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_3d:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    image_store v[0:3], v[4:6], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_3D unorm
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.image.store.3d.v4f32.i32(<4 x float> %vdata, i32 15, i32 %s, i32 %t, i32 %r, <8 x i32> %rsrc, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @store_cube(<8 x i32> inreg %rsrc, <4 x float> %vdata, i32 %s, i32 %t, i32 %slice) {
; VERDE-LABEL: store_cube:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_store v[0:3], v[4:6], s[0:7] dmask:0xf unorm da
; VERDE-NEXT:    s_endpgm
;
; FIJI-LABEL: store_cube:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_store v[0:3], v[4:6], s[0:7] dmask:0xf unorm da
; FIJI-NEXT:    s_endpgm
;
; GFX6789-LABEL: store_cube:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_store v[0:3], v[4:6], s[0:7] dmask:0xf unorm da
; GFX6789-NEXT:    s_endpgm
;
; NOPRT-LABEL: store_cube:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_store v[0:3], v[4:6], s[0:7] dmask:0xf unorm da
; NOPRT-NEXT:    s_endpgm
;
; GFX10-LABEL: store_cube:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    image_store v[0:3], v[4:6], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_CUBE unorm
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_cube:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    image_store v[0:3], v[4:6], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_CUBE unorm
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.image.store.cube.v4f32.i32(<4 x float> %vdata, i32 15, i32 %s, i32 %t, i32 %slice, <8 x i32> %rsrc, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @store_1darray(<8 x i32> inreg %rsrc, <4 x float> %vdata, i32 %s, i32 %slice) {
; VERDE-LABEL: store_1darray:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_store v[0:3], v[4:5], s[0:7] dmask:0xf unorm da
; VERDE-NEXT:    s_endpgm
;
; FIJI-LABEL: store_1darray:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_store v[0:3], v[4:5], s[0:7] dmask:0xf unorm da
; FIJI-NEXT:    s_endpgm
;
; GFX6789-LABEL: store_1darray:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_store v[0:3], v[4:5], s[0:7] dmask:0xf unorm da
; GFX6789-NEXT:    s_endpgm
;
; NOPRT-LABEL: store_1darray:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_store v[0:3], v[4:5], s[0:7] dmask:0xf unorm da
; NOPRT-NEXT:    s_endpgm
;
; GFX10-LABEL: store_1darray:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    image_store v[0:3], v[4:5], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D_ARRAY unorm
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_1darray:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    image_store v[0:3], v[4:5], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D_ARRAY unorm
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.image.store.1darray.v4f32.i32(<4 x float> %vdata, i32 15, i32 %s, i32 %slice, <8 x i32> %rsrc, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @store_2darray(<8 x i32> inreg %rsrc, <4 x float> %vdata, i32 %s, i32 %t, i32 %slice) {
; VERDE-LABEL: store_2darray:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_store v[0:3], v[4:6], s[0:7] dmask:0xf unorm da
; VERDE-NEXT:    s_endpgm
;
; FIJI-LABEL: store_2darray:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_store v[0:3], v[4:6], s[0:7] dmask:0xf unorm da
; FIJI-NEXT:    s_endpgm
;
; GFX6789-LABEL: store_2darray:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_store v[0:3], v[4:6], s[0:7] dmask:0xf unorm da
; GFX6789-NEXT:    s_endpgm
;
; NOPRT-LABEL: store_2darray:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_store v[0:3], v[4:6], s[0:7] dmask:0xf unorm da
; NOPRT-NEXT:    s_endpgm
;
; GFX10-LABEL: store_2darray:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    image_store v[0:3], v[4:6], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY unorm
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_2darray:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    image_store v[0:3], v[4:6], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY unorm
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.image.store.2darray.v4f32.i32(<4 x float> %vdata, i32 15, i32 %s, i32 %t, i32 %slice, <8 x i32> %rsrc, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @store_2dmsaa(<8 x i32> inreg %rsrc, <4 x float> %vdata, i32 %s, i32 %t, i32 %fragid) {
; VERDE-LABEL: store_2dmsaa:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_store v[0:3], v[4:6], s[0:7] dmask:0xf unorm
; VERDE-NEXT:    s_endpgm
;
; FIJI-LABEL: store_2dmsaa:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_store v[0:3], v[4:6], s[0:7] dmask:0xf unorm
; FIJI-NEXT:    s_endpgm
;
; GFX6789-LABEL: store_2dmsaa:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_store v[0:3], v[4:6], s[0:7] dmask:0xf unorm
; GFX6789-NEXT:    s_endpgm
;
; NOPRT-LABEL: store_2dmsaa:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_store v[0:3], v[4:6], s[0:7] dmask:0xf unorm
; NOPRT-NEXT:    s_endpgm
;
; GFX10-LABEL: store_2dmsaa:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    image_store v[0:3], v[4:6], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_2D_MSAA unorm
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_2dmsaa:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    image_store v[0:3], v[4:6], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_2D_MSAA unorm
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.image.store.2dmsaa.v4f32.i32(<4 x float> %vdata, i32 15, i32 %s, i32 %t, i32 %fragid, <8 x i32> %rsrc, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @store_2darraymsaa(<8 x i32> inreg %rsrc, <4 x float> %vdata, i32 %s, i32 %t, i32 %slice, i32 %fragid) {
; VERDE-LABEL: store_2darraymsaa:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_store v[0:3], v[4:7], s[0:7] dmask:0xf unorm da
; VERDE-NEXT:    s_endpgm
;
; FIJI-LABEL: store_2darraymsaa:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_store v[0:3], v[4:7], s[0:7] dmask:0xf unorm da
; FIJI-NEXT:    s_endpgm
;
; GFX6789-LABEL: store_2darraymsaa:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_store v[0:3], v[4:7], s[0:7] dmask:0xf unorm da
; GFX6789-NEXT:    s_endpgm
;
; NOPRT-LABEL: store_2darraymsaa:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_store v[0:3], v[4:7], s[0:7] dmask:0xf unorm da
; NOPRT-NEXT:    s_endpgm
;
; GFX10-LABEL: store_2darraymsaa:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    image_store v[0:3], v[4:7], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_2darraymsaa:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    image_store v[0:3], v[4:7], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.image.store.2darraymsaa.v4f32.i32(<4 x float> %vdata, i32 15, i32 %s, i32 %t, i32 %slice, i32 %fragid, <8 x i32> %rsrc, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @store_mip_1d(<8 x i32> inreg %rsrc, <4 x float> %vdata, i32 %s, i32 %mip) {
; VERDE-LABEL: store_mip_1d:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_store_mip v[0:3], v[4:5], s[0:7] dmask:0xf unorm
; VERDE-NEXT:    s_endpgm
;
; FIJI-LABEL: store_mip_1d:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_store_mip v[0:3], v[4:5], s[0:7] dmask:0xf unorm
; FIJI-NEXT:    s_endpgm
;
; GFX6789-LABEL: store_mip_1d:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_store_mip v[0:3], v[4:5], s[0:7] dmask:0xf unorm
; GFX6789-NEXT:    s_endpgm
;
; NOPRT-LABEL: store_mip_1d:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_store_mip v[0:3], v[4:5], s[0:7] dmask:0xf unorm
; NOPRT-NEXT:    s_endpgm
;
; GFX10-LABEL: store_mip_1d:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    image_store_mip v[0:3], v[4:5], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D unorm
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_mip_1d:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    image_store_mip v[0:3], v[4:5], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D unorm
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.image.store.mip.1d.v4f32.i32(<4 x float> %vdata, i32 15, i32 %s, i32 %mip, <8 x i32> %rsrc, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @store_mip_2d(<8 x i32> inreg %rsrc, <4 x float> %vdata, i32 %s, i32 %t, i32 %mip) {
; VERDE-LABEL: store_mip_2d:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_store_mip v[0:3], v[4:6], s[0:7] dmask:0xf unorm
; VERDE-NEXT:    s_endpgm
;
; FIJI-LABEL: store_mip_2d:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_store_mip v[0:3], v[4:6], s[0:7] dmask:0xf unorm
; FIJI-NEXT:    s_endpgm
;
; GFX6789-LABEL: store_mip_2d:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_store_mip v[0:3], v[4:6], s[0:7] dmask:0xf unorm
; GFX6789-NEXT:    s_endpgm
;
; NOPRT-LABEL: store_mip_2d:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_store_mip v[0:3], v[4:6], s[0:7] dmask:0xf unorm
; NOPRT-NEXT:    s_endpgm
;
; GFX10-LABEL: store_mip_2d:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    image_store_mip v[0:3], v[4:6], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_2D unorm
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_mip_2d:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    image_store_mip v[0:3], v[4:6], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_2D unorm
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.image.store.mip.2d.v4f32.i32(<4 x float> %vdata, i32 15, i32 %s, i32 %t, i32 %mip, <8 x i32> %rsrc, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @store_mip_3d(<8 x i32> inreg %rsrc, <4 x float> %vdata, i32 %s, i32 %t, i32 %r, i32 %mip) {
; VERDE-LABEL: store_mip_3d:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_store_mip v[0:3], v[4:7], s[0:7] dmask:0xf unorm
; VERDE-NEXT:    s_endpgm
;
; FIJI-LABEL: store_mip_3d:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_store_mip v[0:3], v[4:7], s[0:7] dmask:0xf unorm
; FIJI-NEXT:    s_endpgm
;
; GFX6789-LABEL: store_mip_3d:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_store_mip v[0:3], v[4:7], s[0:7] dmask:0xf unorm
; GFX6789-NEXT:    s_endpgm
;
; NOPRT-LABEL: store_mip_3d:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_store_mip v[0:3], v[4:7], s[0:7] dmask:0xf unorm
; NOPRT-NEXT:    s_endpgm
;
; GFX10-LABEL: store_mip_3d:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    image_store_mip v[0:3], v[4:7], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_3D unorm
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_mip_3d:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    image_store_mip v[0:3], v[4:7], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_3D unorm
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.image.store.mip.3d.v4f32.i32(<4 x float> %vdata, i32 15, i32 %s, i32 %t, i32 %r, i32 %mip, <8 x i32> %rsrc, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @store_mip_cube(<8 x i32> inreg %rsrc, <4 x float> %vdata, i32 %s, i32 %t, i32 %slice, i32 %mip) {
; VERDE-LABEL: store_mip_cube:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_store_mip v[0:3], v[4:7], s[0:7] dmask:0xf unorm da
; VERDE-NEXT:    s_endpgm
;
; FIJI-LABEL: store_mip_cube:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_store_mip v[0:3], v[4:7], s[0:7] dmask:0xf unorm da
; FIJI-NEXT:    s_endpgm
;
; GFX6789-LABEL: store_mip_cube:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_store_mip v[0:3], v[4:7], s[0:7] dmask:0xf unorm da
; GFX6789-NEXT:    s_endpgm
;
; NOPRT-LABEL: store_mip_cube:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_store_mip v[0:3], v[4:7], s[0:7] dmask:0xf unorm da
; NOPRT-NEXT:    s_endpgm
;
; GFX10-LABEL: store_mip_cube:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    image_store_mip v[0:3], v[4:7], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_CUBE unorm
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_mip_cube:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    image_store_mip v[0:3], v[4:7], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_CUBE unorm
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.image.store.mip.cube.v4f32.i32(<4 x float> %vdata, i32 15, i32 %s, i32 %t, i32 %slice, i32 %mip, <8 x i32> %rsrc, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @store_mip_1darray(<8 x i32> inreg %rsrc, <4 x float> %vdata, i32 %s, i32 %slice, i32 %mip) {
; VERDE-LABEL: store_mip_1darray:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_store_mip v[0:3], v[4:6], s[0:7] dmask:0xf unorm da
; VERDE-NEXT:    s_endpgm
;
; FIJI-LABEL: store_mip_1darray:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_store_mip v[0:3], v[4:6], s[0:7] dmask:0xf unorm da
; FIJI-NEXT:    s_endpgm
;
; GFX6789-LABEL: store_mip_1darray:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_store_mip v[0:3], v[4:6], s[0:7] dmask:0xf unorm da
; GFX6789-NEXT:    s_endpgm
;
; NOPRT-LABEL: store_mip_1darray:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_store_mip v[0:3], v[4:6], s[0:7] dmask:0xf unorm da
; NOPRT-NEXT:    s_endpgm
;
; GFX10-LABEL: store_mip_1darray:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    image_store_mip v[0:3], v[4:6], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D_ARRAY unorm
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_mip_1darray:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    image_store_mip v[0:3], v[4:6], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D_ARRAY unorm
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.image.store.mip.1darray.v4f32.i32(<4 x float> %vdata, i32 15, i32 %s, i32 %slice, i32 %mip, <8 x i32> %rsrc, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @store_mip_2darray(<8 x i32> inreg %rsrc, <4 x float> %vdata, i32 %s, i32 %t, i32 %slice, i32 %mip) {
; VERDE-LABEL: store_mip_2darray:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_store_mip v[0:3], v[4:7], s[0:7] dmask:0xf unorm da
; VERDE-NEXT:    s_endpgm
;
; FIJI-LABEL: store_mip_2darray:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_store_mip v[0:3], v[4:7], s[0:7] dmask:0xf unorm da
; FIJI-NEXT:    s_endpgm
;
; GFX6789-LABEL: store_mip_2darray:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_store_mip v[0:3], v[4:7], s[0:7] dmask:0xf unorm da
; GFX6789-NEXT:    s_endpgm
;
; NOPRT-LABEL: store_mip_2darray:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_store_mip v[0:3], v[4:7], s[0:7] dmask:0xf unorm da
; NOPRT-NEXT:    s_endpgm
;
; GFX10-LABEL: store_mip_2darray:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    image_store_mip v[0:3], v[4:7], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY unorm
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_mip_2darray:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    image_store_mip v[0:3], v[4:7], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY unorm
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.image.store.mip.2darray.v4f32.i32(<4 x float> %vdata, i32 15, i32 %s, i32 %t, i32 %slice, i32 %mip, <8 x i32> %rsrc, i32 0, i32 0)
  ret void
}

define amdgpu_ps <4 x float> @getresinfo_1d(<8 x i32> inreg %rsrc, i32 %mip) {
; VERDE-LABEL: getresinfo_1d:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf unorm
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: getresinfo_1d:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf unorm
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: getresinfo_1d:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf unorm
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: getresinfo_1d:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf unorm
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: getresinfo_1d:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D unorm
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.getresinfo.1d.v4f32.i32(i32 15, i32 %mip, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @getresinfo_2d(<8 x i32> inreg %rsrc, i32 %mip) {
; VERDE-LABEL: getresinfo_2d:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf unorm
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: getresinfo_2d:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf unorm
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: getresinfo_2d:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf unorm
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: getresinfo_2d:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf unorm
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: getresinfo_2d:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf dim:SQ_RSRC_IMG_2D unorm
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.getresinfo.2d.v4f32.i32(i32 15, i32 %mip, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @getresinfo_3d(<8 x i32> inreg %rsrc, i32 %mip) {
; VERDE-LABEL: getresinfo_3d:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf unorm
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: getresinfo_3d:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf unorm
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: getresinfo_3d:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf unorm
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: getresinfo_3d:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf unorm
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: getresinfo_3d:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf dim:SQ_RSRC_IMG_3D unorm
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.getresinfo.3d.v4f32.i32(i32 15, i32 %mip, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @getresinfo_cube(<8 x i32> inreg %rsrc, i32 %mip) {
; VERDE-LABEL: getresinfo_cube:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf unorm da
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: getresinfo_cube:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf unorm da
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: getresinfo_cube:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf unorm da
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: getresinfo_cube:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf unorm da
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: getresinfo_cube:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf dim:SQ_RSRC_IMG_CUBE unorm
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.getresinfo.cube.v4f32.i32(i32 15, i32 %mip, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @getresinfo_1darray(<8 x i32> inreg %rsrc, i32 %mip) {
; VERDE-LABEL: getresinfo_1darray:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf unorm da
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: getresinfo_1darray:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf unorm da
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: getresinfo_1darray:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf unorm da
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: getresinfo_1darray:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf unorm da
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: getresinfo_1darray:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D_ARRAY unorm
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.getresinfo.1darray.v4f32.i32(i32 15, i32 %mip, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @getresinfo_2darray(<8 x i32> inreg %rsrc, i32 %mip) {
; VERDE-LABEL: getresinfo_2darray:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf unorm da
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: getresinfo_2darray:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf unorm da
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: getresinfo_2darray:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf unorm da
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: getresinfo_2darray:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf unorm da
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: getresinfo_2darray:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY unorm
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.getresinfo.2darray.v4f32.i32(i32 15, i32 %mip, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @getresinfo_2dmsaa(<8 x i32> inreg %rsrc, i32 %mip) {
; VERDE-LABEL: getresinfo_2dmsaa:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf unorm
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: getresinfo_2dmsaa:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf unorm
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: getresinfo_2dmsaa:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf unorm
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: getresinfo_2dmsaa:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf unorm
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: getresinfo_2dmsaa:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf dim:SQ_RSRC_IMG_2D_MSAA unorm
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.getresinfo.2dmsaa.v4f32.i32(i32 15, i32 %mip, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @getresinfo_2darraymsaa(<8 x i32> inreg %rsrc, i32 %mip) {
; VERDE-LABEL: getresinfo_2darraymsaa:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf unorm da
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: getresinfo_2darraymsaa:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf unorm da
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: getresinfo_2darraymsaa:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf unorm da
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: getresinfo_2darraymsaa:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf unorm da
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: getresinfo_2darraymsaa:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    image_get_resinfo v[0:3], v0, s[0:7] dmask:0xf dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.getresinfo.2darraymsaa.v4f32.i32(i32 15, i32 %mip, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps float @load_1d_V1(<8 x i32> inreg %rsrc, i32 %s) {
; VERDE-LABEL: load_1d_V1:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_load v0, v0, s[0:7] dmask:0x8 unorm
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_1d_V1:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_load v0, v0, s[0:7] dmask:0x8 unorm
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_1d_V1:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_load v0, v0, s[0:7] dmask:0x8 unorm
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_1d_V1:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_load v0, v0, s[0:7] dmask:0x8 unorm
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: load_1d_V1:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    image_load v0, v0, s[0:7] dmask:0x8 dim:SQ_RSRC_IMG_1D unorm
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %v = call float @llvm.amdgcn.image.load.1d.f32.i32(i32 8, i32 %s, <8 x i32> %rsrc, i32 0, i32 0)
  ret float %v
}

define amdgpu_ps <2 x float> @load_1d_V2(<8 x i32> inreg %rsrc, i32 %s) {
; VERDE-LABEL: load_1d_V2:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_load v[0:1], v0, s[0:7] dmask:0x9 unorm
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_1d_V2:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_load v[0:1], v0, s[0:7] dmask:0x9 unorm
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_1d_V2:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_load v[0:1], v0, s[0:7] dmask:0x9 unorm
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_1d_V2:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_load v[0:1], v0, s[0:7] dmask:0x9 unorm
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: load_1d_V2:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    image_load v[0:1], v0, s[0:7] dmask:0x9 dim:SQ_RSRC_IMG_1D unorm
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %v = call <2 x float> @llvm.amdgcn.image.load.1d.v2f32.i32(i32 9, i32 %s, <8 x i32> %rsrc, i32 0, i32 0)
  ret <2 x float> %v
}

define amdgpu_ps void @store_1d_V1(<8 x i32> inreg %rsrc, float %vdata, i32 %s) {
; VERDE-LABEL: store_1d_V1:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_store v0, v1, s[0:7] dmask:0x2 unorm
; VERDE-NEXT:    s_endpgm
;
; FIJI-LABEL: store_1d_V1:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_store v0, v1, s[0:7] dmask:0x2 unorm
; FIJI-NEXT:    s_endpgm
;
; GFX6789-LABEL: store_1d_V1:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_store v0, v1, s[0:7] dmask:0x2 unorm
; GFX6789-NEXT:    s_endpgm
;
; NOPRT-LABEL: store_1d_V1:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_store v0, v1, s[0:7] dmask:0x2 unorm
; NOPRT-NEXT:    s_endpgm
;
; GFX10-LABEL: store_1d_V1:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    image_store v0, v1, s[0:7] dmask:0x2 dim:SQ_RSRC_IMG_1D unorm
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_1d_V1:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    image_store v0, v1, s[0:7] dmask:0x2 dim:SQ_RSRC_IMG_1D unorm
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.image.store.1d.f32.i32(float %vdata, i32 2, i32 %s, <8 x i32> %rsrc, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @store_1d_V2(<8 x i32> inreg %rsrc, <2 x float> %vdata, i32 %s) {
; VERDE-LABEL: store_1d_V2:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_store v[0:1], v2, s[0:7] dmask:0xc unorm
; VERDE-NEXT:    s_endpgm
;
; FIJI-LABEL: store_1d_V2:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_store v[0:1], v2, s[0:7] dmask:0xc unorm
; FIJI-NEXT:    s_endpgm
;
; GFX6789-LABEL: store_1d_V2:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_store v[0:1], v2, s[0:7] dmask:0xc unorm
; GFX6789-NEXT:    s_endpgm
;
; NOPRT-LABEL: store_1d_V2:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_store v[0:1], v2, s[0:7] dmask:0xc unorm
; NOPRT-NEXT:    s_endpgm
;
; GFX10-LABEL: store_1d_V2:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    image_store v[0:1], v2, s[0:7] dmask:0xc dim:SQ_RSRC_IMG_1D unorm
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_1d_V2:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    image_store v[0:1], v2, s[0:7] dmask:0xc dim:SQ_RSRC_IMG_1D unorm
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.image.store.1d.v2f32.i32(<2 x float> %vdata, i32 12, i32 %s, <8 x i32> %rsrc, i32 0, i32 0)
  ret void
}

define amdgpu_ps <4 x float> @load_1d_glc(<8 x i32> inreg %rsrc, i32 %s) {
; VERDE-LABEL: load_1d_glc:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_load v[0:3], v0, s[0:7] dmask:0xf unorm glc
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_1d_glc:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_load v[0:3], v0, s[0:7] dmask:0xf unorm glc
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_1d_glc:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_load v[0:3], v0, s[0:7] dmask:0xf unorm glc
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_1d_glc:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_load v[0:3], v0, s[0:7] dmask:0xf unorm glc
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: load_1d_glc:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    image_load v[0:3], v0, s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D unorm glc
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.load.1d.v4f32.i32(i32 15, i32 %s, <8 x i32> %rsrc, i32 0, i32 1)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @load_1d_slc(<8 x i32> inreg %rsrc, i32 %s) {
; VERDE-LABEL: load_1d_slc:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_load v[0:3], v0, s[0:7] dmask:0xf unorm slc
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_1d_slc:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_load v[0:3], v0, s[0:7] dmask:0xf unorm slc
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_1d_slc:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_load v[0:3], v0, s[0:7] dmask:0xf unorm slc
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_1d_slc:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_load v[0:3], v0, s[0:7] dmask:0xf unorm slc
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: load_1d_slc:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    image_load v[0:3], v0, s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D unorm slc
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.load.1d.v4f32.i32(i32 15, i32 %s, <8 x i32> %rsrc, i32 0, i32 2)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @load_1d_glc_slc(<8 x i32> inreg %rsrc, i32 %s) {
; VERDE-LABEL: load_1d_glc_slc:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_load v[0:3], v0, s[0:7] dmask:0xf unorm glc slc
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: load_1d_glc_slc:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_load v[0:3], v0, s[0:7] dmask:0xf unorm glc slc
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: load_1d_glc_slc:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_load v[0:3], v0, s[0:7] dmask:0xf unorm glc slc
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: load_1d_glc_slc:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_load v[0:3], v0, s[0:7] dmask:0xf unorm glc slc
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: load_1d_glc_slc:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    image_load v[0:3], v0, s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D unorm glc slc
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.load.1d.v4f32.i32(i32 15, i32 %s, <8 x i32> %rsrc, i32 0, i32 3)
  ret <4 x float> %v
}

define amdgpu_ps void @store_1d_glc(<8 x i32> inreg %rsrc, <4 x float> %vdata, i32 %s) {
; VERDE-LABEL: store_1d_glc:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_store v[0:3], v4, s[0:7] dmask:0xf unorm glc
; VERDE-NEXT:    s_endpgm
;
; FIJI-LABEL: store_1d_glc:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_store v[0:3], v4, s[0:7] dmask:0xf unorm glc
; FIJI-NEXT:    s_endpgm
;
; GFX6789-LABEL: store_1d_glc:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_store v[0:3], v4, s[0:7] dmask:0xf unorm glc
; GFX6789-NEXT:    s_endpgm
;
; NOPRT-LABEL: store_1d_glc:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_store v[0:3], v4, s[0:7] dmask:0xf unorm glc
; NOPRT-NEXT:    s_endpgm
;
; GFX10-LABEL: store_1d_glc:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    image_store v[0:3], v4, s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D unorm glc
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_1d_glc:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    image_store v[0:3], v4, s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D unorm glc
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.image.store.1d.v4f32.i32(<4 x float> %vdata, i32 15, i32 %s, <8 x i32> %rsrc, i32 0, i32 1)
  ret void
}

define amdgpu_ps void @store_1d_slc(<8 x i32> inreg %rsrc, <4 x float> %vdata, i32 %s) {
; VERDE-LABEL: store_1d_slc:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_store v[0:3], v4, s[0:7] dmask:0xf unorm slc
; VERDE-NEXT:    s_endpgm
;
; FIJI-LABEL: store_1d_slc:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_store v[0:3], v4, s[0:7] dmask:0xf unorm slc
; FIJI-NEXT:    s_endpgm
;
; GFX6789-LABEL: store_1d_slc:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_store v[0:3], v4, s[0:7] dmask:0xf unorm slc
; GFX6789-NEXT:    s_endpgm
;
; NOPRT-LABEL: store_1d_slc:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_store v[0:3], v4, s[0:7] dmask:0xf unorm slc
; NOPRT-NEXT:    s_endpgm
;
; GFX10-LABEL: store_1d_slc:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    image_store v[0:3], v4, s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D unorm slc
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_1d_slc:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    image_store v[0:3], v4, s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D unorm slc
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.image.store.1d.v4f32.i32(<4 x float> %vdata, i32 15, i32 %s, <8 x i32> %rsrc, i32 0, i32 2)
  ret void
}

define amdgpu_ps void @store_1d_glc_slc(<8 x i32> inreg %rsrc, <4 x float> %vdata, i32 %s) {
; VERDE-LABEL: store_1d_glc_slc:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_store v[0:3], v4, s[0:7] dmask:0xf unorm glc slc
; VERDE-NEXT:    s_endpgm
;
; FIJI-LABEL: store_1d_glc_slc:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_store v[0:3], v4, s[0:7] dmask:0xf unorm glc slc
; FIJI-NEXT:    s_endpgm
;
; GFX6789-LABEL: store_1d_glc_slc:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_store v[0:3], v4, s[0:7] dmask:0xf unorm glc slc
; GFX6789-NEXT:    s_endpgm
;
; NOPRT-LABEL: store_1d_glc_slc:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_store v[0:3], v4, s[0:7] dmask:0xf unorm glc slc
; NOPRT-NEXT:    s_endpgm
;
; GFX10-LABEL: store_1d_glc_slc:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    image_store v[0:3], v4, s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D unorm glc slc
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_1d_glc_slc:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    image_store v[0:3], v4, s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D unorm glc slc
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.image.store.1d.v4f32.i32(<4 x float> %vdata, i32 15, i32 %s, <8 x i32> %rsrc, i32 0, i32 3)
  ret void
}

define amdgpu_ps <3 x float> @getresinfo_dmask7(<8 x i32> inreg %rsrc, <4 x float> %vdata, i32 %mip) {
; GFX6-LABEL: getresinfo_dmask7:
; GFX6:       ; %bb.0: ; %main_body
; GFX6-NEXT:    s_mov_b32 s0, s2
; GFX6-NEXT:    s_mov_b32 s1, s3
; GFX6-NEXT:    s_mov_b32 s2, s4
; GFX6-NEXT:    s_mov_b32 s3, s5
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s7
; GFX6-NEXT:    s_mov_b32 s6, s8
; GFX6-NEXT:    s_mov_b32 s7, s9
; GFX6-NEXT:    image_get_resinfo v[0:2], v0, s[0:7] dmask:0x7 unorm
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: getresinfo_dmask7:
; GFX8:       ; %bb.0: ; %main_body
; GFX8-NEXT:    s_mov_b32 s0, s2
; GFX8-NEXT:    s_mov_b32 s1, s3
; GFX8-NEXT:    s_mov_b32 s2, s4
; GFX8-NEXT:    s_mov_b32 s3, s5
; GFX8-NEXT:    s_mov_b32 s4, s6
; GFX8-NEXT:    s_mov_b32 s5, s7
; GFX8-NEXT:    s_mov_b32 s6, s8
; GFX8-NEXT:    s_mov_b32 s7, s9
; GFX8-NEXT:    image_get_resinfo v[0:2], v0, s[0:7] dmask:0x7 unorm
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    ; return to shader part epilog
;
; VERDE-LABEL: getresinfo_dmask7:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_get_resinfo v[0:2], v0, s[0:7] dmask:0x7 unorm
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: getresinfo_dmask7:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_get_resinfo v[0:2], v0, s[0:7] dmask:0x7 unorm
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: getresinfo_dmask7:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_get_resinfo v[0:2], v0, s[0:7] dmask:0x7 unorm
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: getresinfo_dmask7:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_get_resinfo v[0:2], v0, s[0:7] dmask:0x7 unorm
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: getresinfo_dmask7:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    image_get_resinfo v[0:2], v0, s[0:7] dmask:0x7 dim:SQ_RSRC_IMG_1D unorm
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %r = call <3 x float> @llvm.amdgcn.image.getresinfo.1d.v3f32.i32(i32 7, i32 %mip, <8 x i32> %rsrc, i32 0, i32 0)
  ret <3 x float> %r
}

define amdgpu_ps <2 x float> @getresinfo_dmask3(<8 x i32> inreg %rsrc, <4 x float> %vdata, i32 %mip) {
; GFX6-LABEL: getresinfo_dmask3:
; GFX6:       ; %bb.0: ; %main_body
; GFX6-NEXT:    s_mov_b32 s0, s2
; GFX6-NEXT:    s_mov_b32 s1, s3
; GFX6-NEXT:    s_mov_b32 s2, s4
; GFX6-NEXT:    s_mov_b32 s3, s5
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s7
; GFX6-NEXT:    s_mov_b32 s6, s8
; GFX6-NEXT:    s_mov_b32 s7, s9
; GFX6-NEXT:    image_get_resinfo v[0:1], v0, s[0:7] dmask:0x3 unorm
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: getresinfo_dmask3:
; GFX8:       ; %bb.0: ; %main_body
; GFX8-NEXT:    s_mov_b32 s0, s2
; GFX8-NEXT:    s_mov_b32 s1, s3
; GFX8-NEXT:    s_mov_b32 s2, s4
; GFX8-NEXT:    s_mov_b32 s3, s5
; GFX8-NEXT:    s_mov_b32 s4, s6
; GFX8-NEXT:    s_mov_b32 s5, s7
; GFX8-NEXT:    s_mov_b32 s6, s8
; GFX8-NEXT:    s_mov_b32 s7, s9
; GFX8-NEXT:    image_get_resinfo v[0:1], v0, s[0:7] dmask:0x3 unorm
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    ; return to shader part epilog
;
; VERDE-LABEL: getresinfo_dmask3:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_get_resinfo v[0:1], v0, s[0:7] dmask:0x3 unorm
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: getresinfo_dmask3:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_get_resinfo v[0:1], v0, s[0:7] dmask:0x3 unorm
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: getresinfo_dmask3:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_get_resinfo v[0:1], v0, s[0:7] dmask:0x3 unorm
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: getresinfo_dmask3:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_get_resinfo v[0:1], v0, s[0:7] dmask:0x3 unorm
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: getresinfo_dmask3:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    image_get_resinfo v[0:1], v0, s[0:7] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %r = call <2 x float> @llvm.amdgcn.image.getresinfo.1d.v2f32.i32(i32 3, i32 %mip, <8 x i32> %rsrc, i32 0, i32 0)
  ret <2 x float> %r
}

define amdgpu_ps float @getresinfo_dmask1(<8 x i32> inreg %rsrc, <4 x float> %vdata, i32 %mip) {
; GFX6-LABEL: getresinfo_dmask1:
; GFX6:       ; %bb.0: ; %main_body
; GFX6-NEXT:    s_mov_b32 s0, s2
; GFX6-NEXT:    s_mov_b32 s1, s3
; GFX6-NEXT:    s_mov_b32 s2, s4
; GFX6-NEXT:    s_mov_b32 s3, s5
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s7
; GFX6-NEXT:    s_mov_b32 s6, s8
; GFX6-NEXT:    s_mov_b32 s7, s9
; GFX6-NEXT:    image_get_resinfo v0, v0, s[0:7] dmask:0x1 unorm
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: getresinfo_dmask1:
; GFX8:       ; %bb.0: ; %main_body
; GFX8-NEXT:    s_mov_b32 s0, s2
; GFX8-NEXT:    s_mov_b32 s1, s3
; GFX8-NEXT:    s_mov_b32 s2, s4
; GFX8-NEXT:    s_mov_b32 s3, s5
; GFX8-NEXT:    s_mov_b32 s4, s6
; GFX8-NEXT:    s_mov_b32 s5, s7
; GFX8-NEXT:    s_mov_b32 s6, s8
; GFX8-NEXT:    s_mov_b32 s7, s9
; GFX8-NEXT:    image_get_resinfo v0, v0, s[0:7] dmask:0x1 unorm
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    ; return to shader part epilog
;
; VERDE-LABEL: getresinfo_dmask1:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_get_resinfo v0, v0, s[0:7] dmask:0x1 unorm
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: getresinfo_dmask1:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_get_resinfo v0, v0, s[0:7] dmask:0x1 unorm
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: getresinfo_dmask1:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_get_resinfo v0, v0, s[0:7] dmask:0x1 unorm
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: getresinfo_dmask1:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_get_resinfo v0, v0, s[0:7] dmask:0x1 unorm
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: getresinfo_dmask1:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    image_get_resinfo v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D unorm
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %r = call float @llvm.amdgcn.image.getresinfo.1d.f32.i32(i32 1, i32 %mip, <8 x i32> %rsrc, i32 0, i32 0)
  ret float %r
}

define amdgpu_ps <4 x float> @getresinfo_dmask0(<8 x i32> inreg %rsrc, <4 x float> %vdata, i32 %mip) #0 {
; VERDE-LABEL: getresinfo_dmask0:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: getresinfo_dmask0:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: getresinfo_dmask0:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: getresinfo_dmask0:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: getresinfo_dmask0:
; GFX10PLUS:       ; %bb.0: ; %main_body
; GFX10PLUS-NEXT:    ; return to shader part epilog
main_body:
  %r = call <4 x float> @llvm.amdgcn.image.getresinfo.1d.v4f32.i32(i32 0, i32 %mip, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x float> %r
}

;
define amdgpu_ps void @image_store_wait(<8 x i32> inreg %arg, <8 x i32> inreg %arg1, <8 x i32> inreg %arg2, <4 x float> %arg3, i32 %arg4) #0 {
; VERDE-LABEL: image_store_wait:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    image_store v[0:3], v4, s[0:7] dmask:0xf unorm
; VERDE-NEXT:    s_waitcnt expcnt(0)
; VERDE-NEXT:    image_load v[0:3], v4, s[8:15] dmask:0xf unorm
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    image_store v[0:3], v4, s[16:23] dmask:0xf unorm
; VERDE-NEXT:    s_endpgm
;
; FIJI-LABEL: image_store_wait:
; FIJI:       ; %bb.0: ; %main_body
; FIJI-NEXT:    image_store v[0:3], v4, s[0:7] dmask:0xf unorm
; FIJI-NEXT:    image_load v[0:3], v4, s[8:15] dmask:0xf unorm
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    image_store v[0:3], v4, s[16:23] dmask:0xf unorm
; FIJI-NEXT:    s_endpgm
;
; GFX6789-LABEL: image_store_wait:
; GFX6789:       ; %bb.0: ; %main_body
; GFX6789-NEXT:    image_store v[0:3], v4, s[0:7] dmask:0xf unorm
; GFX6789-NEXT:    image_load v[0:3], v4, s[8:15] dmask:0xf unorm
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    image_store v[0:3], v4, s[16:23] dmask:0xf unorm
; GFX6789-NEXT:    s_endpgm
;
; NOPRT-LABEL: image_store_wait:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    image_store v[0:3], v4, s[0:7] dmask:0xf unorm
; NOPRT-NEXT:    image_load v[0:3], v4, s[8:15] dmask:0xf unorm
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    image_store v[0:3], v4, s[16:23] dmask:0xf unorm
; NOPRT-NEXT:    s_endpgm
;
; GFX10-LABEL: image_store_wait:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    image_store v[0:3], v4, s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D unorm
; GFX10-NEXT:    image_load v[0:3], v4, s[8:15] dmask:0xf dim:SQ_RSRC_IMG_1D unorm
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    image_store v[0:3], v4, s[16:23] dmask:0xf dim:SQ_RSRC_IMG_1D unorm
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: image_store_wait:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    image_store v[0:3], v4, s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D unorm
; GFX11-NEXT:    image_load v[0:3], v4, s[8:15] dmask:0xf dim:SQ_RSRC_IMG_1D unorm
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    image_store v[0:3], v4, s[16:23] dmask:0xf dim:SQ_RSRC_IMG_1D unorm
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.image.store.1d.v4f32.i32(<4 x float> %arg3, i32 15, i32 %arg4, <8 x i32> %arg, i32 0, i32 0)
  %data = call <4 x float> @llvm.amdgcn.image.load.1d.v4f32.i32(i32 15, i32 %arg4, <8 x i32> %arg1, i32 0, i32 0)
  call void @llvm.amdgcn.image.store.1d.v4f32.i32(<4 x float> %data, i32 15, i32 %arg4, <8 x i32> %arg2, i32 0, i32 0)
  ret void
}

define amdgpu_ps float @image_load_mmo(<8 x i32> inreg %rsrc, float addrspace(3)* %lds, <2 x i32> %c) #0 {
; VERDE-LABEL: image_load_mmo:
; VERDE:       ; %bb.0:
; VERDE-NEXT:    image_load v1, v[1:2], s[0:7] dmask:0x1 unorm
; VERDE-NEXT:    v_mov_b32_e32 v2, 0
; VERDE-NEXT:    s_mov_b32 m0, -1
; VERDE-NEXT:    ds_write_b32 v0, v2
; VERDE-NEXT:    v_add_i32_e32 v0, vcc, 16, v0
; VERDE-NEXT:    ds_write_b32 v0, v2
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    v_mov_b32_e32 v0, v1
; VERDE-NEXT:    s_waitcnt lgkmcnt(0)
; VERDE-NEXT:    ; return to shader part epilog
;
; FIJI-LABEL: image_load_mmo:
; FIJI:       ; %bb.0:
; FIJI-NEXT:    image_load v1, v[1:2], s[0:7] dmask:0x1 unorm
; FIJI-NEXT:    v_mov_b32_e32 v2, 0
; FIJI-NEXT:    s_mov_b32 m0, -1
; FIJI-NEXT:    ds_write2_b32 v0, v2, v2 offset1:4
; FIJI-NEXT:    s_waitcnt vmcnt(0)
; FIJI-NEXT:    v_mov_b32_e32 v0, v1
; FIJI-NEXT:    s_waitcnt lgkmcnt(0)
; FIJI-NEXT:    ; return to shader part epilog
;
; GFX6789-LABEL: image_load_mmo:
; GFX6789:       ; %bb.0:
; GFX6789-NEXT:    image_load v1, v[1:2], s[0:7] dmask:0x1 unorm
; GFX6789-NEXT:    v_mov_b32_e32 v2, 0
; GFX6789-NEXT:    ds_write2_b32 v0, v2, v2 offset1:4
; GFX6789-NEXT:    s_waitcnt vmcnt(0)
; GFX6789-NEXT:    v_mov_b32_e32 v0, v1
; GFX6789-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6789-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: image_load_mmo:
; NOPRT:       ; %bb.0:
; NOPRT-NEXT:    image_load v1, v[1:2], s[0:7] dmask:0x1 unorm
; NOPRT-NEXT:    v_mov_b32_e32 v2, 0
; NOPRT-NEXT:    ds_write2_b32 v0, v2, v2 offset1:4
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    v_mov_b32_e32 v0, v1
; NOPRT-NEXT:    s_waitcnt lgkmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: image_load_mmo:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    image_load v1, v[1:2], s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_2D unorm
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    ds_write2_b32 v0, v2, v2 offset1:4
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, v1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: image_load_mmo:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    image_load v1, v[1:2], s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_2D unorm
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    ds_store_2addr_b32 v0, v2, v2 offset1:4
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v0, v1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
  store float 0.000000e+00, float addrspace(3)* %lds
  %c0 = extractelement <2 x i32> %c, i32 0
  %c1 = extractelement <2 x i32> %c, i32 1
  %tex = call float @llvm.amdgcn.image.load.2d.f32.i32(i32 1, i32 %c0, i32 %c1, <8 x i32> %rsrc, i32 0, i32 0)
  %tmp2 = getelementptr float, float addrspace(3)* %lds, i32 4
  store float 0.000000e+00, float addrspace(3)* %tmp2
  ret float %tex
}

declare <4 x float> @llvm.amdgcn.image.load.1d.v4f32.i32(i32, i32, <8 x i32>, i32, i32) #1
declare {float,i32} @llvm.amdgcn.image.load.1d.f32i32.i32(i32, i32, <8 x i32>, i32, i32) #1
declare {<2 x float>,i32} @llvm.amdgcn.image.load.1d.v2f32i32.i32(i32, i32, <8 x i32>, i32, i32) #1
declare {<4 x float>,i32} @llvm.amdgcn.image.load.1d.v4f32i32.i32(i32, i32, <8 x i32>, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.load.2d.v4f32.i32(i32, i32, i32, <8 x i32>, i32, i32) #1
declare {<4 x float>,i32} @llvm.amdgcn.image.load.2d.v4f32i32.i32(i32, i32, i32, <8 x i32>, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.load.3d.v4f32.i32(i32, i32, i32, i32, <8 x i32>, i32, i32) #1
declare {<4 x float>,i32} @llvm.amdgcn.image.load.3d.v4f32i32.i32(i32, i32, i32, i32, <8 x i32>, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.load.cube.v4f32.i32(i32, i32, i32, i32, <8 x i32>, i32, i32) #1
declare {<4 x float>,i32} @llvm.amdgcn.image.load.cube.v4f32i32.i32(i32, i32, i32, i32, <8 x i32>, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.load.1darray.v4f32.i32(i32, i32, i32, <8 x i32>, i32, i32) #1
declare {<4 x float>,i32} @llvm.amdgcn.image.load.1darray.v4f32i32.i32(i32, i32, i32, <8 x i32>, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.load.2darray.v4f32.i32(i32, i32, i32, i32, <8 x i32>, i32, i32) #1
declare {<4 x float>,i32} @llvm.amdgcn.image.load.2darray.v4f32i32.i32(i32, i32, i32, i32, <8 x i32>, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.load.2dmsaa.v4f32.i32(i32, i32, i32, i32, <8 x i32>, i32, i32) #1
declare {<4 x float>,i32} @llvm.amdgcn.image.load.2dmsaa.v4f32i32.i32(i32, i32, i32, i32, <8 x i32>, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.load.2darraymsaa.v4f32.i32(i32, i32, i32, i32, i32, <8 x i32>, i32, i32) #1
declare {<4 x float>,i32} @llvm.amdgcn.image.load.2darraymsaa.v4f32i32.i32(i32, i32, i32, i32, i32, <8 x i32>, i32, i32) #1

declare <4 x float> @llvm.amdgcn.image.load.mip.1d.v4f32.i32(i32, i32, i32, <8 x i32>, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.load.mip.2d.v4f32.i32(i32, i32, i32, i32, <8 x i32>, i32, i32) #1
declare {<4 x float>,i32} @llvm.amdgcn.image.load.mip.1d.v4f32i32.i32(i32, i32, i32, <8 x i32>, i32, i32) #1
declare {<4 x float>,i32} @llvm.amdgcn.image.load.mip.2d.v4f32i32.i32(i32, i32, i32, i32, <8 x i32>, i32, i32) #1
declare {<2 x float>,i32} @llvm.amdgcn.image.load.mip.2d.v2f32i32.i32(i32, i32, i32, i32, <8 x i32>, i32, i32) #1
declare {float,i32} @llvm.amdgcn.image.load.mip.2d.f32i32.i32(i32, i32, i32, i32, <8 x i32>, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.load.mip.3d.v4f32.i32(i32, i32, i32, i32, i32, <8 x i32>, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.load.mip.cube.v4f32.i32(i32, i32, i32, i32, i32, <8 x i32>, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.load.mip.1darray.v4f32.i32(i32, i32, i32, i32, <8 x i32>, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.load.mip.2darray.v4f32.i32(i32, i32, i32, i32, i32, <8 x i32>, i32, i32) #1

declare void @llvm.amdgcn.image.store.1d.v4f32.i32(<4 x float>, i32, i32, <8 x i32>, i32, i32) #0
declare void @llvm.amdgcn.image.store.2d.v4f32.i32(<4 x float>, i32, i32, i32, <8 x i32>, i32, i32) #0
declare void @llvm.amdgcn.image.store.3d.v4f32.i32(<4 x float>, i32, i32, i32, i32, <8 x i32>, i32, i32) #0
declare void @llvm.amdgcn.image.store.cube.v4f32.i32(<4 x float>, i32, i32, i32, i32, <8 x i32>, i32, i32) #0
declare void @llvm.amdgcn.image.store.1darray.v4f32.i32(<4 x float>, i32, i32, i32, <8 x i32>, i32, i32) #0
declare void @llvm.amdgcn.image.store.2darray.v4f32.i32(<4 x float>, i32, i32, i32, i32, <8 x i32>, i32, i32) #0
declare void @llvm.amdgcn.image.store.2dmsaa.v4f32.i32(<4 x float>, i32, i32, i32, i32, <8 x i32>, i32, i32) #0
declare void @llvm.amdgcn.image.store.2darraymsaa.v4f32.i32(<4 x float>, i32, i32, i32, i32, i32, <8 x i32>, i32, i32) #0

declare void @llvm.amdgcn.image.store.mip.1d.v4f32.i32(<4 x float>, i32, i32, i32, <8 x i32>, i32, i32) #0
declare void @llvm.amdgcn.image.store.mip.2d.v4f32.i32(<4 x float>, i32, i32, i32, i32, <8 x i32>, i32, i32) #0
declare void @llvm.amdgcn.image.store.mip.3d.v4f32.i32(<4 x float>, i32, i32, i32, i32, i32, <8 x i32>, i32, i32) #0
declare void @llvm.amdgcn.image.store.mip.cube.v4f32.i32(<4 x float>, i32, i32, i32, i32, i32, <8 x i32>, i32, i32) #0
declare void @llvm.amdgcn.image.store.mip.1darray.v4f32.i32(<4 x float>, i32, i32, i32, i32, <8 x i32>, i32, i32) #0
declare void @llvm.amdgcn.image.store.mip.2darray.v4f32.i32(<4 x float>, i32, i32, i32, i32, i32, <8 x i32>, i32, i32) #0

declare <4 x float> @llvm.amdgcn.image.getresinfo.1d.v4f32.i32(i32, i32, <8 x i32>, i32, i32) #2
declare <3 x float> @llvm.amdgcn.image.getresinfo.1d.v3f32.i32(i32 immarg, i32, <8 x i32>, i32 immarg, i32 immarg) #1
declare <2 x float> @llvm.amdgcn.image.getresinfo.1d.v2f32.i32(i32 immarg, i32, <8 x i32>, i32 immarg, i32 immarg) #1
declare float @llvm.amdgcn.image.getresinfo.1d.f32.i32(i32 immarg, i32, <8 x i32>, i32 immarg, i32 immarg) #1
declare <4 x float> @llvm.amdgcn.image.getresinfo.2d.v4f32.i32(i32, i32, <8 x i32>, i32, i32) #2
declare <4 x float> @llvm.amdgcn.image.getresinfo.3d.v4f32.i32(i32, i32, <8 x i32>, i32, i32) #2
declare <4 x float> @llvm.amdgcn.image.getresinfo.cube.v4f32.i32(i32, i32, <8 x i32>, i32, i32) #2
declare <4 x float> @llvm.amdgcn.image.getresinfo.1darray.v4f32.i32(i32, i32, <8 x i32>, i32, i32) #2
declare <4 x float> @llvm.amdgcn.image.getresinfo.2darray.v4f32.i32(i32, i32, <8 x i32>, i32, i32) #2
declare <4 x float> @llvm.amdgcn.image.getresinfo.2dmsaa.v4f32.i32(i32, i32, <8 x i32>, i32, i32) #2
declare <4 x float> @llvm.amdgcn.image.getresinfo.2darraymsaa.v4f32.i32(i32, i32, <8 x i32>, i32, i32) #2

declare float @llvm.amdgcn.image.load.1d.f32.i32(i32, i32, <8 x i32>, i32, i32) #1
declare float @llvm.amdgcn.image.load.2d.f32.i32(i32, i32, i32, <8 x i32>, i32, i32) #1
declare <2 x float> @llvm.amdgcn.image.load.1d.v2f32.i32(i32, i32, <8 x i32>, i32, i32) #1
declare void @llvm.amdgcn.image.store.1d.f32.i32(float, i32, i32, <8 x i32>, i32, i32) #0
declare void @llvm.amdgcn.image.store.1d.v2f32.i32(<2 x float>, i32, i32, <8 x i32>, i32, i32) #0

attributes #0 = { nounwind }
attributes #1 = { nounwind readonly }
attributes #2 = { nounwind readnone }
