; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel=0 -march=amdgcn -mcpu=gfx940 < %s | FileCheck %s -check-prefixes=GFX940-SDAG
; RUN: llc -global-isel=1 -march=amdgcn -mcpu=gfx940 < %s | FileCheck %s -check-prefixes=GFX940-GISEL
; RUN: llc -global-isel=0 -march=amdgcn -mcpu=gfx1100 < %s | FileCheck %s -check-prefixes=GFX11-SDAG
; RUN: llc -global-isel=1 -march=amdgcn -mcpu=gfx1100 < %s | FileCheck %s -check-prefixes=GFX11-GISEL

; Test flat scratch SVS addressing mode with various combinations of alignment
; of soffset, voffset and inst_offset.

declare i32 @llvm.amdgcn.workitem.id.x()

define amdgpu_kernel void @soff1_voff1(i32 %soff) {
; GFX940-SDAG-LABEL: soff1_voff1:
; GFX940-SDAG:       ; %bb.0: ; %bb
; GFX940-SDAG-NEXT:    s_load_dword s0, s[0:1], 0x24
; GFX940-SDAG-NEXT:    v_mov_b32_e32 v1, 1
; GFX940-SDAG-NEXT:    v_mov_b32_e32 v2, 2
; GFX940-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-SDAG-NEXT:    s_add_i32 s0, s0, 4
; GFX940-SDAG-NEXT:    scratch_store_byte v0, v1, s0 offset:1 sc0 sc1
; GFX940-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX940-SDAG-NEXT:    scratch_store_byte v0, v2, s0 offset:2 sc0 sc1
; GFX940-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX940-SDAG-NEXT:    v_mov_b32_e32 v1, 4
; GFX940-SDAG-NEXT:    scratch_store_byte v0, v1, s0 offset:4 sc0 sc1
; GFX940-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX940-SDAG-NEXT:    s_endpgm
;
; GFX940-GISEL-LABEL: soff1_voff1:
; GFX940-GISEL:       ; %bb.0: ; %bb
; GFX940-GISEL-NEXT:    s_load_dword s0, s[0:1], 0x24
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v1, 4
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v2, 1
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v3, 2
; GFX940-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-GISEL-NEXT:    v_add_u32_e32 v1, s0, v1
; GFX940-GISEL-NEXT:    v_add_u32_e32 v0, v1, v0
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v1, 4
; GFX940-GISEL-NEXT:    scratch_store_byte v0, v2, off offset:1 sc0 sc1
; GFX940-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX940-GISEL-NEXT:    scratch_store_byte v0, v3, off offset:2 sc0 sc1
; GFX940-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX940-GISEL-NEXT:    scratch_store_byte v0, v1, off offset:4 sc0 sc1
; GFX940-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX940-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: soff1_voff1:
; GFX11-SDAG:       ; %bb.0: ; %bb
; GFX11-SDAG-NEXT:    s_load_b32 s0, s[0:1], 0x24
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, 1
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v2, 2
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v3, 4
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add3_u32 v0, 4, s0, v0
; GFX11-SDAG-NEXT:    scratch_store_b8 v0, v1, off offset:1 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    scratch_store_b8 v0, v2, off offset:2 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    scratch_store_b8 v0, v3, off offset:4 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: soff1_voff1:
; GFX11-GISEL:       ; %bb.0: ; %bb
; GFX11-GISEL-NEXT:    s_load_b32 s0, s[0:1], 0x24
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v2, 1
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v3, 4
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_add_nc_u32_e64 v1, s0, 4
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, v1, v0
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v1, 2
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v2, off offset:1 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v1, off offset:2 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v3, off offset:4 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
bb:
  %soff1 = mul i32 %soff, 1
  %a = alloca i8, i32 64, align 4, addrspace(5)
  %as = getelementptr i8, i8 addrspace(5)* %a, i32 %soff1
  %voff = call i32 @llvm.amdgcn.workitem.id.x()
  %voff1 = mul i32 %voff, 1
  %asv = getelementptr i8, i8 addrspace(5)* %as, i32 %voff1
  %p1 = getelementptr i8, i8 addrspace(5)* %asv, i32 1
  store volatile i8 1, i8 addrspace(5)* %p1
  %p2 = getelementptr i8, i8 addrspace(5)* %asv, i32 2
  store volatile i8 2, i8 addrspace(5)* %p2
  %p4 = getelementptr i8, i8 addrspace(5)* %asv, i32 4
  store volatile i8 4, i8 addrspace(5)* %p4
  ret void
}

define amdgpu_kernel void @soff1_voff2(i32 %soff) {
; GFX940-SDAG-LABEL: soff1_voff2:
; GFX940-SDAG:       ; %bb.0: ; %bb
; GFX940-SDAG-NEXT:    s_load_dword s0, s[0:1], 0x24
; GFX940-SDAG-NEXT:    v_mov_b32_e32 v1, 1
; GFX940-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX940-SDAG-NEXT:    v_mov_b32_e32 v2, 2
; GFX940-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-SDAG-NEXT:    s_add_i32 s0, s0, 4
; GFX940-SDAG-NEXT:    scratch_store_byte v0, v1, s0 offset:1 sc0 sc1
; GFX940-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX940-SDAG-NEXT:    scratch_store_byte v0, v2, s0 offset:2 sc0 sc1
; GFX940-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX940-SDAG-NEXT:    v_mov_b32_e32 v1, 4
; GFX940-SDAG-NEXT:    scratch_store_byte v0, v1, s0 offset:4 sc0 sc1
; GFX940-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX940-SDAG-NEXT:    s_endpgm
;
; GFX940-GISEL-LABEL: soff1_voff2:
; GFX940-GISEL:       ; %bb.0: ; %bb
; GFX940-GISEL-NEXT:    s_load_dword s0, s[0:1], 0x24
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v1, 4
; GFX940-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v2, 1
; GFX940-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-GISEL-NEXT:    v_add_u32_e32 v1, s0, v1
; GFX940-GISEL-NEXT:    v_add_u32_e32 v0, v1, v0
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v1, 2
; GFX940-GISEL-NEXT:    scratch_store_byte v0, v2, off offset:1 sc0 sc1
; GFX940-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX940-GISEL-NEXT:    scratch_store_byte v0, v1, off offset:2 sc0 sc1
; GFX940-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v1, 4
; GFX940-GISEL-NEXT:    scratch_store_byte v0, v1, off offset:4 sc0 sc1
; GFX940-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX940-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: soff1_voff2:
; GFX11-SDAG:       ; %bb.0: ; %bb
; GFX11-SDAG-NEXT:    s_load_b32 s0, s[0:1], 0x24
; GFX11-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, 1
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v2, 2
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v3, 4
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add3_u32 v0, 4, s0, v0
; GFX11-SDAG-NEXT:    scratch_store_b8 v0, v1, off offset:1 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    scratch_store_b8 v0, v2, off offset:2 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    scratch_store_b8 v0, v3, off offset:4 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: soff1_voff2:
; GFX11-GISEL:       ; %bb.0: ; %bb
; GFX11-GISEL-NEXT:    s_load_b32 s0, s[0:1], 0x24
; GFX11-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v2, 1
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v3, 4
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_add_nc_u32_e64 v1, s0, 4
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, v1, v0
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v1, 2
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v2, off offset:1 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v1, off offset:2 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v3, off offset:4 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
bb:
  %soff1 = mul i32 %soff, 1
  %a = alloca i8, i32 64, align 4, addrspace(5)
  %as = getelementptr i8, i8 addrspace(5)* %a, i32 %soff1
  %voff = call i32 @llvm.amdgcn.workitem.id.x()
  %voff2 = mul i32 %voff, 2
  %asv = getelementptr i8, i8 addrspace(5)* %as, i32 %voff2
  %p1 = getelementptr i8, i8 addrspace(5)* %asv, i32 1
  store volatile i8 1, i8 addrspace(5)* %p1
  %p2 = getelementptr i8, i8 addrspace(5)* %asv, i32 2
  store volatile i8 2, i8 addrspace(5)* %p2
  %p4 = getelementptr i8, i8 addrspace(5)* %asv, i32 4
  store volatile i8 4, i8 addrspace(5)* %p4
  ret void
}

define amdgpu_kernel void @soff1_voff4(i32 %soff) {
; GFX940-SDAG-LABEL: soff1_voff4:
; GFX940-SDAG:       ; %bb.0: ; %bb
; GFX940-SDAG-NEXT:    s_load_dword s0, s[0:1], 0x24
; GFX940-SDAG-NEXT:    v_mov_b32_e32 v1, 1
; GFX940-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX940-SDAG-NEXT:    v_mov_b32_e32 v2, 2
; GFX940-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-SDAG-NEXT:    s_add_i32 s0, s0, 4
; GFX940-SDAG-NEXT:    scratch_store_byte v0, v1, s0 offset:1 sc0 sc1
; GFX940-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX940-SDAG-NEXT:    scratch_store_byte v0, v2, s0 offset:2 sc0 sc1
; GFX940-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX940-SDAG-NEXT:    v_mov_b32_e32 v1, 4
; GFX940-SDAG-NEXT:    scratch_store_byte v0, v1, s0 offset:4 sc0 sc1
; GFX940-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX940-SDAG-NEXT:    s_endpgm
;
; GFX940-GISEL-LABEL: soff1_voff4:
; GFX940-GISEL:       ; %bb.0: ; %bb
; GFX940-GISEL-NEXT:    s_load_dword s0, s[0:1], 0x24
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v1, 4
; GFX940-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v2, 1
; GFX940-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-GISEL-NEXT:    v_add_u32_e32 v1, s0, v1
; GFX940-GISEL-NEXT:    v_add_u32_e32 v0, v1, v0
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v1, 2
; GFX940-GISEL-NEXT:    scratch_store_byte v0, v2, off offset:1 sc0 sc1
; GFX940-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX940-GISEL-NEXT:    scratch_store_byte v0, v1, off offset:2 sc0 sc1
; GFX940-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v1, 4
; GFX940-GISEL-NEXT:    scratch_store_byte v0, v1, off offset:4 sc0 sc1
; GFX940-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX940-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: soff1_voff4:
; GFX11-SDAG:       ; %bb.0: ; %bb
; GFX11-SDAG-NEXT:    s_load_b32 s0, s[0:1], 0x24
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, 1
; GFX11-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v2, 2
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v3, 4
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_add_i32 s0, s0, 4
; GFX11-SDAG-NEXT:    scratch_store_b8 v0, v1, s0 offset:1 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    scratch_store_b8 v0, v2, s0 offset:2 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    scratch_store_b8 v0, v3, s0 offset:4 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: soff1_voff4:
; GFX11-GISEL:       ; %bb.0: ; %bb
; GFX11-GISEL-NEXT:    s_load_b32 s0, s[0:1], 0x24
; GFX11-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v2, 1
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v3, 4
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_add_nc_u32_e64 v1, s0, 4
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, v1, v0
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v1, 2
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v2, off offset:1 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v1, off offset:2 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v3, off offset:4 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
bb:
  %soff1 = mul i32 %soff, 1
  %a = alloca i8, i32 64, align 4, addrspace(5)
  %as = getelementptr i8, i8 addrspace(5)* %a, i32 %soff1
  %voff = call i32 @llvm.amdgcn.workitem.id.x()
  %voff4 = mul i32 %voff, 4
  %asv = getelementptr i8, i8 addrspace(5)* %as, i32 %voff4
  %p1 = getelementptr i8, i8 addrspace(5)* %asv, i32 1
  store volatile i8 1, i8 addrspace(5)* %p1
  %p2 = getelementptr i8, i8 addrspace(5)* %asv, i32 2
  store volatile i8 2, i8 addrspace(5)* %p2
  %p4 = getelementptr i8, i8 addrspace(5)* %asv, i32 4
  store volatile i8 4, i8 addrspace(5)* %p4
  ret void
}

define amdgpu_kernel void @soff2_voff1(i32 %soff) {
; GFX940-SDAG-LABEL: soff2_voff1:
; GFX940-SDAG:       ; %bb.0: ; %bb
; GFX940-SDAG-NEXT:    s_load_dword s0, s[0:1], 0x24
; GFX940-SDAG-NEXT:    v_mov_b32_e32 v1, 1
; GFX940-SDAG-NEXT:    v_mov_b32_e32 v2, 2
; GFX940-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-SDAG-NEXT:    s_lshl_b32 s0, s0, 1
; GFX940-SDAG-NEXT:    s_add_i32 s0, s0, 4
; GFX940-SDAG-NEXT:    scratch_store_byte v0, v1, s0 offset:1 sc0 sc1
; GFX940-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX940-SDAG-NEXT:    scratch_store_byte v0, v2, s0 offset:2 sc0 sc1
; GFX940-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX940-SDAG-NEXT:    v_mov_b32_e32 v1, 4
; GFX940-SDAG-NEXT:    scratch_store_byte v0, v1, s0 offset:4 sc0 sc1
; GFX940-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX940-SDAG-NEXT:    s_endpgm
;
; GFX940-GISEL-LABEL: soff2_voff1:
; GFX940-GISEL:       ; %bb.0: ; %bb
; GFX940-GISEL-NEXT:    s_load_dword s0, s[0:1], 0x24
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v1, 4
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v2, 1
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v3, 2
; GFX940-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-GISEL-NEXT:    s_lshl_b32 s0, s0, 1
; GFX940-GISEL-NEXT:    v_add_u32_e32 v1, s0, v1
; GFX940-GISEL-NEXT:    v_add_u32_e32 v0, v1, v0
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v1, 4
; GFX940-GISEL-NEXT:    scratch_store_byte v0, v2, off offset:1 sc0 sc1
; GFX940-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX940-GISEL-NEXT:    scratch_store_byte v0, v3, off offset:2 sc0 sc1
; GFX940-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX940-GISEL-NEXT:    scratch_store_byte v0, v1, off offset:4 sc0 sc1
; GFX940-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX940-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: soff2_voff1:
; GFX11-SDAG:       ; %bb.0: ; %bb
; GFX11-SDAG-NEXT:    s_load_b32 s0, s[0:1], 0x24
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, 1
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v2, 2
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v3, 4
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_lshl_b32 s0, s0, 1
; GFX11-SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-SDAG-NEXT:    v_add3_u32 v0, 4, s0, v0
; GFX11-SDAG-NEXT:    scratch_store_b8 v0, v1, off offset:1 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    scratch_store_b8 v0, v2, off offset:2 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    scratch_store_b8 v0, v3, off offset:4 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: soff2_voff1:
; GFX11-GISEL:       ; %bb.0: ; %bb
; GFX11-GISEL-NEXT:    s_load_b32 s0, s[0:1], 0x24
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v2, 1
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v3, 4
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_lshl_b32 s0, s0, 1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_add_nc_u32_e64 v1, s0, 4
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, v1, v0
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v1, 2
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v2, off offset:1 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v1, off offset:2 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v3, off offset:4 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
bb:
  %soff2 = mul i32 %soff, 2
  %a = alloca i8, i32 64, align 4, addrspace(5)
  %as = getelementptr i8, i8 addrspace(5)* %a, i32 %soff2
  %voff = call i32 @llvm.amdgcn.workitem.id.x()
  %voff1 = mul i32 %voff, 1
  %asv = getelementptr i8, i8 addrspace(5)* %as, i32 %voff1
  %p1 = getelementptr i8, i8 addrspace(5)* %asv, i32 1
  store volatile i8 1, i8 addrspace(5)* %p1
  %p2 = getelementptr i8, i8 addrspace(5)* %asv, i32 2
  store volatile i8 2, i8 addrspace(5)* %p2
  %p4 = getelementptr i8, i8 addrspace(5)* %asv, i32 4
  store volatile i8 4, i8 addrspace(5)* %p4
  ret void
}

define amdgpu_kernel void @soff2_voff2(i32 %soff) {
; GFX940-SDAG-LABEL: soff2_voff2:
; GFX940-SDAG:       ; %bb.0: ; %bb
; GFX940-SDAG-NEXT:    s_load_dword s0, s[0:1], 0x24
; GFX940-SDAG-NEXT:    v_mov_b32_e32 v1, 1
; GFX940-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX940-SDAG-NEXT:    v_mov_b32_e32 v2, 2
; GFX940-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-SDAG-NEXT:    s_lshl_b32 s0, s0, 1
; GFX940-SDAG-NEXT:    s_add_i32 s0, s0, 4
; GFX940-SDAG-NEXT:    scratch_store_byte v0, v1, s0 offset:1 sc0 sc1
; GFX940-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX940-SDAG-NEXT:    scratch_store_byte v0, v2, s0 offset:2 sc0 sc1
; GFX940-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX940-SDAG-NEXT:    v_mov_b32_e32 v1, 4
; GFX940-SDAG-NEXT:    scratch_store_byte v0, v1, s0 offset:4 sc0 sc1
; GFX940-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX940-SDAG-NEXT:    s_endpgm
;
; GFX940-GISEL-LABEL: soff2_voff2:
; GFX940-GISEL:       ; %bb.0: ; %bb
; GFX940-GISEL-NEXT:    s_load_dword s0, s[0:1], 0x24
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v1, 4
; GFX940-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v2, 1
; GFX940-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-GISEL-NEXT:    s_lshl_b32 s0, s0, 1
; GFX940-GISEL-NEXT:    v_add_u32_e32 v1, s0, v1
; GFX940-GISEL-NEXT:    v_add_u32_e32 v0, v1, v0
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v1, 2
; GFX940-GISEL-NEXT:    scratch_store_byte v0, v2, off offset:1 sc0 sc1
; GFX940-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX940-GISEL-NEXT:    scratch_store_byte v0, v1, off offset:2 sc0 sc1
; GFX940-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v1, 4
; GFX940-GISEL-NEXT:    scratch_store_byte v0, v1, off offset:4 sc0 sc1
; GFX940-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX940-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: soff2_voff2:
; GFX11-SDAG:       ; %bb.0: ; %bb
; GFX11-SDAG-NEXT:    s_load_b32 s0, s[0:1], 0x24
; GFX11-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, 1
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v2, 2
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v3, 4
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_lshl_b32 s0, s0, 1
; GFX11-SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-SDAG-NEXT:    v_add3_u32 v0, 4, s0, v0
; GFX11-SDAG-NEXT:    scratch_store_b8 v0, v1, off offset:1 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    scratch_store_b8 v0, v2, off offset:2 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    scratch_store_b8 v0, v3, off offset:4 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: soff2_voff2:
; GFX11-GISEL:       ; %bb.0: ; %bb
; GFX11-GISEL-NEXT:    s_load_b32 s0, s[0:1], 0x24
; GFX11-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v2, 1
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v3, 4
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_lshl_b32 s0, s0, 1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_add_nc_u32_e64 v1, s0, 4
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, v1, v0
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v1, 2
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v2, off offset:1 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v1, off offset:2 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v3, off offset:4 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
bb:
  %soff2 = mul i32 %soff, 2
  %a = alloca i8, i32 64, align 4, addrspace(5)
  %as = getelementptr i8, i8 addrspace(5)* %a, i32 %soff2
  %voff = call i32 @llvm.amdgcn.workitem.id.x()
  %voff2 = mul i32 %voff, 2
  %asv = getelementptr i8, i8 addrspace(5)* %as, i32 %voff2
  %p1 = getelementptr i8, i8 addrspace(5)* %asv, i32 1
  store volatile i8 1, i8 addrspace(5)* %p1
  %p2 = getelementptr i8, i8 addrspace(5)* %asv, i32 2
  store volatile i8 2, i8 addrspace(5)* %p2
  %p4 = getelementptr i8, i8 addrspace(5)* %asv, i32 4
  store volatile i8 4, i8 addrspace(5)* %p4
  ret void
}

define amdgpu_kernel void @soff2_voff4(i32 %soff) {
; GFX940-SDAG-LABEL: soff2_voff4:
; GFX940-SDAG:       ; %bb.0: ; %bb
; GFX940-SDAG-NEXT:    s_load_dword s0, s[0:1], 0x24
; GFX940-SDAG-NEXT:    v_mov_b32_e32 v1, 1
; GFX940-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX940-SDAG-NEXT:    v_mov_b32_e32 v2, 2
; GFX940-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-SDAG-NEXT:    s_lshl_b32 s0, s0, 1
; GFX940-SDAG-NEXT:    s_add_i32 s0, s0, 4
; GFX940-SDAG-NEXT:    scratch_store_byte v0, v1, s0 offset:1 sc0 sc1
; GFX940-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX940-SDAG-NEXT:    scratch_store_byte v0, v2, s0 offset:2 sc0 sc1
; GFX940-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX940-SDAG-NEXT:    v_mov_b32_e32 v1, 4
; GFX940-SDAG-NEXT:    scratch_store_byte v0, v1, s0 offset:4 sc0 sc1
; GFX940-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX940-SDAG-NEXT:    s_endpgm
;
; GFX940-GISEL-LABEL: soff2_voff4:
; GFX940-GISEL:       ; %bb.0: ; %bb
; GFX940-GISEL-NEXT:    s_load_dword s0, s[0:1], 0x24
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v1, 4
; GFX940-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v2, 1
; GFX940-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-GISEL-NEXT:    s_lshl_b32 s0, s0, 1
; GFX940-GISEL-NEXT:    v_add_u32_e32 v1, s0, v1
; GFX940-GISEL-NEXT:    v_add_u32_e32 v0, v1, v0
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v1, 2
; GFX940-GISEL-NEXT:    scratch_store_byte v0, v2, off offset:1 sc0 sc1
; GFX940-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX940-GISEL-NEXT:    scratch_store_byte v0, v1, off offset:2 sc0 sc1
; GFX940-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v1, 4
; GFX940-GISEL-NEXT:    scratch_store_byte v0, v1, off offset:4 sc0 sc1
; GFX940-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX940-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: soff2_voff4:
; GFX11-SDAG:       ; %bb.0: ; %bb
; GFX11-SDAG-NEXT:    s_load_b32 s0, s[0:1], 0x24
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, 1
; GFX11-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v2, 2
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v3, 4
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_lshl_b32 s0, s0, 1
; GFX11-SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-SDAG-NEXT:    s_add_i32 s0, s0, 4
; GFX11-SDAG-NEXT:    scratch_store_b8 v0, v1, s0 offset:1 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    scratch_store_b8 v0, v2, s0 offset:2 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    scratch_store_b8 v0, v3, s0 offset:4 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: soff2_voff4:
; GFX11-GISEL:       ; %bb.0: ; %bb
; GFX11-GISEL-NEXT:    s_load_b32 s0, s[0:1], 0x24
; GFX11-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v2, 1
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v3, 4
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_lshl_b32 s0, s0, 1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_add_nc_u32_e64 v1, s0, 4
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, v1, v0
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v1, 2
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v2, off offset:1 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v1, off offset:2 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v3, off offset:4 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
bb:
  %soff2 = mul i32 %soff, 2
  %a = alloca i8, i32 64, align 4, addrspace(5)
  %as = getelementptr i8, i8 addrspace(5)* %a, i32 %soff2
  %voff = call i32 @llvm.amdgcn.workitem.id.x()
  %voff4 = mul i32 %voff, 4
  %asv = getelementptr i8, i8 addrspace(5)* %as, i32 %voff4
  %p1 = getelementptr i8, i8 addrspace(5)* %asv, i32 1
  store volatile i8 1, i8 addrspace(5)* %p1
  %p2 = getelementptr i8, i8 addrspace(5)* %asv, i32 2
  store volatile i8 2, i8 addrspace(5)* %p2
  %p4 = getelementptr i8, i8 addrspace(5)* %asv, i32 4
  store volatile i8 4, i8 addrspace(5)* %p4
  ret void
}

define amdgpu_kernel void @soff4_voff1(i32 %soff) {
; GFX940-SDAG-LABEL: soff4_voff1:
; GFX940-SDAG:       ; %bb.0: ; %bb
; GFX940-SDAG-NEXT:    s_load_dword s0, s[0:1], 0x24
; GFX940-SDAG-NEXT:    v_mov_b32_e32 v1, 1
; GFX940-SDAG-NEXT:    v_mov_b32_e32 v2, 2
; GFX940-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-SDAG-NEXT:    s_lshl_b32 s0, s0, 2
; GFX940-SDAG-NEXT:    s_add_i32 s0, s0, 4
; GFX940-SDAG-NEXT:    scratch_store_byte v0, v1, s0 offset:1 sc0 sc1
; GFX940-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX940-SDAG-NEXT:    scratch_store_byte v0, v2, s0 offset:2 sc0 sc1
; GFX940-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX940-SDAG-NEXT:    v_mov_b32_e32 v1, 4
; GFX940-SDAG-NEXT:    scratch_store_byte v0, v1, s0 offset:4 sc0 sc1
; GFX940-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX940-SDAG-NEXT:    s_endpgm
;
; GFX940-GISEL-LABEL: soff4_voff1:
; GFX940-GISEL:       ; %bb.0: ; %bb
; GFX940-GISEL-NEXT:    s_load_dword s0, s[0:1], 0x24
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v1, 4
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v2, 1
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v3, 2
; GFX940-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-GISEL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX940-GISEL-NEXT:    v_add_u32_e32 v1, s0, v1
; GFX940-GISEL-NEXT:    v_add_u32_e32 v0, v1, v0
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v1, 4
; GFX940-GISEL-NEXT:    scratch_store_byte v0, v2, off offset:1 sc0 sc1
; GFX940-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX940-GISEL-NEXT:    scratch_store_byte v0, v3, off offset:2 sc0 sc1
; GFX940-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX940-GISEL-NEXT:    scratch_store_byte v0, v1, off offset:4 sc0 sc1
; GFX940-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX940-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: soff4_voff1:
; GFX11-SDAG:       ; %bb.0: ; %bb
; GFX11-SDAG-NEXT:    s_load_b32 s0, s[0:1], 0x24
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, 1
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v3, 2
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v4, 4
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-SDAG-NEXT:    v_add3_u32 v2, 4, s0, v0
; GFX11-SDAG-NEXT:    s_add_i32 s0, s0, 4
; GFX11-SDAG-NEXT:    scratch_store_b8 v2, v1, off offset:1 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    scratch_store_b8 v2, v3, off offset:2 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    scratch_store_b8 v0, v4, s0 offset:4 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: soff4_voff1:
; GFX11-GISEL:       ; %bb.0: ; %bb
; GFX11-GISEL-NEXT:    s_load_b32 s0, s[0:1], 0x24
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v2, 1
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v3, 4
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_add_nc_u32_e64 v1, s0, 4
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, v1, v0
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v1, 2
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v2, off offset:1 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v1, off offset:2 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v3, off offset:4 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
bb:
  %soff4 = mul i32 %soff, 4
  %a = alloca i8, i32 64, align 4, addrspace(5)
  %as = getelementptr i8, i8 addrspace(5)* %a, i32 %soff4
  %voff = call i32 @llvm.amdgcn.workitem.id.x()
  %voff1 = mul i32 %voff, 1
  %asv = getelementptr i8, i8 addrspace(5)* %as, i32 %voff1
  %p1 = getelementptr i8, i8 addrspace(5)* %asv, i32 1
  store volatile i8 1, i8 addrspace(5)* %p1
  %p2 = getelementptr i8, i8 addrspace(5)* %asv, i32 2
  store volatile i8 2, i8 addrspace(5)* %p2
  %p4 = getelementptr i8, i8 addrspace(5)* %asv, i32 4
  store volatile i8 4, i8 addrspace(5)* %p4
  ret void
}

define amdgpu_kernel void @soff4_voff2(i32 %soff) {
; GFX940-SDAG-LABEL: soff4_voff2:
; GFX940-SDAG:       ; %bb.0: ; %bb
; GFX940-SDAG-NEXT:    s_load_dword s0, s[0:1], 0x24
; GFX940-SDAG-NEXT:    v_mov_b32_e32 v1, 1
; GFX940-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX940-SDAG-NEXT:    v_mov_b32_e32 v2, 2
; GFX940-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-SDAG-NEXT:    s_lshl_b32 s0, s0, 2
; GFX940-SDAG-NEXT:    s_add_i32 s0, s0, 4
; GFX940-SDAG-NEXT:    scratch_store_byte v0, v1, s0 offset:1 sc0 sc1
; GFX940-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX940-SDAG-NEXT:    scratch_store_byte v0, v2, s0 offset:2 sc0 sc1
; GFX940-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX940-SDAG-NEXT:    v_mov_b32_e32 v1, 4
; GFX940-SDAG-NEXT:    scratch_store_byte v0, v1, s0 offset:4 sc0 sc1
; GFX940-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX940-SDAG-NEXT:    s_endpgm
;
; GFX940-GISEL-LABEL: soff4_voff2:
; GFX940-GISEL:       ; %bb.0: ; %bb
; GFX940-GISEL-NEXT:    s_load_dword s0, s[0:1], 0x24
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v1, 4
; GFX940-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v2, 1
; GFX940-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-GISEL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX940-GISEL-NEXT:    v_add_u32_e32 v1, s0, v1
; GFX940-GISEL-NEXT:    v_add_u32_e32 v0, v1, v0
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v1, 2
; GFX940-GISEL-NEXT:    scratch_store_byte v0, v2, off offset:1 sc0 sc1
; GFX940-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX940-GISEL-NEXT:    scratch_store_byte v0, v1, off offset:2 sc0 sc1
; GFX940-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v1, 4
; GFX940-GISEL-NEXT:    scratch_store_byte v0, v1, off offset:4 sc0 sc1
; GFX940-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX940-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: soff4_voff2:
; GFX11-SDAG:       ; %bb.0: ; %bb
; GFX11-SDAG-NEXT:    s_load_b32 s0, s[0:1], 0x24
; GFX11-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, 1
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v2, 2
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v4, 4
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-SDAG-NEXT:    v_add3_u32 v3, 4, s0, v0
; GFX11-SDAG-NEXT:    s_add_i32 s0, s0, 4
; GFX11-SDAG-NEXT:    scratch_store_b8 v0, v1, s0 offset:1 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    scratch_store_b8 v3, v2, off offset:2 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    scratch_store_b8 v0, v4, s0 offset:4 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: soff4_voff2:
; GFX11-GISEL:       ; %bb.0: ; %bb
; GFX11-GISEL-NEXT:    s_load_b32 s0, s[0:1], 0x24
; GFX11-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v2, 1
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v3, 4
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_add_nc_u32_e64 v1, s0, 4
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, v1, v0
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v1, 2
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v2, off offset:1 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v1, off offset:2 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v3, off offset:4 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
bb:
  %soff4 = mul i32 %soff, 4
  %a = alloca i8, i32 64, align 4, addrspace(5)
  %as = getelementptr i8, i8 addrspace(5)* %a, i32 %soff4
  %voff = call i32 @llvm.amdgcn.workitem.id.x()
  %voff2 = mul i32 %voff, 2
  %asv = getelementptr i8, i8 addrspace(5)* %as, i32 %voff2
  %p1 = getelementptr i8, i8 addrspace(5)* %asv, i32 1
  store volatile i8 1, i8 addrspace(5)* %p1
  %p2 = getelementptr i8, i8 addrspace(5)* %asv, i32 2
  store volatile i8 2, i8 addrspace(5)* %p2
  %p4 = getelementptr i8, i8 addrspace(5)* %asv, i32 4
  store volatile i8 4, i8 addrspace(5)* %p4
  ret void
}

define amdgpu_kernel void @soff4_voff4(i32 %soff) {
; GFX940-SDAG-LABEL: soff4_voff4:
; GFX940-SDAG:       ; %bb.0: ; %bb
; GFX940-SDAG-NEXT:    s_load_dword s0, s[0:1], 0x24
; GFX940-SDAG-NEXT:    v_mov_b32_e32 v1, 1
; GFX940-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX940-SDAG-NEXT:    v_mov_b32_e32 v2, 2
; GFX940-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-SDAG-NEXT:    s_lshl_b32 s0, s0, 2
; GFX940-SDAG-NEXT:    s_add_i32 s0, s0, 4
; GFX940-SDAG-NEXT:    scratch_store_byte v0, v1, s0 offset:1 sc0 sc1
; GFX940-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX940-SDAG-NEXT:    scratch_store_byte v0, v2, s0 offset:2 sc0 sc1
; GFX940-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX940-SDAG-NEXT:    v_mov_b32_e32 v1, 4
; GFX940-SDAG-NEXT:    scratch_store_byte v0, v1, s0 offset:4 sc0 sc1
; GFX940-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX940-SDAG-NEXT:    s_endpgm
;
; GFX940-GISEL-LABEL: soff4_voff4:
; GFX940-GISEL:       ; %bb.0: ; %bb
; GFX940-GISEL-NEXT:    s_load_dword s0, s[0:1], 0x24
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v1, 4
; GFX940-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v2, 1
; GFX940-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-GISEL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX940-GISEL-NEXT:    v_add_u32_e32 v1, s0, v1
; GFX940-GISEL-NEXT:    v_add_u32_e32 v0, v1, v0
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v1, 2
; GFX940-GISEL-NEXT:    scratch_store_byte v0, v2, off offset:1 sc0 sc1
; GFX940-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX940-GISEL-NEXT:    scratch_store_byte v0, v1, off offset:2 sc0 sc1
; GFX940-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX940-GISEL-NEXT:    v_mov_b32_e32 v1, 4
; GFX940-GISEL-NEXT:    scratch_store_byte v0, v1, off offset:4 sc0 sc1
; GFX940-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX940-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: soff4_voff4:
; GFX11-SDAG:       ; %bb.0: ; %bb
; GFX11-SDAG-NEXT:    s_load_b32 s0, s[0:1], 0x24
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, 1
; GFX11-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v2, 2
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v3, 4
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-SDAG-NEXT:    s_add_i32 s0, s0, 4
; GFX11-SDAG-NEXT:    scratch_store_b8 v0, v1, s0 offset:1 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    scratch_store_b8 v0, v2, s0 offset:2 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    scratch_store_b8 v0, v3, s0 offset:4 dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: soff4_voff4:
; GFX11-GISEL:       ; %bb.0: ; %bb
; GFX11-GISEL-NEXT:    s_load_b32 s0, s[0:1], 0x24
; GFX11-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v2, 1
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v3, 4
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_add_nc_u32_e64 v1, s0, 4
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, v1, v0
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v1, 2
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v2, off offset:1 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v1, off offset:2 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    scratch_store_b8 v0, v3, off offset:4 dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
bb:
  %soff4 = mul i32 %soff, 4
  %a = alloca i8, i32 64, align 4, addrspace(5)
  %as = getelementptr i8, i8 addrspace(5)* %a, i32 %soff4
  %voff = call i32 @llvm.amdgcn.workitem.id.x()
  %voff4 = mul i32 %voff, 4
  %asv = getelementptr i8, i8 addrspace(5)* %as, i32 %voff4
  %p1 = getelementptr i8, i8 addrspace(5)* %asv, i32 1
  store volatile i8 1, i8 addrspace(5)* %p1
  %p2 = getelementptr i8, i8 addrspace(5)* %asv, i32 2
  store volatile i8 2, i8 addrspace(5)* %p2
  %p4 = getelementptr i8, i8 addrspace(5)* %asv, i32 4
  store volatile i8 4, i8 addrspace(5)* %p4
  ret void
}
