; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck --check-prefix=GFX9 %s
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=fiji -verify-machineinstrs < %s | FileCheck --check-prefix=GFX8 %s
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=hawaii -verify-machineinstrs < %s | FileCheck --check-prefix=GFX7 %s
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=gfx1010 -verify-machineinstrs < %s | FileCheck --check-prefix=GFX10 %s

define amdgpu_ps void @insertelement_s_v2i8_s_s(<2 x i8> addrspace(4)* inreg %ptr, i8 inreg %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_s_v2i8_s_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    global_load_ushort v0, v0, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v0, v1, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; GFX9-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    global_store_short v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v2i8_s_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ushort v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s4
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v0, v1, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX8-NEXT:    v_lshlrev_b16_e32 v2, 8, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v2i8_s_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s0, s2
; GFX7-NEXT:    s_mov_b32 s1, s3
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_load_ushort v0, off, s[0:3], 0
; GFX7-NEXT:    v_mov_b32_e32 v1, s4
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 0
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 1
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v2i8_s_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, s5, 1
; GFX10-NEXT:    v_cmp_eq_u32_e64 s1, s5, 0
; GFX10-NEXT:    global_load_ushort v0, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v0, s4, s1
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, s4, s0
; GFX10-NEXT:    s_movk_i32 s0, 0xff
; GFX10-NEXT:    v_and_b32_sdwa v3, v1, s0 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-NEXT:    global_store_short v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
  %vec = load <2 x i8>, <2 x i8> addrspace(4)* %ptr
  %insert = insertelement <2 x i8> %vec, i8 %val, i32 %idx
  store <2 x i8> %insert, <2 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v2i8_s_s(<2 x i8> addrspace(1)* %ptr, i8 inreg %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_v_v2i8_s_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_ushort v0, v[0:1], off
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s3, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v0, v1, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s3, 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; GFX9-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    global_store_short v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v2i8_s_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_ushort v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s2
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s3, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v0, v1, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s3, 1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX8-NEXT:    v_lshlrev_b16_e32 v2, 8, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v2i8_s_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_ushort v0, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_mov_b32_e32 v1, s2
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s3, 0
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s3, 1
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    buffer_store_short v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v2i8_s_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_ushort v0, v[0:1], off
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, s3, 1
; GFX10-NEXT:    v_cmp_eq_u32_e64 s1, s3, 0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v0, s2, s1
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, s2, s0
; GFX10-NEXT:    s_movk_i32 s0, 0xff
; GFX10-NEXT:    v_and_b32_sdwa v3, v1, s0 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-NEXT:    global_store_short v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
  %vec = load <2 x i8>, <2 x i8> addrspace(1 )* %ptr
  %insert = insertelement <2 x i8> %vec, i8 %val, i32 %idx
  store <2 x i8> %insert, <2 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v2i8_v_s(<2 x i8> addrspace(4)* inreg %ptr, i8 %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_s_v2i8_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_load_ushort v1, v1, s[2:3]
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 8, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v1, v0, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX9-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    global_store_short v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v2i8_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v1, s2
; GFX8-NEXT:    v_mov_b32_e32 v2, s3
; GFX8-NEXT:    flat_load_ushort v1, v[1:2]
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 8, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v1, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX8-NEXT:    v_lshlrev_b16_e32 v2, 8, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v2i8_v_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s0, s2
; GFX7-NEXT:    s_mov_b32 s1, s3
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_load_ushort v1, off, s[0:3], 0
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 0
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 8, v1
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v2i8_v_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s4, 1
; GFX10-NEXT:    s_movk_i32 s0, 0xff
; GFX10-NEXT:    global_load_ushort v1, v1, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v2, 8, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s4, 0
; GFX10-NEXT:    v_and_b32_sdwa v2, v2, s0 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v1, v0, vcc_lo
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-NEXT:    global_store_short v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
  %vec = load <2 x i8>, <2 x i8> addrspace(4)* %ptr
  %insert = insertelement <2 x i8> %vec, i8 %val, i32 %idx
  store <2 x i8> %insert, <2 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v2i8_s_v(<2 x i8> addrspace(4)* inreg %ptr, i8 inreg %val, i32 %idx) {
; GFX9-LABEL: insertelement_s_v2i8_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_load_ushort v1, v1, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 8, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v1, v2, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX9-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_or_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    global_store_short v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v2i8_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v1, s2
; GFX8-NEXT:    v_mov_b32_e32 v2, s3
; GFX8-NEXT:    flat_load_ushort v1, v[1:2]
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 8, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v1, v2, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX8-NEXT:    v_lshlrev_b16_e32 v2, 8, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v2i8_s_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s0, s2
; GFX7-NEXT:    s_mov_b32 s1, s3
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_load_ushort v1, off, s[0:3], 0
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 8, v1
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v2i8_s_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX10-NEXT:    s_movk_i32 s0, 0xff
; GFX10-NEXT:    global_load_ushort v1, v1, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v2, 8, v1
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v2, s4, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-NEXT:    v_and_b32_sdwa v2, v2, s0 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v1, s4, vcc_lo
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-NEXT:    global_store_short v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
  %vec = load <2 x i8>, <2 x i8> addrspace(4)* %ptr
  %insert = insertelement <2 x i8> %vec, i8 %val, i32 %idx
  store <2 x i8> %insert, <2 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v2i8_v_v(<2 x i8> addrspace(4)* inreg %ptr, i8 %val, i32 %idx) {
; GFX9-LABEL: insertelement_s_v2i8_v_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    global_load_ushort v2, v2, s[2:3]
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 8, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX9-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX9-NEXT:    v_lshlrev_b16_e32 v3, 8, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    global_store_short v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v2i8_v_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_load_ushort v2, v[2:3]
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 8, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX8-NEXT:    v_lshlrev_b16_e32 v3, 8, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v2i8_v_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s0, s2
; GFX7-NEXT:    s_mov_b32 s1, s3
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_load_ushort v2, off, s[0:3], 0
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 8, v2
; GFX7-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v2i8_v_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v1
; GFX10-NEXT:    s_movk_i32 s0, 0xff
; GFX10-NEXT:    global_load_ushort v2, v2, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 8, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v3, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX10-NEXT:    v_and_b32_sdwa v3, v3, s0 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc_lo
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-NEXT:    global_store_short v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
  %vec = load <2 x i8>, <2 x i8> addrspace(4)* %ptr
  %insert = insertelement <2 x i8> %vec, i8 %val, i32 %idx
  store <2 x i8> %insert, <2 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v2i8_s_v(<2 x i8> addrspace(1)* %ptr, i8 inreg %val, i32 %idx) {
; GFX9-LABEL: insertelement_v_v2i8_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_ushort v0, v[0:1], off
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 8, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v0, v1, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v1, vcc
; GFX9-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_or_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    global_store_short v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v2i8_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_ushort v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s2
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 8, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v0, v1, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX8-NEXT:    v_lshlrev_b16_e32 v2, 8, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v2i8_s_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_ushort v0, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_mov_b32_e32 v1, s2
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 8, v0
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    buffer_store_short v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v2i8_s_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_ushort v0, v[0:1], off
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v2
; GFX10-NEXT:    s_movk_i32 s0, 0xff
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, s2, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX10-NEXT:    v_and_b32_sdwa v3, v1, s0 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v0, s2, vcc_lo
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-NEXT:    global_store_short v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
  %vec = load <2 x i8>, <2 x i8> addrspace(1)* %ptr
  %insert = insertelement <2 x i8> %vec, i8 %val, i32 %idx
  store <2 x i8> %insert, <2 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v2i8_v_s(<2 x i8> addrspace(1)* %ptr, i8 %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_v_v2i8_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_ushort v0, v[0:1], off
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v0, v2, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc
; GFX9-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    global_store_short v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v2i8_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_ushort v0, v[0:1]
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v0, v2, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX8-NEXT:    v_lshlrev_b16_e32 v2, 8, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v2i8_v_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_ushort v0, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 0
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 1
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    buffer_store_short v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v2i8_v_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_ushort v0, v[0:1], off
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s2, 1
; GFX10-NEXT:    s_movk_i32 s0, 0xff
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s2, 0
; GFX10-NEXT:    v_and_b32_sdwa v3, v1, s0 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v0, v2, vcc_lo
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-NEXT:    global_store_short v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
  %vec = load <2 x i8>, <2 x i8> addrspace(1)* %ptr
  %insert = insertelement <2 x i8> %vec, i8 %val, i32 %idx
  store <2 x i8> %insert, <2 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v2i8_v_v(<2 x i8> addrspace(1)* %ptr, i8 %val, i32 %idx) {
; GFX9-LABEL: insertelement_v_v2i8_v_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_ushort v0, v[0:1], off
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v0, v2, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc
; GFX9-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX9-NEXT:    v_lshlrev_b16_e32 v2, 8, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_or_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    global_store_short v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v2i8_v_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_ushort v0, v[0:1]
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v0, v2, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX8-NEXT:    v_lshlrev_b16_e32 v2, 8, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v2i8_v_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s2, 0
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    buffer_load_ushort v0, v[0:1], s[0:3], 0 addr64
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v3
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v2i8_v_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_ushort v0, v[0:1], off
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v3
; GFX10-NEXT:    s_movk_i32 s0, 0xff
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v3
; GFX10-NEXT:    v_and_b32_sdwa v3, v1, s0 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v0, v2, vcc_lo
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-NEXT:    global_store_short v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
  %vec = load <2 x i8>, <2 x i8> addrspace(1)* %ptr
  %insert = insertelement <2 x i8> %vec, i8 %val, i32 %idx
  store <2 x i8> %insert, <2 x i8> addrspace(1)* null
  ret void
}

; FIXME: 3 element load/store legalization
; define amdgpu_ps void @insertelement_s_v3i8_s_s(<3 x i8> addrspace(4)* inreg %ptr, i8 inreg %val, i32 inreg %idx) {
;   %vec = load <3 x i8>, <3 x i8> addrspace(4)* %ptr
;   %insert = insertelement <3 x i8> %vec, i8 %val, i32 %idx
;   store <3 x i8> %insert, <3 x i8> addrspace(1)* null
;   ret void
; }

; define amdgpu_ps void @insertelement_v_v3i8_s_s(<3 x i8> addrspace(1)* %ptr, i8 inreg %val, i32 inreg %idx) {
;   %vec = load <3 x i8>, <3 x i8> addrspace(1 )* %ptr
;   %insert = insertelement <3 x i8> %vec, i8 %val, i32 %idx
;   store <3 x i8> %insert, <3 x i8> addrspace(1)* null
;   ret void
; }

; define amdgpu_ps void @insertelement_s_v3i8_v_s(<3 x i8> addrspace(4)* inreg %ptr, i8 %val, i32 inreg %idx) {
;   %vec = load <3 x i8>, <3 x i8> addrspace(4)* %ptr
;   %insert = insertelement <3 x i8> %vec, i8 %val, i32 %idx
;   store <3 x i8> %insert, <3 x i8> addrspace(1)* null
;   ret void
; }

; define amdgpu_ps void @insertelement_s_v3i8_s_v(<3 x i8> addrspace(4)* inreg %ptr, i8 inreg %val, i32 %idx) {
;   %vec = load <3 x i8>, <3 x i8> addrspace(4)* %ptr
;   %insert = insertelement <3 x i8> %vec, i8 %val, i32 %idx
;   store <3 x i8> %insert, <3 x i8> addrspace(1)* null
;   ret void
; }

; define amdgpu_ps void @insertelement_s_v3i8_v_v(<3 x i8> addrspace(4)* inreg %ptr, i8 %val, i32 %idx) {
;   %vec = load <3 x i8>, <3 x i8> addrspace(4)* %ptr
;   %insert = insertelement <3 x i8> %vec, i8 %val, i32 %idx
;   store <3 x i8> %insert, <3 x i8> addrspace(1)* null
;   ret void
; }

; define amdgpu_ps void @insertelement_v_v3i8_s_v(<3 x i8> addrspace(1)* %ptr, i8 inreg %val, i32 %idx) {
;   %vec = load <3 x i8>, <3 x i8> addrspace(1)* %ptr
;   %insert = insertelement <3 x i8> %vec, i8 %val, i32 %idx
;   store <3 x i8> %insert, <3 x i8> addrspace(1)* null
;   ret void
; }

; define amdgpu_ps void @insertelement_v_v3i8_v_s(<3 x i8> addrspace(1)* %ptr, i8 %val, i32 inreg %idx) {
;   %vec = load <3 x i8>, <3 x i8> addrspace(1)* %ptr
;   %insert = insertelement <3 x i8> %vec, i8 %val, i32 %idx
;   store <3 x i8> %insert, <3 x i8> addrspace(1)* null
;   ret void
; }

; define amdgpu_ps void @insertelement_v_v3i8_v_v(<3 x i8> addrspace(1)* %ptr, i8 %val, i32 %idx) {
;   %vec = load <3 x i8>, <3 x i8> addrspace(1)* %ptr
;   %insert = insertelement <3 x i8> %vec, i8 %val, i32 %idx
;   store <3 x i8> %insert, <3 x i8> addrspace(1)* null
;   ret void
; }

define amdgpu_ps void @insertelement_v_v4i8_s_s(<4 x i8> addrspace(1)* %ptr, i8 inreg %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_v_v4i8_s_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dword v0, v[0:1], off
; GFX9-NEXT:    s_mov_b32 s0, 8
; GFX9-NEXT:    s_and_b32 s3, s3, 3
; GFX9-NEXT:    s_mov_b32 s1, 16
; GFX9-NEXT:    s_movk_i32 s4, 0xff
; GFX9-NEXT:    s_and_b32 s2, s2, 0xff
; GFX9-NEXT:    s_lshl_b32 s3, s3, 3
; GFX9-NEXT:    s_lshl_b32 s2, s2, s3
; GFX9-NEXT:    s_lshl_b32 s3, 0xff, s3
; GFX9-NEXT:    s_not_b32 s3, s3
; GFX9-NEXT:    v_mov_b32_e32 v4, s2
; GFX9-NEXT:    v_mov_b32_e32 v2, 8
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v3, 16
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v6, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v7, s1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v0, s4, v6
; GFX9-NEXT:    v_lshlrev_b32_e32 v5, 24, v5
; GFX9-NEXT:    v_or3_b32 v0, v0, v7, v5
; GFX9-NEXT:    v_and_or_b32 v0, v0, s3, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v3, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v2, v0, v1, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_or3_b32 v2, v2, v3, v4
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v4i8_s_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, 8
; GFX8-NEXT:    v_mov_b32_e32 v2, 16
; GFX8-NEXT:    s_and_b32 s0, s3, 3
; GFX8-NEXT:    s_and_b32 s1, s2, 0xff
; GFX8-NEXT:    s_lshl_b32 s0, s0, 3
; GFX8-NEXT:    s_lshl_b32 s1, s1, s0
; GFX8-NEXT:    s_lshl_b32 s0, 0xff, s0
; GFX8-NEXT:    s_not_b32 s0, s0
; GFX8-NEXT:    v_mov_b32_e32 v3, 8
; GFX8-NEXT:    v_mov_b32_e32 v4, 16
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 24, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v5
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_and_b32_e32 v0, s0, v0
; GFX8-NEXT:    v_or_b32_e32 v0, s1, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 24, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v3, v4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 24, v1
; GFX8-NEXT:    v_or_b32_e32 v3, v0, v3
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v4i8_s_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_and_b32 s0, s3, 3
; GFX7-NEXT:    s_and_b32 s1, s2, 0xff
; GFX7-NEXT:    s_lshl_b32 s0, s0, 3
; GFX7-NEXT:    s_lshl_b32 s1, s1, s0
; GFX7-NEXT:    s_lshl_b32 s0, 0xff, s0
; GFX7-NEXT:    s_not_b32 s0, s0
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v3, v0, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_and_b32_e32 v0, s0, v0
; GFX7-NEXT:    v_or_b32_e32 v0, s1, v0
; GFX7-NEXT:    v_bfe_u32 v3, v0, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v4i8_s_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dword v0, v[0:1], off
; GFX10-NEXT:    s_mov_b32 s0, 8
; GFX10-NEXT:    s_and_b32 s1, s2, 0xff
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX10-NEXT:    s_mov_b32 s0, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, v0, 0xff, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 24, v2
; GFX10-NEXT:    s_and_b32 s0, s3, 3
; GFX10-NEXT:    v_mov_b32_e32 v2, 16
; GFX10-NEXT:    s_lshl_b32 s0, s0, 3
; GFX10-NEXT:    v_or3_b32 v0, v0, v3, v1
; GFX10-NEXT:    s_lshl_b32 s2, 0xff, s0
; GFX10-NEXT:    s_lshl_b32 s0, s1, s0
; GFX10-NEXT:    s_not_b32 s1, s2
; GFX10-NEXT:    v_mov_b32_e32 v1, 8
; GFX10-NEXT:    v_and_or_b32 v0, v0, s1, s0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v4, 0xff, v0, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_or3_b32 v2, v4, v2, v3
; GFX10-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
  %vec = load <4 x i8>, <4 x i8> addrspace(1 )* %ptr
  %insert = insertelement <4 x i8> %vec, i8 %val, i32 %idx
  store <4 x i8> %insert, <4 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v4i8_v_s(<4 x i8> addrspace(4)* inreg %ptr, i8 %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_s_v4i8_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX9-NEXT:    s_mov_b32 s1, 8
; GFX9-NEXT:    s_mov_b32 s2, 16
; GFX9-NEXT:    s_movk_i32 s5, 0xff
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_bfe_u32 s7, s0, 0x80008
; GFX9-NEXT:    s_lshr_b32 s3, s0, 24
; GFX9-NEXT:    s_and_b32 s6, s0, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s7, 8
; GFX9-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_lshl_b32 s0, s0, 16
; GFX9-NEXT:    s_or_b32 s0, s6, s0
; GFX9-NEXT:    s_lshl_b32 s3, s3, 24
; GFX9-NEXT:    s_or_b32 s0, s0, s3
; GFX9-NEXT:    s_and_b32 s3, s4, 3
; GFX9-NEXT:    s_lshl_b32 s3, s3, 3
; GFX9-NEXT:    s_lshl_b32 s4, 0xff, s3
; GFX9-NEXT:    s_andn2_b32 s0, s0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-NEXT:    v_lshl_or_b32 v0, v0, s3, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, s1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_and_or_b32 v2, v0, s5, v2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v3, s2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_e32 v4, 24, v1
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_or3_b32 v2, v2, v3, v4
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v4i8_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX8-NEXT:    v_mov_b32_e32 v2, 8
; GFX8-NEXT:    v_mov_b32_e32 v3, 16
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_bfe_u32 s3, s0, 0x80008
; GFX8-NEXT:    s_lshr_b32 s1, s0, 24
; GFX8-NEXT:    s_and_b32 s2, s0, 0xff
; GFX8-NEXT:    s_lshl_b32 s3, s3, 8
; GFX8-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX8-NEXT:    s_or_b32 s2, s2, s3
; GFX8-NEXT:    s_lshl_b32 s0, s0, 16
; GFX8-NEXT:    s_or_b32 s0, s2, s0
; GFX8-NEXT:    s_lshl_b32 s1, s1, 24
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    s_and_b32 s1, s4, 3
; GFX8-NEXT:    s_lshl_b32 s1, s1, 3
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_lshl_b32 s1, 0xff, s1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    s_andn2_b32 s0, s0, s1
; GFX8-NEXT:    v_or_b32_e32 v0, s0, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 24, v0
; GFX8-NEXT:    v_or_b32_sdwa v2, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_e32 v2, v2, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 24, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v4i8_v_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_bfe_u32 s3, s0, 0x80008
; GFX7-NEXT:    s_lshr_b32 s1, s0, 24
; GFX7-NEXT:    s_and_b32 s2, s0, 0xff
; GFX7-NEXT:    s_lshl_b32 s3, s3, 8
; GFX7-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX7-NEXT:    s_or_b32 s2, s2, s3
; GFX7-NEXT:    s_lshl_b32 s0, s0, 16
; GFX7-NEXT:    s_or_b32 s0, s2, s0
; GFX7-NEXT:    s_lshl_b32 s1, s1, 24
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    s_and_b32 s1, s4, 3
; GFX7-NEXT:    s_lshl_b32 s1, s1, 3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, s1, v0
; GFX7-NEXT:    s_lshl_b32 s1, 0xff, s1
; GFX7-NEXT:    s_andn2_b32 s0, s0, s1
; GFX7-NEXT:    v_or_b32_e32 v0, s0, v0
; GFX7-NEXT:    v_bfe_u32 v3, v0, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v4i8_v_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX10-NEXT:    s_and_b32 s1, s4, 3
; GFX10-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX10-NEXT:    s_lshl_b32 s1, s1, 3
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_bfe_u32 s4, s0, 0x80008
; GFX10-NEXT:    s_lshr_b32 s2, s0, 24
; GFX10-NEXT:    s_and_b32 s3, s0, 0xff
; GFX10-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX10-NEXT:    s_lshl_b32 s4, s4, 8
; GFX10-NEXT:    s_lshl_b32 s0, s0, 16
; GFX10-NEXT:    s_or_b32 s3, s3, s4
; GFX10-NEXT:    s_lshl_b32 s2, s2, 24
; GFX10-NEXT:    s_or_b32 s0, s3, s0
; GFX10-NEXT:    s_lshl_b32 s3, 0xff, s1
; GFX10-NEXT:    s_or_b32 s0, s0, s2
; GFX10-NEXT:    s_andn2_b32 s0, s0, s3
; GFX10-NEXT:    v_lshl_or_b32 v0, v0, s1, s0
; GFX10-NEXT:    s_mov_b32 s0, 8
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX10-NEXT:    s_mov_b32 s0, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v4, v0, 0xff, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_or3_b32 v2, v4, v3, v2
; GFX10-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
  %vec = load <4 x i8>, <4 x i8> addrspace(4)* %ptr
  %insert = insertelement <4 x i8> %vec, i8 %val, i32 %idx
  store <4 x i8> %insert, <4 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v4i8_s_v(<4 x i8> addrspace(4)* inreg %ptr, i8 inreg %val, i32 %idx) {
; GFX9-LABEL: insertelement_s_v4i8_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX9-NEXT:    s_movk_i32 s5, 0xff
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX9-NEXT:    s_mov_b32 s1, 8
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_bfe_u32 s7, s0, 0x80008
; GFX9-NEXT:    s_lshr_b32 s3, s0, 24
; GFX9-NEXT:    s_and_b32 s6, s0, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s7, 8
; GFX9-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_lshl_b32 s0, s0, 16
; GFX9-NEXT:    s_or_b32 s0, s6, s0
; GFX9-NEXT:    s_lshl_b32 s3, s3, 24
; GFX9-NEXT:    s_or_b32 s0, s0, s3
; GFX9-NEXT:    s_and_b32 s3, s4, 0xff
; GFX9-NEXT:    v_lshlrev_b32_e64 v1, v0, s3
; GFX9-NEXT:    v_lshlrev_b32_e64 v0, v0, s5
; GFX9-NEXT:    v_xor_b32_e32 v0, -1, v0
; GFX9-NEXT:    v_and_or_b32 v0, s0, v0, v1
; GFX9-NEXT:    s_mov_b32 s2, 16
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, s1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_and_or_b32 v2, v0, s5, v2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v3, s2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_e32 v4, 24, v1
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_or3_b32 v2, v2, v3, v4
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v4i8_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX8-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX8-NEXT:    s_movk_i32 s1, 0xff
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX8-NEXT:    v_mov_b32_e32 v2, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_bfe_u32 s5, s0, 0x80008
; GFX8-NEXT:    s_lshr_b32 s2, s0, 24
; GFX8-NEXT:    s_and_b32 s3, s0, 0xff
; GFX8-NEXT:    s_lshl_b32 s5, s5, 8
; GFX8-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX8-NEXT:    s_or_b32 s3, s3, s5
; GFX8-NEXT:    s_lshl_b32 s0, s0, 16
; GFX8-NEXT:    s_or_b32 s0, s3, s0
; GFX8-NEXT:    s_lshl_b32 s2, s2, 24
; GFX8-NEXT:    s_or_b32 s0, s0, s2
; GFX8-NEXT:    s_and_b32 s2, s4, 0xff
; GFX8-NEXT:    v_lshlrev_b32_e64 v1, v0, s2
; GFX8-NEXT:    v_lshlrev_b32_e64 v0, v0, s1
; GFX8-NEXT:    v_xor_b32_e32 v0, -1, v0
; GFX8-NEXT:    v_and_b32_e32 v0, s0, v0
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_mov_b32_e32 v3, 16
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 24, v0
; GFX8-NEXT:    v_or_b32_sdwa v2, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_e32 v2, v2, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 24, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v4i8_s_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX7-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_bfe_u32 s3, s0, 0x80008
; GFX7-NEXT:    s_lshr_b32 s1, s0, 24
; GFX7-NEXT:    s_and_b32 s2, s0, 0xff
; GFX7-NEXT:    s_lshl_b32 s3, s3, 8
; GFX7-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX7-NEXT:    s_or_b32 s2, s2, s3
; GFX7-NEXT:    s_lshl_b32 s0, s0, 16
; GFX7-NEXT:    s_or_b32 s0, s2, s0
; GFX7-NEXT:    s_lshl_b32 s1, s1, 24
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    s_and_b32 s1, s4, 0xff
; GFX7-NEXT:    v_lshl_b32_e32 v1, s1, v0
; GFX7-NEXT:    v_lshl_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    v_xor_b32_e32 v0, -1, v0
; GFX7-NEXT:    v_and_b32_e32 v0, s0, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_bfe_u32 v3, v0, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v4i8_s_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX10-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX10-NEXT:    s_and_b32 s1, s4, 0xff
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX10-NEXT:    v_lshlrev_b32_e64 v1, v0, 0xff
; GFX10-NEXT:    v_lshlrev_b32_e64 v0, v0, s1
; GFX10-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_bfe_u32 s3, s0, 0x80008
; GFX10-NEXT:    s_lshr_b32 s1, s0, 24
; GFX10-NEXT:    s_and_b32 s2, s0, 0xff
; GFX10-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX10-NEXT:    s_lshl_b32 s3, s3, 8
; GFX10-NEXT:    s_lshl_b32 s0, s0, 16
; GFX10-NEXT:    s_or_b32 s2, s2, s3
; GFX10-NEXT:    s_lshl_b32 s1, s1, 24
; GFX10-NEXT:    s_or_b32 s0, s2, s0
; GFX10-NEXT:    s_or_b32 s0, s0, s1
; GFX10-NEXT:    v_and_or_b32 v0, s0, v1, v0
; GFX10-NEXT:    s_mov_b32 s0, 8
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX10-NEXT:    s_mov_b32 s0, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v4, v0, 0xff, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_or3_b32 v2, v4, v3, v2
; GFX10-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
  %vec = load <4 x i8>, <4 x i8> addrspace(4)* %ptr
  %insert = insertelement <4 x i8> %vec, i8 %val, i32 %idx
  store <4 x i8> %insert, <4 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v4i8_v_v(<4 x i8> addrspace(4)* inreg %ptr, i8 %val, i32 %idx) {
; GFX9-LABEL: insertelement_s_v4i8_v_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX9-NEXT:    s_movk_i32 s4, 0xff
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_bfe_u32 s6, s0, 0x80008
; GFX9-NEXT:    s_lshr_b32 s3, s0, 24
; GFX9-NEXT:    s_and_b32 s5, s0, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 8
; GFX9-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_lshl_b32 s0, s0, 16
; GFX9-NEXT:    s_or_b32 s0, s5, s0
; GFX9-NEXT:    s_lshl_b32 s3, s3, 24
; GFX9-NEXT:    v_lshlrev_b32_e64 v1, v1, s4
; GFX9-NEXT:    s_or_b32 s0, s0, s3
; GFX9-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX9-NEXT:    s_mov_b32 s1, 8
; GFX9-NEXT:    v_and_or_b32 v0, s0, v1, v0
; GFX9-NEXT:    s_mov_b32 s2, 16
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, s1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_and_or_b32 v2, v0, s4, v2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v3, s2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_e32 v4, 24, v1
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_or3_b32 v2, v2, v3, v4
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v4i8_v_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX8-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX8-NEXT:    s_movk_i32 s1, 0xff
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_bfe_u32 s4, s0, 0x80008
; GFX8-NEXT:    s_lshr_b32 s2, s0, 24
; GFX8-NEXT:    s_and_b32 s3, s0, 0xff
; GFX8-NEXT:    s_lshl_b32 s4, s4, 8
; GFX8-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX8-NEXT:    s_or_b32 s3, s3, s4
; GFX8-NEXT:    s_lshl_b32 s0, s0, 16
; GFX8-NEXT:    s_or_b32 s0, s3, s0
; GFX8-NEXT:    s_lshl_b32 s2, s2, 24
; GFX8-NEXT:    v_lshlrev_b32_e64 v1, v1, s1
; GFX8-NEXT:    s_or_b32 s0, s0, s2
; GFX8-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX8-NEXT:    v_and_b32_e32 v1, s0, v1
; GFX8-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-NEXT:    v_mov_b32_e32 v2, 8
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_mov_b32_e32 v3, 16
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 24, v0
; GFX8-NEXT:    v_or_b32_sdwa v2, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_e32 v2, v2, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 24, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v4i8_v_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX7-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, v1, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_bfe_u32 s3, s0, 0x80008
; GFX7-NEXT:    s_lshr_b32 s1, s0, 24
; GFX7-NEXT:    s_and_b32 s2, s0, 0xff
; GFX7-NEXT:    s_lshl_b32 s3, s3, 8
; GFX7-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX7-NEXT:    s_or_b32 s2, s2, s3
; GFX7-NEXT:    s_lshl_b32 s0, s0, 16
; GFX7-NEXT:    s_or_b32 s0, s2, s0
; GFX7-NEXT:    s_lshl_b32 s1, s1, 24
; GFX7-NEXT:    v_lshl_b32_e32 v1, 0xff, v1
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX7-NEXT:    v_and_b32_e32 v1, s0, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_bfe_u32 v3, v0, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v4i8_v_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX10-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX10-NEXT:    v_lshlrev_b32_e64 v2, v1, 0xff
; GFX10-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX10-NEXT:    v_xor_b32_e32 v1, -1, v2
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_bfe_u32 s3, s0, 0x80008
; GFX10-NEXT:    s_lshr_b32 s1, s0, 24
; GFX10-NEXT:    s_and_b32 s2, s0, 0xff
; GFX10-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX10-NEXT:    s_lshl_b32 s3, s3, 8
; GFX10-NEXT:    s_lshl_b32 s0, s0, 16
; GFX10-NEXT:    s_or_b32 s2, s2, s3
; GFX10-NEXT:    s_lshl_b32 s1, s1, 24
; GFX10-NEXT:    s_or_b32 s0, s2, s0
; GFX10-NEXT:    s_or_b32 s0, s0, s1
; GFX10-NEXT:    v_and_or_b32 v0, s0, v1, v0
; GFX10-NEXT:    s_mov_b32 s0, 8
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX10-NEXT:    s_mov_b32 s0, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v4, v0, 0xff, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_or3_b32 v2, v4, v3, v2
; GFX10-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
  %vec = load <4 x i8>, <4 x i8> addrspace(4)* %ptr
  %insert = insertelement <4 x i8> %vec, i8 %val, i32 %idx
  store <4 x i8> %insert, <4 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v4i8_s_v(<4 x i8> addrspace(1)* %ptr, i8 inreg %val, i32 %idx) {
; GFX9-LABEL: insertelement_v_v4i8_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dword v0, v[0:1], off
; GFX9-NEXT:    s_mov_b32 s0, 8
; GFX9-NEXT:    v_and_b32_e32 v2, 3, v2
; GFX9-NEXT:    s_mov_b32 s1, 16
; GFX9-NEXT:    s_movk_i32 s3, 0xff
; GFX9-NEXT:    s_and_b32 s2, s2, 0xff
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 3, v2
; GFX9-NEXT:    v_lshlrev_b32_e64 v5, v2, s2
; GFX9-NEXT:    v_lshlrev_b32_e64 v2, v2, s3
; GFX9-NEXT:    v_xor_b32_e32 v2, -1, v2
; GFX9-NEXT:    v_mov_b32_e32 v3, 8
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v4, 16
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v7, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v8, s1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v0, s3, v7
; GFX9-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX9-NEXT:    v_or3_b32 v0, v0, v8, v6
; GFX9-NEXT:    v_and_or_b32 v0, v0, v2, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v3, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v4, v4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v3, v0, v1, v3
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_or3_b32 v2, v3, v4, v2
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v4i8_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v3, 8
; GFX8-NEXT:    v_and_b32_e32 v2, 3, v2
; GFX8-NEXT:    v_mov_b32_e32 v1, 0xff
; GFX8-NEXT:    v_mov_b32_e32 v4, 16
; GFX8-NEXT:    s_and_b32 s0, s2, 0xff
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 3, v2
; GFX8-NEXT:    v_lshlrev_b32_e64 v7, v2, s0
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, v2, v1
; GFX8-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX8-NEXT:    v_mov_b32_e32 v5, 8
; GFX8-NEXT:    v_mov_b32_e32 v6, 16
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_sdwa v3, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v4, v4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v7
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v5, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 24, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v3, v6, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 24, v1
; GFX8-NEXT:    v_or_b32_e32 v3, v0, v3
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v4i8_s_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_and_b32_e32 v1, 3, v2
; GFX7-NEXT:    s_and_b32 s0, s2, 0xff
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX7-NEXT:    v_lshl_b32_e32 v2, s0, v1
; GFX7-NEXT:    v_lshl_b32_e32 v1, 0xff, v1
; GFX7-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v5, v0, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v4, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 8, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v4, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX7-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_bfe_u32 v3, v0, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v4i8_s_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dword v0, v[0:1], off
; GFX10-NEXT:    v_and_b32_e32 v1, 3, v2
; GFX10-NEXT:    s_mov_b32 s0, 8
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX10-NEXT:    v_lshlrev_b32_e64 v4, v1, 0xff
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX10-NEXT:    s_mov_b32 s0, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v5, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, v0, 0xff, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 24, v3
; GFX10-NEXT:    s_and_b32 s0, s2, 0xff
; GFX10-NEXT:    v_xor_b32_e32 v3, -1, v4
; GFX10-NEXT:    v_lshlrev_b32_e64 v1, v1, s0
; GFX10-NEXT:    v_or3_b32 v0, v0, v5, v2
; GFX10-NEXT:    v_mov_b32_e32 v2, 8
; GFX10-NEXT:    v_and_or_b32 v0, v0, v3, v1
; GFX10-NEXT:    v_mov_b32_e32 v1, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v4, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v2, 0xff, v0, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_or3_b32 v2, v2, v4, v3
; GFX10-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
  %vec = load <4 x i8>, <4 x i8> addrspace(1)* %ptr
  %insert = insertelement <4 x i8> %vec, i8 %val, i32 %idx
  store <4 x i8> %insert, <4 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v4i8_v_s(<4 x i8> addrspace(1)* %ptr, i8 %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_v_v4i8_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dword v0, v[0:1], off
; GFX9-NEXT:    s_mov_b32 s0, 8
; GFX9-NEXT:    s_and_b32 s2, s2, 3
; GFX9-NEXT:    s_mov_b32 s1, 16
; GFX9-NEXT:    s_movk_i32 s3, 0xff
; GFX9-NEXT:    s_lshl_b32 s2, s2, 3
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, s2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    s_lshl_b32 s2, 0xff, s2
; GFX9-NEXT:    s_not_b32 s2, s2
; GFX9-NEXT:    v_mov_b32_e32 v3, 8
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v4, 16
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v6, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v7, s1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v0, s3, v6
; GFX9-NEXT:    v_lshlrev_b32_e32 v5, 24, v5
; GFX9-NEXT:    v_or3_b32 v0, v0, v7, v5
; GFX9-NEXT:    v_and_or_b32 v0, v0, s2, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v3, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v4, v4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v3, v0, v1, v3
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_or3_b32 v2, v3, v4, v2
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v4i8_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_and_b32 s0, s2, 3
; GFX8-NEXT:    v_mov_b32_e32 v1, 8
; GFX8-NEXT:    s_lshl_b32 s0, s0, 3
; GFX8-NEXT:    v_mov_b32_e32 v3, 16
; GFX8-NEXT:    v_mov_b32_e32 v6, s0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v6, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    s_lshl_b32 s0, 0xff, s0
; GFX8-NEXT:    s_not_b32 s0, s0
; GFX8-NEXT:    v_mov_b32_e32 v4, 8
; GFX8-NEXT:    v_mov_b32_e32 v5, 16
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 24, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v3, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v6
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_and_b32_e32 v0, s0, v0
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 24, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v3, v5, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 24, v1
; GFX8-NEXT:    v_or_b32_e32 v3, v0, v3
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v4i8_v_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_and_b32 s0, s2, 3
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX7-NEXT:    s_lshl_b32 s0, s0, 3
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, s0, v1
; GFX7-NEXT:    s_lshl_b32 s0, 0xff, s0
; GFX7-NEXT:    s_not_b32 s0, s0
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v4, v0, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v3, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX7-NEXT:    v_or_b32_e32 v0, v3, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_and_b32_e32 v0, s0, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_bfe_u32 v3, v0, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v4i8_v_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dword v0, v[0:1], off
; GFX10-NEXT:    s_mov_b32 s0, 8
; GFX10-NEXT:    s_and_b32 s1, s2, 3
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX10-NEXT:    s_mov_b32 s0, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v4, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, v0, 0xff, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX10-NEXT:    s_lshl_b32 s0, s1, 3
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, s0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX10-NEXT:    s_lshl_b32 s0, 0xff, s0
; GFX10-NEXT:    v_or3_b32 v0, v0, v4, v1
; GFX10-NEXT:    s_not_b32 s0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, 8
; GFX10-NEXT:    v_and_or_b32 v0, v0, s0, v2
; GFX10-NEXT:    v_mov_b32_e32 v2, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v4, 0xff, v0, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_or3_b32 v2, v4, v2, v3
; GFX10-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
  %vec = load <4 x i8>, <4 x i8> addrspace(1)* %ptr
  %insert = insertelement <4 x i8> %vec, i8 %val, i32 %idx
  store <4 x i8> %insert, <4 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v4i8_v_v(<4 x i8> addrspace(1)* %ptr, i8 %val, i32 %idx) {
; GFX9-LABEL: insertelement_v_v4i8_v_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dword v0, v[0:1], off
; GFX9-NEXT:    s_mov_b32 s0, 8
; GFX9-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX9-NEXT:    s_mov_b32 s1, 16
; GFX9-NEXT:    s_movk_i32 s2, 0xff
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_e64 v3, v3, s2
; GFX9-NEXT:    v_xor_b32_e32 v3, -1, v3
; GFX9-NEXT:    v_mov_b32_e32 v4, 8
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v5, 16
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v7, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v8, s1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v0, s2, v7
; GFX9-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX9-NEXT:    v_or3_b32 v0, v0, v8, v6
; GFX9-NEXT:    v_and_or_b32 v0, v0, v3, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v3, v4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v4, v5, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v3, v0, v1, v3
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_or3_b32 v2, v3, v4, v2
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v4i8_v_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v4, 8
; GFX8-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_mov_b32_e32 v1, 0xff
; GFX8-NEXT:    v_mov_b32_e32 v5, 16
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, v3, v1
; GFX8-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX8-NEXT:    v_mov_b32_e32 v6, 8
; GFX8-NEXT:    v_mov_b32_e32 v7, 16
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_sdwa v4, v4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v5, v5, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v5
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX8-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v6, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 24, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v3, v7, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 24, v1
; GFX8-NEXT:    v_or_b32_e32 v3, v0, v3
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v4i8_v_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s2, 0
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[0:3], 0 addr64
; GFX7-NEXT:    v_and_b32_e32 v1, 3, v3
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v1, v2
; GFX7-NEXT:    v_lshl_b32_e32 v1, 0xff, v1
; GFX7-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v5, v0, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v4, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 8, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v4, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX7-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_bfe_u32 v3, v0, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v4i8_v_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dword v0, v[0:1], off
; GFX10-NEXT:    v_and_b32_e32 v1, 3, v3
; GFX10-NEXT:    s_mov_b32 s0, 8
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX10-NEXT:    v_lshlrev_b32_e64 v5, v1, 0xff
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX10-NEXT:    v_xor_b32_e32 v2, -1, v5
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX10-NEXT:    s_mov_b32 s0, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v6, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, v0, 0xff, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 24, v4
; GFX10-NEXT:    v_or3_b32 v0, v0, v6, v3
; GFX10-NEXT:    v_mov_b32_e32 v3, 8
; GFX10-NEXT:    v_and_or_b32 v0, v0, v2, v1
; GFX10-NEXT:    v_mov_b32_e32 v1, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v4, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v2, 0xff, v0, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_or3_b32 v2, v2, v4, v3
; GFX10-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
  %vec = load <4 x i8>, <4 x i8> addrspace(1)* %ptr
  %insert = insertelement <4 x i8> %vec, i8 %val, i32 %idx
  store <4 x i8> %insert, <4 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v8i8_s_s(<8 x i8> addrspace(4)* inreg %ptr, i8 inreg %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_s_v8i8_s_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_bfe_u32 s7, s0, 0x80008
; GFX9-NEXT:    s_lshr_b32 s2, s0, 24
; GFX9-NEXT:    s_and_b32 s6, s0, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s7, 8
; GFX9-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_lshl_b32 s0, s0, 16
; GFX9-NEXT:    s_or_b32 s0, s6, s0
; GFX9-NEXT:    s_lshl_b32 s2, s2, 24
; GFX9-NEXT:    s_bfe_u32 s6, s1, 0x80008
; GFX9-NEXT:    s_lshr_b32 s3, s1, 24
; GFX9-NEXT:    s_or_b32 s0, s0, s2
; GFX9-NEXT:    s_and_b32 s2, s1, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 8
; GFX9-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX9-NEXT:    s_or_b32 s2, s2, s6
; GFX9-NEXT:    s_lshl_b32 s1, s1, 16
; GFX9-NEXT:    s_or_b32 s1, s2, s1
; GFX9-NEXT:    s_lshl_b32 s2, s3, 24
; GFX9-NEXT:    s_or_b32 s1, s1, s2
; GFX9-NEXT:    s_lshr_b32 s2, s5, 2
; GFX9-NEXT:    s_cmp_eq_u32 s2, 1
; GFX9-NEXT:    s_cselect_b32 s3, s1, s0
; GFX9-NEXT:    s_and_b32 s5, s5, 3
; GFX9-NEXT:    s_lshl_b32 s5, s5, 3
; GFX9-NEXT:    s_and_b32 s4, s4, 0xff
; GFX9-NEXT:    s_lshl_b32 s4, s4, s5
; GFX9-NEXT:    s_lshl_b32 s5, 0xff, s5
; GFX9-NEXT:    s_andn2_b32 s3, s3, s5
; GFX9-NEXT:    s_or_b32 s3, s3, s4
; GFX9-NEXT:    s_cmp_eq_u32 s2, 0
; GFX9-NEXT:    s_cselect_b32 s0, s3, s0
; GFX9-NEXT:    s_cmp_eq_u32 s2, 1
; GFX9-NEXT:    s_cselect_b32 s1, s3, s1
; GFX9-NEXT:    s_bfe_u32 s5, s0, 0x80008
; GFX9-NEXT:    s_lshr_b32 s2, s0, 24
; GFX9-NEXT:    s_and_b32 s4, s0, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 8
; GFX9-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_lshl_b32 s0, s0, 16
; GFX9-NEXT:    s_or_b32 s0, s4, s0
; GFX9-NEXT:    s_lshl_b32 s2, s2, 24
; GFX9-NEXT:    s_bfe_u32 s4, s1, 0x80008
; GFX9-NEXT:    s_lshr_b32 s3, s1, 24
; GFX9-NEXT:    s_or_b32 s0, s0, s2
; GFX9-NEXT:    s_and_b32 s2, s1, 0xff
; GFX9-NEXT:    s_lshl_b32 s4, s4, 8
; GFX9-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX9-NEXT:    s_or_b32 s2, s2, s4
; GFX9-NEXT:    s_lshl_b32 s1, s1, 16
; GFX9-NEXT:    s_or_b32 s1, s2, s1
; GFX9-NEXT:    s_lshl_b32 s2, s3, 24
; GFX9-NEXT:    s_or_b32 s1, s1, s2
; GFX9-NEXT:    v_mov_b32_e32 v3, s1
; GFX9-NEXT:    v_mov_b32_e32 v2, s0
; GFX9-NEXT:    global_store_dwordx2 v[0:1], v[2:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v8i8_s_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX8-NEXT:    v_mov_b32_e32 v0, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_bfe_u32 s7, s0, 0x80008
; GFX8-NEXT:    s_lshr_b32 s2, s0, 24
; GFX8-NEXT:    s_and_b32 s6, s0, 0xff
; GFX8-NEXT:    s_lshl_b32 s7, s7, 8
; GFX8-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX8-NEXT:    s_or_b32 s6, s6, s7
; GFX8-NEXT:    s_lshl_b32 s0, s0, 16
; GFX8-NEXT:    s_or_b32 s0, s6, s0
; GFX8-NEXT:    s_lshl_b32 s2, s2, 24
; GFX8-NEXT:    s_bfe_u32 s6, s1, 0x80008
; GFX8-NEXT:    s_lshr_b32 s3, s1, 24
; GFX8-NEXT:    s_or_b32 s0, s0, s2
; GFX8-NEXT:    s_and_b32 s2, s1, 0xff
; GFX8-NEXT:    s_lshl_b32 s6, s6, 8
; GFX8-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX8-NEXT:    s_or_b32 s2, s2, s6
; GFX8-NEXT:    s_lshl_b32 s1, s1, 16
; GFX8-NEXT:    s_or_b32 s1, s2, s1
; GFX8-NEXT:    s_lshl_b32 s2, s3, 24
; GFX8-NEXT:    s_or_b32 s1, s1, s2
; GFX8-NEXT:    s_lshr_b32 s2, s5, 2
; GFX8-NEXT:    s_cmp_eq_u32 s2, 1
; GFX8-NEXT:    s_cselect_b32 s3, s1, s0
; GFX8-NEXT:    s_and_b32 s5, s5, 3
; GFX8-NEXT:    s_lshl_b32 s5, s5, 3
; GFX8-NEXT:    s_and_b32 s4, s4, 0xff
; GFX8-NEXT:    s_lshl_b32 s4, s4, s5
; GFX8-NEXT:    s_lshl_b32 s5, 0xff, s5
; GFX8-NEXT:    s_andn2_b32 s3, s3, s5
; GFX8-NEXT:    s_or_b32 s3, s3, s4
; GFX8-NEXT:    s_cmp_eq_u32 s2, 0
; GFX8-NEXT:    s_cselect_b32 s0, s3, s0
; GFX8-NEXT:    s_cmp_eq_u32 s2, 1
; GFX8-NEXT:    s_cselect_b32 s1, s3, s1
; GFX8-NEXT:    s_bfe_u32 s5, s0, 0x80008
; GFX8-NEXT:    s_lshr_b32 s2, s0, 24
; GFX8-NEXT:    s_and_b32 s4, s0, 0xff
; GFX8-NEXT:    s_lshl_b32 s5, s5, 8
; GFX8-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX8-NEXT:    s_or_b32 s4, s4, s5
; GFX8-NEXT:    s_lshl_b32 s0, s0, 16
; GFX8-NEXT:    s_or_b32 s0, s4, s0
; GFX8-NEXT:    s_lshl_b32 s2, s2, 24
; GFX8-NEXT:    s_bfe_u32 s4, s1, 0x80008
; GFX8-NEXT:    s_lshr_b32 s3, s1, 24
; GFX8-NEXT:    s_or_b32 s0, s0, s2
; GFX8-NEXT:    s_and_b32 s2, s1, 0xff
; GFX8-NEXT:    s_lshl_b32 s4, s4, 8
; GFX8-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX8-NEXT:    s_or_b32 s2, s2, s4
; GFX8-NEXT:    s_lshl_b32 s1, s1, 16
; GFX8-NEXT:    s_or_b32 s1, s2, s1
; GFX8-NEXT:    s_lshl_b32 s2, s3, 24
; GFX8-NEXT:    s_or_b32 s1, s1, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v8i8_s_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_bfe_u32 s7, s0, 0x80008
; GFX7-NEXT:    s_lshr_b32 s2, s0, 24
; GFX7-NEXT:    s_and_b32 s6, s0, 0xff
; GFX7-NEXT:    s_lshl_b32 s7, s7, 8
; GFX7-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX7-NEXT:    s_or_b32 s6, s6, s7
; GFX7-NEXT:    s_lshl_b32 s0, s0, 16
; GFX7-NEXT:    s_or_b32 s0, s6, s0
; GFX7-NEXT:    s_lshl_b32 s2, s2, 24
; GFX7-NEXT:    s_bfe_u32 s6, s1, 0x80008
; GFX7-NEXT:    s_lshr_b32 s3, s1, 24
; GFX7-NEXT:    s_or_b32 s0, s0, s2
; GFX7-NEXT:    s_and_b32 s2, s1, 0xff
; GFX7-NEXT:    s_lshl_b32 s6, s6, 8
; GFX7-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX7-NEXT:    s_or_b32 s2, s2, s6
; GFX7-NEXT:    s_lshl_b32 s1, s1, 16
; GFX7-NEXT:    s_or_b32 s1, s2, s1
; GFX7-NEXT:    s_lshl_b32 s2, s3, 24
; GFX7-NEXT:    s_or_b32 s1, s1, s2
; GFX7-NEXT:    s_lshr_b32 s2, s5, 2
; GFX7-NEXT:    s_cmp_eq_u32 s2, 1
; GFX7-NEXT:    s_cselect_b32 s3, s1, s0
; GFX7-NEXT:    s_and_b32 s5, s5, 3
; GFX7-NEXT:    s_lshl_b32 s5, s5, 3
; GFX7-NEXT:    s_and_b32 s4, s4, 0xff
; GFX7-NEXT:    s_lshl_b32 s4, s4, s5
; GFX7-NEXT:    s_lshl_b32 s5, 0xff, s5
; GFX7-NEXT:    s_andn2_b32 s3, s3, s5
; GFX7-NEXT:    s_or_b32 s3, s3, s4
; GFX7-NEXT:    s_cmp_eq_u32 s2, 0
; GFX7-NEXT:    s_cselect_b32 s4, s3, s0
; GFX7-NEXT:    s_cmp_eq_u32 s2, 1
; GFX7-NEXT:    s_cselect_b32 s3, s3, s1
; GFX7-NEXT:    s_bfe_u32 s7, s4, 0x80008
; GFX7-NEXT:    s_lshr_b32 s2, s4, 24
; GFX7-NEXT:    s_and_b32 s6, s4, 0xff
; GFX7-NEXT:    s_lshl_b32 s7, s7, 8
; GFX7-NEXT:    s_bfe_u32 s4, s4, 0x80010
; GFX7-NEXT:    s_or_b32 s6, s6, s7
; GFX7-NEXT:    s_lshl_b32 s4, s4, 16
; GFX7-NEXT:    s_or_b32 s4, s6, s4
; GFX7-NEXT:    s_lshl_b32 s2, s2, 24
; GFX7-NEXT:    s_bfe_u32 s6, s3, 0x80008
; GFX7-NEXT:    s_lshr_b32 s5, s3, 24
; GFX7-NEXT:    s_or_b32 s2, s4, s2
; GFX7-NEXT:    s_and_b32 s4, s3, 0xff
; GFX7-NEXT:    s_lshl_b32 s6, s6, 8
; GFX7-NEXT:    s_bfe_u32 s3, s3, 0x80010
; GFX7-NEXT:    s_or_b32 s4, s4, s6
; GFX7-NEXT:    s_lshl_b32 s3, s3, 16
; GFX7-NEXT:    s_or_b32 s3, s4, s3
; GFX7-NEXT:    s_lshl_b32 s4, s5, 24
; GFX7-NEXT:    s_or_b32 s3, s3, s4
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v8i8_s_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX10-NEXT:    s_lshr_b32 s2, s5, 2
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_bfe_u32 s8, s0, 0x80008
; GFX10-NEXT:    s_bfe_u32 s10, s1, 0x80008
; GFX10-NEXT:    s_lshr_b32 s3, s0, 24
; GFX10-NEXT:    s_lshr_b32 s6, s1, 24
; GFX10-NEXT:    s_and_b32 s7, s0, 0xff
; GFX10-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX10-NEXT:    s_and_b32 s9, s1, 0xff
; GFX10-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX10-NEXT:    s_lshl_b32 s8, s8, 8
; GFX10-NEXT:    s_lshl_b32 s10, s10, 8
; GFX10-NEXT:    s_lshl_b32 s0, s0, 16
; GFX10-NEXT:    s_lshl_b32 s1, s1, 16
; GFX10-NEXT:    s_or_b32 s7, s7, s8
; GFX10-NEXT:    s_or_b32 s8, s9, s10
; GFX10-NEXT:    s_lshl_b32 s3, s3, 24
; GFX10-NEXT:    s_lshl_b32 s6, s6, 24
; GFX10-NEXT:    s_or_b32 s0, s7, s0
; GFX10-NEXT:    s_or_b32 s1, s8, s1
; GFX10-NEXT:    s_or_b32 s0, s0, s3
; GFX10-NEXT:    s_or_b32 s1, s1, s6
; GFX10-NEXT:    s_cmp_eq_u32 s2, 1
; GFX10-NEXT:    s_cselect_b32 s3, s1, s0
; GFX10-NEXT:    s_and_b32 s5, s5, 3
; GFX10-NEXT:    s_and_b32 s4, s4, 0xff
; GFX10-NEXT:    s_lshl_b32 s5, s5, 3
; GFX10-NEXT:    s_lshl_b32 s6, 0xff, s5
; GFX10-NEXT:    s_lshl_b32 s4, s4, s5
; GFX10-NEXT:    s_andn2_b32 s3, s3, s6
; GFX10-NEXT:    s_or_b32 s3, s3, s4
; GFX10-NEXT:    s_cmp_eq_u32 s2, 0
; GFX10-NEXT:    s_cselect_b32 s0, s3, s0
; GFX10-NEXT:    s_cmp_eq_u32 s2, 1
; GFX10-NEXT:    s_cselect_b32 s1, s3, s1
; GFX10-NEXT:    s_bfe_u32 s4, s0, 0x80008
; GFX10-NEXT:    s_lshr_b32 s2, s0, 24
; GFX10-NEXT:    s_and_b32 s3, s0, 0xff
; GFX10-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX10-NEXT:    s_lshl_b32 s4, s4, 8
; GFX10-NEXT:    s_bfe_u32 s7, s1, 0x80008
; GFX10-NEXT:    s_lshr_b32 s5, s1, 24
; GFX10-NEXT:    s_lshl_b32 s0, s0, 16
; GFX10-NEXT:    s_and_b32 s6, s1, 0xff
; GFX10-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX10-NEXT:    s_or_b32 s3, s3, s4
; GFX10-NEXT:    s_lshl_b32 s4, s7, 8
; GFX10-NEXT:    s_or_b32 s0, s3, s0
; GFX10-NEXT:    s_or_b32 s3, s6, s4
; GFX10-NEXT:    s_lshl_b32 s1, s1, 16
; GFX10-NEXT:    s_lshl_b32 s2, s2, 24
; GFX10-NEXT:    s_or_b32 s1, s3, s1
; GFX10-NEXT:    s_lshl_b32 s3, s5, 24
; GFX10-NEXT:    s_or_b32 s0, s0, s2
; GFX10-NEXT:    s_or_b32 s1, s1, s3
; GFX10-NEXT:    v_mov_b32_e32 v3, s1
; GFX10-NEXT:    v_mov_b32_e32 v2, s0
; GFX10-NEXT:    global_store_dwordx2 v[0:1], v[2:3], off
; GFX10-NEXT:    s_endpgm
  %vec = load <8 x i8>, <8 x i8> addrspace(4)* %ptr
  %insert = insertelement <8 x i8> %vec, i8 %val, i32 %idx
  store <8 x i8> %insert, <8 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v8i8_s_s(<8 x i8> addrspace(1)* %ptr, i8 inreg %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_v_v8i8_s_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX9-NEXT:    s_mov_b32 s0, 8
; GFX9-NEXT:    s_mov_b32 s1, 16
; GFX9-NEXT:    s_movk_i32 s4, 0xff
; GFX9-NEXT:    s_lshr_b32 s5, s3, 2
; GFX9-NEXT:    s_and_b32 s3, s3, 3
; GFX9-NEXT:    s_and_b32 s2, s2, 0xff
; GFX9-NEXT:    s_lshl_b32 s3, s3, 3
; GFX9-NEXT:    s_lshl_b32 s2, s2, s3
; GFX9-NEXT:    s_lshl_b32 s3, 0xff, s3
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 1
; GFX9-NEXT:    s_not_b32 s3, s3
; GFX9-NEXT:    v_mov_b32_e32 v7, s2
; GFX9-NEXT:    v_mov_b32_e32 v5, 8
; GFX9-NEXT:    v_mov_b32_e32 v4, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v6, 16
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 24, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 24, v1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v10, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v12, s0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v11, s1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v13, s1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v0, s4, v10
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 24, v8
; GFX9-NEXT:    v_and_or_b32 v1, v1, s4, v12
; GFX9-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; GFX9-NEXT:    v_or3_b32 v0, v0, v11, v8
; GFX9-NEXT:    v_or3_b32 v1, v1, v13, v9
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v0, v1, vcc
; GFX9-NEXT:    v_and_or_b32 v7, v8, s3, v7
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], s5, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v7, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v7, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 24, v1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v9, v5, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v5, v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v10, v6, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v6, v6, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v0, v4, v9
; GFX9-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX9-NEXT:    v_and_or_b32 v1, v1, v4, v5
; GFX9-NEXT:    v_lshlrev_b32_e32 v4, 24, v8
; GFX9-NEXT:    v_or3_b32 v0, v0, v10, v7
; GFX9-NEXT:    v_or3_b32 v1, v1, v6, v4
; GFX9-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v8i8_s_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v4, 8
; GFX8-NEXT:    v_mov_b32_e32 v5, 16
; GFX8-NEXT:    s_and_b32 s1, s3, 3
; GFX8-NEXT:    s_lshr_b32 s0, s3, 2
; GFX8-NEXT:    s_and_b32 s2, s2, 0xff
; GFX8-NEXT:    s_lshl_b32 s1, s1, 3
; GFX8-NEXT:    s_lshl_b32 s2, s2, s1
; GFX8-NEXT:    s_lshl_b32 s1, 0xff, s1
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s0, 1
; GFX8-NEXT:    s_not_b32 s1, s1
; GFX8-NEXT:    v_mov_b32_e32 v6, 8
; GFX8-NEXT:    v_mov_b32_e32 v7, 16
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_sdwa v10, v4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v4, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 24, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 24, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v11, v5, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v5, v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v8, 24, v8
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 24, v9
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v11
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v5
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v8
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v0, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v4, s1, v4
; GFX8-NEXT:    v_or_b32_e32 v4, s2, v4
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], s0, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX8-NEXT:    v_lshlrev_b32_sdwa v8, v6, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v6, v6, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v9, v7, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v7, v7, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 24, v5
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v9
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v7
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v5
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v8i8_s_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_and_b32 s1, s3, 3
; GFX7-NEXT:    s_lshr_b32 s0, s3, 2
; GFX7-NEXT:    s_and_b32 s2, s2, 0xff
; GFX7-NEXT:    s_lshl_b32 s1, s1, 3
; GFX7-NEXT:    s_lshl_b32 s2, s2, s1
; GFX7-NEXT:    s_lshl_b32 s1, 0xff, s1
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s0, 1
; GFX7-NEXT:    s_not_b32 s1, s1
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v5, v0, 8, 8
; GFX7-NEXT:    v_bfe_u32 v7, v1, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v4, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_and_b32_e32 v6, 0xff, v1
; GFX7-NEXT:    v_bfe_u32 v1, v1, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 8, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v7, 8, v7
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX7-NEXT:    v_or_b32_e32 v5, v6, v7
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v4, v0
; GFX7-NEXT:    v_or_b32_e32 v1, v5, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX7-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v2, s1, v2
; GFX7-NEXT:    v_or_b32_e32 v2, s2, v2
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], s0, 0
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7-NEXT:    v_bfe_u32 v5, v0, 8, 8
; GFX7-NEXT:    v_bfe_u32 v7, v1, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v4, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_and_b32_e32 v6, 0xff, v1
; GFX7-NEXT:    v_bfe_u32 v1, v1, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 8, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v7, 8, v7
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX7-NEXT:    v_or_b32_e32 v5, v6, v7
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v4, v0
; GFX7-NEXT:    v_or_b32_e32 v1, v5, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX7-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v8i8_s_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX10-NEXT:    s_mov_b32 s0, 8
; GFX10-NEXT:    s_mov_b32 s1, 16
; GFX10-NEXT:    s_and_b32 s2, s2, 0xff
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v4, 24, v1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v5, s0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v6, s1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v7, s1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, v0, 0xff, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX10-NEXT:    v_and_or_b32 v1, v1, 0xff, v5
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 24, v4
; GFX10-NEXT:    s_lshr_b32 s0, s3, 2
; GFX10-NEXT:    s_and_b32 s1, s3, 3
; GFX10-NEXT:    v_or3_b32 v0, v0, v6, v2
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s0, 1
; GFX10-NEXT:    v_or3_b32 v1, v1, v7, v3
; GFX10-NEXT:    s_lshl_b32 s1, s1, 3
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, s0, 0
; GFX10-NEXT:    s_lshl_b32 s3, 0xff, s1
; GFX10-NEXT:    s_lshl_b32 s1, s2, s1
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc_lo
; GFX10-NEXT:    s_not_b32 s2, s3
; GFX10-NEXT:    v_mov_b32_e32 v3, 8
; GFX10-NEXT:    v_and_or_b32 v2, v2, s2, s1
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc_lo
; GFX10-NEXT:    v_mov_b32_e32 v2, 16
; GFX10-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v5, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v6, 24, v1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, v3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v7, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v8, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v2, 0xff, v0, v5
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX10-NEXT:    v_and_or_b32 v3, 0xff, v1, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 24, v6
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_or3_b32 v2, v2, v7, v4
; GFX10-NEXT:    v_or3_b32 v3, v3, v8, v5
; GFX10-NEXT:    global_store_dwordx2 v[0:1], v[2:3], off
; GFX10-NEXT:    s_endpgm
  %vec = load <8 x i8>, <8 x i8> addrspace(1 )* %ptr
  %insert = insertelement <8 x i8> %vec, i8 %val, i32 %idx
  store <8 x i8> %insert, <8 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v8i8_v_s(<8 x i8> addrspace(4)* inreg %ptr, i8 %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_s_v8i8_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX9-NEXT:    s_mov_b32 s2, 8
; GFX9-NEXT:    s_mov_b32 s3, 16
; GFX9-NEXT:    v_mov_b32_e32 v2, 0xff
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_bfe_u32 s8, s0, 0x80008
; GFX9-NEXT:    s_lshr_b32 s5, s0, 24
; GFX9-NEXT:    s_and_b32 s7, s0, 0xff
; GFX9-NEXT:    s_lshl_b32 s8, s8, 8
; GFX9-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX9-NEXT:    s_or_b32 s7, s7, s8
; GFX9-NEXT:    s_lshl_b32 s0, s0, 16
; GFX9-NEXT:    s_or_b32 s0, s7, s0
; GFX9-NEXT:    s_lshl_b32 s5, s5, 24
; GFX9-NEXT:    s_bfe_u32 s7, s1, 0x80008
; GFX9-NEXT:    s_lshr_b32 s6, s1, 24
; GFX9-NEXT:    s_or_b32 s0, s0, s5
; GFX9-NEXT:    s_and_b32 s5, s1, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s7, 8
; GFX9-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX9-NEXT:    s_or_b32 s5, s5, s7
; GFX9-NEXT:    s_lshl_b32 s1, s1, 16
; GFX9-NEXT:    s_or_b32 s1, s5, s1
; GFX9-NEXT:    s_lshl_b32 s5, s6, 24
; GFX9-NEXT:    s_or_b32 s1, s1, s5
; GFX9-NEXT:    s_lshr_b32 s5, s4, 2
; GFX9-NEXT:    s_cmp_eq_u32 s5, 1
; GFX9-NEXT:    s_cselect_b32 s6, s1, s0
; GFX9-NEXT:    s_and_b32 s4, s4, 3
; GFX9-NEXT:    s_lshl_b32 s4, s4, 3
; GFX9-NEXT:    s_lshl_b32 s7, 0xff, s4
; GFX9-NEXT:    s_andn2_b32 s6, s6, s7
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    v_lshl_or_b32 v3, v0, s4, v1
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v5, s2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_and_or_b32 v5, v0, v2, v5
; GFX9-NEXT:    v_lshlrev_b32_sdwa v0, s3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 24, v1
; GFX9-NEXT:    v_or3_b32 v0, v5, v0, v3
; GFX9-NEXT:    v_lshlrev_b32_sdwa v3, s2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_and_or_b32 v5, v1, v2, v3
; GFX9-NEXT:    v_lshlrev_b32_sdwa v1, s3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    v_or3_b32 v1, v5, v1, v4
; GFX9-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v8i8_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX8-NEXT:    v_mov_b32_e32 v4, 8
; GFX8-NEXT:    v_mov_b32_e32 v6, 16
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_bfe_u32 s6, s0, 0x80008
; GFX8-NEXT:    s_lshr_b32 s2, s0, 24
; GFX8-NEXT:    s_and_b32 s5, s0, 0xff
; GFX8-NEXT:    s_lshl_b32 s6, s6, 8
; GFX8-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX8-NEXT:    s_or_b32 s5, s5, s6
; GFX8-NEXT:    s_lshl_b32 s0, s0, 16
; GFX8-NEXT:    s_or_b32 s0, s5, s0
; GFX8-NEXT:    s_lshl_b32 s2, s2, 24
; GFX8-NEXT:    s_bfe_u32 s5, s1, 0x80008
; GFX8-NEXT:    s_lshr_b32 s3, s1, 24
; GFX8-NEXT:    s_or_b32 s0, s0, s2
; GFX8-NEXT:    s_and_b32 s2, s1, 0xff
; GFX8-NEXT:    s_lshl_b32 s5, s5, 8
; GFX8-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX8-NEXT:    s_or_b32 s2, s2, s5
; GFX8-NEXT:    s_lshl_b32 s1, s1, 16
; GFX8-NEXT:    s_or_b32 s1, s2, s1
; GFX8-NEXT:    s_lshl_b32 s2, s3, 24
; GFX8-NEXT:    s_or_b32 s1, s1, s2
; GFX8-NEXT:    s_lshr_b32 s2, s4, 2
; GFX8-NEXT:    s_cmp_eq_u32 s2, 1
; GFX8-NEXT:    s_cselect_b32 s3, s1, s0
; GFX8-NEXT:    s_and_b32 s4, s4, 3
; GFX8-NEXT:    s_lshl_b32 s4, s4, 3
; GFX8-NEXT:    v_mov_b32_e32 v1, s4
; GFX8-NEXT:    s_lshl_b32 s4, 0xff, s4
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    s_andn2_b32 s3, s3, s4
; GFX8-NEXT:    v_or_b32_e32 v2, s3, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v5, v4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX8-NEXT:    v_or_b32_sdwa v5, v0, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v6, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_e32 v0, v5, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX8-NEXT:    v_or_b32_sdwa v2, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v6, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 24, v3
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v8i8_v_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_bfe_u32 s6, s0, 0x80008
; GFX7-NEXT:    s_lshr_b32 s2, s0, 24
; GFX7-NEXT:    s_and_b32 s5, s0, 0xff
; GFX7-NEXT:    s_lshl_b32 s6, s6, 8
; GFX7-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX7-NEXT:    s_or_b32 s5, s5, s6
; GFX7-NEXT:    s_lshl_b32 s0, s0, 16
; GFX7-NEXT:    s_or_b32 s0, s5, s0
; GFX7-NEXT:    s_lshl_b32 s2, s2, 24
; GFX7-NEXT:    s_bfe_u32 s5, s1, 0x80008
; GFX7-NEXT:    s_lshr_b32 s3, s1, 24
; GFX7-NEXT:    s_or_b32 s0, s0, s2
; GFX7-NEXT:    s_and_b32 s2, s1, 0xff
; GFX7-NEXT:    s_lshl_b32 s5, s5, 8
; GFX7-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX7-NEXT:    s_or_b32 s2, s2, s5
; GFX7-NEXT:    s_lshl_b32 s1, s1, 16
; GFX7-NEXT:    s_or_b32 s1, s2, s1
; GFX7-NEXT:    s_lshl_b32 s2, s3, 24
; GFX7-NEXT:    s_or_b32 s1, s1, s2
; GFX7-NEXT:    s_lshr_b32 s2, s4, 2
; GFX7-NEXT:    s_cmp_eq_u32 s2, 1
; GFX7-NEXT:    s_cselect_b32 s3, s1, s0
; GFX7-NEXT:    s_and_b32 s4, s4, 3
; GFX7-NEXT:    s_lshl_b32 s4, s4, 3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, s4, v0
; GFX7-NEXT:    s_lshl_b32 s4, 0xff, s4
; GFX7-NEXT:    s_andn2_b32 s3, s3, s4
; GFX7-NEXT:    v_or_b32_e32 v2, s3, v0
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 0
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s2, 1
; GFX7-NEXT:    v_bfe_u32 v5, v0, 8, 8
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v4, 0xff, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 8, v5
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v4, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX7-NEXT:    v_bfe_u32 v4, v1, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; GFX7-NEXT:    v_bfe_u32 v1, v1, 16, 8
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 24, v3
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v8i8_v_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX10-NEXT:    s_lshr_b32 s2, s4, 2
; GFX10-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s2, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_bfe_u32 s7, s0, 0x80008
; GFX10-NEXT:    s_bfe_u32 s9, s1, 0x80008
; GFX10-NEXT:    s_lshr_b32 s3, s0, 24
; GFX10-NEXT:    s_lshr_b32 s5, s1, 24
; GFX10-NEXT:    s_and_b32 s6, s0, 0xff
; GFX10-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX10-NEXT:    s_and_b32 s8, s1, 0xff
; GFX10-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX10-NEXT:    s_lshl_b32 s7, s7, 8
; GFX10-NEXT:    s_lshl_b32 s9, s9, 8
; GFX10-NEXT:    s_lshl_b32 s0, s0, 16
; GFX10-NEXT:    s_lshl_b32 s1, s1, 16
; GFX10-NEXT:    s_or_b32 s6, s6, s7
; GFX10-NEXT:    s_or_b32 s7, s8, s9
; GFX10-NEXT:    s_lshl_b32 s3, s3, 24
; GFX10-NEXT:    s_lshl_b32 s5, s5, 24
; GFX10-NEXT:    s_or_b32 s0, s6, s0
; GFX10-NEXT:    s_or_b32 s1, s7, s1
; GFX10-NEXT:    s_or_b32 s0, s0, s3
; GFX10-NEXT:    s_or_b32 s1, s1, s5
; GFX10-NEXT:    s_cmp_eq_u32 s2, 1
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    s_cselect_b32 s3, s1, s0
; GFX10-NEXT:    s_and_b32 s4, s4, 3
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    s_lshl_b32 s4, s4, 3
; GFX10-NEXT:    s_mov_b32 s0, 8
; GFX10-NEXT:    s_lshl_b32 s5, 0xff, s4
; GFX10-NEXT:    s_mov_b32 s1, 16
; GFX10-NEXT:    s_andn2_b32 s3, s3, s5
; GFX10-NEXT:    v_lshl_or_b32 v2, v2, s4, s3
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s2, 1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc_lo
; GFX10-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v6, s1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v3, 0xff, v0, v3
; GFX10-NEXT:    v_lshrrev_b32_e32 v4, 24, v1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v5, s0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v7, s1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX10-NEXT:    v_and_or_b32 v5, 0xff, v1, v5
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_or3_b32 v2, v3, v6, v2
; GFX10-NEXT:    v_or3_b32 v3, v5, v7, v4
; GFX10-NEXT:    global_store_dwordx2 v[0:1], v[2:3], off
; GFX10-NEXT:    s_endpgm
  %vec = load <8 x i8>, <8 x i8> addrspace(4)* %ptr
  %insert = insertelement <8 x i8> %vec, i8 %val, i32 %idx
  store <8 x i8> %insert, <8 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v8i8_s_v(<8 x i8> addrspace(4)* inreg %ptr, i8 inreg %val, i32 %idx) {
; GFX9-LABEL: insertelement_s_v8i8_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 2, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX9-NEXT:    s_movk_i32 s7, 0xff
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_bfe_u32 s9, s0, 0x80008
; GFX9-NEXT:    s_lshr_b32 s5, s0, 24
; GFX9-NEXT:    s_and_b32 s8, s0, 0xff
; GFX9-NEXT:    s_lshl_b32 s9, s9, 8
; GFX9-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX9-NEXT:    s_or_b32 s8, s8, s9
; GFX9-NEXT:    s_lshl_b32 s0, s0, 16
; GFX9-NEXT:    s_or_b32 s0, s8, s0
; GFX9-NEXT:    s_lshl_b32 s5, s5, 24
; GFX9-NEXT:    s_bfe_u32 s8, s1, 0x80008
; GFX9-NEXT:    s_lshr_b32 s6, s1, 24
; GFX9-NEXT:    s_or_b32 s0, s0, s5
; GFX9-NEXT:    s_and_b32 s5, s1, 0xff
; GFX9-NEXT:    s_lshl_b32 s8, s8, 8
; GFX9-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX9-NEXT:    s_or_b32 s5, s5, s8
; GFX9-NEXT:    s_lshl_b32 s1, s1, 16
; GFX9-NEXT:    s_or_b32 s1, s5, s1
; GFX9-NEXT:    s_lshl_b32 s5, s6, 24
; GFX9-NEXT:    s_or_b32 s1, s1, s5
; GFX9-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-NEXT:    v_mov_b32_e32 v3, s1
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX9-NEXT:    s_and_b32 s4, s4, 0xff
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX9-NEXT:    v_lshlrev_b32_e64 v3, v0, s4
; GFX9-NEXT:    v_lshlrev_b32_e64 v0, v0, s7
; GFX9-NEXT:    v_xor_b32_e32 v0, -1, v0
; GFX9-NEXT:    v_and_or_b32 v3, v1, v0, v3
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v2
; GFX9-NEXT:    s_mov_b32 s2, 8
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v3, s[0:1]
; GFX9-NEXT:    s_mov_b32 s3, 16
; GFX9-NEXT:    v_mov_b32_e32 v4, 0xff
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v5, s2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX9-NEXT:    v_and_or_b32 v5, v0, v4, v5
; GFX9-NEXT:    v_lshlrev_b32_sdwa v0, s3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX9-NEXT:    v_or3_b32 v0, v5, v0, v2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, s2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_and_or_b32 v4, v1, v4, v2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v1, s3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_e32 v5, 24, v3
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    v_or3_b32 v1, v4, v1, v5
; GFX9-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v8i8_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX8-NEXT:    s_movk_i32 s5, 0xff
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_bfe_u32 s7, s0, 0x80008
; GFX8-NEXT:    s_lshr_b32 s2, s0, 24
; GFX8-NEXT:    s_and_b32 s6, s0, 0xff
; GFX8-NEXT:    s_lshl_b32 s7, s7, 8
; GFX8-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX8-NEXT:    s_or_b32 s6, s6, s7
; GFX8-NEXT:    s_lshl_b32 s0, s0, 16
; GFX8-NEXT:    s_or_b32 s0, s6, s0
; GFX8-NEXT:    s_lshl_b32 s2, s2, 24
; GFX8-NEXT:    s_bfe_u32 s6, s1, 0x80008
; GFX8-NEXT:    s_lshr_b32 s3, s1, 24
; GFX8-NEXT:    s_or_b32 s0, s0, s2
; GFX8-NEXT:    s_and_b32 s2, s1, 0xff
; GFX8-NEXT:    s_lshl_b32 s6, s6, 8
; GFX8-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX8-NEXT:    s_or_b32 s2, s2, s6
; GFX8-NEXT:    s_lshl_b32 s1, s1, 16
; GFX8-NEXT:    s_or_b32 s1, s2, s1
; GFX8-NEXT:    s_lshl_b32 s2, s3, 24
; GFX8-NEXT:    s_or_b32 s1, s1, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX8-NEXT:    s_and_b32 s2, s4, 0xff
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX8-NEXT:    v_lshlrev_b32_e64 v3, v0, s2
; GFX8-NEXT:    v_lshlrev_b32_e64 v0, v0, s5
; GFX8-NEXT:    v_xor_b32_e32 v0, -1, v0
; GFX8-NEXT:    v_and_b32_e32 v0, v1, v0
; GFX8-NEXT:    v_or_b32_e32 v3, v0, v3
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v2
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v3, s[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v4, 8
; GFX8-NEXT:    v_lshlrev_b32_sdwa v5, v4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_mov_b32_e32 v6, 16
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX8-NEXT:    v_or_b32_sdwa v5, v0, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v6, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX8-NEXT:    v_or_b32_e32 v0, v5, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX8-NEXT:    v_or_b32_sdwa v2, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v6, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 24, v3
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v8i8_s_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 2, v0
; GFX7-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_bfe_u32 s6, s0, 0x80008
; GFX7-NEXT:    s_lshr_b32 s2, s0, 24
; GFX7-NEXT:    s_and_b32 s5, s0, 0xff
; GFX7-NEXT:    s_lshl_b32 s6, s6, 8
; GFX7-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX7-NEXT:    s_or_b32 s5, s5, s6
; GFX7-NEXT:    s_lshl_b32 s0, s0, 16
; GFX7-NEXT:    s_or_b32 s0, s5, s0
; GFX7-NEXT:    s_lshl_b32 s2, s2, 24
; GFX7-NEXT:    s_bfe_u32 s5, s1, 0x80008
; GFX7-NEXT:    s_lshr_b32 s3, s1, 24
; GFX7-NEXT:    s_or_b32 s0, s0, s2
; GFX7-NEXT:    s_and_b32 s2, s1, 0xff
; GFX7-NEXT:    s_lshl_b32 s5, s5, 8
; GFX7-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX7-NEXT:    s_or_b32 s2, s2, s5
; GFX7-NEXT:    s_lshl_b32 s1, s1, 16
; GFX7-NEXT:    s_or_b32 s1, s2, s1
; GFX7-NEXT:    s_lshl_b32 s2, s3, 24
; GFX7-NEXT:    s_or_b32 s1, s1, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s0
; GFX7-NEXT:    v_mov_b32_e32 v3, s1
; GFX7-NEXT:    s_and_b32 s2, s4, 0xff
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX7-NEXT:    v_lshl_b32_e32 v3, s2, v0
; GFX7-NEXT:    v_lshl_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    v_xor_b32_e32 v0, -1, v0
; GFX7-NEXT:    v_and_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_or_b32_e32 v3, v0, v3
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v2
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v3, s[0:1]
; GFX7-NEXT:    v_bfe_u32 v5, v0, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v4, 0xff, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 8, v5
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX7-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v4, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX7-NEXT:    v_bfe_u32 v4, v1, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; GFX7-NEXT:    v_bfe_u32 v1, v1, 16, 8
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 24, v3
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v8i8_s_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX10-NEXT:    v_and_b32_e32 v1, 3, v0
; GFX10-NEXT:    s_and_b32 s2, s4, 0xff
; GFX10-NEXT:    v_lshrrev_b32_e32 v2, 2, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v2
; GFX10-NEXT:    v_lshlrev_b32_e64 v3, v1, s2
; GFX10-NEXT:    v_lshlrev_b32_e64 v0, v1, 0xff
; GFX10-NEXT:    v_xor_b32_e32 v4, -1, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_bfe_u32 s7, s1, 0x80008
; GFX10-NEXT:    s_lshr_b32 s3, s1, 24
; GFX10-NEXT:    s_and_b32 s6, s1, 0xff
; GFX10-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX10-NEXT:    s_lshl_b32 s7, s7, 8
; GFX10-NEXT:    s_lshl_b32 s1, s1, 16
; GFX10-NEXT:    s_or_b32 s6, s6, s7
; GFX10-NEXT:    s_bfe_u32 s5, s0, 0x80008
; GFX10-NEXT:    s_lshl_b32 s3, s3, 24
; GFX10-NEXT:    s_or_b32 s1, s6, s1
; GFX10-NEXT:    s_lshr_b32 s2, s0, 24
; GFX10-NEXT:    s_and_b32 s4, s0, 0xff
; GFX10-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX10-NEXT:    s_lshl_b32 s5, s5, 8
; GFX10-NEXT:    s_or_b32 s1, s1, s3
; GFX10-NEXT:    s_lshl_b32 s0, s0, 16
; GFX10-NEXT:    s_or_b32 s3, s4, s5
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    s_lshl_b32 s2, s2, 24
; GFX10-NEXT:    s_or_b32 s0, s3, s0
; GFX10-NEXT:    s_or_b32 s0, s0, s2
; GFX10-NEXT:    v_cndmask_b32_e32 v5, s0, v1, vcc_lo
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, 0, v2
; GFX10-NEXT:    s_mov_b32 s1, 16
; GFX10-NEXT:    v_and_or_b32 v3, v5, v4, v3
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v3, s0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX10-NEXT:    s_mov_b32 s0, 8
; GFX10-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v4, 24, v1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v5, s0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v6, s1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v7, s1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v3, 0xff, v0, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX10-NEXT:    v_and_or_b32 v5, 0xff, v1, v5
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_or3_b32 v2, v3, v6, v2
; GFX10-NEXT:    v_or3_b32 v3, v5, v7, v4
; GFX10-NEXT:    global_store_dwordx2 v[0:1], v[2:3], off
; GFX10-NEXT:    s_endpgm
  %vec = load <8 x i8>, <8 x i8> addrspace(4)* %ptr
  %insert = insertelement <8 x i8> %vec, i8 %val, i32 %idx
  store <8 x i8> %insert, <8 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v8i8_v_v(<8 x i8> addrspace(4)* inreg %ptr, i8 %val, i32 %idx) {
; GFX9-LABEL: insertelement_s_v8i8_v_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 2, v1
; GFX9-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX9-NEXT:    s_movk_i32 s6, 0xff
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_bfe_u32 s8, s0, 0x80008
; GFX9-NEXT:    s_lshr_b32 s4, s0, 24
; GFX9-NEXT:    s_and_b32 s7, s0, 0xff
; GFX9-NEXT:    s_lshl_b32 s8, s8, 8
; GFX9-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX9-NEXT:    s_or_b32 s7, s7, s8
; GFX9-NEXT:    s_lshl_b32 s0, s0, 16
; GFX9-NEXT:    s_or_b32 s0, s7, s0
; GFX9-NEXT:    s_lshl_b32 s4, s4, 24
; GFX9-NEXT:    s_bfe_u32 s7, s1, 0x80008
; GFX9-NEXT:    s_lshr_b32 s5, s1, 24
; GFX9-NEXT:    s_or_b32 s0, s0, s4
; GFX9-NEXT:    s_and_b32 s4, s1, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s7, 8
; GFX9-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX9-NEXT:    s_or_b32 s4, s4, s7
; GFX9-NEXT:    s_lshl_b32 s1, s1, 16
; GFX9-NEXT:    s_or_b32 s1, s4, s1
; GFX9-NEXT:    s_lshl_b32 s4, s5, 24
; GFX9-NEXT:    s_or_b32 s1, s1, s4
; GFX9-NEXT:    v_mov_b32_e32 v3, s0
; GFX9-NEXT:    v_mov_b32_e32 v4, s1
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_e64 v1, v1, s6
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GFX9-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX9-NEXT:    v_and_or_b32 v3, v3, v1, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v2
; GFX9-NEXT:    s_mov_b32 s2, 8
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v3, s[0:1]
; GFX9-NEXT:    s_mov_b32 s3, 16
; GFX9-NEXT:    v_mov_b32_e32 v4, 0xff
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v5, s2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX9-NEXT:    v_and_or_b32 v5, v0, v4, v5
; GFX9-NEXT:    v_lshlrev_b32_sdwa v0, s3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX9-NEXT:    v_or3_b32 v0, v5, v0, v2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, s2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_and_or_b32 v4, v1, v4, v2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v1, s3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_e32 v5, 24, v3
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    v_or3_b32 v1, v4, v1, v5
; GFX9-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v8i8_v_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 2, v1
; GFX8-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX8-NEXT:    s_movk_i32 s4, 0xff
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_bfe_u32 s6, s0, 0x80008
; GFX8-NEXT:    s_lshr_b32 s2, s0, 24
; GFX8-NEXT:    s_and_b32 s5, s0, 0xff
; GFX8-NEXT:    s_lshl_b32 s6, s6, 8
; GFX8-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX8-NEXT:    s_or_b32 s5, s5, s6
; GFX8-NEXT:    s_lshl_b32 s0, s0, 16
; GFX8-NEXT:    s_or_b32 s0, s5, s0
; GFX8-NEXT:    s_lshl_b32 s2, s2, 24
; GFX8-NEXT:    s_bfe_u32 s5, s1, 0x80008
; GFX8-NEXT:    s_lshr_b32 s3, s1, 24
; GFX8-NEXT:    s_or_b32 s0, s0, s2
; GFX8-NEXT:    s_and_b32 s2, s1, 0xff
; GFX8-NEXT:    s_lshl_b32 s5, s5, 8
; GFX8-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX8-NEXT:    s_or_b32 s2, s2, s5
; GFX8-NEXT:    s_lshl_b32 s1, s1, 16
; GFX8-NEXT:    s_or_b32 s1, s2, s1
; GFX8-NEXT:    s_lshl_b32 s2, s3, 24
; GFX8-NEXT:    s_or_b32 s1, s1, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s0
; GFX8-NEXT:    v_mov_b32_e32 v4, s1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_e64 v1, v1, s4
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GFX8-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX8-NEXT:    v_and_b32_e32 v1, v3, v1
; GFX8-NEXT:    v_or_b32_e32 v3, v1, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v2
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v3, s[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v4, 8
; GFX8-NEXT:    v_lshlrev_b32_sdwa v5, v4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_mov_b32_e32 v6, 16
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX8-NEXT:    v_or_b32_sdwa v5, v0, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v6, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX8-NEXT:    v_or_b32_e32 v0, v5, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX8-NEXT:    v_or_b32_sdwa v2, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v6, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 24, v3
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v8i8_v_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 2, v1
; GFX7-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_bfe_u32 s5, s0, 0x80008
; GFX7-NEXT:    s_lshr_b32 s2, s0, 24
; GFX7-NEXT:    s_and_b32 s4, s0, 0xff
; GFX7-NEXT:    s_lshl_b32 s5, s5, 8
; GFX7-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX7-NEXT:    s_or_b32 s4, s4, s5
; GFX7-NEXT:    s_lshl_b32 s0, s0, 16
; GFX7-NEXT:    s_or_b32 s0, s4, s0
; GFX7-NEXT:    s_lshl_b32 s2, s2, 24
; GFX7-NEXT:    s_bfe_u32 s4, s1, 0x80008
; GFX7-NEXT:    s_lshr_b32 s3, s1, 24
; GFX7-NEXT:    s_or_b32 s0, s0, s2
; GFX7-NEXT:    s_and_b32 s2, s1, 0xff
; GFX7-NEXT:    s_lshl_b32 s4, s4, 8
; GFX7-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX7-NEXT:    s_or_b32 s2, s2, s4
; GFX7-NEXT:    s_lshl_b32 s1, s1, 16
; GFX7-NEXT:    s_or_b32 s1, s2, s1
; GFX7-NEXT:    s_lshl_b32 s2, s3, 24
; GFX7-NEXT:    s_or_b32 s1, s1, s2
; GFX7-NEXT:    v_mov_b32_e32 v3, s0
; GFX7-NEXT:    v_mov_b32_e32 v4, s1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_lshl_b32_e32 v1, 0xff, v1
; GFX7-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GFX7-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX7-NEXT:    v_and_b32_e32 v1, v3, v1
; GFX7-NEXT:    v_or_b32_e32 v3, v1, v0
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v2
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v3, s[0:1]
; GFX7-NEXT:    v_bfe_u32 v5, v0, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v4, 0xff, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 8, v5
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX7-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v4, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX7-NEXT:    v_bfe_u32 v4, v1, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; GFX7-NEXT:    v_bfe_u32 v1, v1, 16, 8
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 24, v3
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v8i8_v_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX10-NEXT:    v_and_b32_e32 v2, 3, v1
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 2, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 3, v2
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v3
; GFX10-NEXT:    v_lshlrev_b32_sdwa v4, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX10-NEXT:    v_lshlrev_b32_e64 v0, v2, 0xff
; GFX10-NEXT:    v_xor_b32_e32 v2, -1, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_bfe_u32 s7, s1, 0x80008
; GFX10-NEXT:    s_lshr_b32 s3, s1, 24
; GFX10-NEXT:    s_and_b32 s6, s1, 0xff
; GFX10-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX10-NEXT:    s_lshl_b32 s7, s7, 8
; GFX10-NEXT:    s_lshl_b32 s1, s1, 16
; GFX10-NEXT:    s_or_b32 s6, s6, s7
; GFX10-NEXT:    s_bfe_u32 s5, s0, 0x80008
; GFX10-NEXT:    s_lshl_b32 s3, s3, 24
; GFX10-NEXT:    s_or_b32 s1, s6, s1
; GFX10-NEXT:    s_lshr_b32 s2, s0, 24
; GFX10-NEXT:    s_and_b32 s4, s0, 0xff
; GFX10-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX10-NEXT:    s_lshl_b32 s5, s5, 8
; GFX10-NEXT:    s_or_b32 s1, s1, s3
; GFX10-NEXT:    s_lshl_b32 s0, s0, 16
; GFX10-NEXT:    s_or_b32 s3, s4, s5
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    s_lshl_b32 s2, s2, 24
; GFX10-NEXT:    s_or_b32 s0, s3, s0
; GFX10-NEXT:    s_or_b32 s0, s0, s2
; GFX10-NEXT:    v_cndmask_b32_e32 v5, s0, v1, vcc_lo
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, 0, v3
; GFX10-NEXT:    s_mov_b32 s1, 16
; GFX10-NEXT:    v_and_or_b32 v2, v5, v2, v4
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc_lo
; GFX10-NEXT:    s_mov_b32 s0, 8
; GFX10-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v4, 24, v1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v5, s0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v6, s1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v7, s1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v3, 0xff, v0, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX10-NEXT:    v_and_or_b32 v5, 0xff, v1, v5
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_or3_b32 v2, v3, v6, v2
; GFX10-NEXT:    v_or3_b32 v3, v5, v7, v4
; GFX10-NEXT:    global_store_dwordx2 v[0:1], v[2:3], off
; GFX10-NEXT:    s_endpgm
  %vec = load <8 x i8>, <8 x i8> addrspace(4)* %ptr
  %insert = insertelement <8 x i8> %vec, i8 %val, i32 %idx
  store <8 x i8> %insert, <8 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v8i8_s_v(<8 x i8> addrspace(1)* %ptr, i8 inreg %val, i32 %idx) {
; GFX9-LABEL: insertelement_v_v8i8_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX9-NEXT:    s_mov_b32 s0, 8
; GFX9-NEXT:    s_mov_b32 s1, 16
; GFX9-NEXT:    s_movk_i32 s3, 0xff
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 2, v2
; GFX9-NEXT:    v_and_b32_e32 v2, 3, v2
; GFX9-NEXT:    v_mov_b32_e32 v5, 0xff
; GFX9-NEXT:    s_and_b32 s2, s2, 0xff
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 3, v2
; GFX9-NEXT:    v_lshlrev_b32_e64 v9, v2, s2
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, v2, v5
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v8
; GFX9-NEXT:    v_xor_b32_e32 v2, -1, v2
; GFX9-NEXT:    v_mov_b32_e32 v6, 8
; GFX9-NEXT:    v_mov_b32_e32 v7, 16
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 24, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v11, 24, v1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v12, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v14, s0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v13, s1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v15, s1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v0, s3, v12
; GFX9-NEXT:    v_lshlrev_b32_e32 v10, 24, v10
; GFX9-NEXT:    v_and_or_b32 v1, v1, s3, v14
; GFX9-NEXT:    v_lshlrev_b32_e32 v11, 24, v11
; GFX9-NEXT:    v_or3_b32 v0, v0, v13, v10
; GFX9-NEXT:    v_or3_b32 v1, v1, v15, v11
; GFX9-NEXT:    v_cndmask_b32_e32 v10, v0, v1, vcc
; GFX9-NEXT:    v_and_or_b32 v2, v10, v2, v9
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v8
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 24, v1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v9, v6, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v6, v6, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v10, v7, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v7, v7, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v0, v5, v9
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX9-NEXT:    v_and_or_b32 v1, v1, v5, v6
; GFX9-NEXT:    v_lshlrev_b32_e32 v5, 24, v8
; GFX9-NEXT:    v_or3_b32 v0, v0, v10, v2
; GFX9-NEXT:    v_or3_b32 v1, v1, v7, v5
; GFX9-NEXT:    global_store_dwordx2 v[3:4], v[0:1], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v8i8_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v6, 8
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 2, v2
; GFX8-NEXT:    v_and_b32_e32 v2, 3, v2
; GFX8-NEXT:    v_mov_b32_e32 v5, 0xff
; GFX8-NEXT:    v_mov_b32_e32 v7, 16
; GFX8-NEXT:    s_and_b32 s0, s2, 0xff
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 3, v2
; GFX8-NEXT:    v_lshlrev_b32_e64 v11, v2, s0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, v2, v5
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v10
; GFX8-NEXT:    v_xor_b32_e32 v2, -1, v2
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v10
; GFX8-NEXT:    v_mov_b32_e32 v8, 8
; GFX8-NEXT:    v_mov_b32_e32 v9, 16
; GFX8-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_sdwa v13, v6, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v6, v6, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 24, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v12, 24, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v14, v7, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v7, v7, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 24, v5
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 24, v12
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v14
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v7
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v5
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v6
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v0, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v2, v5, v2
; GFX8-NEXT:    v_or_b32_e32 v2, v2, v11
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX8-NEXT:    v_lshlrev_b32_sdwa v6, v8, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v8, v8, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v7, v9, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v9, v9, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 24, v5
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v7
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v9
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v5
; GFX8-NEXT:    flat_store_dwordx2 v[3:4], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v8i8_s_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 2, v2
; GFX7-NEXT:    v_and_b32_e32 v2, 3, v2
; GFX7-NEXT:    s_and_b32 s0, s2, 0xff
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 3, v2
; GFX7-NEXT:    v_lshl_b32_e32 v4, s0, v2
; GFX7-NEXT:    v_lshl_b32_e32 v2, 0xff, v2
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v3
; GFX7-NEXT:    v_xor_b32_e32 v2, -1, v2
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v3
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v8, v0, 8, 8
; GFX7-NEXT:    v_bfe_u32 v10, v1, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 24, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v7, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_and_b32_e32 v9, 0xff, v1
; GFX7-NEXT:    v_bfe_u32 v1, v1, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v8, 8, v8
; GFX7-NEXT:    v_lshlrev_b32_e32 v10, 8, v10
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_or_b32_e32 v7, v7, v8
; GFX7-NEXT:    v_or_b32_e32 v8, v9, v10
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 24, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX7-NEXT:    v_or_b32_e32 v0, v7, v0
; GFX7-NEXT:    v_or_b32_e32 v1, v8, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v5
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v6
; GFX7-NEXT:    v_cndmask_b32_e32 v5, v0, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v2, v5, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v4
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7-NEXT:    v_bfe_u32 v5, v0, 8, 8
; GFX7-NEXT:    v_bfe_u32 v7, v1, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v4, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_and_b32_e32 v6, 0xff, v1
; GFX7-NEXT:    v_bfe_u32 v1, v1, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 8, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v7, 8, v7
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX7-NEXT:    v_or_b32_e32 v5, v6, v7
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v4, v0
; GFX7-NEXT:    v_or_b32_e32 v1, v5, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX7-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v8i8_s_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX10-NEXT:    s_mov_b32 s0, 8
; GFX10-NEXT:    v_and_b32_e32 v3, 3, v2
; GFX10-NEXT:    s_mov_b32 s1, 16
; GFX10-NEXT:    v_lshrrev_b32_e32 v2, 2, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v2
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v5, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v6, 24, v1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v7, s0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v8, s1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v9, s1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, v0, 0xff, v5
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX10-NEXT:    v_and_or_b32 v1, v1, 0xff, v7
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 24, v6
; GFX10-NEXT:    v_lshlrev_b32_e64 v6, v3, 0xff
; GFX10-NEXT:    s_and_b32 s0, s2, 0xff
; GFX10-NEXT:    v_or3_b32 v0, v0, v8, v4
; GFX10-NEXT:    v_lshlrev_b32_e64 v3, v3, s0
; GFX10-NEXT:    v_or3_b32 v1, v1, v9, v5
; GFX10-NEXT:    v_xor_b32_e32 v4, -1, v6
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, 0, v2
; GFX10-NEXT:    v_mov_b32_e32 v2, 8
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v0, v1, vcc_lo
; GFX10-NEXT:    v_and_or_b32 v3, v5, v4, v3
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v3, s0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX10-NEXT:    v_mov_b32_e32 v3, 16
; GFX10-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v5, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v6, 24, v1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v7, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, v3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v5, 0xff, v0, v5
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX10-NEXT:    v_and_or_b32 v8, 0xff, v1, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_or3_b32 v2, v5, v7, v4
; GFX10-NEXT:    v_or3_b32 v3, v8, v3, v6
; GFX10-NEXT:    global_store_dwordx2 v[0:1], v[2:3], off
; GFX10-NEXT:    s_endpgm
  %vec = load <8 x i8>, <8 x i8> addrspace(1)* %ptr
  %insert = insertelement <8 x i8> %vec, i8 %val, i32 %idx
  store <8 x i8> %insert, <8 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v8i8_v_s(<8 x i8> addrspace(1)* %ptr, i8 %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_v_v8i8_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX9-NEXT:    s_mov_b32 s0, 8
; GFX9-NEXT:    s_mov_b32 s1, 16
; GFX9-NEXT:    s_movk_i32 s3, 0xff
; GFX9-NEXT:    s_lshr_b32 s4, s2, 2
; GFX9-NEXT:    s_and_b32 s2, s2, 3
; GFX9-NEXT:    s_lshl_b32 s2, s2, 3
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, s2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    s_lshl_b32 s2, 0xff, s2
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX9-NEXT:    s_not_b32 s2, s2
; GFX9-NEXT:    v_mov_b32_e32 v6, 8
; GFX9-NEXT:    v_mov_b32_e32 v5, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v7, 16
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 24, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 24, v1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v10, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v12, s0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v11, s1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v13, s1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v0, s3, v10
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 24, v8
; GFX9-NEXT:    v_and_or_b32 v1, v1, s3, v12
; GFX9-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; GFX9-NEXT:    v_or3_b32 v0, v0, v11, v8
; GFX9-NEXT:    v_or3_b32 v1, v1, v13, v9
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v0, v1, vcc
; GFX9-NEXT:    v_and_or_b32 v2, v8, s2, v2
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], s4, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 24, v1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v9, v6, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v6, v6, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v10, v7, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v7, v7, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v0, v5, v9
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX9-NEXT:    v_and_or_b32 v1, v1, v5, v6
; GFX9-NEXT:    v_lshlrev_b32_e32 v5, 24, v8
; GFX9-NEXT:    v_or3_b32 v0, v0, v10, v2
; GFX9-NEXT:    v_or3_b32 v1, v1, v7, v5
; GFX9-NEXT:    global_store_dwordx2 v[3:4], v[0:1], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v8i8_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX8-NEXT:    s_and_b32 s1, s2, 3
; GFX8-NEXT:    v_mov_b32_e32 v5, 8
; GFX8-NEXT:    s_lshl_b32 s1, s1, 3
; GFX8-NEXT:    v_mov_b32_e32 v6, 16
; GFX8-NEXT:    v_mov_b32_e32 v9, s1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v9, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    s_lshr_b32 s0, s2, 2
; GFX8-NEXT:    s_lshl_b32 s1, 0xff, s1
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s0, 1
; GFX8-NEXT:    s_not_b32 s1, s1
; GFX8-NEXT:    v_mov_b32_e32 v7, 8
; GFX8-NEXT:    v_mov_b32_e32 v8, 16
; GFX8-NEXT:    v_mov_b32_e32 v3, 0
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_sdwa v11, v5, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v5, v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 24, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 24, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v12, v6, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v6, v6, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 24, v10
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v12
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v6
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v9
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v0, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v5, s1, v5
; GFX8-NEXT:    v_or_b32_e32 v2, v5, v2
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], s0, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX8-NEXT:    v_lshlrev_b32_sdwa v6, v7, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v7, v7, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v9, v8, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v8, v8, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 24, v5
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v9
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v8
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v5
; GFX8-NEXT:    flat_store_dwordx2 v[3:4], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v8i8_v_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_and_b32 s1, s2, 3
; GFX7-NEXT:    s_lshr_b32 s0, s2, 2
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX7-NEXT:    s_lshl_b32 s1, s1, 3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, s1, v2
; GFX7-NEXT:    s_lshl_b32 s1, 0xff, s1
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s0, 1
; GFX7-NEXT:    s_not_b32 s1, s1
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v6, v0, 8, 8
; GFX7-NEXT:    v_bfe_u32 v8, v1, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v5, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_and_b32_e32 v7, 0xff, v1
; GFX7-NEXT:    v_bfe_u32 v1, v1, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v6, 8, v6
; GFX7-NEXT:    v_lshlrev_b32_e32 v8, 8, v8
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_or_b32_e32 v5, v5, v6
; GFX7-NEXT:    v_or_b32_e32 v6, v7, v8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX7-NEXT:    v_or_b32_e32 v0, v5, v0
; GFX7-NEXT:    v_or_b32_e32 v1, v6, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX7-NEXT:    v_cndmask_b32_e32 v3, v0, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v3, s1, v3
; GFX7-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], s0, 0
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7-NEXT:    v_bfe_u32 v5, v0, 8, 8
; GFX7-NEXT:    v_bfe_u32 v7, v1, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v4, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_and_b32_e32 v6, 0xff, v1
; GFX7-NEXT:    v_bfe_u32 v1, v1, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 8, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v7, 8, v7
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX7-NEXT:    v_or_b32_e32 v5, v6, v7
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v4, v0
; GFX7-NEXT:    v_or_b32_e32 v1, v5, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX7-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v8i8_v_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX10-NEXT:    s_mov_b32 s0, 8
; GFX10-NEXT:    s_mov_b32 s1, 16
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v4, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v6, s0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v7, s1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v8, s1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, v0, 0xff, v4
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; GFX10-NEXT:    v_and_or_b32 v1, v1, 0xff, v6
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 24, v5
; GFX10-NEXT:    s_lshr_b32 s1, s2, 2
; GFX10-NEXT:    s_and_b32 s0, s2, 3
; GFX10-NEXT:    v_or3_b32 v0, v0, v7, v3
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s1, 1
; GFX10-NEXT:    v_or3_b32 v1, v1, v8, v4
; GFX10-NEXT:    s_lshl_b32 s0, s0, 3
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, s0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX10-NEXT:    s_lshl_b32 s0, 0xff, s0
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v0, v1, vcc_lo
; GFX10-NEXT:    s_not_b32 s0, s0
; GFX10-NEXT:    v_and_or_b32 v2, v3, s0, v2
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, s1, 0
; GFX10-NEXT:    v_mov_b32_e32 v3, 8
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s0
; GFX10-NEXT:    v_mov_b32_e32 v2, 16
; GFX10-NEXT:    v_lshrrev_b32_e32 v6, 24, v1
; GFX10-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v5, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, v3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v7, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v8, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX10-NEXT:    v_and_or_b32 v2, 0xff, v0, v5
; GFX10-NEXT:    v_and_or_b32 v3, 0xff, v1, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 24, v6
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_or3_b32 v2, v2, v7, v4
; GFX10-NEXT:    v_or3_b32 v3, v3, v8, v5
; GFX10-NEXT:    global_store_dwordx2 v[0:1], v[2:3], off
; GFX10-NEXT:    s_endpgm
  %vec = load <8 x i8>, <8 x i8> addrspace(1)* %ptr
  %insert = insertelement <8 x i8> %vec, i8 %val, i32 %idx
  store <8 x i8> %insert, <8 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v8i8_v_v(<8 x i8> addrspace(1)* %ptr, i8 %val, i32 %idx) {
; GFX9-LABEL: insertelement_v_v8i8_v_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX9-NEXT:    s_mov_b32 s0, 8
; GFX9-NEXT:    s_mov_b32 s1, 16
; GFX9-NEXT:    s_movk_i32 s2, 0xff
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 2, v3
; GFX9-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX9-NEXT:    v_mov_b32_e32 v6, 0xff
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, v3, v6
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v9
; GFX9-NEXT:    v_xor_b32_e32 v3, -1, v3
; GFX9-NEXT:    v_mov_b32_e32 v7, 8
; GFX9-NEXT:    v_mov_b32_e32 v8, 16
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 24, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v11, 24, v1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v12, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v14, s0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v13, s1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v15, s1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v0, s2, v12
; GFX9-NEXT:    v_lshlrev_b32_e32 v10, 24, v10
; GFX9-NEXT:    v_and_or_b32 v1, v1, s2, v14
; GFX9-NEXT:    v_lshlrev_b32_e32 v11, 24, v11
; GFX9-NEXT:    v_or3_b32 v0, v0, v13, v10
; GFX9-NEXT:    v_or3_b32 v1, v1, v15, v11
; GFX9-NEXT:    v_cndmask_b32_e32 v10, v0, v1, vcc
; GFX9-NEXT:    v_and_or_b32 v2, v10, v3, v2
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v9
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v9, v7, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v7, v7, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v10, v8, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v8, v8, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v0, v6, v9
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX9-NEXT:    v_and_or_b32 v1, v1, v6, v7
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; GFX9-NEXT:    v_or3_b32 v0, v0, v10, v2
; GFX9-NEXT:    v_or3_b32 v1, v1, v8, v3
; GFX9-NEXT:    global_store_dwordx2 v[4:5], v[0:1], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v8i8_v_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v7, 8
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 2, v3
; GFX8-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_mov_b32_e32 v6, 0xff
; GFX8-NEXT:    v_mov_b32_e32 v8, 16
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, v3, v6
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v11
; GFX8-NEXT:    v_xor_b32_e32 v3, -1, v3
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v11
; GFX8-NEXT:    v_mov_b32_e32 v9, 8
; GFX8-NEXT:    v_mov_b32_e32 v10, 16
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_mov_b32_e32 v5, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_sdwa v13, v7, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v7, v7, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 24, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v12, 24, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v14, v8, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v8, v8, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX8-NEXT:    v_lshlrev_b32_e32 v7, 24, v12
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v14
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v8
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v6
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v7
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v0, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v3, v6, v3
; GFX8-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX8-NEXT:    v_lshlrev_b32_sdwa v6, v9, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v8, v9, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v7, v10, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v9, v10, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v7
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v9
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX8-NEXT:    flat_store_dwordx2 v[4:5], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v8i8_v_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 2, v3
; GFX7-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v3, v2
; GFX7-NEXT:    v_lshl_b32_e32 v3, 0xff, v3
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v4
; GFX7-NEXT:    v_xor_b32_e32 v3, -1, v3
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 0, v4
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v8, v0, 8, 8
; GFX7-NEXT:    v_bfe_u32 v10, v1, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 24, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v7, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_and_b32_e32 v9, 0xff, v1
; GFX7-NEXT:    v_bfe_u32 v1, v1, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v8, 8, v8
; GFX7-NEXT:    v_lshlrev_b32_e32 v10, 8, v10
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_or_b32_e32 v7, v7, v8
; GFX7-NEXT:    v_or_b32_e32 v8, v9, v10
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 24, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX7-NEXT:    v_or_b32_e32 v0, v7, v0
; GFX7-NEXT:    v_or_b32_e32 v1, v8, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v5
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v6
; GFX7-NEXT:    v_cndmask_b32_e32 v5, v0, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v3, v5, v3
; GFX7-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7-NEXT:    v_bfe_u32 v5, v0, 8, 8
; GFX7-NEXT:    v_bfe_u32 v7, v1, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v4, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_and_b32_e32 v6, 0xff, v1
; GFX7-NEXT:    v_bfe_u32 v1, v1, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 8, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v7, 8, v7
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX7-NEXT:    v_or_b32_e32 v5, v6, v7
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v4, v0
; GFX7-NEXT:    v_or_b32_e32 v1, v5, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX7-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v8i8_v_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX10-NEXT:    s_mov_b32 s0, 8
; GFX10-NEXT:    v_and_b32_e32 v4, 3, v3
; GFX10-NEXT:    s_mov_b32 s1, 16
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 2, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v3
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v5, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v6, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v8, s0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v9, s1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v10, s1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, v0, 0xff, v6
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 24, v5
; GFX10-NEXT:    v_and_or_b32 v1, v1, 0xff, v8
; GFX10-NEXT:    v_lshlrev_b32_e32 v6, 24, v7
; GFX10-NEXT:    v_lshlrev_b32_e64 v7, v4, 0xff
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, 0, v3
; GFX10-NEXT:    v_or3_b32 v0, v0, v9, v5
; GFX10-NEXT:    v_mov_b32_e32 v3, 8
; GFX10-NEXT:    v_or3_b32 v1, v1, v10, v6
; GFX10-NEXT:    v_xor_b32_e32 v4, -1, v7
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v0, v1, vcc_lo
; GFX10-NEXT:    v_and_or_b32 v2, v5, v4, v2
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc_lo
; GFX10-NEXT:    v_mov_b32_e32 v2, 16
; GFX10-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v5, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v6, 24, v1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, v3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v7, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v8, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v2, 0xff, v0, v5
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX10-NEXT:    v_and_or_b32 v3, 0xff, v1, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 24, v6
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    v_or3_b32 v2, v2, v7, v4
; GFX10-NEXT:    v_or3_b32 v3, v3, v8, v5
; GFX10-NEXT:    global_store_dwordx2 v[0:1], v[2:3], off
; GFX10-NEXT:    s_endpgm
  %vec = load <8 x i8>, <8 x i8> addrspace(1)* %ptr
  %insert = insertelement <8 x i8> %vec, i8 %val, i32 %idx
  store <8 x i8> %insert, <8 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v16i8_s_s(<16 x i8> addrspace(4)* inreg %ptr, i8 inreg %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_s_v16i8_s_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_bfe_u32 s11, s0, 0x80008
; GFX9-NEXT:    s_lshr_b32 s6, s0, 24
; GFX9-NEXT:    s_and_b32 s10, s0, 0xff
; GFX9-NEXT:    s_lshl_b32 s11, s11, 8
; GFX9-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX9-NEXT:    s_or_b32 s10, s10, s11
; GFX9-NEXT:    s_lshl_b32 s0, s0, 16
; GFX9-NEXT:    s_or_b32 s0, s10, s0
; GFX9-NEXT:    s_lshl_b32 s6, s6, 24
; GFX9-NEXT:    s_bfe_u32 s10, s1, 0x80008
; GFX9-NEXT:    s_lshr_b32 s7, s1, 24
; GFX9-NEXT:    s_or_b32 s0, s0, s6
; GFX9-NEXT:    s_and_b32 s6, s1, 0xff
; GFX9-NEXT:    s_lshl_b32 s10, s10, 8
; GFX9-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX9-NEXT:    s_or_b32 s6, s6, s10
; GFX9-NEXT:    s_lshl_b32 s1, s1, 16
; GFX9-NEXT:    s_or_b32 s1, s6, s1
; GFX9-NEXT:    s_lshl_b32 s6, s7, 24
; GFX9-NEXT:    s_bfe_u32 s7, s2, 0x80008
; GFX9-NEXT:    s_lshr_b32 s8, s2, 24
; GFX9-NEXT:    s_or_b32 s1, s1, s6
; GFX9-NEXT:    s_and_b32 s6, s2, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s7, 8
; GFX9-NEXT:    s_bfe_u32 s2, s2, 0x80010
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_lshl_b32 s2, s2, 16
; GFX9-NEXT:    s_or_b32 s2, s6, s2
; GFX9-NEXT:    s_lshl_b32 s6, s8, 24
; GFX9-NEXT:    s_bfe_u32 s7, s3, 0x80008
; GFX9-NEXT:    s_lshr_b32 s9, s3, 24
; GFX9-NEXT:    s_or_b32 s2, s2, s6
; GFX9-NEXT:    s_and_b32 s6, s3, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s7, 8
; GFX9-NEXT:    s_bfe_u32 s3, s3, 0x80010
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_lshl_b32 s3, s3, 16
; GFX9-NEXT:    s_or_b32 s3, s6, s3
; GFX9-NEXT:    s_lshl_b32 s6, s9, 24
; GFX9-NEXT:    s_or_b32 s3, s3, s6
; GFX9-NEXT:    s_lshr_b32 s6, s5, 2
; GFX9-NEXT:    s_cmp_eq_u32 s6, 1
; GFX9-NEXT:    s_cselect_b32 s7, s1, s0
; GFX9-NEXT:    s_cmp_eq_u32 s6, 2
; GFX9-NEXT:    s_cselect_b32 s7, s2, s7
; GFX9-NEXT:    s_cmp_eq_u32 s6, 3
; GFX9-NEXT:    s_cselect_b32 s7, s3, s7
; GFX9-NEXT:    s_and_b32 s5, s5, 3
; GFX9-NEXT:    s_lshl_b32 s5, s5, 3
; GFX9-NEXT:    s_and_b32 s4, s4, 0xff
; GFX9-NEXT:    s_lshl_b32 s4, s4, s5
; GFX9-NEXT:    s_lshl_b32 s5, 0xff, s5
; GFX9-NEXT:    s_andn2_b32 s5, s7, s5
; GFX9-NEXT:    s_or_b32 s4, s5, s4
; GFX9-NEXT:    s_cmp_eq_u32 s6, 0
; GFX9-NEXT:    s_cselect_b32 s0, s4, s0
; GFX9-NEXT:    s_cmp_eq_u32 s6, 1
; GFX9-NEXT:    s_cselect_b32 s1, s4, s1
; GFX9-NEXT:    s_cmp_eq_u32 s6, 2
; GFX9-NEXT:    s_cselect_b32 s2, s4, s2
; GFX9-NEXT:    s_cmp_eq_u32 s6, 3
; GFX9-NEXT:    s_cselect_b32 s3, s4, s3
; GFX9-NEXT:    s_bfe_u32 s9, s0, 0x80008
; GFX9-NEXT:    s_lshr_b32 s4, s0, 24
; GFX9-NEXT:    s_and_b32 s8, s0, 0xff
; GFX9-NEXT:    s_lshl_b32 s9, s9, 8
; GFX9-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX9-NEXT:    s_or_b32 s8, s8, s9
; GFX9-NEXT:    s_lshl_b32 s0, s0, 16
; GFX9-NEXT:    s_or_b32 s0, s8, s0
; GFX9-NEXT:    s_lshl_b32 s4, s4, 24
; GFX9-NEXT:    s_bfe_u32 s8, s1, 0x80008
; GFX9-NEXT:    s_lshr_b32 s5, s1, 24
; GFX9-NEXT:    s_or_b32 s0, s0, s4
; GFX9-NEXT:    s_and_b32 s4, s1, 0xff
; GFX9-NEXT:    s_lshl_b32 s8, s8, 8
; GFX9-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX9-NEXT:    s_or_b32 s4, s4, s8
; GFX9-NEXT:    s_lshl_b32 s1, s1, 16
; GFX9-NEXT:    s_or_b32 s1, s4, s1
; GFX9-NEXT:    s_lshl_b32 s4, s5, 24
; GFX9-NEXT:    s_bfe_u32 s5, s2, 0x80008
; GFX9-NEXT:    s_lshr_b32 s6, s2, 24
; GFX9-NEXT:    s_or_b32 s1, s1, s4
; GFX9-NEXT:    s_and_b32 s4, s2, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 8
; GFX9-NEXT:    s_bfe_u32 s2, s2, 0x80010
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_lshl_b32 s2, s2, 16
; GFX9-NEXT:    s_or_b32 s2, s4, s2
; GFX9-NEXT:    s_lshl_b32 s4, s6, 24
; GFX9-NEXT:    s_bfe_u32 s5, s3, 0x80008
; GFX9-NEXT:    s_lshr_b32 s7, s3, 24
; GFX9-NEXT:    s_or_b32 s2, s2, s4
; GFX9-NEXT:    s_and_b32 s4, s3, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 8
; GFX9-NEXT:    s_bfe_u32 s3, s3, 0x80010
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_lshl_b32 s3, s3, 16
; GFX9-NEXT:    s_or_b32 s3, s4, s3
; GFX9-NEXT:    s_lshl_b32 s4, s7, 24
; GFX9-NEXT:    s_or_b32 s3, s3, s4
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    v_mov_b32_e32 v3, s3
; GFX9-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v16i8_s_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_mov_b32_e32 v5, 0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_bfe_u32 s11, s0, 0x80008
; GFX8-NEXT:    s_lshr_b32 s6, s0, 24
; GFX8-NEXT:    s_and_b32 s10, s0, 0xff
; GFX8-NEXT:    s_lshl_b32 s11, s11, 8
; GFX8-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX8-NEXT:    s_or_b32 s10, s10, s11
; GFX8-NEXT:    s_lshl_b32 s0, s0, 16
; GFX8-NEXT:    s_or_b32 s0, s10, s0
; GFX8-NEXT:    s_lshl_b32 s6, s6, 24
; GFX8-NEXT:    s_bfe_u32 s10, s1, 0x80008
; GFX8-NEXT:    s_lshr_b32 s7, s1, 24
; GFX8-NEXT:    s_or_b32 s0, s0, s6
; GFX8-NEXT:    s_and_b32 s6, s1, 0xff
; GFX8-NEXT:    s_lshl_b32 s10, s10, 8
; GFX8-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX8-NEXT:    s_or_b32 s6, s6, s10
; GFX8-NEXT:    s_lshl_b32 s1, s1, 16
; GFX8-NEXT:    s_or_b32 s1, s6, s1
; GFX8-NEXT:    s_lshl_b32 s6, s7, 24
; GFX8-NEXT:    s_bfe_u32 s7, s2, 0x80008
; GFX8-NEXT:    s_lshr_b32 s8, s2, 24
; GFX8-NEXT:    s_or_b32 s1, s1, s6
; GFX8-NEXT:    s_and_b32 s6, s2, 0xff
; GFX8-NEXT:    s_lshl_b32 s7, s7, 8
; GFX8-NEXT:    s_bfe_u32 s2, s2, 0x80010
; GFX8-NEXT:    s_or_b32 s6, s6, s7
; GFX8-NEXT:    s_lshl_b32 s2, s2, 16
; GFX8-NEXT:    s_or_b32 s2, s6, s2
; GFX8-NEXT:    s_lshl_b32 s6, s8, 24
; GFX8-NEXT:    s_bfe_u32 s7, s3, 0x80008
; GFX8-NEXT:    s_lshr_b32 s9, s3, 24
; GFX8-NEXT:    s_or_b32 s2, s2, s6
; GFX8-NEXT:    s_and_b32 s6, s3, 0xff
; GFX8-NEXT:    s_lshl_b32 s7, s7, 8
; GFX8-NEXT:    s_bfe_u32 s3, s3, 0x80010
; GFX8-NEXT:    s_or_b32 s6, s6, s7
; GFX8-NEXT:    s_lshl_b32 s3, s3, 16
; GFX8-NEXT:    s_or_b32 s3, s6, s3
; GFX8-NEXT:    s_lshl_b32 s6, s9, 24
; GFX8-NEXT:    s_or_b32 s3, s3, s6
; GFX8-NEXT:    s_lshr_b32 s6, s5, 2
; GFX8-NEXT:    s_cmp_eq_u32 s6, 1
; GFX8-NEXT:    s_cselect_b32 s7, s1, s0
; GFX8-NEXT:    s_cmp_eq_u32 s6, 2
; GFX8-NEXT:    s_cselect_b32 s7, s2, s7
; GFX8-NEXT:    s_cmp_eq_u32 s6, 3
; GFX8-NEXT:    s_cselect_b32 s7, s3, s7
; GFX8-NEXT:    s_and_b32 s5, s5, 3
; GFX8-NEXT:    s_lshl_b32 s5, s5, 3
; GFX8-NEXT:    s_and_b32 s4, s4, 0xff
; GFX8-NEXT:    s_lshl_b32 s4, s4, s5
; GFX8-NEXT:    s_lshl_b32 s5, 0xff, s5
; GFX8-NEXT:    s_andn2_b32 s5, s7, s5
; GFX8-NEXT:    s_or_b32 s4, s5, s4
; GFX8-NEXT:    s_cmp_eq_u32 s6, 0
; GFX8-NEXT:    s_cselect_b32 s0, s4, s0
; GFX8-NEXT:    s_cmp_eq_u32 s6, 1
; GFX8-NEXT:    s_cselect_b32 s1, s4, s1
; GFX8-NEXT:    s_cmp_eq_u32 s6, 2
; GFX8-NEXT:    s_cselect_b32 s2, s4, s2
; GFX8-NEXT:    s_cmp_eq_u32 s6, 3
; GFX8-NEXT:    s_cselect_b32 s3, s4, s3
; GFX8-NEXT:    s_bfe_u32 s9, s0, 0x80008
; GFX8-NEXT:    s_lshr_b32 s4, s0, 24
; GFX8-NEXT:    s_and_b32 s8, s0, 0xff
; GFX8-NEXT:    s_lshl_b32 s9, s9, 8
; GFX8-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX8-NEXT:    s_or_b32 s8, s8, s9
; GFX8-NEXT:    s_lshl_b32 s0, s0, 16
; GFX8-NEXT:    s_or_b32 s0, s8, s0
; GFX8-NEXT:    s_lshl_b32 s4, s4, 24
; GFX8-NEXT:    s_bfe_u32 s8, s1, 0x80008
; GFX8-NEXT:    s_lshr_b32 s5, s1, 24
; GFX8-NEXT:    s_or_b32 s0, s0, s4
; GFX8-NEXT:    s_and_b32 s4, s1, 0xff
; GFX8-NEXT:    s_lshl_b32 s8, s8, 8
; GFX8-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX8-NEXT:    s_or_b32 s4, s4, s8
; GFX8-NEXT:    s_lshl_b32 s1, s1, 16
; GFX8-NEXT:    s_or_b32 s1, s4, s1
; GFX8-NEXT:    s_lshl_b32 s4, s5, 24
; GFX8-NEXT:    s_bfe_u32 s5, s2, 0x80008
; GFX8-NEXT:    s_lshr_b32 s6, s2, 24
; GFX8-NEXT:    s_or_b32 s1, s1, s4
; GFX8-NEXT:    s_and_b32 s4, s2, 0xff
; GFX8-NEXT:    s_lshl_b32 s5, s5, 8
; GFX8-NEXT:    s_bfe_u32 s2, s2, 0x80010
; GFX8-NEXT:    s_or_b32 s4, s4, s5
; GFX8-NEXT:    s_lshl_b32 s2, s2, 16
; GFX8-NEXT:    s_or_b32 s2, s4, s2
; GFX8-NEXT:    s_lshl_b32 s4, s6, 24
; GFX8-NEXT:    s_bfe_u32 s5, s3, 0x80008
; GFX8-NEXT:    s_lshr_b32 s7, s3, 24
; GFX8-NEXT:    s_or_b32 s2, s2, s4
; GFX8-NEXT:    s_and_b32 s4, s3, 0xff
; GFX8-NEXT:    s_lshl_b32 s5, s5, 8
; GFX8-NEXT:    s_bfe_u32 s3, s3, 0x80010
; GFX8-NEXT:    s_or_b32 s4, s4, s5
; GFX8-NEXT:    s_lshl_b32 s3, s3, 16
; GFX8-NEXT:    s_or_b32 s3, s4, s3
; GFX8-NEXT:    s_lshl_b32 s4, s7, 24
; GFX8-NEXT:    s_or_b32 s3, s3, s4
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v16i8_s_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_bfe_u32 s11, s0, 0x80008
; GFX7-NEXT:    s_lshr_b32 s6, s0, 24
; GFX7-NEXT:    s_and_b32 s10, s0, 0xff
; GFX7-NEXT:    s_lshl_b32 s11, s11, 8
; GFX7-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX7-NEXT:    s_or_b32 s10, s10, s11
; GFX7-NEXT:    s_lshl_b32 s0, s0, 16
; GFX7-NEXT:    s_or_b32 s0, s10, s0
; GFX7-NEXT:    s_lshl_b32 s6, s6, 24
; GFX7-NEXT:    s_bfe_u32 s10, s1, 0x80008
; GFX7-NEXT:    s_lshr_b32 s7, s1, 24
; GFX7-NEXT:    s_or_b32 s0, s0, s6
; GFX7-NEXT:    s_and_b32 s6, s1, 0xff
; GFX7-NEXT:    s_lshl_b32 s10, s10, 8
; GFX7-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX7-NEXT:    s_or_b32 s6, s6, s10
; GFX7-NEXT:    s_lshl_b32 s1, s1, 16
; GFX7-NEXT:    s_or_b32 s1, s6, s1
; GFX7-NEXT:    s_lshl_b32 s6, s7, 24
; GFX7-NEXT:    s_bfe_u32 s7, s2, 0x80008
; GFX7-NEXT:    s_lshr_b32 s8, s2, 24
; GFX7-NEXT:    s_or_b32 s1, s1, s6
; GFX7-NEXT:    s_and_b32 s6, s2, 0xff
; GFX7-NEXT:    s_lshl_b32 s7, s7, 8
; GFX7-NEXT:    s_bfe_u32 s2, s2, 0x80010
; GFX7-NEXT:    s_or_b32 s6, s6, s7
; GFX7-NEXT:    s_lshl_b32 s2, s2, 16
; GFX7-NEXT:    s_or_b32 s2, s6, s2
; GFX7-NEXT:    s_lshl_b32 s6, s8, 24
; GFX7-NEXT:    s_bfe_u32 s7, s3, 0x80008
; GFX7-NEXT:    s_lshr_b32 s9, s3, 24
; GFX7-NEXT:    s_or_b32 s2, s2, s6
; GFX7-NEXT:    s_and_b32 s6, s3, 0xff
; GFX7-NEXT:    s_lshl_b32 s7, s7, 8
; GFX7-NEXT:    s_bfe_u32 s3, s3, 0x80010
; GFX7-NEXT:    s_or_b32 s6, s6, s7
; GFX7-NEXT:    s_lshl_b32 s3, s3, 16
; GFX7-NEXT:    s_or_b32 s3, s6, s3
; GFX7-NEXT:    s_lshl_b32 s6, s9, 24
; GFX7-NEXT:    s_or_b32 s3, s3, s6
; GFX7-NEXT:    s_lshr_b32 s6, s5, 2
; GFX7-NEXT:    s_cmp_eq_u32 s6, 1
; GFX7-NEXT:    s_cselect_b32 s7, s1, s0
; GFX7-NEXT:    s_cmp_eq_u32 s6, 2
; GFX7-NEXT:    s_cselect_b32 s7, s2, s7
; GFX7-NEXT:    s_cmp_eq_u32 s6, 3
; GFX7-NEXT:    s_cselect_b32 s7, s3, s7
; GFX7-NEXT:    s_and_b32 s5, s5, 3
; GFX7-NEXT:    s_lshl_b32 s5, s5, 3
; GFX7-NEXT:    s_and_b32 s4, s4, 0xff
; GFX7-NEXT:    s_lshl_b32 s4, s4, s5
; GFX7-NEXT:    s_lshl_b32 s5, 0xff, s5
; GFX7-NEXT:    s_andn2_b32 s5, s7, s5
; GFX7-NEXT:    s_or_b32 s4, s5, s4
; GFX7-NEXT:    s_cmp_eq_u32 s6, 0
; GFX7-NEXT:    s_cselect_b32 s5, s4, s0
; GFX7-NEXT:    s_cmp_eq_u32 s6, 1
; GFX7-NEXT:    s_cselect_b32 s7, s4, s1
; GFX7-NEXT:    s_cmp_eq_u32 s6, 2
; GFX7-NEXT:    s_cselect_b32 s2, s4, s2
; GFX7-NEXT:    s_cmp_eq_u32 s6, 3
; GFX7-NEXT:    s_cselect_b32 s3, s4, s3
; GFX7-NEXT:    s_bfe_u32 s11, s5, 0x80008
; GFX7-NEXT:    s_lshr_b32 s4, s5, 24
; GFX7-NEXT:    s_and_b32 s10, s5, 0xff
; GFX7-NEXT:    s_lshl_b32 s11, s11, 8
; GFX7-NEXT:    s_bfe_u32 s5, s5, 0x80010
; GFX7-NEXT:    s_or_b32 s10, s10, s11
; GFX7-NEXT:    s_lshl_b32 s5, s5, 16
; GFX7-NEXT:    s_or_b32 s5, s10, s5
; GFX7-NEXT:    s_lshl_b32 s4, s4, 24
; GFX7-NEXT:    s_bfe_u32 s10, s7, 0x80008
; GFX7-NEXT:    s_lshr_b32 s6, s7, 24
; GFX7-NEXT:    s_or_b32 s4, s5, s4
; GFX7-NEXT:    s_and_b32 s5, s7, 0xff
; GFX7-NEXT:    s_lshl_b32 s10, s10, 8
; GFX7-NEXT:    s_bfe_u32 s7, s7, 0x80010
; GFX7-NEXT:    s_or_b32 s5, s5, s10
; GFX7-NEXT:    s_lshl_b32 s7, s7, 16
; GFX7-NEXT:    s_or_b32 s5, s5, s7
; GFX7-NEXT:    s_lshl_b32 s6, s6, 24
; GFX7-NEXT:    s_bfe_u32 s7, s2, 0x80008
; GFX7-NEXT:    s_lshr_b32 s8, s2, 24
; GFX7-NEXT:    s_or_b32 s5, s5, s6
; GFX7-NEXT:    s_and_b32 s6, s2, 0xff
; GFX7-NEXT:    s_lshl_b32 s7, s7, 8
; GFX7-NEXT:    s_bfe_u32 s2, s2, 0x80010
; GFX7-NEXT:    s_or_b32 s6, s6, s7
; GFX7-NEXT:    s_lshl_b32 s2, s2, 16
; GFX7-NEXT:    s_or_b32 s2, s6, s2
; GFX7-NEXT:    s_lshl_b32 s6, s8, 24
; GFX7-NEXT:    s_bfe_u32 s7, s3, 0x80008
; GFX7-NEXT:    s_lshr_b32 s9, s3, 24
; GFX7-NEXT:    s_or_b32 s6, s2, s6
; GFX7-NEXT:    s_and_b32 s2, s3, 0xff
; GFX7-NEXT:    s_lshl_b32 s7, s7, 8
; GFX7-NEXT:    s_bfe_u32 s3, s3, 0x80010
; GFX7-NEXT:    s_or_b32 s2, s2, s7
; GFX7-NEXT:    s_lshl_b32 s3, s3, 16
; GFX7-NEXT:    s_or_b32 s2, s2, s3
; GFX7-NEXT:    s_lshl_b32 s3, s9, 24
; GFX7-NEXT:    s_or_b32 s7, s2, s3
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s6
; GFX7-NEXT:    v_mov_b32_e32 v3, s7
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v16i8_s_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX10-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-NEXT:    v_mov_b32_e32 v5, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_bfe_u32 s11, s0, 0x80008
; GFX10-NEXT:    s_bfe_u32 s13, s1, 0x80008
; GFX10-NEXT:    s_lshr_b32 s7, s1, 24
; GFX10-NEXT:    s_and_b32 s10, s0, 0xff
; GFX10-NEXT:    s_and_b32 s12, s1, 0xff
; GFX10-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX10-NEXT:    s_lshl_b32 s11, s11, 8
; GFX10-NEXT:    s_lshl_b32 s13, s13, 8
; GFX10-NEXT:    s_lshr_b32 s6, s0, 24
; GFX10-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX10-NEXT:    s_lshl_b32 s1, s1, 16
; GFX10-NEXT:    s_or_b32 s10, s10, s11
; GFX10-NEXT:    s_or_b32 s11, s12, s13
; GFX10-NEXT:    s_bfe_u32 s15, s2, 0x80008
; GFX10-NEXT:    s_lshl_b32 s0, s0, 16
; GFX10-NEXT:    s_lshl_b32 s7, s7, 24
; GFX10-NEXT:    s_or_b32 s1, s11, s1
; GFX10-NEXT:    s_lshr_b32 s8, s2, 24
; GFX10-NEXT:    s_and_b32 s14, s2, 0xff
; GFX10-NEXT:    s_bfe_u32 s2, s2, 0x80010
; GFX10-NEXT:    s_lshl_b32 s6, s6, 24
; GFX10-NEXT:    s_lshl_b32 s15, s15, 8
; GFX10-NEXT:    s_or_b32 s0, s10, s0
; GFX10-NEXT:    s_or_b32 s1, s1, s7
; GFX10-NEXT:    s_bfe_u32 s7, s3, 0x80008
; GFX10-NEXT:    s_lshr_b32 s9, s3, 24
; GFX10-NEXT:    s_or_b32 s12, s14, s15
; GFX10-NEXT:    s_or_b32 s0, s0, s6
; GFX10-NEXT:    s_lshl_b32 s2, s2, 16
; GFX10-NEXT:    s_lshl_b32 s6, s8, 24
; GFX10-NEXT:    s_and_b32 s8, s3, 0xff
; GFX10-NEXT:    s_lshl_b32 s7, s7, 8
; GFX10-NEXT:    s_bfe_u32 s3, s3, 0x80010
; GFX10-NEXT:    s_or_b32 s2, s12, s2
; GFX10-NEXT:    s_or_b32 s7, s8, s7
; GFX10-NEXT:    s_lshl_b32 s3, s3, 16
; GFX10-NEXT:    s_or_b32 s2, s2, s6
; GFX10-NEXT:    s_or_b32 s3, s7, s3
; GFX10-NEXT:    s_lshl_b32 s6, s9, 24
; GFX10-NEXT:    s_lshr_b32 s7, s5, 2
; GFX10-NEXT:    s_or_b32 s3, s3, s6
; GFX10-NEXT:    s_cmp_eq_u32 s7, 1
; GFX10-NEXT:    s_cselect_b32 s6, s1, s0
; GFX10-NEXT:    s_cmp_eq_u32 s7, 2
; GFX10-NEXT:    s_cselect_b32 s6, s2, s6
; GFX10-NEXT:    s_cmp_eq_u32 s7, 3
; GFX10-NEXT:    s_cselect_b32 s6, s3, s6
; GFX10-NEXT:    s_and_b32 s5, s5, 3
; GFX10-NEXT:    s_and_b32 s4, s4, 0xff
; GFX10-NEXT:    s_lshl_b32 s5, s5, 3
; GFX10-NEXT:    s_lshl_b32 s8, 0xff, s5
; GFX10-NEXT:    s_lshl_b32 s4, s4, s5
; GFX10-NEXT:    s_andn2_b32 s5, s6, s8
; GFX10-NEXT:    s_or_b32 s4, s5, s4
; GFX10-NEXT:    s_cmp_eq_u32 s7, 0
; GFX10-NEXT:    s_cselect_b32 s0, s4, s0
; GFX10-NEXT:    s_cmp_eq_u32 s7, 1
; GFX10-NEXT:    s_cselect_b32 s1, s4, s1
; GFX10-NEXT:    s_cmp_eq_u32 s7, 2
; GFX10-NEXT:    s_cselect_b32 s2, s4, s2
; GFX10-NEXT:    s_cmp_eq_u32 s7, 3
; GFX10-NEXT:    s_cselect_b32 s3, s4, s3
; GFX10-NEXT:    s_bfe_u32 s7, s0, 0x80008
; GFX10-NEXT:    s_lshr_b32 s4, s0, 24
; GFX10-NEXT:    s_and_b32 s8, s0, 0xff
; GFX10-NEXT:    s_lshl_b32 s7, s7, 8
; GFX10-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX10-NEXT:    s_or_b32 s7, s8, s7
; GFX10-NEXT:    s_lshl_b32 s0, s0, 16
; GFX10-NEXT:    s_lshr_b32 s5, s1, 24
; GFX10-NEXT:    s_or_b32 s0, s7, s0
; GFX10-NEXT:    s_bfe_u32 s7, s1, 0x80008
; GFX10-NEXT:    s_lshl_b32 s4, s4, 24
; GFX10-NEXT:    s_and_b32 s9, s1, 0xff
; GFX10-NEXT:    s_lshl_b32 s7, s7, 8
; GFX10-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX10-NEXT:    s_or_b32 s7, s9, s7
; GFX10-NEXT:    s_lshl_b32 s1, s1, 16
; GFX10-NEXT:    s_or_b32 s0, s0, s4
; GFX10-NEXT:    s_lshl_b32 s4, s5, 24
; GFX10-NEXT:    s_bfe_u32 s5, s2, 0x80008
; GFX10-NEXT:    s_lshr_b32 s6, s2, 24
; GFX10-NEXT:    s_or_b32 s1, s7, s1
; GFX10-NEXT:    s_and_b32 s7, s2, 0xff
; GFX10-NEXT:    s_lshl_b32 s5, s5, 8
; GFX10-NEXT:    s_bfe_u32 s2, s2, 0x80010
; GFX10-NEXT:    s_or_b32 s5, s7, s5
; GFX10-NEXT:    s_lshl_b32 s2, s2, 16
; GFX10-NEXT:    s_or_b32 s1, s1, s4
; GFX10-NEXT:    s_bfe_u32 s4, s3, 0x80008
; GFX10-NEXT:    s_lshr_b32 s8, s3, 24
; GFX10-NEXT:    s_or_b32 s2, s5, s2
; GFX10-NEXT:    s_and_b32 s5, s3, 0xff
; GFX10-NEXT:    s_lshl_b32 s4, s4, 8
; GFX10-NEXT:    s_bfe_u32 s3, s3, 0x80010
; GFX10-NEXT:    s_or_b32 s4, s5, s4
; GFX10-NEXT:    s_lshl_b32 s3, s3, 16
; GFX10-NEXT:    s_lshl_b32 s5, s6, 24
; GFX10-NEXT:    s_or_b32 s3, s4, s3
; GFX10-NEXT:    s_lshl_b32 s4, s8, 24
; GFX10-NEXT:    s_or_b32 s2, s2, s5
; GFX10-NEXT:    s_or_b32 s3, s3, s4
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    v_mov_b32_e32 v2, s2
; GFX10-NEXT:    v_mov_b32_e32 v3, s3
; GFX10-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX10-NEXT:    s_endpgm
  %vec = load <16 x i8>, <16 x i8> addrspace(4)* %ptr
  %insert = insertelement <16 x i8> %vec, i8 %val, i32 %idx
  store <16 x i8> %insert, <16 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v16i8_s_s(<16 x i8> addrspace(1)* %ptr, i8 inreg %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_v_v16i8_s_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX9-NEXT:    s_mov_b32 s0, 8
; GFX9-NEXT:    s_mov_b32 s1, 16
; GFX9-NEXT:    s_movk_i32 s4, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v7, 8
; GFX9-NEXT:    v_mov_b32_e32 v6, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v8, 16
; GFX9-NEXT:    s_lshr_b32 s5, s3, 2
; GFX9-NEXT:    s_and_b32 s3, s3, 3
; GFX9-NEXT:    s_and_b32 s2, s2, 0xff
; GFX9-NEXT:    s_lshl_b32 s3, s3, 3
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 1
; GFX9-NEXT:    s_lshl_b32 s2, s2, s3
; GFX9-NEXT:    s_lshl_b32 s3, 0xff, s3
; GFX9-NEXT:    s_not_b32 s6, s3
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 24, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 24, v1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v13, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v15, s0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshrrev_b32_e32 v11, 24, v2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v14, s1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v16, s1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v17, v7, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_and_or_b32 v0, v0, s4, v13
; GFX9-NEXT:    v_and_or_b32 v1, v1, s4, v15
; GFX9-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; GFX9-NEXT:    v_lshlrev_b32_e32 v10, 24, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v12, 24, v3
; GFX9-NEXT:    v_lshlrev_b32_sdwa v18, v8, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v19, v7, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_and_or_b32 v2, v2, v6, v17
; GFX9-NEXT:    v_lshlrev_b32_e32 v11, 24, v11
; GFX9-NEXT:    v_or3_b32 v0, v0, v14, v9
; GFX9-NEXT:    v_or3_b32 v1, v1, v16, v10
; GFX9-NEXT:    v_and_or_b32 v13, v3, v6, v19
; GFX9-NEXT:    v_lshlrev_b32_sdwa v3, v8, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_e32 v12, 24, v12
; GFX9-NEXT:    v_or3_b32 v2, v2, v18, v11
; GFX9-NEXT:    v_cndmask_b32_e32 v9, v0, v1, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], s5, 2
; GFX9-NEXT:    v_mov_b32_e32 v15, s2
; GFX9-NEXT:    v_or3_b32 v3, v13, v3, v12
; GFX9-NEXT:    v_cndmask_b32_e64 v9, v9, v2, s[0:1]
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[2:3], s5, 3
; GFX9-NEXT:    v_cndmask_b32_e64 v9, v9, v3, s[2:3]
; GFX9-NEXT:    v_and_or_b32 v9, v9, s6, v15
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], s5, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v9, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v9, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, v9, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, v9, s[2:3]
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 24, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 24, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v11, 24, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v12, 24, v3
; GFX9-NEXT:    v_lshlrev_b32_sdwa v13, v7, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v15, v7, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v17, v7, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v7, v7, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v14, v8, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v16, v8, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v18, v8, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v8, v8, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v0, v6, v13
; GFX9-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; GFX9-NEXT:    v_and_or_b32 v1, v1, v6, v15
; GFX9-NEXT:    v_lshlrev_b32_e32 v10, 24, v10
; GFX9-NEXT:    v_and_or_b32 v2, v2, v6, v17
; GFX9-NEXT:    v_lshlrev_b32_e32 v11, 24, v11
; GFX9-NEXT:    v_and_or_b32 v3, v3, v6, v7
; GFX9-NEXT:    v_lshlrev_b32_e32 v6, 24, v12
; GFX9-NEXT:    v_or3_b32 v0, v0, v14, v9
; GFX9-NEXT:    v_or3_b32 v1, v1, v16, v10
; GFX9-NEXT:    v_or3_b32 v2, v2, v18, v11
; GFX9-NEXT:    v_or3_b32 v3, v3, v8, v6
; GFX9-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v16i8_s_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v6, 8
; GFX8-NEXT:    v_mov_b32_e32 v7, 16
; GFX8-NEXT:    v_mov_b32_e32 v8, 8
; GFX8-NEXT:    v_mov_b32_e32 v9, 16
; GFX8-NEXT:    s_and_b32 s0, s3, 3
; GFX8-NEXT:    s_lshr_b32 s4, s3, 2
; GFX8-NEXT:    s_and_b32 s1, s2, 0xff
; GFX8-NEXT:    s_lshl_b32 s0, s0, 3
; GFX8-NEXT:    s_lshl_b32 s5, s1, s0
; GFX8-NEXT:    s_lshl_b32 s0, 0xff, s0
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX8-NEXT:    s_not_b32 s6, s0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], s4, 2
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[2:3], s4, 3
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_mov_b32_e32 v5, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_sdwa v14, v6, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v6, v6, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 24, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 24, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v15, v7, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v7, v7, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v16, v8, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshrrev_b32_e32 v12, 24, v2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v17, v9, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v18, v8, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_e32 v10, 24, v10
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 24, v11
; GFX8-NEXT:    v_or_b32_sdwa v2, v2, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v15
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v7
; GFX8-NEXT:    v_lshrrev_b32_e32 v13, 24, v3
; GFX8-NEXT:    v_lshlrev_b32_sdwa v19, v9, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_e32 v11, 24, v12
; GFX8-NEXT:    v_or_b32_sdwa v3, v3, v18 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v2, v2, v17
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v10
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v6
; GFX8-NEXT:    v_lshlrev_b32_e32 v12, 24, v13
; GFX8-NEXT:    v_or_b32_e32 v3, v3, v19
; GFX8-NEXT:    v_or_b32_e32 v2, v2, v11
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v0, v1, vcc
; GFX8-NEXT:    v_or_b32_e32 v3, v3, v12
; GFX8-NEXT:    v_cndmask_b32_e64 v6, v6, v2, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v6, v6, v3, s[2:3]
; GFX8-NEXT:    v_and_b32_e32 v6, s6, v6
; GFX8-NEXT:    v_or_b32_e32 v6, s5, v6
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[4:5], s4, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v6, s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v6, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v3, v6, s[2:3]
; GFX8-NEXT:    v_lshlrev_b32_sdwa v12, v8, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v14, v8, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v16, v8, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v8, v8, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 24, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 24, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 24, v3
; GFX8-NEXT:    v_lshlrev_b32_sdwa v13, v9, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v15, v9, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v17, v9, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v9, v9, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v2, v2, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v3, v3, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX8-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX8-NEXT:    v_lshlrev_b32_e32 v10, 24, v10
; GFX8-NEXT:    v_lshlrev_b32_e32 v8, 24, v11
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v13
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v15
; GFX8-NEXT:    v_or_b32_e32 v2, v2, v17
; GFX8-NEXT:    v_or_b32_e32 v3, v3, v9
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v6
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v7
; GFX8-NEXT:    v_or_b32_e32 v2, v2, v10
; GFX8-NEXT:    v_or_b32_e32 v3, v3, v8
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v16i8_s_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, 0xf000
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[0:3], v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_and_b32 s0, s3, 3
; GFX7-NEXT:    s_lshr_b32 s4, s3, 2
; GFX7-NEXT:    s_and_b32 s1, s2, 0xff
; GFX7-NEXT:    s_lshl_b32 s0, s0, 3
; GFX7-NEXT:    s_lshl_b32 s5, s1, s0
; GFX7-NEXT:    s_lshl_b32 s0, 0xff, s0
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX7-NEXT:    s_not_b32 s6, s0
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], s4, 2
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[2:3], s4, 3
; GFX7-NEXT:    s_mov_b32 s10, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v9, v0, 8, 8
; GFX7-NEXT:    v_bfe_u32 v11, v1, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v8, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_and_b32_e32 v10, 0xff, v1
; GFX7-NEXT:    v_bfe_u32 v1, v1, 16, 8
; GFX7-NEXT:    v_bfe_u32 v13, v2, 8, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v9, 8, v9
; GFX7-NEXT:    v_lshlrev_b32_e32 v11, 8, v11
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 24, v2
; GFX7-NEXT:    v_and_b32_e32 v12, 0xff, v2
; GFX7-NEXT:    v_bfe_u32 v2, v2, 16, 8
; GFX7-NEXT:    v_bfe_u32 v15, v3, 8, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v13, 8, v13
; GFX7-NEXT:    v_or_b32_e32 v8, v8, v9
; GFX7-NEXT:    v_or_b32_e32 v9, v10, v11
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 24, v3
; GFX7-NEXT:    v_and_b32_e32 v14, 0xff, v3
; GFX7-NEXT:    v_bfe_u32 v3, v3, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 24, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v15, 8, v15
; GFX7-NEXT:    v_or_b32_e32 v10, v12, v13
; GFX7-NEXT:    v_or_b32_e32 v0, v8, v0
; GFX7-NEXT:    v_or_b32_e32 v1, v9, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_or_b32_e32 v11, v14, v15
; GFX7-NEXT:    v_or_b32_e32 v2, v10, v2
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX7-NEXT:    v_or_b32_e32 v3, v11, v3
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v6
; GFX7-NEXT:    v_cndmask_b32_e32 v4, v0, v1, vcc
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v7
; GFX7-NEXT:    v_cndmask_b32_e64 v4, v4, v2, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v4, v4, v3, s[2:3]
; GFX7-NEXT:    v_and_b32_e32 v4, s6, v4
; GFX7-NEXT:    v_or_b32_e32 v4, s5, v4
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[4:5], s4, 0
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s[4:5]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v2, v4, s[0:1]
; GFX7-NEXT:    v_bfe_u32 v9, v0, 8, 8
; GFX7-NEXT:    v_bfe_u32 v11, v1, 8, 8
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v3, v4, s[2:3]
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v8, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_and_b32_e32 v10, 0xff, v1
; GFX7-NEXT:    v_bfe_u32 v1, v1, 16, 8
; GFX7-NEXT:    v_bfe_u32 v13, v2, 8, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v9, 8, v9
; GFX7-NEXT:    v_lshlrev_b32_e32 v11, 8, v11
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 24, v2
; GFX7-NEXT:    v_and_b32_e32 v12, 0xff, v2
; GFX7-NEXT:    v_bfe_u32 v2, v2, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v13, 8, v13
; GFX7-NEXT:    v_or_b32_e32 v8, v8, v9
; GFX7-NEXT:    v_or_b32_e32 v9, v10, v11
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 24, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_or_b32_e32 v10, v12, v13
; GFX7-NEXT:    v_or_b32_e32 v0, v8, v0
; GFX7-NEXT:    v_or_b32_e32 v1, v9, v1
; GFX7-NEXT:    v_or_b32_e32 v2, v10, v2
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v6
; GFX7-NEXT:    v_bfe_u32 v5, v3, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 24, v3
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v4
; GFX7-NEXT:    v_and_b32_e32 v4, 0xff, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 8, v5
; GFX7-NEXT:    v_bfe_u32 v3, v3, 16, 8
; GFX7-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_or_b32_e32 v3, v4, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v7
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v16i8_s_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX10-NEXT:    s_mov_b32 s0, 8
; GFX10-NEXT:    v_mov_b32_e32 v4, 8
; GFX10-NEXT:    s_mov_b32 s1, 16
; GFX10-NEXT:    v_mov_b32_e32 v5, 16
; GFX10-NEXT:    s_lshr_b32 s4, s3, 2
; GFX10-NEXT:    s_and_b32 s2, s2, 0xff
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s4, 1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v6, 24, v0
; GFX10-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v10, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v12, s0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v8, 24, v2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v11, s1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v13, s1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v14, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_and_or_b32 v0, v0, 0xff, v10
; GFX10-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX10-NEXT:    v_and_or_b32 v1, v1, 0xff, v12
; GFX10-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX10-NEXT:    v_lshrrev_b32_e32 v9, 24, v3
; GFX10-NEXT:    v_lshlrev_b32_sdwa v15, v5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v16, v4, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_and_or_b32 v2, 0xff, v2, v14
; GFX10-NEXT:    v_lshlrev_b32_e32 v8, 24, v8
; GFX10-NEXT:    v_or3_b32 v0, v0, v11, v6
; GFX10-NEXT:    v_or3_b32 v1, v1, v13, v7
; GFX10-NEXT:    v_lshlrev_b32_sdwa v10, v5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v3, 0xff, v3, v16
; GFX10-NEXT:    v_lshlrev_b32_e32 v6, 24, v9
; GFX10-NEXT:    v_or3_b32 v2, v2, v15, v8
; GFX10-NEXT:    v_cndmask_b32_e32 v7, v0, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, s4, 2
; GFX10-NEXT:    s_and_b32 s1, s3, 3
; GFX10-NEXT:    v_or3_b32 v3, v3, v10, v6
; GFX10-NEXT:    s_lshl_b32 s3, s1, 3
; GFX10-NEXT:    v_cmp_eq_u32_e64 s1, s4, 3
; GFX10-NEXT:    v_cndmask_b32_e64 v6, v7, v2, s0
; GFX10-NEXT:    s_lshl_b32 s5, 0xff, s3
; GFX10-NEXT:    s_lshl_b32 s2, s2, s3
; GFX10-NEXT:    s_not_b32 s3, s5
; GFX10-NEXT:    v_cndmask_b32_e64 v6, v6, v3, s1
; GFX10-NEXT:    v_and_or_b32 v6, v6, s3, s2
; GFX10-NEXT:    v_cmp_eq_u32_e64 s2, s4, 0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v6, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v6, s2
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v3, v6, s1
; GFX10-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX10-NEXT:    v_lshrrev_b32_e32 v6, 24, v0
; GFX10-NEXT:    v_lshrrev_b32_e32 v8, 24, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v9, 24, v3
; GFX10-NEXT:    v_lshlrev_b32_sdwa v10, v4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v12, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v14, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v4, v4, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v11, v5, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v13, v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v15, v5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v16, v5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, 0xff, v0, v10
; GFX10-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX10-NEXT:    v_and_or_b32 v1, 0xff, v1, v12
; GFX10-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX10-NEXT:    v_and_or_b32 v2, 0xff, v2, v14
; GFX10-NEXT:    v_lshlrev_b32_e32 v8, 24, v8
; GFX10-NEXT:    v_and_or_b32 v3, 0xff, v3, v4
; GFX10-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; GFX10-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-NEXT:    v_mov_b32_e32 v5, 0
; GFX10-NEXT:    v_or3_b32 v0, v0, v11, v6
; GFX10-NEXT:    v_or3_b32 v1, v1, v13, v7
; GFX10-NEXT:    v_or3_b32 v2, v2, v15, v8
; GFX10-NEXT:    v_or3_b32 v3, v3, v16, v9
; GFX10-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX10-NEXT:    s_endpgm
  %vec = load <16 x i8>, <16 x i8> addrspace(1 )* %ptr
  %insert = insertelement <16 x i8> %vec, i8 %val, i32 %idx
  store <16 x i8> %insert, <16 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v16i8_v_s(<16 x i8> addrspace(4)* inreg %ptr, i8 %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_s_v16i8_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX9-NEXT:    s_mov_b32 s5, 8
; GFX9-NEXT:    s_mov_b32 s6, 16
; GFX9-NEXT:    v_mov_b32_e32 v4, 0xff
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_bfe_u32 s12, s0, 0x80008
; GFX9-NEXT:    s_lshr_b32 s7, s0, 24
; GFX9-NEXT:    s_and_b32 s11, s0, 0xff
; GFX9-NEXT:    s_lshl_b32 s12, s12, 8
; GFX9-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX9-NEXT:    s_or_b32 s11, s11, s12
; GFX9-NEXT:    s_lshl_b32 s0, s0, 16
; GFX9-NEXT:    s_or_b32 s0, s11, s0
; GFX9-NEXT:    s_lshl_b32 s7, s7, 24
; GFX9-NEXT:    s_bfe_u32 s11, s1, 0x80008
; GFX9-NEXT:    s_lshr_b32 s8, s1, 24
; GFX9-NEXT:    s_or_b32 s0, s0, s7
; GFX9-NEXT:    s_and_b32 s7, s1, 0xff
; GFX9-NEXT:    s_lshl_b32 s11, s11, 8
; GFX9-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX9-NEXT:    s_or_b32 s7, s7, s11
; GFX9-NEXT:    s_lshl_b32 s1, s1, 16
; GFX9-NEXT:    s_or_b32 s1, s7, s1
; GFX9-NEXT:    s_lshl_b32 s7, s8, 24
; GFX9-NEXT:    s_bfe_u32 s8, s2, 0x80008
; GFX9-NEXT:    s_lshr_b32 s9, s2, 24
; GFX9-NEXT:    s_or_b32 s1, s1, s7
; GFX9-NEXT:    s_and_b32 s7, s2, 0xff
; GFX9-NEXT:    s_lshl_b32 s8, s8, 8
; GFX9-NEXT:    s_bfe_u32 s2, s2, 0x80010
; GFX9-NEXT:    s_or_b32 s7, s7, s8
; GFX9-NEXT:    s_lshl_b32 s2, s2, 16
; GFX9-NEXT:    s_or_b32 s2, s7, s2
; GFX9-NEXT:    s_lshl_b32 s7, s9, 24
; GFX9-NEXT:    s_bfe_u32 s8, s3, 0x80008
; GFX9-NEXT:    s_lshr_b32 s10, s3, 24
; GFX9-NEXT:    s_or_b32 s2, s2, s7
; GFX9-NEXT:    s_and_b32 s7, s3, 0xff
; GFX9-NEXT:    s_lshl_b32 s8, s8, 8
; GFX9-NEXT:    s_bfe_u32 s3, s3, 0x80010
; GFX9-NEXT:    s_or_b32 s7, s7, s8
; GFX9-NEXT:    s_lshl_b32 s3, s3, 16
; GFX9-NEXT:    s_or_b32 s3, s7, s3
; GFX9-NEXT:    s_lshl_b32 s7, s10, 24
; GFX9-NEXT:    s_or_b32 s3, s3, s7
; GFX9-NEXT:    s_lshr_b32 s7, s4, 2
; GFX9-NEXT:    s_cmp_eq_u32 s7, 1
; GFX9-NEXT:    s_cselect_b32 s8, s1, s0
; GFX9-NEXT:    s_cmp_eq_u32 s7, 2
; GFX9-NEXT:    s_cselect_b32 s8, s2, s8
; GFX9-NEXT:    s_cmp_eq_u32 s7, 3
; GFX9-NEXT:    s_cselect_b32 s8, s3, s8
; GFX9-NEXT:    s_and_b32 s4, s4, 3
; GFX9-NEXT:    s_lshl_b32 s4, s4, 3
; GFX9-NEXT:    s_lshl_b32 s9, 0xff, s4
; GFX9-NEXT:    s_andn2_b32 s8, s8, s9
; GFX9-NEXT:    v_mov_b32_e32 v1, s8
; GFX9-NEXT:    v_lshl_or_b32 v5, v0, s4, v1
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s7, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v5, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s7, 1
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s7, 2
; GFX9-NEXT:    v_mov_b32_e32 v3, s3
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v2, v5, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s7, 3
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v3, v5, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v9, s5, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_and_or_b32 v9, v0, v4, v9
; GFX9-NEXT:    v_lshlrev_b32_sdwa v0, s6, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_e32 v5, 24, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 24, v1
; GFX9-NEXT:    v_or3_b32 v0, v9, v0, v5
; GFX9-NEXT:    v_lshlrev_b32_sdwa v5, s5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_and_or_b32 v5, v1, v4, v5
; GFX9-NEXT:    v_lshlrev_b32_sdwa v1, s6, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX9-NEXT:    v_or3_b32 v1, v5, v1, v6
; GFX9-NEXT:    v_mov_b32_e32 v5, 8
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v6, v5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_mov_b32_e32 v9, 16
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 24, v3
; GFX9-NEXT:    v_and_or_b32 v6, v2, v4, v6
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v9, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX9-NEXT:    v_lshlrev_b32_sdwa v5, v5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_or3_b32 v2, v6, v2, v7
; GFX9-NEXT:    v_and_or_b32 v6, v3, v4, v5
; GFX9-NEXT:    v_lshlrev_b32_sdwa v3, v9, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_e32 v7, 24, v8
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-NEXT:    v_or3_b32 v3, v6, v3, v7
; GFX9-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v16i8_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX8-NEXT:    v_mov_b32_e32 v8, 8
; GFX8-NEXT:    v_mov_b32_e32 v10, 16
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_bfe_u32 s10, s0, 0x80008
; GFX8-NEXT:    s_lshr_b32 s5, s0, 24
; GFX8-NEXT:    s_and_b32 s9, s0, 0xff
; GFX8-NEXT:    s_lshl_b32 s10, s10, 8
; GFX8-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX8-NEXT:    s_or_b32 s9, s9, s10
; GFX8-NEXT:    s_lshl_b32 s0, s0, 16
; GFX8-NEXT:    s_or_b32 s0, s9, s0
; GFX8-NEXT:    s_lshl_b32 s5, s5, 24
; GFX8-NEXT:    s_bfe_u32 s9, s1, 0x80008
; GFX8-NEXT:    s_lshr_b32 s6, s1, 24
; GFX8-NEXT:    s_or_b32 s0, s0, s5
; GFX8-NEXT:    s_and_b32 s5, s1, 0xff
; GFX8-NEXT:    s_lshl_b32 s9, s9, 8
; GFX8-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX8-NEXT:    s_or_b32 s5, s5, s9
; GFX8-NEXT:    s_lshl_b32 s1, s1, 16
; GFX8-NEXT:    s_or_b32 s1, s5, s1
; GFX8-NEXT:    s_lshl_b32 s5, s6, 24
; GFX8-NEXT:    s_bfe_u32 s6, s2, 0x80008
; GFX8-NEXT:    s_lshr_b32 s7, s2, 24
; GFX8-NEXT:    s_or_b32 s1, s1, s5
; GFX8-NEXT:    s_and_b32 s5, s2, 0xff
; GFX8-NEXT:    s_lshl_b32 s6, s6, 8
; GFX8-NEXT:    s_bfe_u32 s2, s2, 0x80010
; GFX8-NEXT:    s_or_b32 s5, s5, s6
; GFX8-NEXT:    s_lshl_b32 s2, s2, 16
; GFX8-NEXT:    s_or_b32 s2, s5, s2
; GFX8-NEXT:    s_lshl_b32 s5, s7, 24
; GFX8-NEXT:    s_bfe_u32 s6, s3, 0x80008
; GFX8-NEXT:    s_lshr_b32 s8, s3, 24
; GFX8-NEXT:    s_or_b32 s2, s2, s5
; GFX8-NEXT:    s_and_b32 s5, s3, 0xff
; GFX8-NEXT:    s_lshl_b32 s6, s6, 8
; GFX8-NEXT:    s_bfe_u32 s3, s3, 0x80010
; GFX8-NEXT:    s_or_b32 s5, s5, s6
; GFX8-NEXT:    s_lshl_b32 s3, s3, 16
; GFX8-NEXT:    s_or_b32 s3, s5, s3
; GFX8-NEXT:    s_lshl_b32 s5, s8, 24
; GFX8-NEXT:    s_or_b32 s3, s3, s5
; GFX8-NEXT:    s_lshr_b32 s5, s4, 2
; GFX8-NEXT:    s_cmp_eq_u32 s5, 1
; GFX8-NEXT:    s_cselect_b32 s6, s1, s0
; GFX8-NEXT:    s_cmp_eq_u32 s5, 2
; GFX8-NEXT:    s_cselect_b32 s6, s2, s6
; GFX8-NEXT:    s_cmp_eq_u32 s5, 3
; GFX8-NEXT:    s_cselect_b32 s6, s3, s6
; GFX8-NEXT:    s_and_b32 s4, s4, 3
; GFX8-NEXT:    s_lshl_b32 s4, s4, 3
; GFX8-NEXT:    v_mov_b32_e32 v1, s4
; GFX8-NEXT:    s_lshl_b32 s4, 0xff, s4
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    s_andn2_b32 s4, s6, s4
; GFX8-NEXT:    v_or_b32_e32 v4, s4, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 1
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v2, v4, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 3
; GFX8-NEXT:    v_lshlrev_b32_sdwa v9, v8, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX8-NEXT:    v_or_b32_sdwa v9, v0, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v10, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_e32 v0, v9, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX8-NEXT:    v_lshlrev_b32_sdwa v4, v8, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX8-NEXT:    v_or_b32_sdwa v4, v1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v10, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_e32 v1, v4, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 24, v5
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX8-NEXT:    v_mov_b32_e32 v4, 8
; GFX8-NEXT:    v_lshlrev_b32_sdwa v5, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_mov_b32_e32 v8, 16
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 24, v2
; GFX8-NEXT:    v_or_b32_sdwa v5, v2, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v8, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v4, v4, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v2, v5, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 24, v6
; GFX8-NEXT:    v_or_b32_sdwa v4, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v3, v8, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_e32 v2, v2, v5
; GFX8-NEXT:    v_or_b32_e32 v3, v4, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 24, v7
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_mov_b32_e32 v5, 0
; GFX8-NEXT:    v_or_b32_e32 v3, v3, v6
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v16i8_v_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_bfe_u32 s10, s0, 0x80008
; GFX7-NEXT:    s_lshr_b32 s5, s0, 24
; GFX7-NEXT:    s_and_b32 s9, s0, 0xff
; GFX7-NEXT:    s_lshl_b32 s10, s10, 8
; GFX7-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX7-NEXT:    s_or_b32 s9, s9, s10
; GFX7-NEXT:    s_lshl_b32 s0, s0, 16
; GFX7-NEXT:    s_or_b32 s0, s9, s0
; GFX7-NEXT:    s_lshl_b32 s5, s5, 24
; GFX7-NEXT:    s_bfe_u32 s9, s1, 0x80008
; GFX7-NEXT:    s_lshr_b32 s6, s1, 24
; GFX7-NEXT:    s_or_b32 s0, s0, s5
; GFX7-NEXT:    s_and_b32 s5, s1, 0xff
; GFX7-NEXT:    s_lshl_b32 s9, s9, 8
; GFX7-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX7-NEXT:    s_or_b32 s5, s5, s9
; GFX7-NEXT:    s_lshl_b32 s1, s1, 16
; GFX7-NEXT:    s_or_b32 s1, s5, s1
; GFX7-NEXT:    s_lshl_b32 s5, s6, 24
; GFX7-NEXT:    s_bfe_u32 s6, s2, 0x80008
; GFX7-NEXT:    s_lshr_b32 s7, s2, 24
; GFX7-NEXT:    s_or_b32 s1, s1, s5
; GFX7-NEXT:    s_and_b32 s5, s2, 0xff
; GFX7-NEXT:    s_lshl_b32 s6, s6, 8
; GFX7-NEXT:    s_bfe_u32 s2, s2, 0x80010
; GFX7-NEXT:    s_or_b32 s5, s5, s6
; GFX7-NEXT:    s_lshl_b32 s2, s2, 16
; GFX7-NEXT:    s_or_b32 s2, s5, s2
; GFX7-NEXT:    s_lshl_b32 s5, s7, 24
; GFX7-NEXT:    s_bfe_u32 s6, s3, 0x80008
; GFX7-NEXT:    s_lshr_b32 s8, s3, 24
; GFX7-NEXT:    s_or_b32 s2, s2, s5
; GFX7-NEXT:    s_and_b32 s5, s3, 0xff
; GFX7-NEXT:    s_lshl_b32 s6, s6, 8
; GFX7-NEXT:    s_bfe_u32 s3, s3, 0x80010
; GFX7-NEXT:    s_or_b32 s5, s5, s6
; GFX7-NEXT:    s_lshl_b32 s3, s3, 16
; GFX7-NEXT:    s_or_b32 s3, s5, s3
; GFX7-NEXT:    s_lshl_b32 s5, s8, 24
; GFX7-NEXT:    s_or_b32 s3, s3, s5
; GFX7-NEXT:    s_lshr_b32 s5, s4, 2
; GFX7-NEXT:    s_cmp_eq_u32 s5, 1
; GFX7-NEXT:    s_cselect_b32 s6, s1, s0
; GFX7-NEXT:    s_cmp_eq_u32 s5, 2
; GFX7-NEXT:    s_cselect_b32 s6, s2, s6
; GFX7-NEXT:    s_cmp_eq_u32 s5, 3
; GFX7-NEXT:    s_cselect_b32 s6, s3, s6
; GFX7-NEXT:    s_and_b32 s4, s4, 3
; GFX7-NEXT:    s_lshl_b32 s4, s4, 3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, s4, v0
; GFX7-NEXT:    s_lshl_b32 s4, 0xff, s4
; GFX7-NEXT:    s_andn2_b32 s4, s6, s4
; GFX7-NEXT:    v_or_b32_e32 v4, s4, v0
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 1
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 2
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    v_cndmask_b32_e32 v2, v2, v4, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s5, 3
; GFX7-NEXT:    v_bfe_u32 v9, v0, 8, 8
; GFX7-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v8, 0xff, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v9, 8, v9
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_or_b32_e32 v8, v8, v9
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v8, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX7-NEXT:    v_bfe_u32 v8, v1, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX7-NEXT:    v_and_b32_e32 v4, 0xff, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v8, 8, v8
; GFX7-NEXT:    v_bfe_u32 v1, v1, 16, 8
; GFX7-NEXT:    v_or_b32_e32 v4, v4, v8
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_or_b32_e32 v1, v4, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v5
; GFX7-NEXT:    v_bfe_u32 v5, v2, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 24, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX7-NEXT:    v_and_b32_e32 v4, 0xff, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 8, v5
; GFX7-NEXT:    v_bfe_u32 v2, v2, 16, 8
; GFX7-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v4, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v6
; GFX7-NEXT:    v_bfe_u32 v5, v3, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 24, v3
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v4
; GFX7-NEXT:    v_and_b32_e32 v4, 0xff, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 8, v5
; GFX7-NEXT:    v_bfe_u32 v3, v3, 16, 8
; GFX7-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_or_b32_e32 v3, v4, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v7
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v16i8_v_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX10-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX10-NEXT:    v_mov_b32_e32 v10, 8
; GFX10-NEXT:    v_mov_b32_e32 v12, 16
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_bfe_u32 s10, s0, 0x80008
; GFX10-NEXT:    s_bfe_u32 s12, s1, 0x80008
; GFX10-NEXT:    s_lshr_b32 s6, s1, 24
; GFX10-NEXT:    s_and_b32 s9, s0, 0xff
; GFX10-NEXT:    s_and_b32 s11, s1, 0xff
; GFX10-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX10-NEXT:    s_lshl_b32 s10, s10, 8
; GFX10-NEXT:    s_lshl_b32 s12, s12, 8
; GFX10-NEXT:    s_lshr_b32 s5, s0, 24
; GFX10-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX10-NEXT:    s_lshl_b32 s1, s1, 16
; GFX10-NEXT:    s_or_b32 s9, s9, s10
; GFX10-NEXT:    s_or_b32 s10, s11, s12
; GFX10-NEXT:    s_bfe_u32 s14, s2, 0x80008
; GFX10-NEXT:    s_lshl_b32 s0, s0, 16
; GFX10-NEXT:    s_lshl_b32 s6, s6, 24
; GFX10-NEXT:    s_or_b32 s1, s10, s1
; GFX10-NEXT:    s_lshr_b32 s7, s2, 24
; GFX10-NEXT:    s_and_b32 s13, s2, 0xff
; GFX10-NEXT:    s_bfe_u32 s2, s2, 0x80010
; GFX10-NEXT:    s_lshl_b32 s5, s5, 24
; GFX10-NEXT:    s_lshl_b32 s14, s14, 8
; GFX10-NEXT:    s_or_b32 s0, s9, s0
; GFX10-NEXT:    s_or_b32 s1, s1, s6
; GFX10-NEXT:    s_bfe_u32 s6, s3, 0x80008
; GFX10-NEXT:    s_lshr_b32 s8, s3, 24
; GFX10-NEXT:    s_or_b32 s11, s13, s14
; GFX10-NEXT:    s_or_b32 s0, s0, s5
; GFX10-NEXT:    s_lshl_b32 s2, s2, 16
; GFX10-NEXT:    s_lshl_b32 s5, s7, 24
; GFX10-NEXT:    s_and_b32 s7, s3, 0xff
; GFX10-NEXT:    s_lshl_b32 s6, s6, 8
; GFX10-NEXT:    s_bfe_u32 s3, s3, 0x80010
; GFX10-NEXT:    s_or_b32 s2, s11, s2
; GFX10-NEXT:    s_or_b32 s6, s7, s6
; GFX10-NEXT:    s_lshl_b32 s3, s3, 16
; GFX10-NEXT:    s_or_b32 s2, s2, s5
; GFX10-NEXT:    s_or_b32 s3, s6, s3
; GFX10-NEXT:    s_lshl_b32 s5, s8, 24
; GFX10-NEXT:    s_lshr_b32 s6, s4, 2
; GFX10-NEXT:    s_or_b32 s3, s3, s5
; GFX10-NEXT:    s_cmp_eq_u32 s6, 1
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s6, 0
; GFX10-NEXT:    s_cselect_b32 s5, s1, s0
; GFX10-NEXT:    s_cmp_eq_u32 s6, 2
; GFX10-NEXT:    s_cselect_b32 s5, s2, s5
; GFX10-NEXT:    s_cmp_eq_u32 s6, 3
; GFX10-NEXT:    s_cselect_b32 s5, s3, s5
; GFX10-NEXT:    s_and_b32 s4, s4, 3
; GFX10-NEXT:    s_lshl_b32 s4, s4, 3
; GFX10-NEXT:    s_lshl_b32 s7, 0xff, s4
; GFX10-NEXT:    s_andn2_b32 s5, s5, s7
; GFX10-NEXT:    v_lshl_or_b32 v4, v0, s4, s5
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    v_mov_b32_e32 v2, s2
; GFX10-NEXT:    v_mov_b32_e32 v3, s3
; GFX10-NEXT:    s_mov_b32 s0, 8
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s6, 1
; GFX10-NEXT:    s_mov_b32 s1, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v6, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s6, 2
; GFX10-NEXT:    v_and_or_b32 v6, 0xff, v0, v6
; GFX10-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v2, v4, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s6, 3
; GFX10-NEXT:    v_lshlrev_b32_sdwa v9, s0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 24, v5
; GFX10-NEXT:    v_lshrrev_b32_e32 v7, 24, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc_lo
; GFX10-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v11, v10, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v0, s1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v9, 0xff, v1, v9
; GFX10-NEXT:    v_lshrrev_b32_e32 v8, 24, v3
; GFX10-NEXT:    v_lshlrev_b32_sdwa v10, v10, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, s1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v11, 0xff, v2, v11
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v12, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX10-NEXT:    v_and_or_b32 v10, 0xff, v3, v10
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, v12, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_e32 v8, 24, v8
; GFX10-NEXT:    v_or3_b32 v0, v6, v0, v4
; GFX10-NEXT:    v_or3_b32 v1, v9, v1, v5
; GFX10-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-NEXT:    v_or3_b32 v2, v11, v2, v7
; GFX10-NEXT:    v_mov_b32_e32 v5, 0
; GFX10-NEXT:    v_or3_b32 v3, v10, v3, v8
; GFX10-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX10-NEXT:    s_endpgm
  %vec = load <16 x i8>, <16 x i8> addrspace(4)* %ptr
  %insert = insertelement <16 x i8> %vec, i8 %val, i32 %idx
  store <16 x i8> %insert, <16 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v16i8_s_v(<16 x i8> addrspace(4)* inreg %ptr, i8 inreg %val, i32 %idx) {
; GFX9-LABEL: insertelement_s_v16i8_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 2, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v4
; GFX9-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX9-NEXT:    s_movk_i32 s12, 0xff
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_bfe_u32 s13, s0, 0x80008
; GFX9-NEXT:    s_lshr_b32 s5, s0, 24
; GFX9-NEXT:    s_and_b32 s8, s0, 0xff
; GFX9-NEXT:    s_lshl_b32 s13, s13, 8
; GFX9-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX9-NEXT:    s_or_b32 s8, s8, s13
; GFX9-NEXT:    s_lshl_b32 s0, s0, 16
; GFX9-NEXT:    s_or_b32 s0, s8, s0
; GFX9-NEXT:    s_lshl_b32 s5, s5, 24
; GFX9-NEXT:    s_or_b32 s8, s0, s5
; GFX9-NEXT:    s_bfe_u32 s5, s1, 0x80008
; GFX9-NEXT:    s_lshr_b32 s9, s1, 24
; GFX9-NEXT:    s_and_b32 s0, s1, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 8
; GFX9-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX9-NEXT:    s_or_b32 s0, s0, s5
; GFX9-NEXT:    s_lshl_b32 s1, s1, 16
; GFX9-NEXT:    s_or_b32 s0, s0, s1
; GFX9-NEXT:    s_lshl_b32 s1, s9, 24
; GFX9-NEXT:    s_or_b32 s9, s0, s1
; GFX9-NEXT:    s_bfe_u32 s1, s2, 0x80008
; GFX9-NEXT:    s_and_b32 s0, s2, 0xff
; GFX9-NEXT:    s_lshl_b32 s1, s1, 8
; GFX9-NEXT:    s_or_b32 s0, s0, s1
; GFX9-NEXT:    s_bfe_u32 s1, s2, 0x80010
; GFX9-NEXT:    s_lshr_b32 s10, s2, 24
; GFX9-NEXT:    s_lshl_b32 s1, s1, 16
; GFX9-NEXT:    s_or_b32 s0, s0, s1
; GFX9-NEXT:    s_lshl_b32 s1, s10, 24
; GFX9-NEXT:    s_or_b32 s10, s0, s1
; GFX9-NEXT:    s_bfe_u32 s1, s3, 0x80008
; GFX9-NEXT:    s_and_b32 s0, s3, 0xff
; GFX9-NEXT:    s_lshl_b32 s1, s1, 8
; GFX9-NEXT:    s_or_b32 s0, s0, s1
; GFX9-NEXT:    s_bfe_u32 s1, s3, 0x80010
; GFX9-NEXT:    s_lshr_b32 s11, s3, 24
; GFX9-NEXT:    s_lshl_b32 s1, s1, 16
; GFX9-NEXT:    s_or_b32 s0, s0, s1
; GFX9-NEXT:    s_lshl_b32 s1, s11, 24
; GFX9-NEXT:    v_mov_b32_e32 v1, s8
; GFX9-NEXT:    v_mov_b32_e32 v2, s9
; GFX9-NEXT:    s_or_b32 s11, s0, s1
; GFX9-NEXT:    v_mov_b32_e32 v3, s10
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v4
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX9-NEXT:    s_and_b32 s4, s4, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v5, s11
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, v3, s[0:1]
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v4
; GFX9-NEXT:    v_lshlrev_b32_e64 v2, v0, s4
; GFX9-NEXT:    v_lshlrev_b32_e64 v0, v0, s12
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, v5, s[2:3]
; GFX9-NEXT:    v_xor_b32_e32 v0, -1, v0
; GFX9-NEXT:    v_and_or_b32 v6, v1, v0, v2
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v4
; GFX9-NEXT:    s_mov_b32 s6, 8
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v6, s[4:5]
; GFX9-NEXT:    s_mov_b32 s7, 16
; GFX9-NEXT:    v_mov_b32_e32 v5, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v9, s6, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_mov_b32_e32 v2, s10
; GFX9-NEXT:    v_mov_b32_e32 v3, s11
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v6, vcc
; GFX9-NEXT:    v_and_or_b32 v9, v0, v5, v9
; GFX9-NEXT:    v_lshlrev_b32_sdwa v0, s7, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, v6, s[2:3]
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 24, v1
; GFX9-NEXT:    v_or3_b32 v0, v9, v0, v4
; GFX9-NEXT:    v_lshlrev_b32_sdwa v4, s6, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_and_or_b32 v4, v1, v5, v4
; GFX9-NEXT:    v_lshlrev_b32_sdwa v1, s7, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX9-NEXT:    v_or3_b32 v1, v4, v1, v6
; GFX9-NEXT:    v_mov_b32_e32 v4, 8
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v6, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_mov_b32_e32 v9, 16
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 24, v3
; GFX9-NEXT:    v_and_or_b32 v6, v2, v5, v6
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v9, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX9-NEXT:    v_lshlrev_b32_sdwa v4, v4, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_or3_b32 v2, v6, v2, v7
; GFX9-NEXT:    v_and_or_b32 v6, v3, v5, v4
; GFX9-NEXT:    v_lshlrev_b32_sdwa v3, v9, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_e32 v7, 24, v8
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-NEXT:    v_or3_b32 v3, v6, v3, v7
; GFX9-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v16i8_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 2, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v4
; GFX8-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX8-NEXT:    s_movk_i32 s12, 0xff
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_bfe_u32 s9, s0, 0x80008
; GFX8-NEXT:    s_lshr_b32 s5, s0, 24
; GFX8-NEXT:    s_and_b32 s8, s0, 0xff
; GFX8-NEXT:    s_lshl_b32 s9, s9, 8
; GFX8-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX8-NEXT:    s_or_b32 s8, s8, s9
; GFX8-NEXT:    s_lshl_b32 s0, s0, 16
; GFX8-NEXT:    s_or_b32 s0, s8, s0
; GFX8-NEXT:    s_lshl_b32 s5, s5, 24
; GFX8-NEXT:    s_or_b32 s8, s0, s5
; GFX8-NEXT:    s_bfe_u32 s5, s1, 0x80008
; GFX8-NEXT:    s_lshr_b32 s6, s1, 24
; GFX8-NEXT:    s_and_b32 s0, s1, 0xff
; GFX8-NEXT:    s_lshl_b32 s5, s5, 8
; GFX8-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX8-NEXT:    s_or_b32 s0, s0, s5
; GFX8-NEXT:    s_lshl_b32 s1, s1, 16
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    s_lshl_b32 s1, s6, 24
; GFX8-NEXT:    s_or_b32 s9, s0, s1
; GFX8-NEXT:    s_bfe_u32 s1, s2, 0x80008
; GFX8-NEXT:    s_and_b32 s0, s2, 0xff
; GFX8-NEXT:    s_lshl_b32 s1, s1, 8
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    s_bfe_u32 s1, s2, 0x80010
; GFX8-NEXT:    s_lshr_b32 s7, s2, 24
; GFX8-NEXT:    s_lshl_b32 s1, s1, 16
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    s_lshl_b32 s1, s7, 24
; GFX8-NEXT:    s_or_b32 s10, s0, s1
; GFX8-NEXT:    s_bfe_u32 s1, s3, 0x80008
; GFX8-NEXT:    s_and_b32 s0, s3, 0xff
; GFX8-NEXT:    s_lshl_b32 s1, s1, 8
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    s_bfe_u32 s1, s3, 0x80010
; GFX8-NEXT:    s_lshr_b32 s11, s3, 24
; GFX8-NEXT:    s_lshl_b32 s1, s1, 16
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    s_lshl_b32 s1, s11, 24
; GFX8-NEXT:    v_mov_b32_e32 v1, s8
; GFX8-NEXT:    v_mov_b32_e32 v2, s9
; GFX8-NEXT:    s_or_b32 s11, s0, s1
; GFX8-NEXT:    v_mov_b32_e32 v3, s10
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX8-NEXT:    s_and_b32 s4, s4, 0xff
; GFX8-NEXT:    v_mov_b32_e32 v5, s11
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v1, v3, s[0:1]
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v4
; GFX8-NEXT:    v_lshlrev_b32_e64 v2, v0, s4
; GFX8-NEXT:    v_lshlrev_b32_e64 v0, v0, s12
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v1, v5, s[2:3]
; GFX8-NEXT:    v_xor_b32_e32 v0, -1, v0
; GFX8-NEXT:    v_and_b32_e32 v0, v1, v0
; GFX8-NEXT:    v_or_b32_e32 v5, v0, v2
; GFX8-NEXT:    v_mov_b32_e32 v0, s8
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v4
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v5, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v8, 8
; GFX8-NEXT:    v_lshlrev_b32_sdwa v9, v8, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_mov_b32_e32 v10, 16
; GFX8-NEXT:    v_mov_b32_e32 v1, s9
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX8-NEXT:    v_or_b32_sdwa v9, v0, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v10, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX8-NEXT:    v_or_b32_e32 v0, v9, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX8-NEXT:    v_mov_b32_e32 v2, s10
; GFX8-NEXT:    v_mov_b32_e32 v3, s11
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX8-NEXT:    v_lshlrev_b32_sdwa v4, v8, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v3, v5, s[2:3]
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX8-NEXT:    v_or_b32_sdwa v4, v1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v10, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_e32 v1, v4, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 24, v5
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX8-NEXT:    v_mov_b32_e32 v4, 8
; GFX8-NEXT:    v_lshlrev_b32_sdwa v5, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_mov_b32_e32 v8, 16
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 24, v2
; GFX8-NEXT:    v_or_b32_sdwa v5, v2, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v8, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v4, v4, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v2, v5, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 24, v6
; GFX8-NEXT:    v_or_b32_sdwa v4, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v3, v8, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_e32 v2, v2, v5
; GFX8-NEXT:    v_or_b32_e32 v3, v4, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 24, v7
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_mov_b32_e32 v5, 0
; GFX8-NEXT:    v_or_b32_e32 v3, v3, v6
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v16i8_s_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 2, v0
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v4
; GFX7-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_bfe_u32 s9, s0, 0x80008
; GFX7-NEXT:    s_lshr_b32 s5, s0, 24
; GFX7-NEXT:    s_and_b32 s8, s0, 0xff
; GFX7-NEXT:    s_lshl_b32 s9, s9, 8
; GFX7-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX7-NEXT:    s_or_b32 s8, s8, s9
; GFX7-NEXT:    s_lshl_b32 s0, s0, 16
; GFX7-NEXT:    s_or_b32 s0, s8, s0
; GFX7-NEXT:    s_lshl_b32 s5, s5, 24
; GFX7-NEXT:    s_or_b32 s8, s0, s5
; GFX7-NEXT:    s_bfe_u32 s5, s1, 0x80008
; GFX7-NEXT:    s_lshr_b32 s6, s1, 24
; GFX7-NEXT:    s_and_b32 s0, s1, 0xff
; GFX7-NEXT:    s_lshl_b32 s5, s5, 8
; GFX7-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX7-NEXT:    s_or_b32 s0, s0, s5
; GFX7-NEXT:    s_lshl_b32 s1, s1, 16
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    s_lshl_b32 s1, s6, 24
; GFX7-NEXT:    s_or_b32 s9, s0, s1
; GFX7-NEXT:    s_bfe_u32 s1, s2, 0x80008
; GFX7-NEXT:    s_and_b32 s0, s2, 0xff
; GFX7-NEXT:    s_lshl_b32 s1, s1, 8
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    s_bfe_u32 s1, s2, 0x80010
; GFX7-NEXT:    s_lshr_b32 s7, s2, 24
; GFX7-NEXT:    s_lshl_b32 s1, s1, 16
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    s_lshl_b32 s1, s7, 24
; GFX7-NEXT:    s_or_b32 s10, s0, s1
; GFX7-NEXT:    s_bfe_u32 s1, s3, 0x80008
; GFX7-NEXT:    s_and_b32 s0, s3, 0xff
; GFX7-NEXT:    s_lshl_b32 s1, s1, 8
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    s_bfe_u32 s1, s3, 0x80010
; GFX7-NEXT:    s_lshr_b32 s11, s3, 24
; GFX7-NEXT:    s_lshl_b32 s1, s1, 16
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    s_lshl_b32 s1, s11, 24
; GFX7-NEXT:    v_mov_b32_e32 v1, s8
; GFX7-NEXT:    v_mov_b32_e32 v2, s9
; GFX7-NEXT:    s_or_b32 s11, s0, s1
; GFX7-NEXT:    v_mov_b32_e32 v3, s10
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v4
; GFX7-NEXT:    s_and_b32 s4, s4, 0xff
; GFX7-NEXT:    v_mov_b32_e32 v5, s11
; GFX7-NEXT:    v_cndmask_b32_e64 v1, v1, v3, s[0:1]
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v4
; GFX7-NEXT:    v_lshl_b32_e32 v2, s4, v0
; GFX7-NEXT:    v_lshl_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    v_cndmask_b32_e64 v1, v1, v5, s[2:3]
; GFX7-NEXT:    v_xor_b32_e32 v0, -1, v0
; GFX7-NEXT:    v_and_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_or_b32_e32 v5, v0, v2
; GFX7-NEXT:    v_mov_b32_e32 v0, s8
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v4
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v5, s[4:5]
; GFX7-NEXT:    v_bfe_u32 v9, v0, 8, 8
; GFX7-NEXT:    v_mov_b32_e32 v1, s9
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v8, 0xff, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v9, 8, v9
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX7-NEXT:    v_or_b32_e32 v8, v8, v9
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_mov_b32_e32 v2, s10
; GFX7-NEXT:    v_mov_b32_e32 v3, s11
; GFX7-NEXT:    v_or_b32_e32 v0, v8, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX7-NEXT:    v_bfe_u32 v8, v1, 8, 8
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v3, v5, s[2:3]
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX7-NEXT:    v_and_b32_e32 v4, 0xff, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v8, 8, v8
; GFX7-NEXT:    v_bfe_u32 v1, v1, 16, 8
; GFX7-NEXT:    v_or_b32_e32 v4, v4, v8
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_or_b32_e32 v1, v4, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v5
; GFX7-NEXT:    v_bfe_u32 v5, v2, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 24, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX7-NEXT:    v_and_b32_e32 v4, 0xff, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 8, v5
; GFX7-NEXT:    v_bfe_u32 v2, v2, 16, 8
; GFX7-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v4, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v6
; GFX7-NEXT:    v_bfe_u32 v5, v3, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 24, v3
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v4
; GFX7-NEXT:    v_and_b32_e32 v4, 0xff, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 8, v5
; GFX7-NEXT:    v_bfe_u32 v3, v3, 16, 8
; GFX7-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_or_b32_e32 v3, v4, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v7
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v16i8_s_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX10-NEXT:    v_lshrrev_b32_e32 v4, 2, v0
; GFX10-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX10-NEXT:    v_mov_b32_e32 v10, 8
; GFX10-NEXT:    v_mov_b32_e32 v12, 16
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v4
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX10-NEXT:    v_lshlrev_b32_e64 v2, v0, 0xff
; GFX10-NEXT:    v_xor_b32_e32 v2, -1, v2
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_bfe_u32 s9, s0, 0x80008
; GFX10-NEXT:    s_bfe_u32 s12, s1, 0x80008
; GFX10-NEXT:    s_lshr_b32 s5, s0, 24
; GFX10-NEXT:    s_and_b32 s8, s0, 0xff
; GFX10-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX10-NEXT:    s_lshl_b32 s9, s9, 8
; GFX10-NEXT:    s_lshr_b32 s6, s1, 24
; GFX10-NEXT:    s_and_b32 s10, s1, 0xff
; GFX10-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX10-NEXT:    s_lshl_b32 s12, s12, 8
; GFX10-NEXT:    s_bfe_u32 s14, s2, 0x80008
; GFX10-NEXT:    s_lshl_b32 s0, s0, 16
; GFX10-NEXT:    s_or_b32 s8, s8, s9
; GFX10-NEXT:    s_lshl_b32 s1, s1, 16
; GFX10-NEXT:    s_or_b32 s9, s10, s12
; GFX10-NEXT:    s_lshr_b32 s7, s2, 24
; GFX10-NEXT:    s_and_b32 s13, s2, 0xff
; GFX10-NEXT:    s_bfe_u32 s2, s2, 0x80010
; GFX10-NEXT:    s_lshl_b32 s5, s5, 24
; GFX10-NEXT:    s_lshl_b32 s14, s14, 8
; GFX10-NEXT:    s_or_b32 s0, s8, s0
; GFX10-NEXT:    s_lshl_b32 s6, s6, 24
; GFX10-NEXT:    s_or_b32 s1, s9, s1
; GFX10-NEXT:    s_or_b32 s10, s13, s14
; GFX10-NEXT:    s_or_b32 s8, s0, s5
; GFX10-NEXT:    s_lshl_b32 s0, s2, 16
; GFX10-NEXT:    s_or_b32 s9, s1, s6
; GFX10-NEXT:    s_or_b32 s0, s10, s0
; GFX10-NEXT:    s_lshl_b32 s1, s7, 24
; GFX10-NEXT:    s_bfe_u32 s2, s3, 0x80008
; GFX10-NEXT:    v_mov_b32_e32 v1, s9
; GFX10-NEXT:    s_and_b32 s5, s3, 0xff
; GFX10-NEXT:    s_lshl_b32 s2, s2, 8
; GFX10-NEXT:    s_or_b32 s10, s0, s1
; GFX10-NEXT:    s_bfe_u32 s1, s3, 0x80010
; GFX10-NEXT:    s_or_b32 s0, s5, s2
; GFX10-NEXT:    s_lshl_b32 s1, s1, 16
; GFX10-NEXT:    v_cndmask_b32_e32 v1, s8, v1, vcc_lo
; GFX10-NEXT:    s_or_b32 s1, s0, s1
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, 2, v4
; GFX10-NEXT:    s_lshr_b32 s11, s3, 24
; GFX10-NEXT:    s_mov_b32 s3, 8
; GFX10-NEXT:    s_lshl_b32 s2, s11, 24
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, s10, s0
; GFX10-NEXT:    s_or_b32 s11, s1, s2
; GFX10-NEXT:    v_cmp_eq_u32_e64 s1, 3, v4
; GFX10-NEXT:    s_and_b32 s2, s4, 0xff
; GFX10-NEXT:    v_lshlrev_b32_e64 v0, v0, s2
; GFX10-NEXT:    v_cmp_eq_u32_e64 s2, 0, v4
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, s11, s1
; GFX10-NEXT:    v_and_or_b32 v5, v1, v2, v0
; GFX10-NEXT:    v_mov_b32_e32 v0, s8
; GFX10-NEXT:    v_mov_b32_e32 v1, s9
; GFX10-NEXT:    v_mov_b32_e32 v2, s10
; GFX10-NEXT:    v_mov_b32_e32 v3, s11
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v5, s2
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v3, v5, s1
; GFX10-NEXT:    s_mov_b32 s2, 16
; GFX10-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX10-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v6, s3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v9, s3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v7, 24, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v8, 24, v3
; GFX10-NEXT:    v_lshlrev_b32_sdwa v11, v10, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v10, v10, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_and_or_b32 v6, 0xff, v0, v6
; GFX10-NEXT:    v_lshlrev_b32_sdwa v0, s2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX10-NEXT:    v_and_or_b32 v9, 0xff, v1, v9
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, s2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 24, v5
; GFX10-NEXT:    v_and_or_b32 v11, 0xff, v2, v11
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v12, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX10-NEXT:    v_and_or_b32 v10, 0xff, v3, v10
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, v12, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_e32 v8, 24, v8
; GFX10-NEXT:    v_or3_b32 v0, v6, v0, v4
; GFX10-NEXT:    v_or3_b32 v1, v9, v1, v5
; GFX10-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-NEXT:    v_or3_b32 v2, v11, v2, v7
; GFX10-NEXT:    v_mov_b32_e32 v5, 0
; GFX10-NEXT:    v_or3_b32 v3, v10, v3, v8
; GFX10-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX10-NEXT:    s_endpgm
  %vec = load <16 x i8>, <16 x i8> addrspace(4)* %ptr
  %insert = insertelement <16 x i8> %vec, i8 %val, i32 %idx
  store <16 x i8> %insert, <16 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_s_v16i8_v_v(<16 x i8> addrspace(4)* inreg %ptr, i8 %val, i32 %idx) {
; GFX9-LABEL: insertelement_s_v16i8_v_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 2, v1
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v4
; GFX9-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX9-NEXT:    s_movk_i32 s10, 0xff
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_bfe_u32 s12, s0, 0x80008
; GFX9-NEXT:    s_lshr_b32 s4, s0, 24
; GFX9-NEXT:    s_and_b32 s11, s0, 0xff
; GFX9-NEXT:    s_lshl_b32 s12, s12, 8
; GFX9-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX9-NEXT:    s_or_b32 s11, s11, s12
; GFX9-NEXT:    s_lshl_b32 s0, s0, 16
; GFX9-NEXT:    s_or_b32 s0, s11, s0
; GFX9-NEXT:    s_lshl_b32 s4, s4, 24
; GFX9-NEXT:    s_bfe_u32 s11, s1, 0x80008
; GFX9-NEXT:    s_lshr_b32 s5, s1, 24
; GFX9-NEXT:    s_or_b32 s4, s0, s4
; GFX9-NEXT:    s_and_b32 s0, s1, 0xff
; GFX9-NEXT:    s_lshl_b32 s11, s11, 8
; GFX9-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX9-NEXT:    s_or_b32 s0, s0, s11
; GFX9-NEXT:    s_lshl_b32 s1, s1, 16
; GFX9-NEXT:    s_or_b32 s0, s0, s1
; GFX9-NEXT:    s_lshl_b32 s1, s5, 24
; GFX9-NEXT:    s_or_b32 s5, s0, s1
; GFX9-NEXT:    s_bfe_u32 s1, s2, 0x80008
; GFX9-NEXT:    s_and_b32 s0, s2, 0xff
; GFX9-NEXT:    s_lshl_b32 s1, s1, 8
; GFX9-NEXT:    s_or_b32 s0, s0, s1
; GFX9-NEXT:    s_bfe_u32 s1, s2, 0x80010
; GFX9-NEXT:    s_lshr_b32 s6, s2, 24
; GFX9-NEXT:    s_lshl_b32 s1, s1, 16
; GFX9-NEXT:    s_or_b32 s0, s0, s1
; GFX9-NEXT:    s_lshl_b32 s1, s6, 24
; GFX9-NEXT:    s_or_b32 s6, s0, s1
; GFX9-NEXT:    s_bfe_u32 s1, s3, 0x80008
; GFX9-NEXT:    s_and_b32 s0, s3, 0xff
; GFX9-NEXT:    s_lshl_b32 s1, s1, 8
; GFX9-NEXT:    s_or_b32 s0, s0, s1
; GFX9-NEXT:    s_bfe_u32 s1, s3, 0x80010
; GFX9-NEXT:    s_lshr_b32 s7, s3, 24
; GFX9-NEXT:    s_lshl_b32 s1, s1, 16
; GFX9-NEXT:    s_or_b32 s0, s0, s1
; GFX9-NEXT:    s_lshl_b32 s1, s7, 24
; GFX9-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-NEXT:    s_or_b32 s7, s0, s1
; GFX9-NEXT:    v_mov_b32_e32 v5, s6
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v4
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX9-NEXT:    v_mov_b32_e32 v6, s7
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[0:1]
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v4
; GFX9-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_e64 v1, v1, s10
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[2:3]
; GFX9-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX9-NEXT:    v_and_or_b32 v6, v2, v1, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-NEXT:    v_mov_b32_e32 v3, s7
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v4
; GFX9-NEXT:    s_mov_b32 s8, 8
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v6, s[4:5]
; GFX9-NEXT:    s_mov_b32 s9, 16
; GFX9-NEXT:    v_mov_b32_e32 v5, 0xff
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v9, s8, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v6, vcc
; GFX9-NEXT:    v_and_or_b32 v9, v0, v5, v9
; GFX9-NEXT:    v_lshlrev_b32_sdwa v0, s9, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, v6, s[2:3]
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 24, v1
; GFX9-NEXT:    v_or3_b32 v0, v9, v0, v4
; GFX9-NEXT:    v_lshlrev_b32_sdwa v4, s8, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_and_or_b32 v4, v1, v5, v4
; GFX9-NEXT:    v_lshlrev_b32_sdwa v1, s9, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX9-NEXT:    v_or3_b32 v1, v4, v1, v6
; GFX9-NEXT:    v_mov_b32_e32 v4, 8
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v6, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_mov_b32_e32 v9, 16
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 24, v3
; GFX9-NEXT:    v_and_or_b32 v6, v2, v5, v6
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v9, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX9-NEXT:    v_lshlrev_b32_sdwa v4, v4, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_or3_b32 v2, v6, v2, v7
; GFX9-NEXT:    v_and_or_b32 v6, v3, v5, v4
; GFX9-NEXT:    v_lshlrev_b32_sdwa v3, v9, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_e32 v7, 24, v8
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-NEXT:    v_or3_b32 v3, v6, v3, v7
; GFX9-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_s_v16i8_v_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 2, v1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v4
; GFX8-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX8-NEXT:    s_movk_i32 s8, 0xff
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_bfe_u32 s10, s0, 0x80008
; GFX8-NEXT:    s_lshr_b32 s4, s0, 24
; GFX8-NEXT:    s_and_b32 s9, s0, 0xff
; GFX8-NEXT:    s_lshl_b32 s10, s10, 8
; GFX8-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX8-NEXT:    s_or_b32 s9, s9, s10
; GFX8-NEXT:    s_lshl_b32 s0, s0, 16
; GFX8-NEXT:    s_or_b32 s0, s9, s0
; GFX8-NEXT:    s_lshl_b32 s4, s4, 24
; GFX8-NEXT:    s_bfe_u32 s9, s1, 0x80008
; GFX8-NEXT:    s_lshr_b32 s5, s1, 24
; GFX8-NEXT:    s_or_b32 s4, s0, s4
; GFX8-NEXT:    s_and_b32 s0, s1, 0xff
; GFX8-NEXT:    s_lshl_b32 s9, s9, 8
; GFX8-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX8-NEXT:    s_or_b32 s0, s0, s9
; GFX8-NEXT:    s_lshl_b32 s1, s1, 16
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    s_lshl_b32 s1, s5, 24
; GFX8-NEXT:    s_or_b32 s5, s0, s1
; GFX8-NEXT:    s_bfe_u32 s1, s2, 0x80008
; GFX8-NEXT:    s_and_b32 s0, s2, 0xff
; GFX8-NEXT:    s_lshl_b32 s1, s1, 8
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    s_bfe_u32 s1, s2, 0x80010
; GFX8-NEXT:    s_lshr_b32 s6, s2, 24
; GFX8-NEXT:    s_lshl_b32 s1, s1, 16
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    s_lshl_b32 s1, s6, 24
; GFX8-NEXT:    s_or_b32 s6, s0, s1
; GFX8-NEXT:    s_bfe_u32 s1, s3, 0x80008
; GFX8-NEXT:    s_and_b32 s0, s3, 0xff
; GFX8-NEXT:    s_lshl_b32 s1, s1, 8
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    s_bfe_u32 s1, s3, 0x80010
; GFX8-NEXT:    s_lshr_b32 s7, s3, 24
; GFX8-NEXT:    s_lshl_b32 s1, s1, 16
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    s_lshl_b32 s1, s7, 24
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    v_mov_b32_e32 v3, s5
; GFX8-NEXT:    s_or_b32 s7, s0, s1
; GFX8-NEXT:    v_mov_b32_e32 v5, s6
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX8-NEXT:    v_mov_b32_e32 v6, s7
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[0:1]
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v4
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_e64 v1, v1, s8
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[2:3]
; GFX8-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX8-NEXT:    v_and_b32_e32 v1, v2, v1
; GFX8-NEXT:    v_or_b32_e32 v5, v1, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_mov_b32_e32 v2, s6
; GFX8-NEXT:    v_mov_b32_e32 v3, s7
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v4
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v5, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v8, 8
; GFX8-NEXT:    v_lshlrev_b32_sdwa v9, v8, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_mov_b32_e32 v10, 16
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX8-NEXT:    v_or_b32_sdwa v9, v0, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v10, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX8-NEXT:    v_or_b32_e32 v0, v9, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX8-NEXT:    v_lshlrev_b32_sdwa v4, v8, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v3, v5, s[2:3]
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX8-NEXT:    v_or_b32_sdwa v4, v1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v10, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_e32 v1, v4, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 24, v5
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX8-NEXT:    v_mov_b32_e32 v4, 8
; GFX8-NEXT:    v_lshlrev_b32_sdwa v5, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_mov_b32_e32 v8, 16
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 24, v2
; GFX8-NEXT:    v_or_b32_sdwa v5, v2, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v8, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v4, v4, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v2, v5, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 24, v6
; GFX8-NEXT:    v_or_b32_sdwa v4, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v3, v8, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_e32 v2, v2, v5
; GFX8-NEXT:    v_or_b32_e32 v3, v4, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 24, v7
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_mov_b32_e32 v5, 0
; GFX8-NEXT:    v_or_b32_e32 v3, v3, v6
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_s_v16i8_v_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 2, v1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v4
; GFX7-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_bfe_u32 s9, s0, 0x80008
; GFX7-NEXT:    s_lshr_b32 s4, s0, 24
; GFX7-NEXT:    s_and_b32 s8, s0, 0xff
; GFX7-NEXT:    s_lshl_b32 s9, s9, 8
; GFX7-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX7-NEXT:    s_or_b32 s8, s8, s9
; GFX7-NEXT:    s_lshl_b32 s0, s0, 16
; GFX7-NEXT:    s_or_b32 s0, s8, s0
; GFX7-NEXT:    s_lshl_b32 s4, s4, 24
; GFX7-NEXT:    s_bfe_u32 s8, s1, 0x80008
; GFX7-NEXT:    s_lshr_b32 s5, s1, 24
; GFX7-NEXT:    s_or_b32 s4, s0, s4
; GFX7-NEXT:    s_and_b32 s0, s1, 0xff
; GFX7-NEXT:    s_lshl_b32 s8, s8, 8
; GFX7-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX7-NEXT:    s_or_b32 s0, s0, s8
; GFX7-NEXT:    s_lshl_b32 s1, s1, 16
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    s_lshl_b32 s1, s5, 24
; GFX7-NEXT:    s_or_b32 s5, s0, s1
; GFX7-NEXT:    s_bfe_u32 s1, s2, 0x80008
; GFX7-NEXT:    s_and_b32 s0, s2, 0xff
; GFX7-NEXT:    s_lshl_b32 s1, s1, 8
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    s_bfe_u32 s1, s2, 0x80010
; GFX7-NEXT:    s_lshr_b32 s6, s2, 24
; GFX7-NEXT:    s_lshl_b32 s1, s1, 16
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    s_lshl_b32 s1, s6, 24
; GFX7-NEXT:    s_or_b32 s6, s0, s1
; GFX7-NEXT:    s_bfe_u32 s1, s3, 0x80008
; GFX7-NEXT:    s_and_b32 s0, s3, 0xff
; GFX7-NEXT:    s_lshl_b32 s1, s1, 8
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    s_bfe_u32 s1, s3, 0x80010
; GFX7-NEXT:    s_lshr_b32 s7, s3, 24
; GFX7-NEXT:    s_lshl_b32 s1, s1, 16
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    s_lshl_b32 s1, s7, 24
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    v_mov_b32_e32 v3, s5
; GFX7-NEXT:    s_or_b32 s7, s0, s1
; GFX7-NEXT:    v_mov_b32_e32 v5, s6
; GFX7-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v4
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    v_mov_b32_e32 v6, s7
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[0:1]
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_lshl_b32_e32 v1, 0xff, v1
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[2:3]
; GFX7-NEXT:    v_xor_b32_e32 v1, -1, v1
; GFX7-NEXT:    v_and_b32_e32 v1, v2, v1
; GFX7-NEXT:    v_or_b32_e32 v5, v1, v0
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s6
; GFX7-NEXT:    v_mov_b32_e32 v3, s7
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v4
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v5, s[4:5]
; GFX7-NEXT:    v_bfe_u32 v9, v0, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v8, 0xff, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v9, 8, v9
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX7-NEXT:    v_or_b32_e32 v8, v8, v9
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v8, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX7-NEXT:    v_bfe_u32 v8, v1, 8, 8
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v3, v5, s[2:3]
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX7-NEXT:    v_and_b32_e32 v4, 0xff, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v8, 8, v8
; GFX7-NEXT:    v_bfe_u32 v1, v1, 16, 8
; GFX7-NEXT:    v_or_b32_e32 v4, v4, v8
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_or_b32_e32 v1, v4, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v5
; GFX7-NEXT:    v_bfe_u32 v5, v2, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 24, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX7-NEXT:    v_and_b32_e32 v4, 0xff, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 8, v5
; GFX7-NEXT:    v_bfe_u32 v2, v2, 16, 8
; GFX7-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v4, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v6
; GFX7-NEXT:    v_bfe_u32 v5, v3, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 24, v3
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v4
; GFX7-NEXT:    v_and_b32_e32 v4, 0xff, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 8, v5
; GFX7-NEXT:    v_bfe_u32 v3, v3, 16, 8
; GFX7-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_or_b32_e32 v3, v4, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v7
; GFX7-NEXT:    s_mov_b64 s[0:1], 0
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_s_v16i8_v_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX10-NEXT:    v_lshrrev_b32_e32 v4, 2, v1
; GFX10-NEXT:    v_and_b32_e32 v1, 3, v1
; GFX10-NEXT:    v_mov_b32_e32 v10, 8
; GFX10-NEXT:    v_mov_b32_e32 v12, 16
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v4
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX10-NEXT:    v_lshlrev_b32_e64 v3, v1, 0xff
; GFX10-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX10-NEXT:    v_xor_b32_e32 v1, -1, v3
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_bfe_u32 s9, s0, 0x80008
; GFX10-NEXT:    s_lshr_b32 s4, s0, 24
; GFX10-NEXT:    s_and_b32 s8, s0, 0xff
; GFX10-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX10-NEXT:    s_bfe_u32 s11, s1, 0x80008
; GFX10-NEXT:    s_lshl_b32 s9, s9, 8
; GFX10-NEXT:    s_lshr_b32 s5, s1, 24
; GFX10-NEXT:    s_and_b32 s10, s1, 0xff
; GFX10-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GFX10-NEXT:    s_lshl_b32 s0, s0, 16
; GFX10-NEXT:    s_lshl_b32 s11, s11, 8
; GFX10-NEXT:    s_or_b32 s8, s8, s9
; GFX10-NEXT:    s_lshl_b32 s4, s4, 24
; GFX10-NEXT:    s_lshl_b32 s1, s1, 16
; GFX10-NEXT:    s_or_b32 s9, s10, s11
; GFX10-NEXT:    s_or_b32 s0, s8, s0
; GFX10-NEXT:    s_or_b32 s1, s9, s1
; GFX10-NEXT:    s_or_b32 s4, s0, s4
; GFX10-NEXT:    s_lshl_b32 s0, s5, 24
; GFX10-NEXT:    s_bfe_u32 s13, s2, 0x80008
; GFX10-NEXT:    s_or_b32 s5, s1, s0
; GFX10-NEXT:    s_bfe_u32 s0, s3, 0x80008
; GFX10-NEXT:    s_and_b32 s1, s3, 0xff
; GFX10-NEXT:    s_lshl_b32 s0, s0, 8
; GFX10-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-NEXT:    s_or_b32 s0, s1, s0
; GFX10-NEXT:    s_bfe_u32 s1, s3, 0x80010
; GFX10-NEXT:    s_lshr_b32 s6, s2, 24
; GFX10-NEXT:    s_and_b32 s12, s2, 0xff
; GFX10-NEXT:    s_bfe_u32 s2, s2, 0x80010
; GFX10-NEXT:    s_lshl_b32 s13, s13, 8
; GFX10-NEXT:    s_lshl_b32 s1, s1, 16
; GFX10-NEXT:    s_lshl_b32 s2, s2, 16
; GFX10-NEXT:    s_or_b32 s10, s12, s13
; GFX10-NEXT:    v_cndmask_b32_e32 v2, s4, v2, vcc_lo
; GFX10-NEXT:    s_or_b32 s1, s0, s1
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, 2, v4
; GFX10-NEXT:    s_lshr_b32 s7, s3, 24
; GFX10-NEXT:    s_or_b32 s2, s10, s2
; GFX10-NEXT:    s_lshl_b32 s6, s6, 24
; GFX10-NEXT:    s_mov_b32 s3, 8
; GFX10-NEXT:    s_or_b32 s6, s2, s6
; GFX10-NEXT:    s_lshl_b32 s2, s7, 24
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v2, s6, s0
; GFX10-NEXT:    s_or_b32 s7, s1, s2
; GFX10-NEXT:    v_cmp_eq_u32_e64 s1, 3, v4
; GFX10-NEXT:    v_cmp_eq_u32_e64 s2, 0, v4
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v2, s7, s1
; GFX10-NEXT:    v_and_or_b32 v5, v2, v1, v0
; GFX10-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-NEXT:    v_mov_b32_e32 v2, s6
; GFX10-NEXT:    v_mov_b32_e32 v3, s7
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, v5, s2
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v3, v5, s1
; GFX10-NEXT:    s_mov_b32 s2, 16
; GFX10-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX10-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v6, s3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v9, s3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v7, 24, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v8, 24, v3
; GFX10-NEXT:    v_lshlrev_b32_sdwa v11, v10, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v10, v10, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_and_or_b32 v6, 0xff, v0, v6
; GFX10-NEXT:    v_lshlrev_b32_sdwa v0, s2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX10-NEXT:    v_and_or_b32 v9, 0xff, v1, v9
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, s2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 24, v5
; GFX10-NEXT:    v_and_or_b32 v11, 0xff, v2, v11
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v12, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX10-NEXT:    v_and_or_b32 v10, 0xff, v3, v10
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, v12, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_e32 v8, 24, v8
; GFX10-NEXT:    v_or3_b32 v0, v6, v0, v4
; GFX10-NEXT:    v_or3_b32 v1, v9, v1, v5
; GFX10-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-NEXT:    v_or3_b32 v2, v11, v2, v7
; GFX10-NEXT:    v_mov_b32_e32 v5, 0
; GFX10-NEXT:    v_or3_b32 v3, v10, v3, v8
; GFX10-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX10-NEXT:    s_endpgm
  %vec = load <16 x i8>, <16 x i8> addrspace(4)* %ptr
  %insert = insertelement <16 x i8> %vec, i8 %val, i32 %idx
  store <16 x i8> %insert, <16 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v16i8_s_v(<16 x i8> addrspace(1)* %ptr, i8 inreg %val, i32 %idx) {
; GFX9-LABEL: insertelement_v_v16i8_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx4 v[3:6], v[0:1], off
; GFX9-NEXT:    s_mov_b32 s0, 8
; GFX9-NEXT:    v_mov_b32_e32 v1, 8
; GFX9-NEXT:    s_mov_b32 s1, 16
; GFX9-NEXT:    s_movk_i32 s3, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v0, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v7, 16
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 24, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 24, v4
; GFX9-NEXT:    v_lshlrev_b32_sdwa v12, s0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v14, s0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v16, v1, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 24, v5
; GFX9-NEXT:    v_lshlrev_b32_sdwa v13, s1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v15, s1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v3, v3, s3, v12
; GFX9-NEXT:    v_and_or_b32 v12, v4, s3, v14
; GFX9-NEXT:    v_and_or_b32 v14, v5, v0, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v16, 2, v2
; GFX9-NEXT:    v_and_b32_e32 v2, 3, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 24, v8
; GFX9-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v11, 24, v6
; GFX9-NEXT:    v_lshlrev_b32_sdwa v17, v7, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v18, v1, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    s_and_b32 s0, s2, 0xff
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 3, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v10, 24, v10
; GFX9-NEXT:    v_or3_b32 v3, v3, v13, v8
; GFX9-NEXT:    v_or3_b32 v8, v12, v15, v9
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v16
; GFX9-NEXT:    v_lshlrev_b32_sdwa v19, v7, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v6, v6, v0, v18
; GFX9-NEXT:    v_lshlrev_b32_e64 v18, v2, s0
; GFX9-NEXT:    v_lshlrev_b32_e32 v11, 24, v11
; GFX9-NEXT:    v_or3_b32 v9, v14, v17, v10
; GFX9-NEXT:    v_cndmask_b32_e32 v10, v3, v8, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v16
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, v2, v0
; GFX9-NEXT:    v_or3_b32 v6, v6, v19, v11
; GFX9-NEXT:    v_cndmask_b32_e64 v10, v10, v9, s[0:1]
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v16
; GFX9-NEXT:    v_xor_b32_e32 v2, -1, v2
; GFX9-NEXT:    v_cndmask_b32_e64 v10, v10, v6, s[2:3]
; GFX9-NEXT:    v_and_or_b32 v2, v10, v2, v18
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v16
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, v2, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v8, v2, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v9, v9, v2, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v6, v2, s[2:3]
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 24, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 24, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v11, 24, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v12, 24, v2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v13, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v15, v1, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v17, v1, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v14, v7, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v16, v7, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v18, v7, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v7, v7, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v3, v3, v0, v13
; GFX9-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX9-NEXT:    v_and_or_b32 v8, v8, v0, v15
; GFX9-NEXT:    v_lshlrev_b32_e32 v10, 24, v10
; GFX9-NEXT:    v_and_or_b32 v9, v9, v0, v17
; GFX9-NEXT:    v_lshlrev_b32_e32 v11, 24, v11
; GFX9-NEXT:    v_and_or_b32 v13, v2, v0, v1
; GFX9-NEXT:    v_lshlrev_b32_e32 v12, 24, v12
; GFX9-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-NEXT:    v_or3_b32 v0, v3, v14, v6
; GFX9-NEXT:    v_or3_b32 v1, v8, v16, v10
; GFX9-NEXT:    v_or3_b32 v2, v9, v18, v11
; GFX9-NEXT:    v_or3_b32 v3, v13, v7, v12
; GFX9-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v16i8_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx4 v[3:6], v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, 8
; GFX8-NEXT:    v_mov_b32_e32 v8, 8
; GFX8-NEXT:    v_mov_b32_e32 v7, 16
; GFX8-NEXT:    v_mov_b32_e32 v0, 0xff
; GFX8-NEXT:    v_mov_b32_e32 v9, 16
; GFX8-NEXT:    s_and_b32 s0, s2, 0xff
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_sdwa v14, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v16, v8, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 24, v3
; GFX8-NEXT:    v_lshlrev_b32_sdwa v15, v7, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_or_b32_sdwa v3, v3, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v14, v5, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshrrev_b32_e32 v16, 2, v2
; GFX8-NEXT:    v_and_b32_e32 v2, 3, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 24, v4
; GFX8-NEXT:    v_lshlrev_b32_sdwa v7, v7, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v18, v8, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_or_b32_sdwa v1, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 3, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v12, 24, v5
; GFX8-NEXT:    v_lshrrev_b32_e32 v13, 24, v6
; GFX8-NEXT:    v_lshlrev_b32_sdwa v17, v9, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v19, v9, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v6, v6, v18 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e64 v18, v2, s0
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, v2, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 24, v10
; GFX8-NEXT:    v_lshlrev_b32_e32 v10, 24, v11
; GFX8-NEXT:    v_or_b32_e32 v3, v3, v15
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v7
; GFX8-NEXT:    v_lshlrev_b32_e32 v11, 24, v12
; GFX8-NEXT:    v_or_b32_e32 v7, v14, v17
; GFX8-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v10
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v16
; GFX8-NEXT:    v_lshlrev_b32_e32 v12, 24, v13
; GFX8-NEXT:    v_or_b32_e32 v6, v6, v19
; GFX8-NEXT:    v_or_b32_e32 v3, v7, v11
; GFX8-NEXT:    v_cndmask_b32_e32 v7, v2, v1, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v16
; GFX8-NEXT:    v_or_b32_e32 v6, v6, v12
; GFX8-NEXT:    v_cndmask_b32_e64 v7, v7, v3, s[0:1]
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v16
; GFX8-NEXT:    v_xor_b32_e32 v0, -1, v0
; GFX8-NEXT:    v_cndmask_b32_e64 v7, v7, v6, s[2:3]
; GFX8-NEXT:    v_and_b32_e32 v0, v7, v0
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v18
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v16
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, v0, s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v3, v0, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v6, v0, s[2:3]
; GFX8-NEXT:    v_lshlrev_b32_sdwa v12, v8, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v14, v8, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v16, v8, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v8, v8, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 24, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 24, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 24, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v13, v9, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v15, v9, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v17, v9, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v9, v9, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v2, v2, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v3, v3, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX8-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX8-NEXT:    v_lshlrev_b32_e32 v10, 24, v10
; GFX8-NEXT:    v_lshlrev_b32_e32 v8, 24, v11
; GFX8-NEXT:    v_or_b32_e32 v2, v2, v13
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v15
; GFX8-NEXT:    v_or_b32_e32 v3, v3, v17
; GFX8-NEXT:    v_or_b32_e32 v9, v0, v9
; GFX8-NEXT:    v_mov_b32_e32 v5, 0
; GFX8-NEXT:    v_or_b32_e32 v0, v2, v6
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v7
; GFX8-NEXT:    v_or_b32_e32 v2, v3, v10
; GFX8-NEXT:    v_or_b32_e32 v3, v9, v8
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v16i8_s_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, 0xf000
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[3:6], v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    v_lshrrev_b32_e32 v17, 2, v2
; GFX7-NEXT:    v_and_b32_e32 v2, 3, v2
; GFX7-NEXT:    s_and_b32 s0, s2, 0xff
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 3, v2
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v17
; GFX7-NEXT:    v_lshl_b32_e32 v18, s0, v2
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v17
; GFX7-NEXT:    v_lshl_b32_e32 v2, 0xff, v2
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v17
; GFX7-NEXT:    v_xor_b32_e32 v2, -1, v2
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v17
; GFX7-NEXT:    s_mov_b32 s10, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v10, v3, 8, 8
; GFX7-NEXT:    v_bfe_u32 v12, v4, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 24, v4
; GFX7-NEXT:    v_and_b32_e32 v9, 0xff, v3
; GFX7-NEXT:    v_bfe_u32 v3, v3, 16, 8
; GFX7-NEXT:    v_and_b32_e32 v11, 0xff, v4
; GFX7-NEXT:    v_bfe_u32 v4, v4, 16, 8
; GFX7-NEXT:    v_bfe_u32 v14, v5, 8, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v10, 8, v10
; GFX7-NEXT:    v_lshlrev_b32_e32 v12, 8, v12
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 24, v5
; GFX7-NEXT:    v_and_b32_e32 v13, 0xff, v5
; GFX7-NEXT:    v_bfe_u32 v5, v5, 16, 8
; GFX7-NEXT:    v_bfe_u32 v16, v6, 8, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v14, 8, v14
; GFX7-NEXT:    v_or_b32_e32 v9, v9, v10
; GFX7-NEXT:    v_or_b32_e32 v10, v11, v12
; GFX7-NEXT:    v_lshrrev_b32_e32 v8, 24, v6
; GFX7-NEXT:    v_and_b32_e32 v15, 0xff, v6
; GFX7-NEXT:    v_bfe_u32 v6, v6, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v16, 8, v16
; GFX7-NEXT:    v_or_b32_e32 v11, v13, v14
; GFX7-NEXT:    v_or_b32_e32 v3, v9, v3
; GFX7-NEXT:    v_or_b32_e32 v4, v10, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX7-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX7-NEXT:    v_or_b32_e32 v12, v15, v16
; GFX7-NEXT:    v_or_b32_e32 v5, v11, v5
; GFX7-NEXT:    v_or_b32_e32 v0, v3, v0
; GFX7-NEXT:    v_or_b32_e32 v1, v4, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v8, 24, v8
; GFX7-NEXT:    v_or_b32_e32 v6, v12, v6
; GFX7-NEXT:    v_or_b32_e32 v3, v5, v7
; GFX7-NEXT:    v_cndmask_b32_e32 v5, v0, v1, vcc
; GFX7-NEXT:    v_or_b32_e32 v4, v6, v8
; GFX7-NEXT:    v_cndmask_b32_e64 v5, v5, v3, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v5, v5, v4, s[2:3]
; GFX7-NEXT:    v_and_b32_e32 v2, v5, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v18
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[4:5]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v3, v2, s[0:1]
; GFX7-NEXT:    v_bfe_u32 v9, v0, 8, 8
; GFX7-NEXT:    v_bfe_u32 v11, v1, 8, 8
; GFX7-NEXT:    v_cndmask_b32_e64 v4, v4, v2, s[2:3]
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v8, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_and_b32_e32 v10, 0xff, v1
; GFX7-NEXT:    v_bfe_u32 v1, v1, 16, 8
; GFX7-NEXT:    v_bfe_u32 v13, v3, 8, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v9, 8, v9
; GFX7-NEXT:    v_lshlrev_b32_e32 v11, 8, v11
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 24, v3
; GFX7-NEXT:    v_and_b32_e32 v12, 0xff, v3
; GFX7-NEXT:    v_bfe_u32 v3, v3, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v13, 8, v13
; GFX7-NEXT:    v_or_b32_e32 v8, v8, v9
; GFX7-NEXT:    v_or_b32_e32 v9, v10, v11
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 24, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_or_b32_e32 v10, v12, v13
; GFX7-NEXT:    v_or_b32_e32 v0, v8, v0
; GFX7-NEXT:    v_or_b32_e32 v1, v9, v1
; GFX7-NEXT:    v_or_b32_e32 v3, v10, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 24, v6
; GFX7-NEXT:    v_bfe_u32 v5, v4, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 24, v4
; GFX7-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX7-NEXT:    v_and_b32_e32 v3, 0xff, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 8, v5
; GFX7-NEXT:    v_bfe_u32 v4, v4, 16, 8
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v7
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v16i8_s_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dwordx4 v[3:6], v[0:1], off
; GFX10-NEXT:    s_mov_b32 s0, 8
; GFX10-NEXT:    v_mov_b32_e32 v1, 8
; GFX10-NEXT:    s_mov_b32 s1, 16
; GFX10-NEXT:    v_and_b32_e32 v0, 3, v2
; GFX10-NEXT:    v_mov_b32_e32 v7, 16
; GFX10-NEXT:    v_lshrrev_b32_e32 v2, 2, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v2
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v8, 24, v3
; GFX10-NEXT:    v_lshrrev_b32_e32 v9, 24, v4
; GFX10-NEXT:    v_lshlrev_b32_sdwa v12, s0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v14, s0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v10, 24, v5
; GFX10-NEXT:    v_lshlrev_b32_sdwa v13, s1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v15, s1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v16, v1, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_and_or_b32 v3, v3, 0xff, v12
; GFX10-NEXT:    v_lshlrev_b32_e32 v8, 24, v8
; GFX10-NEXT:    v_and_or_b32 v4, v4, 0xff, v14
; GFX10-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; GFX10-NEXT:    v_lshrrev_b32_e32 v11, 24, v6
; GFX10-NEXT:    v_lshlrev_b32_sdwa v17, v7, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v18, v1, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_and_or_b32 v5, 0xff, v5, v16
; GFX10-NEXT:    v_lshlrev_b32_e32 v10, 24, v10
; GFX10-NEXT:    v_or3_b32 v3, v3, v13, v8
; GFX10-NEXT:    v_or3_b32 v4, v4, v15, v9
; GFX10-NEXT:    v_lshlrev_b32_sdwa v12, v7, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v6, 0xff, v6, v18
; GFX10-NEXT:    v_lshlrev_b32_e32 v8, 24, v11
; GFX10-NEXT:    v_or3_b32 v5, v5, v17, v10
; GFX10-NEXT:    v_cndmask_b32_e32 v9, v3, v4, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, 2, v2
; GFX10-NEXT:    s_and_b32 s1, s2, 0xff
; GFX10-NEXT:    v_lshlrev_b32_e64 v10, v0, 0xff
; GFX10-NEXT:    v_or3_b32 v6, v6, v12, v8
; GFX10-NEXT:    v_lshlrev_b32_e64 v0, v0, s1
; GFX10-NEXT:    v_cndmask_b32_e64 v8, v9, v5, s0
; GFX10-NEXT:    v_cmp_eq_u32_e64 s1, 3, v2
; GFX10-NEXT:    v_xor_b32_e32 v9, -1, v10
; GFX10-NEXT:    v_cmp_eq_u32_e64 s2, 0, v2
; GFX10-NEXT:    v_cndmask_b32_e64 v8, v8, v6, s1
; GFX10-NEXT:    v_and_or_b32 v0, v8, v9, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v3, v0, s2
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v4, v0, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v4, v5, v0, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v6, v0, s1
; GFX10-NEXT:    v_lshrrev_b32_e32 v5, 24, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v6, 24, v3
; GFX10-NEXT:    v_lshrrev_b32_e32 v8, 24, v4
; GFX10-NEXT:    v_lshrrev_b32_e32 v9, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v10, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v12, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v14, v1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v11, v7, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v13, v7, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v15, v7, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v7, v7, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v2, 0xff, v2, v10
; GFX10-NEXT:    v_lshlrev_b32_e32 v10, 24, v5
; GFX10-NEXT:    v_and_or_b32 v3, 0xff, v3, v12
; GFX10-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX10-NEXT:    v_and_or_b32 v12, 0xff, v4, v14
; GFX10-NEXT:    v_lshlrev_b32_e32 v8, 24, v8
; GFX10-NEXT:    v_and_or_b32 v14, 0xff, v0, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; GFX10-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-NEXT:    v_mov_b32_e32 v5, 0
; GFX10-NEXT:    v_or3_b32 v0, v2, v11, v10
; GFX10-NEXT:    v_or3_b32 v1, v3, v13, v6
; GFX10-NEXT:    v_or3_b32 v2, v12, v15, v8
; GFX10-NEXT:    v_or3_b32 v3, v14, v7, v9
; GFX10-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX10-NEXT:    s_endpgm
  %vec = load <16 x i8>, <16 x i8> addrspace(1)* %ptr
  %insert = insertelement <16 x i8> %vec, i8 %val, i32 %idx
  store <16 x i8> %insert, <16 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v16i8_v_s(<16 x i8> addrspace(1)* %ptr, i8 %val, i32 inreg %idx) {
; GFX9-LABEL: insertelement_v_v16i8_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx4 v[3:6], v[0:1], off
; GFX9-NEXT:    s_mov_b32 s0, 8
; GFX9-NEXT:    s_mov_b32 s1, 16
; GFX9-NEXT:    s_movk_i32 s3, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v1, 8
; GFX9-NEXT:    v_mov_b32_e32 v0, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v7, 16
; GFX9-NEXT:    s_lshr_b32 s4, s2, 2
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 24, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 24, v4
; GFX9-NEXT:    v_lshlrev_b32_sdwa v12, s0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v14, s0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    s_and_b32 s0, s2, 3
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 24, v5
; GFX9-NEXT:    v_lshlrev_b32_sdwa v13, s1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v15, s1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v16, v1, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_and_or_b32 v3, v3, s3, v12
; GFX9-NEXT:    v_and_or_b32 v12, v4, s3, v14
; GFX9-NEXT:    s_lshl_b32 s0, s0, 3
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 24, v8
; GFX9-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v11, 24, v6
; GFX9-NEXT:    v_lshlrev_b32_sdwa v17, v7, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v18, v1, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_and_or_b32 v14, v5, v0, v16
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, s0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    s_lshl_b32 s0, 0xff, s0
; GFX9-NEXT:    v_lshlrev_b32_e32 v10, 24, v10
; GFX9-NEXT:    v_or3_b32 v3, v3, v13, v8
; GFX9-NEXT:    v_or3_b32 v8, v12, v15, v9
; GFX9-NEXT:    v_lshlrev_b32_sdwa v19, v7, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v6, v6, v0, v18
; GFX9-NEXT:    s_not_b32 s5, s0
; GFX9-NEXT:    v_lshlrev_b32_e32 v11, 24, v11
; GFX9-NEXT:    v_or3_b32 v9, v14, v17, v10
; GFX9-NEXT:    v_cndmask_b32_e32 v10, v3, v8, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], s4, 2
; GFX9-NEXT:    v_or3_b32 v6, v6, v19, v11
; GFX9-NEXT:    v_cndmask_b32_e64 v10, v10, v9, s[0:1]
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[2:3], s4, 3
; GFX9-NEXT:    v_cndmask_b32_e64 v10, v10, v6, s[2:3]
; GFX9-NEXT:    v_and_or_b32 v2, v10, s5, v2
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], s4, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, v2, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v8, v2, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v9, v9, v2, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v6, v2, s[2:3]
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 24, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 24, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v11, 24, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v12, 24, v2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v13, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v15, v1, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v17, v1, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v14, v7, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v16, v7, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v18, v7, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v7, v7, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v3, v3, v0, v13
; GFX9-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX9-NEXT:    v_and_or_b32 v8, v8, v0, v15
; GFX9-NEXT:    v_lshlrev_b32_e32 v10, 24, v10
; GFX9-NEXT:    v_and_or_b32 v9, v9, v0, v17
; GFX9-NEXT:    v_lshlrev_b32_e32 v11, 24, v11
; GFX9-NEXT:    v_and_or_b32 v13, v2, v0, v1
; GFX9-NEXT:    v_lshlrev_b32_e32 v12, 24, v12
; GFX9-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-NEXT:    v_or3_b32 v0, v3, v14, v6
; GFX9-NEXT:    v_or3_b32 v1, v8, v16, v10
; GFX9-NEXT:    v_or3_b32 v2, v9, v18, v11
; GFX9-NEXT:    v_or3_b32 v3, v13, v7, v12
; GFX9-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v16i8_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx4 v[3:6], v[0:1]
; GFX8-NEXT:    s_and_b32 s0, s2, 3
; GFX8-NEXT:    v_mov_b32_e32 v0, 8
; GFX8-NEXT:    s_lshl_b32 s0, s0, 3
; GFX8-NEXT:    v_mov_b32_e32 v1, 16
; GFX8-NEXT:    v_mov_b32_e32 v9, 8
; GFX8-NEXT:    v_mov_b32_e32 v11, s0
; GFX8-NEXT:    v_mov_b32_e32 v10, 16
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v11, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    s_lshr_b32 s4, s2, 2
; GFX8-NEXT:    s_lshl_b32 s0, 0xff, s0
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX8-NEXT:    s_not_b32 s5, s0
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], s4, 2
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[2:3], s4, 3
; GFX8-NEXT:    v_mov_b32_e32 v7, 0
; GFX8-NEXT:    v_mov_b32_e32 v8, 0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_sdwa v15, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 24, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v12, 24, v4
; GFX8-NEXT:    v_lshlrev_b32_sdwa v16, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v17, v9, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_or_b32_sdwa v3, v3, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v0, v4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshrrev_b32_e32 v13, 24, v5
; GFX8-NEXT:    v_lshlrev_b32_sdwa v18, v10, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v19, v9, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_or_b32_sdwa v4, v5, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v11, 24, v11
; GFX8-NEXT:    v_lshlrev_b32_e32 v12, 24, v12
; GFX8-NEXT:    v_or_b32_e32 v3, v3, v16
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v14, 24, v6
; GFX8-NEXT:    v_or_b32_sdwa v5, v6, v19 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v6, v10, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_e32 v13, 24, v13
; GFX8-NEXT:    v_or_b32_e32 v1, v4, v18
; GFX8-NEXT:    v_or_b32_e32 v3, v3, v11
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v12
; GFX8-NEXT:    v_lshlrev_b32_e32 v14, 24, v14
; GFX8-NEXT:    v_or_b32_e32 v4, v5, v6
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v13
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v3, v0, vcc
; GFX8-NEXT:    v_or_b32_e32 v4, v4, v14
; GFX8-NEXT:    v_cndmask_b32_e64 v5, v5, v1, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v5, v5, v4, s[2:3]
; GFX8-NEXT:    v_and_b32_e32 v5, s5, v5
; GFX8-NEXT:    v_or_b32_e32 v2, v5, v2
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[4:5], s4, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v3, v2, s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v1, v2, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v4, v2, s[2:3]
; GFX8-NEXT:    v_lshlrev_b32_sdwa v12, v9, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v14, v9, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v16, v9, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v9, v9, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 24, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 24, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 24, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 24, v2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v13, v10, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v15, v10, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v17, v10, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v10, v10, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v3, v3, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v2, v2, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 24, v5
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX8-NEXT:    v_lshlrev_b32_e32 v9, 24, v11
; GFX8-NEXT:    v_or_b32_e32 v3, v3, v13
; GFX8-NEXT:    v_or_b32_e32 v11, v0, v15
; GFX8-NEXT:    v_or_b32_e32 v12, v1, v17
; GFX8-NEXT:    v_or_b32_e32 v10, v2, v10
; GFX8-NEXT:    v_or_b32_e32 v0, v3, v4
; GFX8-NEXT:    v_or_b32_e32 v1, v11, v5
; GFX8-NEXT:    v_or_b32_e32 v2, v12, v6
; GFX8-NEXT:    v_or_b32_e32 v3, v10, v9
; GFX8-NEXT:    flat_store_dwordx4 v[7:8], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v16i8_v_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, 0xf000
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[3:6], v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v2
; GFX7-NEXT:    s_and_b32 s0, s2, 3
; GFX7-NEXT:    s_lshr_b32 s4, s2, 2
; GFX7-NEXT:    s_lshl_b32 s0, s0, 3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, s0, v0
; GFX7-NEXT:    s_lshl_b32 s0, 0xff, s0
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX7-NEXT:    s_not_b32 s5, s0
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], s4, 2
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[2:3], s4, 3
; GFX7-NEXT:    s_mov_b32 s10, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v10, v3, 8, 8
; GFX7-NEXT:    v_bfe_u32 v12, v4, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 24, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 24, v4
; GFX7-NEXT:    v_and_b32_e32 v9, 0xff, v3
; GFX7-NEXT:    v_bfe_u32 v3, v3, 16, 8
; GFX7-NEXT:    v_and_b32_e32 v11, 0xff, v4
; GFX7-NEXT:    v_bfe_u32 v4, v4, 16, 8
; GFX7-NEXT:    v_bfe_u32 v14, v5, 8, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v10, 8, v10
; GFX7-NEXT:    v_lshlrev_b32_e32 v12, 8, v12
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 24, v5
; GFX7-NEXT:    v_and_b32_e32 v13, 0xff, v5
; GFX7-NEXT:    v_bfe_u32 v5, v5, 16, 8
; GFX7-NEXT:    v_bfe_u32 v16, v6, 8, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v14, 8, v14
; GFX7-NEXT:    v_or_b32_e32 v9, v9, v10
; GFX7-NEXT:    v_or_b32_e32 v10, v11, v12
; GFX7-NEXT:    v_lshrrev_b32_e32 v8, 24, v6
; GFX7-NEXT:    v_and_b32_e32 v15, 0xff, v6
; GFX7-NEXT:    v_bfe_u32 v6, v6, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v16, 8, v16
; GFX7-NEXT:    v_or_b32_e32 v11, v13, v14
; GFX7-NEXT:    v_or_b32_e32 v3, v9, v3
; GFX7-NEXT:    v_or_b32_e32 v4, v10, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX7-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX7-NEXT:    v_or_b32_e32 v12, v15, v16
; GFX7-NEXT:    v_or_b32_e32 v5, v11, v5
; GFX7-NEXT:    v_or_b32_e32 v1, v3, v1
; GFX7-NEXT:    v_or_b32_e32 v2, v4, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v8, 24, v8
; GFX7-NEXT:    v_or_b32_e32 v6, v12, v6
; GFX7-NEXT:    v_or_b32_e32 v3, v5, v7
; GFX7-NEXT:    v_cndmask_b32_e32 v5, v1, v2, vcc
; GFX7-NEXT:    v_or_b32_e32 v4, v6, v8
; GFX7-NEXT:    v_cndmask_b32_e64 v5, v5, v3, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v5, v5, v4, s[2:3]
; GFX7-NEXT:    v_and_b32_e32 v5, s5, v5
; GFX7-NEXT:    v_or_b32_e32 v0, v5, v0
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[4:5], s4, 0
; GFX7-NEXT:    v_cndmask_b32_e64 v1, v1, v0, s[4:5]
; GFX7-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v3, v0, s[0:1]
; GFX7-NEXT:    v_bfe_u32 v9, v1, 8, 8
; GFX7-NEXT:    v_bfe_u32 v11, v2, 8, 8
; GFX7-NEXT:    v_cndmask_b32_e64 v4, v4, v0, s[2:3]
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 24, v2
; GFX7-NEXT:    v_and_b32_e32 v8, 0xff, v1
; GFX7-NEXT:    v_bfe_u32 v1, v1, 16, 8
; GFX7-NEXT:    v_and_b32_e32 v10, 0xff, v2
; GFX7-NEXT:    v_bfe_u32 v2, v2, 16, 8
; GFX7-NEXT:    v_bfe_u32 v13, v3, 8, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v9, 8, v9
; GFX7-NEXT:    v_lshlrev_b32_e32 v11, 8, v11
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 24, v3
; GFX7-NEXT:    v_and_b32_e32 v12, 0xff, v3
; GFX7-NEXT:    v_bfe_u32 v3, v3, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v13, 8, v13
; GFX7-NEXT:    v_or_b32_e32 v8, v8, v9
; GFX7-NEXT:    v_or_b32_e32 v9, v10, v11
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 24, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_or_b32_e32 v10, v12, v13
; GFX7-NEXT:    v_or_b32_e32 v1, v8, v1
; GFX7-NEXT:    v_or_b32_e32 v2, v9, v2
; GFX7-NEXT:    v_or_b32_e32 v3, v10, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_or_b32_e32 v1, v2, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 24, v6
; GFX7-NEXT:    v_bfe_u32 v5, v4, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 24, v4
; GFX7-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX7-NEXT:    v_and_b32_e32 v3, 0xff, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 8, v5
; GFX7-NEXT:    v_bfe_u32 v4, v4, 16, 8
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v7
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v16i8_v_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dwordx4 v[3:6], v[0:1], off
; GFX10-NEXT:    s_mov_b32 s0, 8
; GFX10-NEXT:    v_mov_b32_e32 v0, 8
; GFX10-NEXT:    s_mov_b32 s1, 16
; GFX10-NEXT:    v_mov_b32_e32 v1, 16
; GFX10-NEXT:    s_lshr_b32 s3, s2, 2
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s3, 1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v7, 24, v3
; GFX10-NEXT:    v_lshrrev_b32_e32 v8, 24, v4
; GFX10-NEXT:    v_lshlrev_b32_sdwa v11, s0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v13, s0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v9, 24, v5
; GFX10-NEXT:    v_lshlrev_b32_sdwa v12, s1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v14, s1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v15, v0, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_and_or_b32 v3, v3, 0xff, v11
; GFX10-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX10-NEXT:    v_and_or_b32 v4, v4, 0xff, v13
; GFX10-NEXT:    v_lshlrev_b32_e32 v8, 24, v8
; GFX10-NEXT:    v_lshrrev_b32_e32 v10, 24, v6
; GFX10-NEXT:    v_lshlrev_b32_sdwa v16, v1, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v17, v0, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_and_or_b32 v5, 0xff, v5, v15
; GFX10-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; GFX10-NEXT:    v_or3_b32 v3, v3, v12, v7
; GFX10-NEXT:    v_or3_b32 v4, v4, v14, v8
; GFX10-NEXT:    v_lshlrev_b32_sdwa v11, v1, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v6, 0xff, v6, v17
; GFX10-NEXT:    v_lshlrev_b32_e32 v7, 24, v10
; GFX10-NEXT:    v_or3_b32 v5, v5, v16, v9
; GFX10-NEXT:    v_cndmask_b32_e32 v8, v3, v4, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, s3, 2
; GFX10-NEXT:    s_and_b32 s1, s2, 3
; GFX10-NEXT:    v_or3_b32 v6, v6, v11, v7
; GFX10-NEXT:    s_lshl_b32 s2, s1, 3
; GFX10-NEXT:    v_cmp_eq_u32_e64 s1, s3, 3
; GFX10-NEXT:    v_cndmask_b32_e64 v7, v8, v5, s0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, s2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX10-NEXT:    s_lshl_b32 s2, 0xff, s2
; GFX10-NEXT:    s_not_b32 s2, s2
; GFX10-NEXT:    v_cndmask_b32_e64 v7, v7, v6, s1
; GFX10-NEXT:    v_and_or_b32 v2, v7, s2, v2
; GFX10-NEXT:    v_cmp_eq_u32_e64 s2, s3, 0
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v4, v2, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v3, v2, s2
; GFX10-NEXT:    v_cndmask_b32_e64 v5, v5, v2, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v6, v2, s1
; GFX10-NEXT:    v_lshrrev_b32_e32 v7, 24, v4
; GFX10-NEXT:    v_lshrrev_b32_e32 v6, 24, v3
; GFX10-NEXT:    v_lshrrev_b32_e32 v8, 24, v5
; GFX10-NEXT:    v_lshrrev_b32_e32 v9, 24, v2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v10, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v12, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v14, v0, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v11, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v13, v1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v15, v1, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v16, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v1, 0xff, v3, v10
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 24, v6
; GFX10-NEXT:    v_and_or_b32 v6, 0xff, v4, v12
; GFX10-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX10-NEXT:    v_and_or_b32 v10, 0xff, v5, v14
; GFX10-NEXT:    v_lshlrev_b32_e32 v8, 24, v8
; GFX10-NEXT:    v_and_or_b32 v12, 0xff, v2, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; GFX10-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-NEXT:    v_mov_b32_e32 v5, 0
; GFX10-NEXT:    v_or3_b32 v0, v1, v11, v3
; GFX10-NEXT:    v_or3_b32 v1, v6, v13, v7
; GFX10-NEXT:    v_or3_b32 v2, v10, v15, v8
; GFX10-NEXT:    v_or3_b32 v3, v12, v16, v9
; GFX10-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX10-NEXT:    s_endpgm
  %vec = load <16 x i8>, <16 x i8> addrspace(1)* %ptr
  %insert = insertelement <16 x i8> %vec, i8 %val, i32 %idx
  store <16 x i8> %insert, <16 x i8> addrspace(1)* null
  ret void
}

define amdgpu_ps void @insertelement_v_v16i8_v_v(<16 x i8> addrspace(1)* %ptr, i8 %val, i32 %idx) {
; GFX9-LABEL: insertelement_v_v16i8_v_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx4 v[4:7], v[0:1], off
; GFX9-NEXT:    s_mov_b32 s0, 8
; GFX9-NEXT:    v_mov_b32_e32 v1, 8
; GFX9-NEXT:    s_mov_b32 s1, 16
; GFX9-NEXT:    s_movk_i32 s2, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v0, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v8, 16
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 24, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 24, v5
; GFX9-NEXT:    v_lshlrev_b32_sdwa v13, s0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v15, s0, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v17, v1, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v19, v1, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshrrev_b32_e32 v11, 24, v6
; GFX9-NEXT:    v_lshlrev_b32_sdwa v14, s1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v16, s1, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v18, v8, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v13, v4, s2, v13
; GFX9-NEXT:    v_and_or_b32 v15, v5, s2, v15
; GFX9-NEXT:    v_and_or_b32 v6, v6, v0, v17
; GFX9-NEXT:    v_and_or_b32 v17, v7, v0, v19
; GFX9-NEXT:    v_lshrrev_b32_e32 v19, 2, v3
; GFX9-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; GFX9-NEXT:    v_lshlrev_b32_e32 v10, 24, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v12, 24, v7
; GFX9-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX9-NEXT:    v_lshlrev_b32_e32 v11, 24, v11
; GFX9-NEXT:    v_or3_b32 v9, v13, v14, v9
; GFX9-NEXT:    v_or3_b32 v10, v15, v16, v10
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v19
; GFX9-NEXT:    v_lshlrev_b32_sdwa v7, v8, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX9-NEXT:    v_lshlrev_b32_e32 v12, 24, v12
; GFX9-NEXT:    v_or3_b32 v6, v6, v18, v11
; GFX9-NEXT:    v_cndmask_b32_e32 v11, v9, v10, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v19
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, v3, v0
; GFX9-NEXT:    v_or3_b32 v7, v17, v7, v12
; GFX9-NEXT:    v_cndmask_b32_e64 v11, v11, v6, s[0:1]
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v19
; GFX9-NEXT:    v_xor_b32_e32 v3, -1, v3
; GFX9-NEXT:    v_cndmask_b32_e64 v11, v11, v7, s[2:3]
; GFX9-NEXT:    v_and_or_b32 v2, v11, v3, v2
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v19
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v9, v2, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e32 v9, v10, v2, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v6, v6, v2, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v7, v2, s[2:3]
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 24, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v11, 24, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v12, 24, v2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v13, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v15, v1, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v17, v1, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v14, v8, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v16, v8, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v18, v8, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v8, v8, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v3, v3, v0, v13
; GFX9-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX9-NEXT:    v_and_or_b32 v9, v9, v0, v15
; GFX9-NEXT:    v_lshlrev_b32_e32 v10, 24, v10
; GFX9-NEXT:    v_and_or_b32 v6, v6, v0, v17
; GFX9-NEXT:    v_lshlrev_b32_e32 v11, 24, v11
; GFX9-NEXT:    v_and_or_b32 v13, v2, v0, v1
; GFX9-NEXT:    v_lshlrev_b32_e32 v12, 24, v12
; GFX9-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-NEXT:    v_or3_b32 v0, v3, v14, v7
; GFX9-NEXT:    v_or3_b32 v1, v9, v16, v10
; GFX9-NEXT:    v_or3_b32 v2, v6, v18, v11
; GFX9-NEXT:    v_or3_b32 v3, v13, v8, v12
; GFX9-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX9-NEXT:    s_endpgm
;
; GFX8-LABEL: insertelement_v_v16i8_v_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx4 v[4:7], v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v9, 8
; GFX8-NEXT:    v_mov_b32_e32 v1, 8
; GFX8-NEXT:    v_mov_b32_e32 v10, 16
; GFX8-NEXT:    v_mov_b32_e32 v8, 16
; GFX8-NEXT:    v_mov_b32_e32 v0, 0xff
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_sdwa v17, v9, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v19, v9, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v13, 24, v6
; GFX8-NEXT:    v_lshlrev_b32_sdwa v15, v1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v18, v10, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v6, v6, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v17, v7, v19 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshrrev_b32_e32 v19, 2, v3
; GFX8-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 24, v4
; GFX8-NEXT:    v_lshrrev_b32_e32 v12, 24, v5
; GFX8-NEXT:    v_lshrrev_b32_e32 v14, 24, v7
; GFX8-NEXT:    v_lshlrev_b32_sdwa v16, v8, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v8, v8, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v15, v4, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v1, v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, v3, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 24, v11
; GFX8-NEXT:    v_lshlrev_b32_e32 v11, 24, v12
; GFX8-NEXT:    v_lshlrev_b32_e32 v12, 24, v13
; GFX8-NEXT:    v_lshlrev_b32_e32 v13, 24, v14
; GFX8-NEXT:    v_or_b32_e32 v14, v15, v16
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v8
; GFX8-NEXT:    v_lshlrev_b32_sdwa v7, v10, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_e32 v6, v6, v18
; GFX8-NEXT:    v_or_b32_e32 v3, v14, v3
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v11
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v19
; GFX8-NEXT:    v_or_b32_e32 v7, v17, v7
; GFX8-NEXT:    v_or_b32_e32 v6, v6, v12
; GFX8-NEXT:    v_cndmask_b32_e32 v8, v3, v1, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v19
; GFX8-NEXT:    v_or_b32_e32 v7, v7, v13
; GFX8-NEXT:    v_cndmask_b32_e64 v8, v8, v6, s[0:1]
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v19
; GFX8-NEXT:    v_xor_b32_e32 v0, -1, v0
; GFX8-NEXT:    v_cndmask_b32_e64 v8, v8, v7, s[2:3]
; GFX8-NEXT:    v_and_b32_e32 v0, v8, v0
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v19
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v3, v0, s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v6, v0, s[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v7, v0, s[2:3]
; GFX8-NEXT:    v_lshlrev_b32_sdwa v12, v9, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v14, v9, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v16, v9, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v9, v9, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 24, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 24, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 24, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v13, v10, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v15, v10, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v17, v10, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v10, v10, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v2, v2, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v3, v3, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX8-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX8-NEXT:    v_lshlrev_b32_e32 v8, 24, v8
; GFX8-NEXT:    v_lshlrev_b32_e32 v9, 24, v11
; GFX8-NEXT:    v_or_b32_e32 v2, v2, v13
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v15
; GFX8-NEXT:    v_or_b32_e32 v3, v3, v17
; GFX8-NEXT:    v_or_b32_e32 v10, v0, v10
; GFX8-NEXT:    v_mov_b32_e32 v5, 0
; GFX8-NEXT:    v_or_b32_e32 v0, v2, v6
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v7
; GFX8-NEXT:    v_or_b32_e32 v2, v3, v8
; GFX8-NEXT:    v_or_b32_e32 v3, v10, v9
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: insertelement_v_v16i8_v_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, 0xf000
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[4:7], v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    v_lshrrev_b32_e32 v18, 2, v3
; GFX7-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v18
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[0:1], 2, v18
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v3, v2
; GFX7-NEXT:    v_lshl_b32_e32 v3, 0xff, v3
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[2:3], 3, v18
; GFX7-NEXT:    v_xor_b32_e32 v3, -1, v3
; GFX7-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v18
; GFX7-NEXT:    s_mov_b32 s10, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v11, v4, 8, 8
; GFX7-NEXT:    v_bfe_u32 v13, v5, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v4
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 24, v5
; GFX7-NEXT:    v_and_b32_e32 v10, 0xff, v4
; GFX7-NEXT:    v_bfe_u32 v4, v4, 16, 8
; GFX7-NEXT:    v_and_b32_e32 v12, 0xff, v5
; GFX7-NEXT:    v_bfe_u32 v5, v5, 16, 8
; GFX7-NEXT:    v_bfe_u32 v15, v6, 8, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v11, 8, v11
; GFX7-NEXT:    v_lshlrev_b32_e32 v13, 8, v13
; GFX7-NEXT:    v_lshrrev_b32_e32 v8, 24, v6
; GFX7-NEXT:    v_and_b32_e32 v14, 0xff, v6
; GFX7-NEXT:    v_bfe_u32 v6, v6, 16, 8
; GFX7-NEXT:    v_bfe_u32 v17, v7, 8, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v15, 8, v15
; GFX7-NEXT:    v_or_b32_e32 v10, v10, v11
; GFX7-NEXT:    v_or_b32_e32 v11, v12, v13
; GFX7-NEXT:    v_lshrrev_b32_e32 v9, 24, v7
; GFX7-NEXT:    v_and_b32_e32 v16, 0xff, v7
; GFX7-NEXT:    v_bfe_u32 v7, v7, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX7-NEXT:    v_lshlrev_b32_e32 v17, 8, v17
; GFX7-NEXT:    v_or_b32_e32 v12, v14, v15
; GFX7-NEXT:    v_or_b32_e32 v4, v10, v4
; GFX7-NEXT:    v_or_b32_e32 v5, v11, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v8, 24, v8
; GFX7-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; GFX7-NEXT:    v_or_b32_e32 v13, v16, v17
; GFX7-NEXT:    v_or_b32_e32 v6, v12, v6
; GFX7-NEXT:    v_or_b32_e32 v0, v4, v0
; GFX7-NEXT:    v_or_b32_e32 v1, v5, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; GFX7-NEXT:    v_or_b32_e32 v7, v13, v7
; GFX7-NEXT:    v_or_b32_e32 v4, v6, v8
; GFX7-NEXT:    v_cndmask_b32_e32 v6, v0, v1, vcc
; GFX7-NEXT:    v_or_b32_e32 v5, v7, v9
; GFX7-NEXT:    v_cndmask_b32_e64 v6, v6, v4, s[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v6, v6, v5, s[2:3]
; GFX7-NEXT:    v_and_b32_e32 v3, v6, v3
; GFX7-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[4:5]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v4, v2, s[0:1]
; GFX7-NEXT:    v_bfe_u32 v9, v0, 8, 8
; GFX7-NEXT:    v_bfe_u32 v11, v1, 8, 8
; GFX7-NEXT:    v_cndmask_b32_e64 v4, v5, v2, s[2:3]
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v8, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_and_b32_e32 v10, 0xff, v1
; GFX7-NEXT:    v_bfe_u32 v1, v1, 16, 8
; GFX7-NEXT:    v_bfe_u32 v13, v3, 8, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v9, 8, v9
; GFX7-NEXT:    v_lshlrev_b32_e32 v11, 8, v11
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 24, v3
; GFX7-NEXT:    v_and_b32_e32 v12, 0xff, v3
; GFX7-NEXT:    v_bfe_u32 v3, v3, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v13, 8, v13
; GFX7-NEXT:    v_or_b32_e32 v8, v8, v9
; GFX7-NEXT:    v_or_b32_e32 v9, v10, v11
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 24, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_or_b32_e32 v10, v12, v13
; GFX7-NEXT:    v_or_b32_e32 v0, v8, v0
; GFX7-NEXT:    v_or_b32_e32 v1, v9, v1
; GFX7-NEXT:    v_or_b32_e32 v3, v10, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 24, v6
; GFX7-NEXT:    v_bfe_u32 v5, v4, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 24, v4
; GFX7-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX7-NEXT:    v_and_b32_e32 v3, 0xff, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 8, v5
; GFX7-NEXT:    v_bfe_u32 v4, v4, 16, 8
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v7
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; GFX7-NEXT:    s_endpgm
;
; GFX10-LABEL: insertelement_v_v16i8_v_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dwordx4 v[4:7], v[0:1], off
; GFX10-NEXT:    s_mov_b32 s0, 8
; GFX10-NEXT:    v_mov_b32_e32 v1, 8
; GFX10-NEXT:    s_mov_b32 s1, 16
; GFX10-NEXT:    v_and_b32_e32 v0, 3, v3
; GFX10-NEXT:    v_mov_b32_e32 v8, 16
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 2, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v3
; GFX10-NEXT:    v_cmp_eq_u32_e64 s2, 0, v3
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v9, 24, v4
; GFX10-NEXT:    v_lshrrev_b32_e32 v10, 24, v5
; GFX10-NEXT:    v_lshlrev_b32_sdwa v13, s0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v15, s0, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v11, 24, v6
; GFX10-NEXT:    v_lshlrev_b32_sdwa v14, s1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v16, s1, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v17, v1, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_and_or_b32 v4, v4, 0xff, v13
; GFX10-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; GFX10-NEXT:    v_and_or_b32 v5, v5, 0xff, v15
; GFX10-NEXT:    v_lshlrev_b32_e32 v10, 24, v10
; GFX10-NEXT:    v_lshrrev_b32_e32 v12, 24, v7
; GFX10-NEXT:    v_lshlrev_b32_sdwa v18, v8, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v19, v1, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_and_or_b32 v6, 0xff, v6, v17
; GFX10-NEXT:    v_lshlrev_b32_e32 v11, 24, v11
; GFX10-NEXT:    v_or3_b32 v4, v4, v14, v9
; GFX10-NEXT:    v_or3_b32 v5, v5, v16, v10
; GFX10-NEXT:    v_lshlrev_b32_sdwa v13, v8, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v7, 0xff, v7, v19
; GFX10-NEXT:    v_lshlrev_b32_e32 v9, 24, v12
; GFX10-NEXT:    v_or3_b32 v6, v6, v18, v11
; GFX10-NEXT:    v_cndmask_b32_e32 v10, v4, v5, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e64 s0, 2, v3
; GFX10-NEXT:    v_lshlrev_b32_e64 v11, v0, 0xff
; GFX10-NEXT:    v_or3_b32 v7, v7, v13, v9
; GFX10-NEXT:    v_cmp_eq_u32_e64 s1, 3, v3
; GFX10-NEXT:    v_lshlrev_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX10-NEXT:    v_cndmask_b32_e64 v9, v10, v6, s0
; GFX10-NEXT:    v_xor_b32_e32 v2, -1, v11
; GFX10-NEXT:    v_cndmask_b32_e64 v9, v9, v7, s1
; GFX10-NEXT:    v_and_or_b32 v0, v9, v2, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v4, v0, s2
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v5, v0, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v4, v6, v0, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v7, v0, s1
; GFX10-NEXT:    v_lshrrev_b32_e32 v5, 24, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v6, 24, v3
; GFX10-NEXT:    v_lshrrev_b32_e32 v7, 24, v4
; GFX10-NEXT:    v_lshrrev_b32_e32 v9, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v10, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v12, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v14, v1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v11, v8, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v13, v8, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v15, v8, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v8, v8, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v2, 0xff, v2, v10
; GFX10-NEXT:    v_lshlrev_b32_e32 v10, 24, v5
; GFX10-NEXT:    v_and_or_b32 v3, 0xff, v3, v12
; GFX10-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX10-NEXT:    v_and_or_b32 v12, 0xff, v4, v14
; GFX10-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX10-NEXT:    v_and_or_b32 v14, 0xff, v0, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; GFX10-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-NEXT:    v_mov_b32_e32 v5, 0
; GFX10-NEXT:    v_or3_b32 v0, v2, v11, v10
; GFX10-NEXT:    v_or3_b32 v1, v3, v13, v6
; GFX10-NEXT:    v_or3_b32 v2, v12, v15, v7
; GFX10-NEXT:    v_or3_b32 v3, v14, v8, v9
; GFX10-NEXT:    global_store_dwordx4 v[4:5], v[0:3], off
; GFX10-NEXT:    s_endpgm
  %vec = load <16 x i8>, <16 x i8> addrspace(1)* %ptr
  %insert = insertelement <16 x i8> %vec, i8 %val, i32 %idx
  store <16 x i8> %insert, <16 x i8> addrspace(1)* null
  ret void
}
