; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f | FileCheck %s --check-prefix=AVX512F
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vl,+fast-variable-shuffle | FileCheck %s --check-prefix=AVX512VL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+avx512vl,+avx512dq,+fast-variable-shuffle | FileCheck %s --check-prefix=VL_BW_DQ

define <2 x i1> @shuf2i1_1_0(<2 x i1> %a) {
; AVX512F-LABEL: shuf2i1_1_0:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsllq $63, %xmm0, %xmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vpternlogq $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,3,0,1]
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vpternlogq $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: shuf2i1_1_0:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsllq $63, %xmm0, %xmm0
; AVX512VL-NEXT:    vptestmq %xmm0, %xmm0, %k1
; AVX512VL-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX512VL-NEXT:    vmovdqa64 %xmm0, %xmm1 {%k1} {z}
; AVX512VL-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,3,0,1]
; AVX512VL-NEXT:    vptestmq %xmm1, %xmm1, %k1
; AVX512VL-NEXT:    vmovdqa64 %xmm0, %xmm0 {%k1} {z}
; AVX512VL-NEXT:    retq
;
; VL_BW_DQ-LABEL: shuf2i1_1_0:
; VL_BW_DQ:       # %bb.0:
; VL_BW_DQ-NEXT:    vpsllq $63, %xmm0, %xmm0
; VL_BW_DQ-NEXT:    vpmovq2m %xmm0, %k0
; VL_BW_DQ-NEXT:    vpmovm2q %k0, %xmm0
; VL_BW_DQ-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,3,0,1]
; VL_BW_DQ-NEXT:    vpmovq2m %xmm0, %k0
; VL_BW_DQ-NEXT:    vpmovm2q %k0, %xmm0
; VL_BW_DQ-NEXT:    retq
  %b = shufflevector <2 x i1> %a, <2 x i1> undef, <2 x i32> <i32 1, i32 0>
  ret <2 x i1> %b
}

define <2 x i1> @shuf2i1_1_2(<2 x i1> %a) {
; AVX512F-LABEL: shuf2i1_1_2:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsllq $63, %xmm0, %xmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vpternlogq $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm1 = [18446744073709551615,0]
; AVX512F-NEXT:    vpalignr {{.*#+}} xmm0 = xmm0[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vpternlogq $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: shuf2i1_1_2:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsllq $63, %xmm0, %xmm0
; AVX512VL-NEXT:    vptestmq %xmm0, %xmm0, %k1
; AVX512VL-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX512VL-NEXT:    vmovdqa64 %xmm0, %xmm1 {%k1} {z}
; AVX512VL-NEXT:    vmovdqa {{.*#+}} xmm2 = [18446744073709551615,0]
; AVX512VL-NEXT:    vpalignr {{.*#+}} xmm1 = xmm1[8,9,10,11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7]
; AVX512VL-NEXT:    vptestmq %xmm1, %xmm1, %k1
; AVX512VL-NEXT:    vmovdqa64 %xmm0, %xmm0 {%k1} {z}
; AVX512VL-NEXT:    retq
;
; VL_BW_DQ-LABEL: shuf2i1_1_2:
; VL_BW_DQ:       # %bb.0:
; VL_BW_DQ-NEXT:    vpsllq $63, %xmm0, %xmm0
; VL_BW_DQ-NEXT:    vpmovq2m %xmm0, %k0
; VL_BW_DQ-NEXT:    vpmovm2q %k0, %xmm0
; VL_BW_DQ-NEXT:    vmovdqa {{.*#+}} xmm1 = [18446744073709551615,0]
; VL_BW_DQ-NEXT:    vpalignr {{.*#+}} xmm0 = xmm0[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; VL_BW_DQ-NEXT:    vpmovq2m %xmm0, %k0
; VL_BW_DQ-NEXT:    vpmovm2q %k0, %xmm0
; VL_BW_DQ-NEXT:    retq
  %b = shufflevector <2 x i1> %a, <2 x i1> <i1 1, i1 0>, <2 x i32> <i32 1, i32 2>
  ret <2 x i1> %b
}


define <4 x i1> @shuf4i1_3_2_10(<4 x i1> %a) {
; AVX512F-LABEL: shuf4i1_3_2_10:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[3,2,1,0]
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: shuf4i1_3_2_10:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512VL-NEXT:    vptestmd %xmm0, %xmm0, %k1
; AVX512VL-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX512VL-NEXT:    vmovdqa32 %xmm0, %xmm1 {%k1} {z}
; AVX512VL-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[3,2,1,0]
; AVX512VL-NEXT:    vptestmd %xmm1, %xmm1, %k1
; AVX512VL-NEXT:    vmovdqa32 %xmm0, %xmm0 {%k1} {z}
; AVX512VL-NEXT:    retq
;
; VL_BW_DQ-LABEL: shuf4i1_3_2_10:
; VL_BW_DQ:       # %bb.0:
; VL_BW_DQ-NEXT:    vpslld $31, %xmm0, %xmm0
; VL_BW_DQ-NEXT:    vpmovd2m %xmm0, %k0
; VL_BW_DQ-NEXT:    vpmovm2d %k0, %xmm0
; VL_BW_DQ-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[3,2,1,0]
; VL_BW_DQ-NEXT:    vpmovd2m %xmm0, %k0
; VL_BW_DQ-NEXT:    vpmovm2d %k0, %xmm0
; VL_BW_DQ-NEXT:    retq
  %b = shufflevector <4 x i1> %a, <4 x i1> undef, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  ret <4 x i1> %b
}

define <8 x i1> @shuf8i1_3_6_1_0_3_7_7_0(<8 x i64> %a, <8 x i64> %b, <8 x i64> %a1, <8 x i64> %b1) {
; AVX512F-LABEL: shuf8i1_3_6_1_0_3_7_7_0:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpcmpeqq %zmm2, %zmm0, %k1
; AVX512F-NEXT:    vpternlogq $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [3,6,1,0,3,7,7,0]
; AVX512F-NEXT:    vpermq %zmm0, %zmm1, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: shuf8i1_3_6_1_0_3_7_7_0:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpcmpeqq %zmm2, %zmm0, %k1
; AVX512VL-NEXT:    vpcmpeqd %ymm0, %ymm0, %ymm0
; AVX512VL-NEXT:    vmovdqa32 %ymm0, %ymm1 {%k1} {z}
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm2 = [3,6,1,0,3,7,7,0]
; AVX512VL-NEXT:    vpermd %ymm1, %ymm2, %ymm1
; AVX512VL-NEXT:    vptestmd %ymm1, %ymm1, %k1
; AVX512VL-NEXT:    vmovdqa32 %ymm0, %ymm0 {%k1} {z}
; AVX512VL-NEXT:    vpmovdw %ymm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; VL_BW_DQ-LABEL: shuf8i1_3_6_1_0_3_7_7_0:
; VL_BW_DQ:       # %bb.0:
; VL_BW_DQ-NEXT:    vpcmpeqq %zmm2, %zmm0, %k0
; VL_BW_DQ-NEXT:    vpmovm2d %k0, %ymm0
; VL_BW_DQ-NEXT:    vmovdqa {{.*#+}} ymm1 = [3,6,1,0,3,7,7,0]
; VL_BW_DQ-NEXT:    vpermd %ymm0, %ymm1, %ymm0
; VL_BW_DQ-NEXT:    vpmovd2m %ymm0, %k0
; VL_BW_DQ-NEXT:    vpmovm2w %k0, %xmm0
; VL_BW_DQ-NEXT:    vzeroupper
; VL_BW_DQ-NEXT:    retq
  %a2 = icmp eq <8 x i64> %a, %a1
  %b2 = icmp eq <8 x i64> %b, %b1
  %c = shufflevector <8 x i1> %a2, <8 x i1> %b2, <8 x i32> <i32 3, i32 6, i32 1, i32 0, i32 3, i32 7, i32 7, i32 0>
  ret <8 x i1> %c
}

define <16 x i1> @shuf16i1_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0(<16 x i32> %a, <16 x i32> %b, <16 x i32> %a1, <16 x i32> %b1) {
; AVX512F-LABEL: shuf16i1_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpcmpeqd %zmm2, %zmm0, %k1
; AVX512F-NEXT:    vpcmpeqd %zmm3, %zmm1, %k2
; AVX512F-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k2} {z}
; AVX512F-NEXT:    vpternlogd $255, %zmm1, %zmm1, %zmm1 {%k1} {z}
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [3,6,22,12,3,7,7,0,3,6,1,13,3,21,7,0]
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm1, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: shuf16i1_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpcmpeqd %zmm2, %zmm0, %k1
; AVX512VL-NEXT:    vpcmpeqd %zmm3, %zmm1, %k2
; AVX512VL-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k2} {z}
; AVX512VL-NEXT:    vpternlogd $255, %zmm1, %zmm1, %zmm1 {%k1} {z}
; AVX512VL-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [3,6,22,12,3,7,7,0,3,6,1,13,3,21,7,0]
; AVX512VL-NEXT:    vpermi2d %zmm0, %zmm1, %zmm2
; AVX512VL-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512VL-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512VL-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; VL_BW_DQ-LABEL: shuf16i1_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0:
; VL_BW_DQ:       # %bb.0:
; VL_BW_DQ-NEXT:    vpcmpeqd %zmm2, %zmm0, %k0
; VL_BW_DQ-NEXT:    vpcmpeqd %zmm3, %zmm1, %k1
; VL_BW_DQ-NEXT:    vpmovm2d %k1, %zmm0
; VL_BW_DQ-NEXT:    vpmovm2d %k0, %zmm1
; VL_BW_DQ-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [3,6,22,12,3,7,7,0,3,6,1,13,3,21,7,0]
; VL_BW_DQ-NEXT:    vpermi2d %zmm0, %zmm1, %zmm2
; VL_BW_DQ-NEXT:    vpmovd2m %zmm2, %k0
; VL_BW_DQ-NEXT:    vpmovm2b %k0, %xmm0
; VL_BW_DQ-NEXT:    vzeroupper
; VL_BW_DQ-NEXT:    retq
  %a2 = icmp eq <16 x i32> %a, %a1
  %b2 = icmp eq <16 x i32> %b, %b1
  %c = shufflevector <16 x i1> %a2, <16 x i1> %b2, <16 x i32> <i32 3, i32 6, i32 22, i32 12, i32 3, i32 7, i32 7, i32 0, i32 3, i32 6, i32 1, i32 13, i32 3, i32 21, i32 7, i32 0>
  ret <16 x i1> %c
}

define <32 x i1> @shuf32i1_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0(<32 x i1> %a) {
; AVX512F-LABEL: shuf32i1_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpmovsxbd %xmm0, %zmm1
; AVX512F-NEXT:    vpslld $31, %zmm1, %zmm1
; AVX512F-NEXT:    vptestmd %zmm1, %zmm1, %k1
; AVX512F-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512F-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512F-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k2
; AVX512F-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k2} {z}
; AVX512F-NEXT:    vpternlogd $255, %zmm1, %zmm1, %zmm1 {%k1} {z}
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [3,6,22,12,3,7,7,0,3,6,1,13,3,21,7,0]
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm1, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512F-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: shuf32i1_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxbd %xmm0, %zmm1
; AVX512VL-NEXT:    vpslld $31, %zmm1, %zmm1
; AVX512VL-NEXT:    vptestmd %zmm1, %zmm1, %k1
; AVX512VL-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512VL-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512VL-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512VL-NEXT:    vptestmd %zmm0, %zmm0, %k2
; AVX512VL-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k2} {z}
; AVX512VL-NEXT:    vpternlogd $255, %zmm1, %zmm1, %zmm1 {%k1} {z}
; AVX512VL-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [3,6,22,12,3,7,7,0,3,6,1,13,3,21,7,0]
; AVX512VL-NEXT:    vpermi2d %zmm0, %zmm1, %zmm2
; AVX512VL-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512VL-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512VL-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512VL-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; VL_BW_DQ-LABEL: shuf32i1_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0:
; VL_BW_DQ:       # %bb.0:
; VL_BW_DQ-NEXT:    vpsllw $7, %ymm0, %ymm0
; VL_BW_DQ-NEXT:    vpmovb2m %ymm0, %k0
; VL_BW_DQ-NEXT:    vpmovm2w %k0, %zmm0
; VL_BW_DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [3,6,22,12,3,7,7,0,3,6,1,13,3,21,7,0,3,6,22,12,3,7,7,0,3,6,1,13,3,21,7,0]
; VL_BW_DQ-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; VL_BW_DQ-NEXT:    vpermw %zmm0, %zmm1, %zmm0
; VL_BW_DQ-NEXT:    vpmovw2m %zmm0, %k0
; VL_BW_DQ-NEXT:    vpmovm2b %k0, %ymm0
; VL_BW_DQ-NEXT:    retq
  %b = shufflevector <32 x i1> %a, <32 x i1> undef, <32 x i32> <i32 3, i32 6, i32 22, i32 12, i32 3, i32 7, i32 7, i32 0, i32 3, i32 6, i32 1, i32 13, i32 3, i32 21, i32 7, i32 0, i32 3, i32 6, i32 22, i32 12, i32 3, i32 7, i32 7, i32 0, i32 3, i32 6, i32 1, i32 13, i32 3, i32 21, i32 7, i32 0>
  ret <32 x i1> %b
}

define <32 x i16> @shuf32i1_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_icmp_v32i16(<32 x i16> %a, <32 x i16> %c, <32 x i16> %d) {
; AVX512F-LABEL: shuf32i1_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_icmp_v32i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512F-NEXT:    vpcmpeqw %ymm3, %ymm0, %ymm4
; AVX512F-NEXT:    vpmovsxwd %ymm4, %zmm4
; AVX512F-NEXT:    vptestmd %zmm4, %zmm4, %k1
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm0
; AVX512F-NEXT:    vpcmpeqw %ymm3, %ymm0, %ymm0
; AVX512F-NEXT:    vpmovsxwd %ymm0, %zmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k2
; AVX512F-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k2} {z}
; AVX512F-NEXT:    vpternlogd $255, %zmm3, %zmm3, %zmm3 {%k1} {z}
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [3,6,22,12,3,7,7,0,3,6,1,13,3,21,7,0]
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm3, %zmm4
; AVX512F-NEXT:    vptestmd %zmm4, %zmm4, %k1
; AVX512F-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; AVX512F-NEXT:    vpternlogq $202, %zmm2, %zmm1, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: shuf32i1_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_icmp_v32i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512VL-NEXT:    vpcmpeqw %ymm3, %ymm0, %ymm4
; AVX512VL-NEXT:    vpmovsxwd %ymm4, %zmm4
; AVX512VL-NEXT:    vptestmd %zmm4, %zmm4, %k1
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm0
; AVX512VL-NEXT:    vpcmpeqw %ymm3, %ymm0, %ymm0
; AVX512VL-NEXT:    vpmovsxwd %ymm0, %zmm0
; AVX512VL-NEXT:    vptestmd %zmm0, %zmm0, %k2
; AVX512VL-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k2} {z}
; AVX512VL-NEXT:    vpternlogd $255, %zmm3, %zmm3, %zmm3 {%k1} {z}
; AVX512VL-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [3,6,22,12,3,7,7,0,3,6,1,13,3,21,7,0]
; AVX512VL-NEXT:    vpermi2d %zmm0, %zmm3, %zmm4
; AVX512VL-NEXT:    vptestmd %zmm4, %zmm4, %k1
; AVX512VL-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512VL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; AVX512VL-NEXT:    vpternlogq $202, %zmm2, %zmm1, %zmm0
; AVX512VL-NEXT:    retq
;
; VL_BW_DQ-LABEL: shuf32i1_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_icmp_v32i16:
; VL_BW_DQ:       # %bb.0:
; VL_BW_DQ-NEXT:    vptestnmw %zmm0, %zmm0, %k0
; VL_BW_DQ-NEXT:    vpmovm2w %k0, %zmm0
; VL_BW_DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [3,6,22,12,3,7,7,0,3,6,1,13,3,21,7,0,3,6,22,12,3,7,7,0,3,6,1,13,3,21,7,0]
; VL_BW_DQ-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; VL_BW_DQ-NEXT:    vpermw %zmm0, %zmm3, %zmm0
; VL_BW_DQ-NEXT:    vpmovw2m %zmm0, %k1
; VL_BW_DQ-NEXT:    vpblendmw %zmm1, %zmm2, %zmm0 {%k1}
; VL_BW_DQ-NEXT:    retq
  %cmp = icmp eq <32 x i16> %a, zeroinitializer
  %shuf = shufflevector <32 x i1> %cmp, <32 x i1> undef, <32 x i32> <i32 3, i32 6, i32 22, i32 12, i32 3, i32 7, i32 7, i32 0, i32 3, i32 6, i32 1, i32 13, i32 3, i32 21, i32 7, i32 0, i32 3, i32 6, i32 22, i32 12, i32 3, i32 7, i32 7, i32 0, i32 3, i32 6, i32 1, i32 13, i32 3, i32 21, i32 7, i32 0>
  %sel = select <32 x i1> %shuf, <32 x i16> %c, <32 x i16> %d
  ret <32 x i16> %sel
}

define <32 x i8> @shuf32i1_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_icmp_v32i8(<32 x i8> %a, <32 x i8> %c, <32 x i8> %d) {
; AVX512F-LABEL: shuf32i1_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_icmp_v32i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512F-NEXT:    vpcmpeqb %ymm3, %ymm0, %ymm0
; AVX512F-NEXT:    vpmovsxbd %xmm0, %zmm3
; AVX512F-NEXT:    vptestmd %zmm3, %zmm3, %k1
; AVX512F-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512F-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k2
; AVX512F-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k2} {z}
; AVX512F-NEXT:    vpternlogd $255, %zmm3, %zmm3, %zmm3 {%k1} {z}
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [3,6,22,12,3,7,7,0,3,6,1,13,3,21,7,0]
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm3, %zmm4
; AVX512F-NEXT:    vptestmd %zmm4, %zmm4, %k1
; AVX512F-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512F-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-NEXT:    vpblendvb %ymm0, %ymm1, %ymm2, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: shuf32i1_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_icmp_v32i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512VL-NEXT:    vpcmpeqb %ymm3, %ymm0, %ymm0
; AVX512VL-NEXT:    vpmovsxbd %xmm0, %zmm3
; AVX512VL-NEXT:    vptestmd %zmm3, %zmm3, %k1
; AVX512VL-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512VL-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512VL-NEXT:    vptestmd %zmm0, %zmm0, %k2
; AVX512VL-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k2} {z}
; AVX512VL-NEXT:    vpternlogd $255, %zmm3, %zmm3, %zmm3 {%k1} {z}
; AVX512VL-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [3,6,22,12,3,7,7,0,3,6,1,13,3,21,7,0]
; AVX512VL-NEXT:    vpermi2d %zmm0, %zmm3, %zmm4
; AVX512VL-NEXT:    vptestmd %zmm4, %zmm4, %k1
; AVX512VL-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512VL-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512VL-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512VL-NEXT:    vpblendvb %ymm0, %ymm1, %ymm2, %ymm0
; AVX512VL-NEXT:    retq
;
; VL_BW_DQ-LABEL: shuf32i1_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_icmp_v32i8:
; VL_BW_DQ:       # %bb.0:
; VL_BW_DQ-NEXT:    vptestnmb %ymm0, %ymm0, %k0
; VL_BW_DQ-NEXT:    vpmovm2w %k0, %zmm0
; VL_BW_DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [3,6,22,12,3,7,7,0,3,6,1,13,3,21,7,0,3,6,22,12,3,7,7,0,3,6,1,13,3,21,7,0]
; VL_BW_DQ-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; VL_BW_DQ-NEXT:    vpermw %zmm0, %zmm3, %zmm0
; VL_BW_DQ-NEXT:    vpmovw2m %zmm0, %k1
; VL_BW_DQ-NEXT:    vpblendmb %ymm1, %ymm2, %ymm0 {%k1}
; VL_BW_DQ-NEXT:    retq
  %cmp = icmp eq <32 x i8> %a, zeroinitializer
  %shuf = shufflevector <32 x i1> %cmp, <32 x i1> undef, <32 x i32> <i32 3, i32 6, i32 22, i32 12, i32 3, i32 7, i32 7, i32 0, i32 3, i32 6, i32 1, i32 13, i32 3, i32 21, i32 7, i32 0, i32 3, i32 6, i32 22, i32 12, i32 3, i32 7, i32 7, i32 0, i32 3, i32 6, i32 1, i32 13, i32 3, i32 21, i32 7, i32 0>
  %sel = select <32 x i1> %shuf, <32 x i8> %c, <32 x i8> %d
  ret <32 x i8> %sel
}

define <32 x i16> @shuf32i1_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_icmp_v32i16_split(<16 x i32> %a, <16 x i32> %b, <32 x i16> %c, <32 x i16> %d) {
; AVX512F-LABEL: shuf32i1_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_icmp_v32i16_split:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vptestnmd %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vptestnmd %zmm1, %zmm1, %k2
; AVX512F-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k2} {z}
; AVX512F-NEXT:    vpternlogd $255, %zmm1, %zmm1, %zmm1 {%k1} {z}
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [3,6,22,12,3,7,7,0,3,6,1,13,3,21,7,0]
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm1, %zmm4
; AVX512F-NEXT:    vptestmd %zmm4, %zmm4, %k1
; AVX512F-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; AVX512F-NEXT:    vpternlogq $202, %zmm3, %zmm2, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: shuf32i1_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_icmp_v32i16_split:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vptestnmd %zmm0, %zmm0, %k1
; AVX512VL-NEXT:    vptestnmd %zmm1, %zmm1, %k2
; AVX512VL-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k2} {z}
; AVX512VL-NEXT:    vpternlogd $255, %zmm1, %zmm1, %zmm1 {%k1} {z}
; AVX512VL-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [3,6,22,12,3,7,7,0,3,6,1,13,3,21,7,0]
; AVX512VL-NEXT:    vpermi2d %zmm0, %zmm1, %zmm4
; AVX512VL-NEXT:    vptestmd %zmm4, %zmm4, %k1
; AVX512VL-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512VL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; AVX512VL-NEXT:    vpternlogq $202, %zmm3, %zmm2, %zmm0
; AVX512VL-NEXT:    retq
;
; VL_BW_DQ-LABEL: shuf32i1_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_icmp_v32i16_split:
; VL_BW_DQ:       # %bb.0:
; VL_BW_DQ-NEXT:    vptestnmd %zmm0, %zmm0, %k0
; VL_BW_DQ-NEXT:    vptestnmd %zmm1, %zmm1, %k1
; VL_BW_DQ-NEXT:    kunpckwd %k0, %k1, %k0
; VL_BW_DQ-NEXT:    vpmovm2w %k0, %zmm0
; VL_BW_DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [3,6,22,12,3,7,7,0,3,6,1,13,3,21,7,0,3,6,22,12,3,7,7,0,3,6,1,13,3,21,7,0]
; VL_BW_DQ-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; VL_BW_DQ-NEXT:    vpermw %zmm0, %zmm1, %zmm0
; VL_BW_DQ-NEXT:    vpmovw2m %zmm0, %k1
; VL_BW_DQ-NEXT:    vpblendmw %zmm2, %zmm3, %zmm0 {%k1}
; VL_BW_DQ-NEXT:    retq
  %cmp1 = icmp eq <16 x i32> %a, zeroinitializer
  %cmp2 = icmp eq <16 x i32> %b, zeroinitializer
  %concat = shufflevector <16 x i1> %cmp1, <16 x i1> %cmp2, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %shuf = shufflevector <32 x i1> %concat, <32 x i1> undef, <32 x i32> <i32 3, i32 6, i32 22, i32 12, i32 3, i32 7, i32 7, i32 0, i32 3, i32 6, i32 1, i32 13, i32 3, i32 21, i32 7, i32 0, i32 3, i32 6, i32 22, i32 12, i32 3, i32 7, i32 7, i32 0, i32 3, i32 6, i32 1, i32 13, i32 3, i32 21, i32 7, i32 0>
  %sel = select <32 x i1> %shuf, <32 x i16> %c, <32 x i16> %d
  ret <32 x i16> %sel
}

define <32 x i8> @shuf32i1_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_icmp_v32i8_split(<16 x i32> %a, <16 x i32> %b, <32 x i8> %c, <32 x i8> %d) {
; AVX512F-LABEL: shuf32i1_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_icmp_v32i8_split:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vptestnmd %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vptestnmd %zmm1, %zmm1, %k2
; AVX512F-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k2} {z}
; AVX512F-NEXT:    vpternlogd $255, %zmm1, %zmm1, %zmm1 {%k1} {z}
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [3,6,22,12,3,7,7,0,3,6,1,13,3,21,7,0]
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm1, %zmm4
; AVX512F-NEXT:    vptestmd %zmm4, %zmm4, %k1
; AVX512F-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512F-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-NEXT:    vpblendvb %ymm0, %ymm2, %ymm3, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: shuf32i1_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_icmp_v32i8_split:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vptestnmd %zmm0, %zmm0, %k1
; AVX512VL-NEXT:    vptestnmd %zmm1, %zmm1, %k2
; AVX512VL-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k2} {z}
; AVX512VL-NEXT:    vpternlogd $255, %zmm1, %zmm1, %zmm1 {%k1} {z}
; AVX512VL-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [3,6,22,12,3,7,7,0,3,6,1,13,3,21,7,0]
; AVX512VL-NEXT:    vpermi2d %zmm0, %zmm1, %zmm4
; AVX512VL-NEXT:    vptestmd %zmm4, %zmm4, %k1
; AVX512VL-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512VL-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512VL-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512VL-NEXT:    vpblendvb %ymm0, %ymm2, %ymm3, %ymm0
; AVX512VL-NEXT:    retq
;
; VL_BW_DQ-LABEL: shuf32i1_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_3_6_22_12_3_7_7_0_3_6_1_13_3_21_7_0_icmp_v32i8_split:
; VL_BW_DQ:       # %bb.0:
; VL_BW_DQ-NEXT:    vptestnmd %zmm0, %zmm0, %k0
; VL_BW_DQ-NEXT:    vptestnmd %zmm1, %zmm1, %k1
; VL_BW_DQ-NEXT:    kunpckwd %k0, %k1, %k0
; VL_BW_DQ-NEXT:    vpmovm2w %k0, %zmm0
; VL_BW_DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [3,6,22,12,3,7,7,0,3,6,1,13,3,21,7,0,3,6,22,12,3,7,7,0,3,6,1,13,3,21,7,0]
; VL_BW_DQ-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; VL_BW_DQ-NEXT:    vpermw %zmm0, %zmm1, %zmm0
; VL_BW_DQ-NEXT:    vpmovw2m %zmm0, %k1
; VL_BW_DQ-NEXT:    vpblendmb %ymm2, %ymm3, %ymm0 {%k1}
; VL_BW_DQ-NEXT:    retq
  %cmp1 = icmp eq <16 x i32> %a, zeroinitializer
  %cmp2 = icmp eq <16 x i32> %b, zeroinitializer
  %concat = shufflevector <16 x i1> %cmp1, <16 x i1> %cmp2, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %shuf = shufflevector <32 x i1> %concat, <32 x i1> undef, <32 x i32> <i32 3, i32 6, i32 22, i32 12, i32 3, i32 7, i32 7, i32 0, i32 3, i32 6, i32 1, i32 13, i32 3, i32 21, i32 7, i32 0, i32 3, i32 6, i32 22, i32 12, i32 3, i32 7, i32 7, i32 0, i32 3, i32 6, i32 1, i32 13, i32 3, i32 21, i32 7, i32 0>
  %sel = select <32 x i1> %shuf, <32 x i8> %c, <32 x i8> %d
  ret <32 x i8> %sel
}

define <8 x i1> @shuf8i1_u_2_u_u_2_u_2_u(i8 %a) {
; AVX512F-LABEL: shuf8i1_u_2_u_u_2_u_2_u:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    vpternlogq $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512F-NEXT:    vpbroadcastq %xmm0, %zmm0
; AVX512F-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: shuf8i1_u_2_u_u_2_u_2_u:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    kmovw %edi, %k1
; AVX512VL-NEXT:    vpcmpeqd %ymm0, %ymm0, %ymm0
; AVX512VL-NEXT:    vmovdqa32 %ymm0, %ymm1 {%k1} {z}
; AVX512VL-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX512VL-NEXT:    vpbroadcastq %xmm1, %ymm1
; AVX512VL-NEXT:    vpslld $31, %ymm1, %ymm1
; AVX512VL-NEXT:    vptestmd %ymm1, %ymm1, %k1
; AVX512VL-NEXT:    vmovdqa32 %ymm0, %ymm0 {%k1} {z}
; AVX512VL-NEXT:    vpmovdw %ymm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; VL_BW_DQ-LABEL: shuf8i1_u_2_u_u_2_u_2_u:
; VL_BW_DQ:       # %bb.0:
; VL_BW_DQ-NEXT:    kmovd %edi, %k0
; VL_BW_DQ-NEXT:    vpmovm2d %k0, %ymm0
; VL_BW_DQ-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; VL_BW_DQ-NEXT:    vpbroadcastq %xmm0, %ymm0
; VL_BW_DQ-NEXT:    vpmovd2m %ymm0, %k0
; VL_BW_DQ-NEXT:    vpmovm2w %k0, %xmm0
; VL_BW_DQ-NEXT:    vzeroupper
; VL_BW_DQ-NEXT:    retq
  %b = bitcast i8 %a to <8 x i1>
  %c = shufflevector < 8 x i1> %b, <8 x i1>undef, <8 x i32> <i32 undef, i32 2, i32 undef, i32 undef, i32 2, i32 undef, i32 2, i32 undef>
  ret <8 x i1> %c
}

define i8 @shuf8i1_10_2_9_u_3_u_2_u(i8 %a) {
; AVX512F-LABEL: shuf8i1_10_2_9_u_3_u_2_u:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    vpternlogq $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm2 = <8,2,10,u,3,u,2,u>
; AVX512F-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512F-NEXT:    vpsllq $63, %zmm2, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    # kill: def $al killed $al killed $eax
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: shuf8i1_10_2_9_u_3_u_2_u:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    kmovw %edi, %k1
; AVX512VL-NEXT:    vpcmpeqd %ymm0, %ymm0, %ymm0
; AVX512VL-NEXT:    vmovdqa32 %ymm0, %ymm0 {%k1} {z}
; AVX512VL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm2 = [8,2,10,3,3,2,2,3]
; AVX512VL-NEXT:    vpermi2d %ymm1, %ymm0, %ymm2
; AVX512VL-NEXT:    vpslld $31, %ymm2, %ymm0
; AVX512VL-NEXT:    vptestmd %ymm0, %ymm0, %k0
; AVX512VL-NEXT:    kmovw %k0, %eax
; AVX512VL-NEXT:    # kill: def $al killed $al killed $eax
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; VL_BW_DQ-LABEL: shuf8i1_10_2_9_u_3_u_2_u:
; VL_BW_DQ:       # %bb.0:
; VL_BW_DQ-NEXT:    kmovd %edi, %k0
; VL_BW_DQ-NEXT:    vpmovm2d %k0, %ymm0
; VL_BW_DQ-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; VL_BW_DQ-NEXT:    vmovdqa {{.*#+}} ymm2 = [8,2,10,3,3,2,2,3]
; VL_BW_DQ-NEXT:    vpermi2d %ymm1, %ymm0, %ymm2
; VL_BW_DQ-NEXT:    vpmovd2m %ymm2, %k0
; VL_BW_DQ-NEXT:    kmovd %k0, %eax
; VL_BW_DQ-NEXT:    # kill: def $al killed $al killed $eax
; VL_BW_DQ-NEXT:    vzeroupper
; VL_BW_DQ-NEXT:    retq
  %b = bitcast i8 %a to <8 x i1>
  %c = shufflevector < 8 x i1> %b, <8 x i1> zeroinitializer, <8 x i32> <i32 10, i32 2, i32 9, i32 undef, i32 3, i32 undef, i32 2, i32 undef>
  %d = bitcast <8 x i1> %c to i8
  ret i8 %d
}

define i8 @shuf8i1_0_1_4_5_u_u_u_u(i8 %a) {
; AVX512F-LABEL: shuf8i1_0_1_4_5_u_u_u_u:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    vpternlogq $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vshufi64x2 {{.*#+}} zmm0 = zmm0[0,1,4,5,0,1,0,1]
; AVX512F-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    # kill: def $al killed $al killed $eax
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: shuf8i1_0_1_4_5_u_u_u_u:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    kmovw %edi, %k1
; AVX512VL-NEXT:    vpcmpeqd %ymm0, %ymm0, %ymm0
; AVX512VL-NEXT:    vmovdqa32 %ymm0, %ymm0 {%k1} {z}
; AVX512VL-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX512VL-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX512VL-NEXT:    vptestmd %ymm0, %ymm0, %k0
; AVX512VL-NEXT:    kmovw %k0, %eax
; AVX512VL-NEXT:    # kill: def $al killed $al killed $eax
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; VL_BW_DQ-LABEL: shuf8i1_0_1_4_5_u_u_u_u:
; VL_BW_DQ:       # %bb.0:
; VL_BW_DQ-NEXT:    kmovd %edi, %k0
; VL_BW_DQ-NEXT:    vpmovm2d %k0, %ymm0
; VL_BW_DQ-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; VL_BW_DQ-NEXT:    vpmovd2m %ymm0, %k0
; VL_BW_DQ-NEXT:    kmovd %k0, %eax
; VL_BW_DQ-NEXT:    # kill: def $al killed $al killed $eax
; VL_BW_DQ-NEXT:    vzeroupper
; VL_BW_DQ-NEXT:    retq
  %b = bitcast i8 %a to <8 x i1>
  %c = shufflevector < 8 x i1> %b, <8 x i1> undef, <8 x i32> <i32 0, i32 1, i32 4, i32 5, i32 undef, i32 undef, i32 undef, i32 undef>
  %d = bitcast <8 x i1> %c to i8
  ret i8 %d
}

define i8 @shuf8i1_9_6_1_0_3_7_7_0(i8 %a) {
; AVX512F-LABEL: shuf8i1_9_6_1_0_3_7_7_0:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    vpternlogq $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [8,6,1,0,3,7,7,0]
; AVX512F-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512F-NEXT:    vptestmq %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    # kill: def $al killed $al killed $eax
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: shuf8i1_9_6_1_0_3_7_7_0:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    kmovw %edi, %k1
; AVX512VL-NEXT:    vpcmpeqd %ymm0, %ymm0, %ymm0
; AVX512VL-NEXT:    vmovdqa32 %ymm0, %ymm0 {%k1} {z}
; AVX512VL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm2 = [8,6,1,0,3,7,7,0]
; AVX512VL-NEXT:    vpermi2d %ymm1, %ymm0, %ymm2
; AVX512VL-NEXT:    vptestmd %ymm2, %ymm2, %k0
; AVX512VL-NEXT:    kmovw %k0, %eax
; AVX512VL-NEXT:    # kill: def $al killed $al killed $eax
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; VL_BW_DQ-LABEL: shuf8i1_9_6_1_0_3_7_7_0:
; VL_BW_DQ:       # %bb.0:
; VL_BW_DQ-NEXT:    kmovd %edi, %k0
; VL_BW_DQ-NEXT:    vpmovm2d %k0, %ymm0
; VL_BW_DQ-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; VL_BW_DQ-NEXT:    vmovdqa {{.*#+}} ymm2 = [8,6,1,0,3,7,7,0]
; VL_BW_DQ-NEXT:    vpermi2d %ymm1, %ymm0, %ymm2
; VL_BW_DQ-NEXT:    vpmovd2m %ymm2, %k0
; VL_BW_DQ-NEXT:    kmovd %k0, %eax
; VL_BW_DQ-NEXT:    # kill: def $al killed $al killed $eax
; VL_BW_DQ-NEXT:    vzeroupper
; VL_BW_DQ-NEXT:    retq
  %b = bitcast i8 %a to <8 x i1>
  %c = shufflevector <8 x i1> %b, <8 x i1> zeroinitializer, <8 x i32> <i32 9, i32 6, i32 1, i32 0, i32 3, i32 7, i32 7, i32 0>
  %d = bitcast <8 x i1>%c to i8
  ret i8 %d
}

define i8 @shuf8i1_9_6_1_10_3_7_7_0(i8 %a) {
; AVX512F-LABEL: shuf8i1_9_6_1_10_3_7_7_0:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    vpternlogq $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [9,1,2,10,4,5,6,7]
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpermt2q %zmm0, %zmm1, %zmm2
; AVX512F-NEXT:    vptestmq %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    # kill: def $al killed $al killed $eax
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: shuf8i1_9_6_1_10_3_7_7_0:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    kmovw %edi, %k1
; AVX512VL-NEXT:    vpcmpeqd %ymm0, %ymm0, %ymm0
; AVX512VL-NEXT:    vmovdqa32 %ymm0, %ymm0 {%k1} {z}
; AVX512VL-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[4,5,6,7],zero,zero,zero,zero,zero,zero,zero,zero,ymm0[8,9,10,11],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512VL-NEXT:    vptestmd %ymm0, %ymm0, %k0
; AVX512VL-NEXT:    kmovw %k0, %eax
; AVX512VL-NEXT:    # kill: def $al killed $al killed $eax
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; VL_BW_DQ-LABEL: shuf8i1_9_6_1_10_3_7_7_0:
; VL_BW_DQ:       # %bb.0:
; VL_BW_DQ-NEXT:    kmovd %edi, %k0
; VL_BW_DQ-NEXT:    vpmovm2d %k0, %ymm0
; VL_BW_DQ-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[4,5,6,7],zero,zero,zero,zero,zero,zero,zero,zero,ymm0[8,9,10,11],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; VL_BW_DQ-NEXT:    vpmovd2m %ymm0, %k0
; VL_BW_DQ-NEXT:    kmovd %k0, %eax
; VL_BW_DQ-NEXT:    # kill: def $al killed $al killed $eax
; VL_BW_DQ-NEXT:    vzeroupper
; VL_BW_DQ-NEXT:    retq
  %b = bitcast i8 %a to <8 x i1>
  %c = shufflevector <8 x i1> zeroinitializer, <8 x i1> %b, <8 x i32> <i32 9, i32 6, i32 1, i32 10, i32 3, i32 7, i32 7, i32 0>
  %d = bitcast <8 x i1>%c to i8
  ret i8 %d
}

define i8 @shuf8i1__9_6_1_10_3_7_7_1(i8 %a) {
; AVX512F-LABEL: shuf8i1__9_6_1_10_3_7_7_1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    vpternlogq $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [9,6,1,0,3,7,7,1]
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [18446744073709551615,18446744073709551615,0,0,0,0,0,0]
; AVX512F-NEXT:    vpermt2q %zmm0, %zmm1, %zmm2
; AVX512F-NEXT:    vptestmq %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    # kill: def $al killed $al killed $eax
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: shuf8i1__9_6_1_10_3_7_7_1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    kmovw %edi, %k1
; AVX512VL-NEXT:    vpcmpeqd %ymm0, %ymm0, %ymm0
; AVX512VL-NEXT:    vmovdqa32 %ymm0, %ymm0 {%k1} {z}
; AVX512VL-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,2,3]
; AVX512VL-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],mem[1,2,3,4,5,6,7]
; AVX512VL-NEXT:    vptestmd %ymm0, %ymm0, %k0
; AVX512VL-NEXT:    kmovw %k0, %eax
; AVX512VL-NEXT:    # kill: def $al killed $al killed $eax
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; VL_BW_DQ-LABEL: shuf8i1__9_6_1_10_3_7_7_1:
; VL_BW_DQ:       # %bb.0:
; VL_BW_DQ-NEXT:    kmovd %edi, %k0
; VL_BW_DQ-NEXT:    vpmovm2d %k0, %ymm0
; VL_BW_DQ-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,2,3]
; VL_BW_DQ-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],mem[1,2,3,4,5,6,7]
; VL_BW_DQ-NEXT:    vpmovd2m %ymm0, %k0
; VL_BW_DQ-NEXT:    kmovd %k0, %eax
; VL_BW_DQ-NEXT:    # kill: def $al killed $al killed $eax
; VL_BW_DQ-NEXT:    vzeroupper
; VL_BW_DQ-NEXT:    retq
  %b = bitcast i8 %a to <8 x i1>
  %c = shufflevector <8 x i1> <i1 1, i1 1, i1 0, i1 0, i1 1, i1 1, i1 0, i1 0>, <8 x i1> %b, <8 x i32> <i32 9, i32 6, i32 1, i32 0, i32 3, i32 7, i32 7, i32 1>
  %c1 = bitcast <8 x i1>%c to i8
  ret i8 %c1
}

define i8 @shuf8i1_9_6_1_10_3_7_7_0_all_ones(<8 x i1> %a) {
; AVX512F-LABEL: shuf8i1_9_6_1_10_3_7_7_0_all_ones:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512F-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vpternlogq $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [9,1,2,3,4,5,6,7]
; AVX512F-NEXT:    vpternlogd $255, %zmm2, %zmm2, %zmm2
; AVX512F-NEXT:    vpermt2q %zmm0, %zmm1, %zmm2
; AVX512F-NEXT:    vptestmq %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    # kill: def $al killed $al killed $eax
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: shuf8i1_9_6_1_10_3_7_7_0_all_ones:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxwd %xmm0, %ymm0
; AVX512VL-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX512VL-NEXT:    vptestmd %ymm0, %ymm0, %k1
; AVX512VL-NEXT:    vpcmpeqd %ymm0, %ymm0, %ymm0
; AVX512VL-NEXT:    vmovdqa32 %ymm0, %ymm1 {%k1} {z}
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm2 = [9,1,2,3,4,5,6,7]
; AVX512VL-NEXT:    vpermi2d %ymm1, %ymm0, %ymm2
; AVX512VL-NEXT:    vptestmd %ymm2, %ymm2, %k0
; AVX512VL-NEXT:    kmovw %k0, %eax
; AVX512VL-NEXT:    # kill: def $al killed $al killed $eax
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; VL_BW_DQ-LABEL: shuf8i1_9_6_1_10_3_7_7_0_all_ones:
; VL_BW_DQ:       # %bb.0:
; VL_BW_DQ-NEXT:    vpsllw $15, %xmm0, %xmm0
; VL_BW_DQ-NEXT:    vpmovw2m %xmm0, %k0
; VL_BW_DQ-NEXT:    vpmovm2d %k0, %ymm0
; VL_BW_DQ-NEXT:    vmovdqa {{.*#+}} ymm1 = [9,1,2,3,4,5,6,7]
; VL_BW_DQ-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; VL_BW_DQ-NEXT:    vpermt2d %ymm0, %ymm1, %ymm2
; VL_BW_DQ-NEXT:    vpmovd2m %ymm2, %k0
; VL_BW_DQ-NEXT:    kmovd %k0, %eax
; VL_BW_DQ-NEXT:    # kill: def $al killed $al killed $eax
; VL_BW_DQ-NEXT:    vzeroupper
; VL_BW_DQ-NEXT:    retq
  %c = shufflevector <8 x i1> <i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1>, <8 x i1> %a, <8 x i32> <i32 9, i32 6, i32 1, i32 0, i32 3, i32 7, i32 7, i32 0>
  %c1 = bitcast <8 x i1>%c to i8
  ret i8 %c1
}


define i16 @shuf16i1_0_0_0_0_0_0_0_0_0_0_0_0_0_0_0_0(i16 %a) {
; AVX512F-LABEL: shuf16i1_0_0_0_0_0_0_0_0_0_0_0_0_0_0_0_0:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpbroadcastd %xmm0, %zmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    # kill: def $ax killed $ax killed $eax
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: shuf16i1_0_0_0_0_0_0_0_0_0_0_0_0_0_0_0_0:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    kmovw %edi, %k1
; AVX512VL-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512VL-NEXT:    vpbroadcastd %xmm0, %zmm0
; AVX512VL-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512VL-NEXT:    kmovw %k0, %eax
; AVX512VL-NEXT:    # kill: def $ax killed $ax killed $eax
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; VL_BW_DQ-LABEL: shuf16i1_0_0_0_0_0_0_0_0_0_0_0_0_0_0_0_0:
; VL_BW_DQ:       # %bb.0:
; VL_BW_DQ-NEXT:    kmovd %edi, %k0
; VL_BW_DQ-NEXT:    vpmovm2d %k0, %zmm0
; VL_BW_DQ-NEXT:    vpbroadcastd %xmm0, %zmm0
; VL_BW_DQ-NEXT:    vpmovd2m %zmm0, %k0
; VL_BW_DQ-NEXT:    kmovd %k0, %eax
; VL_BW_DQ-NEXT:    # kill: def $ax killed $ax killed $eax
; VL_BW_DQ-NEXT:    vzeroupper
; VL_BW_DQ-NEXT:    retq
  %b = bitcast i16 %a to <16 x i1>
  %c = shufflevector < 16 x i1> %b, <16 x i1> undef, <16 x i32> zeroinitializer
  %d = bitcast <16 x i1> %c to i16
  ret i16 %d
}

define i64 @shuf64i1_zero(i64 %a) {
; AVX512F-LABEL: shuf64i1_zero:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpbroadcastd %xmm0, %zmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    kmovw %k0, %ecx
; AVX512F-NEXT:    shll $16, %ecx
; AVX512F-NEXT:    orl %eax, %ecx
; AVX512F-NEXT:    movq %rcx, %rax
; AVX512F-NEXT:    shlq $32, %rax
; AVX512F-NEXT:    orq %rcx, %rax
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: shuf64i1_zero:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    kmovw %edi, %k1
; AVX512VL-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512VL-NEXT:    vpbroadcastd %xmm0, %zmm0
; AVX512VL-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512VL-NEXT:    kmovw %k0, %eax
; AVX512VL-NEXT:    kmovw %k0, %ecx
; AVX512VL-NEXT:    shll $16, %ecx
; AVX512VL-NEXT:    orl %eax, %ecx
; AVX512VL-NEXT:    movq %rcx, %rax
; AVX512VL-NEXT:    shlq $32, %rax
; AVX512VL-NEXT:    orq %rcx, %rax
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; VL_BW_DQ-LABEL: shuf64i1_zero:
; VL_BW_DQ:       # %bb.0:
; VL_BW_DQ-NEXT:    kmovq %rdi, %k0
; VL_BW_DQ-NEXT:    vpmovm2b %k0, %zmm0
; VL_BW_DQ-NEXT:    vpbroadcastb %xmm0, %zmm0
; VL_BW_DQ-NEXT:    vpmovb2m %zmm0, %k0
; VL_BW_DQ-NEXT:    kmovq %k0, %rax
; VL_BW_DQ-NEXT:    vzeroupper
; VL_BW_DQ-NEXT:    retq
  %b = bitcast i64 %a to <64 x i1>
  %c = shufflevector < 64 x i1> %b, <64 x i1> undef, <64 x i32> zeroinitializer
  %d = bitcast <64 x i1> %c to i64
  ret i64 %d
}
