; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mcpu=x86-64 -mattr=+sse2 | FileCheck %s --check-prefixes=CHECK,SSE,SSE2
; RUN: llc < %s -mcpu=x86-64 -mattr=+ssse3 | FileCheck %s --check-prefixes=CHECK,SSE,SSSE3
; RUN: llc < %s -mcpu=x86-64 -mattr=+sse4.1 | FileCheck %s --check-prefixes=CHECK,SSE,SSE41
; RUN: llc < %s -mcpu=x86-64 -mattr=+avx | FileCheck %s --check-prefixes=CHECK,AVX,AVX1
; RUN: llc < %s -mcpu=x86-64 -mattr=+avx2 | FileCheck %s --check-prefixes=CHECK,AVX,AVX2,AVX2-SLOW
; RUN: llc < %s -mcpu=x86-64 -mattr=+avx2,+fast-variable-shuffle | FileCheck %s --check-prefixes=CHECK,AVX,AVX2,AVX2-FAST
;
; Verify that the DAG combiner correctly folds bitwise operations across
; shuffles, nested shuffles with undef, pairs of nested shuffles, and other
; basic and always-safe patterns. Also test that the DAG combiner will combine
; target-specific shuffle instructions where reasonable.

target triple = "x86_64-unknown-unknown"

declare <4 x i32> @llvm.x86.sse2.pshuf.d(<4 x i32>, i8)
declare <8 x i16> @llvm.x86.sse2.pshufl.w(<8 x i16>, i8)
declare <8 x i16> @llvm.x86.sse2.pshufh.w(<8 x i16>, i8)

define <4 x i32> @combine_pshufd1(<4 x i32> %a) {
; CHECK-LABEL: combine_pshufd1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    retq
entry:
  %b = call <4 x i32> @llvm.x86.sse2.pshuf.d(<4 x i32> %a, i8 27)
  %c = call <4 x i32> @llvm.x86.sse2.pshuf.d(<4 x i32> %b, i8 27)
  ret <4 x i32> %c
}

define <4 x i32> @combine_pshufd2(<4 x i32> %a) {
; CHECK-LABEL: combine_pshufd2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    retq
entry:
  %b = call <4 x i32> @llvm.x86.sse2.pshuf.d(<4 x i32> %a, i8 27)
  %b.cast = bitcast <4 x i32> %b to <8 x i16>
  %c = call <8 x i16> @llvm.x86.sse2.pshufl.w(<8 x i16> %b.cast, i8 -28)
  %c.cast = bitcast <8 x i16> %c to <4 x i32>
  %d = call <4 x i32> @llvm.x86.sse2.pshuf.d(<4 x i32> %c.cast, i8 27)
  ret <4 x i32> %d
}

define <4 x i32> @combine_pshufd3(<4 x i32> %a) {
; CHECK-LABEL: combine_pshufd3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    retq
entry:
  %b = call <4 x i32> @llvm.x86.sse2.pshuf.d(<4 x i32> %a, i8 27)
  %b.cast = bitcast <4 x i32> %b to <8 x i16>
  %c = call <8 x i16> @llvm.x86.sse2.pshufh.w(<8 x i16> %b.cast, i8 -28)
  %c.cast = bitcast <8 x i16> %c to <4 x i32>
  %d = call <4 x i32> @llvm.x86.sse2.pshuf.d(<4 x i32> %c.cast, i8 27)
  ret <4 x i32> %d
}

define <4 x i32> @combine_pshufd4(<4 x i32> %a) {
; SSE-LABEL: combine_pshufd4:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,7,6,5,4]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_pshufd4:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,7,6,5,4]
; AVX-NEXT:    retq
entry:
  %b = call <4 x i32> @llvm.x86.sse2.pshuf.d(<4 x i32> %a, i8 -31)
  %b.cast = bitcast <4 x i32> %b to <8 x i16>
  %c = call <8 x i16> @llvm.x86.sse2.pshufh.w(<8 x i16> %b.cast, i8 27)
  %c.cast = bitcast <8 x i16> %c to <4 x i32>
  %d = call <4 x i32> @llvm.x86.sse2.pshuf.d(<4 x i32> %c.cast, i8 -31)
  ret <4 x i32> %d
}

define <4 x i32> @combine_pshufd5(<4 x i32> %a) {
; SSE-LABEL: combine_pshufd5:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,2,1,0,4,5,6,7]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_pshufd5:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[3,2,1,0,4,5,6,7]
; AVX-NEXT:    retq
entry:
  %b = call <4 x i32> @llvm.x86.sse2.pshuf.d(<4 x i32> %a, i8 -76)
  %b.cast = bitcast <4 x i32> %b to <8 x i16>
  %c = call <8 x i16> @llvm.x86.sse2.pshufl.w(<8 x i16> %b.cast, i8 27)
  %c.cast = bitcast <8 x i16> %c to <4 x i32>
  %d = call <4 x i32> @llvm.x86.sse2.pshuf.d(<4 x i32> %c.cast, i8 -76)
  ret <4 x i32> %d
}

define <4 x i32> @combine_pshufd6(<4 x i32> %a) {
; SSE-LABEL: combine_pshufd6:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE-NEXT:    retq
;
; AVX1-LABEL: combine_pshufd6:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,0,0,0]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: combine_pshufd6:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vbroadcastss %xmm0, %xmm0
; AVX2-NEXT:    retq
entry:
  %b = call <4 x i32> @llvm.x86.sse2.pshuf.d(<4 x i32> %a, i8 0)
  %c = call <4 x i32> @llvm.x86.sse2.pshuf.d(<4 x i32> %b, i8 8)
  ret <4 x i32> %c
}

define <8 x i16> @combine_pshuflw1(<8 x i16> %a) {
; CHECK-LABEL: combine_pshuflw1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    retq
entry:
  %b = call <8 x i16> @llvm.x86.sse2.pshufl.w(<8 x i16> %a, i8 27)
  %c = call <8 x i16> @llvm.x86.sse2.pshufl.w(<8 x i16> %b, i8 27)
  ret <8 x i16> %c
}

define <8 x i16> @combine_pshuflw2(<8 x i16> %a) {
; CHECK-LABEL: combine_pshuflw2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    retq
entry:
  %b = call <8 x i16> @llvm.x86.sse2.pshufl.w(<8 x i16> %a, i8 27)
  %c = call <8 x i16> @llvm.x86.sse2.pshufh.w(<8 x i16> %b, i8 -28)
  %d = call <8 x i16> @llvm.x86.sse2.pshufl.w(<8 x i16> %c, i8 27)
  ret <8 x i16> %d
}

define <8 x i16> @combine_pshuflw3(<8 x i16> %a) {
; SSE-LABEL: combine_pshuflw3:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,7,6,5,4]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_pshuflw3:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,7,6,5,4]
; AVX-NEXT:    retq
entry:
  %b = call <8 x i16> @llvm.x86.sse2.pshufl.w(<8 x i16> %a, i8 27)
  %c = call <8 x i16> @llvm.x86.sse2.pshufh.w(<8 x i16> %b, i8 27)
  %d = call <8 x i16> @llvm.x86.sse2.pshufl.w(<8 x i16> %c, i8 27)
  ret <8 x i16> %d
}

define <8 x i16> @combine_pshufhw1(<8 x i16> %a) {
; SSE-LABEL: combine_pshufhw1:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,2,1,0,4,5,6,7]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_pshufhw1:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[3,2,1,0,4,5,6,7]
; AVX-NEXT:    retq
entry:
  %b = call <8 x i16> @llvm.x86.sse2.pshufh.w(<8 x i16> %a, i8 27)
  %c = call <8 x i16> @llvm.x86.sse2.pshufl.w(<8 x i16> %b, i8 27)
  %d = call <8 x i16> @llvm.x86.sse2.pshufh.w(<8 x i16> %c, i8 27)
  ret <8 x i16> %d
}

define <4 x i32> @combine_bitwise_ops_test1(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; SSE-LABEL: combine_bitwise_ops_test1:
; SSE:       # %bb.0:
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_bitwise_ops_test1:
; AVX:       # %bb.0:
; AVX-NEXT:    vandps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX-NEXT:    retq
  %shuf1 = shufflevector <4 x i32> %a, <4 x i32> %c, <4 x i32><i32 0, i32 2, i32 1, i32 3>
  %shuf2 = shufflevector <4 x i32> %b, <4 x i32> %c, <4 x i32><i32 0, i32 2, i32 1, i32 3>
  %and = and <4 x i32> %shuf1, %shuf2
  ret <4 x i32> %and
}

define <4 x i32> @combine_bitwise_ops_test2(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; SSE-LABEL: combine_bitwise_ops_test2:
; SSE:       # %bb.0:
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_bitwise_ops_test2:
; AVX:       # %bb.0:
; AVX-NEXT:    vorps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX-NEXT:    retq
  %shuf1 = shufflevector <4 x i32> %a, <4 x i32> %c, <4 x i32><i32 0, i32 2, i32 1, i32 3>
  %shuf2 = shufflevector <4 x i32> %b, <4 x i32> %c, <4 x i32><i32 0, i32 2, i32 1, i32 3>
  %or = or <4 x i32> %shuf1, %shuf2
  ret <4 x i32> %or
}

define <4 x i32> @combine_bitwise_ops_test3(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; SSE-LABEL: combine_bitwise_ops_test3:
; SSE:       # %bb.0:
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_bitwise_ops_test3:
; AVX:       # %bb.0:
; AVX-NEXT:    vxorps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX-NEXT:    retq
  %shuf1 = shufflevector <4 x i32> %a, <4 x i32> %c, <4 x i32><i32 0, i32 2, i32 1, i32 3>
  %shuf2 = shufflevector <4 x i32> %b, <4 x i32> %c, <4 x i32><i32 0, i32 2, i32 1, i32 3>
  %xor = xor <4 x i32> %shuf1, %shuf2
  ret <4 x i32> %xor
}

define <4 x i32> @combine_bitwise_ops_test4(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; SSE-LABEL: combine_bitwise_ops_test4:
; SSE:       # %bb.0:
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_bitwise_ops_test4:
; AVX:       # %bb.0:
; AVX-NEXT:    vandps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX-NEXT:    retq
  %shuf1 = shufflevector <4 x i32> %c, <4 x i32> %a, <4 x i32><i32 4, i32 6, i32 5, i32 7>
  %shuf2 = shufflevector <4 x i32> %c, <4 x i32> %b, <4 x i32><i32 4, i32 6, i32 5, i32 7>
  %and = and <4 x i32> %shuf1, %shuf2
  ret <4 x i32> %and
}

define <4 x i32> @combine_bitwise_ops_test5(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; SSE-LABEL: combine_bitwise_ops_test5:
; SSE:       # %bb.0:
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_bitwise_ops_test5:
; AVX:       # %bb.0:
; AVX-NEXT:    vorps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX-NEXT:    retq
  %shuf1 = shufflevector <4 x i32> %c, <4 x i32> %a, <4 x i32><i32 4, i32 6, i32 5, i32 7>
  %shuf2 = shufflevector <4 x i32> %c, <4 x i32> %b, <4 x i32><i32 4, i32 6, i32 5, i32 7>
  %or = or <4 x i32> %shuf1, %shuf2
  ret <4 x i32> %or
}

define <4 x i32> @combine_bitwise_ops_test6(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; SSE-LABEL: combine_bitwise_ops_test6:
; SSE:       # %bb.0:
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_bitwise_ops_test6:
; AVX:       # %bb.0:
; AVX-NEXT:    vxorps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX-NEXT:    retq
  %shuf1 = shufflevector <4 x i32> %c, <4 x i32> %a, <4 x i32><i32 4, i32 6, i32 5, i32 7>
  %shuf2 = shufflevector <4 x i32> %c, <4 x i32> %b, <4 x i32><i32 4, i32 6, i32 5, i32 7>
  %xor = xor <4 x i32> %shuf1, %shuf2
  ret <4 x i32> %xor
}


; Verify that DAGCombiner moves the shuffle after the xor/and/or even if shuffles
; are not performing a swizzle operations.

define <4 x i32> @combine_bitwise_ops_test1b(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; SSE2-LABEL: combine_bitwise_ops_test1b:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,3,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_bitwise_ops_test1b:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    pand %xmm1, %xmm0
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,3,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_bitwise_ops_test1b:
; SSE41:       # %bb.0:
; SSE41-NEXT:    andps %xmm1, %xmm0
; SSE41-NEXT:    blendps {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_bitwise_ops_test1b:
; AVX:       # %bb.0:
; AVX-NEXT:    vandps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3]
; AVX-NEXT:    retq
  %shuf1 = shufflevector <4 x i32> %a, <4 x i32> %c, <4 x i32><i32 0, i32 5, i32 2, i32 7>
  %shuf2 = shufflevector <4 x i32> %b, <4 x i32> %c, <4 x i32><i32 0, i32 5, i32 2, i32 7>
  %and = and <4 x i32> %shuf1, %shuf2
  ret <4 x i32> %and
}

define <4 x i32> @combine_bitwise_ops_test2b(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; SSE2-LABEL: combine_bitwise_ops_test2b:
; SSE2:       # %bb.0:
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,3,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_bitwise_ops_test2b:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    por %xmm1, %xmm0
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,3,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_bitwise_ops_test2b:
; SSE41:       # %bb.0:
; SSE41-NEXT:    orps %xmm1, %xmm0
; SSE41-NEXT:    blendps {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_bitwise_ops_test2b:
; AVX:       # %bb.0:
; AVX-NEXT:    vorps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3]
; AVX-NEXT:    retq
  %shuf1 = shufflevector <4 x i32> %a, <4 x i32> %c, <4 x i32><i32 0, i32 5, i32 2, i32 7>
  %shuf2 = shufflevector <4 x i32> %b, <4 x i32> %c, <4 x i32><i32 0, i32 5, i32 2, i32 7>
  %or = or <4 x i32> %shuf1, %shuf2
  ret <4 x i32> %or
}

define <4 x i32> @combine_bitwise_ops_test3b(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; SSE2-LABEL: combine_bitwise_ops_test3b:
; SSE2:       # %bb.0:
; SSE2-NEXT:    xorps %xmm1, %xmm0
; SSE2-NEXT:    andps {{.*}}(%rip), %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_bitwise_ops_test3b:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    xorps %xmm1, %xmm0
; SSSE3-NEXT:    andps {{.*}}(%rip), %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_bitwise_ops_test3b:
; SSE41:       # %bb.0:
; SSE41-NEXT:    xorps %xmm1, %xmm0
; SSE41-NEXT:    xorps %xmm1, %xmm1
; SSE41-NEXT:    blendps {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2],xmm1[3]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_bitwise_ops_test3b:
; AVX:       # %bb.0:
; AVX-NEXT:    vxorps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2],xmm1[3]
; AVX-NEXT:    retq
  %shuf1 = shufflevector <4 x i32> %a, <4 x i32> %c, <4 x i32><i32 0, i32 5, i32 2, i32 7>
  %shuf2 = shufflevector <4 x i32> %b, <4 x i32> %c, <4 x i32><i32 0, i32 5, i32 2, i32 7>
  %xor = xor <4 x i32> %shuf1, %shuf2
  ret <4 x i32> %xor
}

define <4 x i32> @combine_bitwise_ops_test4b(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; SSE2-LABEL: combine_bitwise_ops_test4b:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,3,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_bitwise_ops_test4b:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    pand %xmm1, %xmm0
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,3,2,3]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,2,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_bitwise_ops_test4b:
; SSE41:       # %bb.0:
; SSE41-NEXT:    andps %xmm1, %xmm0
; SSE41-NEXT:    blendps {{.*#+}} xmm0 = xmm2[0],xmm0[1],xmm2[2],xmm0[3]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_bitwise_ops_test4b:
; AVX:       # %bb.0:
; AVX-NEXT:    vandps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm2[0],xmm0[1],xmm2[2],xmm0[3]
; AVX-NEXT:    retq
  %shuf1 = shufflevector <4 x i32> %c, <4 x i32> %a, <4 x i32><i32 0, i32 5, i32 2, i32 7>
  %shuf2 = shufflevector <4 x i32> %c, <4 x i32> %b, <4 x i32><i32 0, i32 5, i32 2, i32 7>
  %and = and <4 x i32> %shuf1, %shuf2
  ret <4 x i32> %and
}

define <4 x i32> @combine_bitwise_ops_test5b(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; SSE2-LABEL: combine_bitwise_ops_test5b:
; SSE2:       # %bb.0:
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,3,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_bitwise_ops_test5b:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    por %xmm1, %xmm0
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,3,2,3]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,2,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_bitwise_ops_test5b:
; SSE41:       # %bb.0:
; SSE41-NEXT:    orps %xmm1, %xmm0
; SSE41-NEXT:    blendps {{.*#+}} xmm0 = xmm2[0],xmm0[1],xmm2[2],xmm0[3]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_bitwise_ops_test5b:
; AVX:       # %bb.0:
; AVX-NEXT:    vorps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm2[0],xmm0[1],xmm2[2],xmm0[3]
; AVX-NEXT:    retq
  %shuf1 = shufflevector <4 x i32> %c, <4 x i32> %a, <4 x i32><i32 0, i32 5, i32 2, i32 7>
  %shuf2 = shufflevector <4 x i32> %c, <4 x i32> %b, <4 x i32><i32 0, i32 5, i32 2, i32 7>
  %or = or <4 x i32> %shuf1, %shuf2
  ret <4 x i32> %or
}

define <4 x i32> @combine_bitwise_ops_test6b(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; SSE2-LABEL: combine_bitwise_ops_test6b:
; SSE2:       # %bb.0:
; SSE2-NEXT:    xorps %xmm1, %xmm0
; SSE2-NEXT:    andps {{.*}}(%rip), %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_bitwise_ops_test6b:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    xorps %xmm1, %xmm0
; SSSE3-NEXT:    andps {{.*}}(%rip), %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_bitwise_ops_test6b:
; SSE41:       # %bb.0:
; SSE41-NEXT:    xorps %xmm1, %xmm0
; SSE41-NEXT:    xorps %xmm1, %xmm1
; SSE41-NEXT:    blendps {{.*#+}} xmm0 = xmm1[0],xmm0[1],xmm1[2],xmm0[3]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_bitwise_ops_test6b:
; AVX:       # %bb.0:
; AVX-NEXT:    vxorps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0],xmm0[1],xmm1[2],xmm0[3]
; AVX-NEXT:    retq
  %shuf1 = shufflevector <4 x i32> %c, <4 x i32> %a, <4 x i32><i32 0, i32 5, i32 2, i32 7>
  %shuf2 = shufflevector <4 x i32> %c, <4 x i32> %b, <4 x i32><i32 0, i32 5, i32 2, i32 7>
  %xor = xor <4 x i32> %shuf1, %shuf2
  ret <4 x i32> %xor
}

define <4 x i32> @combine_bitwise_ops_test1c(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; SSE-LABEL: combine_bitwise_ops_test1c:
; SSE:       # %bb.0:
; SSE-NEXT:    andps %xmm1, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm2[1,3]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_bitwise_ops_test1c:
; AVX:       # %bb.0:
; AVX-NEXT:    vandps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm2[1,3]
; AVX-NEXT:    retq
  %shuf1 = shufflevector <4 x i32> %a, <4 x i32> %c, <4 x i32><i32 0, i32 2, i32 5, i32 7>
  %shuf2 = shufflevector <4 x i32> %b, <4 x i32> %c, <4 x i32><i32 0, i32 2, i32 5, i32 7>
  %and = and <4 x i32> %shuf1, %shuf2
  ret <4 x i32> %and
}

define <4 x i32> @combine_bitwise_ops_test2c(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; SSE-LABEL: combine_bitwise_ops_test2c:
; SSE:       # %bb.0:
; SSE-NEXT:    orps %xmm1, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm2[1,3]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_bitwise_ops_test2c:
; AVX:       # %bb.0:
; AVX-NEXT:    vorps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm2[1,3]
; AVX-NEXT:    retq
  %shuf1 = shufflevector <4 x i32> %a, <4 x i32> %c, <4 x i32><i32 0, i32 2, i32 5, i32 7>
  %shuf2 = shufflevector <4 x i32> %b, <4 x i32> %c, <4 x i32><i32 0, i32 2, i32 5, i32 7>
  %or = or <4 x i32> %shuf1, %shuf2
  ret <4 x i32> %or
}

define <4 x i32> @combine_bitwise_ops_test3c(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; SSE2-LABEL: combine_bitwise_ops_test3c:
; SSE2:       # %bb.0:
; SSE2-NEXT:    xorps %xmm1, %xmm0
; SSE2-NEXT:    xorps %xmm1, %xmm1
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[2,3]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_bitwise_ops_test3c:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    xorps %xmm1, %xmm0
; SSSE3-NEXT:    xorps %xmm1, %xmm1
; SSSE3-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[2,3]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_bitwise_ops_test3c:
; SSE41:       # %bb.0:
; SSE41-NEXT:    xorps %xmm1, %xmm0
; SSE41-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0,2],zero,zero
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_bitwise_ops_test3c:
; AVX:       # %bb.0:
; AVX-NEXT:    vxorps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,2],zero,zero
; AVX-NEXT:    retq
  %shuf1 = shufflevector <4 x i32> %a, <4 x i32> %c, <4 x i32><i32 0, i32 2, i32 5, i32 7>
  %shuf2 = shufflevector <4 x i32> %b, <4 x i32> %c, <4 x i32><i32 0, i32 2, i32 5, i32 7>
  %xor = xor <4 x i32> %shuf1, %shuf2
  ret <4 x i32> %xor
}

define <4 x i32> @combine_bitwise_ops_test4c(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; SSE-LABEL: combine_bitwise_ops_test4c:
; SSE:       # %bb.0:
; SSE-NEXT:    andps %xmm1, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,2],xmm0[1,3]
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_bitwise_ops_test4c:
; AVX:       # %bb.0:
; AVX-NEXT:    vandps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm2[0,2],xmm0[1,3]
; AVX-NEXT:    retq
  %shuf1 = shufflevector <4 x i32> %c, <4 x i32> %a, <4 x i32><i32 0, i32 2, i32 5, i32 7>
  %shuf2 = shufflevector <4 x i32> %c, <4 x i32> %b, <4 x i32><i32 0, i32 2, i32 5, i32 7>
  %and = and <4 x i32> %shuf1, %shuf2
  ret <4 x i32> %and
}

define <4 x i32> @combine_bitwise_ops_test5c(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; SSE-LABEL: combine_bitwise_ops_test5c:
; SSE:       # %bb.0:
; SSE-NEXT:    orps %xmm1, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,2],xmm0[1,3]
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_bitwise_ops_test5c:
; AVX:       # %bb.0:
; AVX-NEXT:    vorps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm2[0,2],xmm0[1,3]
; AVX-NEXT:    retq
  %shuf1 = shufflevector <4 x i32> %c, <4 x i32> %a, <4 x i32><i32 0, i32 2, i32 5, i32 7>
  %shuf2 = shufflevector <4 x i32> %c, <4 x i32> %b, <4 x i32><i32 0, i32 2, i32 5, i32 7>
  %or = or <4 x i32> %shuf1, %shuf2
  ret <4 x i32> %or
}

define <4 x i32> @combine_bitwise_ops_test6c(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; SSE2-LABEL: combine_bitwise_ops_test6c:
; SSE2:       # %bb.0:
; SSE2-NEXT:    xorps %xmm1, %xmm0
; SSE2-NEXT:    xorps %xmm1, %xmm1
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[1,3]
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_bitwise_ops_test6c:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    xorps %xmm1, %xmm0
; SSSE3-NEXT:    xorps %xmm1, %xmm1
; SSSE3-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[1,3]
; SSSE3-NEXT:    movaps %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_bitwise_ops_test6c:
; SSE41:       # %bb.0:
; SSE41-NEXT:    xorps %xmm1, %xmm0
; SSE41-NEXT:    insertps {{.*#+}} xmm0 = zero,zero,xmm0[1,3]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_bitwise_ops_test6c:
; AVX:       # %bb.0:
; AVX-NEXT:    vxorps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vinsertps {{.*#+}} xmm0 = zero,zero,xmm0[1,3]
; AVX-NEXT:    retq
  %shuf1 = shufflevector <4 x i32> %c, <4 x i32> %a, <4 x i32><i32 0, i32 2, i32 5, i32 7>
  %shuf2 = shufflevector <4 x i32> %c, <4 x i32> %b, <4 x i32><i32 0, i32 2, i32 5, i32 7>
  %xor = xor <4 x i32> %shuf1, %shuf2
  ret <4 x i32> %xor
}

define <4 x i32> @combine_nested_undef_test1(<4 x i32> %A, <4 x i32> %B) {
; SSE-LABEL: combine_nested_undef_test1:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,1,0,1]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_nested_undef_test1:
; AVX:       # %bb.0:
; AVX-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,1,0,1]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %A, <4 x i32> %B, <4 x i32> <i32 0, i32 4, i32 3, i32 1>
  %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <4 x i32> <i32 2, i32 4, i32 0, i32 3>
  ret <4 x i32> %2
}

define <4 x i32> @combine_nested_undef_test2(<4 x i32> %A, <4 x i32> %B) {
; SSE-LABEL: combine_nested_undef_test2:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,0,3]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_nested_undef_test2:
; AVX:       # %bb.0:
; AVX-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,1,0,3]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %A, <4 x i32> %B, <4 x i32> <i32 0, i32 5, i32 2, i32 3>
  %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <4 x i32> <i32 2, i32 4, i32 0, i32 3>
  ret <4 x i32> %2
}

define <4 x i32> @combine_nested_undef_test3(<4 x i32> %A, <4 x i32> %B) {
; SSE-LABEL: combine_nested_undef_test3:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,0,3]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_nested_undef_test3:
; AVX:       # %bb.0:
; AVX-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,1,0,3]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %A, <4 x i32> %B, <4 x i32> <i32 0, i32 6, i32 2, i32 3>
  %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <4 x i32> <i32 2, i32 4, i32 0, i32 3>
  ret <4 x i32> %2
}

define <4 x i32> @combine_nested_undef_test4(<4 x i32> %A, <4 x i32> %B) {
; SSE-LABEL: combine_nested_undef_test4:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,0,1]
; SSE-NEXT:    retq
;
; AVX1-LABEL: combine_nested_undef_test4:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,1,0,1]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: combine_nested_undef_test4:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovddup {{.*#+}} xmm0 = xmm0[0,0]
; AVX2-NEXT:    retq
  %1 = shufflevector <4 x i32> %A, <4 x i32> %B, <4 x i32> <i32 0, i32 4, i32 7, i32 1>
  %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <4 x i32> <i32 4, i32 4, i32 0, i32 3>
  ret <4 x i32> %2
}

define <4 x i32> @combine_nested_undef_test5(<4 x i32> %A, <4 x i32> %B) {
; SSE-LABEL: combine_nested_undef_test5:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_nested_undef_test5:
; AVX:       # %bb.0:
; AVX-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %A, <4 x i32> %B, <4 x i32> <i32 5, i32 5, i32 2, i32 3>
  %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <4 x i32> <i32 2, i32 4, i32 4, i32 3>
  ret <4 x i32> %2
}

define <4 x i32> @combine_nested_undef_test6(<4 x i32> %A, <4 x i32> %B) {
; SSE-LABEL: combine_nested_undef_test6:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,0,1]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_nested_undef_test6:
; AVX:       # %bb.0:
; AVX-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,3,0,1]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %A, <4 x i32> %B, <4 x i32> <i32 0, i32 6, i32 2, i32 4>
  %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <4 x i32> <i32 2, i32 4, i32 0, i32 4>
  ret <4 x i32> %2
}

define <4 x i32> @combine_nested_undef_test7(<4 x i32> %A, <4 x i32> %B) {
; SSE-LABEL: combine_nested_undef_test7:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,0,2]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_nested_undef_test7:
; AVX:       # %bb.0:
; AVX-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,2,0,2]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %A, <4 x i32> %B, <4 x i32> <i32 0, i32 5, i32 2, i32 7>
  %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <4 x i32> <i32 0, i32 2, i32 0, i32 2>
  ret <4 x i32> %2
}

define <4 x i32> @combine_nested_undef_test8(<4 x i32> %A, <4 x i32> %B) {
; SSE-LABEL: combine_nested_undef_test8:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_nested_undef_test8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %A, <4 x i32> %B, <4 x i32> <i32 4, i32 1, i32 6, i32 3>
  %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <4 x i32> <i32 1, i32 4, i32 3, i32 4>
  ret <4 x i32> %2
}

define <4 x i32> @combine_nested_undef_test9(<4 x i32> %A, <4 x i32> %B) {
; SSE-LABEL: combine_nested_undef_test9:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,3,2,2]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_nested_undef_test9:
; AVX:       # %bb.0:
; AVX-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[1,3,2,2]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %A, <4 x i32> %B, <4 x i32> <i32 1, i32 3, i32 2, i32 5>
  %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <4 x i32> <i32 0, i32 1, i32 4, i32 2>
  ret <4 x i32> %2
}

define <4 x i32> @combine_nested_undef_test10(<4 x i32> %A, <4 x i32> %B) {
; SSE-LABEL: combine_nested_undef_test10:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_nested_undef_test10:
; AVX:       # %bb.0:
; AVX-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %A, <4 x i32> %B, <4 x i32> <i32 1, i32 1, i32 5, i32 5>
  %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <4 x i32> <i32 0, i32 4, i32 1, i32 4>
  ret <4 x i32> %2
}

define <4 x i32> @combine_nested_undef_test11(<4 x i32> %A, <4 x i32> %B) {
; SSE-LABEL: combine_nested_undef_test11:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,2,1]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_nested_undef_test11:
; AVX:       # %bb.0:
; AVX-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[1,1,2,1]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %A, <4 x i32> %B, <4 x i32> <i32 1, i32 2, i32 5, i32 4>
  %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <4 x i32> <i32 0, i32 4, i32 1, i32 0>
  ret <4 x i32> %2
}

define <4 x i32> @combine_nested_undef_test12(<4 x i32> %A, <4 x i32> %B) {
; SSE-LABEL: combine_nested_undef_test12:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,0,1]
; SSE-NEXT:    retq
;
; AVX1-LABEL: combine_nested_undef_test12:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,1,0,1]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: combine_nested_undef_test12:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vbroadcastss %xmm0, %xmm0
; AVX2-NEXT:    retq
  %1 = shufflevector <4 x i32> %A, <4 x i32> %B, <4 x i32> <i32 0, i32 0, i32 2, i32 4>
  %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <4 x i32> <i32 1, i32 4, i32 0, i32 4>
  ret <4 x i32> %2
}

; The following pair of shuffles is folded into vector %A.
define <4 x i32> @combine_nested_undef_test13(<4 x i32> %A, <4 x i32> %B) {
; CHECK-LABEL: combine_nested_undef_test13:
; CHECK:       # %bb.0:
; CHECK-NEXT:    retq
  %1 = shufflevector <4 x i32> %A, <4 x i32> %B, <4 x i32> <i32 1, i32 4, i32 2, i32 6>
  %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <4 x i32> <i32 4, i32 0, i32 2, i32 4>
  ret <4 x i32> %2
}

; The following pair of shuffles is folded into vector %B.
define <4 x i32> @combine_nested_undef_test14(<4 x i32> %A, <4 x i32> %B) {
; SSE-LABEL: combine_nested_undef_test14:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_nested_undef_test14:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps %xmm1, %xmm0
; AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %A, <4 x i32> %B, <4 x i32> <i32 0, i32 6, i32 2, i32 4>
  %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <4 x i32> <i32 3, i32 4, i32 1, i32 4>
  ret <4 x i32> %2
}


; Verify that we don't optimize the following cases. We expect more than one shuffle.
;
; FIXME: Many of these already don't make sense, and the rest should stop
; making sense with th enew vector shuffle lowering. Revisit at least testing for
; it.

define <4 x i32> @combine_nested_undef_test15(<4 x i32> %A, <4 x i32> %B) {
; SSE2-LABEL: combine_nested_undef_test15:
; SSE2:       # %bb.0:
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,0],xmm0[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],xmm0[0,1]
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_nested_undef_test15:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,0],xmm0[3,0]
; SSSE3-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],xmm0[0,1]
; SSSE3-NEXT:    movaps %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_nested_undef_test15:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,1,1]
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,1,0,1]
; SSE41-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,3],xmm0[4,5,6,7]
; SSE41-NEXT:    retq
;
; AVX1-LABEL: combine_nested_undef_test15:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[0,0,1,1]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,1,0,1]
; AVX1-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: combine_nested_undef_test15:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vbroadcastss %xmm1, %xmm1
; AVX2-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,1,0,1]
; AVX2-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3]
; AVX2-NEXT:    retq
  %1 = shufflevector <4 x i32> %A, <4 x i32> %B, <4 x i32> <i32 0, i32 4, i32 3, i32 1>
  %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <4 x i32> <i32 2, i32 1, i32 0, i32 3>
  ret <4 x i32> %2
}

define <4 x i32> @combine_nested_undef_test16(<4 x i32> %A, <4 x i32> %B) {
; SSE2-LABEL: combine_nested_undef_test16:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,3,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,0,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_nested_undef_test16:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,3,2,3]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,0,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_nested_undef_test16:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,0,1]
; SSE41-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,3],xmm0[4,5],xmm1[6,7]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_nested_undef_test16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,3,0,1]
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2],xmm1[3]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %A, <4 x i32> %B, <4 x i32> <i32 0, i32 5, i32 2, i32 7>
  %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <4 x i32> <i32 2, i32 1, i32 0, i32 3>
  ret <4 x i32> %2
}

define <4 x i32> @combine_nested_undef_test17(<4 x i32> %A, <4 x i32> %B) {
; SSE2-LABEL: combine_nested_undef_test17:
; SSE2:       # %bb.0:
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,0],xmm0[1,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,1],xmm1[0,2]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_nested_undef_test17:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,0],xmm0[1,0]
; SSSE3-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,1],xmm1[0,2]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_nested_undef_test17:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pblendw {{.*#+}} xmm0 = xmm1[0,1],xmm0[2,3,4,5,6,7]
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,1,0,1]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_nested_undef_test17:
; AVX:       # %bb.0:
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3]
; AVX-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,1,0,1]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %A, <4 x i32> %B, <4 x i32> <i32 4, i32 1, i32 3, i32 1>
  %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <4 x i32> <i32 2, i32 1, i32 0, i32 3>
  ret <4 x i32> %2
}

define <4 x i32> @combine_nested_undef_test18(<4 x i32> %A, <4 x i32> %B) {
; SSE-LABEL: combine_nested_undef_test18:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,0,3]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_nested_undef_test18:
; AVX:       # %bb.0:
; AVX-NEXT:    vpermilps {{.*#+}} xmm0 = xmm1[1,1,0,3]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %A, <4 x i32> %B, <4 x i32> <i32 4, i32 5, i32 2, i32 7>
  %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <4 x i32> <i32 1, i32 1, i32 0, i32 3>
  ret <4 x i32> %2
}

define <4 x i32> @combine_nested_undef_test19(<4 x i32> %A, <4 x i32> %B) {
; SSE2-LABEL: combine_nested_undef_test19:
; SSE2:       # %bb.0:
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,0,0,0]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_nested_undef_test19:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,0,0,0]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_nested_undef_test19:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,3],xmm0[4,5,6,7]
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,0,0,0]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_nested_undef_test19:
; AVX:       # %bb.0:
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3]
; AVX-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[1,0,0,0]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %A, <4 x i32> %B, <4 x i32> <i32 0, i32 4, i32 5, i32 6>
  %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <4 x i32> <i32 2, i32 0, i32 0, i32 0>
  ret <4 x i32> %2
}

define <4 x i32> @combine_nested_undef_test20(<4 x i32> %A, <4 x i32> %B) {
; SSE2-LABEL: combine_nested_undef_test20:
; SSE2:       # %bb.0:
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,0],xmm0[2,3]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2,3,1]
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_nested_undef_test20:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,0],xmm0[2,3]
; SSSE3-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2,3,1]
; SSSE3-NEXT:    movaps %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_nested_undef_test20:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pblendw {{.*#+}} xmm0 = xmm1[0,1,2,3],xmm0[4,5,6,7]
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,3,0]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_nested_undef_test20:
; AVX:       # %bb.0:
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0,1],xmm0[2,3]
; AVX-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,2,3,0]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %A, <4 x i32> %B, <4 x i32> <i32 3, i32 2, i32 4, i32 4>
  %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <4 x i32> <i32 2, i32 1, i32 0, i32 3>
  ret <4 x i32> %2
}

define <4 x i32> @combine_nested_undef_test21(<4 x i32> %A, <4 x i32> %B) {
; SSE2-LABEL: combine_nested_undef_test21:
; SSE2:       # %bb.0:
; SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,3,0,3]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_nested_undef_test21:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,3,0,3]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_nested_undef_test21:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pblendw {{.*#+}} xmm0 = xmm1[0,1],xmm0[2,3],xmm1[4,5,6,7]
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,0,1]
; SSE41-NEXT:    retq
;
; AVX1-LABEL: combine_nested_undef_test21:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0],xmm0[1],xmm1[2,3]
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,1,0,1]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: combine_nested_undef_test21:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0],xmm0[1],xmm1[2,3]
; AVX2-NEXT:    vmovddup {{.*#+}} xmm0 = xmm0[0,0]
; AVX2-NEXT:    retq
  %1 = shufflevector <4 x i32> %A, <4 x i32> %B, <4 x i32> <i32 4, i32 1, i32 3, i32 1>
  %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <4 x i32> <i32 0, i32 1, i32 0, i32 3>
  ret <4 x i32> %2
}


; Test that we correctly combine shuffles according to rule
;  shuffle(shuffle(x, y), undef) -> shuffle(y, undef)

define <4 x i32> @combine_nested_undef_test22(<4 x i32> %A, <4 x i32> %B) {
; SSE-LABEL: combine_nested_undef_test22:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,3]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_nested_undef_test22:
; AVX:       # %bb.0:
; AVX-NEXT:    vpermilps {{.*#+}} xmm0 = xmm1[1,1,1,3]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %A, <4 x i32> %B, <4 x i32> <i32 4, i32 5, i32 2, i32 7>
  %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <4 x i32> <i32 1, i32 1, i32 1, i32 3>
  ret <4 x i32> %2
}

define <4 x i32> @combine_nested_undef_test23(<4 x i32> %A, <4 x i32> %B) {
; SSE-LABEL: combine_nested_undef_test23:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,1,0,3]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_nested_undef_test23:
; AVX:       # %bb.0:
; AVX-NEXT:    vpermilps {{.*#+}} xmm0 = xmm1[0,1,0,3]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %A, <4 x i32> %B, <4 x i32> <i32 4, i32 5, i32 2, i32 7>
  %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <4 x i32> <i32 0, i32 1, i32 0, i32 3>
  ret <4 x i32> %2
}

define <4 x i32> @combine_nested_undef_test24(<4 x i32> %A, <4 x i32> %B) {
; SSE-LABEL: combine_nested_undef_test24:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,3,2,3]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_nested_undef_test24:
; AVX:       # %bb.0:
; AVX-NEXT:    vpermilps {{.*#+}} xmm0 = xmm1[0,3,2,3]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %A, <4 x i32> %B, <4 x i32> <i32 4, i32 1, i32 6, i32 7>
  %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <4 x i32> <i32 0, i32 3, i32 2, i32 4>
  ret <4 x i32> %2
}

define <4 x i32> @combine_nested_undef_test25(<4 x i32> %A, <4 x i32> %B) {
; SSE-LABEL: combine_nested_undef_test25:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,0,1]
; SSE-NEXT:    retq
;
; AVX1-LABEL: combine_nested_undef_test25:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,1,0,1]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: combine_nested_undef_test25:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovddup {{.*#+}} xmm0 = xmm0[0,0]
; AVX2-NEXT:    retq
  %1 = shufflevector <4 x i32> %B, <4 x i32> %A, <4 x i32> <i32 1, i32 5, i32 2, i32 4>
  %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <4 x i32> <i32 3, i32 1, i32 3, i32 1>
  ret <4 x i32> %2
}

define <4 x i32> @combine_nested_undef_test26(<4 x i32> %A, <4 x i32> %B) {
; SSE-LABEL: combine_nested_undef_test26:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_nested_undef_test26:
; AVX:       # %bb.0:
; AVX-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %B, <4 x i32> %A, <4 x i32> <i32 1, i32 2, i32 6, i32 7>
  %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <4 x i32> <i32 2, i32 3, i32 2, i32 3>
  ret <4 x i32> %2
}

define <4 x i32> @combine_nested_undef_test27(<4 x i32> %A, <4 x i32> %B) {
; SSE-LABEL: combine_nested_undef_test27:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,0,1]
; SSE-NEXT:    retq
;
; AVX1-LABEL: combine_nested_undef_test27:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,1,0,1]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: combine_nested_undef_test27:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovddup {{.*#+}} xmm0 = xmm0[0,0]
; AVX2-NEXT:    retq
  %1 = shufflevector <4 x i32> %B, <4 x i32> %A, <4 x i32> <i32 2, i32 1, i32 5, i32 4>
  %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <4 x i32> <i32 3, i32 2, i32 3, i32 2>
  ret <4 x i32> %2
}

define <4 x i32> @combine_nested_undef_test28(<4 x i32> %A, <4 x i32> %B) {
; SSE-LABEL: combine_nested_undef_test28:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,1,0]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_nested_undef_test28:
; AVX:       # %bb.0:
; AVX-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,1,1,0]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %B, <4 x i32> %A, <4 x i32> <i32 1, i32 2, i32 4, i32 5>
  %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <4 x i32> <i32 2, i32 3, i32 3, i32 2>
  ret <4 x i32> %2
}

define <4 x float> @combine_test1(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: combine_test1:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_test1:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps %xmm1, %xmm0
; AVX-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 4, i32 1, i32 6, i32 3>
  %2 = shufflevector <4 x float> %1, <4 x float> %b, <4 x i32> <i32 0, i32 5, i32 2, i32 7>
  ret <4 x float> %2
}

define <4 x float> @combine_test2(<4 x float> %a, <4 x float> %b) {
; SSE2-LABEL: combine_test2:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_test2:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSSE3-NEXT:    movaps %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_test2:
; SSE41:       # %bb.0:
; SSE41-NEXT:    blendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_test2:
; AVX:       # %bb.0:
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 0, i32 5, i32 2, i32 7>
  %2 = shufflevector <4 x float> %1, <4 x float> %b, <4 x i32> <i32 0, i32 1, i32 6, i32 3>
  ret <4 x float> %2
}

define <4 x float> @combine_test3(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: combine_test3:
; SSE:       # %bb.0:
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_test3:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 0, i32 5, i32 1, i32 7>
  %2 = shufflevector <4 x float> %1, <4 x float> %b, <4 x i32> <i32 0, i32 2, i32 4, i32 1>
  ret <4 x float> %2
}

define <4 x float> @combine_test4(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: combine_test4:
; SSE:       # %bb.0:
; SSE-NEXT:    movhlps {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_test4:
; AVX:       # %bb.0:
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 2, i32 3, i32 5, i32 5>
  %2 = shufflevector <4 x float> %1, <4 x float> %b, <4 x i32> <i32 6, i32 7, i32 0, i32 1>
  ret <4 x float> %2
}

define <4 x float> @combine_test5(<4 x float> %a, <4 x float> %b) {
; SSE2-LABEL: combine_test5:
; SSE2:       # %bb.0:
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,0],xmm1[0,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0],xmm1[2,3]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_test5:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,0],xmm1[0,0]
; SSSE3-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0],xmm1[2,3]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_test5:
; SSE41:       # %bb.0:
; SSE41-NEXT:    blendps {{.*#+}} xmm0 = xmm1[0],xmm0[1],xmm1[2,3]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_test5:
; AVX:       # %bb.0:
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0],xmm0[1],xmm1[2,3]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 4, i32 1, i32 6, i32 3>
  %2 = shufflevector <4 x float> %1, <4 x float> %b, <4 x i32> <i32 0, i32 1, i32 2, i32 7>
  ret <4 x float> %2
}

define <4 x i32> @combine_test6(<4 x i32> %a, <4 x i32> %b) {
; SSE-LABEL: combine_test6:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_test6:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps %xmm1, %xmm0
; AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 4, i32 1, i32 6, i32 3>
  %2 = shufflevector <4 x i32> %1, <4 x i32> %b, <4 x i32> <i32 0, i32 5, i32 2, i32 7>
  ret <4 x i32> %2
}

define <4 x i32> @combine_test7(<4 x i32> %a, <4 x i32> %b) {
; SSE2-LABEL: combine_test7:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_test7:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSSE3-NEXT:    movaps %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_test7:
; SSE41:       # %bb.0:
; SSE41-NEXT:    blendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_test7:
; AVX:       # %bb.0:
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 0, i32 5, i32 2, i32 7>
  %2 = shufflevector <4 x i32> %1, <4 x i32> %b, <4 x i32> <i32 0, i32 1, i32 6, i32 3>
  ret <4 x i32> %2
}

define <4 x i32> @combine_test8(<4 x i32> %a, <4 x i32> %b) {
; SSE-LABEL: combine_test8:
; SSE:       # %bb.0:
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_test8:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 0, i32 5, i32 1, i32 7>
  %2 = shufflevector <4 x i32> %1, <4 x i32> %b, <4 x i32> <i32 0, i32 2, i32 4, i32 1>
  ret <4 x i32> %2
}

define <4 x i32> @combine_test9(<4 x i32> %a, <4 x i32> %b) {
; SSE-LABEL: combine_test9:
; SSE:       # %bb.0:
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm0[1]
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_test9:
; AVX:       # %bb.0:
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 2, i32 3, i32 5, i32 5>
  %2 = shufflevector <4 x i32> %1, <4 x i32> %b, <4 x i32> <i32 6, i32 7, i32 0, i32 1>
  ret <4 x i32> %2
}

define <4 x i32> @combine_test10(<4 x i32> %a, <4 x i32> %b) {
; SSE2-LABEL: combine_test10:
; SSE2:       # %bb.0:
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,0],xmm1[0,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0],xmm1[2,3]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_test10:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,0],xmm1[0,0]
; SSSE3-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0],xmm1[2,3]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_test10:
; SSE41:       # %bb.0:
; SSE41-NEXT:    blendps {{.*#+}} xmm0 = xmm1[0],xmm0[1],xmm1[2,3]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_test10:
; AVX:       # %bb.0:
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0],xmm0[1],xmm1[2,3]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 4, i32 1, i32 6, i32 3>
  %2 = shufflevector <4 x i32> %1, <4 x i32> %b, <4 x i32> <i32 0, i32 1, i32 2, i32 7>
  ret <4 x i32> %2
}

define <4 x float> @combine_test11(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: combine_test11:
; CHECK:       # %bb.0:
; CHECK-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 4, i32 1, i32 6, i32 3>
  %2 = shufflevector <4 x float> %1, <4 x float> %a, <4 x i32> <i32 4, i32 1, i32 6, i32 3>
  ret <4 x float> %2
}

define <4 x float> @combine_test12(<4 x float> %a, <4 x float> %b) {
; SSE2-LABEL: combine_test12:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_test12:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSSE3-NEXT:    movaps %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_test12:
; SSE41:       # %bb.0:
; SSE41-NEXT:    blendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_test12:
; AVX:       # %bb.0:
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 0, i32 5, i32 6, i32 7>
  %2 = shufflevector <4 x float> %1, <4 x float> %a, <4 x i32> <i32 4, i32 1, i32 2, i32 3>
  ret <4 x float> %2
}

define <4 x float> @combine_test13(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: combine_test13:
; SSE:       # %bb.0:
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_test13:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 0, i32 1, i32 4, i32 5>
  %2 = shufflevector <4 x float> %1, <4 x float> %a, <4 x i32> <i32 4, i32 5, i32 2, i32 3>
  ret <4 x float> %2
}

define <4 x float> @combine_test14(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: combine_test14:
; SSE:       # %bb.0:
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_test14:
; AVX:       # %bb.0:
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 6, i32 7, i32 5, i32 5>
  %2 = shufflevector <4 x float> %1, <4 x float> %a, <4 x i32> <i32 6, i32 7, i32 0, i32 1>
  ret <4 x float> %2
}

define <4 x float> @combine_test15(<4 x float> %a, <4 x float> %b) {
; SSE2-LABEL: combine_test15:
; SSE2:       # %bb.0:
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,0],xmm1[0,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0],xmm1[2,3]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_test15:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,0],xmm1[0,0]
; SSSE3-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0],xmm1[2,3]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_test15:
; SSE41:       # %bb.0:
; SSE41-NEXT:    blendps {{.*#+}} xmm0 = xmm1[0],xmm0[1],xmm1[2,3]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_test15:
; AVX:       # %bb.0:
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0],xmm0[1],xmm1[2,3]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 4, i32 1, i32 6, i32 7>
  %2 = shufflevector <4 x float> %1, <4 x float> %a, <4 x i32> <i32 0, i32 5, i32 2, i32 3>
  ret <4 x float> %2
}

define <4 x i32> @combine_test16(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: combine_test16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    retq
  %1 = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 4, i32 1, i32 6, i32 3>
  %2 = shufflevector <4 x i32> %1, <4 x i32> %a, <4 x i32> <i32 4, i32 1, i32 6, i32 3>
  ret <4 x i32> %2
}

define <4 x i32> @combine_test17(<4 x i32> %a, <4 x i32> %b) {
; SSE2-LABEL: combine_test17:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_test17:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSSE3-NEXT:    movaps %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_test17:
; SSE41:       # %bb.0:
; SSE41-NEXT:    blendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_test17:
; AVX:       # %bb.0:
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 0, i32 5, i32 6, i32 7>
  %2 = shufflevector <4 x i32> %1, <4 x i32> %a, <4 x i32> <i32 4, i32 1, i32 2, i32 3>
  ret <4 x i32> %2
}

define <4 x i32> @combine_test18(<4 x i32> %a, <4 x i32> %b) {
; SSE-LABEL: combine_test18:
; SSE:       # %bb.0:
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_test18:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 0, i32 1, i32 4, i32 5>
  %2 = shufflevector <4 x i32> %1, <4 x i32> %a, <4 x i32> <i32 4, i32 5, i32 2, i32 3>
  ret <4 x i32> %2
}

define <4 x i32> @combine_test19(<4 x i32> %a, <4 x i32> %b) {
; SSE-LABEL: combine_test19:
; SSE:       # %bb.0:
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_test19:
; AVX:       # %bb.0:
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 6, i32 7, i32 5, i32 5>
  %2 = shufflevector <4 x i32> %1, <4 x i32> %a, <4 x i32> <i32 6, i32 7, i32 0, i32 1>
  ret <4 x i32> %2
}

define <4 x i32> @combine_test20(<4 x i32> %a, <4 x i32> %b) {
; SSE2-LABEL: combine_test20:
; SSE2:       # %bb.0:
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,0],xmm1[0,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0],xmm1[2,3]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_test20:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,0],xmm1[0,0]
; SSSE3-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0],xmm1[2,3]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_test20:
; SSE41:       # %bb.0:
; SSE41-NEXT:    blendps {{.*#+}} xmm0 = xmm1[0],xmm0[1],xmm1[2,3]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_test20:
; AVX:       # %bb.0:
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0],xmm0[1],xmm1[2,3]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 4, i32 1, i32 6, i32 7>
  %2 = shufflevector <4 x i32> %1, <4 x i32> %a, <4 x i32> <i32 0, i32 5, i32 2, i32 3>
  ret <4 x i32> %2
}

define <4 x i32> @combine_test21(<8 x i32> %a, <4 x i32>* %ptr) {
; SSE-LABEL: combine_test21:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps %xmm0, %xmm2
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm1[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE-NEXT:    movaps %xmm2, (%rdi)
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_test21:
; AVX:       # %bb.0:
; AVX-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm0[0],xmm1[0]
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX-NEXT:    vmovaps %xmm2, (%rdi)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
  %1 = shufflevector <8 x i32> %a, <8 x i32> %a, <4 x i32> <i32 0, i32 1, i32 4, i32 5>
  %2 = shufflevector <8 x i32> %a, <8 x i32> %a, <4 x i32> <i32 2, i32 3, i32 6, i32 7>
  store <4 x i32> %1, <4 x i32>* %ptr, align 16
  ret <4 x i32> %2
}

define <8 x float> @combine_test22(<2 x float>* %a, <2 x float>* %b) {
; SSE-LABEL: combine_test22:
; SSE:       # %bb.0:
; SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movhps {{.*#+}} xmm0 = xmm0[0,1],mem[0,1]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_test22:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX-NEXT:    vmovhps {{.*#+}} xmm0 = xmm0[0,1],mem[0,1]
; AVX-NEXT:    retq
; Current AVX2 lowering of this is still awful, not adding a test case.
  %1 = load <2 x float>, <2 x float>* %a, align 8
  %2 = load <2 x float>, <2 x float>* %b, align 8
  %3 = shufflevector <2 x float> %1, <2 x float> %2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  ret <8 x float> %3
}

; PR22359
define void @combine_test23(<8 x float> %v, <2 x float>* %ptr) {
; SSE-LABEL: combine_test23:
; SSE:       # %bb.0:
; SSE-NEXT:    movups %xmm0, (%rdi)
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_test23:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovups %xmm0, (%rdi)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
  %idx2 = getelementptr inbounds <2 x float>, <2 x float>* %ptr, i64 1
  %shuffle0 = shufflevector <8 x float> %v, <8 x float> undef, <2 x i32> <i32 0, i32 1>
  %shuffle1 = shufflevector <8 x float> %v, <8 x float> undef, <2 x i32> <i32 2, i32 3>
  store <2 x float> %shuffle0, <2 x float>* %ptr, align 8
  store <2 x float> %shuffle1, <2 x float>* %idx2, align 8
  ret void
}

; Check some negative cases.
; FIXME: Do any of these really make sense? Are they redundant with the above tests?

define <4 x float> @combine_test1b(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: combine_test1b:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,0]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_test1b:
; AVX:       # %bb.0:
; AVX-NEXT:    vpermilps {{.*#+}} xmm0 = xmm1[0,1,2,0]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 4, i32 1, i32 6, i32 3>
  %2 = shufflevector <4 x float> %1, <4 x float> %b, <4 x i32> <i32 0, i32 5, i32 2, i32 0>
  ret <4 x float> %2
}

define <4 x float> @combine_test2b(<4 x float> %a, <4 x float> %b) {
; SSE2-LABEL: combine_test2b:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_test2b:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movddup {{.*#+}} xmm0 = xmm1[0,0]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_test2b:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movddup {{.*#+}} xmm0 = xmm1[0,0]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_test2b:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovddup {{.*#+}} xmm0 = xmm1[0,0]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 4, i32 1, i32 6, i32 3>
  %2 = shufflevector <4 x float> %1, <4 x float> %b, <4 x i32> <i32 0, i32 5, i32 0, i32 5>
  ret <4 x float> %2
}

define <4 x float> @combine_test3b(<4 x float> %a, <4 x float> %b) {
; SSE2-LABEL: combine_test3b:
; SSE2:       # %bb.0:
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[2,3]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_test3b:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[3,0]
; SSSE3-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[2,3]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_test3b:
; SSE41:       # %bb.0:
; SSE41-NEXT:    blendps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,3]
; SSE41-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,3,2,3]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_test3b:
; AVX:       # %bb.0:
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,3]
; AVX-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,3,2,3]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 0, i32 0, i32 6, i32 3>
  %2 = shufflevector <4 x float> %1, <4 x float> %b, <4 x i32> <i32 0, i32 7, i32 2, i32 7>
  ret <4 x float> %2
}

define <4 x float> @combine_test4b(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: combine_test4b:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[2,3]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_test4b:
; AVX:       # %bb.0:
; AVX-NEXT:    vpermilps {{.*#+}} xmm0 = xmm1[1,1,2,3]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 4, i32 1, i32 6, i32 3>
  %2 = shufflevector <4 x float> %1, <4 x float> %b, <4 x i32> <i32 5, i32 5, i32 2, i32 7>
  ret <4 x float> %2
}


; Verify that we correctly fold shuffles even when we use illegal vector types.

define <4 x i8> @combine_test1c(<4 x i8>* %a, <4 x i8>* %b) {
; SSE2-LABEL: combine_test1c:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE2-NEXT:    movss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE2-NEXT:    movaps {{.*#+}} xmm0 = [0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; SSE2-NEXT:    andps %xmm0, %xmm2
; SSE2-NEXT:    andnps %xmm1, %xmm0
; SSE2-NEXT:    orps %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_test1c:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSSE3-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSSE3-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSSE3-NEXT:    pshufb {{.*#+}} xmm0 = xmm0[1,2,4,6,u,u,u,u,u,u,u,u,u,u,u,u]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_test1c:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE41-NEXT:    movd {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE41-NEXT:    movaps {{.*#+}} xmm0 = <0,255,255,255,u,u,u,u,u,u,u,u,u,u,u,u>
; SSE41-NEXT:    pblendvb %xmm0, %xmm2, %xmm1
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_test1c:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX-NEXT:    vmovdqa {{.*#+}} xmm2 = <0,255,255,255,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %A = load <4 x i8>, <4 x i8>* %a
  %B = load <4 x i8>, <4 x i8>* %b
  %1 = shufflevector <4 x i8> %A, <4 x i8> %B, <4 x i32> <i32 0, i32 5, i32 2, i32 7>
  %2 = shufflevector <4 x i8> %1, <4 x i8> %B, <4 x i32> <i32 0, i32 1, i32 6, i32 3>
  ret <4 x i8> %2
}

define <4 x i8> @combine_test2c(<4 x i8>* %a, <4 x i8>* %b) {
; SSE-LABEL: combine_test2c:
; SSE:       # %bb.0:
; SSE-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_test2c:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX-NEXT:    retq
  %A = load <4 x i8>, <4 x i8>* %a
  %B = load <4 x i8>, <4 x i8>* %b
  %1 = shufflevector <4 x i8> %A, <4 x i8> %B, <4 x i32> <i32 0, i32 5, i32 1, i32 5>
  %2 = shufflevector <4 x i8> %1, <4 x i8> %B, <4 x i32> <i32 0, i32 2, i32 4, i32 1>
  ret <4 x i8> %2
}

define <4 x i8> @combine_test3c(<4 x i8>* %a, <4 x i8>* %b) {
; SSE-LABEL: combine_test3c:
; SSE:       # %bb.0:
; SSE-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_test3c:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX-NEXT:    retq
  %A = load <4 x i8>, <4 x i8>* %a
  %B = load <4 x i8>, <4 x i8>* %b
  %1 = shufflevector <4 x i8> %A, <4 x i8> %B, <4 x i32> <i32 2, i32 3, i32 5, i32 5>
  %2 = shufflevector <4 x i8> %1, <4 x i8> %B, <4 x i32> <i32 6, i32 7, i32 0, i32 1>
  ret <4 x i8> %2
}

define <4 x i8> @combine_test4c(<4 x i8>* %a, <4 x i8>* %b) {
; SSE2-LABEL: combine_test4c:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE2-NEXT:    movss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE2-NEXT:    movaps {{.*#+}} xmm0 = [255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; SSE2-NEXT:    andps %xmm0, %xmm2
; SSE2-NEXT:    andnps %xmm1, %xmm0
; SSE2-NEXT:    orps %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_test4c:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSSE3-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSSE3-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSSE3-NEXT:    pshufb {{.*#+}} xmm0 = xmm0[0,3,4,6,u,u,u,u,u,u,u,u,u,u,u,u]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_test4c:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE41-NEXT:    movd {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE41-NEXT:    movaps {{.*#+}} xmm0 = <255,0,255,255,u,u,u,u,u,u,u,u,u,u,u,u>
; SSE41-NEXT:    pblendvb %xmm0, %xmm2, %xmm1
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_test4c:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX-NEXT:    vmovdqa {{.*#+}} xmm2 = <255,0,255,255,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %A = load <4 x i8>, <4 x i8>* %a
  %B = load <4 x i8>, <4 x i8>* %b
  %1 = shufflevector <4 x i8> %A, <4 x i8> %B, <4 x i32> <i32 4, i32 1, i32 6, i32 3>
  %2 = shufflevector <4 x i8> %1, <4 x i8> %B, <4 x i32> <i32 0, i32 1, i32 2, i32 7>
  ret <4 x i8> %2
}


; The following test cases are generated from this C++ code
;
;__m128 blend_01(__m128 a, __m128 b)
;{
;  __m128 s = a;
;  s = _mm_blend_ps( s, b, 1<<0 );
;  s = _mm_blend_ps( s, b, 1<<1 );
;  return s;
;}
;
;__m128 blend_02(__m128 a, __m128 b)
;{
;  __m128 s = a;
;  s = _mm_blend_ps( s, b, 1<<0 );
;  s = _mm_blend_ps( s, b, 1<<2 );
;  return s;
;}
;
;__m128 blend_123(__m128 a, __m128 b)
;{
;  __m128 s = a;
;  s = _mm_blend_ps( s, b, 1<<1 );
;  s = _mm_blend_ps( s, b, 1<<2 );
;  s = _mm_blend_ps( s, b, 1<<3 );
;  return s;
;}

; Ideally, we should collapse the following shuffles into a single one.

define <4 x float> @combine_blend_01(<4 x float> %a, <4 x float> %b) {
; SSE2-LABEL: combine_blend_01:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movsd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_blend_01:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movsd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_blend_01:
; SSE41:       # %bb.0:
; SSE41-NEXT:    blendps {{.*#+}} xmm0 = xmm1[0,1],xmm0[2,3]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_blend_01:
; AVX:       # %bb.0:
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0,1],xmm0[2,3]
; AVX-NEXT:    retq
  %shuffle = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 4, i32 undef, i32 2, i32 3>
  %shuffle6 = shufflevector <4 x float> %shuffle, <4 x float> %b, <4 x i32> <i32 0, i32 5, i32 2, i32 3>
  ret <4 x float> %shuffle6
}

define <4 x float> @combine_blend_02(<4 x float> %a, <4 x float> %b) {
; SSE2-LABEL: combine_blend_02:
; SSE2:       # %bb.0:
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm0[1,3]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2,1,3]
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_blend_02:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm0[1,3]
; SSSE3-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2,1,3]
; SSSE3-NEXT:    movaps %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_blend_02:
; SSE41:       # %bb.0:
; SSE41-NEXT:    blendps {{.*#+}} xmm0 = xmm1[0],xmm0[1],xmm1[2],xmm0[3]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_blend_02:
; AVX:       # %bb.0:
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0],xmm0[1],xmm1[2],xmm0[3]
; AVX-NEXT:    retq
  %shuffle = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 4, i32 1, i32 undef, i32 3>
  %shuffle6 = shufflevector <4 x float> %shuffle, <4 x float> %b, <4 x i32> <i32 0, i32 1, i32 6, i32 3>
  ret <4 x float> %shuffle6
}

define <4 x float> @combine_blend_123(<4 x float> %a, <4 x float> %b) {
; SSE2-LABEL: combine_blend_123:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_blend_123:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSSE3-NEXT:    movaps %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_blend_123:
; SSE41:       # %bb.0:
; SSE41-NEXT:    blendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_blend_123:
; AVX:       # %bb.0:
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; AVX-NEXT:    retq
  %shuffle = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 0, i32 5, i32 undef, i32 undef>
  %shuffle6 = shufflevector <4 x float> %shuffle, <4 x float> %b, <4 x i32> <i32 0, i32 1, i32 6, i32 undef>
  %shuffle12 = shufflevector <4 x float> %shuffle6, <4 x float> %b, <4 x i32> <i32 0, i32 1, i32 2, i32 7>
  ret <4 x float> %shuffle12
}

define <4 x i32> @combine_test_movhl_1(<4 x i32> %a, <4 x i32> %b) {
; SSE-LABEL: combine_test_movhl_1:
; SSE:       # %bb.0:
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm0[1]
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_test_movhl_1:
; AVX:       # %bb.0:
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 2, i32 7, i32 5, i32 3>
  %2 = shufflevector <4 x i32> %1, <4 x i32> %b, <4 x i32> <i32 6, i32 1, i32 0, i32 3>
  ret <4 x i32> %2
}

define <4 x i32> @combine_test_movhl_2(<4 x i32> %a, <4 x i32> %b) {
; SSE-LABEL: combine_test_movhl_2:
; SSE:       # %bb.0:
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm0[1]
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_test_movhl_2:
; AVX:       # %bb.0:
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 2, i32 0, i32 3, i32 6>
  %2 = shufflevector <4 x i32> %1, <4 x i32> %b, <4 x i32> <i32 3, i32 7, i32 0, i32 2>
  ret <4 x i32> %2
}

define <4 x i32> @combine_test_movhl_3(<4 x i32> %a, <4 x i32> %b) {
; SSE-LABEL: combine_test_movhl_3:
; SSE:       # %bb.0:
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm0[1]
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_test_movhl_3:
; AVX:       # %bb.0:
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 7, i32 6, i32 3, i32 2>
  %2 = shufflevector <4 x i32> %1, <4 x i32> %b, <4 x i32> <i32 6, i32 0, i32 3, i32 2>
  ret <4 x i32> %2
}


; Verify that we fold shuffles according to rule:
;  (shuffle(shuffle A, Undef, M0), B, M1) -> (shuffle A, B, M2)

define <4 x float> @combine_undef_input_test1(<4 x float> %a, <4 x float> %b) {
; SSE2-LABEL: combine_undef_input_test1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movsd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_undef_input_test1:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movsd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_undef_input_test1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    blendps {{.*#+}} xmm0 = xmm1[0,1],xmm0[2,3]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_undef_input_test1:
; AVX:       # %bb.0:
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0,1],xmm0[2,3]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> undef, <4 x i32> <i32 4, i32 2, i32 3, i32 1>
  %2 = shufflevector <4 x float> %1, <4 x float> %b, <4 x i32> <i32 4, i32 5, i32 1, i32 2>
  ret <4 x float> %2
}

define <4 x float> @combine_undef_input_test2(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: combine_undef_input_test2:
; SSE:       # %bb.0:
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_undef_input_test2:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> undef, <4 x i32> <i32 6, i32 0, i32 1, i32 7>
  %2 = shufflevector <4 x float> %1, <4 x float> %b, <4 x i32> <i32 1, i32 2, i32 4, i32 5>
  ret <4 x float> %2
}

define <4 x float> @combine_undef_input_test3(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: combine_undef_input_test3:
; SSE:       # %bb.0:
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_undef_input_test3:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> undef, <4 x i32> <i32 0, i32 5, i32 1, i32 7>
  %2 = shufflevector <4 x float> %1, <4 x float> %b, <4 x i32> <i32 0, i32 2, i32 4, i32 1>
  ret <4 x float> %2
}

define <4 x float> @combine_undef_input_test4(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: combine_undef_input_test4:
; SSE:       # %bb.0:
; SSE-NEXT:    movhlps {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_undef_input_test4:
; AVX:       # %bb.0:
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> undef, <4 x i32> <i32 2, i32 3, i32 5, i32 5>
  %2 = shufflevector <4 x float> %1, <4 x float> %b, <4 x i32> <i32 6, i32 7, i32 0, i32 1>
  ret <4 x float> %2
}

define <4 x float> @combine_undef_input_test5(<4 x float> %a, <4 x float> %b) {
; SSE2-LABEL: combine_undef_input_test5:
; SSE2:       # %bb.0:
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,3]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_undef_input_test5:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,3]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_undef_input_test5:
; SSE41:       # %bb.0:
; SSE41-NEXT:    blendps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,3]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_undef_input_test5:
; AVX:       # %bb.0:
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,3]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> undef, <4 x i32> <i32 0, i32 4, i32 1, i32 3>
  %2 = shufflevector <4 x float> %1, <4 x float> %b, <4 x i32> <i32 0, i32 2, i32 6, i32 7>
  ret <4 x float> %2
}


; Verify that we fold shuffles according to rule:
;  (shuffle(shuffle A, Undef, M0), A, M1) -> (shuffle A, Undef, M2)

define <4 x float> @combine_undef_input_test6(<4 x float> %a) {
; CHECK-LABEL: combine_undef_input_test6:
; CHECK:       # %bb.0:
; CHECK-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> undef, <4 x i32> <i32 4, i32 2, i32 3, i32 1>
  %2 = shufflevector <4 x float> %1, <4 x float> %a, <4 x i32> <i32 4, i32 5, i32 1, i32 2>
  ret <4 x float> %2
}

define <4 x float> @combine_undef_input_test7(<4 x float> %a) {
; SSE2-LABEL: combine_undef_input_test7:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0,0]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_undef_input_test7:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movddup {{.*#+}} xmm0 = xmm0[0,0]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_undef_input_test7:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movddup {{.*#+}} xmm0 = xmm0[0,0]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_undef_input_test7:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovddup {{.*#+}} xmm0 = xmm0[0,0]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> undef, <4 x i32> <i32 6, i32 0, i32 1, i32 7>
  %2 = shufflevector <4 x float> %1, <4 x float> %a, <4 x i32> <i32 1, i32 2, i32 4, i32 5>
  ret <4 x float> %2
}

define <4 x float> @combine_undef_input_test8(<4 x float> %a) {
; SSE2-LABEL: combine_undef_input_test8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0,0]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_undef_input_test8:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movddup {{.*#+}} xmm0 = xmm0[0,0]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_undef_input_test8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movddup {{.*#+}} xmm0 = xmm0[0,0]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_undef_input_test8:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovddup {{.*#+}} xmm0 = xmm0[0,0]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> undef, <4 x i32> <i32 0, i32 5, i32 1, i32 7>
  %2 = shufflevector <4 x float> %1, <4 x float> %a, <4 x i32> <i32 0, i32 2, i32 4, i32 1>
  ret <4 x float> %2
}

define <4 x float> @combine_undef_input_test9(<4 x float> %a) {
; SSE-LABEL: combine_undef_input_test9:
; SSE:       # %bb.0:
; SSE-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_undef_input_test9:
; AVX:       # %bb.0:
; AVX-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,1]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> undef, <4 x i32> <i32 2, i32 3, i32 5, i32 5>
  %2 = shufflevector <4 x float> %1, <4 x float> %a, <4 x i32> <i32 6, i32 7, i32 0, i32 1>
  ret <4 x float> %2
}

define <4 x float> @combine_undef_input_test10(<4 x float> %a) {
; CHECK-LABEL: combine_undef_input_test10:
; CHECK:       # %bb.0:
; CHECK-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> undef, <4 x i32> <i32 0, i32 4, i32 1, i32 3>
  %2 = shufflevector <4 x float> %1, <4 x float> %a, <4 x i32> <i32 0, i32 2, i32 6, i32 7>
  ret <4 x float> %2
}

define <4 x float> @combine_undef_input_test11(<4 x float> %a, <4 x float> %b) {
; SSE2-LABEL: combine_undef_input_test11:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movsd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_undef_input_test11:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movsd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_undef_input_test11:
; SSE41:       # %bb.0:
; SSE41-NEXT:    blendps {{.*#+}} xmm0 = xmm1[0,1],xmm0[2,3]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_undef_input_test11:
; AVX:       # %bb.0:
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0,1],xmm0[2,3]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> undef, <4 x i32> <i32 4, i32 2, i32 3, i32 1>
  %2 = shufflevector <4 x float> %b, <4 x float> %1, <4 x i32> <i32 0, i32 1, i32 5, i32 6>
  ret <4 x float> %2
}

define <4 x float> @combine_undef_input_test12(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: combine_undef_input_test12:
; SSE:       # %bb.0:
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_undef_input_test12:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> undef, <4 x i32> <i32 6, i32 0, i32 1, i32 7>
  %2 = shufflevector <4 x float> %b, <4 x float> %1, <4 x i32> <i32 5, i32 6, i32 0, i32 1>
  ret <4 x float> %2
}

define <4 x float> @combine_undef_input_test13(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: combine_undef_input_test13:
; SSE:       # %bb.0:
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_undef_input_test13:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> undef, <4 x i32> <i32 0, i32 5, i32 1, i32 7>
  %2 = shufflevector <4 x float> %b, <4 x float> %1, <4 x i32> <i32 4, i32 5, i32 0, i32 5>
  ret <4 x float> %2
}

define <4 x float> @combine_undef_input_test14(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: combine_undef_input_test14:
; SSE:       # %bb.0:
; SSE-NEXT:    movhlps {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_undef_input_test14:
; AVX:       # %bb.0:
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> undef, <4 x i32> <i32 2, i32 3, i32 5, i32 5>
  %2 = shufflevector <4 x float> %b, <4 x float> %1, <4 x i32> <i32 2, i32 3, i32 4, i32 5>
  ret <4 x float> %2
}

define <4 x float> @combine_undef_input_test15(<4 x float> %a, <4 x float> %b) {
; SSE2-LABEL: combine_undef_input_test15:
; SSE2:       # %bb.0:
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,3]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_undef_input_test15:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,3]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_undef_input_test15:
; SSE41:       # %bb.0:
; SSE41-NEXT:    blendps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,3]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_undef_input_test15:
; AVX:       # %bb.0:
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,3]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> undef, <4 x i32> <i32 0, i32 4, i32 1, i32 3>
  %2 = shufflevector <4 x float> %b, <4 x float> %1, <4 x i32> <i32 4, i32 6, i32 2, i32 3>
  ret <4 x float> %2
}


; Verify that shuffles are canonicalized according to rules:
;  shuffle(B, shuffle(A, Undef)) -> shuffle(shuffle(A, Undef), B)
;
; This allows to trigger the following combine rule:
;  (shuffle(shuffle A, Undef, M0), A, M1) -> (shuffle A, Undef, M2)
;
; As a result, all the shuffle pairs in each function below should be
; combined into a single legal shuffle operation.

define <4 x float> @combine_undef_input_test16(<4 x float> %a) {
; CHECK-LABEL: combine_undef_input_test16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> undef, <4 x i32> <i32 4, i32 2, i32 3, i32 1>
  %2 = shufflevector <4 x float> %a, <4 x float> %1, <4 x i32> <i32 0, i32 1, i32 5, i32 3>
  ret <4 x float> %2
}

define <4 x float> @combine_undef_input_test17(<4 x float> %a) {
; SSE2-LABEL: combine_undef_input_test17:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0,0]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_undef_input_test17:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movddup {{.*#+}} xmm0 = xmm0[0,0]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_undef_input_test17:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movddup {{.*#+}} xmm0 = xmm0[0,0]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_undef_input_test17:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovddup {{.*#+}} xmm0 = xmm0[0,0]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> undef, <4 x i32> <i32 6, i32 0, i32 1, i32 7>
  %2 = shufflevector <4 x float> %a, <4 x float> %1, <4 x i32> <i32 5, i32 6, i32 0, i32 1>
  ret <4 x float> %2
}

define <4 x float> @combine_undef_input_test18(<4 x float> %a) {
; SSE2-LABEL: combine_undef_input_test18:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0,0]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_undef_input_test18:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movddup {{.*#+}} xmm0 = xmm0[0,0]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_undef_input_test18:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movddup {{.*#+}} xmm0 = xmm0[0,0]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_undef_input_test18:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovddup {{.*#+}} xmm0 = xmm0[0,0]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> undef, <4 x i32> <i32 0, i32 5, i32 1, i32 7>
  %2 = shufflevector <4 x float> %a, <4 x float> %1, <4 x i32> <i32 4, i32 6, i32 0, i32 5>
  ret <4 x float> %2
}

define <4 x float> @combine_undef_input_test19(<4 x float> %a) {
; SSE-LABEL: combine_undef_input_test19:
; SSE:       # %bb.0:
; SSE-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_undef_input_test19:
; AVX:       # %bb.0:
; AVX-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,1]
; AVX-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> undef, <4 x i32> <i32 2, i32 3, i32 5, i32 5>
  %2 = shufflevector <4 x float> %a, <4 x float> %1, <4 x i32> <i32 2, i32 3, i32 4, i32 5>
  ret <4 x float> %2
}

define <4 x float> @combine_undef_input_test20(<4 x float> %a) {
; CHECK-LABEL: combine_undef_input_test20:
; CHECK:       # %bb.0:
; CHECK-NEXT:    retq
  %1 = shufflevector <4 x float> %a, <4 x float> undef, <4 x i32> <i32 0, i32 4, i32 1, i32 3>
  %2 = shufflevector <4 x float> %a, <4 x float> %1, <4 x i32> <i32 4, i32 6, i32 2, i32 3>
  ret <4 x float> %2
}

; These tests are designed to test the ability to combine away unnecessary
; operations feeding into a shuffle. The AVX cases are the important ones as
; they leverage operations which cannot be done naturally on the entire vector
; and thus are decomposed into multiple smaller operations.

define <8 x i32> @combine_unneeded_subvector1(<8 x i32> %a) {
; SSE-LABEL: combine_unneeded_subvector1:
; SSE:       # %bb.0:
; SSE-NEXT:    paddd {{.*}}(%rip), %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[3,2,1,0]
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: combine_unneeded_subvector1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpaddd {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: combine_unneeded_subvector1:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpaddd {{.*}}(%rip), %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: combine_unneeded_subvector1:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vpaddd {{.*}}(%rip), %ymm0, %ymm0
; AVX2-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [7,6,5,4,7,6,5,4]
; AVX2-FAST-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    retq
  %b = add <8 x i32> %a, <i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8>
  %c = shufflevector <8 x i32> %b, <8 x i32> undef, <8 x i32> <i32 7, i32 6, i32 5, i32 4, i32 7, i32 6, i32 5, i32 4>
  ret <8 x i32> %c
}

define <8 x i32> @combine_unneeded_subvector2(<8 x i32> %a, <8 x i32> %b) {
; SSE-LABEL: combine_unneeded_subvector2:
; SSE:       # %bb.0:
; SSE-NEXT:    paddd {{.*}}(%rip), %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[3,2,1,0]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[3,2,1,0]
; SSE-NEXT:    retq
;
; AVX1-LABEL: combine_unneeded_subvector2:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpaddd {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[2,3],ymm0[2,3]
; AVX1-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: combine_unneeded_subvector2:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddd {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm1[2,3],ymm0[2,3]
; AVX2-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[3,2,1,0,7,6,5,4]
; AVX2-NEXT:    retq
  %c = add <8 x i32> %a, <i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8>
  %d = shufflevector <8 x i32> %b, <8 x i32> %c, <8 x i32> <i32 7, i32 6, i32 5, i32 4, i32 15, i32 14, i32 13, i32 12>
  ret <8 x i32> %d
}

define <4 x float> @combine_insertps1(<4 x float> %a, <4 x float> %b) {
; SSE2-LABEL: combine_insertps1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],xmm0[1,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm0[2,3]
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_insertps1:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],xmm0[1,0]
; SSSE3-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm0[2,3]
; SSSE3-NEXT:    movaps %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_insertps1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    insertps {{.*#+}} xmm0 = xmm1[2],xmm0[1,2,3]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_insertps1:
; AVX:       # %bb.0:
; AVX-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[2],xmm0[1,2,3]
; AVX-NEXT:    retq

  %c = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32><i32 0, i32 6, i32 2, i32 4>
  %d = shufflevector <4 x float> %a, <4 x float> %c, <4 x i32> <i32 5, i32 1, i32 6, i32 3>
  ret <4 x float> %d
}

define <4 x float> @combine_insertps2(<4 x float> %a, <4 x float> %b) {
; SSE2-LABEL: combine_insertps2:
; SSE2:       # %bb.0:
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],xmm0[0,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],xmm0[2,3]
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_insertps2:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],xmm0[0,0]
; SSSE3-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],xmm0[2,3]
; SSSE3-NEXT:    movaps %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_insertps2:
; SSE41:       # %bb.0:
; SSE41-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0],xmm1[2],xmm0[2,3]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_insertps2:
; AVX:       # %bb.0:
; AVX-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0],xmm1[2],xmm0[2,3]
; AVX-NEXT:    retq

  %c = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32><i32 0, i32 1, i32 6, i32 7>
  %d = shufflevector <4 x float> %a, <4 x float> %c, <4 x i32> <i32 4, i32 6, i32 2, i32 3>
  ret <4 x float> %d
}

define <4 x float> @combine_insertps3(<4 x float> %a, <4 x float> %b) {
; SSE2-LABEL: combine_insertps3:
; SSE2:       # %bb.0:
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,0],xmm0[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm1[0,2]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_insertps3:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,0],xmm0[3,0]
; SSSE3-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm1[0,2]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_insertps3:
; SSE41:       # %bb.0:
; SSE41-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0,1],xmm1[0],xmm0[3]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_insertps3:
; AVX:       # %bb.0:
; AVX-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1],xmm1[0],xmm0[3]
; AVX-NEXT:    retq

  %c = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32><i32 0, i32 4, i32 2, i32 5>
  %d = shufflevector <4 x float> %a, <4 x float> %c, <4 x i32><i32 4, i32 1, i32 5, i32 3>
  ret <4 x float> %d
}

define <4 x float> @combine_insertps4(<4 x float> %a, <4 x float> %b) {
; SSE2-LABEL: combine_insertps4:
; SSE2:       # %bb.0:
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,3]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,0]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_insertps4:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,3]
; SSSE3-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,0]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_insertps4:
; SSE41:       # %bb.0:
; SSE41-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0,1,2],xmm1[0]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_insertps4:
; AVX:       # %bb.0:
; AVX-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1,2],xmm1[0]
; AVX-NEXT:    retq

  %c = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32><i32 0, i32 4, i32 2, i32 5>
  %d = shufflevector <4 x float> %a, <4 x float> %c, <4 x i32><i32 4, i32 1, i32 6, i32 5>
  ret <4 x float> %d
}

define void @combine_scalar_load_with_blend_with_zero(double* %a0, <4 x float>* %a1) {
; SSE-LABEL: combine_scalar_load_with_blend_with_zero:
; SSE:       # %bb.0:
; SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movaps %xmm0, (%rsi)
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_scalar_load_with_blend_with_zero:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX-NEXT:    vmovaps %xmm0, (%rsi)
; AVX-NEXT:    retq
  %1 = load double, double* %a0, align 8
  %2 = insertelement <2 x double> undef, double %1, i32 0
  %3 = insertelement <2 x double> %2, double 0.000000e+00, i32 1
  %4 = bitcast <2 x double> %3 to <4 x float>
  %5 = shufflevector <4 x float> %4, <4 x float> <float 0.000000e+00, float undef, float undef, float undef>, <4 x i32> <i32 0, i32 1, i32 4, i32 3>
  store <4 x float> %5, <4 x float>* %a1, align 16
  ret void
}

; PR30371
define <4 x float> @combine_constant_insertion_v4f32(float %f) {
; SSE2-LABEL: combine_constant_insertion_v4f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movaps {{.*#+}} xmm1 = <u,4.0E+0,5.0E+0,3.0E+0>
; SSE2-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_constant_insertion_v4f32:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movaps {{.*#+}} xmm1 = <u,4.0E+0,5.0E+0,3.0E+0>
; SSSE3-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSSE3-NEXT:    movaps %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_constant_insertion_v4f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    blendps {{.*#+}} xmm0 = xmm0[0],mem[1,2,3]
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_constant_insertion_v4f32:
; AVX:       # %bb.0:
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],mem[1,2,3]
; AVX-NEXT:    retq
  %a0 = insertelement <4 x float> undef, float %f, i32 0
  %ret = shufflevector <4 x float> %a0, <4 x float> <float undef, float 4.0, float 5.0, float 3.0>, <4 x i32> <i32 0, i32 5, i32 6, i32 7>
  ret <4 x float> %ret
}

define <4 x i32> @combine_constant_insertion_v4i32(i32 %f) {
; SSE2-LABEL: combine_constant_insertion_v4i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd %edi, %xmm1
; SSE2-NEXT:    movaps {{.*#+}} xmm0 = <u,4,5,30>
; SSE2-NEXT:    movss {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: combine_constant_insertion_v4i32:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movd %edi, %xmm1
; SSSE3-NEXT:    movaps {{.*#+}} xmm0 = <u,4,5,30>
; SSSE3-NEXT:    movss {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: combine_constant_insertion_v4i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa {{.*#+}} xmm0 = <u,4,5,30>
; SSE41-NEXT:    pinsrd $0, %edi, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: combine_constant_insertion_v4i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovdqa {{.*#+}} xmm0 = <u,4,5,30>
; AVX-NEXT:    vpinsrd $0, %edi, %xmm0, %xmm0
; AVX-NEXT:    retq
  %a0 = insertelement <4 x i32> undef, i32 %f, i32 0
  %ret = shufflevector <4 x i32> %a0, <4 x i32> <i32 undef, i32 4, i32 5, i32 30>, <4 x i32> <i32 0, i32 5, i32 6, i32 7>
  ret <4 x i32> %ret
}

define <4 x float> @PR22377(<4 x float> %a, <4 x float> %b) {
; SSE2-LABEL: PR22377:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    movaps %xmm0, %xmm1
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,3],xmm0[2,3]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2,0,2]
; SSE2-NEXT:    addps %xmm0, %xmm1
; SSE2-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: PR22377:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    movaps %xmm0, %xmm1
; SSSE3-NEXT:    haddps %xmm0, %xmm1
; SSSE3-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,1]
; SSSE3-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2,1,3]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: PR22377:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    movaps %xmm0, %xmm1
; SSE41-NEXT:    haddps %xmm0, %xmm1
; SSE41-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,1]
; SSE41-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2,1,3]
; SSE41-NEXT:    retq
;
; AVX-LABEL: PR22377:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vhaddps %xmm0, %xmm0, %xmm1
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,1]
; AVX-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX-NEXT:    retq
entry:
  %s1 = shufflevector <4 x float> %a, <4 x float> undef, <4 x i32> <i32 1, i32 3, i32 1, i32 3>
  %s2 = shufflevector <4 x float> %a, <4 x float> undef, <4 x i32> <i32 0, i32 2, i32 0, i32 2>
  %r2 = fadd <4 x float> %s1, %s2
  %s3 = shufflevector <4 x float> %s2, <4 x float> %r2, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
  ret <4 x float> %s3
}

define <4 x float> @PR22390(<4 x float> %a, <4 x float> %b) {
; SSE2-LABEL: PR22390:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,0,1,2]
; SSE2-NEXT:    movaps %xmm0, %xmm2
; SSE2-NEXT:    movss {{.*#+}} xmm2 = xmm1[0],xmm2[1,2,3]
; SSE2-NEXT:    addps %xmm0, %xmm2
; SSE2-NEXT:    movaps %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: PR22390:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,0,1,2]
; SSSE3-NEXT:    movaps %xmm0, %xmm2
; SSSE3-NEXT:    movss {{.*#+}} xmm2 = xmm1[0],xmm2[1,2,3]
; SSSE3-NEXT:    addps %xmm0, %xmm2
; SSSE3-NEXT:    movaps %xmm2, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: PR22390:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,0,1,2]
; SSE41-NEXT:    blendps {{.*#+}} xmm1 = xmm1[0],xmm0[1,2,3]
; SSE41-NEXT:    addps %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: PR22390:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,0,1,2]
; AVX-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0],xmm0[1,2,3]
; AVX-NEXT:    vaddps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
entry:
  %s1 = shufflevector <4 x float> %a, <4 x float> undef, <4 x i32> <i32 3, i32 0, i32 1, i32 2>
  %s2 = shufflevector <4 x float> %s1, <4 x float> %b, <4 x i32> <i32 4, i32 1, i32 2, i32 3>
  %r2 = fadd <4 x float> %s1, %s2
  ret <4 x float> %r2
}

define <8 x float> @PR22412(<8 x float> %a, <8 x float> %b) {
; SSE-LABEL: PR22412:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    movaps %xmm3, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,0],xmm3[3,2]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,0],xmm2[3,2]
; SSE-NEXT:    retq
;
; AVX1-LABEL: PR22412:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm1[2,3,0,1]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,0],ymm2[3,2],ymm0[5,4],ymm2[7,6]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: PR22412:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,3,0,1]
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,0],ymm1[3,2],ymm0[5,4],ymm1[7,6]
; AVX2-NEXT:    retq
entry:
  %s1 = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 1, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %s2 = shufflevector <8 x float> %s1, <8 x float> undef, <8 x i32> <i32 1, i32 0, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2>
  ret <8 x float> %s2
}

define <4 x float> @PR30264(<4 x float> %x) {
; SSE2-LABEL: PR30264:
; SSE2:       # %bb.0:
; SSE2-NEXT:    xorps %xmm1, %xmm1
; SSE2-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],mem[2,3]
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: PR30264:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    xorps %xmm1, %xmm1
; SSSE3-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSSE3-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],mem[2,3]
; SSSE3-NEXT:    movaps %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: PR30264:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movaps {{.*#+}} xmm1 = <u,u,4.0E+0,1.0E+0>
; SSE41-NEXT:    insertps {{.*#+}} xmm1 = xmm0[0],zero,xmm1[2,3]
; SSE41-NEXT:    movaps %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: PR30264:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps {{.*#+}} xmm1 = <u,u,4.0E+0,1.0E+0>
; AVX-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0],zero,xmm1[2,3]
; AVX-NEXT:    retq
  %shuf1 = shufflevector <4 x float> %x, <4 x float> <float undef, float 0.0, float undef, float undef>, <4 x i32> <i32 0, i32 5, i32 undef, i32 undef>
  %shuf2 = shufflevector <4 x float> %shuf1, <4 x float> <float undef, float undef, float 4.0, float 1.0>, <4 x i32> <i32 0, i32 1, i32 6, i32 7>
  ret <4 x float> %shuf2
}

define <8 x i16> @PR39549(<16 x i8> %x) {
; SSE-LABEL: PR39549:
; SSE:       # %bb.0:
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE-NEXT:    psraw $8, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: PR39549:
; AVX:       # %bb.0:
; AVX-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX-NEXT:    vpsraw $8, %xmm0, %xmm0
; AVX-NEXT:    retq
  %a = shufflevector <16 x i8> %x, <16 x i8> undef, <16 x i32> <i32 8, i32 undef, i32 9, i32 undef, i32 10, i32 undef, i32 11, i32 undef, i32 12, i32 undef, i32 13, i32 undef, i32 14, i32 undef, i32 15, i32 undef>
  %b = bitcast <16 x i8> %a to <8 x i16>
  %c = shl <8 x i16> %b, <i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8>
  %d = ashr <8 x i16> %c, <i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8>
  ret <8 x i16> %d
}

define <4 x i32> @PR41545(<4 x i32> %a0, <16 x i8> %a1) {
; SSE-LABEL: PR41545:
; SSE:       # %bb.0:
; SSE-NEXT:    paddd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: PR41545:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1  = shufflevector <16 x i8> %a1, <16 x i8> undef, <4 x i32> <i32 0, i32 4, i32 8, i32 12>
  %2  = shufflevector <16 x i8> %a1, <16 x i8> undef, <4 x i32> <i32 1, i32 5, i32 9, i32 13>
  %3  = shufflevector <16 x i8> %a1, <16 x i8> undef, <4 x i32> <i32 2, i32 6, i32 10, i32 14>
  %4  = shufflevector <16 x i8> %a1, <16 x i8> undef, <4 x i32> <i32 3, i32 7, i32 11, i32 15>
  %5  = zext <4 x i8> %1 to <4 x i32>
  %6  = zext <4 x i8> %2 to <4 x i32>
  %7  = zext <4 x i8> %3 to <4 x i32>
  %8  = zext <4 x i8> %4 to <4 x i32>
  %9  = shl <4 x i32> %6, <i32 8, i32 8, i32 8, i32 8>
  %10 = shl <4 x i32> %7, <i32 16, i32 16, i32 16, i32 16>
  %11 = shl <4 x i32> %8, <i32 24, i32 24, i32 24, i32 24>
  %12 = or <4 x i32> %5, %9
  %13 = or <4 x i32> %12, %10
  %14 = or <4 x i32> %13, %11
  %15 = add <4 x i32> %a0, %14
  ret <4 x i32> %15
}

define <8 x i16> @shuffle_extract_insert(<8 x i16> %a) {
; SSE-LABEL: shuffle_extract_insert:
; SSE:       # %bb.0:
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[2,1,0,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,5,4,7]
; SSE-NEXT:    retq
;
; AVX1-LABEL: shuffle_extract_insert:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[2,1,0,3,4,5,6,7]
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,5,4,7]
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: shuffle_extract_insert:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[2,1,0,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,5,4,7]
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: shuffle_extract_insert:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,5,2,3,0,1,6,7,12,13,10,11,8,9,14,15]
; AVX2-FAST-NEXT:    retq
  %a0 = extractelement <8 x i16> %a, i32 0
  %a1 = extractelement <8 x i16> %a, i32 1
  %a3 = extractelement <8 x i16> %a, i32 3
  %a4 = extractelement <8 x i16> %a, i32 4
  %a5 = extractelement <8 x i16> %a, i32 5
  %a6 = extractelement <8 x i16> %a, i32 6
  %a7 = extractelement <8 x i16> %a, i32 7
  %1 = shufflevector <8 x i16> %a, <8 x i16> %a, <8 x i32> <i32 2, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %2 = insertelement <8 x i16> %1, i16 %a1, i32 1
  %3 = insertelement <8 x i16> %2, i16 %a0, i32 2
  %4 = insertelement <8 x i16> %3, i16 %a3, i32 3
  %5 = insertelement <8 x i16> %4, i16 %a6, i32 4
  %6 = insertelement <8 x i16> %5, i16 %a5, i32 5
  %7 = insertelement <8 x i16> %6, i16 %a4, i32 6
  %8 = insertelement <8 x i16> %7, i16 %a7, i32 7
  ret <8 x i16> %8
}

define <8 x i16> @shuffle_extract_insert_double(<8 x i16> %a, <8 x i16> %b) {
; SSE2-LABEL: shuffle_extract_insert_double:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,3,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,7,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,3,2,4,5,6,7]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[1,0,3,2,4,5,6,7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: shuffle_extract_insert_double:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    pshufb {{.*#+}} xmm1 = xmm1[0,1,6,7,10,11,14,15,u,u,u,u,u,u,u,u]
; SSSE3-NEXT:    pshufb {{.*#+}} xmm0 = xmm0[4,5,0,1,12,13,8,9,u,u,u,u,u,u,u,u]
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: shuffle_extract_insert_double:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pshufb {{.*#+}} xmm1 = xmm1[0,1,6,7,10,11,14,15,u,u,u,u,u,u,u,u]
; SSE41-NEXT:    pshufb {{.*#+}} xmm0 = xmm0[4,5,0,1,12,13,8,9,u,u,u,u,u,u,u,u]
; SSE41-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE41-NEXT:    retq
;
; AVX-LABEL: shuffle_extract_insert_double:
; AVX:       # %bb.0:
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[0,1,6,7,10,11,14,15,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,5,0,1,12,13,8,9,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX-NEXT:    retq
  %a0 = extractelement <8 x i16> %a, i32 0
  %a4 = extractelement <8 x i16> %a, i32 4
  %a6 = extractelement <8 x i16> %a, i32 6
  %b11 = extractelement <8 x i16> %b, i32 3
  %b13 = extractelement <8 x i16> %b, i32 5
  %b15 = extractelement <8 x i16> %b, i32 7
  %1 = shufflevector <8 x i16> %a, <8 x i16> %b, <8 x i32> <i32 2, i32 8, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %2 = insertelement <8 x i16> %1, i16 %a0, i32 2
  %3 = insertelement <8 x i16> %2, i16 %b11, i32 3
  %4 = insertelement <8 x i16> %3, i16 %a6, i32 4
  %5 = insertelement <8 x i16> %4, i16 %b13, i32 5
  %6 = insertelement <8 x i16> %5, i16 %a4, i32 6
  %7 = insertelement <8 x i16> %6, i16 %b15, i32 7
  ret <8 x i16> %7
}

define <8 x i16> @shuffle_extract_concat_insert(<4 x i16> %lhsa, <4 x i16> %rhsa, <8 x i16> %b) {
; SSE2-LABEL: shuffle_extract_concat_insert:
; SSE2:       # %bb.0:
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[1,0,3,2,4,5,6,7]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm1 = xmm2[0,3,2,3,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,7,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,3,2,4,5,6,7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: shuffle_extract_concat_insert:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSSE3-NEXT:    pshufb {{.*#+}} xmm0 = xmm0[4,5,0,1,12,13,8,9,u,u,u,u,u,u,u,u]
; SSSE3-NEXT:    pshufb {{.*#+}} xmm2 = xmm2[0,1,6,7,10,11,14,15,u,u,u,u,u,u,u,u]
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: shuffle_extract_concat_insert:
; SSE41:       # %bb.0:
; SSE41-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE41-NEXT:    pshufb {{.*#+}} xmm0 = xmm0[4,5,0,1,12,13,8,9,u,u,u,u,u,u,u,u]
; SSE41-NEXT:    pshufb {{.*#+}} xmm2 = xmm2[0,1,6,7,10,11,14,15,u,u,u,u,u,u,u,u]
; SSE41-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE41-NEXT:    retq
;
; AVX-LABEL: shuffle_extract_concat_insert:
; AVX:       # %bb.0:
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,5,0,1,12,13,8,9,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = xmm2[0,1,6,7,10,11,14,15,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX-NEXT:    retq
  %a = shufflevector <4 x i16> %lhsa, <4 x i16> %rhsa, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %a0 = extractelement <8 x i16> %a, i32 0
  %a4 = extractelement <8 x i16> %a, i32 4
  %a6 = extractelement <8 x i16> %a, i32 6
  %b11 = extractelement <8 x i16> %b, i32 3
  %b13 = extractelement <8 x i16> %b, i32 5
  %b15 = extractelement <8 x i16> %b, i32 7
  %1 = shufflevector <8 x i16> %a, <8 x i16> %b, <8 x i32> <i32 2, i32 8, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %2 = insertelement <8 x i16> %1, i16 %a0, i32 2
  %3 = insertelement <8 x i16> %2, i16 %b11, i32 3
  %4 = insertelement <8 x i16> %3, i16 %a6, i32 4
  %5 = insertelement <8 x i16> %4, i16 %b13, i32 5
  %6 = insertelement <8 x i16> %5, i16 %a4, i32 6
  %7 = insertelement <8 x i16> %6, i16 %b15, i32 7
  ret <8 x i16> %7
}

define <8 x i16> @shuffle_scalar_to_vector_extract(<8 x i8>* %p0, i8* %p1, i8* %p2) {
; SSE2-LABEL: shuffle_scalar_to_vector_extract:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; SSE2-NEXT:    psraw $8, %xmm1
; SSE2-NEXT:    pextrw $7, %xmm1, %eax
; SSE2-NEXT:    movd %eax, %xmm2
; SSE2-NEXT:    movsbl (%rsi), %eax
; SSE2-NEXT:    movd %eax, %xmm0
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; SSE2-NEXT:    movsbl (%rdx), %eax
; SSE2-NEXT:    movd %eax, %xmm0
; SSE2-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: shuffle_scalar_to_vector_extract:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSSE3-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; SSSE3-NEXT:    psraw $8, %xmm1
; SSSE3-NEXT:    movsbl (%rsi), %eax
; SSSE3-NEXT:    movd %eax, %xmm2
; SSSE3-NEXT:    palignr {{.*#+}} xmm2 = xmm1[14,15],xmm2[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSSE3-NEXT:    movsbl (%rdx), %eax
; SSSE3-NEXT:    movd %eax, %xmm0
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; SSSE3-NEXT:    pxor %xmm0, %xmm0
; SSSE3-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: shuffle_scalar_to_vector_extract:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovsxbw (%rdi), %xmm0
; SSE41-NEXT:    pextrw $4, %xmm0, %eax
; SSE41-NEXT:    pextrw $7, %xmm0, %ecx
; SSE41-NEXT:    pxor %xmm0, %xmm0
; SSE41-NEXT:    pinsrw $1, %eax, %xmm0
; SSE41-NEXT:    movl $65531, %eax # imm = 0xFFFB
; SSE41-NEXT:    pinsrw $2, %eax, %xmm0
; SSE41-NEXT:    pinsrw $4, %ecx, %xmm0
; SSE41-NEXT:    movsbl (%rsi), %eax
; SSE41-NEXT:    pinsrw $5, %eax, %xmm0
; SSE41-NEXT:    movsbl (%rdx), %eax
; SSE41-NEXT:    pinsrw $6, %eax, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: shuffle_scalar_to_vector_extract:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmovsxbw (%rdi), %xmm0
; AVX-NEXT:    vpextrw $4, %xmm0, %eax
; AVX-NEXT:    vpextrw $7, %xmm0, %ecx
; AVX-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vpinsrw $1, %eax, %xmm0, %xmm0
; AVX-NEXT:    movl $65531, %eax # imm = 0xFFFB
; AVX-NEXT:    vpinsrw $2, %eax, %xmm0, %xmm0
; AVX-NEXT:    vpinsrw $4, %ecx, %xmm0, %xmm0
; AVX-NEXT:    movsbl (%rsi), %eax
; AVX-NEXT:    vpinsrw $5, %eax, %xmm0, %xmm0
; AVX-NEXT:    movsbl (%rdx), %eax
; AVX-NEXT:    vpinsrw $6, %eax, %xmm0, %xmm0
; AVX-NEXT:    retq
  %tmp = load <8 x i8>, <8 x i8>* %p0, align 1
  %tmp1 = sext <8 x i8> %tmp to <8 x i16>
  %tmp2 = load i8, i8* %p1, align 1
  %cvt1 = sext i8 %tmp2 to i16
  %tmp3 = load i8, i8* %p2, align 1
  %cvt2 = sext i8 %tmp3 to i16
  %tmp4 = extractelement <8 x i16> %tmp1, i32 4
  %tmp5 = extractelement <8 x i16> %tmp1, i32 7
  %tmp6 = insertelement <8 x i16> <i16 undef, i16 undef, i16 -5, i16 undef, i16 undef, i16 undef, i16 undef, i16 undef>, i16 undef, i32 0
  %tmp7 = insertelement <8 x i16> %tmp6, i16 %tmp4, i32 1
  %tmp8 = insertelement <8 x i16> %tmp7, i16 undef, i32 3
  %tmp9 = insertelement <8 x i16> %tmp8, i16 %tmp5, i32 4
  %tmp10 = insertelement <8 x i16> %tmp9, i16 %cvt1, i32 5
  %tmp11 = insertelement <8 x i16> %tmp10, i16 %cvt2, i32 6
  %tmp12 = insertelement <8 x i16> %tmp11, i16 undef, i32 7
  %tmp13 = shufflevector <8 x i16> %tmp12, <8 x i16> undef, <8 x i32> <i32 0, i32 1, i32 10, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i16> %tmp13
}

define void @PR43024() {
; SSE-LABEL: PR43024:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps {{.*#+}} xmm0 = [NaN,NaN,0.0E+0,0.0E+0]
; SSE-NEXT:    movaps %xmm0, (%rax)
; SSE-NEXT:    addss {{.*}}(%rip), %xmm0
; SSE-NEXT:    xorps %xmm1, %xmm1
; SSE-NEXT:    addss %xmm1, %xmm0
; SSE-NEXT:    addss %xmm1, %xmm0
; SSE-NEXT:    movss %xmm0, (%rax)
; SSE-NEXT:    retq
;
; AVX-LABEL: PR43024:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps {{.*#+}} xmm0 = [NaN,NaN,0.0E+0,0.0E+0]
; AVX-NEXT:    vmovaps %xmm0, (%rax)
; AVX-NEXT:    vaddss {{\.LCPI.*}}+{{.*}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vaddss %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vaddss {{\.LCPI.*}}+{{.*}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    vmovss %xmm0, (%rax)
; AVX-NEXT:    retq
  store <4 x float> <float 0x7FF8000000000000, float 0x7FF8000000000000, float 0x0, float 0x0>, <4 x float>* undef, align 16
  %1 = load <4 x float>, <4 x float>* undef, align 16
  %2 = fmul <4 x float> %1, <float 0x0, float 0x0, float 0x0, float 0x0>
  %3 = shufflevector <4 x float> %2, <4 x float> undef, <4 x i32> <i32 1, i32 undef, i32 undef, i32 undef>
  %4 = fadd <4 x float> %2, %3
  %5 = fadd <4 x float> zeroinitializer, %4
  %6 = shufflevector <4 x float> %2, <4 x float> undef, <4 x i32> <i32 3, i32 undef, i32 undef, i32 undef>
  %7 = fadd <4 x float> %6, %5
  %8 = extractelement <4 x float> %7, i32 0
  store float %8, float* undef, align 8
  ret void
}

define void @PR45604(<32 x i16>* %dst, <8 x i16>* %src) {
; SSE2-LABEL: PR45604:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa (%rsi), %xmm1
; SSE2-NEXT:    movd %xmm1, %eax
; SSE2-NEXT:    movzwl %ax, %eax
; SSE2-NEXT:    movd %eax, %xmm0
; SSE2-NEXT:    movl $11, %eax
; SSE2-NEXT:    pinsrw $2, %eax, %xmm0
; SSE2-NEXT:    pextrw $1, %xmm1, %ecx
; SSE2-NEXT:    pinsrw $4, %ecx, %xmm0
; SSE2-NEXT:    pinsrw $6, %eax, %xmm0
; SSE2-NEXT:    pextrw $2, %xmm1, %ecx
; SSE2-NEXT:    movd %ecx, %xmm2
; SSE2-NEXT:    pinsrw $2, %eax, %xmm2
; SSE2-NEXT:    pextrw $3, %xmm1, %ecx
; SSE2-NEXT:    pinsrw $4, %ecx, %xmm2
; SSE2-NEXT:    pinsrw $6, %eax, %xmm2
; SSE2-NEXT:    pextrw $4, %xmm1, %ecx
; SSE2-NEXT:    movd %ecx, %xmm3
; SSE2-NEXT:    pinsrw $2, %eax, %xmm3
; SSE2-NEXT:    pextrw $5, %xmm1, %ecx
; SSE2-NEXT:    pinsrw $4, %ecx, %xmm3
; SSE2-NEXT:    pinsrw $6, %eax, %xmm3
; SSE2-NEXT:    pextrw $6, %xmm1, %ecx
; SSE2-NEXT:    movd %ecx, %xmm4
; SSE2-NEXT:    pinsrw $2, %eax, %xmm4
; SSE2-NEXT:    pextrw $7, %xmm1, %ecx
; SSE2-NEXT:    pinsrw $4, %ecx, %xmm4
; SSE2-NEXT:    pinsrw $6, %eax, %xmm4
; SSE2-NEXT:    movdqa %xmm4, 48(%rdi)
; SSE2-NEXT:    movdqa %xmm3, 32(%rdi)
; SSE2-NEXT:    movdqa %xmm2, 16(%rdi)
; SSE2-NEXT:    movdqa %xmm0, (%rdi)
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: PR45604:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa (%rsi), %xmm1
; SSSE3-NEXT:    movd %xmm1, %eax
; SSSE3-NEXT:    movzwl %ax, %eax
; SSSE3-NEXT:    movd %eax, %xmm0
; SSSE3-NEXT:    movl $11, %eax
; SSSE3-NEXT:    pinsrw $2, %eax, %xmm0
; SSSE3-NEXT:    pextrw $1, %xmm1, %ecx
; SSSE3-NEXT:    pinsrw $4, %ecx, %xmm0
; SSSE3-NEXT:    pinsrw $6, %eax, %xmm0
; SSSE3-NEXT:    pextrw $2, %xmm1, %ecx
; SSSE3-NEXT:    movd %ecx, %xmm2
; SSSE3-NEXT:    pinsrw $2, %eax, %xmm2
; SSSE3-NEXT:    pextrw $3, %xmm1, %ecx
; SSSE3-NEXT:    pinsrw $4, %ecx, %xmm2
; SSSE3-NEXT:    pinsrw $6, %eax, %xmm2
; SSSE3-NEXT:    pextrw $4, %xmm1, %ecx
; SSSE3-NEXT:    movd %ecx, %xmm3
; SSSE3-NEXT:    pinsrw $2, %eax, %xmm3
; SSSE3-NEXT:    pextrw $5, %xmm1, %ecx
; SSSE3-NEXT:    pinsrw $4, %ecx, %xmm3
; SSSE3-NEXT:    pinsrw $6, %eax, %xmm3
; SSSE3-NEXT:    pextrw $6, %xmm1, %ecx
; SSSE3-NEXT:    movd %ecx, %xmm4
; SSSE3-NEXT:    pinsrw $2, %eax, %xmm4
; SSSE3-NEXT:    pextrw $7, %xmm1, %ecx
; SSSE3-NEXT:    pinsrw $4, %ecx, %xmm4
; SSSE3-NEXT:    pinsrw $6, %eax, %xmm4
; SSSE3-NEXT:    movdqa %xmm4, 48(%rdi)
; SSSE3-NEXT:    movdqa %xmm3, 32(%rdi)
; SSSE3-NEXT:    movdqa %xmm2, 16(%rdi)
; SSSE3-NEXT:    movdqa %xmm0, (%rdi)
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: PR45604:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa (%rsi), %xmm1
; SSE41-NEXT:    pextrw $2, %xmm1, %eax
; SSE41-NEXT:    movd %eax, %xmm0
; SSE41-NEXT:    movl $11, %eax
; SSE41-NEXT:    pinsrw $2, %eax, %xmm0
; SSE41-NEXT:    pextrw $3, %xmm1, %ecx
; SSE41-NEXT:    pinsrw $4, %ecx, %xmm0
; SSE41-NEXT:    pinsrw $6, %eax, %xmm0
; SSE41-NEXT:    pextrw $4, %xmm1, %ecx
; SSE41-NEXT:    movd %ecx, %xmm2
; SSE41-NEXT:    pinsrw $2, %eax, %xmm2
; SSE41-NEXT:    pextrw $5, %xmm1, %ecx
; SSE41-NEXT:    pinsrw $4, %ecx, %xmm2
; SSE41-NEXT:    pinsrw $6, %eax, %xmm2
; SSE41-NEXT:    pextrw $6, %xmm1, %ecx
; SSE41-NEXT:    movd %ecx, %xmm3
; SSE41-NEXT:    pinsrw $2, %eax, %xmm3
; SSE41-NEXT:    pextrw $7, %xmm1, %ecx
; SSE41-NEXT:    pinsrw $4, %ecx, %xmm3
; SSE41-NEXT:    pinsrw $6, %eax, %xmm3
; SSE41-NEXT:    pxor %xmm4, %xmm4
; SSE41-NEXT:    pblendw {{.*#+}} xmm4 = xmm1[0],xmm4[1,2,3,4,5,6,7]
; SSE41-NEXT:    pinsrw $2, %eax, %xmm4
; SSE41-NEXT:    pextrw $1, %xmm1, %ecx
; SSE41-NEXT:    pinsrw $4, %ecx, %xmm4
; SSE41-NEXT:    pinsrw $6, %eax, %xmm4
; SSE41-NEXT:    movdqa %xmm4, (%rdi)
; SSE41-NEXT:    movdqa %xmm3, 48(%rdi)
; SSE41-NEXT:    movdqa %xmm2, 32(%rdi)
; SSE41-NEXT:    movdqa %xmm0, 16(%rdi)
; SSE41-NEXT:    retq
;
; AVX1-LABEL: PR45604:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rsi), %xmm0
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[3,3,3,3]
; AVX1-NEXT:    vpmovzxwq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [11,11,11,0,11,11,11,0]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1],xmm2[2,3],xmm1[4,5],xmm2[6,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[2,3,2,3]
; AVX1-NEXT:    vpmovzxwq {{.*#+}} xmm3 = xmm3[0],zero,zero,zero,xmm3[1],zero,zero,zero
; AVX1-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1],xmm2[2,3],xmm3[4,5],xmm2[6,7]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[1,1,1,1]
; AVX1-NEXT:    vpmovzxwq {{.*#+}} xmm3 = xmm3[0],zero,zero,zero,xmm3[1],zero,zero,zero
; AVX1-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1],xmm2[2,3],xmm3[4,5],xmm2[6,7]
; AVX1-NEXT:    vpmovzxwq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm2[2,3],xmm0[4,5],xmm2[6,7]
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX1-NEXT:    vmovups %ymm0, (%rdi)
; AVX1-NEXT:    vmovups %ymm1, 32(%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: PR45604:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rsi), %xmm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[0,2,0,2]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = <0,1,8,9,u,u,u,u,2,3,10,11,u,u,u,u,4,5,12,13,u,u,u,u,6,7,14,15,u,u,u,u>
; AVX2-NEXT:    vpshufb %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = <u,u,u,u,11,0,0,0,u,u,u,u,11,0,0,0,u,u,u,u,11,0,0,0,u,u,u,u,11,0,0,0>
; AVX2-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0],ymm3[1],ymm1[2],ymm3[3],ymm1[4],ymm3[5],ymm1[6],ymm3[7]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[1,3,1,3]
; AVX2-NEXT:    vpshufb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0],ymm3[1],ymm0[2],ymm3[3],ymm0[4],ymm3[5],ymm0[6],ymm3[7]
; AVX2-NEXT:    vmovdqu %ymm0, 32(%rdi)
; AVX2-NEXT:    vmovdqu %ymm1, (%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
  %v1 = load <8 x i16>, <8 x i16>* %src, align 16
  %v2 = shufflevector <8 x i16> %v1, <8 x i16> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %v3 = shufflevector <16 x i16> %v2, <16 x i16> <i16 11, i16 11, i16 11, i16 11, i16 11, i16 11, i16 11, i16 11, i16 0, i16 0, i16 0, i16 0, i16 0, i16 0, i16 0, i16 0>, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
  store <32 x i16> %v3, <32 x i16>* %dst, align 16
  ret void
}
