; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumbv8.1m.main-none-none-eabi -mattr=+mve -verify-machineinstrs %s -o - | FileCheck %s

define arm_aapcs_vfpcc <4 x i32> @vqshrni32_smaxmin(<4 x i32> %so) {
; CHECK-LABEL: vqshrni32_smaxmin:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqshrnb.s32 q0, q0, #3
; CHECK-NEXT:    vmovlb.s16 q0, q0
; CHECK-NEXT:    bx lr
entry:
  %s0 = ashr <4 x i32> %so, <i32 3, i32 3, i32 3, i32 3>
  %c1 = icmp slt <4 x i32> %s0, <i32 32767, i32 32767, i32 32767, i32 32767>
  %s1 = select <4 x i1> %c1, <4 x i32> %s0, <4 x i32> <i32 32767, i32 32767, i32 32767, i32 32767>
  %c2 = icmp sgt <4 x i32> %s1, <i32 -32768, i32 -32768, i32 -32768, i32 -32768>
  %s2 = select <4 x i1> %c2, <4 x i32> %s1, <4 x i32> <i32 -32768, i32 -32768, i32 -32768, i32 -32768>
  ret <4 x i32> %s2
}

define arm_aapcs_vfpcc <4 x i32> @vqshrni32_sminmax(<4 x i32> %so) {
; CHECK-LABEL: vqshrni32_sminmax:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqshrnb.s32 q0, q0, #3
; CHECK-NEXT:    vmovlb.s16 q0, q0
; CHECK-NEXT:    bx lr
entry:
  %s0 = ashr <4 x i32> %so, <i32 3, i32 3, i32 3, i32 3>
  %c1 = icmp sgt <4 x i32> %s0, <i32 -32768, i32 -32768, i32 -32768, i32 -32768>
  %s1 = select <4 x i1> %c1, <4 x i32> %s0, <4 x i32> <i32 -32768, i32 -32768, i32 -32768, i32 -32768>
  %c2 = icmp slt <4 x i32> %s1, <i32 32767, i32 32767, i32 32767, i32 32767>
  %s2 = select <4 x i1> %c2, <4 x i32> %s1, <4 x i32> <i32 32767, i32 32767, i32 32767, i32 32767>
  ret <4 x i32> %s2
}

define arm_aapcs_vfpcc <4 x i32> @vqshrni32_umaxmin(<4 x i32> %so) {
; CHECK-LABEL: vqshrni32_umaxmin:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqshrnb.u32 q0, q0, #3
; CHECK-NEXT:    vmovlb.u16 q0, q0
; CHECK-NEXT:    bx lr
entry:
  %s0 = lshr <4 x i32> %so, <i32 3, i32 3, i32 3, i32 3>
  %c1 = icmp ult <4 x i32> %s0, <i32 65535, i32 65535, i32 65535, i32 65535>
  %s1 = select <4 x i1> %c1, <4 x i32> %s0, <4 x i32> <i32 65535, i32 65535, i32 65535, i32 65535>
  ret <4 x i32> %s1
}

define arm_aapcs_vfpcc <4 x i32> @vqshrni32_uminmax(<4 x i32> %so) {
; CHECK-LABEL: vqshrni32_uminmax:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqshrnb.u32 q0, q0, #3
; CHECK-NEXT:    vmovlb.u16 q0, q0
; CHECK-NEXT:    bx lr
entry:
  %s0 = lshr <4 x i32> %so, <i32 3, i32 3, i32 3, i32 3>
  %c2 = icmp ult <4 x i32> %s0, <i32 65535, i32 65535, i32 65535, i32 65535>
  %s2 = select <4 x i1> %c2, <4 x i32> %s0, <4 x i32> <i32 65535, i32 65535, i32 65535, i32 65535>
  ret <4 x i32> %s2
}

define arm_aapcs_vfpcc <8 x i16> @vqshrni16_smaxmin(<8 x i16> %so) {
; CHECK-LABEL: vqshrni16_smaxmin:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqshrnb.s16 q0, q0, #3
; CHECK-NEXT:    vmovlb.s8 q0, q0
; CHECK-NEXT:    bx lr
entry:
  %s0 = ashr <8 x i16> %so, <i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3>
  %c1 = icmp slt <8 x i16> %s0, <i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127>
  %s1 = select <8 x i1> %c1, <8 x i16> %s0, <8 x i16> <i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127>
  %c2 = icmp sgt <8 x i16> %s1, <i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128>
  %s2 = select <8 x i1> %c2, <8 x i16> %s1, <8 x i16> <i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128>
  ret <8 x i16> %s2
}

define arm_aapcs_vfpcc <8 x i16> @vqshrni16_sminmax(<8 x i16> %so) {
; CHECK-LABEL: vqshrni16_sminmax:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqshrnb.s16 q0, q0, #3
; CHECK-NEXT:    vmovlb.s8 q0, q0
; CHECK-NEXT:    bx lr
entry:
  %s0 = ashr <8 x i16> %so, <i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3>
  %c1 = icmp sgt <8 x i16> %s0, <i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128>
  %s1 = select <8 x i1> %c1, <8 x i16> %s0, <8 x i16> <i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128>
  %c2 = icmp slt <8 x i16> %s1, <i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127>
  %s2 = select <8 x i1> %c2, <8 x i16> %s1, <8 x i16> <i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127>
  ret <8 x i16> %s2
}

define arm_aapcs_vfpcc <8 x i16> @vqshrni16_umaxmin(<8 x i16> %so) {
; CHECK-LABEL: vqshrni16_umaxmin:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqshrnb.u16 q0, q0, #3
; CHECK-NEXT:    vmovlb.u8 q0, q0
; CHECK-NEXT:    bx lr
entry:
  %s0 = lshr <8 x i16> %so, <i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3>
  %c1 = icmp ult <8 x i16> %s0, <i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255>
  %s1 = select <8 x i1> %c1, <8 x i16> %s0, <8 x i16> <i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255>
  ret <8 x i16> %s1
}

define arm_aapcs_vfpcc <8 x i16> @vqshrni16_uminmax(<8 x i16> %so) {
; CHECK-LABEL: vqshrni16_uminmax:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqshrnb.u16 q0, q0, #3
; CHECK-NEXT:    vmovlb.u8 q0, q0
; CHECK-NEXT:    bx lr
entry:
  %s0 = lshr <8 x i16> %so, <i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3>
  %c2 = icmp ult <8 x i16> %s0, <i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255>
  %s2 = select <8 x i1> %c2, <8 x i16> %s0, <8 x i16> <i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255>
  ret <8 x i16> %s2
}

define arm_aapcs_vfpcc <16 x i8> @vqshrni8_smaxmin(<16 x i8> %so) {
; CHECK-LABEL: vqshrni8_smaxmin:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vshr.s8 q0, q0, #3
; CHECK-NEXT:    vmov.i8 q1, #0x7
; CHECK-NEXT:    vmin.s8 q0, q0, q1
; CHECK-NEXT:    vmov.i8 q1, #0xf8
; CHECK-NEXT:    vmax.s8 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %s0 = ashr <16 x i8> %so, <i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3>
  %c1 = icmp slt <16 x i8> %s0, <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7>
  %s1 = select <16 x i1> %c1, <16 x i8> %s0, <16 x i8> <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7>
  %c2 = icmp sgt <16 x i8> %s1, <i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8>
  %s2 = select <16 x i1> %c2, <16 x i8> %s1, <16 x i8> <i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8>
  ret <16 x i8> %s2
}

define arm_aapcs_vfpcc <16 x i8> @vqshrni8_sminmax(<16 x i8> %so) {
; CHECK-LABEL: vqshrni8_sminmax:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vshr.s8 q0, q0, #3
; CHECK-NEXT:    vmov.i8 q1, #0xf8
; CHECK-NEXT:    vmax.s8 q0, q0, q1
; CHECK-NEXT:    vmov.i8 q1, #0x7
; CHECK-NEXT:    vmin.s8 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %s0 = ashr <16 x i8> %so, <i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3>
  %c1 = icmp sgt <16 x i8> %s0, <i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8>
  %s1 = select <16 x i1> %c1, <16 x i8> %s0, <16 x i8> <i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8, i8 -8>
  %c2 = icmp slt <16 x i8> %s1, <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7>
  %s2 = select <16 x i1> %c2, <16 x i8> %s1, <16 x i8> <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7>
  ret <16 x i8> %s2
}

define arm_aapcs_vfpcc <16 x i8> @vqshrni8_umaxmin(<16 x i8> %so) {
; CHECK-LABEL: vqshrni8_umaxmin:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vshr.u8 q0, q0, #3
; CHECK-NEXT:    vmov.i8 q1, #0xf
; CHECK-NEXT:    vmin.u8 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %s0 = lshr <16 x i8> %so, <i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3>
  %c1 = icmp ult <16 x i8> %s0, <i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15>
  %s1 = select <16 x i1> %c1, <16 x i8> %s0, <16 x i8> <i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15>
  ret <16 x i8> %s1
}

define arm_aapcs_vfpcc <16 x i8> @vqshrni8_uminmax(<16 x i8> %so) {
; CHECK-LABEL: vqshrni8_uminmax:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vshr.u8 q0, q0, #3
; CHECK-NEXT:    vmov.i8 q1, #0xf
; CHECK-NEXT:    vmin.u8 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %s0 = lshr <16 x i8> %so, <i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3>
  %c2 = icmp ult <16 x i8> %s0, <i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15>
  %s2 = select <16 x i1> %c2, <16 x i8> %s0, <16 x i8> <i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15>
  ret <16 x i8> %s2
}

define arm_aapcs_vfpcc <2 x i64> @vqshrni64_smaxmin(<2 x i64> %so) {
; CHECK-LABEL: vqshrni64_smaxmin:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r5, lr}
; CHECK-NEXT:    push {r5, lr}
; CHECK-NEXT:    vmov r5, s1
; CHECK-NEXT:    mvn lr, #-2147483648
; CHECK-NEXT:    vmov r2, s0
; CHECK-NEXT:    mov.w r12, #0
; CHECK-NEXT:    asrl r2, r5, #3
; CHECK-NEXT:    vmov r3, s3
; CHECK-NEXT:    subs.w r0, r2, lr
; CHECK-NEXT:    vmov.32 q2[0], r2
; CHECK-NEXT:    sbcs r0, r5, #0
; CHECK-NEXT:    vmov.32 q2[1], r5
; CHECK-NEXT:    mov.w r0, #0
; CHECK-NEXT:    mov.w r2, #-1
; CHECK-NEXT:    it lt
; CHECK-NEXT:    movlt r0, #1
; CHECK-NEXT:    cmp r0, #0
; CHECK-NEXT:    csetm r0, ne
; CHECK-NEXT:    vmov.32 q1[0], r0
; CHECK-NEXT:    vmov.32 q1[1], r0
; CHECK-NEXT:    vmov r0, s2
; CHECK-NEXT:    asrl r0, r3, #3
; CHECK-NEXT:    subs.w r1, r0, lr
; CHECK-NEXT:    vmov.32 q2[2], r0
; CHECK-NEXT:    sbcs r1, r3, #0
; CHECK-NEXT:    vmov.32 q2[3], r3
; CHECK-NEXT:    mov.w r1, #0
; CHECK-NEXT:    it lt
; CHECK-NEXT:    movlt r1, #1
; CHECK-NEXT:    cmp r1, #0
; CHECK-NEXT:    csetm r1, ne
; CHECK-NEXT:    vmov.32 q1[2], r1
; CHECK-NEXT:    vmov.32 q1[3], r1
; CHECK-NEXT:    adr r1, .LCPI12_0
; CHECK-NEXT:    vldrw.u32 q0, [r1]
; CHECK-NEXT:    vbic q0, q0, q1
; CHECK-NEXT:    vand q1, q2, q1
; CHECK-NEXT:    vorr q0, q1, q0
; CHECK-NEXT:    vmov r1, s0
; CHECK-NEXT:    vmov r0, s1
; CHECK-NEXT:    rsbs.w r1, r1, #-2147483648
; CHECK-NEXT:    sbcs.w r0, r2, r0
; CHECK-NEXT:    vmov r1, s2
; CHECK-NEXT:    mov.w r0, #0
; CHECK-NEXT:    it lt
; CHECK-NEXT:    movlt r0, #1
; CHECK-NEXT:    cmp r0, #0
; CHECK-NEXT:    csetm r0, ne
; CHECK-NEXT:    vmov.32 q1[0], r0
; CHECK-NEXT:    vmov.32 q1[1], r0
; CHECK-NEXT:    vmov r0, s3
; CHECK-NEXT:    rsbs.w r1, r1, #-2147483648
; CHECK-NEXT:    sbcs.w r0, r2, r0
; CHECK-NEXT:    it lt
; CHECK-NEXT:    movlt.w r12, #1
; CHECK-NEXT:    cmp.w r12, #0
; CHECK-NEXT:    csetm r0, ne
; CHECK-NEXT:    vmov.32 q1[2], r0
; CHECK-NEXT:    vmov.32 q1[3], r0
; CHECK-NEXT:    adr r0, .LCPI12_1
; CHECK-NEXT:    vldrw.u32 q2, [r0]
; CHECK-NEXT:    vand q0, q0, q1
; CHECK-NEXT:    vbic q2, q2, q1
; CHECK-NEXT:    vorr q0, q0, q2
; CHECK-NEXT:    pop {r5, pc}
; CHECK-NEXT:    .p2align 4
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI12_0:
; CHECK-NEXT:    .long 2147483647 @ 0x7fffffff
; CHECK-NEXT:    .long 0 @ 0x0
; CHECK-NEXT:    .long 2147483647 @ 0x7fffffff
; CHECK-NEXT:    .long 0 @ 0x0
; CHECK-NEXT:  .LCPI12_1:
; CHECK-NEXT:    .long 2147483648 @ 0x80000000
; CHECK-NEXT:    .long 4294967295 @ 0xffffffff
; CHECK-NEXT:    .long 2147483648 @ 0x80000000
; CHECK-NEXT:    .long 4294967295 @ 0xffffffff
entry:
  %s0 = ashr <2 x i64> %so, <i64 3, i64 3>
  %c1 = icmp slt <2 x i64> %s0, <i64 2147483647, i64 2147483647>
  %s1 = select <2 x i1> %c1, <2 x i64> %s0, <2 x i64> <i64 2147483647, i64 2147483647>
  %c2 = icmp sgt <2 x i64> %s1, <i64 -2147483648, i64 -2147483648>
  %s2 = select <2 x i1> %c2, <2 x i64> %s1, <2 x i64> <i64 -2147483648, i64 -2147483648>
  ret <2 x i64> %s2
}

define arm_aapcs_vfpcc <2 x i64> @vqshrni64_sminmax(<2 x i64> %so) {
; CHECK-LABEL: vqshrni64_sminmax:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, lr}
; CHECK-NEXT:    push {r4, lr}
; CHECK-NEXT:    vmov r1, s1
; CHECK-NEXT:    mov.w lr, #-1
; CHECK-NEXT:    vmov r2, s0
; CHECK-NEXT:    mov.w r12, #0
; CHECK-NEXT:    asrl r2, r1, #3
; CHECK-NEXT:    vmov r3, s3
; CHECK-NEXT:    rsbs.w r0, r2, #-2147483648
; CHECK-NEXT:    vmov.32 q2[0], r2
; CHECK-NEXT:    sbcs.w r0, lr, r1
; CHECK-NEXT:    vmov.32 q2[1], r1
; CHECK-NEXT:    mov.w r0, #0
; CHECK-NEXT:    mvn r2, #-2147483648
; CHECK-NEXT:    it lt
; CHECK-NEXT:    movlt r0, #1
; CHECK-NEXT:    cmp r0, #0
; CHECK-NEXT:    csetm r0, ne
; CHECK-NEXT:    vmov.32 q1[0], r0
; CHECK-NEXT:    vmov.32 q1[1], r0
; CHECK-NEXT:    vmov r0, s2
; CHECK-NEXT:    asrl r0, r3, #3
; CHECK-NEXT:    rsbs.w r4, r0, #-2147483648
; CHECK-NEXT:    vmov.32 q2[2], r0
; CHECK-NEXT:    sbcs.w r4, lr, r3
; CHECK-NEXT:    vmov.32 q2[3], r3
; CHECK-NEXT:    mov.w r4, #0
; CHECK-NEXT:    it lt
; CHECK-NEXT:    movlt r4, #1
; CHECK-NEXT:    cmp r4, #0
; CHECK-NEXT:    csetm r4, ne
; CHECK-NEXT:    vmov.32 q1[2], r4
; CHECK-NEXT:    vmov.32 q1[3], r4
; CHECK-NEXT:    adr r4, .LCPI13_0
; CHECK-NEXT:    vldrw.u32 q0, [r4]
; CHECK-NEXT:    vbic q0, q0, q1
; CHECK-NEXT:    vand q1, q2, q1
; CHECK-NEXT:    vorr q0, q1, q0
; CHECK-NEXT:    vmov r1, s0
; CHECK-NEXT:    vmov r0, s1
; CHECK-NEXT:    subs r1, r1, r2
; CHECK-NEXT:    sbcs r0, r0, #0
; CHECK-NEXT:    vmov r1, s2
; CHECK-NEXT:    mov.w r0, #0
; CHECK-NEXT:    it lt
; CHECK-NEXT:    movlt r0, #1
; CHECK-NEXT:    cmp r0, #0
; CHECK-NEXT:    csetm r0, ne
; CHECK-NEXT:    vmov.32 q1[0], r0
; CHECK-NEXT:    vmov.32 q1[1], r0
; CHECK-NEXT:    vmov r0, s3
; CHECK-NEXT:    subs r1, r1, r2
; CHECK-NEXT:    sbcs r0, r0, #0
; CHECK-NEXT:    it lt
; CHECK-NEXT:    movlt.w r12, #1
; CHECK-NEXT:    cmp.w r12, #0
; CHECK-NEXT:    csetm r0, ne
; CHECK-NEXT:    vmov.32 q1[2], r0
; CHECK-NEXT:    vmov.32 q1[3], r0
; CHECK-NEXT:    adr r0, .LCPI13_1
; CHECK-NEXT:    vldrw.u32 q2, [r0]
; CHECK-NEXT:    vand q0, q0, q1
; CHECK-NEXT:    vbic q2, q2, q1
; CHECK-NEXT:    vorr q0, q0, q2
; CHECK-NEXT:    pop {r4, pc}
; CHECK-NEXT:    .p2align 4
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI13_0:
; CHECK-NEXT:    .long 2147483648 @ 0x80000000
; CHECK-NEXT:    .long 4294967295 @ 0xffffffff
; CHECK-NEXT:    .long 2147483648 @ 0x80000000
; CHECK-NEXT:    .long 4294967295 @ 0xffffffff
; CHECK-NEXT:  .LCPI13_1:
; CHECK-NEXT:    .long 2147483647 @ 0x7fffffff
; CHECK-NEXT:    .long 0 @ 0x0
; CHECK-NEXT:    .long 2147483647 @ 0x7fffffff
; CHECK-NEXT:    .long 0 @ 0x0
entry:
  %s0 = ashr <2 x i64> %so, <i64 3, i64 3>
  %c1 = icmp sgt <2 x i64> %s0, <i64 -2147483648, i64 -2147483648>
  %s1 = select <2 x i1> %c1, <2 x i64> %s0, <2 x i64> <i64 -2147483648, i64 -2147483648>
  %c2 = icmp slt <2 x i64> %s1, <i64 2147483647, i64 2147483647>
  %s2 = select <2 x i1> %c2, <2 x i64> %s1, <2 x i64> <i64 2147483647, i64 2147483647>
  ret <2 x i64> %s2
}

define arm_aapcs_vfpcc <2 x i64> @vqshrni64_umaxmin(<2 x i64> %so) {
; CHECK-LABEL: vqshrni64_umaxmin:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r5, r6, r7, lr}
; CHECK-NEXT:    push {r5, r6, r7, lr}
; CHECK-NEXT:    vmov r7, s1
; CHECK-NEXT:    movs r1, #0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    lsrl r0, r7, #3
; CHECK-NEXT:    vmov r3, s3
; CHECK-NEXT:    subs.w r2, r0, #-1
; CHECK-NEXT:    vmov.32 q2[0], r0
; CHECK-NEXT:    sbcs r2, r7, #0
; CHECK-NEXT:    vmov.32 q2[1], r7
; CHECK-NEXT:    mov.w r2, #0
; CHECK-NEXT:    it lo
; CHECK-NEXT:    movlo r2, #1
; CHECK-NEXT:    cmp r2, #0
; CHECK-NEXT:    csetm r2, ne
; CHECK-NEXT:    vmov.32 q1[0], r2
; CHECK-NEXT:    vmov.32 q1[1], r2
; CHECK-NEXT:    vmov r2, s2
; CHECK-NEXT:    lsrl r2, r3, #3
; CHECK-NEXT:    vmov.i64 q0, #0xffffffff
; CHECK-NEXT:    subs.w r5, r2, #-1
; CHECK-NEXT:    vmov.32 q2[2], r2
; CHECK-NEXT:    sbcs r5, r3, #0
; CHECK-NEXT:    it lo
; CHECK-NEXT:    movlo r1, #1
; CHECK-NEXT:    cmp r1, #0
; CHECK-NEXT:    vmov.32 q2[3], r3
; CHECK-NEXT:    csetm r1, ne
; CHECK-NEXT:    vmov.32 q1[2], r1
; CHECK-NEXT:    vmov.32 q1[3], r1
; CHECK-NEXT:    vbic q0, q0, q1
; CHECK-NEXT:    vand q1, q2, q1
; CHECK-NEXT:    vorr q0, q1, q0
; CHECK-NEXT:    pop {r5, r6, r7, pc}
entry:
  %s0 = lshr <2 x i64> %so, <i64 3, i64 3>
  %c1 = icmp ult <2 x i64> %s0, <i64 4294967295, i64 4294967295>
  %s1 = select <2 x i1> %c1, <2 x i64> %s0, <2 x i64> <i64 4294967295, i64 4294967295>
  ret <2 x i64> %s1
}

define arm_aapcs_vfpcc <2 x i64> @vqshrni64_uminmax(<2 x i64> %so) {
; CHECK-LABEL: vqshrni64_uminmax:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r5, r6, r7, lr}
; CHECK-NEXT:    push {r5, r6, r7, lr}
; CHECK-NEXT:    vmov r7, s1
; CHECK-NEXT:    movs r1, #0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    lsrl r0, r7, #3
; CHECK-NEXT:    vmov r3, s3
; CHECK-NEXT:    subs.w r2, r0, #-1
; CHECK-NEXT:    vmov.32 q2[0], r0
; CHECK-NEXT:    sbcs r2, r7, #0
; CHECK-NEXT:    vmov.32 q2[1], r7
; CHECK-NEXT:    mov.w r2, #0
; CHECK-NEXT:    it lo
; CHECK-NEXT:    movlo r2, #1
; CHECK-NEXT:    cmp r2, #0
; CHECK-NEXT:    csetm r2, ne
; CHECK-NEXT:    vmov.32 q1[0], r2
; CHECK-NEXT:    vmov.32 q1[1], r2
; CHECK-NEXT:    vmov r2, s2
; CHECK-NEXT:    lsrl r2, r3, #3
; CHECK-NEXT:    vmov.i64 q0, #0xffffffff
; CHECK-NEXT:    subs.w r5, r2, #-1
; CHECK-NEXT:    vmov.32 q2[2], r2
; CHECK-NEXT:    sbcs r5, r3, #0
; CHECK-NEXT:    it lo
; CHECK-NEXT:    movlo r1, #1
; CHECK-NEXT:    cmp r1, #0
; CHECK-NEXT:    vmov.32 q2[3], r3
; CHECK-NEXT:    csetm r1, ne
; CHECK-NEXT:    vmov.32 q1[2], r1
; CHECK-NEXT:    vmov.32 q1[3], r1
; CHECK-NEXT:    vbic q0, q0, q1
; CHECK-NEXT:    vand q1, q2, q1
; CHECK-NEXT:    vorr q0, q1, q0
; CHECK-NEXT:    pop {r5, r6, r7, pc}
entry:
  %s0 = lshr <2 x i64> %so, <i64 3, i64 3>
  %c2 = icmp ult <2 x i64> %s0, <i64 4294967295, i64 4294967295>
  %s2 = select <2 x i1> %c2, <2 x i64> %s0, <2 x i64> <i64 4294967295, i64 4294967295>
  ret <2 x i64> %s2
}
