; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 -enable-amdgpu-aa=0 -mattr=+flat-for-global -denormal-fp-math=preserve-sign < %s | FileCheck -enable-var-scope -check-prefixes=GCN,GFX89,GFX9 %s
; RUN: llc -verify-machineinstrs -mtriple=amdgcn-amd-amdhsa -mcpu=fiji -enable-amdgpu-aa=0 -mattr=+flat-for-global < %s | FileCheck -enable-var-scope -check-prefixes=GCN,GFX89,CIVI,VI %s
; RUN: llc -verify-machineinstrs -mtriple=amdgcn-amd-amdhsa -mcpu=hawaii -enable-amdgpu-aa=0 -mattr=+flat-for-global < %s | FileCheck -enable-var-scope -check-prefixes=GCN,CIVI,CI %s

define amdgpu_kernel void @s_insertelement_v2i16_0(<2 x i16> addrspace(1)* %out, <2 x i16> addrspace(4)* %vec.ptr) #0 {
; GFX9-LABEL: s_insertelement_v2i16_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_pack_lh_b32_b16 s0, 0x3e7, s0
; GFX9-NEXT:    v_mov_b32_e32 v2, s0
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; CIVI-LABEL: s_insertelement_v2i16_0:
; CIVI:       ; %bb.0:
; CIVI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; CIVI-NEXT:    s_waitcnt lgkmcnt(0)
; CIVI-NEXT:    v_mov_b32_e32 v0, s0
; CIVI-NEXT:    s_load_dword s0, s[2:3], 0x0
; CIVI-NEXT:    v_mov_b32_e32 v1, s1
; CIVI-NEXT:    s_waitcnt lgkmcnt(0)
; CIVI-NEXT:    s_and_b32 s0, s0, 0xffff0000
; CIVI-NEXT:    s_or_b32 s0, s0, 0x3e7
; CIVI-NEXT:    v_mov_b32_e32 v2, s0
; CIVI-NEXT:    flat_store_dword v[0:1], v2
; CIVI-NEXT:    s_endpgm
  %vec = load <2 x i16>, <2 x i16> addrspace(4)* %vec.ptr
  %vecins = insertelement <2 x i16> %vec, i16 999, i32 0
  store <2 x i16> %vecins, <2 x i16> addrspace(1)* %out
  ret void
}


define amdgpu_kernel void @s_insertelement_v2i16_0_reg(<2 x i16> addrspace(1)* %out, <2 x i16> addrspace(4)* %vec.ptr, [8 x i32], i16 %elt) #0 {
; GFX9-LABEL: s_insertelement_v2i16_0_reg:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-NEXT:    s_load_dword s4, s[4:5], 0x30
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_pack_lh_b32_b16 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v2, s0
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: s_insertelement_v2i16_0_reg:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; VI-NEXT:    s_load_dword s4, s[4:5], 0x30
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    s_load_dword s0, s[2:3], 0x0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_and_b32 s1, s4, 0xffff
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_and_b32 s0, s0, 0xffff0000
; VI-NEXT:    s_or_b32 s0, s1, s0
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; CI-LABEL: s_insertelement_v2i16_0_reg:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; CI-NEXT:    s_load_dword s4, s[4:5], 0xc
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_load_dword s2, s[2:3], 0x0
; CI-NEXT:    v_mov_b32_e32 v0, s0
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    s_and_b32 s1, s4, 0xffff
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_and_b32 s0, s2, 0xffff0000
; CI-NEXT:    s_or_b32 s0, s1, s0
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    s_endpgm
  %vec = load <2 x i16>, <2 x i16> addrspace(4)* %vec.ptr
  %vecins = insertelement <2 x i16> %vec, i16 %elt, i32 0
  store <2 x i16> %vecins, <2 x i16> addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @s_insertelement_v2i16_0_multi_use_hi_reg(<2 x i16> addrspace(1)* %out, <2 x i16> addrspace(4)* %vec.ptr, [8 x i32], i16 %elt) #0 {
; GFX9-LABEL: s_insertelement_v2i16_0_multi_use_hi_reg:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-NEXT:    s_load_dword s4, s[4:5], 0x30
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshr_b32 s0, s2, 16
; GFX9-NEXT:    s_pack_ll_b32_b16 s1, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s0
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: s_insertelement_v2i16_0_multi_use_hi_reg:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; VI-NEXT:    s_load_dword s4, s[4:5], 0x30
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    s_load_dword s0, s[2:3], 0x0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_and_b32 s1, s4, 0xffff
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshr_b32 s2, s0, 16
; VI-NEXT:    s_and_b32 s0, s0, 0xffff0000
; VI-NEXT:    s_or_b32 s0, s1, s0
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    ;;#ASMSTART
; VI-NEXT:    ; use s2
; VI-NEXT:    ;;#ASMEND
; VI-NEXT:    s_endpgm
;
; CI-LABEL: s_insertelement_v2i16_0_multi_use_hi_reg:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; CI-NEXT:    s_load_dword s4, s[4:5], 0xc
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_load_dword s2, s[2:3], 0x0
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    v_mov_b32_e32 v0, s0
; CI-NEXT:    s_and_b32 s0, s4, 0xffff
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_lshr_b32 s1, s2, 16
; CI-NEXT:    s_lshl_b32 s2, s1, 16
; CI-NEXT:    s_or_b32 s0, s0, s2
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    ;;#ASMSTART
; CI-NEXT:    ; use s1
; CI-NEXT:    ;;#ASMEND
; CI-NEXT:    s_endpgm
  %vec = load <2 x i16>, <2 x i16> addrspace(4)* %vec.ptr
  %elt1 = extractelement <2 x i16> %vec, i32 1
  %vecins = insertelement <2 x i16> %vec, i16 %elt, i32 0
  store <2 x i16> %vecins, <2 x i16> addrspace(1)* %out
  %use1 = zext i16 %elt1 to i32
  call void asm sideeffect "; use $0", "s"(i32 %use1) #0
  ret void
}

define amdgpu_kernel void @s_insertelement_v2i16_0_reghi(<2 x i16> addrspace(1)* %out, <2 x i16> addrspace(4)* %vec.ptr, [8 x i32], i32 %elt.arg) #0 {
; GFX9-LABEL: s_insertelement_v2i16_0_reghi:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-NEXT:    s_load_dword s4, s[4:5], 0x30
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_pack_hh_b32_b16 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v2, s0
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: s_insertelement_v2i16_0_reghi:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; VI-NEXT:    s_load_dword s4, s[4:5], 0x30
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    s_load_dword s0, s[2:3], 0x0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_lshr_b32 s1, s4, 16
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_and_b32 s0, s0, 0xffff0000
; VI-NEXT:    s_or_b32 s0, s1, s0
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; CI-LABEL: s_insertelement_v2i16_0_reghi:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; CI-NEXT:    s_load_dword s4, s[4:5], 0xc
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_load_dword s2, s[2:3], 0x0
; CI-NEXT:    v_mov_b32_e32 v0, s0
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    s_lshr_b32 s1, s4, 16
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_and_b32 s0, s2, 0xffff0000
; CI-NEXT:    s_or_b32 s0, s1, s0
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    s_endpgm
  %vec = load <2 x i16>, <2 x i16> addrspace(4)* %vec.ptr
  %elt.hi = lshr i32 %elt.arg, 16
  %elt = trunc i32 %elt.hi to i16
  %vecins = insertelement <2 x i16> %vec, i16 %elt, i32 0
  store <2 x i16> %vecins, <2 x i16> addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @s_insertelement_v2i16_0_reghi_multi_use_1(<2 x i16> addrspace(1)* %out, <2 x i16> addrspace(4)* %vec.ptr, i32 %elt.arg) #0 {
; GFX9-LABEL: s_insertelement_v2i16_0_reghi_multi_use_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-NEXT:    s_load_dword s4, s[4:5], 0x10
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    s_lshr_b32 s0, s4, 16
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_pack_lh_b32_b16 s1, s0, s2
; GFX9-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s0
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: s_insertelement_v2i16_0_reghi_multi_use_1:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; VI-NEXT:    s_load_dword s4, s[4:5], 0x10
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s2, s[2:3], 0x0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_lshr_b32 s0, s4, 16
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_and_b32 s1, s2, 0xffff0000
; VI-NEXT:    s_or_b32 s1, s0, s1
; VI-NEXT:    v_mov_b32_e32 v2, s1
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    ;;#ASMSTART
; VI-NEXT:    ; use s0
; VI-NEXT:    ;;#ASMEND
; VI-NEXT:    s_endpgm
;
; CI-LABEL: s_insertelement_v2i16_0_reghi_multi_use_1:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; CI-NEXT:    s_load_dword s4, s[4:5], 0x4
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_load_dword s2, s[2:3], 0x0
; CI-NEXT:    v_mov_b32_e32 v0, s0
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    s_lshr_b32 s0, s4, 16
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_and_b32 s1, s2, 0xffff0000
; CI-NEXT:    s_or_b32 s1, s0, s1
; CI-NEXT:    v_mov_b32_e32 v2, s1
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    ;;#ASMSTART
; CI-NEXT:    ; use s0
; CI-NEXT:    ;;#ASMEND
; CI-NEXT:    s_endpgm
  %vec = load <2 x i16>, <2 x i16> addrspace(4)* %vec.ptr
  %elt.hi = lshr i32 %elt.arg, 16
  %elt = trunc i32 %elt.hi to i16
  %vecins = insertelement <2 x i16> %vec, i16 %elt, i32 0
  store <2 x i16> %vecins, <2 x i16> addrspace(1)* %out
  %use1 = zext i16 %elt to i32
  call void asm sideeffect "; use $0", "s"(i32 %use1) #0
  ret void
}

define amdgpu_kernel void @s_insertelement_v2i16_0_reghi_both_multi_use_1(<2 x i16> addrspace(1)* %out, <2 x i16> addrspace(4)* %vec.ptr, i32 %elt.arg) #0 {
; GFX9-LABEL: s_insertelement_v2i16_0_reghi_both_multi_use_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-NEXT:    s_load_dword s4, s[4:5], 0x10
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    s_lshr_b32 s1, s4, 16
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshr_b32 s0, s0, 16
; GFX9-NEXT:    s_pack_ll_b32_b16 s2, s1, s0
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s1
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s0
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: s_insertelement_v2i16_0_reghi_both_multi_use_1:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; VI-NEXT:    s_load_dword s4, s[4:5], 0x10
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    s_load_dword s0, s[2:3], 0x0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_lshr_b32 s1, s4, 16
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshr_b32 s2, s0, 16
; VI-NEXT:    s_and_b32 s0, s0, 0xffff0000
; VI-NEXT:    s_or_b32 s0, s1, s0
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    ;;#ASMSTART
; VI-NEXT:    ; use s1
; VI-NEXT:    ;;#ASMEND
; VI-NEXT:    ;;#ASMSTART
; VI-NEXT:    ; use s2
; VI-NEXT:    ;;#ASMEND
; VI-NEXT:    s_endpgm
;
; CI-LABEL: s_insertelement_v2i16_0_reghi_both_multi_use_1:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; CI-NEXT:    s_load_dword s4, s[4:5], 0x4
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s0
; CI-NEXT:    s_load_dword s0, s[2:3], 0x0
; CI-NEXT:    v_mov_b32_e32 v2, s4
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    s_lshr_b32 s1, s4, 16
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_lshr_b32 s0, s0, 16
; CI-NEXT:    v_alignbit_b32 v2, s0, v2, 16
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    ;;#ASMSTART
; CI-NEXT:    ; use s1
; CI-NEXT:    ;;#ASMEND
; CI-NEXT:    ;;#ASMSTART
; CI-NEXT:    ; use s0
; CI-NEXT:    ;;#ASMEND
; CI-NEXT:    s_endpgm
  %vec = load <2 x i16>, <2 x i16> addrspace(4)* %vec.ptr
  %elt.hi = lshr i32 %elt.arg, 16
  %elt = trunc i32 %elt.hi to i16
  %vec.hi = extractelement <2 x i16> %vec, i32 1
  %vecins = insertelement <2 x i16> %vec, i16 %elt, i32 0
  store <2 x i16> %vecins, <2 x i16> addrspace(1)* %out
  %use1 = zext i16 %elt to i32
  %vec.hi.use1 = zext i16 %vec.hi to i32

  call void asm sideeffect "; use $0", "s"(i32 %use1) #0
  call void asm sideeffect "; use $0", "s"(i32 %vec.hi.use1) #0
  ret void
}

define amdgpu_kernel void @s_insertelement_v2i16_1(<2 x i16> addrspace(1)* %out, <2 x i16> addrspace(4)* %vec.ptr) #0 {
; GFX9-LABEL: s_insertelement_v2i16_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_pack_ll_b32_b16 s0, s0, 0x3e7
; GFX9-NEXT:    v_mov_b32_e32 v2, s0
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; CIVI-LABEL: s_insertelement_v2i16_1:
; CIVI:       ; %bb.0:
; CIVI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; CIVI-NEXT:    s_waitcnt lgkmcnt(0)
; CIVI-NEXT:    v_mov_b32_e32 v0, s0
; CIVI-NEXT:    s_load_dword s0, s[2:3], 0x0
; CIVI-NEXT:    v_mov_b32_e32 v1, s1
; CIVI-NEXT:    s_waitcnt lgkmcnt(0)
; CIVI-NEXT:    s_and_b32 s0, s0, 0xffff
; CIVI-NEXT:    s_or_b32 s0, s0, 0x3e70000
; CIVI-NEXT:    v_mov_b32_e32 v2, s0
; CIVI-NEXT:    flat_store_dword v[0:1], v2
; CIVI-NEXT:    s_endpgm
  %vec = load <2 x i16>, <2 x i16> addrspace(4)* %vec.ptr
  %vecins = insertelement <2 x i16> %vec, i16 999, i32 1
  store <2 x i16> %vecins, <2 x i16> addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @s_insertelement_v2i16_1_reg(<2 x i16> addrspace(1)* %out, <2 x i16> addrspace(4)* %vec.ptr, [8 x i32], i16 %elt) #0 {
; GFX9-LABEL: s_insertelement_v2i16_1_reg:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-NEXT:    s_load_dword s4, s[4:5], 0x30
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_pack_ll_b32_b16 s0, s0, s4
; GFX9-NEXT:    v_mov_b32_e32 v2, s0
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: s_insertelement_v2i16_1_reg:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; VI-NEXT:    s_load_dword s4, s[4:5], 0x30
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    s_load_dword s0, s[2:3], 0x0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_lshl_b32 s1, s4, 16
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_and_b32 s0, s0, 0xffff
; VI-NEXT:    s_or_b32 s0, s0, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; CI-LABEL: s_insertelement_v2i16_1_reg:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; CI-NEXT:    s_load_dword s4, s[4:5], 0xc
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_load_dword s2, s[2:3], 0x0
; CI-NEXT:    v_mov_b32_e32 v0, s0
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    s_lshl_b32 s1, s4, 16
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_and_b32 s0, s2, 0xffff
; CI-NEXT:    s_or_b32 s0, s0, s1
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    s_endpgm
  %vec = load <2 x i16>, <2 x i16> addrspace(4)* %vec.ptr
  %vecins = insertelement <2 x i16> %vec, i16 %elt, i32 1
  store <2 x i16> %vecins, <2 x i16> addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @s_insertelement_v2f16_0(<2 x half> addrspace(1)* %out, <2 x half> addrspace(4)* %vec.ptr) #0 {
; GFX9-LABEL: s_insertelement_v2f16_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshr_b32 s0, s0, 16
; GFX9-NEXT:    s_pack_ll_b32_b16 s0, 0x4500, s0
; GFX9-NEXT:    v_mov_b32_e32 v2, s0
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; CIVI-LABEL: s_insertelement_v2f16_0:
; CIVI:       ; %bb.0:
; CIVI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; CIVI-NEXT:    s_waitcnt lgkmcnt(0)
; CIVI-NEXT:    v_mov_b32_e32 v0, s0
; CIVI-NEXT:    s_load_dword s0, s[2:3], 0x0
; CIVI-NEXT:    v_mov_b32_e32 v1, s1
; CIVI-NEXT:    s_waitcnt lgkmcnt(0)
; CIVI-NEXT:    s_and_b32 s0, s0, 0xffff0000
; CIVI-NEXT:    s_or_b32 s0, s0, 0x4500
; CIVI-NEXT:    v_mov_b32_e32 v2, s0
; CIVI-NEXT:    flat_store_dword v[0:1], v2
; CIVI-NEXT:    s_endpgm
  %vec = load <2 x half>, <2 x half> addrspace(4)* %vec.ptr
  %vecins = insertelement <2 x half> %vec, half 5.000000e+00, i32 0
  store <2 x half> %vecins, <2 x half> addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @s_insertelement_v2f16_1(<2 x half> addrspace(1)* %out, <2 x half> addrspace(4)* %vec.ptr) #0 {
; GFX9-LABEL: s_insertelement_v2f16_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_pack_ll_b32_b16 s0, s0, 0x4500
; GFX9-NEXT:    v_mov_b32_e32 v2, s0
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; CIVI-LABEL: s_insertelement_v2f16_1:
; CIVI:       ; %bb.0:
; CIVI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; CIVI-NEXT:    s_waitcnt lgkmcnt(0)
; CIVI-NEXT:    v_mov_b32_e32 v0, s0
; CIVI-NEXT:    s_load_dword s0, s[2:3], 0x0
; CIVI-NEXT:    v_mov_b32_e32 v1, s1
; CIVI-NEXT:    s_waitcnt lgkmcnt(0)
; CIVI-NEXT:    s_and_b32 s0, s0, 0xffff
; CIVI-NEXT:    s_or_b32 s0, s0, 0x45000000
; CIVI-NEXT:    v_mov_b32_e32 v2, s0
; CIVI-NEXT:    flat_store_dword v[0:1], v2
; CIVI-NEXT:    s_endpgm
  %vec = load <2 x half>, <2 x half> addrspace(4)* %vec.ptr
  %vecins = insertelement <2 x half> %vec, half 5.000000e+00, i32 1
  store <2 x half> %vecins, <2 x half> addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @v_insertelement_v2i16_0(<2 x i16> addrspace(1)* %out, <2 x i16> addrspace(1)* %in) #0 {
; GFX9-LABEL: v_insertelement_v2i16_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0xffff
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_movk_i32 s2, 0x3e7
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_bfi_b32 v1, v2, s2, v1
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v2i16_0:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; VI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_add_u32_e32 v2, vcc, s0, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; VI-NEXT:    v_or_b32_e32 v0, 0x3e7, v0
; VI-NEXT:    flat_store_dword v[2:3], v0
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v2i16_0:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; CI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dword v0, v[0:1]
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_add_i32_e32 v2, vcc, s0, v2
; CI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; CI-NEXT:    v_or_b32_e32 v0, 0x3e7, v0
; CI-NEXT:    flat_store_dword v[2:3], v0
; CI-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <2 x i16>, <2 x i16> addrspace(1)* %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <2 x i16>, <2 x i16> addrspace(1)* %out, i64 %tid.ext
  %vec = load <2 x i16>, <2 x i16> addrspace(1)* %in.gep
  %vecins = insertelement <2 x i16> %vec, i16 999, i32 0
  store <2 x i16> %vecins, <2 x i16> addrspace(1)* %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v2i16_0_reghi(<2 x i16> addrspace(1)* %out, <2 x i16> addrspace(1)* %in, i32 %elt.arg) #0 {
; GFX9-LABEL: v_insertelement_v2i16_0_reghi:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-NEXT:    s_load_dword s4, s[4:5], 0x10
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v3, 0xffff0000
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    v_lshrrev_b32_e64 v2, 16, s4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_and_or_b32 v1, v1, v3, v2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v2i16_0_reghi:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; VI-NEXT:    s_load_dword s4, s[4:5], 0x10
; VI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    v_add_u32_e32 v2, vcc, s0, v2
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    s_lshr_b32 s0, s4, 16
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; VI-NEXT:    v_or_b32_e32 v0, s0, v0
; VI-NEXT:    flat_store_dword v[2:3], v0
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v2i16_0_reghi:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; CI-NEXT:    s_load_dword s4, s[4:5], 0x4
; CI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dword v3, v[0:1]
; CI-NEXT:    v_add_i32_e32 v0, vcc, s0, v2
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    s_lshr_b32 s0, s4, 16
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v3
; CI-NEXT:    v_or_b32_e32 v2, s0, v2
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <2 x i16>, <2 x i16> addrspace(1)* %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <2 x i16>, <2 x i16> addrspace(1)* %out, i64 %tid.ext
  %vec = load <2 x i16>, <2 x i16> addrspace(1)* %in.gep
  %elt.hi = lshr i32 %elt.arg, 16
  %elt = trunc i32 %elt.hi to i16
  %vecins = insertelement <2 x i16> %vec, i16 %elt, i32 0
  store <2 x i16> %vecins, <2 x i16> addrspace(1)* %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v2i16_0_inlineimm(<2 x i16> addrspace(1)* %out, <2 x i16> addrspace(1)* %in) #0 {
; GFX9-LABEL: v_insertelement_v2i16_0_inlineimm:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0xffff
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_bfi_b32 v1, v2, 53, v1
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v2i16_0_inlineimm:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; VI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_add_u32_e32 v2, vcc, s0, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; VI-NEXT:    v_or_b32_e32 v0, 53, v0
; VI-NEXT:    flat_store_dword v[2:3], v0
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v2i16_0_inlineimm:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; CI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dword v0, v[0:1]
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_add_i32_e32 v2, vcc, s0, v2
; CI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; CI-NEXT:    v_or_b32_e32 v0, 53, v0
; CI-NEXT:    flat_store_dword v[2:3], v0
; CI-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <2 x i16>, <2 x i16> addrspace(1)* %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <2 x i16>, <2 x i16> addrspace(1)* %out, i64 %tid.ext
  %vec = load <2 x i16>, <2 x i16> addrspace(1)* %in.gep
  %vecins = insertelement <2 x i16> %vec, i16 53, i32 0
  store <2 x i16> %vecins, <2 x i16> addrspace(1)* %out.gep
  ret void
}

; FIXME: fold lshl_or c0, c1, v0 -> or (c0 << c1), v0
define amdgpu_kernel void @v_insertelement_v2i16_1(<2 x i16> addrspace(1)* %out, <2 x i16> addrspace(1)* %in) #0 {
; GFX9-LABEL: v_insertelement_v2i16_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_movk_i32 s2, 0x3e7
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX9-NEXT:    v_lshl_or_b32 v1, s2, 16, v1
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v2i16_1:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; VI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v1, 0x3e70000
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_add_u32_e32 v2, vcc, s0, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    flat_store_dword v[2:3], v0
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v2i16_1:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; CI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dword v0, v[0:1]
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_add_i32_e32 v2, vcc, s0, v2
; CI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; CI-NEXT:    v_or_b32_e32 v0, 0x3e70000, v0
; CI-NEXT:    flat_store_dword v[2:3], v0
; CI-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <2 x i16>, <2 x i16> addrspace(1)* %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <2 x i16>, <2 x i16> addrspace(1)* %out, i64 %tid.ext
  %vec = load <2 x i16>, <2 x i16> addrspace(1)* %in.gep
  %vecins = insertelement <2 x i16> %vec, i16 999, i32 1
  store <2 x i16> %vecins, <2 x i16> addrspace(1)* %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v2i16_1_inlineimm(<2 x i16> addrspace(1)* %out, <2 x i16> addrspace(1)* %in) #0 {
; GFX9-LABEL: v_insertelement_v2i16_1_inlineimm:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX9-NEXT:    v_lshl_or_b32 v1, -15, 16, v1
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v2i16_1_inlineimm:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; VI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v1, 0xfff10000
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_add_u32_e32 v2, vcc, s0, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    flat_store_dword v[2:3], v0
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v2i16_1_inlineimm:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; CI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dword v0, v[0:1]
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_add_i32_e32 v2, vcc, s0, v2
; CI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; CI-NEXT:    v_or_b32_e32 v0, 0xfff10000, v0
; CI-NEXT:    flat_store_dword v[2:3], v0
; CI-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <2 x i16>, <2 x i16> addrspace(1)* %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <2 x i16>, <2 x i16> addrspace(1)* %out, i64 %tid.ext
  %vec = load <2 x i16>, <2 x i16> addrspace(1)* %in.gep
  %vecins = insertelement <2 x i16> %vec, i16 -15, i32 1
  store <2 x i16> %vecins, <2 x i16> addrspace(1)* %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v2f16_0(<2 x half> addrspace(1)* %out, <2 x half> addrspace(1)* %in) #0 {
; GFX9-LABEL: v_insertelement_v2f16_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x4500
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_lshl_or_b32 v1, v1, 16, v2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v2f16_0:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; VI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_add_u32_e32 v2, vcc, s0, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; VI-NEXT:    v_or_b32_e32 v0, 0x4500, v0
; VI-NEXT:    flat_store_dword v[2:3], v0
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v2f16_0:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; CI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dword v0, v[0:1]
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_add_i32_e32 v2, vcc, s0, v2
; CI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; CI-NEXT:    v_or_b32_e32 v0, 0x4500, v0
; CI-NEXT:    flat_store_dword v[2:3], v0
; CI-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <2 x half>, <2 x half> addrspace(1)* %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <2 x half>, <2 x half> addrspace(1)* %out, i64 %tid.ext
  %vec = load <2 x half>, <2 x half> addrspace(1)* %in.gep
  %vecins = insertelement <2 x half> %vec, half 5.000000e+00, i32 0
  store <2 x half> %vecins, <2 x half> addrspace(1)* %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v2f16_0_inlineimm(<2 x half> addrspace(1)* %out, <2 x half> addrspace(1)* %in) #0 {
; GFX9-LABEL: v_insertelement_v2f16_0_inlineimm:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_lshl_or_b32 v1, v1, 16, 53
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v2f16_0_inlineimm:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; VI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_add_u32_e32 v2, vcc, s0, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; VI-NEXT:    v_or_b32_e32 v0, 53, v0
; VI-NEXT:    flat_store_dword v[2:3], v0
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v2f16_0_inlineimm:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; CI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dword v0, v[0:1]
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_add_i32_e32 v2, vcc, s0, v2
; CI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; CI-NEXT:    v_or_b32_e32 v0, 53, v0
; CI-NEXT:    flat_store_dword v[2:3], v0
; CI-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <2 x half>, <2 x half> addrspace(1)* %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <2 x half>, <2 x half> addrspace(1)* %out, i64 %tid.ext
  %vec = load <2 x half>, <2 x half> addrspace(1)* %in.gep
  %vecins = insertelement <2 x half> %vec, half 0xH0035, i32 0
  store <2 x half> %vecins, <2 x half> addrspace(1)* %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v2f16_1(<2 x half> addrspace(1)* %out, <2 x half> addrspace(1)* %in) #0 {
; GFX9-LABEL: v_insertelement_v2f16_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_movk_i32 s2, 0x4500
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX9-NEXT:    v_lshl_or_b32 v1, s2, 16, v1
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v2f16_1:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; VI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v1, 0x45000000
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_add_u32_e32 v2, vcc, s0, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    flat_store_dword v[2:3], v0
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v2f16_1:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; CI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dword v0, v[0:1]
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_add_i32_e32 v2, vcc, s0, v2
; CI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; CI-NEXT:    v_or_b32_e32 v0, 0x45000000, v0
; CI-NEXT:    flat_store_dword v[2:3], v0
; CI-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <2 x half>, <2 x half> addrspace(1)* %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <2 x half>, <2 x half> addrspace(1)* %out, i64 %tid.ext
  %vec = load <2 x half>, <2 x half> addrspace(1)* %in.gep
  %vecins = insertelement <2 x half> %vec, half 5.000000e+00, i32 1
  store <2 x half> %vecins, <2 x half> addrspace(1)* %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v2f16_1_inlineimm(<2 x half> addrspace(1)* %out, <2 x half> addrspace(1)* %in) #0 {
; GFX9-LABEL: v_insertelement_v2f16_1_inlineimm:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX9-NEXT:    v_lshl_or_b32 v1, 35, 16, v1
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v2f16_1_inlineimm:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; VI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v1, 0x230000
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_add_u32_e32 v2, vcc, s0, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    flat_store_dword v[2:3], v0
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v2f16_1_inlineimm:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; CI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dword v0, v[0:1]
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_add_i32_e32 v2, vcc, s0, v2
; CI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; CI-NEXT:    v_or_b32_e32 v0, 0x230000, v0
; CI-NEXT:    flat_store_dword v[2:3], v0
; CI-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <2 x half>, <2 x half> addrspace(1)* %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <2 x half>, <2 x half> addrspace(1)* %out, i64 %tid.ext
  %vec = load <2 x half>, <2 x half> addrspace(1)* %in.gep
  %vecins = insertelement <2 x half> %vec, half 0xH0023, i32 1
  store <2 x half> %vecins, <2 x half> addrspace(1)* %out.gep
  ret void
}

; FIXME: Enable for others when argument load not split
define amdgpu_kernel void @s_insertelement_v2i16_dynamic(<2 x i16> addrspace(1)* %out, <2 x i16> addrspace(4)* %vec.ptr, i32 addrspace(4)* %idx.ptr) #0 {
; GFX9-LABEL: s_insertelement_v2i16_dynamic:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[4:5], 0x10
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX9-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b32 s0, s0, 4
; GFX9-NEXT:    s_lshl_b32 s0, 0xffff, s0
; GFX9-NEXT:    s_andn2_b32 s1, s2, s0
; GFX9-NEXT:    s_and_b32 s0, s0, 0x3e703e7
; GFX9-NEXT:    s_or_b32 s0, s0, s1
; GFX9-NEXT:    v_mov_b32_e32 v2, s0
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: s_insertelement_v2i16_dynamic:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; VI-NEXT:    s_load_dwordx4 s[4:7], s[4:5], 0x10
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    s_load_dword s0, s[4:5], 0x0
; VI-NEXT:    s_load_dword s2, s[2:3], 0x0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b32 s0, s0, 4
; VI-NEXT:    s_lshl_b32 s0, 0xffff, s0
; VI-NEXT:    s_andn2_b32 s1, s2, s0
; VI-NEXT:    s_and_b32 s0, s0, 0x3e703e7
; VI-NEXT:    s_or_b32 s0, s0, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; CI-LABEL: s_insertelement_v2i16_dynamic:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; CI-NEXT:    s_load_dwordx4 s[4:7], s[4:5], 0x4
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s0
; CI-NEXT:    s_load_dword s0, s[4:5], 0x0
; CI-NEXT:    s_load_dword s2, s[2:3], 0x0
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_lshl_b32 s0, s0, 4
; CI-NEXT:    s_lshl_b32 s0, 0xffff, s0
; CI-NEXT:    s_andn2_b32 s1, s2, s0
; CI-NEXT:    s_and_b32 s0, s0, 0x3e703e7
; CI-NEXT:    s_or_b32 s0, s0, s1
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    s_endpgm
  %idx = load volatile i32, i32 addrspace(4)* %idx.ptr
  %vec = load <2 x i16>, <2 x i16> addrspace(4)* %vec.ptr
  %vecins = insertelement <2 x i16> %vec, i16 999, i32 %idx
  store <2 x i16> %vecins, <2 x i16> addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @v_insertelement_v2i16_dynamic_sgpr(<2 x i16> addrspace(1)* %out, <2 x i16> addrspace(1)* %in, i32 %idx) #0 {
; GFX9-LABEL: v_insertelement_v2i16_dynamic_sgpr:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-NEXT:    s_load_dword s4, s[4:5], 0x10
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x3e703e7
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_lshl_b32 s2, s4, 4
; GFX9-NEXT:    s_lshl_b32 s2, 0xffff, s2
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_bfi_b32 v1, s2, v2, v1
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v2i16_dynamic_sgpr:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; VI-NEXT:    s_load_dword s4, s[4:5], 0x10
; VI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    v_add_u32_e32 v2, vcc, s0, v2
; VI-NEXT:    s_lshl_b32 s0, s4, 4
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    s_lshl_b32 s0, 0xffff, s0
; VI-NEXT:    v_mov_b32_e32 v1, 0x3e703e7
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_bfi_b32 v0, s0, v1, v0
; VI-NEXT:    flat_store_dword v[2:3], v0
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v2i16_dynamic_sgpr:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; CI-NEXT:    s_load_dword s4, s[4:5], 0x4
; CI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dword v0, v[0:1]
; CI-NEXT:    v_add_i32_e32 v2, vcc, s0, v2
; CI-NEXT:    s_lshl_b32 s0, s4, 4
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    s_lshl_b32 s0, 0xffff, s0
; CI-NEXT:    v_mov_b32_e32 v1, 0x3e703e7
; CI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_bfi_b32 v0, s0, v1, v0
; CI-NEXT:    flat_store_dword v[2:3], v0
; CI-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <2 x i16>, <2 x i16> addrspace(1)* %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <2 x i16>, <2 x i16> addrspace(1)* %out, i64 %tid.ext
  %vec = load <2 x i16>, <2 x i16> addrspace(1)* %in.gep
  %vecins = insertelement <2 x i16> %vec, i16 999, i32 %idx
  store <2 x i16> %vecins, <2 x i16> addrspace(1)* %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v2f16_dynamic_vgpr(<2 x half> addrspace(1)* %out, <2 x half> addrspace(1)* %in, i32 addrspace(1)* %idx.ptr) #0 {
; GFX9-LABEL: v_insertelement_v2f16_dynamic_vgpr:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[4:5], 0x10
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-NEXT:    s_mov_b32 s2, 0xffff
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX9-NEXT:    v_lshlrev_b32_e64 v1, v1, s2
; GFX9-NEXT:    s_mov_b32 s2, 0x12341234
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_bfi_b32 v1, v1, s2, v2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v2f16_dynamic_vgpr:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; VI-NEXT:    s_load_dwordx4 s[4:7], s[4:5], 0x10
; VI-NEXT:    v_lshlrev_b32_e32 v4, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v4
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    v_mov_b32_e32 v3, s5
; VI-NEXT:    v_add_u32_e32 v2, vcc, s4, v4
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    flat_load_dword v2, v[2:3]
; VI-NEXT:    flat_load_dword v3, v[0:1]
; VI-NEXT:    s_mov_b32 s2, 0xffff
; VI-NEXT:    v_add_u32_e32 v0, vcc, s0, v4
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_mov_b32 s0, 0x12341234
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_lshlrev_b32_e32 v2, 4, v2
; VI-NEXT:    v_lshlrev_b32_e64 v2, v2, s2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_bfi_b32 v2, v2, s0, v3
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v2f16_dynamic_vgpr:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; CI-NEXT:    s_load_dwordx4 s[4:7], s[4:5], 0x4
; CI-NEXT:    v_lshlrev_b32_e32 v4, 2, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v4
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    v_mov_b32_e32 v3, s5
; CI-NEXT:    v_add_i32_e32 v2, vcc, s4, v4
; CI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; CI-NEXT:    flat_load_dword v2, v[2:3]
; CI-NEXT:    flat_load_dword v3, v[0:1]
; CI-NEXT:    v_add_i32_e32 v0, vcc, s0, v4
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    s_mov_b32 s0, 0x12341234
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    s_waitcnt vmcnt(1)
; CI-NEXT:    v_lshlrev_b32_e32 v2, 4, v2
; CI-NEXT:    v_lshl_b32_e32 v2, 0xffff, v2
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_bfi_b32 v2, v2, s0, v3
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <2 x half>, <2 x half> addrspace(1)* %in, i64 %tid.ext
  %idx.gep = getelementptr inbounds i32, i32 addrspace(1)* %idx.ptr, i64 %tid.ext
  %out.gep = getelementptr inbounds <2 x half>, <2 x half> addrspace(1)* %out, i64 %tid.ext
  %idx = load i32, i32 addrspace(1)* %idx.gep
  %vec = load <2 x half>, <2 x half> addrspace(1)* %in.gep
  %vecins = insertelement <2 x half> %vec, half 0xH1234, i32 %idx
  store <2 x half> %vecins, <2 x half> addrspace(1)* %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v4f16_0(<4 x half> addrspace(1)* %out, <4 x half> addrspace(1)* %in, [8 x i32], i32 %val) #0 {
; GFX9-LABEL: v_insertelement_v4f16_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-NEXT:    s_load_dword s4, s[4:5], 0x30
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX9-NEXT:    v_mov_b32_e32 v3, 0xffff
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v2, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_bfi_b32 v0, v3, s4, v0
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v4f16_0:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; VI-NEXT:    s_load_dword s4, s[4:5], 0x30
; VI-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    v_add_u32_e32 v2, vcc, s0, v2
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    s_mov_b32 s0, 0xffff
; VI-NEXT:    v_mov_b32_e32 v4, s4
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_bfi_b32 v0, s0, v4, v0
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v4f16_0:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; CI-NEXT:    s_load_dword s4, s[4:5], 0xc
; CI-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; CI-NEXT:    v_add_i32_e32 v2, vcc, s0, v2
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    s_mov_b32 s0, 0xffff
; CI-NEXT:    v_mov_b32_e32 v4, s4
; CI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_bfi_b32 v0, s0, v4, v0
; CI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; CI-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <4 x half>, <4 x half> addrspace(1)* %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <4 x half>, <4 x half> addrspace(1)* %out, i64 %tid.ext
  %vec = load <4 x half>, <4 x half> addrspace(1)* %in.gep
  %val.trunc = trunc i32 %val to i16
  %val.cvt = bitcast i16 %val.trunc to half
  %vecins = insertelement <4 x half> %vec, half %val.cvt, i32 0
  store <4 x half> %vecins, <4 x half> addrspace(1)* %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v4f16_1(<4 x half> addrspace(1)* %out, <4 x half> addrspace(1)* %in, i32 %val) #0 {
; GFX9-LABEL: v_insertelement_v4f16_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-NEXT:    s_load_dword s4, s[4:5], 0x10
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v2, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX9-NEXT:    v_lshl_or_b32 v0, s4, 16, v0
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v4f16_1:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; VI-NEXT:    s_load_dword s4, s[4:5], 0x10
; VI-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    v_add_u32_e32 v2, vcc, s0, v2
; VI-NEXT:    s_lshl_b32 s0, s4, 16
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v4, s0
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v0, v4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v4f16_1:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; CI-NEXT:    s_load_dword s4, s[4:5], 0x4
; CI-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; CI-NEXT:    v_add_i32_e32 v2, vcc, s0, v2
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    s_lshl_b32 s0, s4, 16
; CI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; CI-NEXT:    v_or_b32_e32 v0, s0, v0
; CI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; CI-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <4 x half>, <4 x half> addrspace(1)* %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <4 x half>, <4 x half> addrspace(1)* %out, i64 %tid.ext
  %vec = load <4 x half>, <4 x half> addrspace(1)* %in.gep
  %val.trunc = trunc i32 %val to i16
  %val.cvt = bitcast i16 %val.trunc to half
  %vecins = insertelement <4 x half> %vec, half %val.cvt, i32 1
  store <4 x half> %vecins, <4 x half> addrspace(1)* %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v4f16_2(<4 x half> addrspace(1)* %out, <4 x half> addrspace(1)* %in, [8 x i32], i32 %val) #0 {
; GFX9-LABEL: v_insertelement_v4f16_2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-NEXT:    s_load_dword s4, s[4:5], 0x30
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX9-NEXT:    v_mov_b32_e32 v3, 0xffff
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v2, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_bfi_b32 v1, v3, s4, v1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v4f16_2:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; VI-NEXT:    s_load_dword s4, s[4:5], 0x30
; VI-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    v_add_u32_e32 v2, vcc, s0, v2
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    s_mov_b32 s0, 0xffff
; VI-NEXT:    v_mov_b32_e32 v4, s4
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_bfi_b32 v1, s0, v4, v1
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v4f16_2:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; CI-NEXT:    s_load_dword s4, s[4:5], 0xc
; CI-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; CI-NEXT:    v_add_i32_e32 v2, vcc, s0, v2
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    s_mov_b32 s0, 0xffff
; CI-NEXT:    v_mov_b32_e32 v4, s4
; CI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_bfi_b32 v1, s0, v4, v1
; CI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; CI-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <4 x half>, <4 x half> addrspace(1)* %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <4 x half>, <4 x half> addrspace(1)* %out, i64 %tid.ext
  %vec = load <4 x half>, <4 x half> addrspace(1)* %in.gep
  %val.trunc = trunc i32 %val to i16
  %val.cvt = bitcast i16 %val.trunc to half
  %vecins = insertelement <4 x half> %vec, half %val.cvt, i32 2
  store <4 x half> %vecins, <4 x half> addrspace(1)* %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v4f16_3(<4 x half> addrspace(1)* %out, <4 x half> addrspace(1)* %in, i32 %val) #0 {
; GFX9-LABEL: v_insertelement_v4f16_3:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-NEXT:    s_load_dword s4, s[4:5], 0x10
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v2, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX9-NEXT:    v_lshl_or_b32 v1, s4, 16, v1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v4f16_3:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; VI-NEXT:    s_load_dword s4, s[4:5], 0x10
; VI-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    v_add_u32_e32 v2, vcc, s0, v2
; VI-NEXT:    s_lshl_b32 s0, s4, 16
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v4, s0
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v1, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v4f16_3:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; CI-NEXT:    s_load_dword s4, s[4:5], 0x4
; CI-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; CI-NEXT:    v_add_i32_e32 v2, vcc, s0, v2
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    s_lshl_b32 s0, s4, 16
; CI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; CI-NEXT:    v_or_b32_e32 v1, s0, v1
; CI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; CI-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <4 x half>, <4 x half> addrspace(1)* %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <4 x half>, <4 x half> addrspace(1)* %out, i64 %tid.ext
  %vec = load <4 x half>, <4 x half> addrspace(1)* %in.gep
  %val.trunc = trunc i32 %val to i16
  %val.cvt = bitcast i16 %val.trunc to half
  %vecins = insertelement <4 x half> %vec, half %val.cvt, i32 3
  store <4 x half> %vecins, <4 x half> addrspace(1)* %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v4i16_2(<4 x i16> addrspace(1)* %out, <4 x i16> addrspace(1)* %in, i32 %val) #0 {
; GFX9-LABEL: v_insertelement_v4i16_2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-NEXT:    s_load_dword s4, s[4:5], 0x10
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX9-NEXT:    v_mov_b32_e32 v3, 0xffff
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v2, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_bfi_b32 v1, v3, s4, v1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v4i16_2:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; VI-NEXT:    s_load_dword s4, s[4:5], 0x10
; VI-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    v_add_u32_e32 v2, vcc, s0, v2
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    s_mov_b32 s0, 0xffff
; VI-NEXT:    v_mov_b32_e32 v4, s4
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_bfi_b32 v1, s0, v4, v1
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v4i16_2:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; CI-NEXT:    s_load_dword s4, s[4:5], 0x4
; CI-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; CI-NEXT:    v_add_i32_e32 v2, vcc, s0, v2
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    s_mov_b32 s0, 0xffff
; CI-NEXT:    v_mov_b32_e32 v4, s4
; CI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_bfi_b32 v1, s0, v4, v1
; CI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; CI-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <4 x i16>, <4 x i16> addrspace(1)* %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <4 x i16>, <4 x i16> addrspace(1)* %out, i64 %tid.ext
  %vec = load <4 x i16>, <4 x i16> addrspace(1)* %in.gep
  %val.trunc = trunc i32 %val to i16
  %val.cvt = bitcast i16 %val.trunc to i16
  %vecins = insertelement <4 x i16> %vec, i16 %val.cvt, i32 2
  store <4 x i16> %vecins, <4 x i16> addrspace(1)* %out.gep
  ret void
}

; FIXME: Better code on CI?
define amdgpu_kernel void @v_insertelement_v4i16_dynamic_vgpr(<4 x i16> addrspace(1)* %out, <4 x i16> addrspace(1)* %in, i32 %val) #0 {
; GFX9-LABEL: v_insertelement_v4i16_dynamic_vgpr:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dword v2, v[0:1], off
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-NEXT:    s_load_dword s4, s[4:5], 0x10
; GFX9-NEXT:    v_lshlrev_b32_e32 v4, 3, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v4, s[2:3]
; GFX9-NEXT:    s_mov_b32 s3, 0
; GFX9-NEXT:    s_mov_b32 s2, 0xffff
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 4, v2
; GFX9-NEXT:    v_lshlrev_b64 v[2:3], v2, s[2:3]
; GFX9-NEXT:    s_pack_ll_b32_b16 s2, s4, s4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_bfi_b32 v1, v3, s2, v1
; GFX9-NEXT:    v_bfi_b32 v0, v2, s2, v0
; GFX9-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v4i16_dynamic_vgpr:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; VI-NEXT:    s_load_dword s4, s[4:5], 0x10
; VI-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v4, v[0:1]
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    s_mov_b32 s2, 0xffff
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    s_mov_b32 s3, 0
; VI-NEXT:    s_and_b32 s1, s4, s2
; VI-NEXT:    v_add_u32_e32 v2, vcc, s0, v2
; VI-NEXT:    s_lshl_b32 s0, s1, 16
; VI-NEXT:    s_or_b32 s0, s1, s0
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_lshlrev_b32_e32 v4, 4, v4
; VI-NEXT:    v_lshlrev_b64 v[4:5], v4, s[2:3]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_bfi_b32 v1, v5, s0, v1
; VI-NEXT:    v_bfi_b32 v0, v4, s0, v0
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v4i16_dynamic_vgpr:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; CI-NEXT:    s_load_dword s4, s[4:5], 0x4
; CI-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dword v4, v[0:1]
; CI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; CI-NEXT:    s_mov_b32 s3, 0
; CI-NEXT:    s_mov_b32 s2, 0xffff
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    s_lshl_b32 s1, s4, 16
; CI-NEXT:    s_and_b32 s4, s4, s2
; CI-NEXT:    v_add_i32_e32 v2, vcc, s0, v2
; CI-NEXT:    s_or_b32 s0, s4, s1
; CI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; CI-NEXT:    s_waitcnt vmcnt(1)
; CI-NEXT:    v_lshlrev_b32_e32 v4, 4, v4
; CI-NEXT:    v_lshl_b64 v[4:5], s[2:3], v4
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_bfi_b32 v1, v5, s0, v1
; CI-NEXT:    v_bfi_b32 v0, v4, s0, v0
; CI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; CI-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <4 x i16>, <4 x i16> addrspace(1)* %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <4 x i16>, <4 x i16> addrspace(1)* %out, i64 %tid.ext
  %idx.val = load volatile i32, i32 addrspace(1)* undef
  %vec = load <4 x i16>, <4 x i16> addrspace(1)* %in.gep
  %val.trunc = trunc i32 %val to i16
  %val.cvt = bitcast i16 %val.trunc to i16
  %vecins = insertelement <4 x i16> %vec, i16 %val.cvt, i32 %idx.val
  store <4 x i16> %vecins, <4 x i16> addrspace(1)* %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v4f16_dynamic_sgpr(<4 x half> addrspace(1)* %out, <4 x half> addrspace(1)* %in, i32 %val, i32 %idxval) #0 {
; GFX9-LABEL: v_insertelement_v4f16_dynamic_sgpr:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX9-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x10
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v2, s[2:3]
; GFX9-NEXT:    s_pack_ll_b32_b16 s4, s4, s4
; GFX9-NEXT:    s_mov_b32 s3, 0
; GFX9-NEXT:    s_mov_b32 s2, 0xffff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 4
; GFX9-NEXT:    s_lshl_b64 s[2:3], s[2:3], s5
; GFX9-NEXT:    v_mov_b32_e32 v3, s4
; GFX9-NEXT:    v_mov_b32_e32 v4, s4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_bfi_b32 v1, s3, v3, v1
; GFX9-NEXT:    v_bfi_b32 v0, s2, v4, v0
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v4f16_dynamic_sgpr:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; VI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x10
; VI-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    s_mov_b32 s2, 0xffff
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    s_mov_b32 s3, 0
; VI-NEXT:    s_lshl_b32 s1, s5, 4
; VI-NEXT:    s_and_b32 s4, s4, s2
; VI-NEXT:    v_add_u32_e32 v2, vcc, s0, v2
; VI-NEXT:    s_lshl_b64 s[0:1], s[2:3], s1
; VI-NEXT:    s_lshl_b32 s2, s4, 16
; VI-NEXT:    s_or_b32 s2, s4, s2
; VI-NEXT:    v_mov_b32_e32 v4, s2
; VI-NEXT:    v_mov_b32_e32 v5, s2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_bfi_b32 v1, s1, v4, v1
; VI-NEXT:    v_bfi_b32 v0, s0, v5, v0
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v4f16_dynamic_sgpr:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; CI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x4
; CI-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; CI-NEXT:    s_mov_b32 s2, 0xffff
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    s_and_b32 s6, s4, s2
; CI-NEXT:    s_mov_b32 s3, 0
; CI-NEXT:    s_lshl_b32 s1, s5, 4
; CI-NEXT:    s_lshl_b32 s4, s4, 16
; CI-NEXT:    v_add_i32_e32 v2, vcc, s0, v2
; CI-NEXT:    s_lshl_b64 s[0:1], s[2:3], s1
; CI-NEXT:    s_or_b32 s2, s6, s4
; CI-NEXT:    v_mov_b32_e32 v4, s2
; CI-NEXT:    v_mov_b32_e32 v5, s2
; CI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_bfi_b32 v1, s1, v4, v1
; CI-NEXT:    v_bfi_b32 v0, s0, v5, v0
; CI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; CI-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <4 x half>, <4 x half> addrspace(1)* %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <4 x half>, <4 x half> addrspace(1)* %out, i64 %tid.ext
  %vec = load <4 x half>, <4 x half> addrspace(1)* %in.gep
  %val.trunc = trunc i32 %val to i16
  %val.cvt = bitcast i16 %val.trunc to half
  %vecins = insertelement <4 x half> %vec, half %val.cvt, i32 %idxval
  store <4 x half> %vecins, <4 x half> addrspace(1)* %out.gep
  ret void
}

declare i32 @llvm.amdgcn.workitem.id.x() #1

attributes #0 = { nounwind }
attributes #1 = { nounwind readnone }
