; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck -check-prefixes=GCN %s

; Check lowering of some large extractelement that use the stack
; instead of register indexing.

define i32 @v_extract_v64i32_varidx(<64 x i32> addrspace(1)* %ptr, i32 %idx) {
; GCN-LABEL: v_extract_v64i32_varidx:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v15, v0
; GCN-NEXT:    s_add_u32 s4, s32, 0x3fc0
; GCN-NEXT:    s_mov_b32 s5, 0
; GCN-NEXT:    s_mov_b32 s6, s33
; GCN-NEXT:    s_and_b32 s33, s4, 0xffffc000
; GCN-NEXT:    s_movk_i32 s4, 0x80
; GCN-NEXT:    v_mov_b32_e32 v12, s5
; GCN-NEXT:    v_mov_b32_e32 v16, v1
; GCN-NEXT:    v_add_co_u32_e32 v31, vcc, 64, v15
; GCN-NEXT:    v_mov_b32_e32 v11, s4
; GCN-NEXT:    v_addc_co_u32_e32 v32, vcc, 0, v16, vcc
; GCN-NEXT:    v_add_co_u32_e32 v48, vcc, v15, v11
; GCN-NEXT:    v_addc_co_u32_e32 v49, vcc, v16, v12, vcc
; GCN-NEXT:    s_movk_i32 s4, 0xc0
; GCN-NEXT:    v_mov_b32_e32 v12, s5
; GCN-NEXT:    v_mov_b32_e32 v11, s4
; GCN-NEXT:    buffer_store_dword v40, off, s[0:3], s33 offset:56 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v41, off, s[0:3], s33 offset:52 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v42, off, s[0:3], s33 offset:48 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v43, off, s[0:3], s33 offset:44 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v44, off, s[0:3], s33 offset:40 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v45, off, s[0:3], s33 offset:36 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v46, off, s[0:3], s33 offset:32 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v47, off, s[0:3], s33 offset:28 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v56, off, s[0:3], s33 offset:24 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v57, off, s[0:3], s33 offset:20 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v58, off, s[0:3], s33 offset:16 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v59, off, s[0:3], s33 offset:12 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v60, off, s[0:3], s33 offset:8 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v61, off, s[0:3], s33 offset:4 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v62, off, s[0:3], s33 ; 4-byte Folded Spill
; GCN-NEXT:    v_add_co_u32_e32 v59, vcc, v15, v11
; GCN-NEXT:    global_load_dwordx4 v[3:6], v[15:16], off
; GCN-NEXT:    global_load_dwordx4 v[7:10], v[15:16], off offset:16
; GCN-NEXT:    v_addc_co_u32_e32 v60, vcc, v16, v12, vcc
; GCN-NEXT:    global_load_dwordx4 v[11:14], v[15:16], off offset:32
; GCN-NEXT:    global_load_dwordx4 v[15:18], v[15:16], off offset:48
; GCN-NEXT:    global_load_dwordx4 v[19:22], v[31:32], off
; GCN-NEXT:    global_load_dwordx4 v[23:26], v[31:32], off offset:16
; GCN-NEXT:    global_load_dwordx4 v[27:30], v[31:32], off offset:32
; GCN-NEXT:    global_load_dwordx4 v[31:34], v[31:32], off offset:48
; GCN-NEXT:    global_load_dwordx4 v[35:38], v[48:49], off
; GCN-NEXT:    global_load_dwordx4 v[39:42], v[48:49], off offset:16
; GCN-NEXT:    global_load_dwordx4 v[43:46], v[48:49], off offset:32
; GCN-NEXT:    v_lshrrev_b32_e64 v0, 6, s33
; GCN-NEXT:    v_add_u32_e32 v0, 0x100, v0
; GCN-NEXT:    v_add_u32_e32 v1, 16, v0
; GCN-NEXT:    s_add_u32 s32, s32, 0x10000
; GCN-NEXT:    s_sub_u32 s32, s32, 0x10000
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    buffer_store_dword v35, off, s[0:3], s33 offset:576 ; 4-byte Folded Spill
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    buffer_store_dword v36, off, s[0:3], s33 offset:580 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v37, off, s[0:3], s33 offset:584 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v38, off, s[0:3], s33 offset:588 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v39, off, s[0:3], s33 offset:592 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v40, off, s[0:3], s33 offset:596 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v41, off, s[0:3], s33 offset:600 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v42, off, s[0:3], s33 offset:604 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v43, off, s[0:3], s33 offset:608 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v44, off, s[0:3], s33 offset:612 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v45, off, s[0:3], s33 offset:616 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v46, off, s[0:3], s33 offset:620 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v47, off, s[0:3], s33 offset:624 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v48, off, s[0:3], s33 offset:628 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v49, off, s[0:3], s33 offset:632 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v50, off, s[0:3], s33 offset:636 ; 4-byte Folded Spill
; GCN-NEXT:    global_load_dwordx4 v[47:50], v[48:49], off offset:48
; GCN-NEXT:    global_load_dwordx4 v[43:46], v[59:60], off
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    buffer_store_dword v43, off, s[0:3], s33 offset:512 ; 4-byte Folded Spill
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    buffer_store_dword v44, off, s[0:3], s33 offset:516 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v45, off, s[0:3], s33 offset:520 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v46, off, s[0:3], s33 offset:524 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v47, off, s[0:3], s33 offset:528 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v48, off, s[0:3], s33 offset:532 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v49, off, s[0:3], s33 offset:536 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v50, off, s[0:3], s33 offset:540 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v51, off, s[0:3], s33 offset:544 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v52, off, s[0:3], s33 offset:548 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v53, off, s[0:3], s33 offset:552 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v54, off, s[0:3], s33 offset:556 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v55, off, s[0:3], s33 offset:560 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v56, off, s[0:3], s33 offset:564 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v57, off, s[0:3], s33 offset:568 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v58, off, s[0:3], s33 offset:572 ; 4-byte Folded Spill
; GCN-NEXT:    global_load_dwordx4 v[51:54], v[59:60], off offset:16
; GCN-NEXT:    global_load_dwordx4 v[55:58], v[59:60], off offset:32
; GCN-NEXT:    global_load_dwordx4 v[59:62], v[59:60], off offset:48
; GCN-NEXT:    buffer_store_dword v7, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 20, v0
; GCN-NEXT:    buffer_store_dword v8, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 24, v0
; GCN-NEXT:    buffer_store_dword v9, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 28, v0
; GCN-NEXT:    buffer_store_dword v10, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 32, v0
; GCN-NEXT:    buffer_store_dword v11, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 36, v0
; GCN-NEXT:    buffer_store_dword v12, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 40, v0
; GCN-NEXT:    buffer_store_dword v13, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 44, v0
; GCN-NEXT:    buffer_store_dword v14, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 48, v0
; GCN-NEXT:    buffer_store_dword v15, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 52, v0
; GCN-NEXT:    buffer_store_dword v16, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 56, v0
; GCN-NEXT:    buffer_store_dword v17, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 60, v0
; GCN-NEXT:    buffer_store_dword v18, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 64, v0
; GCN-NEXT:    buffer_store_dword v19, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x44, v0
; GCN-NEXT:    buffer_store_dword v20, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x48, v0
; GCN-NEXT:    buffer_store_dword v21, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x4c, v0
; GCN-NEXT:    buffer_store_dword v22, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x50, v0
; GCN-NEXT:    buffer_store_dword v23, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x54, v0
; GCN-NEXT:    buffer_store_dword v24, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x58, v0
; GCN-NEXT:    buffer_store_dword v25, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x5c, v0
; GCN-NEXT:    buffer_store_dword v26, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x60, v0
; GCN-NEXT:    buffer_store_dword v27, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x64, v0
; GCN-NEXT:    buffer_store_dword v28, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x68, v0
; GCN-NEXT:    buffer_store_dword v29, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x6c, v0
; GCN-NEXT:    buffer_store_dword v30, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x70, v0
; GCN-NEXT:    buffer_store_dword v31, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x74, v0
; GCN-NEXT:    buffer_store_dword v32, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x78, v0
; GCN-NEXT:    buffer_store_dword v33, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x7c, v0
; GCN-NEXT:    buffer_store_dword v34, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x80, v0
; GCN-NEXT:    buffer_store_dword v35, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x84, v0
; GCN-NEXT:    buffer_store_dword v36, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x88, v0
; GCN-NEXT:    buffer_store_dword v37, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x8c, v0
; GCN-NEXT:    buffer_store_dword v38, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x90, v0
; GCN-NEXT:    buffer_store_dword v39, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x94, v0
; GCN-NEXT:    buffer_store_dword v40, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x98, v0
; GCN-NEXT:    buffer_store_dword v41, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x9c, v0
; GCN-NEXT:    buffer_store_dword v42, v1, s[0:3], 0 offen
; GCN-NEXT:    buffer_load_dword v7, off, s[0:3], s33 offset:576 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v8, off, s[0:3], s33 offset:580 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v9, off, s[0:3], s33 offset:584 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v10, off, s[0:3], s33 offset:588 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v11, off, s[0:3], s33 offset:592 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v12, off, s[0:3], s33 offset:596 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v13, off, s[0:3], s33 offset:600 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v14, off, s[0:3], s33 offset:604 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v15, off, s[0:3], s33 offset:608 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v16, off, s[0:3], s33 offset:612 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v17, off, s[0:3], s33 offset:616 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v18, off, s[0:3], s33 offset:620 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v19, off, s[0:3], s33 offset:624 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v20, off, s[0:3], s33 offset:628 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v21, off, s[0:3], s33 offset:632 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v22, off, s[0:3], s33 offset:636 ; 4-byte Folded Reload
; GCN-NEXT:    v_add_u32_e32 v1, 0xa0, v0
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v8, v15
; GCN-NEXT:    buffer_store_dword v8, v1, s[0:3], 0 offen
; GCN-NEXT:    v_mov_b32_e32 v9, v16
; GCN-NEXT:    v_add_u32_e32 v1, 0xa4, v0
; GCN-NEXT:    buffer_store_dword v9, v1, s[0:3], 0 offen
; GCN-NEXT:    v_mov_b32_e32 v10, v17
; GCN-NEXT:    v_add_u32_e32 v1, 0xa8, v0
; GCN-NEXT:    buffer_store_dword v10, v1, s[0:3], 0 offen
; GCN-NEXT:    v_mov_b32_e32 v11, v18
; GCN-NEXT:    v_add_u32_e32 v1, 0xac, v0
; GCN-NEXT:    buffer_store_dword v11, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xb0, v0
; GCN-NEXT:    buffer_store_dword v47, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xb4, v0
; GCN-NEXT:    buffer_store_dword v48, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xb8, v0
; GCN-NEXT:    buffer_store_dword v49, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xbc, v0
; GCN-NEXT:    buffer_store_dword v50, v1, s[0:3], 0 offen
; GCN-NEXT:    buffer_load_dword v7, off, s[0:3], s33 offset:512 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v8, off, s[0:3], s33 offset:516 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v9, off, s[0:3], s33 offset:520 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v10, off, s[0:3], s33 offset:524 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v11, off, s[0:3], s33 offset:528 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v12, off, s[0:3], s33 offset:532 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v13, off, s[0:3], s33 offset:536 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v14, off, s[0:3], s33 offset:540 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v15, off, s[0:3], s33 offset:544 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v16, off, s[0:3], s33 offset:548 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v17, off, s[0:3], s33 offset:552 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v18, off, s[0:3], s33 offset:556 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v19, off, s[0:3], s33 offset:560 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v20, off, s[0:3], s33 offset:564 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v21, off, s[0:3], s33 offset:568 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v22, off, s[0:3], s33 offset:572 ; 4-byte Folded Reload
; GCN-NEXT:    v_add_u32_e32 v1, 0xc0, v0
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    buffer_store_dword v7, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xc4, v0
; GCN-NEXT:    buffer_store_dword v8, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xc8, v0
; GCN-NEXT:    buffer_store_dword v9, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xcc, v0
; GCN-NEXT:    buffer_store_dword v10, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 4, v0
; GCN-NEXT:    buffer_store_dword v4, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 8, v0
; GCN-NEXT:    buffer_store_dword v5, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 12, v0
; GCN-NEXT:    buffer_store_dword v6, v1, s[0:3], 0 offen
; GCN-NEXT:    buffer_store_dword v3, off, s[0:3], s33 offset:256
; GCN-NEXT:    v_add_u32_e32 v1, 0xd0, v0
; GCN-NEXT:    buffer_store_dword v51, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xd4, v0
; GCN-NEXT:    buffer_store_dword v52, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xd8, v0
; GCN-NEXT:    buffer_store_dword v53, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xdc, v0
; GCN-NEXT:    buffer_store_dword v54, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xe0, v0
; GCN-NEXT:    buffer_store_dword v55, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xe4, v0
; GCN-NEXT:    buffer_store_dword v56, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xe8, v0
; GCN-NEXT:    buffer_store_dword v57, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xec, v0
; GCN-NEXT:    buffer_store_dword v58, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xf0, v0
; GCN-NEXT:    buffer_store_dword v59, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xf4, v0
; GCN-NEXT:    buffer_store_dword v60, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xf8, v0
; GCN-NEXT:    buffer_store_dword v61, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xfc, v0
; GCN-NEXT:    buffer_store_dword v62, v1, s[0:3], 0 offen
; GCN-NEXT:    v_and_b32_e32 v1, 63, v2
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GCN-NEXT:    v_add_u32_e32 v0, v0, v1
; GCN-NEXT:    buffer_load_dword v0, v0, s[0:3], 0 offen
; GCN-NEXT:    buffer_load_dword v62, off, s[0:3], s33 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v61, off, s[0:3], s33 offset:4 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v60, off, s[0:3], s33 offset:8 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v59, off, s[0:3], s33 offset:12 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v58, off, s[0:3], s33 offset:16 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v57, off, s[0:3], s33 offset:20 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v56, off, s[0:3], s33 offset:24 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v47, off, s[0:3], s33 offset:28 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v46, off, s[0:3], s33 offset:32 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v45, off, s[0:3], s33 offset:36 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v44, off, s[0:3], s33 offset:40 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v43, off, s[0:3], s33 offset:44 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v42, off, s[0:3], s33 offset:48 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v41, off, s[0:3], s33 offset:52 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v40, off, s[0:3], s33 offset:56 ; 4-byte Folded Reload
; GCN-NEXT:    s_mov_b32 s33, s6
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %vec = load <64 x i32>, <64 x i32> addrspace(1)* %ptr
  %elt = extractelement <64 x i32> %vec, i32 %idx
  ret i32 %elt
}

define i16 @v_extract_v128i16_varidx(<128 x i16> addrspace(1)* %ptr, i32 %idx) {
; GCN-LABEL: v_extract_v128i16_varidx:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v15, v0
; GCN-NEXT:    s_add_u32 s4, s32, 0x3fc0
; GCN-NEXT:    s_mov_b32 s5, 0
; GCN-NEXT:    s_mov_b32 s6, s33
; GCN-NEXT:    s_and_b32 s33, s4, 0xffffc000
; GCN-NEXT:    s_movk_i32 s4, 0x80
; GCN-NEXT:    v_mov_b32_e32 v12, s5
; GCN-NEXT:    v_mov_b32_e32 v16, v1
; GCN-NEXT:    v_add_co_u32_e32 v31, vcc, 64, v15
; GCN-NEXT:    v_mov_b32_e32 v11, s4
; GCN-NEXT:    v_addc_co_u32_e32 v32, vcc, 0, v16, vcc
; GCN-NEXT:    v_add_co_u32_e32 v48, vcc, v15, v11
; GCN-NEXT:    v_addc_co_u32_e32 v49, vcc, v16, v12, vcc
; GCN-NEXT:    s_movk_i32 s4, 0xc0
; GCN-NEXT:    v_mov_b32_e32 v12, s5
; GCN-NEXT:    v_mov_b32_e32 v11, s4
; GCN-NEXT:    buffer_store_dword v40, off, s[0:3], s33 offset:56 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v41, off, s[0:3], s33 offset:52 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v42, off, s[0:3], s33 offset:48 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v43, off, s[0:3], s33 offset:44 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v44, off, s[0:3], s33 offset:40 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v45, off, s[0:3], s33 offset:36 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v46, off, s[0:3], s33 offset:32 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v47, off, s[0:3], s33 offset:28 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v56, off, s[0:3], s33 offset:24 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v57, off, s[0:3], s33 offset:20 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v58, off, s[0:3], s33 offset:16 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v59, off, s[0:3], s33 offset:12 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v60, off, s[0:3], s33 offset:8 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v61, off, s[0:3], s33 offset:4 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v62, off, s[0:3], s33 ; 4-byte Folded Spill
; GCN-NEXT:    v_add_co_u32_e32 v59, vcc, v15, v11
; GCN-NEXT:    global_load_dwordx4 v[3:6], v[15:16], off
; GCN-NEXT:    global_load_dwordx4 v[7:10], v[15:16], off offset:16
; GCN-NEXT:    v_addc_co_u32_e32 v60, vcc, v16, v12, vcc
; GCN-NEXT:    global_load_dwordx4 v[11:14], v[15:16], off offset:32
; GCN-NEXT:    global_load_dwordx4 v[15:18], v[15:16], off offset:48
; GCN-NEXT:    global_load_dwordx4 v[19:22], v[31:32], off
; GCN-NEXT:    global_load_dwordx4 v[23:26], v[31:32], off offset:16
; GCN-NEXT:    global_load_dwordx4 v[27:30], v[31:32], off offset:32
; GCN-NEXT:    global_load_dwordx4 v[31:34], v[31:32], off offset:48
; GCN-NEXT:    global_load_dwordx4 v[35:38], v[48:49], off
; GCN-NEXT:    global_load_dwordx4 v[39:42], v[48:49], off offset:16
; GCN-NEXT:    global_load_dwordx4 v[43:46], v[48:49], off offset:32
; GCN-NEXT:    v_lshrrev_b32_e64 v0, 6, s33
; GCN-NEXT:    v_add_u32_e32 v0, 0x100, v0
; GCN-NEXT:    v_add_u32_e32 v1, 16, v0
; GCN-NEXT:    s_add_u32 s32, s32, 0x10000
; GCN-NEXT:    s_sub_u32 s32, s32, 0x10000
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    buffer_store_dword v35, off, s[0:3], s33 offset:576 ; 4-byte Folded Spill
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    buffer_store_dword v36, off, s[0:3], s33 offset:580 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v37, off, s[0:3], s33 offset:584 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v38, off, s[0:3], s33 offset:588 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v39, off, s[0:3], s33 offset:592 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v40, off, s[0:3], s33 offset:596 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v41, off, s[0:3], s33 offset:600 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v42, off, s[0:3], s33 offset:604 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v43, off, s[0:3], s33 offset:608 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v44, off, s[0:3], s33 offset:612 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v45, off, s[0:3], s33 offset:616 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v46, off, s[0:3], s33 offset:620 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v47, off, s[0:3], s33 offset:624 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v48, off, s[0:3], s33 offset:628 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v49, off, s[0:3], s33 offset:632 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v50, off, s[0:3], s33 offset:636 ; 4-byte Folded Spill
; GCN-NEXT:    global_load_dwordx4 v[47:50], v[48:49], off offset:48
; GCN-NEXT:    global_load_dwordx4 v[43:46], v[59:60], off
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    buffer_store_dword v43, off, s[0:3], s33 offset:512 ; 4-byte Folded Spill
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    buffer_store_dword v44, off, s[0:3], s33 offset:516 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v45, off, s[0:3], s33 offset:520 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v46, off, s[0:3], s33 offset:524 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v47, off, s[0:3], s33 offset:528 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v48, off, s[0:3], s33 offset:532 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v49, off, s[0:3], s33 offset:536 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v50, off, s[0:3], s33 offset:540 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v51, off, s[0:3], s33 offset:544 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v52, off, s[0:3], s33 offset:548 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v53, off, s[0:3], s33 offset:552 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v54, off, s[0:3], s33 offset:556 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v55, off, s[0:3], s33 offset:560 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v56, off, s[0:3], s33 offset:564 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v57, off, s[0:3], s33 offset:568 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v58, off, s[0:3], s33 offset:572 ; 4-byte Folded Spill
; GCN-NEXT:    global_load_dwordx4 v[51:54], v[59:60], off offset:16
; GCN-NEXT:    global_load_dwordx4 v[55:58], v[59:60], off offset:32
; GCN-NEXT:    global_load_dwordx4 v[59:62], v[59:60], off offset:48
; GCN-NEXT:    buffer_store_dword v7, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 20, v0
; GCN-NEXT:    buffer_store_dword v8, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 24, v0
; GCN-NEXT:    buffer_store_dword v9, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 28, v0
; GCN-NEXT:    buffer_store_dword v10, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 32, v0
; GCN-NEXT:    buffer_store_dword v11, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 36, v0
; GCN-NEXT:    buffer_store_dword v12, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 40, v0
; GCN-NEXT:    buffer_store_dword v13, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 44, v0
; GCN-NEXT:    buffer_store_dword v14, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 48, v0
; GCN-NEXT:    buffer_store_dword v15, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 52, v0
; GCN-NEXT:    buffer_store_dword v16, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 56, v0
; GCN-NEXT:    buffer_store_dword v17, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 60, v0
; GCN-NEXT:    buffer_store_dword v18, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 64, v0
; GCN-NEXT:    buffer_store_dword v19, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x44, v0
; GCN-NEXT:    buffer_store_dword v20, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x48, v0
; GCN-NEXT:    buffer_store_dword v21, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x4c, v0
; GCN-NEXT:    buffer_store_dword v22, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x50, v0
; GCN-NEXT:    buffer_store_dword v23, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x54, v0
; GCN-NEXT:    buffer_store_dword v24, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x58, v0
; GCN-NEXT:    buffer_store_dword v25, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x5c, v0
; GCN-NEXT:    buffer_store_dword v26, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x60, v0
; GCN-NEXT:    buffer_store_dword v27, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x64, v0
; GCN-NEXT:    buffer_store_dword v28, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x68, v0
; GCN-NEXT:    buffer_store_dword v29, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x6c, v0
; GCN-NEXT:    buffer_store_dword v30, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x70, v0
; GCN-NEXT:    buffer_store_dword v31, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x74, v0
; GCN-NEXT:    buffer_store_dword v32, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x78, v0
; GCN-NEXT:    buffer_store_dword v33, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x7c, v0
; GCN-NEXT:    buffer_store_dword v34, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x80, v0
; GCN-NEXT:    buffer_store_dword v35, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x84, v0
; GCN-NEXT:    buffer_store_dword v36, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x88, v0
; GCN-NEXT:    buffer_store_dword v37, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x8c, v0
; GCN-NEXT:    buffer_store_dword v38, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x90, v0
; GCN-NEXT:    buffer_store_dword v39, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x94, v0
; GCN-NEXT:    buffer_store_dword v40, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x98, v0
; GCN-NEXT:    buffer_store_dword v41, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x9c, v0
; GCN-NEXT:    buffer_store_dword v42, v1, s[0:3], 0 offen
; GCN-NEXT:    buffer_load_dword v7, off, s[0:3], s33 offset:576 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v8, off, s[0:3], s33 offset:580 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v9, off, s[0:3], s33 offset:584 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v10, off, s[0:3], s33 offset:588 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v11, off, s[0:3], s33 offset:592 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v12, off, s[0:3], s33 offset:596 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v13, off, s[0:3], s33 offset:600 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v14, off, s[0:3], s33 offset:604 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v15, off, s[0:3], s33 offset:608 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v16, off, s[0:3], s33 offset:612 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v17, off, s[0:3], s33 offset:616 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v18, off, s[0:3], s33 offset:620 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v19, off, s[0:3], s33 offset:624 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v20, off, s[0:3], s33 offset:628 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v21, off, s[0:3], s33 offset:632 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v22, off, s[0:3], s33 offset:636 ; 4-byte Folded Reload
; GCN-NEXT:    v_add_u32_e32 v1, 0xa0, v0
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v8, v15
; GCN-NEXT:    buffer_store_dword v8, v1, s[0:3], 0 offen
; GCN-NEXT:    v_mov_b32_e32 v9, v16
; GCN-NEXT:    v_add_u32_e32 v1, 0xa4, v0
; GCN-NEXT:    buffer_store_dword v9, v1, s[0:3], 0 offen
; GCN-NEXT:    v_mov_b32_e32 v10, v17
; GCN-NEXT:    v_add_u32_e32 v1, 0xa8, v0
; GCN-NEXT:    buffer_store_dword v10, v1, s[0:3], 0 offen
; GCN-NEXT:    v_mov_b32_e32 v11, v18
; GCN-NEXT:    v_add_u32_e32 v1, 0xac, v0
; GCN-NEXT:    buffer_store_dword v11, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xb0, v0
; GCN-NEXT:    buffer_store_dword v47, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xb4, v0
; GCN-NEXT:    buffer_store_dword v48, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xb8, v0
; GCN-NEXT:    buffer_store_dword v49, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xbc, v0
; GCN-NEXT:    buffer_store_dword v50, v1, s[0:3], 0 offen
; GCN-NEXT:    buffer_load_dword v7, off, s[0:3], s33 offset:512 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v8, off, s[0:3], s33 offset:516 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v9, off, s[0:3], s33 offset:520 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v10, off, s[0:3], s33 offset:524 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v11, off, s[0:3], s33 offset:528 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v12, off, s[0:3], s33 offset:532 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v13, off, s[0:3], s33 offset:536 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v14, off, s[0:3], s33 offset:540 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v15, off, s[0:3], s33 offset:544 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v16, off, s[0:3], s33 offset:548 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v17, off, s[0:3], s33 offset:552 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v18, off, s[0:3], s33 offset:556 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v19, off, s[0:3], s33 offset:560 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v20, off, s[0:3], s33 offset:564 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v21, off, s[0:3], s33 offset:568 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v22, off, s[0:3], s33 offset:572 ; 4-byte Folded Reload
; GCN-NEXT:    v_add_u32_e32 v1, 0xc0, v0
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    buffer_store_dword v7, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xc4, v0
; GCN-NEXT:    buffer_store_dword v8, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xc8, v0
; GCN-NEXT:    buffer_store_dword v9, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xcc, v0
; GCN-NEXT:    buffer_store_dword v10, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 4, v0
; GCN-NEXT:    buffer_store_dword v4, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 8, v0
; GCN-NEXT:    buffer_store_dword v5, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 12, v0
; GCN-NEXT:    buffer_store_dword v6, v1, s[0:3], 0 offen
; GCN-NEXT:    buffer_store_dword v3, off, s[0:3], s33 offset:256
; GCN-NEXT:    v_add_u32_e32 v3, 0xd0, v0
; GCN-NEXT:    buffer_store_dword v51, v3, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v3, 0xd4, v0
; GCN-NEXT:    buffer_store_dword v52, v3, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v3, 0xd8, v0
; GCN-NEXT:    buffer_store_dword v53, v3, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v3, 0xdc, v0
; GCN-NEXT:    buffer_store_dword v54, v3, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v3, 0xe0, v0
; GCN-NEXT:    buffer_store_dword v55, v3, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v3, 0xe4, v0
; GCN-NEXT:    buffer_store_dword v56, v3, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v3, 0xe8, v0
; GCN-NEXT:    buffer_store_dword v57, v3, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v3, 0xec, v0
; GCN-NEXT:    buffer_store_dword v58, v3, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v3, 0xf0, v0
; GCN-NEXT:    v_lshrrev_b32_e32 v1, 1, v2
; GCN-NEXT:    buffer_store_dword v59, v3, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v3, 0xf4, v0
; GCN-NEXT:    v_and_b32_e32 v1, 63, v1
; GCN-NEXT:    buffer_store_dword v60, v3, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v3, 0xf8, v0
; GCN-NEXT:    buffer_store_dword v61, v3, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v3, 0xfc, v0
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GCN-NEXT:    v_add_u32_e32 v0, v0, v1
; GCN-NEXT:    buffer_store_dword v62, v3, s[0:3], 0 offen
; GCN-NEXT:    buffer_load_dword v0, v0, s[0:3], 0 offen
; GCN-NEXT:    buffer_load_dword v62, off, s[0:3], s33 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v61, off, s[0:3], s33 offset:4 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v60, off, s[0:3], s33 offset:8 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v59, off, s[0:3], s33 offset:12 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v58, off, s[0:3], s33 offset:16 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v57, off, s[0:3], s33 offset:20 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v56, off, s[0:3], s33 offset:24 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v47, off, s[0:3], s33 offset:28 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v46, off, s[0:3], s33 offset:32 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v45, off, s[0:3], s33 offset:36 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v44, off, s[0:3], s33 offset:40 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v43, off, s[0:3], s33 offset:44 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v42, off, s[0:3], s33 offset:48 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v41, off, s[0:3], s33 offset:52 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v40, off, s[0:3], s33 offset:56 ; 4-byte Folded Reload
; GCN-NEXT:    v_and_b32_e32 v1, 1, v2
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GCN-NEXT:    s_mov_b32 s33, s6
; GCN-NEXT:    s_waitcnt vmcnt(15)
; GCN-NEXT:    v_lshrrev_b32_e32 v0, v1, v0
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %vec = load <128 x i16>, <128 x i16> addrspace(1)* %ptr
  %elt = extractelement <128 x i16> %vec, i32 %idx
  ret i16 %elt
}

define i64 @v_extract_v32i64_varidx(<32 x i64> addrspace(1)* %ptr, i32 %idx) {
; GCN-LABEL: v_extract_v32i64_varidx:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v15, v0
; GCN-NEXT:    s_add_u32 s4, s32, 0x3fc0
; GCN-NEXT:    s_mov_b32 s5, 0
; GCN-NEXT:    s_mov_b32 s6, s33
; GCN-NEXT:    s_and_b32 s33, s4, 0xffffc000
; GCN-NEXT:    s_movk_i32 s4, 0x80
; GCN-NEXT:    v_mov_b32_e32 v12, s5
; GCN-NEXT:    v_mov_b32_e32 v16, v1
; GCN-NEXT:    v_add_co_u32_e32 v31, vcc, 64, v15
; GCN-NEXT:    v_mov_b32_e32 v11, s4
; GCN-NEXT:    v_addc_co_u32_e32 v32, vcc, 0, v16, vcc
; GCN-NEXT:    v_add_co_u32_e32 v48, vcc, v15, v11
; GCN-NEXT:    v_addc_co_u32_e32 v49, vcc, v16, v12, vcc
; GCN-NEXT:    s_movk_i32 s4, 0xc0
; GCN-NEXT:    v_mov_b32_e32 v12, s5
; GCN-NEXT:    v_mov_b32_e32 v11, s4
; GCN-NEXT:    buffer_store_dword v40, off, s[0:3], s33 offset:56 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v41, off, s[0:3], s33 offset:52 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v42, off, s[0:3], s33 offset:48 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v43, off, s[0:3], s33 offset:44 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v44, off, s[0:3], s33 offset:40 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v45, off, s[0:3], s33 offset:36 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v46, off, s[0:3], s33 offset:32 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v47, off, s[0:3], s33 offset:28 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v56, off, s[0:3], s33 offset:24 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v57, off, s[0:3], s33 offset:20 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v58, off, s[0:3], s33 offset:16 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v59, off, s[0:3], s33 offset:12 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v60, off, s[0:3], s33 offset:8 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v61, off, s[0:3], s33 offset:4 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v62, off, s[0:3], s33 ; 4-byte Folded Spill
; GCN-NEXT:    v_add_co_u32_e32 v59, vcc, v15, v11
; GCN-NEXT:    global_load_dwordx4 v[3:6], v[15:16], off
; GCN-NEXT:    global_load_dwordx4 v[7:10], v[15:16], off offset:16
; GCN-NEXT:    v_addc_co_u32_e32 v60, vcc, v16, v12, vcc
; GCN-NEXT:    global_load_dwordx4 v[11:14], v[15:16], off offset:32
; GCN-NEXT:    global_load_dwordx4 v[15:18], v[15:16], off offset:48
; GCN-NEXT:    global_load_dwordx4 v[19:22], v[31:32], off
; GCN-NEXT:    global_load_dwordx4 v[23:26], v[31:32], off offset:16
; GCN-NEXT:    global_load_dwordx4 v[27:30], v[31:32], off offset:32
; GCN-NEXT:    global_load_dwordx4 v[31:34], v[31:32], off offset:48
; GCN-NEXT:    global_load_dwordx4 v[35:38], v[48:49], off
; GCN-NEXT:    global_load_dwordx4 v[39:42], v[48:49], off offset:16
; GCN-NEXT:    global_load_dwordx4 v[43:46], v[48:49], off offset:32
; GCN-NEXT:    v_lshrrev_b32_e64 v0, 6, s33
; GCN-NEXT:    v_add_u32_e32 v0, 0x100, v0
; GCN-NEXT:    v_add_u32_e32 v1, 16, v0
; GCN-NEXT:    s_add_u32 s32, s32, 0x10000
; GCN-NEXT:    s_sub_u32 s32, s32, 0x10000
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    buffer_store_dword v35, off, s[0:3], s33 offset:576 ; 4-byte Folded Spill
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    buffer_store_dword v36, off, s[0:3], s33 offset:580 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v37, off, s[0:3], s33 offset:584 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v38, off, s[0:3], s33 offset:588 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v39, off, s[0:3], s33 offset:592 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v40, off, s[0:3], s33 offset:596 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v41, off, s[0:3], s33 offset:600 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v42, off, s[0:3], s33 offset:604 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v43, off, s[0:3], s33 offset:608 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v44, off, s[0:3], s33 offset:612 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v45, off, s[0:3], s33 offset:616 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v46, off, s[0:3], s33 offset:620 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v47, off, s[0:3], s33 offset:624 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v48, off, s[0:3], s33 offset:628 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v49, off, s[0:3], s33 offset:632 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v50, off, s[0:3], s33 offset:636 ; 4-byte Folded Spill
; GCN-NEXT:    global_load_dwordx4 v[47:50], v[48:49], off offset:48
; GCN-NEXT:    global_load_dwordx4 v[43:46], v[59:60], off
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    buffer_store_dword v43, off, s[0:3], s33 offset:512 ; 4-byte Folded Spill
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    buffer_store_dword v44, off, s[0:3], s33 offset:516 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v45, off, s[0:3], s33 offset:520 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v46, off, s[0:3], s33 offset:524 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v47, off, s[0:3], s33 offset:528 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v48, off, s[0:3], s33 offset:532 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v49, off, s[0:3], s33 offset:536 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v50, off, s[0:3], s33 offset:540 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v51, off, s[0:3], s33 offset:544 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v52, off, s[0:3], s33 offset:548 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v53, off, s[0:3], s33 offset:552 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v54, off, s[0:3], s33 offset:556 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v55, off, s[0:3], s33 offset:560 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v56, off, s[0:3], s33 offset:564 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v57, off, s[0:3], s33 offset:568 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v58, off, s[0:3], s33 offset:572 ; 4-byte Folded Spill
; GCN-NEXT:    global_load_dwordx4 v[51:54], v[59:60], off offset:16
; GCN-NEXT:    global_load_dwordx4 v[55:58], v[59:60], off offset:32
; GCN-NEXT:    global_load_dwordx4 v[59:62], v[59:60], off offset:48
; GCN-NEXT:    buffer_store_dword v7, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 20, v0
; GCN-NEXT:    buffer_store_dword v8, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 24, v0
; GCN-NEXT:    buffer_store_dword v9, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 28, v0
; GCN-NEXT:    buffer_store_dword v10, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 32, v0
; GCN-NEXT:    buffer_store_dword v11, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 36, v0
; GCN-NEXT:    buffer_store_dword v12, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 40, v0
; GCN-NEXT:    buffer_store_dword v13, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 44, v0
; GCN-NEXT:    buffer_store_dword v14, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 48, v0
; GCN-NEXT:    buffer_store_dword v15, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 52, v0
; GCN-NEXT:    buffer_store_dword v16, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 56, v0
; GCN-NEXT:    buffer_store_dword v17, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 60, v0
; GCN-NEXT:    buffer_store_dword v18, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 64, v0
; GCN-NEXT:    buffer_store_dword v19, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x44, v0
; GCN-NEXT:    buffer_store_dword v20, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x48, v0
; GCN-NEXT:    buffer_store_dword v21, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x4c, v0
; GCN-NEXT:    buffer_store_dword v22, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x50, v0
; GCN-NEXT:    buffer_store_dword v23, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x54, v0
; GCN-NEXT:    buffer_store_dword v24, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x58, v0
; GCN-NEXT:    buffer_store_dword v25, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x5c, v0
; GCN-NEXT:    buffer_store_dword v26, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x60, v0
; GCN-NEXT:    buffer_store_dword v27, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x64, v0
; GCN-NEXT:    buffer_store_dword v28, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x68, v0
; GCN-NEXT:    buffer_store_dword v29, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x6c, v0
; GCN-NEXT:    buffer_store_dword v30, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x70, v0
; GCN-NEXT:    buffer_store_dword v31, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x74, v0
; GCN-NEXT:    buffer_store_dword v32, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x78, v0
; GCN-NEXT:    buffer_store_dword v33, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x7c, v0
; GCN-NEXT:    buffer_store_dword v34, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x80, v0
; GCN-NEXT:    buffer_store_dword v35, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x84, v0
; GCN-NEXT:    buffer_store_dword v36, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x88, v0
; GCN-NEXT:    buffer_store_dword v37, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x8c, v0
; GCN-NEXT:    buffer_store_dword v38, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x90, v0
; GCN-NEXT:    buffer_store_dword v39, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x94, v0
; GCN-NEXT:    buffer_store_dword v40, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x98, v0
; GCN-NEXT:    buffer_store_dword v41, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0x9c, v0
; GCN-NEXT:    buffer_store_dword v42, v1, s[0:3], 0 offen
; GCN-NEXT:    buffer_load_dword v7, off, s[0:3], s33 offset:576 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v8, off, s[0:3], s33 offset:580 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v9, off, s[0:3], s33 offset:584 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v10, off, s[0:3], s33 offset:588 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v11, off, s[0:3], s33 offset:592 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v12, off, s[0:3], s33 offset:596 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v13, off, s[0:3], s33 offset:600 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v14, off, s[0:3], s33 offset:604 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v15, off, s[0:3], s33 offset:608 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v16, off, s[0:3], s33 offset:612 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v17, off, s[0:3], s33 offset:616 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v18, off, s[0:3], s33 offset:620 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v19, off, s[0:3], s33 offset:624 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v20, off, s[0:3], s33 offset:628 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v21, off, s[0:3], s33 offset:632 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v22, off, s[0:3], s33 offset:636 ; 4-byte Folded Reload
; GCN-NEXT:    v_add_u32_e32 v1, 0xa0, v0
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v8, v15
; GCN-NEXT:    buffer_store_dword v8, v1, s[0:3], 0 offen
; GCN-NEXT:    v_mov_b32_e32 v9, v16
; GCN-NEXT:    v_add_u32_e32 v1, 0xa4, v0
; GCN-NEXT:    buffer_store_dword v9, v1, s[0:3], 0 offen
; GCN-NEXT:    v_mov_b32_e32 v10, v17
; GCN-NEXT:    v_add_u32_e32 v1, 0xa8, v0
; GCN-NEXT:    buffer_store_dword v10, v1, s[0:3], 0 offen
; GCN-NEXT:    v_mov_b32_e32 v11, v18
; GCN-NEXT:    v_add_u32_e32 v1, 0xac, v0
; GCN-NEXT:    buffer_store_dword v11, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xb0, v0
; GCN-NEXT:    buffer_store_dword v47, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xb4, v0
; GCN-NEXT:    buffer_store_dword v48, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xb8, v0
; GCN-NEXT:    buffer_store_dword v49, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xbc, v0
; GCN-NEXT:    buffer_store_dword v50, v1, s[0:3], 0 offen
; GCN-NEXT:    buffer_load_dword v7, off, s[0:3], s33 offset:512 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v8, off, s[0:3], s33 offset:516 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v9, off, s[0:3], s33 offset:520 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v10, off, s[0:3], s33 offset:524 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v11, off, s[0:3], s33 offset:528 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v12, off, s[0:3], s33 offset:532 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v13, off, s[0:3], s33 offset:536 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v14, off, s[0:3], s33 offset:540 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v15, off, s[0:3], s33 offset:544 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v16, off, s[0:3], s33 offset:548 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v17, off, s[0:3], s33 offset:552 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v18, off, s[0:3], s33 offset:556 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v19, off, s[0:3], s33 offset:560 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v20, off, s[0:3], s33 offset:564 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v21, off, s[0:3], s33 offset:568 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v22, off, s[0:3], s33 offset:572 ; 4-byte Folded Reload
; GCN-NEXT:    v_add_u32_e32 v1, 0xc0, v0
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    buffer_store_dword v7, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xc4, v0
; GCN-NEXT:    buffer_store_dword v8, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xc8, v0
; GCN-NEXT:    buffer_store_dword v9, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xcc, v0
; GCN-NEXT:    buffer_store_dword v10, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 4, v0
; GCN-NEXT:    buffer_store_dword v4, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 8, v0
; GCN-NEXT:    buffer_store_dword v5, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 12, v0
; GCN-NEXT:    buffer_store_dword v6, v1, s[0:3], 0 offen
; GCN-NEXT:    buffer_store_dword v3, off, s[0:3], s33 offset:256
; GCN-NEXT:    v_add_u32_e32 v1, 0xd0, v0
; GCN-NEXT:    buffer_store_dword v51, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xd4, v0
; GCN-NEXT:    buffer_store_dword v52, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xd8, v0
; GCN-NEXT:    buffer_store_dword v53, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xdc, v0
; GCN-NEXT:    buffer_store_dword v54, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xe0, v0
; GCN-NEXT:    buffer_store_dword v55, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xe4, v0
; GCN-NEXT:    buffer_store_dword v56, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xe8, v0
; GCN-NEXT:    buffer_store_dword v57, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xec, v0
; GCN-NEXT:    buffer_store_dword v58, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xf0, v0
; GCN-NEXT:    buffer_store_dword v59, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xf4, v0
; GCN-NEXT:    buffer_store_dword v60, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xf8, v0
; GCN-NEXT:    buffer_store_dword v61, v1, s[0:3], 0 offen
; GCN-NEXT:    v_add_u32_e32 v1, 0xfc, v0
; GCN-NEXT:    buffer_store_dword v62, v1, s[0:3], 0 offen
; GCN-NEXT:    v_and_b32_e32 v1, 31, v2
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GCN-NEXT:    v_add_u32_e32 v0, v0, v1
; GCN-NEXT:    v_add_u32_e32 v1, 4, v0
; GCN-NEXT:    buffer_load_dword v0, v0, s[0:3], 0 offen
; GCN-NEXT:    buffer_load_dword v1, v1, s[0:3], 0 offen
; GCN-NEXT:    buffer_load_dword v62, off, s[0:3], s33 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v61, off, s[0:3], s33 offset:4 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v60, off, s[0:3], s33 offset:8 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v59, off, s[0:3], s33 offset:12 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v58, off, s[0:3], s33 offset:16 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v57, off, s[0:3], s33 offset:20 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v56, off, s[0:3], s33 offset:24 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v47, off, s[0:3], s33 offset:28 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v46, off, s[0:3], s33 offset:32 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v45, off, s[0:3], s33 offset:36 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v44, off, s[0:3], s33 offset:40 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v43, off, s[0:3], s33 offset:44 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v42, off, s[0:3], s33 offset:48 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v41, off, s[0:3], s33 offset:52 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v40, off, s[0:3], s33 offset:56 ; 4-byte Folded Reload
; GCN-NEXT:    s_mov_b32 s33, s6
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %vec = load <32 x i64>, <32 x i64> addrspace(1)* %ptr
  %elt = extractelement <32 x i64> %vec, i32 %idx
  ret i64 %elt
}
