; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+ssse3 | FileCheck %s --check-prefixes=SSE,SSSE3
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.1 | FileCheck %s --check-prefixes=SSE,SSE41
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=AVX,AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+avx512vl,+fast-variable-shuffle | FileCheck %s --check-prefixes=AVX,AVX512

declare {<1 x i32>, <1 x i1>} @llvm.smul.with.overflow.v1i32(<1 x i32>, <1 x i32>)
declare {<2 x i32>, <2 x i1>} @llvm.smul.with.overflow.v2i32(<2 x i32>, <2 x i32>)
declare {<3 x i32>, <3 x i1>} @llvm.smul.with.overflow.v3i32(<3 x i32>, <3 x i32>)
declare {<4 x i32>, <4 x i1>} @llvm.smul.with.overflow.v4i32(<4 x i32>, <4 x i32>)
declare {<6 x i32>, <6 x i1>} @llvm.smul.with.overflow.v6i32(<6 x i32>, <6 x i32>)
declare {<8 x i32>, <8 x i1>} @llvm.smul.with.overflow.v8i32(<8 x i32>, <8 x i32>)
declare {<16 x i32>, <16 x i1>} @llvm.smul.with.overflow.v16i32(<16 x i32>, <16 x i32>)

declare {<16 x i8>, <16 x i1>} @llvm.smul.with.overflow.v16i8(<16 x i8>, <16 x i8>)
declare {<8 x i16>, <8 x i1>} @llvm.smul.with.overflow.v8i16(<8 x i16>, <8 x i16>)
declare {<2 x i64>, <2 x i1>} @llvm.smul.with.overflow.v2i64(<2 x i64>, <2 x i64>)

declare {<4 x i24>, <4 x i1>} @llvm.smul.with.overflow.v4i24(<4 x i24>, <4 x i24>)
declare {<4 x i1>, <4 x i1>} @llvm.smul.with.overflow.v4i1(<4 x i1>, <4 x i1>)
declare {<2 x i128>, <2 x i1>} @llvm.smul.with.overflow.v2i128(<2 x i128>, <2 x i128>)

define <1 x i32> @smulo_v1i32(<1 x i32> %a0, <1 x i32> %a1, <1 x i32>* %p2) nounwind {
; SSE-LABEL: smulo_v1i32:
; SSE:       # %bb.0:
; SSE-NEXT:    xorl %eax, %eax
; SSE-NEXT:    imull %esi, %edi
; SSE-NEXT:    seto %al
; SSE-NEXT:    negl %eax
; SSE-NEXT:    movl %edi, (%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: smulo_v1i32:
; AVX:       # %bb.0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    imull %esi, %edi
; AVX-NEXT:    seto %al
; AVX-NEXT:    negl %eax
; AVX-NEXT:    movl %edi, (%rdx)
; AVX-NEXT:    retq
  %t = call {<1 x i32>, <1 x i1>} @llvm.smul.with.overflow.v1i32(<1 x i32> %a0, <1 x i32> %a1)
  %val = extractvalue {<1 x i32>, <1 x i1>} %t, 0
  %obit = extractvalue {<1 x i32>, <1 x i1>} %t, 1
  %res = sext <1 x i1> %obit to <1 x i32>
  store <1 x i32> %val, <1 x i32>* %p2
  ret <1 x i32> %res
}

define <2 x i32> @smulo_v2i32(<2 x i32> %a0, <2 x i32> %a1, <2 x i32>* %p2) nounwind {
; SSE2-LABEL: smulo_v2i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm3
; SSE2-NEXT:    pand %xmm0, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm2
; SSE2-NEXT:    pand %xmm1, %xmm2
; SSE2-NEXT:    paddd %xmm3, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[1,3,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm3, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[1,3,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; SSE2-NEXT:    psubd %xmm2, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    movq %xmm0, (%rdi)
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE2-NEXT:    pxor %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: smulo_v2i32:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    pxor %xmm2, %xmm2
; SSSE3-NEXT:    pxor %xmm3, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm3
; SSSE3-NEXT:    pand %xmm0, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm0, %xmm2
; SSSE3-NEXT:    pand %xmm1, %xmm2
; SSSE3-NEXT:    paddd %xmm3, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[1,1,3,3]
; SSSE3-NEXT:    pmuludq %xmm1, %xmm0
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[1,3,2,3]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSSE3-NEXT:    pmuludq %xmm3, %xmm1
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[1,3,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; SSSE3-NEXT:    psubd %xmm2, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSSE3-NEXT:    movq %xmm0, (%rdi)
; SSSE3-NEXT:    movdqa %xmm0, %xmm1
; SSSE3-NEXT:    psrad $31, %xmm1
; SSSE3-NEXT:    pcmpeqd %xmm4, %xmm1
; SSSE3-NEXT:    pcmpeqd %xmm0, %xmm0
; SSSE3-NEXT:    pxor %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: smulo_v2i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,1,3,3]
; SSE41-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[1,1,3,3]
; SSE41-NEXT:    pmuldq %xmm2, %xmm3
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    pmuldq %xmm1, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE41-NEXT:    pblendw {{.*#+}} xmm2 = xmm2[0,1],xmm3[2,3],xmm2[4,5],xmm3[6,7]
; SSE41-NEXT:    pmulld %xmm1, %xmm0
; SSE41-NEXT:    movq %xmm0, (%rdi)
; SSE41-NEXT:    psrad $31, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    pxor %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: smulo_v2i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm1[1,1,3,3]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[1,1,3,3]
; AVX1-NEXT:    vpmuldq %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpmuldq %xmm1, %xmm0, %xmm3
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm3[0,1],xmm2[2,3],xmm3[4,5],xmm2[6,7]
; AVX1-NEXT:    vpmulld %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vpsrad $31, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpeqd %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpxor %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vmovq %xmm1, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: smulo_v2i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpshufd {{.*#+}} xmm2 = xmm1[1,1,3,3]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[1,1,3,3]
; AVX2-NEXT:    vpmuldq %xmm2, %xmm3, %xmm2
; AVX2-NEXT:    vpmuldq %xmm1, %xmm0, %xmm3
; AVX2-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; AVX2-NEXT:    vpblendd {{.*#+}} xmm2 = xmm3[0],xmm2[1],xmm3[2],xmm2[3]
; AVX2-NEXT:    vpmulld %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vpsrad $31, %xmm1, %xmm0
; AVX2-NEXT:    vpcmpeqd %xmm0, %xmm2, %xmm0
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpxor %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vmovq %xmm1, (%rdi)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: smulo_v2i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmuldq %xmm1, %xmm0, %xmm2
; AVX512-NEXT:    vpshufd {{.*#+}} xmm3 = xmm1[1,1,3,3]
; AVX512-NEXT:    vpshufd {{.*#+}} xmm4 = xmm0[1,1,3,3]
; AVX512-NEXT:    vpmuldq %xmm3, %xmm4, %xmm3
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm4 = [1,5,3,7]
; AVX512-NEXT:    vpermi2d %xmm3, %xmm2, %xmm4
; AVX512-NEXT:    vpmulld %xmm1, %xmm0, %xmm1
; AVX512-NEXT:    vpsrad $31, %xmm1, %xmm0
; AVX512-NEXT:    vpcmpneqd %xmm0, %xmm4, %k1
; AVX512-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    vmovdqa32 %xmm0, %xmm0 {%k1} {z}
; AVX512-NEXT:    vmovq %xmm1, (%rdi)
; AVX512-NEXT:    retq
  %t = call {<2 x i32>, <2 x i1>} @llvm.smul.with.overflow.v2i32(<2 x i32> %a0, <2 x i32> %a1)
  %val = extractvalue {<2 x i32>, <2 x i1>} %t, 0
  %obit = extractvalue {<2 x i32>, <2 x i1>} %t, 1
  %res = sext <2 x i1> %obit to <2 x i32>
  store <2 x i32> %val, <2 x i32>* %p2
  ret <2 x i32> %res
}

define <3 x i32> @smulo_v3i32(<3 x i32> %a0, <3 x i32> %a1, <3 x i32>* %p2) nounwind {
; SSE2-LABEL: smulo_v3i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm3
; SSE2-NEXT:    pand %xmm0, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm2
; SSE2-NEXT:    pand %xmm1, %xmm2
; SSE2-NEXT:    paddd %xmm3, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[1,3,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm3, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[1,3,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; SSE2-NEXT:    psubd %xmm2, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; SSE2-NEXT:    movq %xmm2, (%rdi)
; SSE2-NEXT:    psrad $31, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    pxor %xmm2, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE2-NEXT:    movd %xmm0, 8(%rdi)
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: smulo_v3i32:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    pxor %xmm2, %xmm2
; SSSE3-NEXT:    pxor %xmm3, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm3
; SSSE3-NEXT:    pand %xmm0, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm0, %xmm2
; SSSE3-NEXT:    pand %xmm1, %xmm2
; SSSE3-NEXT:    paddd %xmm3, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[1,1,3,3]
; SSSE3-NEXT:    pmuludq %xmm1, %xmm0
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[1,3,2,3]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSSE3-NEXT:    pmuludq %xmm3, %xmm1
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[1,3,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; SSSE3-NEXT:    psubd %xmm2, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[0,2,2,3]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; SSSE3-NEXT:    movq %xmm2, (%rdi)
; SSSE3-NEXT:    psrad $31, %xmm2
; SSSE3-NEXT:    pcmpeqd %xmm4, %xmm2
; SSSE3-NEXT:    pcmpeqd %xmm1, %xmm1
; SSSE3-NEXT:    pxor %xmm2, %xmm1
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSSE3-NEXT:    movd %xmm0, 8(%rdi)
; SSSE3-NEXT:    movdqa %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: smulo_v3i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,1,3,3]
; SSE41-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[1,1,3,3]
; SSE41-NEXT:    pmuldq %xmm2, %xmm3
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    pmuldq %xmm1, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE41-NEXT:    pblendw {{.*#+}} xmm2 = xmm2[0,1],xmm3[2,3],xmm2[4,5],xmm3[6,7]
; SSE41-NEXT:    pmulld %xmm1, %xmm0
; SSE41-NEXT:    pextrd $2, %xmm0, 8(%rdi)
; SSE41-NEXT:    movq %xmm0, (%rdi)
; SSE41-NEXT:    psrad $31, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    pxor %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: smulo_v3i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm1[1,1,3,3]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[1,1,3,3]
; AVX1-NEXT:    vpmuldq %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpmuldq %xmm1, %xmm0, %xmm3
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm3[0,1],xmm2[2,3],xmm3[4,5],xmm2[6,7]
; AVX1-NEXT:    vpmulld %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vpsrad $31, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpeqd %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpxor %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpextrd $2, %xmm1, 8(%rdi)
; AVX1-NEXT:    vmovq %xmm1, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: smulo_v3i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpshufd {{.*#+}} xmm2 = xmm1[1,1,3,3]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[1,1,3,3]
; AVX2-NEXT:    vpmuldq %xmm2, %xmm3, %xmm2
; AVX2-NEXT:    vpmuldq %xmm1, %xmm0, %xmm3
; AVX2-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; AVX2-NEXT:    vpblendd {{.*#+}} xmm2 = xmm3[0],xmm2[1],xmm3[2],xmm2[3]
; AVX2-NEXT:    vpmulld %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vpsrad $31, %xmm1, %xmm0
; AVX2-NEXT:    vpcmpeqd %xmm0, %xmm2, %xmm0
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpxor %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpextrd $2, %xmm1, 8(%rdi)
; AVX2-NEXT:    vmovq %xmm1, (%rdi)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: smulo_v3i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmuldq %xmm1, %xmm0, %xmm2
; AVX512-NEXT:    vpshufd {{.*#+}} xmm3 = xmm1[1,1,3,3]
; AVX512-NEXT:    vpshufd {{.*#+}} xmm4 = xmm0[1,1,3,3]
; AVX512-NEXT:    vpmuldq %xmm3, %xmm4, %xmm3
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm4 = [1,5,3,7]
; AVX512-NEXT:    vpermi2d %xmm3, %xmm2, %xmm4
; AVX512-NEXT:    vpmulld %xmm1, %xmm0, %xmm1
; AVX512-NEXT:    vpsrad $31, %xmm1, %xmm0
; AVX512-NEXT:    vpcmpneqd %xmm0, %xmm4, %k1
; AVX512-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    vmovdqa32 %xmm0, %xmm0 {%k1} {z}
; AVX512-NEXT:    vpextrd $2, %xmm1, 8(%rdi)
; AVX512-NEXT:    vmovq %xmm1, (%rdi)
; AVX512-NEXT:    retq
  %t = call {<3 x i32>, <3 x i1>} @llvm.smul.with.overflow.v3i32(<3 x i32> %a0, <3 x i32> %a1)
  %val = extractvalue {<3 x i32>, <3 x i1>} %t, 0
  %obit = extractvalue {<3 x i32>, <3 x i1>} %t, 1
  %res = sext <3 x i1> %obit to <3 x i32>
  store <3 x i32> %val, <3 x i32>* %p2
  ret <3 x i32> %res
}

define <4 x i32> @smulo_v4i32(<4 x i32> %a0, <4 x i32> %a1, <4 x i32>* %p2) nounwind {
; SSE2-LABEL: smulo_v4i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm3
; SSE2-NEXT:    pand %xmm0, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm2
; SSE2-NEXT:    pand %xmm1, %xmm2
; SSE2-NEXT:    paddd %xmm3, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[1,3,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm3, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[1,3,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; SSE2-NEXT:    psubd %xmm2, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    movdqa %xmm0, (%rdi)
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE2-NEXT:    pxor %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: smulo_v4i32:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    pxor %xmm2, %xmm2
; SSSE3-NEXT:    pxor %xmm3, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm3
; SSSE3-NEXT:    pand %xmm0, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm0, %xmm2
; SSSE3-NEXT:    pand %xmm1, %xmm2
; SSSE3-NEXT:    paddd %xmm3, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[1,1,3,3]
; SSSE3-NEXT:    pmuludq %xmm1, %xmm0
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[1,3,2,3]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSSE3-NEXT:    pmuludq %xmm3, %xmm1
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[1,3,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; SSSE3-NEXT:    psubd %xmm2, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSSE3-NEXT:    movdqa %xmm0, (%rdi)
; SSSE3-NEXT:    movdqa %xmm0, %xmm1
; SSSE3-NEXT:    psrad $31, %xmm1
; SSSE3-NEXT:    pcmpeqd %xmm4, %xmm1
; SSSE3-NEXT:    pcmpeqd %xmm0, %xmm0
; SSSE3-NEXT:    pxor %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: smulo_v4i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,1,3,3]
; SSE41-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[1,1,3,3]
; SSE41-NEXT:    pmuldq %xmm2, %xmm3
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    pmuldq %xmm1, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE41-NEXT:    pblendw {{.*#+}} xmm2 = xmm2[0,1],xmm3[2,3],xmm2[4,5],xmm3[6,7]
; SSE41-NEXT:    pmulld %xmm1, %xmm0
; SSE41-NEXT:    movdqa %xmm0, (%rdi)
; SSE41-NEXT:    psrad $31, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    pxor %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: smulo_v4i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm1[1,1,3,3]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[1,1,3,3]
; AVX1-NEXT:    vpmuldq %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpmuldq %xmm1, %xmm0, %xmm3
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm3[0,1],xmm2[2,3],xmm3[4,5],xmm2[6,7]
; AVX1-NEXT:    vpmulld %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vpsrad $31, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpeqd %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpxor %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vmovdqa %xmm1, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: smulo_v4i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpshufd {{.*#+}} xmm2 = xmm1[1,1,3,3]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[1,1,3,3]
; AVX2-NEXT:    vpmuldq %xmm2, %xmm3, %xmm2
; AVX2-NEXT:    vpmuldq %xmm1, %xmm0, %xmm3
; AVX2-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; AVX2-NEXT:    vpblendd {{.*#+}} xmm2 = xmm3[0],xmm2[1],xmm3[2],xmm2[3]
; AVX2-NEXT:    vpmulld %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vpsrad $31, %xmm1, %xmm0
; AVX2-NEXT:    vpcmpeqd %xmm0, %xmm2, %xmm0
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpxor %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vmovdqa %xmm1, (%rdi)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: smulo_v4i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmuldq %xmm1, %xmm0, %xmm2
; AVX512-NEXT:    vpshufd {{.*#+}} xmm3 = xmm1[1,1,3,3]
; AVX512-NEXT:    vpshufd {{.*#+}} xmm4 = xmm0[1,1,3,3]
; AVX512-NEXT:    vpmuldq %xmm3, %xmm4, %xmm3
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm4 = [1,5,3,7]
; AVX512-NEXT:    vpermi2d %xmm3, %xmm2, %xmm4
; AVX512-NEXT:    vpmulld %xmm1, %xmm0, %xmm1
; AVX512-NEXT:    vpsrad $31, %xmm1, %xmm0
; AVX512-NEXT:    vpcmpneqd %xmm0, %xmm4, %k1
; AVX512-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    vmovdqa32 %xmm0, %xmm0 {%k1} {z}
; AVX512-NEXT:    vmovdqa %xmm1, (%rdi)
; AVX512-NEXT:    retq
  %t = call {<4 x i32>, <4 x i1>} @llvm.smul.with.overflow.v4i32(<4 x i32> %a0, <4 x i32> %a1)
  %val = extractvalue {<4 x i32>, <4 x i1>} %t, 0
  %obit = extractvalue {<4 x i32>, <4 x i1>} %t, 1
  %res = sext <4 x i1> %obit to <4 x i32>
  store <4 x i32> %val, <4 x i32>* %p2
  ret <4 x i32> %res
}

define <6 x i32> @smulo_v6i32(<6 x i32> %a0, <6 x i32> %a1, <6 x i32>* %p2) nounwind {
; SSE2-LABEL: smulo_v6i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movq %rdi, %rax
; SSE2-NEXT:    movd %r8d, %xmm8
; SSE2-NEXT:    movd %ecx, %xmm0
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm8[0],xmm0[1],xmm8[1]
; SSE2-NEXT:    movd %edx, %xmm3
; SSE2-NEXT:    movd %esi, %xmm6
; SSE2-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm3[0],xmm6[1],xmm3[1]
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm6 = xmm6[0],xmm0[0]
; SSE2-NEXT:    movd {{.*#+}} xmm10 = mem[0],zero,zero,zero
; SSE2-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm10[0],xmm0[1],xmm10[1]
; SSE2-NEXT:    movd {{.*#+}} xmm12 = mem[0],zero,zero,zero
; SSE2-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm12[0],xmm1[1],xmm12[1]
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE2-NEXT:    movd %r9d, %xmm13
; SSE2-NEXT:    movd {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE2-NEXT:    movdqa %xmm13, %xmm11
; SSE2-NEXT:    punpckldq {{.*#+}} xmm11 = xmm11[0],xmm2[0],xmm11[1],xmm2[1]
; SSE2-NEXT:    movd {{.*#+}} xmm9 = mem[0],zero,zero,zero
; SSE2-NEXT:    movd {{.*#+}} xmm7 = mem[0],zero,zero,zero
; SSE2-NEXT:    pmuludq %xmm7, %xmm13
; SSE2-NEXT:    punpckldq {{.*#+}} xmm7 = xmm7[0],xmm9[0],xmm7[1],xmm9[1]
; SSE2-NEXT:    movq {{[0-9]+}}(%rsp), %rcx
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm5
; SSE2-NEXT:    pand %xmm6, %xmm5
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpgtd %xmm6, %xmm0
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    paddd %xmm5, %xmm0
; SSE2-NEXT:    pmuludq %xmm6, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm1[1,3,2,3]
; SSE2-NEXT:    shufps {{.*#+}} xmm12 = xmm12[0,0],xmm10[0,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,0],xmm8[0,0]
; SSE2-NEXT:    pmuludq %xmm12, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm3[1,3,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm6[0],xmm5[1],xmm6[1]
; SSE2-NEXT:    psubd %xmm0, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    movdqa %xmm0, (%rcx)
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm5, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    pxor %xmm1, %xmm0
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm7, %xmm3
; SSE2-NEXT:    pand %xmm11, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm11, %xmm4
; SSE2-NEXT:    pand %xmm7, %xmm4
; SSE2-NEXT:    paddd %xmm3, %xmm4
; SSE2-NEXT:    pmuludq %xmm9, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[1,3,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm13[1,3,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm3[0],xmm5[1],xmm3[1]
; SSE2-NEXT:    psubd %xmm4, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm13[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; SSE2-NEXT:    movq %xmm3, 16(%rcx)
; SSE2-NEXT:    psrad $31, %xmm3
; SSE2-NEXT:    pcmpeqd %xmm5, %xmm3
; SSE2-NEXT:    pxor %xmm1, %xmm3
; SSE2-NEXT:    movq %xmm3, 16(%rdi)
; SSE2-NEXT:    movdqa %xmm0, (%rdi)
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: smulo_v6i32:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movq %rdi, %rax
; SSSE3-NEXT:    movd %r8d, %xmm8
; SSSE3-NEXT:    movd %ecx, %xmm0
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm8[0],xmm0[1],xmm8[1]
; SSSE3-NEXT:    movd %edx, %xmm3
; SSSE3-NEXT:    movd %esi, %xmm6
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm3[0],xmm6[1],xmm3[1]
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm6 = xmm6[0],xmm0[0]
; SSSE3-NEXT:    movd {{.*#+}} xmm10 = mem[0],zero,zero,zero
; SSSE3-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm10[0],xmm0[1],xmm10[1]
; SSSE3-NEXT:    movd {{.*#+}} xmm12 = mem[0],zero,zero,zero
; SSSE3-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm12[0],xmm1[1],xmm12[1]
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSSE3-NEXT:    movd %r9d, %xmm13
; SSSE3-NEXT:    movd {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSSE3-NEXT:    movdqa %xmm13, %xmm11
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm11 = xmm11[0],xmm2[0],xmm11[1],xmm2[1]
; SSSE3-NEXT:    movd {{.*#+}} xmm9 = mem[0],zero,zero,zero
; SSSE3-NEXT:    movd {{.*#+}} xmm7 = mem[0],zero,zero,zero
; SSSE3-NEXT:    pmuludq %xmm7, %xmm13
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm7 = xmm7[0],xmm9[0],xmm7[1],xmm9[1]
; SSSE3-NEXT:    movq {{[0-9]+}}(%rsp), %rcx
; SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSSE3-NEXT:    pxor %xmm5, %xmm5
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm5
; SSSE3-NEXT:    pand %xmm6, %xmm5
; SSSE3-NEXT:    pxor %xmm0, %xmm0
; SSSE3-NEXT:    pcmpgtd %xmm6, %xmm0
; SSSE3-NEXT:    pand %xmm1, %xmm0
; SSSE3-NEXT:    paddd %xmm5, %xmm0
; SSSE3-NEXT:    pmuludq %xmm6, %xmm1
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm1[1,3,2,3]
; SSSE3-NEXT:    shufps {{.*#+}} xmm12 = xmm12[0,0],xmm10[0,0]
; SSSE3-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,0],xmm8[0,0]
; SSSE3-NEXT:    pmuludq %xmm12, %xmm3
; SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm3[1,3,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm6[0],xmm5[1],xmm6[1]
; SSSE3-NEXT:    psubd %xmm0, %xmm5
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,2,2,3]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[0,2,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSSE3-NEXT:    movdqa %xmm0, (%rcx)
; SSSE3-NEXT:    psrad $31, %xmm0
; SSSE3-NEXT:    pcmpeqd %xmm5, %xmm0
; SSSE3-NEXT:    pcmpeqd %xmm1, %xmm1
; SSSE3-NEXT:    pxor %xmm1, %xmm0
; SSSE3-NEXT:    pxor %xmm3, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm7, %xmm3
; SSSE3-NEXT:    pand %xmm11, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm11, %xmm4
; SSSE3-NEXT:    pand %xmm7, %xmm4
; SSSE3-NEXT:    paddd %xmm3, %xmm4
; SSSE3-NEXT:    pmuludq %xmm9, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[1,3,2,3]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm13[1,3,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm3[0],xmm5[1],xmm3[1]
; SSSE3-NEXT:    psubd %xmm4, %xmm5
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm13[0,2,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; SSSE3-NEXT:    movq %xmm3, 16(%rcx)
; SSSE3-NEXT:    psrad $31, %xmm3
; SSSE3-NEXT:    pcmpeqd %xmm5, %xmm3
; SSSE3-NEXT:    pxor %xmm1, %xmm3
; SSSE3-NEXT:    movq %xmm3, 16(%rdi)
; SSSE3-NEXT:    movdqa %xmm0, (%rdi)
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: smulo_v6i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movq %rdi, %rax
; SSE41-NEXT:    movd %esi, %xmm2
; SSE41-NEXT:    pinsrd $1, %edx, %xmm2
; SSE41-NEXT:    pinsrd $2, %ecx, %xmm2
; SSE41-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE41-NEXT:    pinsrd $1, {{[0-9]+}}(%rsp), %xmm1
; SSE41-NEXT:    pinsrd $2, {{[0-9]+}}(%rsp), %xmm1
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    pmuldq %xmm2, %xmm1
; SSE41-NEXT:    pinsrd $3, %r8d, %xmm2
; SSE41-NEXT:    movd {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE41-NEXT:    movd %r9d, %xmm4
; SSE41-NEXT:    movdqa %xmm4, %xmm5
; SSE41-NEXT:    pmuldq %xmm3, %xmm4
; SSE41-NEXT:    pinsrd $1, {{[0-9]+}}(%rsp), %xmm3
; SSE41-NEXT:    pinsrd $1, {{[0-9]+}}(%rsp), %xmm5
; SSE41-NEXT:    pmulld %xmm3, %xmm5
; SSE41-NEXT:    pinsrd $3, {{[0-9]+}}(%rsp), %xmm0
; SSE41-NEXT:    movq {{[0-9]+}}(%rsp), %rcx
; SSE41-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[1,1,3,3]
; SSE41-NEXT:    pshufd {{.*#+}} xmm6 = xmm0[1,1,3,3]
; SSE41-NEXT:    pmuldq %xmm3, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE41-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0,1],xmm6[2,3],xmm1[4,5],xmm6[6,7]
; SSE41-NEXT:    pmulld %xmm2, %xmm0
; SSE41-NEXT:    movdqa %xmm0, (%rcx)
; SSE41-NEXT:    psrad $31, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    pxor %xmm1, %xmm0
; SSE41-NEXT:    movd {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE41-NEXT:    movd {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE41-NEXT:    pmuldq %xmm2, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm2 = xmm4[1,1,3,3]
; SSE41-NEXT:    pblendw {{.*#+}} xmm2 = xmm2[0,1],xmm3[2,3],xmm2[4,5],xmm3[6,7]
; SSE41-NEXT:    movq %xmm5, 16(%rcx)
; SSE41-NEXT:    psrad $31, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm5
; SSE41-NEXT:    pxor %xmm1, %xmm5
; SSE41-NEXT:    movq %xmm5, 16(%rdi)
; SSE41-NEXT:    movdqa %xmm0, (%rdi)
; SSE41-NEXT:    retq
;
; AVX1-LABEL: smulo_v6i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm2[1,1,3,3]
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm4[1,1,3,3]
; AVX1-NEXT:    vpmuldq %xmm3, %xmm5, %xmm3
; AVX1-NEXT:    vpmuldq %xmm2, %xmm4, %xmm5
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm3 = xmm5[0,1],xmm3[2,3],xmm5[4,5],xmm3[6,7]
; AVX1-NEXT:    vpmulld %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsrad $31, %xmm2, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpxor %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm1[1,1,3,3]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm6 = xmm0[1,1,3,3]
; AVX1-NEXT:    vpmuldq %xmm5, %xmm6, %xmm5
; AVX1-NEXT:    vpmuldq %xmm1, %xmm0, %xmm6
; AVX1-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm5 = xmm6[0,1],xmm5[2,3],xmm6[4,5],xmm5[6,7]
; AVX1-NEXT:    vpmulld %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vpsrad $31, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpeqd %xmm0, %xmm5, %xmm0
; AVX1-NEXT:    vpxor %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX1-NEXT:    vmovq %xmm2, 16(%rdi)
; AVX1-NEXT:    vmovdqa %xmm1, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: smulo_v6i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpshufd {{.*#+}} ymm2 = ymm1[1,1,3,3,5,5,7,7]
; AVX2-NEXT:    vpshufd {{.*#+}} ymm3 = ymm0[1,1,3,3,5,5,7,7]
; AVX2-NEXT:    vpmuldq %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpmuldq %ymm1, %ymm0, %ymm3
; AVX2-NEXT:    vpshufd {{.*#+}} ymm3 = ymm3[1,1,3,3,5,5,7,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm2 = ymm3[0],ymm2[1],ymm3[2],ymm2[3],ymm3[4],ymm2[5],ymm3[6],ymm2[7]
; AVX2-NEXT:    vpmulld %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpsrad $31, %ymm1, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX2-NEXT:    vpxor %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX2-NEXT:    vmovq %xmm2, 16(%rdi)
; AVX2-NEXT:    vmovdqa %xmm1, (%rdi)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: smulo_v6i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmuldq %ymm1, %ymm0, %ymm2
; AVX512-NEXT:    vpshufd {{.*#+}} ymm3 = ymm1[1,1,3,3,5,5,7,7]
; AVX512-NEXT:    vpshufd {{.*#+}} ymm4 = ymm0[1,1,3,3,5,5,7,7]
; AVX512-NEXT:    vpmuldq %ymm3, %ymm4, %ymm3
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm4 = [1,9,3,11,5,13,7,15]
; AVX512-NEXT:    vpermi2d %ymm3, %ymm2, %ymm4
; AVX512-NEXT:    vpmulld %ymm1, %ymm0, %ymm1
; AVX512-NEXT:    vpsrad $31, %ymm1, %ymm0
; AVX512-NEXT:    vpcmpneqd %ymm0, %ymm4, %k1
; AVX512-NEXT:    vpcmpeqd %ymm0, %ymm0, %ymm0
; AVX512-NEXT:    vmovdqa32 %ymm0, %ymm0 {%k1} {z}
; AVX512-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX512-NEXT:    vmovq %xmm2, 16(%rdi)
; AVX512-NEXT:    vmovdqa %xmm1, (%rdi)
; AVX512-NEXT:    retq
  %t = call {<6 x i32>, <6 x i1>} @llvm.smul.with.overflow.v6i32(<6 x i32> %a0, <6 x i32> %a1)
  %val = extractvalue {<6 x i32>, <6 x i1>} %t, 0
  %obit = extractvalue {<6 x i32>, <6 x i1>} %t, 1
  %res = sext <6 x i1> %obit to <6 x i32>
  store <6 x i32> %val, <6 x i32>* %p2
  ret <6 x i32> %res
}

define <8 x i32> @smulo_v8i32(<8 x i32> %a0, <8 x i32> %a1, <8 x i32>* %p2) nounwind {
; SSE2-LABEL: smulo_v8i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm5
; SSE2-NEXT:    pand %xmm0, %xmm5
; SSE2-NEXT:    pxor %xmm6, %xmm6
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm6
; SSE2-NEXT:    pand %xmm2, %xmm6
; SSE2-NEXT:    paddd %xmm5, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm0[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm2, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[1,3,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm7, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm2[1,3,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm7[0],xmm5[1],xmm7[1]
; SSE2-NEXT:    psubd %xmm6, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE2-NEXT:    movdqa %xmm0, (%rdi)
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm5, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm2, %xmm0
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm3, %xmm5
; SSE2-NEXT:    pand %xmm1, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm4
; SSE2-NEXT:    pand %xmm3, %xmm4
; SSE2-NEXT:    paddd %xmm5, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm1[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm3, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm1[1,3,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm5, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm3[1,3,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm5[0],xmm6[1],xmm5[1]
; SSE2-NEXT:    psubd %xmm4, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm3[0],xmm1[1],xmm3[1]
; SSE2-NEXT:    movdqa %xmm1, 16(%rdi)
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm6, %xmm1
; SSE2-NEXT:    pxor %xmm2, %xmm1
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: smulo_v8i32:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSSE3-NEXT:    pxor %xmm5, %xmm5
; SSSE3-NEXT:    pcmpgtd %xmm2, %xmm5
; SSSE3-NEXT:    pand %xmm0, %xmm5
; SSSE3-NEXT:    pxor %xmm6, %xmm6
; SSSE3-NEXT:    pcmpgtd %xmm0, %xmm6
; SSSE3-NEXT:    pand %xmm2, %xmm6
; SSSE3-NEXT:    paddd %xmm5, %xmm6
; SSSE3-NEXT:    pshufd {{.*#+}} xmm7 = xmm0[1,1,3,3]
; SSSE3-NEXT:    pmuludq %xmm2, %xmm0
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[1,3,2,3]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSSE3-NEXT:    pmuludq %xmm7, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm7 = xmm2[1,3,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm7[0],xmm5[1],xmm7[1]
; SSSE3-NEXT:    psubd %xmm6, %xmm5
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSSE3-NEXT:    movdqa %xmm0, (%rdi)
; SSSE3-NEXT:    psrad $31, %xmm0
; SSSE3-NEXT:    pcmpeqd %xmm5, %xmm0
; SSSE3-NEXT:    pcmpeqd %xmm2, %xmm2
; SSSE3-NEXT:    pxor %xmm2, %xmm0
; SSSE3-NEXT:    pxor %xmm5, %xmm5
; SSSE3-NEXT:    pcmpgtd %xmm3, %xmm5
; SSSE3-NEXT:    pand %xmm1, %xmm5
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm4
; SSSE3-NEXT:    pand %xmm3, %xmm4
; SSSE3-NEXT:    paddd %xmm5, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm1[1,1,3,3]
; SSSE3-NEXT:    pmuludq %xmm3, %xmm1
; SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm1[1,3,2,3]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSSE3-NEXT:    pmuludq %xmm5, %xmm3
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm3[1,3,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm5[0],xmm6[1],xmm5[1]
; SSSE3-NEXT:    psubd %xmm4, %xmm6
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,2,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm3[0],xmm1[1],xmm3[1]
; SSSE3-NEXT:    movdqa %xmm1, 16(%rdi)
; SSSE3-NEXT:    psrad $31, %xmm1
; SSSE3-NEXT:    pcmpeqd %xmm6, %xmm1
; SSSE3-NEXT:    pxor %xmm2, %xmm1
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: smulo_v8i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[1,1,3,3]
; SSE41-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[1,1,3,3]
; SSE41-NEXT:    pmuldq %xmm4, %xmm5
; SSE41-NEXT:    movdqa %xmm0, %xmm4
; SSE41-NEXT:    pmuldq %xmm2, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE41-NEXT:    pblendw {{.*#+}} xmm4 = xmm4[0,1],xmm5[2,3],xmm4[4,5],xmm5[6,7]
; SSE41-NEXT:    pmulld %xmm2, %xmm0
; SSE41-NEXT:    movdqa %xmm0, (%rdi)
; SSE41-NEXT:    psrad $31, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm4, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE41-NEXT:    pxor %xmm2, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm4 = xmm3[1,1,3,3]
; SSE41-NEXT:    pshufd {{.*#+}} xmm5 = xmm1[1,1,3,3]
; SSE41-NEXT:    pmuldq %xmm4, %xmm5
; SSE41-NEXT:    movdqa %xmm1, %xmm4
; SSE41-NEXT:    pmuldq %xmm3, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE41-NEXT:    pblendw {{.*#+}} xmm4 = xmm4[0,1],xmm5[2,3],xmm4[4,5],xmm5[6,7]
; SSE41-NEXT:    pmulld %xmm3, %xmm1
; SSE41-NEXT:    movdqa %xmm1, 16(%rdi)
; SSE41-NEXT:    psrad $31, %xmm1
; SSE41-NEXT:    pcmpeqd %xmm4, %xmm1
; SSE41-NEXT:    pxor %xmm2, %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: smulo_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm2[1,1,3,3]
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm4[1,1,3,3]
; AVX1-NEXT:    vpmuldq %xmm3, %xmm5, %xmm3
; AVX1-NEXT:    vpmuldq %xmm2, %xmm4, %xmm5
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm3 = xmm5[0,1],xmm3[2,3],xmm5[4,5],xmm3[6,7]
; AVX1-NEXT:    vpmulld %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsrad $31, %xmm2, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpxor %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm1[1,1,3,3]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm6 = xmm0[1,1,3,3]
; AVX1-NEXT:    vpmuldq %xmm5, %xmm6, %xmm5
; AVX1-NEXT:    vpmuldq %xmm1, %xmm0, %xmm6
; AVX1-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm5 = xmm6[0,1],xmm5[2,3],xmm6[4,5],xmm5[6,7]
; AVX1-NEXT:    vpmulld %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vpsrad $31, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpeqd %xmm0, %xmm5, %xmm0
; AVX1-NEXT:    vpxor %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX1-NEXT:    vmovdqa %xmm2, 16(%rdi)
; AVX1-NEXT:    vmovdqa %xmm1, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: smulo_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpshufd {{.*#+}} ymm2 = ymm1[1,1,3,3,5,5,7,7]
; AVX2-NEXT:    vpshufd {{.*#+}} ymm3 = ymm0[1,1,3,3,5,5,7,7]
; AVX2-NEXT:    vpmuldq %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpmuldq %ymm1, %ymm0, %ymm3
; AVX2-NEXT:    vpshufd {{.*#+}} ymm3 = ymm3[1,1,3,3,5,5,7,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm2 = ymm3[0],ymm2[1],ymm3[2],ymm2[3],ymm3[4],ymm2[5],ymm3[6],ymm2[7]
; AVX2-NEXT:    vpmulld %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpsrad $31, %ymm1, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX2-NEXT:    vpxor %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vmovdqa %ymm1, (%rdi)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: smulo_v8i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmuldq %ymm1, %ymm0, %ymm2
; AVX512-NEXT:    vpshufd {{.*#+}} ymm3 = ymm1[1,1,3,3,5,5,7,7]
; AVX512-NEXT:    vpshufd {{.*#+}} ymm4 = ymm0[1,1,3,3,5,5,7,7]
; AVX512-NEXT:    vpmuldq %ymm3, %ymm4, %ymm3
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm4 = [1,9,3,11,5,13,7,15]
; AVX512-NEXT:    vpermi2d %ymm3, %ymm2, %ymm4
; AVX512-NEXT:    vpmulld %ymm1, %ymm0, %ymm1
; AVX512-NEXT:    vpsrad $31, %ymm1, %ymm0
; AVX512-NEXT:    vpcmpneqd %ymm0, %ymm4, %k1
; AVX512-NEXT:    vpcmpeqd %ymm0, %ymm0, %ymm0
; AVX512-NEXT:    vmovdqa32 %ymm0, %ymm0 {%k1} {z}
; AVX512-NEXT:    vmovdqa %ymm1, (%rdi)
; AVX512-NEXT:    retq
  %t = call {<8 x i32>, <8 x i1>} @llvm.smul.with.overflow.v8i32(<8 x i32> %a0, <8 x i32> %a1)
  %val = extractvalue {<8 x i32>, <8 x i1>} %t, 0
  %obit = extractvalue {<8 x i32>, <8 x i1>} %t, 1
  %res = sext <8 x i1> %obit to <8 x i32>
  store <8 x i32> %val, <8 x i32>* %p2
  ret <8 x i32> %res
}

define <16 x i32> @smulo_v16i32(<16 x i32> %a0, <16 x i32> %a1, <16 x i32>* %p2) nounwind {
; SSE2-LABEL: smulo_v16i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm8, %xmm8
; SSE2-NEXT:    pxor %xmm9, %xmm9
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm9
; SSE2-NEXT:    pand %xmm0, %xmm9
; SSE2-NEXT:    pxor %xmm10, %xmm10
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm10
; SSE2-NEXT:    pand %xmm4, %xmm10
; SSE2-NEXT:    paddd %xmm9, %xmm10
; SSE2-NEXT:    pshufd {{.*#+}} xmm11 = xmm0[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm4, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm9 = xmm0[1,3,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm12 = xmm4[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm11, %xmm12
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm12[1,3,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm9 = xmm9[0],xmm4[0],xmm9[1],xmm4[1]
; SSE2-NEXT:    psubd %xmm10, %xmm9
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm12[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1]
; SSE2-NEXT:    movdqa %xmm0, (%rdi)
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm9
; SSE2-NEXT:    pxor %xmm9, %xmm0
; SSE2-NEXT:    pxor %xmm10, %xmm10
; SSE2-NEXT:    pcmpgtd %xmm5, %xmm10
; SSE2-NEXT:    pand %xmm1, %xmm10
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm4
; SSE2-NEXT:    pand %xmm5, %xmm4
; SSE2-NEXT:    paddd %xmm10, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm10 = xmm1[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm5, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm11 = xmm1[1,3,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm12 = xmm5[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm10, %xmm12
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm12[1,3,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm11 = xmm11[0],xmm5[0],xmm11[1],xmm5[1]
; SSE2-NEXT:    psubd %xmm4, %xmm11
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm12[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm4[0],xmm1[1],xmm4[1]
; SSE2-NEXT:    movdqa %xmm1, 16(%rdi)
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm11, %xmm1
; SSE2-NEXT:    pxor %xmm9, %xmm1
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm6, %xmm4
; SSE2-NEXT:    pand %xmm2, %xmm4
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm5
; SSE2-NEXT:    pand %xmm6, %xmm5
; SSE2-NEXT:    paddd %xmm4, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm10 = xmm2[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm6, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[1,3,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm11 = xmm6[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm10, %xmm11
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm11[1,3,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm6[0],xmm4[1],xmm6[1]
; SSE2-NEXT:    psubd %xmm5, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm11[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm5[0],xmm2[1],xmm5[1]
; SSE2-NEXT:    movdqa %xmm2, 32(%rdi)
; SSE2-NEXT:    psrad $31, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm2
; SSE2-NEXT:    pxor %xmm9, %xmm2
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm7, %xmm4
; SSE2-NEXT:    pand %xmm3, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm3, %xmm8
; SSE2-NEXT:    pand %xmm7, %xmm8
; SSE2-NEXT:    paddd %xmm4, %xmm8
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm3[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm7, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm3[1,3,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm7[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm4, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm6[1,3,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; SSE2-NEXT:    psubd %xmm8, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm6[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; SSE2-NEXT:    movdqa %xmm3, 48(%rdi)
; SSE2-NEXT:    psrad $31, %xmm3
; SSE2-NEXT:    pcmpeqd %xmm5, %xmm3
; SSE2-NEXT:    pxor %xmm9, %xmm3
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: smulo_v16i32:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    pxor %xmm8, %xmm8
; SSSE3-NEXT:    pxor %xmm9, %xmm9
; SSSE3-NEXT:    pcmpgtd %xmm4, %xmm9
; SSSE3-NEXT:    pand %xmm0, %xmm9
; SSSE3-NEXT:    pxor %xmm10, %xmm10
; SSSE3-NEXT:    pcmpgtd %xmm0, %xmm10
; SSSE3-NEXT:    pand %xmm4, %xmm10
; SSSE3-NEXT:    paddd %xmm9, %xmm10
; SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm0[1,1,3,3]
; SSSE3-NEXT:    pmuludq %xmm4, %xmm0
; SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm0[1,3,2,3]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm12 = xmm4[1,1,3,3]
; SSSE3-NEXT:    pmuludq %xmm11, %xmm12
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm12[1,3,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm9 = xmm9[0],xmm4[0],xmm9[1],xmm4[1]
; SSSE3-NEXT:    psubd %xmm10, %xmm9
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm12[0,2,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1]
; SSSE3-NEXT:    movdqa %xmm0, (%rdi)
; SSSE3-NEXT:    psrad $31, %xmm0
; SSSE3-NEXT:    pcmpeqd %xmm9, %xmm0
; SSSE3-NEXT:    pcmpeqd %xmm9, %xmm9
; SSSE3-NEXT:    pxor %xmm9, %xmm0
; SSSE3-NEXT:    pxor %xmm10, %xmm10
; SSSE3-NEXT:    pcmpgtd %xmm5, %xmm10
; SSSE3-NEXT:    pand %xmm1, %xmm10
; SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm4
; SSSE3-NEXT:    pand %xmm5, %xmm4
; SSSE3-NEXT:    paddd %xmm10, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm10 = xmm1[1,1,3,3]
; SSSE3-NEXT:    pmuludq %xmm5, %xmm1
; SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm1[1,3,2,3]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm12 = xmm5[1,1,3,3]
; SSSE3-NEXT:    pmuludq %xmm10, %xmm12
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm12[1,3,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm11 = xmm11[0],xmm5[0],xmm11[1],xmm5[1]
; SSSE3-NEXT:    psubd %xmm4, %xmm11
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm12[0,2,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm4[0],xmm1[1],xmm4[1]
; SSSE3-NEXT:    movdqa %xmm1, 16(%rdi)
; SSSE3-NEXT:    psrad $31, %xmm1
; SSSE3-NEXT:    pcmpeqd %xmm11, %xmm1
; SSSE3-NEXT:    pxor %xmm9, %xmm1
; SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm6, %xmm4
; SSSE3-NEXT:    pand %xmm2, %xmm4
; SSSE3-NEXT:    pxor %xmm5, %xmm5
; SSSE3-NEXT:    pcmpgtd %xmm2, %xmm5
; SSSE3-NEXT:    pand %xmm6, %xmm5
; SSSE3-NEXT:    paddd %xmm4, %xmm5
; SSSE3-NEXT:    pshufd {{.*#+}} xmm10 = xmm2[1,1,3,3]
; SSSE3-NEXT:    pmuludq %xmm6, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[1,3,2,3]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm6[1,1,3,3]
; SSSE3-NEXT:    pmuludq %xmm10, %xmm11
; SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm11[1,3,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm6[0],xmm4[1],xmm6[1]
; SSSE3-NEXT:    psubd %xmm5, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm11[0,2,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm5[0],xmm2[1],xmm5[1]
; SSSE3-NEXT:    movdqa %xmm2, 32(%rdi)
; SSSE3-NEXT:    psrad $31, %xmm2
; SSSE3-NEXT:    pcmpeqd %xmm4, %xmm2
; SSSE3-NEXT:    pxor %xmm9, %xmm2
; SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm7, %xmm4
; SSSE3-NEXT:    pand %xmm3, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm3, %xmm8
; SSSE3-NEXT:    pand %xmm7, %xmm8
; SSSE3-NEXT:    paddd %xmm4, %xmm8
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm3[1,1,3,3]
; SSSE3-NEXT:    pmuludq %xmm7, %xmm3
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm3[1,3,2,3]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm7[1,1,3,3]
; SSSE3-NEXT:    pmuludq %xmm4, %xmm6
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm6[1,3,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; SSSE3-NEXT:    psubd %xmm8, %xmm5
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,2,2,3]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm6[0,2,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; SSSE3-NEXT:    movdqa %xmm3, 48(%rdi)
; SSSE3-NEXT:    psrad $31, %xmm3
; SSSE3-NEXT:    pcmpeqd %xmm5, %xmm3
; SSSE3-NEXT:    pxor %xmm9, %xmm3
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: smulo_v16i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pshufd {{.*#+}} xmm8 = xmm4[1,1,3,3]
; SSE41-NEXT:    pshufd {{.*#+}} xmm9 = xmm0[1,1,3,3]
; SSE41-NEXT:    pmuldq %xmm8, %xmm9
; SSE41-NEXT:    movdqa %xmm0, %xmm8
; SSE41-NEXT:    pmuldq %xmm4, %xmm8
; SSE41-NEXT:    pshufd {{.*#+}} xmm8 = xmm8[1,1,3,3]
; SSE41-NEXT:    pblendw {{.*#+}} xmm8 = xmm8[0,1],xmm9[2,3],xmm8[4,5],xmm9[6,7]
; SSE41-NEXT:    pmulld %xmm4, %xmm0
; SSE41-NEXT:    movdqa %xmm0, (%rdi)
; SSE41-NEXT:    psrad $31, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm8, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm8, %xmm8
; SSE41-NEXT:    pxor %xmm8, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm9 = xmm5[1,1,3,3]
; SSE41-NEXT:    pshufd {{.*#+}} xmm10 = xmm1[1,1,3,3]
; SSE41-NEXT:    pmuldq %xmm9, %xmm10
; SSE41-NEXT:    movdqa %xmm1, %xmm4
; SSE41-NEXT:    pmuldq %xmm5, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE41-NEXT:    pblendw {{.*#+}} xmm4 = xmm4[0,1],xmm10[2,3],xmm4[4,5],xmm10[6,7]
; SSE41-NEXT:    pmulld %xmm5, %xmm1
; SSE41-NEXT:    movdqa %xmm1, 16(%rdi)
; SSE41-NEXT:    psrad $31, %xmm1
; SSE41-NEXT:    pcmpeqd %xmm4, %xmm1
; SSE41-NEXT:    pxor %xmm8, %xmm1
; SSE41-NEXT:    pshufd {{.*#+}} xmm4 = xmm6[1,1,3,3]
; SSE41-NEXT:    pshufd {{.*#+}} xmm5 = xmm2[1,1,3,3]
; SSE41-NEXT:    pmuldq %xmm4, %xmm5
; SSE41-NEXT:    movdqa %xmm2, %xmm4
; SSE41-NEXT:    pmuldq %xmm6, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE41-NEXT:    pblendw {{.*#+}} xmm4 = xmm4[0,1],xmm5[2,3],xmm4[4,5],xmm5[6,7]
; SSE41-NEXT:    pmulld %xmm6, %xmm2
; SSE41-NEXT:    movdqa %xmm2, 32(%rdi)
; SSE41-NEXT:    psrad $31, %xmm2
; SSE41-NEXT:    pcmpeqd %xmm4, %xmm2
; SSE41-NEXT:    pxor %xmm8, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm4 = xmm7[1,1,3,3]
; SSE41-NEXT:    pshufd {{.*#+}} xmm5 = xmm3[1,1,3,3]
; SSE41-NEXT:    pmuldq %xmm4, %xmm5
; SSE41-NEXT:    movdqa %xmm3, %xmm4
; SSE41-NEXT:    pmuldq %xmm7, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE41-NEXT:    pblendw {{.*#+}} xmm4 = xmm4[0,1],xmm5[2,3],xmm4[4,5],xmm5[6,7]
; SSE41-NEXT:    pmulld %xmm7, %xmm3
; SSE41-NEXT:    movdqa %xmm3, 48(%rdi)
; SSE41-NEXT:    psrad $31, %xmm3
; SSE41-NEXT:    pcmpeqd %xmm4, %xmm3
; SSE41-NEXT:    pxor %xmm8, %xmm3
; SSE41-NEXT:    retq
;
; AVX1-LABEL: smulo_v16i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm4[1,1,3,3]
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm6
; AVX1-NEXT:    vpshufd {{.*#+}} xmm7 = xmm6[1,1,3,3]
; AVX1-NEXT:    vpmuldq %xmm5, %xmm7, %xmm5
; AVX1-NEXT:    vpmuldq %xmm4, %xmm6, %xmm7
; AVX1-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[1,1,3,3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm5 = xmm7[0,1],xmm5[2,3],xmm7[4,5],xmm5[6,7]
; AVX1-NEXT:    vpmulld %xmm4, %xmm6, %xmm8
; AVX1-NEXT:    vpsrad $31, %xmm8, %xmm6
; AVX1-NEXT:    vpcmpeqd %xmm6, %xmm5, %xmm6
; AVX1-NEXT:    vpcmpeqd %xmm9, %xmm9, %xmm9
; AVX1-NEXT:    vpxor %xmm6, %xmm9, %xmm6
; AVX1-NEXT:    vpshufd {{.*#+}} xmm7 = xmm3[1,1,3,3]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm4 = xmm1[1,1,3,3]
; AVX1-NEXT:    vpmuldq %xmm7, %xmm4, %xmm4
; AVX1-NEXT:    vpmuldq %xmm3, %xmm1, %xmm7
; AVX1-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[1,1,3,3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm4 = xmm7[0,1],xmm4[2,3],xmm7[4,5],xmm4[6,7]
; AVX1-NEXT:    vpmulld %xmm3, %xmm1, %xmm3
; AVX1-NEXT:    vpsrad $31, %xmm3, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpxor %xmm1, %xmm9, %xmm1
; AVX1-NEXT:    vpackssdw %xmm6, %xmm1, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm6 = xmm4[1,1,3,3]
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm7
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm7[1,1,3,3]
; AVX1-NEXT:    vpmuldq %xmm6, %xmm5, %xmm5
; AVX1-NEXT:    vpmuldq %xmm4, %xmm7, %xmm6
; AVX1-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm5 = xmm6[0,1],xmm5[2,3],xmm6[4,5],xmm5[6,7]
; AVX1-NEXT:    vpmulld %xmm4, %xmm7, %xmm4
; AVX1-NEXT:    vpsrad $31, %xmm4, %xmm6
; AVX1-NEXT:    vpcmpeqd %xmm6, %xmm5, %xmm5
; AVX1-NEXT:    vpxor %xmm5, %xmm9, %xmm5
; AVX1-NEXT:    vpshufd {{.*#+}} xmm6 = xmm2[1,1,3,3]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm7 = xmm0[1,1,3,3]
; AVX1-NEXT:    vpmuldq %xmm6, %xmm7, %xmm6
; AVX1-NEXT:    vpmuldq %xmm2, %xmm0, %xmm7
; AVX1-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[1,1,3,3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm6 = xmm7[0,1],xmm6[2,3],xmm7[4,5],xmm6[6,7]
; AVX1-NEXT:    vpmulld %xmm2, %xmm0, %xmm2
; AVX1-NEXT:    vpsrad $31, %xmm2, %xmm0
; AVX1-NEXT:    vpcmpeqd %xmm0, %xmm6, %xmm0
; AVX1-NEXT:    vpxor %xmm0, %xmm9, %xmm0
; AVX1-NEXT:    vpackssdw %xmm5, %xmm0, %xmm5
; AVX1-NEXT:    vpacksswb %xmm1, %xmm5, %xmm0
; AVX1-NEXT:    vpmovsxbd %xmm0, %xmm6
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,2,3]
; AVX1-NEXT:    vpmovsxbd %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm6, %ymm0
; AVX1-NEXT:    vpacksswb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpmovsxbd %xmm1, %xmm5
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[1,1,2,3]
; AVX1-NEXT:    vpmovsxbd %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm5, %ymm1
; AVX1-NEXT:    vmovdqa %xmm8, 48(%rdi)
; AVX1-NEXT:    vmovdqa %xmm3, 32(%rdi)
; AVX1-NEXT:    vmovdqa %xmm4, 16(%rdi)
; AVX1-NEXT:    vmovdqa %xmm2, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: smulo_v16i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpshufd {{.*#+}} ymm4 = ymm3[1,1,3,3,5,5,7,7]
; AVX2-NEXT:    vpshufd {{.*#+}} ymm5 = ymm1[1,1,3,3,5,5,7,7]
; AVX2-NEXT:    vpmuldq %ymm4, %ymm5, %ymm4
; AVX2-NEXT:    vpmuldq %ymm3, %ymm1, %ymm5
; AVX2-NEXT:    vpshufd {{.*#+}} ymm5 = ymm5[1,1,3,3,5,5,7,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm4 = ymm5[0],ymm4[1],ymm5[2],ymm4[3],ymm5[4],ymm4[5],ymm5[6],ymm4[7]
; AVX2-NEXT:    vpmulld %ymm3, %ymm1, %ymm3
; AVX2-NEXT:    vpsrad $31, %ymm3, %ymm1
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm4, %ymm1
; AVX2-NEXT:    vpcmpeqd %ymm4, %ymm4, %ymm4
; AVX2-NEXT:    vpxor %ymm4, %ymm1, %ymm1
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm5
; AVX2-NEXT:    vpackssdw %xmm5, %xmm1, %xmm1
; AVX2-NEXT:    vpshufd {{.*#+}} ymm5 = ymm2[1,1,3,3,5,5,7,7]
; AVX2-NEXT:    vpshufd {{.*#+}} ymm6 = ymm0[1,1,3,3,5,5,7,7]
; AVX2-NEXT:    vpmuldq %ymm5, %ymm6, %ymm5
; AVX2-NEXT:    vpmuldq %ymm2, %ymm0, %ymm6
; AVX2-NEXT:    vpshufd {{.*#+}} ymm6 = ymm6[1,1,3,3,5,5,7,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm5 = ymm6[0],ymm5[1],ymm6[2],ymm5[3],ymm6[4],ymm5[5],ymm6[6],ymm5[7]
; AVX2-NEXT:    vpmulld %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vpsrad $31, %ymm2, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm0, %ymm5, %ymm0
; AVX2-NEXT:    vpxor %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm4
; AVX2-NEXT:    vpackssdw %xmm4, %xmm0, %xmm0
; AVX2-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpmovsxbd %xmm0, %ymm0
; AVX2-NEXT:    vpacksswb %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpmovsxbd %xmm1, %ymm1
; AVX2-NEXT:    vmovdqa %ymm3, 32(%rdi)
; AVX2-NEXT:    vmovdqa %ymm2, (%rdi)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: smulo_v16i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmuldq %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vpshufd {{.*#+}} zmm3 = zmm1[1,1,3,3,5,5,7,7,9,9,11,11,13,13,15,15]
; AVX512-NEXT:    vpshufd {{.*#+}} zmm4 = zmm0[1,1,3,3,5,5,7,7,9,9,11,11,13,13,15,15]
; AVX512-NEXT:    vpmuldq %zmm3, %zmm4, %zmm3
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [1,17,3,19,5,21,7,23,9,25,11,27,13,29,15,31]
; AVX512-NEXT:    vpermi2d %zmm3, %zmm2, %zmm4
; AVX512-NEXT:    vpmulld %zmm1, %zmm0, %zmm1
; AVX512-NEXT:    vpsrad $31, %zmm1, %zmm0
; AVX512-NEXT:    vpcmpneqd %zmm0, %zmm4, %k1
; AVX512-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512-NEXT:    vmovdqa64 %zmm1, (%rdi)
; AVX512-NEXT:    retq
  %t = call {<16 x i32>, <16 x i1>} @llvm.smul.with.overflow.v16i32(<16 x i32> %a0, <16 x i32> %a1)
  %val = extractvalue {<16 x i32>, <16 x i1>} %t, 0
  %obit = extractvalue {<16 x i32>, <16 x i1>} %t, 1
  %res = sext <16 x i1> %obit to <16 x i32>
  store <16 x i32> %val, <16 x i32>* %p2
  ret <16 x i32> %res
}

define <16 x i32> @smulo_v16i8(<16 x i8> %a0, <16 x i8> %a1, <16 x i8>* %p2) nounwind {
; SSE2-LABEL: smulo_v16i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm1[8],xmm3[9],xmm1[9],xmm3[10],xmm1[10],xmm3[11],xmm1[11],xmm3[12],xmm1[12],xmm3[13],xmm1[13],xmm3[14],xmm1[14],xmm3[15],xmm1[15]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm5 = xmm5[0],xmm1[0],xmm5[1],xmm1[1],xmm5[2],xmm1[2],xmm5[3],xmm1[3],xmm5[4],xmm1[4],xmm5[5],xmm1[5],xmm5[6],xmm1[6],xmm5[7],xmm1[7]
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; SSE2-NEXT:    movdqa %xmm0, %xmm4
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm6 = xmm6[8],xmm0[8],xmm6[9],xmm0[9],xmm6[10],xmm0[10],xmm6[11],xmm0[11],xmm6[12],xmm0[12],xmm6[13],xmm0[13],xmm6[14],xmm0[14],xmm6[15],xmm0[15]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm7 = xmm7[0],xmm0[0],xmm7[1],xmm0[1],xmm7[2],xmm0[2],xmm7[3],xmm0[3],xmm7[4],xmm0[4],xmm7[5],xmm0[5],xmm7[6],xmm0[6],xmm7[7],xmm0[7]
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE2-NEXT:    pmullw %xmm1, %xmm0
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm0[0],xmm4[1],xmm0[1],xmm4[2],xmm0[2],xmm4[3],xmm0[3],xmm4[4],xmm0[4],xmm4[5],xmm0[5],xmm4[6],xmm0[6],xmm4[7],xmm0[7]
; SSE2-NEXT:    pmullw %xmm2, %xmm4
; SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [255,255,255,255,255,255,255,255]
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    pand %xmm1, %xmm4
; SSE2-NEXT:    packuswb %xmm0, %xmm4
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpgtb %xmm4, %xmm0
; SSE2-NEXT:    psraw $8, %xmm3
; SSE2-NEXT:    psraw $8, %xmm6
; SSE2-NEXT:    pmullw %xmm3, %xmm6
; SSE2-NEXT:    psrlw $8, %xmm6
; SSE2-NEXT:    psraw $8, %xmm5
; SSE2-NEXT:    psraw $8, %xmm7
; SSE2-NEXT:    pmullw %xmm5, %xmm7
; SSE2-NEXT:    psrlw $8, %xmm7
; SSE2-NEXT:    packuswb %xmm6, %xmm7
; SSE2-NEXT:    pcmpeqb %xmm0, %xmm7
; SSE2-NEXT:    pcmpeqd %xmm3, %xmm3
; SSE2-NEXT:    pxor %xmm7, %xmm3
; SSE2-NEXT:    movdqa %xmm3, %xmm1
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; SSE2-NEXT:    pslld $31, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm0[8],xmm3[9],xmm0[9],xmm3[10],xmm0[10],xmm3[11],xmm0[11],xmm3[12],xmm0[12],xmm3[13],xmm0[13],xmm3[14],xmm0[14],xmm3[15],xmm0[15]
; SSE2-NEXT:    movdqa %xmm3, %xmm2
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; SSE2-NEXT:    pslld $31, %xmm2
; SSE2-NEXT:    psrad $31, %xmm2
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm3 = xmm3[4],xmm0[4],xmm3[5],xmm0[5],xmm3[6],xmm0[6],xmm3[7],xmm0[7]
; SSE2-NEXT:    pslld $31, %xmm3
; SSE2-NEXT:    psrad $31, %xmm3
; SSE2-NEXT:    movdqa %xmm4, (%rdi)
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: smulo_v16i8:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa %xmm1, %xmm2
; SSSE3-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm1[8],xmm3[9],xmm1[9],xmm3[10],xmm1[10],xmm3[11],xmm1[11],xmm3[12],xmm1[12],xmm3[13],xmm1[13],xmm3[14],xmm1[14],xmm3[15],xmm1[15]
; SSSE3-NEXT:    punpcklbw {{.*#+}} xmm5 = xmm5[0],xmm1[0],xmm5[1],xmm1[1],xmm5[2],xmm1[2],xmm5[3],xmm1[3],xmm5[4],xmm1[4],xmm5[5],xmm1[5],xmm5[6],xmm1[6],xmm5[7],xmm1[7]
; SSSE3-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; SSSE3-NEXT:    movdqa %xmm0, %xmm4
; SSSE3-NEXT:    punpckhbw {{.*#+}} xmm6 = xmm6[8],xmm0[8],xmm6[9],xmm0[9],xmm6[10],xmm0[10],xmm6[11],xmm0[11],xmm6[12],xmm0[12],xmm6[13],xmm0[13],xmm6[14],xmm0[14],xmm6[15],xmm0[15]
; SSSE3-NEXT:    punpcklbw {{.*#+}} xmm7 = xmm7[0],xmm0[0],xmm7[1],xmm0[1],xmm7[2],xmm0[2],xmm7[3],xmm0[3],xmm7[4],xmm0[4],xmm7[5],xmm0[5],xmm7[6],xmm0[6],xmm7[7],xmm0[7]
; SSSE3-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSSE3-NEXT:    pmullw %xmm1, %xmm0
; SSSE3-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; SSSE3-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm0[0],xmm4[1],xmm0[1],xmm4[2],xmm0[2],xmm4[3],xmm0[3],xmm4[4],xmm0[4],xmm4[5],xmm0[5],xmm4[6],xmm0[6],xmm4[7],xmm0[7]
; SSSE3-NEXT:    pmullw %xmm2, %xmm4
; SSSE3-NEXT:    movdqa {{.*#+}} xmm1 = [255,255,255,255,255,255,255,255]
; SSSE3-NEXT:    pand %xmm1, %xmm0
; SSSE3-NEXT:    pand %xmm1, %xmm4
; SSSE3-NEXT:    packuswb %xmm0, %xmm4
; SSSE3-NEXT:    pxor %xmm0, %xmm0
; SSSE3-NEXT:    pcmpgtb %xmm4, %xmm0
; SSSE3-NEXT:    psraw $8, %xmm3
; SSSE3-NEXT:    psraw $8, %xmm6
; SSSE3-NEXT:    pmullw %xmm3, %xmm6
; SSSE3-NEXT:    psrlw $8, %xmm6
; SSSE3-NEXT:    psraw $8, %xmm5
; SSSE3-NEXT:    psraw $8, %xmm7
; SSSE3-NEXT:    pmullw %xmm5, %xmm7
; SSSE3-NEXT:    psrlw $8, %xmm7
; SSSE3-NEXT:    packuswb %xmm6, %xmm7
; SSSE3-NEXT:    pcmpeqb %xmm0, %xmm7
; SSSE3-NEXT:    pcmpeqd %xmm3, %xmm3
; SSSE3-NEXT:    pxor %xmm7, %xmm3
; SSSE3-NEXT:    movdqa %xmm3, %xmm1
; SSSE3-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; SSSE3-NEXT:    movdqa %xmm1, %xmm0
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSSE3-NEXT:    pslld $31, %xmm0
; SSSE3-NEXT:    psrad $31, %xmm0
; SSSE3-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; SSSE3-NEXT:    pslld $31, %xmm1
; SSSE3-NEXT:    psrad $31, %xmm1
; SSSE3-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm0[8],xmm3[9],xmm0[9],xmm3[10],xmm0[10],xmm3[11],xmm0[11],xmm3[12],xmm0[12],xmm3[13],xmm0[13],xmm3[14],xmm0[14],xmm3[15],xmm0[15]
; SSSE3-NEXT:    movdqa %xmm3, %xmm2
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; SSSE3-NEXT:    pslld $31, %xmm2
; SSSE3-NEXT:    psrad $31, %xmm2
; SSSE3-NEXT:    punpckhwd {{.*#+}} xmm3 = xmm3[4],xmm0[4],xmm3[5],xmm0[5],xmm3[6],xmm0[6],xmm3[7],xmm0[7]
; SSSE3-NEXT:    pslld $31, %xmm3
; SSSE3-NEXT:    psrad $31, %xmm3
; SSSE3-NEXT:    movdqa %xmm4, (%rdi)
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: smulo_v16i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovzxbw {{.*#+}} xmm2 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero
; SSE41-NEXT:    pmovsxbw %xmm1, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm5 = xmm1[2,3,0,1]
; SSE41-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; SSE41-NEXT:    pmovzxbw {{.*#+}} xmm4 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; SSE41-NEXT:    pmovsxbw %xmm0, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm7 = xmm0[2,3,0,1]
; SSE41-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE41-NEXT:    pmullw %xmm1, %xmm0
; SSE41-NEXT:    pmullw %xmm2, %xmm4
; SSE41-NEXT:    movdqa {{.*#+}} xmm1 = [255,255,255,255,255,255,255,255]
; SSE41-NEXT:    pand %xmm1, %xmm0
; SSE41-NEXT:    pand %xmm1, %xmm4
; SSE41-NEXT:    packuswb %xmm0, %xmm4
; SSE41-NEXT:    pxor %xmm0, %xmm0
; SSE41-NEXT:    pcmpgtb %xmm4, %xmm0
; SSE41-NEXT:    pmullw %xmm3, %xmm6
; SSE41-NEXT:    psrlw $8, %xmm6
; SSE41-NEXT:    pmovsxbw %xmm5, %xmm1
; SSE41-NEXT:    pmovsxbw %xmm7, %xmm2
; SSE41-NEXT:    pmullw %xmm1, %xmm2
; SSE41-NEXT:    psrlw $8, %xmm2
; SSE41-NEXT:    packuswb %xmm2, %xmm6
; SSE41-NEXT:    pcmpeqb %xmm0, %xmm6
; SSE41-NEXT:    pcmpeqd %xmm3, %xmm3
; SSE41-NEXT:    pxor %xmm6, %xmm3
; SSE41-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm3[0],zero,zero,zero,xmm3[1],zero,zero,zero,xmm3[2],zero,zero,zero,xmm3[3],zero,zero,zero
; SSE41-NEXT:    pslld $31, %xmm0
; SSE41-NEXT:    psrad $31, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[1,1,2,3]
; SSE41-NEXT:    pmovzxbd {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero
; SSE41-NEXT:    pslld $31, %xmm1
; SSE41-NEXT:    psrad $31, %xmm1
; SSE41-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[2,3,0,1]
; SSE41-NEXT:    pmovzxbd {{.*#+}} xmm2 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero
; SSE41-NEXT:    pslld $31, %xmm2
; SSE41-NEXT:    psrad $31, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[3,1,2,3]
; SSE41-NEXT:    pmovzxbd {{.*#+}} xmm3 = xmm3[0],zero,zero,zero,xmm3[1],zero,zero,zero,xmm3[2],zero,zero,zero,xmm3[3],zero,zero,zero
; SSE41-NEXT:    pslld $31, %xmm3
; SSE41-NEXT:    psrad $31, %xmm3
; SSE41-NEXT:    movdqa %xmm4, (%rdi)
; SSE41-NEXT:    retq
;
; AVX1-LABEL: smulo_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; AVX1-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX1-NEXT:    vpmullw %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [255,255,255,255,255,255,255,255]
; AVX1-NEXT:    vpand %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxbw {{.*#+}} xmm4 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero
; AVX1-NEXT:    vpmovzxbw {{.*#+}} xmm5 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX1-NEXT:    vpmullw %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vpand %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpackuswb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpgtb %xmm2, %xmm3, %xmm3
; AVX1-NEXT:    vpmovsxbw %xmm1, %xmm4
; AVX1-NEXT:    vpmovsxbw %xmm0, %xmm5
; AVX1-NEXT:    vpmullw %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vpsrlw $8, %xmm4, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,3,0,1]
; AVX1-NEXT:    vpmovsxbw %xmm1, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,3,0,1]
; AVX1-NEXT:    vpmovsxbw %xmm0, %xmm0
; AVX1-NEXT:    vpmullw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpcmpeqb %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vpmovsxbd %xmm1, %xmm0
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm1[1,1,2,3]
; AVX1-NEXT:    vpmovsxbd %xmm3, %xmm3
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm1[2,3,0,1]
; AVX1-NEXT:    vpmovsxbd %xmm3, %xmm3
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[3,3,0,1]
; AVX1-NEXT:    vpmovsxbd %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm1
; AVX1-NEXT:    vmovdqa %xmm2, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: smulo_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovsxbw %xmm1, %ymm2
; AVX2-NEXT:    vpmovsxbw %xmm0, %ymm3
; AVX2-NEXT:    vpmullw %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $8, %ymm2, %ymm2
; AVX2-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX2-NEXT:    vpackuswb %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vpmovzxbw {{.*#+}} ymm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; AVX2-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; AVX2-NEXT:    vpmullw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpand {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm3
; AVX2-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpcmpgtb %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpcmpeqb %xmm0, %xmm2, %xmm0
; AVX2-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpxor %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vpmovsxbd %xmm1, %ymm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,3,0,1]
; AVX2-NEXT:    vpmovsxbd %xmm1, %ymm1
; AVX2-NEXT:    vmovdqa %xmm3, (%rdi)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: smulo_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovzxbw {{.*#+}} ymm2 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; AVX512-NEXT:    vpmovzxbw {{.*#+}} ymm3 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; AVX512-NEXT:    vpmullw %ymm2, %ymm3, %ymm2
; AVX512-NEXT:    vpmovwb %ymm2, %xmm2
; AVX512-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512-NEXT:    vpcmpgtb %xmm2, %xmm3, %xmm3
; AVX512-NEXT:    vpmovsxbw %xmm1, %ymm1
; AVX512-NEXT:    vpmovsxbw %xmm0, %ymm0
; AVX512-NEXT:    vpmullw %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX512-NEXT:    vpmovwb %ymm0, %xmm0
; AVX512-NEXT:    vpcmpneqb %xmm3, %xmm0, %k1
; AVX512-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512-NEXT:    vmovdqa %xmm2, (%rdi)
; AVX512-NEXT:    retq
  %t = call {<16 x i8>, <16 x i1>} @llvm.smul.with.overflow.v16i8(<16 x i8> %a0, <16 x i8> %a1)
  %val = extractvalue {<16 x i8>, <16 x i1>} %t, 0
  %obit = extractvalue {<16 x i8>, <16 x i1>} %t, 1
  %res = sext <16 x i1> %obit to <16 x i32>
  store <16 x i8> %val, <16 x i8>* %p2
  ret <16 x i32> %res
}

define <8 x i32> @smulo_v8i16(<8 x i16> %a0, <8 x i16> %a1, <8 x i16>* %p2) nounwind {
; SSE2-LABEL: smulo_v8i16:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    pmulhw %xmm1, %xmm2
; SSE2-NEXT:    pmullw %xmm1, %xmm0
; SSE2-NEXT:    movdqa %xmm0, (%rdi)
; SSE2-NEXT:    psraw $15, %xmm0
; SSE2-NEXT:    pcmpeqw %xmm2, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    pxor %xmm0, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; SSE2-NEXT:    pslld $31, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: smulo_v8i16:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa %xmm0, %xmm2
; SSSE3-NEXT:    pmulhw %xmm1, %xmm2
; SSSE3-NEXT:    pmullw %xmm1, %xmm0
; SSSE3-NEXT:    movdqa %xmm0, (%rdi)
; SSSE3-NEXT:    psraw $15, %xmm0
; SSSE3-NEXT:    pcmpeqw %xmm2, %xmm0
; SSSE3-NEXT:    pcmpeqd %xmm1, %xmm1
; SSSE3-NEXT:    pxor %xmm0, %xmm1
; SSSE3-NEXT:    movdqa %xmm1, %xmm0
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSSE3-NEXT:    pslld $31, %xmm0
; SSSE3-NEXT:    psrad $31, %xmm0
; SSSE3-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; SSSE3-NEXT:    pslld $31, %xmm1
; SSSE3-NEXT:    psrad $31, %xmm1
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: smulo_v8i16:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    pmulhw %xmm1, %xmm2
; SSE41-NEXT:    pmullw %xmm1, %xmm0
; SSE41-NEXT:    movdqa %xmm0, (%rdi)
; SSE41-NEXT:    psraw $15, %xmm0
; SSE41-NEXT:    pcmpeqw %xmm2, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    pxor %xmm0, %xmm1
; SSE41-NEXT:    pmovzxwd {{.*#+}} xmm0 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero
; SSE41-NEXT:    pslld $31, %xmm0
; SSE41-NEXT:    psrad $31, %xmm0
; SSE41-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; SSE41-NEXT:    pslld $31, %xmm1
; SSE41-NEXT:    psrad $31, %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: smulo_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmulhw %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vpmullw %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vpsraw $15, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpeqw %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpxor %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxwd %xmm0, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,3,0,1]
; AVX1-NEXT:    vpmovsxwd %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; AVX1-NEXT:    vmovdqa %xmm1, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: smulo_v8i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmulhw %xmm1, %xmm0, %xmm2
; AVX2-NEXT:    vpmullw %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vpsraw $15, %xmm1, %xmm0
; AVX2-NEXT:    vpcmpeqw %xmm0, %xmm2, %xmm0
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpxor %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpmovsxwd %xmm0, %ymm0
; AVX2-NEXT:    vmovdqa %xmm1, (%rdi)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: smulo_v8i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmulhw %xmm1, %xmm0, %xmm2
; AVX512-NEXT:    vpmullw %xmm1, %xmm0, %xmm1
; AVX512-NEXT:    vpsraw $15, %xmm1, %xmm0
; AVX512-NEXT:    vpcmpneqw %xmm0, %xmm2, %k1
; AVX512-NEXT:    vpcmpeqd %ymm0, %ymm0, %ymm0
; AVX512-NEXT:    vmovdqa32 %ymm0, %ymm0 {%k1} {z}
; AVX512-NEXT:    vmovdqa %xmm1, (%rdi)
; AVX512-NEXT:    retq
  %t = call {<8 x i16>, <8 x i1>} @llvm.smul.with.overflow.v8i16(<8 x i16> %a0, <8 x i16> %a1)
  %val = extractvalue {<8 x i16>, <8 x i1>} %t, 0
  %obit = extractvalue {<8 x i16>, <8 x i1>} %t, 1
  %res = sext <8 x i1> %obit to <8 x i32>
  store <8 x i16> %val, <8 x i16>* %p2
  ret <8 x i32> %res
}

define <2 x i32> @smulo_v2i64(<2 x i64> %a0, <2 x i64> %a1, <2 x i64>* %p2) nounwind {
; SSE2-LABEL: smulo_v2i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[2,3,0,1]
; SSE2-NEXT:    movq %xmm2, %r8
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[2,3,0,1]
; SSE2-NEXT:    movq %xmm2, %rcx
; SSE2-NEXT:    movq %xmm1, %rdx
; SSE2-NEXT:    movq %xmm0, %rsi
; SSE2-NEXT:    xorl %eax, %eax
; SSE2-NEXT:    imulq %rdx, %rsi
; SSE2-NEXT:    movq $-1, %r9
; SSE2-NEXT:    movl $0, %edx
; SSE2-NEXT:    cmovoq %r9, %rdx
; SSE2-NEXT:    movq %rsi, %xmm1
; SSE2-NEXT:    imulq %r8, %rcx
; SSE2-NEXT:    movq %rcx, %xmm0
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE2-NEXT:    movq %rdx, %xmm0
; SSE2-NEXT:    cmovoq %r9, %rax
; SSE2-NEXT:    movq %rax, %xmm2
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE2-NEXT:    movdqa %xmm1, (%rdi)
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: smulo_v2i64:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[2,3,0,1]
; SSSE3-NEXT:    movq %xmm2, %r8
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[2,3,0,1]
; SSSE3-NEXT:    movq %xmm2, %rcx
; SSSE3-NEXT:    movq %xmm1, %rdx
; SSSE3-NEXT:    movq %xmm0, %rsi
; SSSE3-NEXT:    xorl %eax, %eax
; SSSE3-NEXT:    imulq %rdx, %rsi
; SSSE3-NEXT:    movq $-1, %r9
; SSSE3-NEXT:    movl $0, %edx
; SSSE3-NEXT:    cmovoq %r9, %rdx
; SSSE3-NEXT:    movq %rsi, %xmm1
; SSSE3-NEXT:    imulq %r8, %rcx
; SSSE3-NEXT:    movq %rcx, %xmm0
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSSE3-NEXT:    movq %rdx, %xmm0
; SSSE3-NEXT:    cmovoq %r9, %rax
; SSSE3-NEXT:    movq %rax, %xmm2
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSSE3-NEXT:    movdqa %xmm1, (%rdi)
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: smulo_v2i64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movq %xmm1, %r8
; SSE41-NEXT:    movq %xmm0, %rcx
; SSE41-NEXT:    pextrq $1, %xmm1, %rdx
; SSE41-NEXT:    pextrq $1, %xmm0, %rsi
; SSE41-NEXT:    xorl %eax, %eax
; SSE41-NEXT:    imulq %rdx, %rsi
; SSE41-NEXT:    movq $-1, %r9
; SSE41-NEXT:    movl $0, %edx
; SSE41-NEXT:    cmovoq %r9, %rdx
; SSE41-NEXT:    movq %rsi, %xmm0
; SSE41-NEXT:    imulq %r8, %rcx
; SSE41-NEXT:    movq %rcx, %xmm1
; SSE41-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE41-NEXT:    movq %rdx, %xmm0
; SSE41-NEXT:    cmovoq %r9, %rax
; SSE41-NEXT:    movq %rax, %xmm2
; SSE41-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm0[0]
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,2,2,3]
; SSE41-NEXT:    movdqa %xmm1, (%rdi)
; SSE41-NEXT:    retq
;
; AVX1-LABEL: smulo_v2i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovq %xmm1, %r8
; AVX1-NEXT:    vmovq %xmm0, %rcx
; AVX1-NEXT:    vpextrq $1, %xmm1, %rdx
; AVX1-NEXT:    vpextrq $1, %xmm0, %rsi
; AVX1-NEXT:    xorl %eax, %eax
; AVX1-NEXT:    imulq %rdx, %rsi
; AVX1-NEXT:    movq $-1, %r9
; AVX1-NEXT:    movl $0, %edx
; AVX1-NEXT:    cmovoq %r9, %rdx
; AVX1-NEXT:    vmovq %rsi, %xmm0
; AVX1-NEXT:    imulq %r8, %rcx
; AVX1-NEXT:    vmovq %rcx, %xmm1
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; AVX1-NEXT:    vmovq %rdx, %xmm0
; AVX1-NEXT:    cmovoq %r9, %rax
; AVX1-NEXT:    vmovq %rax, %xmm2
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX1-NEXT:    vmovdqa %xmm1, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: smulo_v2i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovq %xmm1, %r8
; AVX2-NEXT:    vmovq %xmm0, %rcx
; AVX2-NEXT:    vpextrq $1, %xmm1, %rdx
; AVX2-NEXT:    vpextrq $1, %xmm0, %rsi
; AVX2-NEXT:    xorl %eax, %eax
; AVX2-NEXT:    imulq %rdx, %rsi
; AVX2-NEXT:    movq $-1, %r9
; AVX2-NEXT:    movl $0, %edx
; AVX2-NEXT:    cmovoq %r9, %rdx
; AVX2-NEXT:    vmovq %rsi, %xmm0
; AVX2-NEXT:    imulq %r8, %rcx
; AVX2-NEXT:    vmovq %rcx, %xmm1
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; AVX2-NEXT:    vmovq %rdx, %xmm0
; AVX2-NEXT:    cmovoq %r9, %rax
; AVX2-NEXT:    vmovq %rax, %xmm2
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX2-NEXT:    vmovdqa %xmm1, (%rdi)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: smulo_v2i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovq %xmm1, %rax
; AVX512-NEXT:    vmovq %xmm0, %rcx
; AVX512-NEXT:    vpextrq $1, %xmm1, %rdx
; AVX512-NEXT:    vpextrq $1, %xmm0, %rsi
; AVX512-NEXT:    imulq %rdx, %rsi
; AVX512-NEXT:    seto %dl
; AVX512-NEXT:    vmovq %rsi, %xmm0
; AVX512-NEXT:    imulq %rax, %rcx
; AVX512-NEXT:    vmovq %rcx, %xmm1
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; AVX512-NEXT:    seto %al
; AVX512-NEXT:    movw $-3, %cx
; AVX512-NEXT:    kmovd %ecx, %k0
; AVX512-NEXT:    kmovd %eax, %k1
; AVX512-NEXT:    kandw %k0, %k1, %k0
; AVX512-NEXT:    kmovd %edx, %k1
; AVX512-NEXT:    kshiftlw $15, %k1, %k1
; AVX512-NEXT:    kshiftrw $14, %k1, %k1
; AVX512-NEXT:    korw %k1, %k0, %k1
; AVX512-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    vmovdqa32 %xmm0, %xmm0 {%k1} {z}
; AVX512-NEXT:    vmovdqa %xmm1, (%rdi)
; AVX512-NEXT:    retq
  %t = call {<2 x i64>, <2 x i1>} @llvm.smul.with.overflow.v2i64(<2 x i64> %a0, <2 x i64> %a1)
  %val = extractvalue {<2 x i64>, <2 x i1>} %t, 0
  %obit = extractvalue {<2 x i64>, <2 x i1>} %t, 1
  %res = sext <2 x i1> %obit to <2 x i32>
  store <2 x i64> %val, <2 x i64>* %p2
  ret <2 x i32> %res
}

define <4 x i32> @smulo_v4i24(<4 x i24> %a0, <4 x i24> %a1, <4 x i24>* %p2) nounwind {
; SSE2-LABEL: smulo_v4i24:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pslld $8, %xmm0
; SSE2-NEXT:    psrad $8, %xmm0
; SSE2-NEXT:    pslld $8, %xmm1
; SSE2-NEXT:    psrad $8, %xmm1
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm2
; SSE2-NEXT:    pand %xmm0, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm3
; SSE2-NEXT:    pand %xmm1, %xmm3
; SSE2-NEXT:    paddd %xmm2, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[1,3,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm4, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,3,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm1[0],xmm5[1],xmm1[1]
; SSE2-NEXT:    psubd %xmm3, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1]
; SSE2-NEXT:    movdqa %xmm3, %xmm1
; SSE2-NEXT:    pslld $8, %xmm1
; SSE2-NEXT:    psrad $8, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm3, %xmm1
; SSE2-NEXT:    psrad $31, %xmm3
; SSE2-NEXT:    pcmpeqd %xmm5, %xmm3
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm4
; SSE2-NEXT:    pxor %xmm4, %xmm3
; SSE2-NEXT:    pxor %xmm4, %xmm1
; SSE2-NEXT:    por %xmm3, %xmm1
; SSE2-NEXT:    movd %xmm0, %eax
; SSE2-NEXT:    movw %ax, (%rdi)
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,0,1]
; SSE2-NEXT:    movd %xmm0, %ecx
; SSE2-NEXT:    movw %cx, 6(%rdi)
; SSE2-NEXT:    movd %xmm2, %edx
; SSE2-NEXT:    movw %dx, 3(%rdi)
; SSE2-NEXT:    shrl $16, %eax
; SSE2-NEXT:    movb %al, 2(%rdi)
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[2,3,2,3]
; SSE2-NEXT:    movd %xmm0, %eax
; SSE2-NEXT:    movw %ax, 9(%rdi)
; SSE2-NEXT:    shrl $16, %ecx
; SSE2-NEXT:    movb %cl, 8(%rdi)
; SSE2-NEXT:    shrl $16, %edx
; SSE2-NEXT:    movb %dl, 5(%rdi)
; SSE2-NEXT:    shrl $16, %eax
; SSE2-NEXT:    movb %al, 11(%rdi)
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: smulo_v4i24:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    pslld $8, %xmm0
; SSSE3-NEXT:    psrad $8, %xmm0
; SSSE3-NEXT:    pslld $8, %xmm1
; SSSE3-NEXT:    psrad $8, %xmm1
; SSSE3-NEXT:    pxor %xmm3, %xmm3
; SSSE3-NEXT:    pxor %xmm2, %xmm2
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm2
; SSSE3-NEXT:    pand %xmm0, %xmm2
; SSSE3-NEXT:    pcmpgtd %xmm0, %xmm3
; SSSE3-NEXT:    pand %xmm1, %xmm3
; SSSE3-NEXT:    paddd %xmm2, %xmm3
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[1,1,3,3]
; SSSE3-NEXT:    pmuludq %xmm1, %xmm0
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[1,3,2,3]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,1,3,3]
; SSSE3-NEXT:    pmuludq %xmm4, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,3,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm1[0],xmm5[1],xmm1[1]
; SSSE3-NEXT:    psubd %xmm3, %xmm5
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[0,2,2,3]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[0,2,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1]
; SSSE3-NEXT:    movdqa %xmm3, %xmm1
; SSSE3-NEXT:    pslld $8, %xmm1
; SSSE3-NEXT:    psrad $8, %xmm1
; SSSE3-NEXT:    pcmpeqd %xmm3, %xmm1
; SSSE3-NEXT:    psrad $31, %xmm3
; SSSE3-NEXT:    pcmpeqd %xmm5, %xmm3
; SSSE3-NEXT:    pcmpeqd %xmm4, %xmm4
; SSSE3-NEXT:    pxor %xmm4, %xmm3
; SSSE3-NEXT:    pxor %xmm4, %xmm1
; SSSE3-NEXT:    por %xmm3, %xmm1
; SSSE3-NEXT:    movd %xmm0, %eax
; SSSE3-NEXT:    movw %ax, (%rdi)
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,0,1]
; SSSE3-NEXT:    movd %xmm0, %ecx
; SSSE3-NEXT:    movw %cx, 6(%rdi)
; SSSE3-NEXT:    movd %xmm2, %edx
; SSSE3-NEXT:    movw %dx, 3(%rdi)
; SSSE3-NEXT:    shrl $16, %eax
; SSSE3-NEXT:    movb %al, 2(%rdi)
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[2,3,2,3]
; SSSE3-NEXT:    movd %xmm0, %eax
; SSSE3-NEXT:    movw %ax, 9(%rdi)
; SSSE3-NEXT:    shrl $16, %ecx
; SSSE3-NEXT:    movb %cl, 8(%rdi)
; SSSE3-NEXT:    shrl $16, %edx
; SSSE3-NEXT:    movb %dl, 5(%rdi)
; SSSE3-NEXT:    shrl $16, %eax
; SSSE3-NEXT:    movb %al, 11(%rdi)
; SSSE3-NEXT:    movdqa %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: smulo_v4i24:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pslld $8, %xmm0
; SSE41-NEXT:    psrad $8, %xmm0
; SSE41-NEXT:    pslld $8, %xmm1
; SSE41-NEXT:    psrad $8, %xmm1
; SSE41-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,1,3,3]
; SSE41-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[1,1,3,3]
; SSE41-NEXT:    pmuldq %xmm2, %xmm3
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    pmuldq %xmm1, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE41-NEXT:    pblendw {{.*#+}} xmm2 = xmm2[0,1],xmm3[2,3],xmm2[4,5],xmm3[6,7]
; SSE41-NEXT:    pmulld %xmm0, %xmm1
; SSE41-NEXT:    movdqa %xmm1, %xmm3
; SSE41-NEXT:    pslld $8, %xmm3
; SSE41-NEXT:    psrad $8, %xmm3
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm3
; SSE41-NEXT:    pextrd $3, %xmm1, %eax
; SSE41-NEXT:    pextrd $2, %xmm1, %ecx
; SSE41-NEXT:    pextrd $1, %xmm1, %edx
; SSE41-NEXT:    movd %xmm1, %esi
; SSE41-NEXT:    psrad $31, %xmm1
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm1
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE41-NEXT:    pxor %xmm0, %xmm1
; SSE41-NEXT:    pxor %xmm3, %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    movw %ax, 9(%rdi)
; SSE41-NEXT:    movw %cx, 6(%rdi)
; SSE41-NEXT:    movw %dx, 3(%rdi)
; SSE41-NEXT:    movw %si, (%rdi)
; SSE41-NEXT:    shrl $16, %eax
; SSE41-NEXT:    movb %al, 11(%rdi)
; SSE41-NEXT:    shrl $16, %ecx
; SSE41-NEXT:    movb %cl, 8(%rdi)
; SSE41-NEXT:    shrl $16, %edx
; SSE41-NEXT:    movb %dl, 5(%rdi)
; SSE41-NEXT:    shrl $16, %esi
; SSE41-NEXT:    movb %sil, 2(%rdi)
; SSE41-NEXT:    retq
;
; AVX1-LABEL: smulo_v4i24:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpslld $8, %xmm0, %xmm0
; AVX1-NEXT:    vpsrad $8, %xmm0, %xmm0
; AVX1-NEXT:    vpslld $8, %xmm1, %xmm1
; AVX1-NEXT:    vpsrad $8, %xmm1, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm1[1,1,3,3]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[1,1,3,3]
; AVX1-NEXT:    vpmuldq %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpmuldq %xmm1, %xmm0, %xmm3
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm3[0,1],xmm2[2,3],xmm3[4,5],xmm2[6,7]
; AVX1-NEXT:    vpmulld %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vpsrad $31, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpeqd %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpxor %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpslld $8, %xmm1, %xmm3
; AVX1-NEXT:    vpsrad $8, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm1, %xmm3, %xmm3
; AVX1-NEXT:    vpxor %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpor %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vpextrd $3, %xmm1, %eax
; AVX1-NEXT:    movw %ax, 9(%rdi)
; AVX1-NEXT:    vpextrd $2, %xmm1, %ecx
; AVX1-NEXT:    movw %cx, 6(%rdi)
; AVX1-NEXT:    vpextrd $1, %xmm1, %edx
; AVX1-NEXT:    movw %dx, 3(%rdi)
; AVX1-NEXT:    vmovd %xmm1, %esi
; AVX1-NEXT:    movw %si, (%rdi)
; AVX1-NEXT:    shrl $16, %eax
; AVX1-NEXT:    movb %al, 11(%rdi)
; AVX1-NEXT:    shrl $16, %ecx
; AVX1-NEXT:    movb %cl, 8(%rdi)
; AVX1-NEXT:    shrl $16, %edx
; AVX1-NEXT:    movb %dl, 5(%rdi)
; AVX1-NEXT:    shrl $16, %esi
; AVX1-NEXT:    movb %sil, 2(%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: smulo_v4i24:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpslld $8, %xmm0, %xmm0
; AVX2-NEXT:    vpsrad $8, %xmm0, %xmm0
; AVX2-NEXT:    vpslld $8, %xmm1, %xmm1
; AVX2-NEXT:    vpsrad $8, %xmm1, %xmm1
; AVX2-NEXT:    vpshufd {{.*#+}} xmm2 = xmm1[1,1,3,3]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[1,1,3,3]
; AVX2-NEXT:    vpmuldq %xmm2, %xmm3, %xmm2
; AVX2-NEXT:    vpmuldq %xmm1, %xmm0, %xmm3
; AVX2-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; AVX2-NEXT:    vpblendd {{.*#+}} xmm2 = xmm3[0],xmm2[1],xmm3[2],xmm2[3]
; AVX2-NEXT:    vpmulld %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vpsrad $31, %xmm1, %xmm0
; AVX2-NEXT:    vpcmpeqd %xmm0, %xmm2, %xmm0
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpxor %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpslld $8, %xmm1, %xmm3
; AVX2-NEXT:    vpsrad $8, %xmm3, %xmm3
; AVX2-NEXT:    vpcmpeqd %xmm1, %xmm3, %xmm3
; AVX2-NEXT:    vpxor %xmm2, %xmm3, %xmm2
; AVX2-NEXT:    vpor %xmm0, %xmm2, %xmm0
; AVX2-NEXT:    vpextrd $3, %xmm1, %eax
; AVX2-NEXT:    movw %ax, 9(%rdi)
; AVX2-NEXT:    vpextrd $2, %xmm1, %ecx
; AVX2-NEXT:    movw %cx, 6(%rdi)
; AVX2-NEXT:    vpextrd $1, %xmm1, %edx
; AVX2-NEXT:    movw %dx, 3(%rdi)
; AVX2-NEXT:    vmovd %xmm1, %esi
; AVX2-NEXT:    movw %si, (%rdi)
; AVX2-NEXT:    shrl $16, %eax
; AVX2-NEXT:    movb %al, 11(%rdi)
; AVX2-NEXT:    shrl $16, %ecx
; AVX2-NEXT:    movb %cl, 8(%rdi)
; AVX2-NEXT:    shrl $16, %edx
; AVX2-NEXT:    movb %dl, 5(%rdi)
; AVX2-NEXT:    shrl $16, %esi
; AVX2-NEXT:    movb %sil, 2(%rdi)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: smulo_v4i24:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpslld $8, %xmm1, %xmm1
; AVX512-NEXT:    vpsrad $8, %xmm1, %xmm1
; AVX512-NEXT:    vpslld $8, %xmm0, %xmm0
; AVX512-NEXT:    vpsrad $8, %xmm0, %xmm0
; AVX512-NEXT:    vpmuldq %xmm1, %xmm0, %xmm2
; AVX512-NEXT:    vpshufd {{.*#+}} xmm3 = xmm1[1,1,3,3]
; AVX512-NEXT:    vpshufd {{.*#+}} xmm4 = xmm0[1,1,3,3]
; AVX512-NEXT:    vpmuldq %xmm3, %xmm4, %xmm3
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm4 = [1,5,3,7]
; AVX512-NEXT:    vpermi2d %xmm3, %xmm2, %xmm4
; AVX512-NEXT:    vpmulld %xmm1, %xmm0, %xmm1
; AVX512-NEXT:    vpsrad $31, %xmm1, %xmm0
; AVX512-NEXT:    vpcmpneqd %xmm0, %xmm4, %k0
; AVX512-NEXT:    vpslld $8, %xmm1, %xmm0
; AVX512-NEXT:    vpsrad $8, %xmm0, %xmm0
; AVX512-NEXT:    vpcmpneqd %xmm1, %xmm0, %k1
; AVX512-NEXT:    korw %k0, %k1, %k1
; AVX512-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    vmovdqa32 %xmm0, %xmm0 {%k1} {z}
; AVX512-NEXT:    vpextrd $3, %xmm1, %eax
; AVX512-NEXT:    movw %ax, 9(%rdi)
; AVX512-NEXT:    vpextrd $2, %xmm1, %ecx
; AVX512-NEXT:    movw %cx, 6(%rdi)
; AVX512-NEXT:    vpextrd $1, %xmm1, %edx
; AVX512-NEXT:    movw %dx, 3(%rdi)
; AVX512-NEXT:    vmovd %xmm1, %esi
; AVX512-NEXT:    movw %si, (%rdi)
; AVX512-NEXT:    shrl $16, %eax
; AVX512-NEXT:    movb %al, 11(%rdi)
; AVX512-NEXT:    shrl $16, %ecx
; AVX512-NEXT:    movb %cl, 8(%rdi)
; AVX512-NEXT:    shrl $16, %edx
; AVX512-NEXT:    movb %dl, 5(%rdi)
; AVX512-NEXT:    shrl $16, %esi
; AVX512-NEXT:    movb %sil, 2(%rdi)
; AVX512-NEXT:    retq
  %t = call {<4 x i24>, <4 x i1>} @llvm.smul.with.overflow.v4i24(<4 x i24> %a0, <4 x i24> %a1)
  %val = extractvalue {<4 x i24>, <4 x i1>} %t, 0
  %obit = extractvalue {<4 x i24>, <4 x i1>} %t, 1
  %res = sext <4 x i1> %obit to <4 x i32>
  store <4 x i24> %val, <4 x i24>* %p2
  ret <4 x i32> %res
}

define <4 x i32> @smulo_v4i1(<4 x i1> %a0, <4 x i1> %a1, <4 x i1>* %p2) nounwind {
; SSE2-LABEL: smulo_v4i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pslld $31, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm3
; SSE2-NEXT:    pand %xmm0, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm2
; SSE2-NEXT:    pand %xmm1, %xmm2
; SSE2-NEXT:    paddd %xmm3, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[1,3,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm3, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[1,3,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; SSE2-NEXT:    psubd %xmm2, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm2, %xmm1
; SSE2-NEXT:    movdqa %xmm0, %xmm3
; SSE2-NEXT:    pslld $31, %xmm3
; SSE2-NEXT:    psrad $31, %xmm3
; SSE2-NEXT:    pcmpeqd %xmm3, %xmm0
; SSE2-NEXT:    pxor %xmm2, %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    movmskps %xmm3, %eax
; SSE2-NEXT:    movb %al, (%rdi)
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: smulo_v4i1:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    pslld $31, %xmm0
; SSSE3-NEXT:    psrad $31, %xmm0
; SSSE3-NEXT:    pslld $31, %xmm1
; SSSE3-NEXT:    psrad $31, %xmm1
; SSSE3-NEXT:    pxor %xmm2, %xmm2
; SSSE3-NEXT:    pxor %xmm3, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm3
; SSSE3-NEXT:    pand %xmm0, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm0, %xmm2
; SSSE3-NEXT:    pand %xmm1, %xmm2
; SSSE3-NEXT:    paddd %xmm3, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[1,1,3,3]
; SSSE3-NEXT:    pmuludq %xmm1, %xmm0
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[1,3,2,3]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSSE3-NEXT:    pmuludq %xmm3, %xmm1
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[1,3,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; SSSE3-NEXT:    psubd %xmm2, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSSE3-NEXT:    movdqa %xmm0, %xmm1
; SSSE3-NEXT:    psrad $31, %xmm1
; SSSE3-NEXT:    pcmpeqd %xmm4, %xmm1
; SSSE3-NEXT:    pcmpeqd %xmm2, %xmm2
; SSSE3-NEXT:    pxor %xmm2, %xmm1
; SSSE3-NEXT:    movdqa %xmm0, %xmm3
; SSSE3-NEXT:    pslld $31, %xmm3
; SSSE3-NEXT:    psrad $31, %xmm3
; SSSE3-NEXT:    pcmpeqd %xmm3, %xmm0
; SSSE3-NEXT:    pxor %xmm2, %xmm0
; SSSE3-NEXT:    por %xmm1, %xmm0
; SSSE3-NEXT:    movmskps %xmm3, %eax
; SSSE3-NEXT:    movb %al, (%rdi)
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: smulo_v4i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pslld $31, %xmm0
; SSE41-NEXT:    psrad $31, %xmm0
; SSE41-NEXT:    pslld $31, %xmm1
; SSE41-NEXT:    psrad $31, %xmm1
; SSE41-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,1,3,3]
; SSE41-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[1,1,3,3]
; SSE41-NEXT:    pmuldq %xmm2, %xmm3
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    pmuldq %xmm1, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE41-NEXT:    pblendw {{.*#+}} xmm2 = xmm2[0,1],xmm3[2,3],xmm2[4,5],xmm3[6,7]
; SSE41-NEXT:    pmulld %xmm0, %xmm1
; SSE41-NEXT:    movdqa %xmm1, %xmm3
; SSE41-NEXT:    psrad $31, %xmm3
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm3
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE41-NEXT:    pxor %xmm0, %xmm3
; SSE41-NEXT:    movdqa %xmm1, %xmm2
; SSE41-NEXT:    pslld $31, %xmm2
; SSE41-NEXT:    psrad $31, %xmm2
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm1
; SSE41-NEXT:    pxor %xmm1, %xmm0
; SSE41-NEXT:    por %xmm3, %xmm0
; SSE41-NEXT:    movmskps %xmm2, %eax
; SSE41-NEXT:    movb %al, (%rdi)
; SSE41-NEXT:    retq
;
; AVX1-LABEL: smulo_v4i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX1-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX1-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX1-NEXT:    vpsrad $31, %xmm1, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm1[1,1,3,3]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[1,1,3,3]
; AVX1-NEXT:    vpmuldq %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpmuldq %xmm1, %xmm0, %xmm3
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm3[0,1],xmm2[2,3],xmm3[4,5],xmm2[6,7]
; AVX1-NEXT:    vpmulld %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpsrad $31, %xmm0, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpxor %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpslld $31, %xmm0, %xmm3
; AVX1-NEXT:    vpsrad $31, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpxor %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovmskps %xmm3, %eax
; AVX1-NEXT:    movb %al, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: smulo_v4i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX2-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX2-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX2-NEXT:    vpsrad $31, %xmm1, %xmm1
; AVX2-NEXT:    vpshufd {{.*#+}} xmm2 = xmm1[1,1,3,3]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[1,1,3,3]
; AVX2-NEXT:    vpmuldq %xmm2, %xmm3, %xmm2
; AVX2-NEXT:    vpmuldq %xmm1, %xmm0, %xmm3
; AVX2-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; AVX2-NEXT:    vpblendd {{.*#+}} xmm2 = xmm3[0],xmm2[1],xmm3[2],xmm2[3]
; AVX2-NEXT:    vpmulld %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpsrad $31, %xmm0, %xmm1
; AVX2-NEXT:    vpcmpeqd %xmm1, %xmm2, %xmm1
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpxor %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpslld $31, %xmm0, %xmm3
; AVX2-NEXT:    vpsrad $31, %xmm3, %xmm3
; AVX2-NEXT:    vpcmpeqd %xmm0, %xmm3, %xmm0
; AVX2-NEXT:    vpxor %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vmovmskps %xmm3, %eax
; AVX2-NEXT:    movb %al, (%rdi)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: smulo_v4i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    pushq %rbx
; AVX512-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX512-NEXT:    vptestmd %xmm1, %xmm1, %k0
; AVX512-NEXT:    kshiftrw $3, %k0, %k1
; AVX512-NEXT:    kmovd %k1, %r9d
; AVX512-NEXT:    andb $1, %r9b
; AVX512-NEXT:    negb %r9b
; AVX512-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512-NEXT:    vptestmd %xmm0, %xmm0, %k1
; AVX512-NEXT:    kshiftrw $3, %k1, %k2
; AVX512-NEXT:    kmovd %k2, %r10d
; AVX512-NEXT:    andb $1, %r10b
; AVX512-NEXT:    negb %r10b
; AVX512-NEXT:    kshiftrw $2, %k1, %k2
; AVX512-NEXT:    kmovd %k2, %r11d
; AVX512-NEXT:    andb $1, %r11b
; AVX512-NEXT:    negb %r11b
; AVX512-NEXT:    kshiftrw $2, %k0, %k2
; AVX512-NEXT:    kmovd %k2, %ebx
; AVX512-NEXT:    andb $1, %bl
; AVX512-NEXT:    negb %bl
; AVX512-NEXT:    kshiftrw $1, %k0, %k2
; AVX512-NEXT:    kmovd %k2, %esi
; AVX512-NEXT:    andb $1, %sil
; AVX512-NEXT:    negb %sil
; AVX512-NEXT:    kshiftrw $1, %k1, %k2
; AVX512-NEXT:    kmovd %k2, %edx
; AVX512-NEXT:    andb $1, %dl
; AVX512-NEXT:    negb %dl
; AVX512-NEXT:    kmovd %k1, %eax
; AVX512-NEXT:    andb $1, %al
; AVX512-NEXT:    negb %al
; AVX512-NEXT:    kmovd %k0, %ecx
; AVX512-NEXT:    andb $1, %cl
; AVX512-NEXT:    negb %cl
; AVX512-NEXT:    # kill: def $al killed $al killed $eax
; AVX512-NEXT:    imulb %cl
; AVX512-NEXT:    movl %eax, %r8d
; AVX512-NEXT:    seto %al
; AVX512-NEXT:    movl %r8d, %ecx
; AVX512-NEXT:    andb $1, %cl
; AVX512-NEXT:    negb %cl
; AVX512-NEXT:    cmpb %r8b, %cl
; AVX512-NEXT:    setne %cl
; AVX512-NEXT:    orb %al, %cl
; AVX512-NEXT:    setne %al
; AVX512-NEXT:    kmovd %eax, %k1
; AVX512-NEXT:    movw $-3, %ax
; AVX512-NEXT:    kmovd %eax, %k0
; AVX512-NEXT:    kandw %k0, %k1, %k1
; AVX512-NEXT:    movl %edx, %eax
; AVX512-NEXT:    imulb %sil
; AVX512-NEXT:    movl %eax, %edx
; AVX512-NEXT:    seto %al
; AVX512-NEXT:    movl %edx, %ecx
; AVX512-NEXT:    andb $1, %cl
; AVX512-NEXT:    negb %cl
; AVX512-NEXT:    cmpb %dl, %cl
; AVX512-NEXT:    setne %cl
; AVX512-NEXT:    orb %al, %cl
; AVX512-NEXT:    setne %al
; AVX512-NEXT:    kmovd %eax, %k2
; AVX512-NEXT:    kshiftlw $15, %k2, %k2
; AVX512-NEXT:    kshiftrw $14, %k2, %k2
; AVX512-NEXT:    korw %k2, %k1, %k2
; AVX512-NEXT:    movw $-5, %ax
; AVX512-NEXT:    kmovd %eax, %k1
; AVX512-NEXT:    kandw %k1, %k2, %k2
; AVX512-NEXT:    movl %r11d, %eax
; AVX512-NEXT:    imulb %bl
; AVX512-NEXT:    movl %eax, %esi
; AVX512-NEXT:    seto %al
; AVX512-NEXT:    movl %esi, %ecx
; AVX512-NEXT:    andb $1, %cl
; AVX512-NEXT:    negb %cl
; AVX512-NEXT:    cmpb %sil, %cl
; AVX512-NEXT:    setne %cl
; AVX512-NEXT:    orb %al, %cl
; AVX512-NEXT:    setne %al
; AVX512-NEXT:    kmovd %eax, %k3
; AVX512-NEXT:    kshiftlw $2, %k3, %k3
; AVX512-NEXT:    korw %k3, %k2, %k2
; AVX512-NEXT:    kshiftlw $13, %k2, %k2
; AVX512-NEXT:    kshiftrw $13, %k2, %k2
; AVX512-NEXT:    movl %r10d, %eax
; AVX512-NEXT:    imulb %r9b
; AVX512-NEXT:    # kill: def $al killed $al def $eax
; AVX512-NEXT:    seto %cl
; AVX512-NEXT:    movl %eax, %ebx
; AVX512-NEXT:    andb $1, %bl
; AVX512-NEXT:    negb %bl
; AVX512-NEXT:    cmpb %al, %bl
; AVX512-NEXT:    setne %bl
; AVX512-NEXT:    orb %cl, %bl
; AVX512-NEXT:    setne %cl
; AVX512-NEXT:    kmovd %ecx, %k3
; AVX512-NEXT:    kshiftlw $3, %k3, %k3
; AVX512-NEXT:    korw %k3, %k2, %k2
; AVX512-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    vmovdqa32 %xmm0, %xmm0 {%k2} {z}
; AVX512-NEXT:    kmovd %r8d, %k2
; AVX512-NEXT:    kandw %k0, %k2, %k0
; AVX512-NEXT:    kmovd %edx, %k2
; AVX512-NEXT:    kshiftlw $15, %k2, %k2
; AVX512-NEXT:    kshiftrw $14, %k2, %k2
; AVX512-NEXT:    korw %k2, %k0, %k0
; AVX512-NEXT:    kandw %k1, %k0, %k0
; AVX512-NEXT:    kmovd %esi, %k1
; AVX512-NEXT:    kshiftlw $15, %k1, %k1
; AVX512-NEXT:    kshiftrw $13, %k1, %k1
; AVX512-NEXT:    korw %k1, %k0, %k0
; AVX512-NEXT:    movw $-9, %cx
; AVX512-NEXT:    kmovd %ecx, %k1
; AVX512-NEXT:    kandw %k1, %k0, %k0
; AVX512-NEXT:    kmovd %eax, %k1
; AVX512-NEXT:    kshiftlw $15, %k1, %k1
; AVX512-NEXT:    kshiftrw $12, %k1, %k1
; AVX512-NEXT:    korw %k1, %k0, %k0
; AVX512-NEXT:    kmovd %k0, %eax
; AVX512-NEXT:    movb %al, (%rdi)
; AVX512-NEXT:    popq %rbx
; AVX512-NEXT:    retq
  %t = call {<4 x i1>, <4 x i1>} @llvm.smul.with.overflow.v4i1(<4 x i1> %a0, <4 x i1> %a1)
  %val = extractvalue {<4 x i1>, <4 x i1>} %t, 0
  %obit = extractvalue {<4 x i1>, <4 x i1>} %t, 1
  %res = sext <4 x i1> %obit to <4 x i32>
  store <4 x i1> %val, <4 x i1>* %p2
  ret <4 x i32> %res
}

define <2 x i32> @smulo_v2i128(<2 x i128> %a0, <2 x i128> %a1, <2 x i128>* %p2) nounwind {
; SSE2-LABEL: smulo_v2i128:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pushq %rbp
; SSE2-NEXT:    pushq %r15
; SSE2-NEXT:    pushq %r14
; SSE2-NEXT:    pushq %r13
; SSE2-NEXT:    pushq %r12
; SSE2-NEXT:    pushq %rbx
; SSE2-NEXT:    subq $24, %rsp
; SSE2-NEXT:    movq %r8, %rax
; SSE2-NEXT:    movq %rcx, %r14
; SSE2-NEXT:    movq %rdx, %rbx
; SSE2-NEXT:    movq {{[0-9]+}}(%rsp), %r15
; SSE2-NEXT:    movq {{[0-9]+}}(%rsp), %r12
; SSE2-NEXT:    movq $0, {{[0-9]+}}(%rsp)
; SSE2-NEXT:    leaq {{[0-9]+}}(%rsp), %r8
; SSE2-NEXT:    movq %rax, %rdx
; SSE2-NEXT:    movq %r9, %rcx
; SSE2-NEXT:    callq __muloti4
; SSE2-NEXT:    movq %rax, %r13
; SSE2-NEXT:    movq %rdx, %rbp
; SSE2-NEXT:    movq $0, {{[0-9]+}}(%rsp)
; SSE2-NEXT:    leaq {{[0-9]+}}(%rsp), %r8
; SSE2-NEXT:    movq %rbx, %rdi
; SSE2-NEXT:    movq %r14, %rsi
; SSE2-NEXT:    movq {{[0-9]+}}(%rsp), %rdx
; SSE2-NEXT:    movq %r12, %rcx
; SSE2-NEXT:    callq __muloti4
; SSE2-NEXT:    xorl %ecx, %ecx
; SSE2-NEXT:    cmpq {{[0-9]+}}(%rsp), %rcx
; SSE2-NEXT:    sbbl %esi, %esi
; SSE2-NEXT:    movd %esi, %xmm1
; SSE2-NEXT:    cmpq {{[0-9]+}}(%rsp), %rcx
; SSE2-NEXT:    sbbl %ecx, %ecx
; SSE2-NEXT:    movd %ecx, %xmm0
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    movq %rdx, 24(%r15)
; SSE2-NEXT:    movq %rax, 16(%r15)
; SSE2-NEXT:    movq %rbp, 8(%r15)
; SSE2-NEXT:    movq %r13, (%r15)
; SSE2-NEXT:    addq $24, %rsp
; SSE2-NEXT:    popq %rbx
; SSE2-NEXT:    popq %r12
; SSE2-NEXT:    popq %r13
; SSE2-NEXT:    popq %r14
; SSE2-NEXT:    popq %r15
; SSE2-NEXT:    popq %rbp
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: smulo_v2i128:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    pushq %rbp
; SSSE3-NEXT:    pushq %r15
; SSSE3-NEXT:    pushq %r14
; SSSE3-NEXT:    pushq %r13
; SSSE3-NEXT:    pushq %r12
; SSSE3-NEXT:    pushq %rbx
; SSSE3-NEXT:    subq $24, %rsp
; SSSE3-NEXT:    movq %r8, %rax
; SSSE3-NEXT:    movq %rcx, %r14
; SSSE3-NEXT:    movq %rdx, %rbx
; SSSE3-NEXT:    movq {{[0-9]+}}(%rsp), %r15
; SSSE3-NEXT:    movq {{[0-9]+}}(%rsp), %r12
; SSSE3-NEXT:    movq $0, {{[0-9]+}}(%rsp)
; SSSE3-NEXT:    leaq {{[0-9]+}}(%rsp), %r8
; SSSE3-NEXT:    movq %rax, %rdx
; SSSE3-NEXT:    movq %r9, %rcx
; SSSE3-NEXT:    callq __muloti4
; SSSE3-NEXT:    movq %rax, %r13
; SSSE3-NEXT:    movq %rdx, %rbp
; SSSE3-NEXT:    movq $0, {{[0-9]+}}(%rsp)
; SSSE3-NEXT:    leaq {{[0-9]+}}(%rsp), %r8
; SSSE3-NEXT:    movq %rbx, %rdi
; SSSE3-NEXT:    movq %r14, %rsi
; SSSE3-NEXT:    movq {{[0-9]+}}(%rsp), %rdx
; SSSE3-NEXT:    movq %r12, %rcx
; SSSE3-NEXT:    callq __muloti4
; SSSE3-NEXT:    xorl %ecx, %ecx
; SSSE3-NEXT:    cmpq {{[0-9]+}}(%rsp), %rcx
; SSSE3-NEXT:    sbbl %esi, %esi
; SSSE3-NEXT:    movd %esi, %xmm1
; SSSE3-NEXT:    cmpq {{[0-9]+}}(%rsp), %rcx
; SSSE3-NEXT:    sbbl %ecx, %ecx
; SSSE3-NEXT:    movd %ecx, %xmm0
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSSE3-NEXT:    movq %rdx, 24(%r15)
; SSSE3-NEXT:    movq %rax, 16(%r15)
; SSSE3-NEXT:    movq %rbp, 8(%r15)
; SSSE3-NEXT:    movq %r13, (%r15)
; SSSE3-NEXT:    addq $24, %rsp
; SSSE3-NEXT:    popq %rbx
; SSSE3-NEXT:    popq %r12
; SSSE3-NEXT:    popq %r13
; SSSE3-NEXT:    popq %r14
; SSSE3-NEXT:    popq %r15
; SSSE3-NEXT:    popq %rbp
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: smulo_v2i128:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pushq %rbp
; SSE41-NEXT:    pushq %r15
; SSE41-NEXT:    pushq %r14
; SSE41-NEXT:    pushq %r13
; SSE41-NEXT:    pushq %r12
; SSE41-NEXT:    pushq %rbx
; SSE41-NEXT:    subq $24, %rsp
; SSE41-NEXT:    movq %r8, %rax
; SSE41-NEXT:    movq %rcx, %r14
; SSE41-NEXT:    movq %rdx, %rbx
; SSE41-NEXT:    movq {{[0-9]+}}(%rsp), %r15
; SSE41-NEXT:    movq {{[0-9]+}}(%rsp), %r12
; SSE41-NEXT:    movq $0, {{[0-9]+}}(%rsp)
; SSE41-NEXT:    leaq {{[0-9]+}}(%rsp), %r8
; SSE41-NEXT:    movq %rax, %rdx
; SSE41-NEXT:    movq %r9, %rcx
; SSE41-NEXT:    callq __muloti4
; SSE41-NEXT:    movq %rax, %r13
; SSE41-NEXT:    movq %rdx, %rbp
; SSE41-NEXT:    movq $0, {{[0-9]+}}(%rsp)
; SSE41-NEXT:    leaq {{[0-9]+}}(%rsp), %r8
; SSE41-NEXT:    movq %rbx, %rdi
; SSE41-NEXT:    movq %r14, %rsi
; SSE41-NEXT:    movq {{[0-9]+}}(%rsp), %rdx
; SSE41-NEXT:    movq %r12, %rcx
; SSE41-NEXT:    callq __muloti4
; SSE41-NEXT:    xorl %ecx, %ecx
; SSE41-NEXT:    cmpq {{[0-9]+}}(%rsp), %rcx
; SSE41-NEXT:    sbbl %esi, %esi
; SSE41-NEXT:    cmpq {{[0-9]+}}(%rsp), %rcx
; SSE41-NEXT:    sbbl %ecx, %ecx
; SSE41-NEXT:    movd %ecx, %xmm0
; SSE41-NEXT:    pinsrd $1, %esi, %xmm0
; SSE41-NEXT:    movq %rdx, 24(%r15)
; SSE41-NEXT:    movq %rax, 16(%r15)
; SSE41-NEXT:    movq %rbp, 8(%r15)
; SSE41-NEXT:    movq %r13, (%r15)
; SSE41-NEXT:    addq $24, %rsp
; SSE41-NEXT:    popq %rbx
; SSE41-NEXT:    popq %r12
; SSE41-NEXT:    popq %r13
; SSE41-NEXT:    popq %r14
; SSE41-NEXT:    popq %r15
; SSE41-NEXT:    popq %rbp
; SSE41-NEXT:    retq
;
; AVX1-LABEL: smulo_v2i128:
; AVX1:       # %bb.0:
; AVX1-NEXT:    pushq %rbp
; AVX1-NEXT:    pushq %r15
; AVX1-NEXT:    pushq %r14
; AVX1-NEXT:    pushq %r13
; AVX1-NEXT:    pushq %r12
; AVX1-NEXT:    pushq %rbx
; AVX1-NEXT:    subq $24, %rsp
; AVX1-NEXT:    movq %r8, %rax
; AVX1-NEXT:    movq %rcx, %r14
; AVX1-NEXT:    movq %rdx, %rbx
; AVX1-NEXT:    movq {{[0-9]+}}(%rsp), %r15
; AVX1-NEXT:    movq {{[0-9]+}}(%rsp), %r12
; AVX1-NEXT:    movq $0, {{[0-9]+}}(%rsp)
; AVX1-NEXT:    leaq {{[0-9]+}}(%rsp), %r8
; AVX1-NEXT:    movq %rax, %rdx
; AVX1-NEXT:    movq %r9, %rcx
; AVX1-NEXT:    callq __muloti4
; AVX1-NEXT:    movq %rax, %r13
; AVX1-NEXT:    movq %rdx, %rbp
; AVX1-NEXT:    movq $0, {{[0-9]+}}(%rsp)
; AVX1-NEXT:    leaq {{[0-9]+}}(%rsp), %r8
; AVX1-NEXT:    movq %rbx, %rdi
; AVX1-NEXT:    movq %r14, %rsi
; AVX1-NEXT:    movq {{[0-9]+}}(%rsp), %rdx
; AVX1-NEXT:    movq %r12, %rcx
; AVX1-NEXT:    callq __muloti4
; AVX1-NEXT:    xorl %ecx, %ecx
; AVX1-NEXT:    cmpq {{[0-9]+}}(%rsp), %rcx
; AVX1-NEXT:    sbbl %esi, %esi
; AVX1-NEXT:    cmpq {{[0-9]+}}(%rsp), %rcx
; AVX1-NEXT:    sbbl %ecx, %ecx
; AVX1-NEXT:    vmovd %ecx, %xmm0
; AVX1-NEXT:    vpinsrd $1, %esi, %xmm0, %xmm0
; AVX1-NEXT:    movq %rdx, 24(%r15)
; AVX1-NEXT:    movq %rax, 16(%r15)
; AVX1-NEXT:    movq %rbp, 8(%r15)
; AVX1-NEXT:    movq %r13, (%r15)
; AVX1-NEXT:    addq $24, %rsp
; AVX1-NEXT:    popq %rbx
; AVX1-NEXT:    popq %r12
; AVX1-NEXT:    popq %r13
; AVX1-NEXT:    popq %r14
; AVX1-NEXT:    popq %r15
; AVX1-NEXT:    popq %rbp
; AVX1-NEXT:    retq
;
; AVX2-LABEL: smulo_v2i128:
; AVX2:       # %bb.0:
; AVX2-NEXT:    pushq %rbp
; AVX2-NEXT:    pushq %r15
; AVX2-NEXT:    pushq %r14
; AVX2-NEXT:    pushq %r13
; AVX2-NEXT:    pushq %r12
; AVX2-NEXT:    pushq %rbx
; AVX2-NEXT:    subq $24, %rsp
; AVX2-NEXT:    movq %r8, %rax
; AVX2-NEXT:    movq %rcx, %r14
; AVX2-NEXT:    movq %rdx, %rbx
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %r15
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %r12
; AVX2-NEXT:    movq $0, {{[0-9]+}}(%rsp)
; AVX2-NEXT:    leaq {{[0-9]+}}(%rsp), %r8
; AVX2-NEXT:    movq %rax, %rdx
; AVX2-NEXT:    movq %r9, %rcx
; AVX2-NEXT:    callq __muloti4
; AVX2-NEXT:    movq %rax, %r13
; AVX2-NEXT:    movq %rdx, %rbp
; AVX2-NEXT:    movq $0, {{[0-9]+}}(%rsp)
; AVX2-NEXT:    leaq {{[0-9]+}}(%rsp), %r8
; AVX2-NEXT:    movq %rbx, %rdi
; AVX2-NEXT:    movq %r14, %rsi
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %rdx
; AVX2-NEXT:    movq %r12, %rcx
; AVX2-NEXT:    callq __muloti4
; AVX2-NEXT:    xorl %ecx, %ecx
; AVX2-NEXT:    cmpq {{[0-9]+}}(%rsp), %rcx
; AVX2-NEXT:    sbbl %esi, %esi
; AVX2-NEXT:    cmpq {{[0-9]+}}(%rsp), %rcx
; AVX2-NEXT:    sbbl %ecx, %ecx
; AVX2-NEXT:    vmovd %ecx, %xmm0
; AVX2-NEXT:    vpinsrd $1, %esi, %xmm0, %xmm0
; AVX2-NEXT:    movq %rdx, 24(%r15)
; AVX2-NEXT:    movq %rax, 16(%r15)
; AVX2-NEXT:    movq %rbp, 8(%r15)
; AVX2-NEXT:    movq %r13, (%r15)
; AVX2-NEXT:    addq $24, %rsp
; AVX2-NEXT:    popq %rbx
; AVX2-NEXT:    popq %r12
; AVX2-NEXT:    popq %r13
; AVX2-NEXT:    popq %r14
; AVX2-NEXT:    popq %r15
; AVX2-NEXT:    popq %rbp
; AVX2-NEXT:    retq
;
; AVX512-LABEL: smulo_v2i128:
; AVX512:       # %bb.0:
; AVX512-NEXT:    pushq %rbp
; AVX512-NEXT:    pushq %r15
; AVX512-NEXT:    pushq %r14
; AVX512-NEXT:    pushq %r13
; AVX512-NEXT:    pushq %r12
; AVX512-NEXT:    pushq %rbx
; AVX512-NEXT:    subq $24, %rsp
; AVX512-NEXT:    movq %r8, %rax
; AVX512-NEXT:    movq %rcx, %r15
; AVX512-NEXT:    movq %rdx, %rbx
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %r12
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %r13
; AVX512-NEXT:    movq $0, {{[0-9]+}}(%rsp)
; AVX512-NEXT:    leaq {{[0-9]+}}(%rsp), %r8
; AVX512-NEXT:    movq %rax, %rdx
; AVX512-NEXT:    movq %r9, %rcx
; AVX512-NEXT:    callq __muloti4
; AVX512-NEXT:    movq %rax, %r14
; AVX512-NEXT:    movq %rdx, %rbp
; AVX512-NEXT:    movq $0, {{[0-9]+}}(%rsp)
; AVX512-NEXT:    leaq {{[0-9]+}}(%rsp), %r8
; AVX512-NEXT:    movq %rbx, %rdi
; AVX512-NEXT:    movq %r15, %rsi
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rdx
; AVX512-NEXT:    movq %r13, %rcx
; AVX512-NEXT:    callq __muloti4
; AVX512-NEXT:    cmpq $0, {{[0-9]+}}(%rsp)
; AVX512-NEXT:    setne %cl
; AVX512-NEXT:    kmovd %ecx, %k0
; AVX512-NEXT:    cmpq $0, {{[0-9]+}}(%rsp)
; AVX512-NEXT:    setne %cl
; AVX512-NEXT:    kshiftlw $1, %k0, %k0
; AVX512-NEXT:    andl $1, %ecx
; AVX512-NEXT:    kmovw %ecx, %k1
; AVX512-NEXT:    korw %k0, %k1, %k1
; AVX512-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    vmovdqa32 %xmm0, %xmm0 {%k1} {z}
; AVX512-NEXT:    movq %rdx, 24(%r12)
; AVX512-NEXT:    movq %rax, 16(%r12)
; AVX512-NEXT:    movq %rbp, 8(%r12)
; AVX512-NEXT:    movq %r14, (%r12)
; AVX512-NEXT:    addq $24, %rsp
; AVX512-NEXT:    popq %rbx
; AVX512-NEXT:    popq %r12
; AVX512-NEXT:    popq %r13
; AVX512-NEXT:    popq %r14
; AVX512-NEXT:    popq %r15
; AVX512-NEXT:    popq %rbp
; AVX512-NEXT:    retq
  %t = call {<2 x i128>, <2 x i1>} @llvm.smul.with.overflow.v2i128(<2 x i128> %a0, <2 x i128> %a1)
  %val = extractvalue {<2 x i128>, <2 x i1>} %t, 0
  %obit = extractvalue {<2 x i128>, <2 x i1>} %t, 1
  %res = sext <2 x i1> %obit to <2 x i32>
  store <2 x i128> %val, <2 x i128>* %p2
  ret <2 x i32> %res
}
