; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumbv8.1m.main-none-none-eabi -mattr=+mve.fp,+fp64 -mve-max-interleave-factor=4 -verify-machineinstrs %s -o - | FileCheck %s

; i32

define void @vld4_v2i32(<8 x i32> *%src, <2 x i32> *%dst) {
; CHECK-LABEL: vld4_v2i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrw.u32 q0, [r0]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #16]
; CHECK-NEXT:    vmov.f32 s8, s3
; CHECK-NEXT:    vmov.32 r3, q1[0]
; CHECK-NEXT:    vmov.f32 s10, s7
; CHECK-NEXT:    vmov r2, s6
; CHECK-NEXT:    vmov.f32 s12, s1
; CHECK-NEXT:    vmov.f32 s14, s5
; CHECK-NEXT:    vdup.32 q1, r3
; CHECK-NEXT:    vmov r3, s6
; CHECK-NEXT:    vmov r0, s10
; CHECK-NEXT:    add r0, r2
; CHECK-NEXT:    vmov r2, s14
; CHECK-NEXT:    add r2, r3
; CHECK-NEXT:    vmov r3, s0
; CHECK-NEXT:    add r0, r2
; CHECK-NEXT:    vmov.32 r2, q0[2]
; CHECK-NEXT:    vdup.32 q1, r2
; CHECK-NEXT:    str r0, [r1, #4]
; CHECK-NEXT:    vmov r0, s8
; CHECK-NEXT:    vmov r2, s4
; CHECK-NEXT:    add r0, r2
; CHECK-NEXT:    vmov r2, s12
; CHECK-NEXT:    add r2, r3
; CHECK-NEXT:    add r0, r2
; CHECK-NEXT:    str r0, [r1]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <8 x i32>, <8 x i32>* %src, align 4
  %s1 = shufflevector <8 x i32> %l1, <8 x i32> undef, <2 x i32> <i32 0, i32 4>
  %s2 = shufflevector <8 x i32> %l1, <8 x i32> undef, <2 x i32> <i32 1, i32 5>
  %s3 = shufflevector <8 x i32> %l1, <8 x i32> undef, <2 x i32> <i32 2, i32 6>
  %s4 = shufflevector <8 x i32> %l1, <8 x i32> undef, <2 x i32> <i32 3, i32 7>
  %a1 = add <2 x i32> %s1, %s2
  %a2 = add <2 x i32> %s3, %s4
  %a3 = add <2 x i32> %a1, %a2
  store <2 x i32> %a3, <2 x i32> *%dst
  ret void
}

define void @vld4_v4i32(<16 x i32> *%src, <4 x i32> *%dst) {
; CHECK-LABEL: vld4_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9}
; CHECK-NEXT:    vpush {d8, d9}
; CHECK-NEXT:    vld40.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld41.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld42.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld43.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    @ kill: def $q0 killed $q0 killed $q0_q1_q2_q3
; CHECK-NEXT:    vadd.i32 q4, q2, q3
; CHECK-NEXT:    vadd.i32 q0, q0, q1
; CHECK-NEXT:    vadd.i32 q0, q0, q4
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    vpop {d8, d9}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <16 x i32>, <16 x i32>* %src, align 4
  %s1 = shufflevector <16 x i32> %l1, <16 x i32> undef, <4 x i32> <i32 0, i32 4, i32 8, i32 12>
  %s2 = shufflevector <16 x i32> %l1, <16 x i32> undef, <4 x i32> <i32 1, i32 5, i32 9, i32 13>
  %s3 = shufflevector <16 x i32> %l1, <16 x i32> undef, <4 x i32> <i32 2, i32 6, i32 10, i32 14>
  %s4 = shufflevector <16 x i32> %l1, <16 x i32> undef, <4 x i32> <i32 3, i32 7, i32 11, i32 15>
  %a1 = add <4 x i32> %s1, %s2
  %a2 = add <4 x i32> %s3, %s4
  %a3 = add <4 x i32> %a1, %a2
  store <4 x i32> %a3, <4 x i32> *%dst
  ret void
}

define void @vld4_v8i32(<32 x i32> *%src, <8 x i32> *%dst) {
; CHECK-LABEL: vld4_v8i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    vld40.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld41.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld42.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld43.32 {q0, q1, q2, q3}, [r0]!
; CHECK-NEXT:    @ kill: def $q0 killed $q0 killed $q0_q1_q2_q3
; CHECK-NEXT:    vadd.i32 q6, q2, q3
; CHECK-NEXT:    vadd.i32 q0, q0, q1
; CHECK-NEXT:    vld40.32 {q1, q2, q3, q4}, [r0]
; CHECK-NEXT:    vadd.i32 q0, q0, q6
; CHECK-NEXT:    vld41.32 {q1, q2, q3, q4}, [r0]
; CHECK-NEXT:    vld42.32 {q1, q2, q3, q4}, [r0]
; CHECK-NEXT:    vld43.32 {q1, q2, q3, q4}, [r0]
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    @ kill: def $q1 killed $q1 killed $q1_q2_q3_q4
; CHECK-NEXT:    vadd.i32 q5, q3, q4
; CHECK-NEXT:    vadd.i32 q1, q1, q2
; CHECK-NEXT:    vadd.i32 q1, q1, q5
; CHECK-NEXT:    vstrw.32 q1, [r1, #16]
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <32 x i32>, <32 x i32>* %src, align 4
  %s1 = shufflevector <32 x i32> %l1, <32 x i32> undef, <8 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 28>
  %s2 = shufflevector <32 x i32> %l1, <32 x i32> undef, <8 x i32> <i32 1, i32 5, i32 9, i32 13, i32 17, i32 21, i32 25, i32 29>
  %s3 = shufflevector <32 x i32> %l1, <32 x i32> undef, <8 x i32> <i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 30>
  %s4 = shufflevector <32 x i32> %l1, <32 x i32> undef, <8 x i32> <i32 3, i32 7, i32 11, i32 15, i32 19, i32 23, i32 27, i32 31>
  %a1 = add <8 x i32> %s1, %s2
  %a2 = add <8 x i32> %s3, %s4
  %a3 = add <8 x i32> %a1, %a2
  store <8 x i32> %a3, <8 x i32> *%dst
  ret void
}

define void @vld4_v16i32(<64 x i32> *%src, <16 x i32> *%dst) {
; CHECK-LABEL: vld4_v16i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5}
; CHECK-NEXT:    push {r4, r5}
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    .pad #136
; CHECK-NEXT:    sub sp, #136
; CHECK-NEXT:    vld40.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    mov r2, r0
; CHECK-NEXT:    add.w r3, r0, #192
; CHECK-NEXT:    vld41.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld42.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    adds r0, #128
; CHECK-NEXT:    vld43.32 {q0, q1, q2, q3}, [r2]!
; CHECK-NEXT:    @ kill: def $q0 killed $q0 killed $q0_q1_q2_q3
; CHECK-NEXT:    vadd.i32 q4, q2, q3
; CHECK-NEXT:    vadd.i32 q0, q0, q1
; CHECK-NEXT:    vstrw.32 q4, [sp, #112] @ 16-byte Spill
; CHECK-NEXT:    vstrw.32 q0, [sp, #96] @ 16-byte Spill
; CHECK-NEXT:    vld40.32 {q1, q2, q3, q4}, [r3]
; CHECK-NEXT:    vld41.32 {q1, q2, q3, q4}, [r3]
; CHECK-NEXT:    vld42.32 {q1, q2, q3, q4}, [r3]
; CHECK-NEXT:    vld43.32 {q1, q2, q3, q4}, [r3]
; CHECK-NEXT:    vldrw.u32 q6, [sp, #112] @ 16-byte Reload
; CHECK-NEXT:    vldrw.u32 q5, [sp, #96] @ 16-byte Reload
; CHECK-NEXT:    vstrw.32 q4, [sp, #80] @ 16-byte Spill
; CHECK-NEXT:    vmov q0, q1
; CHECK-NEXT:    vadd.i32 q6, q5, q6
; CHECK-NEXT:    vldrw.u32 q5, [sp, #80] @ 16-byte Reload
; CHECK-NEXT:    vadd.i32 q0, q0, q2
; CHECK-NEXT:    vstrw.32 q6, [sp, #112] @ 16-byte Spill
; CHECK-NEXT:    vadd.i32 q1, q3, q5
; CHECK-NEXT:    vadd.i32 q0, q0, q1
; CHECK-NEXT:    vstrw.32 q0, [sp, #96] @ 16-byte Spill
; CHECK-NEXT:    vld40.32 {q0, q1, q2, q3}, [r2]
; CHECK-NEXT:    vld41.32 {q0, q1, q2, q3}, [r2]
; CHECK-NEXT:    vld42.32 {q0, q1, q2, q3}, [r2]
; CHECK-NEXT:    vld43.32 {q0, q1, q2, q3}, [r2]
; CHECK-NEXT:    vstmia sp, {d0, d1, d2, d3, d4, d5, d6, d7} @ 64-byte Spill
; CHECK-NEXT:    vld40.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld41.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld42.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld43.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    @ kill: def $q0 killed $q0 killed $q0_q1_q2_q3
; CHECK-NEXT:    vstrw.32 q3, [sp, #80] @ 16-byte Spill
; CHECK-NEXT:    vmov q5, q1
; CHECK-NEXT:    vldrw.u32 q1, [sp, #80] @ 16-byte Reload
; CHECK-NEXT:    vadd.i32 q0, q0, q5
; CHECK-NEXT:    vldmia sp, {d6, d7, d8, d9, d10, d11, d12, d13} @ 64-byte Reload
; CHECK-NEXT:    vadd.i32 q1, q2, q1
; CHECK-NEXT:    @ kill: def $q3 killed $q3 killed $q3_q4_q5_q6
; CHECK-NEXT:    vadd.i32 q2, q3, q4
; CHECK-NEXT:    vadd.i32 q0, q0, q1
; CHECK-NEXT:    vadd.i32 q1, q5, q6
; CHECK-NEXT:    vadd.i32 q1, q2, q1
; CHECK-NEXT:    vldrw.u32 q2, [sp, #96] @ 16-byte Reload
; CHECK-NEXT:    vstrw.32 q0, [r1, #32]
; CHECK-NEXT:    vldrw.u32 q0, [sp, #112] @ 16-byte Reload
; CHECK-NEXT:    vstrw.32 q2, [r1, #48]
; CHECK-NEXT:    vstrw.32 q1, [r1, #16]
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    add sp, #136
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    pop {r4, r5}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <64 x i32>, <64 x i32>* %src, align 4
  %s1 = shufflevector <64 x i32> %l1, <64 x i32> undef, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 28, i32 32, i32 36, i32 40, i32 44, i32 48, i32 52, i32 56, i32 60>
  %s2 = shufflevector <64 x i32> %l1, <64 x i32> undef, <16 x i32> <i32 1, i32 5, i32 9, i32 13, i32 17, i32 21, i32 25, i32 29, i32 33, i32 37, i32 41, i32 45, i32 49, i32 53, i32 57, i32 61>
  %s3 = shufflevector <64 x i32> %l1, <64 x i32> undef, <16 x i32> <i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 30, i32 34, i32 38, i32 42, i32 46, i32 50, i32 54, i32 58, i32 62>
  %s4 = shufflevector <64 x i32> %l1, <64 x i32> undef, <16 x i32> <i32 3, i32 7, i32 11, i32 15, i32 19, i32 23, i32 27, i32 31, i32 35, i32 39, i32 43, i32 47, i32 51, i32 55, i32 59, i32 63>
  %a1 = add <16 x i32> %s1, %s2
  %a2 = add <16 x i32> %s3, %s4
  %a3 = add <16 x i32> %a1, %a2
  store <16 x i32> %a3, <16 x i32> *%dst
  ret void
}

; i16

define void @vld4_v2i16(<8 x i16> *%src, <2 x i16> *%dst) {
; CHECK-LABEL: vld4_v2i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrw.u32 q0, [r0]
; CHECK-NEXT:    vmov.u16 r0, q0[7]
; CHECK-NEXT:    vmov.u16 r2, q0[6]
; CHECK-NEXT:    add r0, r2
; CHECK-NEXT:    vmov.u16 r2, q0[5]
; CHECK-NEXT:    vmov.u16 r3, q0[4]
; CHECK-NEXT:    add r2, r3
; CHECK-NEXT:    vmov.u16 r3, q0[0]
; CHECK-NEXT:    add r0, r2
; CHECK-NEXT:    strh r0, [r1, #2]
; CHECK-NEXT:    vmov.u16 r0, q0[3]
; CHECK-NEXT:    vmov.u16 r2, q0[2]
; CHECK-NEXT:    add r0, r2
; CHECK-NEXT:    vmov.u16 r2, q0[1]
; CHECK-NEXT:    add r2, r3
; CHECK-NEXT:    add r0, r2
; CHECK-NEXT:    strh r0, [r1]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <8 x i16>, <8 x i16>* %src, align 4
  %s1 = shufflevector <8 x i16> %l1, <8 x i16> undef, <2 x i32> <i32 0, i32 4>
  %s2 = shufflevector <8 x i16> %l1, <8 x i16> undef, <2 x i32> <i32 1, i32 5>
  %s3 = shufflevector <8 x i16> %l1, <8 x i16> undef, <2 x i32> <i32 2, i32 6>
  %s4 = shufflevector <8 x i16> %l1, <8 x i16> undef, <2 x i32> <i32 3, i32 7>
  %a1 = add <2 x i16> %s1, %s2
  %a2 = add <2 x i16> %s3, %s4
  %a3 = add <2 x i16> %a1, %a2
  store <2 x i16> %a3, <2 x i16> *%dst
  ret void
}

define void @vld4_v4i16(<16 x i16> *%src, <4 x i16> *%dst) {
; CHECK-LABEL: vld4_v4i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9}
; CHECK-NEXT:    vpush {d8, d9}
; CHECK-NEXT:    vldrw.u32 q1, [r0]
; CHECK-NEXT:    vldrw.u32 q0, [r0, #16]
; CHECK-NEXT:    vmov.u16 r2, q1[3]
; CHECK-NEXT:    vmov.u16 r0, q0[3]
; CHECK-NEXT:    vmov.32 q2[0], r2
; CHECK-NEXT:    vmov.u16 r2, q1[7]
; CHECK-NEXT:    vmov.32 q2[1], r2
; CHECK-NEXT:    vmov.32 q2[2], r0
; CHECK-NEXT:    vmov.u16 r0, q0[7]
; CHECK-NEXT:    vmov.32 q2[3], r0
; CHECK-NEXT:    vmov.u16 r0, q1[2]
; CHECK-NEXT:    vmov.32 q3[0], r0
; CHECK-NEXT:    vmov.u16 r0, q1[6]
; CHECK-NEXT:    vmov.32 q3[1], r0
; CHECK-NEXT:    vmov.u16 r0, q0[2]
; CHECK-NEXT:    vmov.32 q3[2], r0
; CHECK-NEXT:    vmov.u16 r0, q0[6]
; CHECK-NEXT:    vmov.32 q3[3], r0
; CHECK-NEXT:    vmov.u16 r0, q1[0]
; CHECK-NEXT:    vadd.i32 q2, q3, q2
; CHECK-NEXT:    vmov.32 q3[0], r0
; CHECK-NEXT:    vmov.u16 r0, q1[4]
; CHECK-NEXT:    vmov.32 q3[1], r0
; CHECK-NEXT:    vmov.u16 r0, q0[0]
; CHECK-NEXT:    vmov.32 q3[2], r0
; CHECK-NEXT:    vmov.u16 r0, q1[1]
; CHECK-NEXT:    vmov.32 q4[0], r0
; CHECK-NEXT:    vmov.u16 r0, q1[5]
; CHECK-NEXT:    vmov.32 q4[1], r0
; CHECK-NEXT:    vmov.u16 r0, q0[1]
; CHECK-NEXT:    vmov.32 q4[2], r0
; CHECK-NEXT:    vmov.u16 r0, q0[5]
; CHECK-NEXT:    vmov.32 q4[3], r0
; CHECK-NEXT:    vmov.u16 r0, q0[4]
; CHECK-NEXT:    vmov.32 q3[3], r0
; CHECK-NEXT:    vadd.i32 q0, q3, q4
; CHECK-NEXT:    vadd.i32 q0, q0, q2
; CHECK-NEXT:    vstrh.32 q0, [r1]
; CHECK-NEXT:    vpop {d8, d9}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <16 x i16>, <16 x i16>* %src, align 4
  %s1 = shufflevector <16 x i16> %l1, <16 x i16> undef, <4 x i32> <i32 0, i32 4, i32 8, i32 12>
  %s2 = shufflevector <16 x i16> %l1, <16 x i16> undef, <4 x i32> <i32 1, i32 5, i32 9, i32 13>
  %s3 = shufflevector <16 x i16> %l1, <16 x i16> undef, <4 x i32> <i32 2, i32 6, i32 10, i32 14>
  %s4 = shufflevector <16 x i16> %l1, <16 x i16> undef, <4 x i32> <i32 3, i32 7, i32 11, i32 15>
  %a1 = add <4 x i16> %s1, %s2
  %a2 = add <4 x i16> %s3, %s4
  %a3 = add <4 x i16> %a1, %a2
  store <4 x i16> %a3, <4 x i16> *%dst
  ret void
}

define void @vld4_v8i16(<32 x i16> *%src, <8 x i16> *%dst) {
; CHECK-LABEL: vld4_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9}
; CHECK-NEXT:    vpush {d8, d9}
; CHECK-NEXT:    vld40.16 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld41.16 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld42.16 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld43.16 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    @ kill: def $q0 killed $q0 killed $q0_q1_q2_q3
; CHECK-NEXT:    vadd.i16 q4, q2, q3
; CHECK-NEXT:    vadd.i16 q0, q0, q1
; CHECK-NEXT:    vadd.i16 q0, q0, q4
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    vpop {d8, d9}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <32 x i16>, <32 x i16>* %src, align 4
  %s1 = shufflevector <32 x i16> %l1, <32 x i16> undef, <8 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 28>
  %s2 = shufflevector <32 x i16> %l1, <32 x i16> undef, <8 x i32> <i32 1, i32 5, i32 9, i32 13, i32 17, i32 21, i32 25, i32 29>
  %s3 = shufflevector <32 x i16> %l1, <32 x i16> undef, <8 x i32> <i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 30>
  %s4 = shufflevector <32 x i16> %l1, <32 x i16> undef, <8 x i32> <i32 3, i32 7, i32 11, i32 15, i32 19, i32 23, i32 27, i32 31>
  %a1 = add <8 x i16> %s1, %s2
  %a2 = add <8 x i16> %s3, %s4
  %a3 = add <8 x i16> %a1, %a2
  store <8 x i16> %a3, <8 x i16> *%dst
  ret void
}

define void @vld4_v16i16(<64 x i16> *%src, <16 x i16> *%dst) {
; CHECK-LABEL: vld4_v16i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    vld40.16 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld41.16 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld42.16 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld43.16 {q0, q1, q2, q3}, [r0]!
; CHECK-NEXT:    @ kill: def $q0 killed $q0 killed $q0_q1_q2_q3
; CHECK-NEXT:    vadd.i16 q6, q2, q3
; CHECK-NEXT:    vadd.i16 q0, q0, q1
; CHECK-NEXT:    vld40.16 {q1, q2, q3, q4}, [r0]
; CHECK-NEXT:    vadd.i16 q0, q0, q6
; CHECK-NEXT:    vld41.16 {q1, q2, q3, q4}, [r0]
; CHECK-NEXT:    vld42.16 {q1, q2, q3, q4}, [r0]
; CHECK-NEXT:    vld43.16 {q1, q2, q3, q4}, [r0]
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    @ kill: def $q1 killed $q1 killed $q1_q2_q3_q4
; CHECK-NEXT:    vadd.i16 q5, q3, q4
; CHECK-NEXT:    vadd.i16 q1, q1, q2
; CHECK-NEXT:    vadd.i16 q1, q1, q5
; CHECK-NEXT:    vstrw.32 q1, [r1, #16]
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <64 x i16>, <64 x i16>* %src, align 4
  %s1 = shufflevector <64 x i16> %l1, <64 x i16> undef, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 28, i32 32, i32 36, i32 40, i32 44, i32 48, i32 52, i32 56, i32 60>
  %s2 = shufflevector <64 x i16> %l1, <64 x i16> undef, <16 x i32> <i32 1, i32 5, i32 9, i32 13, i32 17, i32 21, i32 25, i32 29, i32 33, i32 37, i32 41, i32 45, i32 49, i32 53, i32 57, i32 61>
  %s3 = shufflevector <64 x i16> %l1, <64 x i16> undef, <16 x i32> <i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 30, i32 34, i32 38, i32 42, i32 46, i32 50, i32 54, i32 58, i32 62>
  %s4 = shufflevector <64 x i16> %l1, <64 x i16> undef, <16 x i32> <i32 3, i32 7, i32 11, i32 15, i32 19, i32 23, i32 27, i32 31, i32 35, i32 39, i32 43, i32 47, i32 51, i32 55, i32 59, i32 63>
  %a1 = add <16 x i16> %s1, %s2
  %a2 = add <16 x i16> %s3, %s4
  %a3 = add <16 x i16> %a1, %a2
  store <16 x i16> %a3, <16 x i16> *%dst
  ret void
}

; i8

define void @vld4_v2i8(<8 x i8> *%src, <2 x i8> *%dst) {
; CHECK-LABEL: vld4_v2i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrb.u16 q0, [r0]
; CHECK-NEXT:    vmov.u16 r0, q0[7]
; CHECK-NEXT:    vmov.u16 r2, q0[6]
; CHECK-NEXT:    add r0, r2
; CHECK-NEXT:    vmov.u16 r2, q0[5]
; CHECK-NEXT:    vmov.u16 r3, q0[4]
; CHECK-NEXT:    add r2, r3
; CHECK-NEXT:    vmov.u16 r3, q0[0]
; CHECK-NEXT:    add r0, r2
; CHECK-NEXT:    strb r0, [r1, #1]
; CHECK-NEXT:    vmov.u16 r0, q0[3]
; CHECK-NEXT:    vmov.u16 r2, q0[2]
; CHECK-NEXT:    add r0, r2
; CHECK-NEXT:    vmov.u16 r2, q0[1]
; CHECK-NEXT:    add r2, r3
; CHECK-NEXT:    add r0, r2
; CHECK-NEXT:    strb r0, [r1]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <8 x i8>, <8 x i8>* %src, align 4
  %s1 = shufflevector <8 x i8> %l1, <8 x i8> undef, <2 x i32> <i32 0, i32 4>
  %s2 = shufflevector <8 x i8> %l1, <8 x i8> undef, <2 x i32> <i32 1, i32 5>
  %s3 = shufflevector <8 x i8> %l1, <8 x i8> undef, <2 x i32> <i32 2, i32 6>
  %s4 = shufflevector <8 x i8> %l1, <8 x i8> undef, <2 x i32> <i32 3, i32 7>
  %a1 = add <2 x i8> %s1, %s2
  %a2 = add <2 x i8> %s3, %s4
  %a3 = add <2 x i8> %a1, %a2
  store <2 x i8> %a3, <2 x i8> *%dst
  ret void
}

define void @vld4_v4i8(<16 x i8> *%src, <4 x i8> *%dst) {
; CHECK-LABEL: vld4_v4i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrw.u32 q0, [r0]
; CHECK-NEXT:    vmov.u8 r0, q0[2]
; CHECK-NEXT:    vrev32.8 q2, q0
; CHECK-NEXT:    vmov.32 q1[0], r0
; CHECK-NEXT:    vmov.u8 r0, q0[6]
; CHECK-NEXT:    vmov.32 q1[1], r0
; CHECK-NEXT:    vmov.u8 r0, q0[10]
; CHECK-NEXT:    vmov.32 q1[2], r0
; CHECK-NEXT:    vmov.u8 r0, q0[14]
; CHECK-NEXT:    vmov.32 q1[3], r0
; CHECK-NEXT:    vadd.i32 q1, q1, q2
; CHECK-NEXT:    vrev16.8 q2, q0
; CHECK-NEXT:    vadd.i32 q0, q0, q2
; CHECK-NEXT:    vadd.i32 q0, q0, q1
; CHECK-NEXT:    vstrb.32 q0, [r1]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <16 x i8>, <16 x i8>* %src, align 4
  %s1 = shufflevector <16 x i8> %l1, <16 x i8> undef, <4 x i32> <i32 0, i32 4, i32 8, i32 12>
  %s2 = shufflevector <16 x i8> %l1, <16 x i8> undef, <4 x i32> <i32 1, i32 5, i32 9, i32 13>
  %s3 = shufflevector <16 x i8> %l1, <16 x i8> undef, <4 x i32> <i32 2, i32 6, i32 10, i32 14>
  %s4 = shufflevector <16 x i8> %l1, <16 x i8> undef, <4 x i32> <i32 3, i32 7, i32 11, i32 15>
  %a1 = add <4 x i8> %s1, %s2
  %a2 = add <4 x i8> %s3, %s4
  %a3 = add <4 x i8> %a1, %a2
  store <4 x i8> %a3, <4 x i8> *%dst
  ret void
}

define void @vld4_v8i8(<32 x i8> *%src, <8 x i8> *%dst) {
; CHECK-LABEL: vld4_v8i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9}
; CHECK-NEXT:    vpush {d8, d9}
; CHECK-NEXT:    vldrw.u32 q1, [r0]
; CHECK-NEXT:    vldrw.u32 q0, [r0, #16]
; CHECK-NEXT:    vmov.u8 r2, q1[3]
; CHECK-NEXT:    vmov.u8 r0, q0[3]
; CHECK-NEXT:    vmov.16 q2[0], r2
; CHECK-NEXT:    vmov.u8 r2, q1[7]
; CHECK-NEXT:    vmov.16 q2[1], r2
; CHECK-NEXT:    vmov.u8 r2, q1[11]
; CHECK-NEXT:    vmov.16 q2[2], r2
; CHECK-NEXT:    vmov.u8 r2, q1[15]
; CHECK-NEXT:    vmov.16 q2[3], r2
; CHECK-NEXT:    vmov.16 q2[4], r0
; CHECK-NEXT:    vmov.u8 r0, q0[7]
; CHECK-NEXT:    vmov.16 q2[5], r0
; CHECK-NEXT:    vmov.u8 r0, q0[11]
; CHECK-NEXT:    vmov.16 q2[6], r0
; CHECK-NEXT:    vmov.u8 r0, q0[15]
; CHECK-NEXT:    vmov.16 q2[7], r0
; CHECK-NEXT:    vmov.u8 r0, q1[2]
; CHECK-NEXT:    vmov.16 q3[0], r0
; CHECK-NEXT:    vmov.u8 r0, q1[6]
; CHECK-NEXT:    vmov.16 q3[1], r0
; CHECK-NEXT:    vmov.u8 r0, q1[10]
; CHECK-NEXT:    vmov.16 q3[2], r0
; CHECK-NEXT:    vmov.u8 r0, q1[14]
; CHECK-NEXT:    vmov.16 q3[3], r0
; CHECK-NEXT:    vmov.u8 r0, q0[2]
; CHECK-NEXT:    vmov.16 q3[4], r0
; CHECK-NEXT:    vmov.u8 r0, q0[6]
; CHECK-NEXT:    vmov.16 q3[5], r0
; CHECK-NEXT:    vmov.u8 r0, q0[10]
; CHECK-NEXT:    vmov.16 q3[6], r0
; CHECK-NEXT:    vmov.u8 r0, q0[14]
; CHECK-NEXT:    vmov.16 q3[7], r0
; CHECK-NEXT:    vmov.u8 r0, q1[0]
; CHECK-NEXT:    vadd.i16 q2, q3, q2
; CHECK-NEXT:    vmov.16 q3[0], r0
; CHECK-NEXT:    vmov.u8 r0, q1[4]
; CHECK-NEXT:    vmov.16 q3[1], r0
; CHECK-NEXT:    vmov.u8 r0, q1[8]
; CHECK-NEXT:    vmov.16 q3[2], r0
; CHECK-NEXT:    vmov.u8 r0, q1[12]
; CHECK-NEXT:    vmov.16 q3[3], r0
; CHECK-NEXT:    vmov.u8 r0, q0[0]
; CHECK-NEXT:    vmov.16 q3[4], r0
; CHECK-NEXT:    vmov.u8 r0, q0[4]
; CHECK-NEXT:    vmov.16 q3[5], r0
; CHECK-NEXT:    vmov.u8 r0, q0[8]
; CHECK-NEXT:    vmov.16 q3[6], r0
; CHECK-NEXT:    vmov.u8 r0, q1[1]
; CHECK-NEXT:    vmov.16 q4[0], r0
; CHECK-NEXT:    vmov.u8 r0, q1[5]
; CHECK-NEXT:    vmov.16 q4[1], r0
; CHECK-NEXT:    vmov.u8 r0, q1[9]
; CHECK-NEXT:    vmov.16 q4[2], r0
; CHECK-NEXT:    vmov.u8 r0, q1[13]
; CHECK-NEXT:    vmov.16 q4[3], r0
; CHECK-NEXT:    vmov.u8 r0, q0[1]
; CHECK-NEXT:    vmov.16 q4[4], r0
; CHECK-NEXT:    vmov.u8 r0, q0[5]
; CHECK-NEXT:    vmov.16 q4[5], r0
; CHECK-NEXT:    vmov.u8 r0, q0[9]
; CHECK-NEXT:    vmov.16 q4[6], r0
; CHECK-NEXT:    vmov.u8 r0, q0[13]
; CHECK-NEXT:    vmov.16 q4[7], r0
; CHECK-NEXT:    vmov.u8 r0, q0[12]
; CHECK-NEXT:    vmov.16 q3[7], r0
; CHECK-NEXT:    vadd.i16 q0, q3, q4
; CHECK-NEXT:    vadd.i16 q0, q0, q2
; CHECK-NEXT:    vstrb.16 q0, [r1]
; CHECK-NEXT:    vpop {d8, d9}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <32 x i8>, <32 x i8>* %src, align 4
  %s1 = shufflevector <32 x i8> %l1, <32 x i8> undef, <8 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 28>
  %s2 = shufflevector <32 x i8> %l1, <32 x i8> undef, <8 x i32> <i32 1, i32 5, i32 9, i32 13, i32 17, i32 21, i32 25, i32 29>
  %s3 = shufflevector <32 x i8> %l1, <32 x i8> undef, <8 x i32> <i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 30>
  %s4 = shufflevector <32 x i8> %l1, <32 x i8> undef, <8 x i32> <i32 3, i32 7, i32 11, i32 15, i32 19, i32 23, i32 27, i32 31>
  %a1 = add <8 x i8> %s1, %s2
  %a2 = add <8 x i8> %s3, %s4
  %a3 = add <8 x i8> %a1, %a2
  store <8 x i8> %a3, <8 x i8> *%dst
  ret void
}

define void @vld4_v16i8(<64 x i8> *%src, <16 x i8> *%dst) {
; CHECK-LABEL: vld4_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9}
; CHECK-NEXT:    vpush {d8, d9}
; CHECK-NEXT:    vld40.8 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld41.8 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld42.8 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld43.8 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    @ kill: def $q0 killed $q0 killed $q0_q1_q2_q3
; CHECK-NEXT:    vadd.i8 q4, q2, q3
; CHECK-NEXT:    vadd.i8 q0, q0, q1
; CHECK-NEXT:    vadd.i8 q0, q0, q4
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    vpop {d8, d9}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <64 x i8>, <64 x i8>* %src, align 4
  %s1 = shufflevector <64 x i8> %l1, <64 x i8> undef, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 28, i32 32, i32 36, i32 40, i32 44, i32 48, i32 52, i32 56, i32 60>
  %s2 = shufflevector <64 x i8> %l1, <64 x i8> undef, <16 x i32> <i32 1, i32 5, i32 9, i32 13, i32 17, i32 21, i32 25, i32 29, i32 33, i32 37, i32 41, i32 45, i32 49, i32 53, i32 57, i32 61>
  %s3 = shufflevector <64 x i8> %l1, <64 x i8> undef, <16 x i32> <i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 30, i32 34, i32 38, i32 42, i32 46, i32 50, i32 54, i32 58, i32 62>
  %s4 = shufflevector <64 x i8> %l1, <64 x i8> undef, <16 x i32> <i32 3, i32 7, i32 11, i32 15, i32 19, i32 23, i32 27, i32 31, i32 35, i32 39, i32 43, i32 47, i32 51, i32 55, i32 59, i32 63>
  %a1 = add <16 x i8> %s1, %s2
  %a2 = add <16 x i8> %s3, %s4
  %a3 = add <16 x i8> %a1, %a2
  store <16 x i8> %a3, <16 x i8> *%dst
  ret void
}

; i64

define void @vld4_v2i64(<8 x i64> *%src, <2 x i64> *%dst) {
; CHECK-LABEL: vld4_v2i64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5, r6, lr}
; CHECK-NEXT:    push {r4, r5, r6, lr}
; CHECK-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-NEXT:    vldrw.u32 q3, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q5, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q0, [r0]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #32]
; CHECK-NEXT:    vmov.f64 d8, d7
; CHECK-NEXT:    vmov.f32 s17, s15
; CHECK-NEXT:    vmov.f32 s18, s22
; CHECK-NEXT:    vmov.f32 s14, s20
; CHECK-NEXT:    vmov.f32 s19, s23
; CHECK-NEXT:    vmov.f32 s15, s21
; CHECK-NEXT:    vmov r3, s18
; CHECK-NEXT:    vmov r0, s14
; CHECK-NEXT:    vmov.f64 d2, d1
; CHECK-NEXT:    vmov r12, s19
; CHECK-NEXT:    vmov r2, s15
; CHECK-NEXT:    vmov.f32 s5, s3
; CHECK-NEXT:    vmov.f32 s6, s10
; CHECK-NEXT:    vmov.f32 s2, s8
; CHECK-NEXT:    vmov.f32 s3, s9
; CHECK-NEXT:    vmov.f32 s7, s11
; CHECK-NEXT:    vmov r4, s2
; CHECK-NEXT:    vmov r5, s4
; CHECK-NEXT:    vmov r6, s0
; CHECK-NEXT:    adds.w lr, r0, r3
; CHECK-NEXT:    vmov r3, s7
; CHECK-NEXT:    vmov r0, s3
; CHECK-NEXT:    adc.w r12, r12, r2
; CHECK-NEXT:    vmov r2, s6
; CHECK-NEXT:    adds r2, r2, r4
; CHECK-NEXT:    vmov r4, s13
; CHECK-NEXT:    adcs r0, r3
; CHECK-NEXT:    adds.w lr, lr, r2
; CHECK-NEXT:    adc.w r12, r12, r0
; CHECK-NEXT:    vmov r0, s16
; CHECK-NEXT:    vmov r2, s12
; CHECK-NEXT:    vmov r3, s17
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adc.w r2, r4, r3
; CHECK-NEXT:    vmov r3, s5
; CHECK-NEXT:    vmov r4, s1
; CHECK-NEXT:    adds r5, r5, r6
; CHECK-NEXT:    adcs r3, r4
; CHECK-NEXT:    adds r0, r0, r5
; CHECK-NEXT:    adcs r2, r3
; CHECK-NEXT:    vmov.32 q0[0], r0
; CHECK-NEXT:    vmov.32 q0[1], r2
; CHECK-NEXT:    vmov.32 q0[2], lr
; CHECK-NEXT:    vmov.32 q0[3], r12
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-NEXT:    pop {r4, r5, r6, pc}
entry:
  %l1 = load <8 x i64>, <8 x i64>* %src, align 4
  %s1 = shufflevector <8 x i64> %l1, <8 x i64> undef, <2 x i32> <i32 0, i32 4>
  %s2 = shufflevector <8 x i64> %l1, <8 x i64> undef, <2 x i32> <i32 1, i32 5>
  %s3 = shufflevector <8 x i64> %l1, <8 x i64> undef, <2 x i32> <i32 2, i32 6>
  %s4 = shufflevector <8 x i64> %l1, <8 x i64> undef, <2 x i32> <i32 3, i32 7>
  %a1 = add <2 x i64> %s1, %s2
  %a2 = add <2 x i64> %s3, %s4
  %a3 = add <2 x i64> %a1, %a2
  store <2 x i64> %a3, <2 x i64> *%dst
  ret void
}

define void @vld4_v4i64(<16 x i64> *%src, <4 x i64> *%dst) {
; CHECK-LABEL: vld4_v4i64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5, r6, r7, r8, lr}
; CHECK-NEXT:    push.w {r4, r5, r6, r7, r8, lr}
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    .pad #72
; CHECK-NEXT:    sub sp, #72
; CHECK-NEXT:    vldrw.u32 q1, [r0, #64]
; CHECK-NEXT:    vldrw.u32 q0, [r0, #96]
; CHECK-NEXT:    vldrw.u32 q5, [r0, #80]
; CHECK-NEXT:    vldrw.u32 q7, [r0, #16]
; CHECK-NEXT:    vmov.f64 d8, d3
; CHECK-NEXT:    vstrw.32 q0, [sp, #32] @ 16-byte Spill
; CHECK-NEXT:    vstrw.32 q1, [sp, #48] @ 16-byte Spill
; CHECK-NEXT:    vmov.f32 s17, s7
; CHECK-NEXT:    vldrw.u32 q1, [r0]
; CHECK-NEXT:    vmov.f32 s18, s2
; CHECK-NEXT:    vmov.f32 s19, s3
; CHECK-NEXT:    vldrw.u32 q0, [r0, #112]
; CHECK-NEXT:    vmov.f64 d12, d11
; CHECK-NEXT:    vstrw.32 q0, [sp, #16] @ 16-byte Spill
; CHECK-NEXT:    vmov.f32 s25, s23
; CHECK-NEXT:    vmov.f32 s26, s2
; CHECK-NEXT:    vmov.f64 d6, d3
; CHECK-NEXT:    vmov.f32 s27, s3
; CHECK-NEXT:    vldrw.u32 q0, [r0, #32]
; CHECK-NEXT:    vmov.f32 s13, s7
; CHECK-NEXT:    vmov.f32 s14, s2
; CHECK-NEXT:    vstrw.32 q0, [sp] @ 16-byte Spill
; CHECK-NEXT:    vmov.f64 d4, d15
; CHECK-NEXT:    vmov.f32 s15, s3
; CHECK-NEXT:    vldrw.u32 q0, [r0, #48]
; CHECK-NEXT:    vmov.f32 s9, s31
; CHECK-NEXT:    vmov.f32 s10, s2
; CHECK-NEXT:    vmov.f32 s30, s0
; CHECK-NEXT:    vmov.f32 s11, s3
; CHECK-NEXT:    vmov.f32 s31, s1
; CHECK-NEXT:    vldrw.u32 q0, [sp] @ 16-byte Reload
; CHECK-NEXT:    vmov r3, s10
; CHECK-NEXT:    vmov r0, s30
; CHECK-NEXT:    vmov.f32 s6, s0
; CHECK-NEXT:    vmov.f32 s7, s1
; CHECK-NEXT:    vldrw.u32 q0, [sp, #16] @ 16-byte Reload
; CHECK-NEXT:    vmov r4, s6
; CHECK-NEXT:    vstrw.32 q1, [sp] @ 16-byte Spill
; CHECK-NEXT:    vmov r12, s11
; CHECK-NEXT:    vmov r2, s31
; CHECK-NEXT:    vmov.f32 s22, s0
; CHECK-NEXT:    vmov.f32 s23, s1
; CHECK-NEXT:    vldrw.u32 q0, [sp, #48] @ 16-byte Reload
; CHECK-NEXT:    vmov r5, s18
; CHECK-NEXT:    vmov r7, s16
; CHECK-NEXT:    adds.w lr, r0, r3
; CHECK-NEXT:    vmov r3, s14
; CHECK-NEXT:    vmov r0, s7
; CHECK-NEXT:    vldrw.u32 q1, [sp, #32] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s2, s4
; CHECK-NEXT:    vmov.f32 s3, s5
; CHECK-NEXT:    vldrw.u32 q1, [sp] @ 16-byte Reload
; CHECK-NEXT:    adc.w r12, r12, r2
; CHECK-NEXT:    vmov r2, s15
; CHECK-NEXT:    vmov r6, s2
; CHECK-NEXT:    adds r3, r3, r4
; CHECK-NEXT:    vmov r4, s23
; CHECK-NEXT:    adcs r0, r2
; CHECK-NEXT:    adds.w lr, lr, r3
; CHECK-NEXT:    adc.w r12, r12, r0
; CHECK-NEXT:    vmov r0, s26
; CHECK-NEXT:    vmov r2, s22
; CHECK-NEXT:    vmov r3, s27
; CHECK-NEXT:    adds r0, r0, r2
; CHECK-NEXT:    adc.w r2, r4, r3
; CHECK-NEXT:    vmov r3, s19
; CHECK-NEXT:    vmov r4, s3
; CHECK-NEXT:    adds r5, r5, r6
; CHECK-NEXT:    vmov r6, s20
; CHECK-NEXT:    adcs r3, r4
; CHECK-NEXT:    adds r0, r0, r5
; CHECK-NEXT:    vmov r5, s24
; CHECK-NEXT:    adc.w r8, r3, r2
; CHECK-NEXT:    vmov r2, s25
; CHECK-NEXT:    vmov r4, s21
; CHECK-NEXT:    vmov r3, s0
; CHECK-NEXT:    adds r5, r5, r6
; CHECK-NEXT:    vmov r6, s1
; CHECK-NEXT:    adcs r2, r4
; CHECK-NEXT:    vmov r4, s17
; CHECK-NEXT:    adds r3, r3, r7
; CHECK-NEXT:    vmov r7, s28
; CHECK-NEXT:    adcs r4, r6
; CHECK-NEXT:    adds r3, r3, r5
; CHECK-NEXT:    vmov r6, s8
; CHECK-NEXT:    adcs r2, r4
; CHECK-NEXT:    vmov r4, s9
; CHECK-NEXT:    vmov.32 q0[0], r3
; CHECK-NEXT:    vmov r5, s29
; CHECK-NEXT:    vmov.32 q0[1], r2
; CHECK-NEXT:    vmov.32 q0[2], r0
; CHECK-NEXT:    vmov r0, s12
; CHECK-NEXT:    vmov r3, s13
; CHECK-NEXT:    vmov.32 q0[3], r8
; CHECK-NEXT:    vmov r2, s5
; CHECK-NEXT:    vstrw.32 q0, [r1, #16]
; CHECK-NEXT:    adds r6, r6, r7
; CHECK-NEXT:    adcs r4, r5
; CHECK-NEXT:    vmov r5, s4
; CHECK-NEXT:    adds r0, r0, r5
; CHECK-NEXT:    adcs r2, r3
; CHECK-NEXT:    adds r0, r0, r6
; CHECK-NEXT:    adcs r2, r4
; CHECK-NEXT:    vmov.32 q0[0], r0
; CHECK-NEXT:    vmov.32 q0[1], r2
; CHECK-NEXT:    vmov.32 q0[2], lr
; CHECK-NEXT:    vmov.32 q0[3], r12
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    add sp, #72
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    pop.w {r4, r5, r6, r7, r8, pc}
entry:
  %l1 = load <16 x i64>, <16 x i64>* %src, align 4
  %s1 = shufflevector <16 x i64> %l1, <16 x i64> undef, <4 x i32> <i32 0, i32 4, i32 8, i32 12>
  %s2 = shufflevector <16 x i64> %l1, <16 x i64> undef, <4 x i32> <i32 1, i32 5, i32 9, i32 13>
  %s3 = shufflevector <16 x i64> %l1, <16 x i64> undef, <4 x i32> <i32 2, i32 6, i32 10, i32 14>
  %s4 = shufflevector <16 x i64> %l1, <16 x i64> undef, <4 x i32> <i32 3, i32 7, i32 11, i32 15>
  %a1 = add <4 x i64> %s1, %s2
  %a2 = add <4 x i64> %s3, %s4
  %a3 = add <4 x i64> %a1, %a2
  store <4 x i64> %a3, <4 x i64> *%dst
  ret void
}

; f32

define void @vld4_v2f32(<8 x float> *%src, <2 x float> *%dst) {
; CHECK-LABEL: vld4_v2f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrw.u32 q1, [r0]
; CHECK-NEXT:    vldrw.u32 q0, [r0, #16]
; CHECK-NEXT:    vmov.f32 s8, s7
; CHECK-NEXT:    vmov.f64 d6, d3
; CHECK-NEXT:    vmov.f32 s9, s3
; CHECK-NEXT:    vmov.f32 s13, s2
; CHECK-NEXT:    vadd.f32 q2, q3, q2
; CHECK-NEXT:    vmov.f32 s12, s5
; CHECK-NEXT:    vmov.f32 s13, s1
; CHECK-NEXT:    vmov.f32 s5, s0
; CHECK-NEXT:    vadd.f32 q0, q1, q3
; CHECK-NEXT:    vadd.f32 q0, q0, q2
; CHECK-NEXT:    vstmia r1, {s0, s1}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <8 x float>, <8 x float>* %src, align 4
  %s1 = shufflevector <8 x float> %l1, <8 x float> undef, <2 x i32> <i32 0, i32 4>
  %s2 = shufflevector <8 x float> %l1, <8 x float> undef, <2 x i32> <i32 1, i32 5>
  %s3 = shufflevector <8 x float> %l1, <8 x float> undef, <2 x i32> <i32 2, i32 6>
  %s4 = shufflevector <8 x float> %l1, <8 x float> undef, <2 x i32> <i32 3, i32 7>
  %a1 = fadd <2 x float> %s1, %s2
  %a2 = fadd <2 x float> %s3, %s4
  %a3 = fadd <2 x float> %a1, %a2
  store <2 x float> %a3, <2 x float> *%dst
  ret void
}

define void @vld4_v4f32(<16 x float> *%src, <4 x float> *%dst) {
; CHECK-LABEL: vld4_v4f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9}
; CHECK-NEXT:    vpush {d8, d9}
; CHECK-NEXT:    vld40.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld41.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld42.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld43.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    @ kill: def $q0 killed $q0 killed $q0_q1_q2_q3
; CHECK-NEXT:    vadd.f32 q4, q2, q3
; CHECK-NEXT:    vadd.f32 q0, q0, q1
; CHECK-NEXT:    vadd.f32 q0, q0, q4
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    vpop {d8, d9}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <16 x float>, <16 x float>* %src, align 4
  %s1 = shufflevector <16 x float> %l1, <16 x float> undef, <4 x i32> <i32 0, i32 4, i32 8, i32 12>
  %s2 = shufflevector <16 x float> %l1, <16 x float> undef, <4 x i32> <i32 1, i32 5, i32 9, i32 13>
  %s3 = shufflevector <16 x float> %l1, <16 x float> undef, <4 x i32> <i32 2, i32 6, i32 10, i32 14>
  %s4 = shufflevector <16 x float> %l1, <16 x float> undef, <4 x i32> <i32 3, i32 7, i32 11, i32 15>
  %a1 = fadd <4 x float> %s1, %s2
  %a2 = fadd <4 x float> %s3, %s4
  %a3 = fadd <4 x float> %a1, %a2
  store <4 x float> %a3, <4 x float> *%dst
  ret void
}

define void @vld4_v8f32(<32 x float> *%src, <8 x float> *%dst) {
; CHECK-LABEL: vld4_v8f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    vld40.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld41.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld42.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld43.32 {q0, q1, q2, q3}, [r0]!
; CHECK-NEXT:    @ kill: def $q0 killed $q0 killed $q0_q1_q2_q3
; CHECK-NEXT:    vadd.f32 q6, q2, q3
; CHECK-NEXT:    vadd.f32 q0, q0, q1
; CHECK-NEXT:    vld40.32 {q1, q2, q3, q4}, [r0]
; CHECK-NEXT:    vadd.f32 q0, q0, q6
; CHECK-NEXT:    vld41.32 {q1, q2, q3, q4}, [r0]
; CHECK-NEXT:    vld42.32 {q1, q2, q3, q4}, [r0]
; CHECK-NEXT:    vld43.32 {q1, q2, q3, q4}, [r0]
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    @ kill: def $q1 killed $q1 killed $q1_q2_q3_q4
; CHECK-NEXT:    vadd.f32 q5, q3, q4
; CHECK-NEXT:    vadd.f32 q1, q1, q2
; CHECK-NEXT:    vadd.f32 q1, q1, q5
; CHECK-NEXT:    vstrw.32 q1, [r1, #16]
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <32 x float>, <32 x float>* %src, align 4
  %s1 = shufflevector <32 x float> %l1, <32 x float> undef, <8 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 28>
  %s2 = shufflevector <32 x float> %l1, <32 x float> undef, <8 x i32> <i32 1, i32 5, i32 9, i32 13, i32 17, i32 21, i32 25, i32 29>
  %s3 = shufflevector <32 x float> %l1, <32 x float> undef, <8 x i32> <i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 30>
  %s4 = shufflevector <32 x float> %l1, <32 x float> undef, <8 x i32> <i32 3, i32 7, i32 11, i32 15, i32 19, i32 23, i32 27, i32 31>
  %a1 = fadd <8 x float> %s1, %s2
  %a2 = fadd <8 x float> %s3, %s4
  %a3 = fadd <8 x float> %a1, %a2
  store <8 x float> %a3, <8 x float> *%dst
  ret void
}

define void @vld4_v16f32(<64 x float> *%src, <16 x float> *%dst) {
; CHECK-LABEL: vld4_v16f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5}
; CHECK-NEXT:    push {r4, r5}
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    .pad #136
; CHECK-NEXT:    sub sp, #136
; CHECK-NEXT:    vld40.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    mov r2, r0
; CHECK-NEXT:    add.w r3, r0, #192
; CHECK-NEXT:    vld41.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld42.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    adds r0, #128
; CHECK-NEXT:    vld43.32 {q0, q1, q2, q3}, [r2]!
; CHECK-NEXT:    @ kill: def $q0 killed $q0 killed $q0_q1_q2_q3
; CHECK-NEXT:    vadd.f32 q4, q2, q3
; CHECK-NEXT:    vadd.f32 q0, q0, q1
; CHECK-NEXT:    vstrw.32 q4, [sp, #112] @ 16-byte Spill
; CHECK-NEXT:    vstrw.32 q0, [sp, #96] @ 16-byte Spill
; CHECK-NEXT:    vld40.32 {q1, q2, q3, q4}, [r3]
; CHECK-NEXT:    vld41.32 {q1, q2, q3, q4}, [r3]
; CHECK-NEXT:    vld42.32 {q1, q2, q3, q4}, [r3]
; CHECK-NEXT:    vld43.32 {q1, q2, q3, q4}, [r3]
; CHECK-NEXT:    vldrw.u32 q6, [sp, #112] @ 16-byte Reload
; CHECK-NEXT:    vldrw.u32 q5, [sp, #96] @ 16-byte Reload
; CHECK-NEXT:    vstrw.32 q4, [sp, #80] @ 16-byte Spill
; CHECK-NEXT:    vmov q0, q1
; CHECK-NEXT:    vadd.f32 q6, q5, q6
; CHECK-NEXT:    vldrw.u32 q5, [sp, #80] @ 16-byte Reload
; CHECK-NEXT:    vadd.f32 q0, q0, q2
; CHECK-NEXT:    vstrw.32 q6, [sp, #112] @ 16-byte Spill
; CHECK-NEXT:    vadd.f32 q1, q3, q5
; CHECK-NEXT:    vadd.f32 q0, q0, q1
; CHECK-NEXT:    vstrw.32 q0, [sp, #96] @ 16-byte Spill
; CHECK-NEXT:    vld40.32 {q0, q1, q2, q3}, [r2]
; CHECK-NEXT:    vld41.32 {q0, q1, q2, q3}, [r2]
; CHECK-NEXT:    vld42.32 {q0, q1, q2, q3}, [r2]
; CHECK-NEXT:    vld43.32 {q0, q1, q2, q3}, [r2]
; CHECK-NEXT:    vstmia sp, {d0, d1, d2, d3, d4, d5, d6, d7} @ 64-byte Spill
; CHECK-NEXT:    vld40.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld41.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld42.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld43.32 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    @ kill: def $q0 killed $q0 killed $q0_q1_q2_q3
; CHECK-NEXT:    vstrw.32 q3, [sp, #80] @ 16-byte Spill
; CHECK-NEXT:    vmov q5, q1
; CHECK-NEXT:    vldrw.u32 q1, [sp, #80] @ 16-byte Reload
; CHECK-NEXT:    vadd.f32 q0, q0, q5
; CHECK-NEXT:    vldmia sp, {d6, d7, d8, d9, d10, d11, d12, d13} @ 64-byte Reload
; CHECK-NEXT:    vadd.f32 q1, q2, q1
; CHECK-NEXT:    @ kill: def $q3 killed $q3 killed $q3_q4_q5_q6
; CHECK-NEXT:    vadd.f32 q2, q3, q4
; CHECK-NEXT:    vadd.f32 q0, q0, q1
; CHECK-NEXT:    vadd.f32 q1, q5, q6
; CHECK-NEXT:    vadd.f32 q1, q2, q1
; CHECK-NEXT:    vldrw.u32 q2, [sp, #96] @ 16-byte Reload
; CHECK-NEXT:    vstrw.32 q0, [r1, #32]
; CHECK-NEXT:    vldrw.u32 q0, [sp, #112] @ 16-byte Reload
; CHECK-NEXT:    vstrw.32 q2, [r1, #48]
; CHECK-NEXT:    vstrw.32 q1, [r1, #16]
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    add sp, #136
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    pop {r4, r5}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <64 x float>, <64 x float>* %src, align 4
  %s1 = shufflevector <64 x float> %l1, <64 x float> undef, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 28, i32 32, i32 36, i32 40, i32 44, i32 48, i32 52, i32 56, i32 60>
  %s2 = shufflevector <64 x float> %l1, <64 x float> undef, <16 x i32> <i32 1, i32 5, i32 9, i32 13, i32 17, i32 21, i32 25, i32 29, i32 33, i32 37, i32 41, i32 45, i32 49, i32 53, i32 57, i32 61>
  %s3 = shufflevector <64 x float> %l1, <64 x float> undef, <16 x i32> <i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 30, i32 34, i32 38, i32 42, i32 46, i32 50, i32 54, i32 58, i32 62>
  %s4 = shufflevector <64 x float> %l1, <64 x float> undef, <16 x i32> <i32 3, i32 7, i32 11, i32 15, i32 19, i32 23, i32 27, i32 31, i32 35, i32 39, i32 43, i32 47, i32 51, i32 55, i32 59, i32 63>
  %a1 = fadd <16 x float> %s1, %s2
  %a2 = fadd <16 x float> %s3, %s4
  %a3 = fadd <16 x float> %a1, %a2
  store <16 x float> %a3, <16 x float> *%dst
  ret void
}

; f16

define void @vld4_v2f16(<8 x half> *%src, <2 x half> *%dst) {
; CHECK-LABEL: vld4_v2f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrw.u32 q0, [r0]
; CHECK-NEXT:    vmovx.f16 s4, s3
; CHECK-NEXT:    vmov r0, s4
; CHECK-NEXT:    vmovx.f16 s4, s1
; CHECK-NEXT:    vmov r2, s4
; CHECK-NEXT:    vmov.16 q1[0], r2
; CHECK-NEXT:    vmov r2, s1
; CHECK-NEXT:    vmov.16 q1[1], r0
; CHECK-NEXT:    vmov r0, s3
; CHECK-NEXT:    vmov.16 q2[0], r2
; CHECK-NEXT:    vmov.16 q2[1], r0
; CHECK-NEXT:    vadd.f16 q1, q2, q1
; CHECK-NEXT:    vmovx.f16 s8, s0
; CHECK-NEXT:    vmov r0, s8
; CHECK-NEXT:    vmovx.f16 s8, s2
; CHECK-NEXT:    vmov r2, s8
; CHECK-NEXT:    vmov.16 q2[0], r0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q2[1], r2
; CHECK-NEXT:    vmov r2, s2
; CHECK-NEXT:    vmov.16 q0[0], r0
; CHECK-NEXT:    vmov.16 q0[1], r2
; CHECK-NEXT:    vadd.f16 q0, q0, q2
; CHECK-NEXT:    vadd.f16 q0, q0, q1
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    str r0, [r1]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <8 x half>, <8 x half>* %src, align 4
  %s1 = shufflevector <8 x half> %l1, <8 x half> undef, <2 x i32> <i32 0, i32 4>
  %s2 = shufflevector <8 x half> %l1, <8 x half> undef, <2 x i32> <i32 1, i32 5>
  %s3 = shufflevector <8 x half> %l1, <8 x half> undef, <2 x i32> <i32 2, i32 6>
  %s4 = shufflevector <8 x half> %l1, <8 x half> undef, <2 x i32> <i32 3, i32 7>
  %a1 = fadd <2 x half> %s1, %s2
  %a2 = fadd <2 x half> %s3, %s4
  %a3 = fadd <2 x half> %a1, %a2
  store <2 x half> %a3, <2 x half> *%dst
  ret void
}

define void @vld4_v4f16(<16 x half> *%src, <4 x half> *%dst) {
; CHECK-LABEL: vld4_v4f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8}
; CHECK-NEXT:    vpush {d8}
; CHECK-NEXT:    vldrw.u32 q1, [r0]
; CHECK-NEXT:    vldrw.u32 q0, [r0, #16]
; CHECK-NEXT:    vmov r2, s5
; CHECK-NEXT:    vmovx.f16 s12, s5
; CHECK-NEXT:    vmov r3, s7
; CHECK-NEXT:    vmov.16 q2[0], r2
; CHECK-NEXT:    vmov.16 q2[1], r3
; CHECK-NEXT:    vmov r0, s1
; CHECK-NEXT:    vmov.16 q2[2], r0
; CHECK-NEXT:    vmov r0, s12
; CHECK-NEXT:    vmovx.f16 s12, s7
; CHECK-NEXT:    vmovx.f16 s16, s1
; CHECK-NEXT:    vmov r2, s12
; CHECK-NEXT:    vmov.16 q3[0], r0
; CHECK-NEXT:    vmov r0, s16
; CHECK-NEXT:    vmov.16 q3[1], r2
; CHECK-NEXT:    vmovx.f16 s16, s3
; CHECK-NEXT:    vmov.16 q3[2], r0
; CHECK-NEXT:    vmov r0, s16
; CHECK-NEXT:    vmovx.f16 s16, s0
; CHECK-NEXT:    vmov.16 q3[3], r0
; CHECK-NEXT:    vmov r0, s3
; CHECK-NEXT:    vmov.16 q2[3], r0
; CHECK-NEXT:    vadd.f16 q2, q2, q3
; CHECK-NEXT:    vmovx.f16 s12, s4
; CHECK-NEXT:    vmov r0, s12
; CHECK-NEXT:    vmovx.f16 s12, s6
; CHECK-NEXT:    vmov r2, s12
; CHECK-NEXT:    vmov.16 q3[0], r0
; CHECK-NEXT:    vmov.16 q3[1], r2
; CHECK-NEXT:    vmov r0, s16
; CHECK-NEXT:    vmovx.f16 s16, s2
; CHECK-NEXT:    vmov.16 q3[2], r0
; CHECK-NEXT:    vmov r0, s16
; CHECK-NEXT:    vmov.16 q3[3], r0
; CHECK-NEXT:    vmov r0, s4
; CHECK-NEXT:    vmov r2, s6
; CHECK-NEXT:    vmov.16 q1[0], r0
; CHECK-NEXT:    vmov.16 q1[1], r2
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q1[2], r0
; CHECK-NEXT:    vmov r0, s2
; CHECK-NEXT:    vmov.16 q1[3], r0
; CHECK-NEXT:    vadd.f16 q0, q1, q3
; CHECK-NEXT:    vadd.f16 q0, q0, q2
; CHECK-NEXT:    vmov r2, s1
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    strd r0, r2, [r1]
; CHECK-NEXT:    vpop {d8}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <16 x half>, <16 x half>* %src, align 4
  %s1 = shufflevector <16 x half> %l1, <16 x half> undef, <4 x i32> <i32 0, i32 4, i32 8, i32 12>
  %s2 = shufflevector <16 x half> %l1, <16 x half> undef, <4 x i32> <i32 1, i32 5, i32 9, i32 13>
  %s3 = shufflevector <16 x half> %l1, <16 x half> undef, <4 x i32> <i32 2, i32 6, i32 10, i32 14>
  %s4 = shufflevector <16 x half> %l1, <16 x half> undef, <4 x i32> <i32 3, i32 7, i32 11, i32 15>
  %a1 = fadd <4 x half> %s1, %s2
  %a2 = fadd <4 x half> %s3, %s4
  %a3 = fadd <4 x half> %a1, %a2
  store <4 x half> %a3, <4 x half> *%dst
  ret void
}

define void @vld4_v8f16(<32 x half> *%src, <8 x half> *%dst) {
; CHECK-LABEL: vld4_v8f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9}
; CHECK-NEXT:    vpush {d8, d9}
; CHECK-NEXT:    vld40.16 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld41.16 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld42.16 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld43.16 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    @ kill: def $q0 killed $q0 killed $q0_q1_q2_q3
; CHECK-NEXT:    vadd.f16 q4, q2, q3
; CHECK-NEXT:    vadd.f16 q0, q0, q1
; CHECK-NEXT:    vadd.f16 q0, q0, q4
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    vpop {d8, d9}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <32 x half>, <32 x half>* %src, align 4
  %s1 = shufflevector <32 x half> %l1, <32 x half> undef, <8 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 28>
  %s2 = shufflevector <32 x half> %l1, <32 x half> undef, <8 x i32> <i32 1, i32 5, i32 9, i32 13, i32 17, i32 21, i32 25, i32 29>
  %s3 = shufflevector <32 x half> %l1, <32 x half> undef, <8 x i32> <i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 30>
  %s4 = shufflevector <32 x half> %l1, <32 x half> undef, <8 x i32> <i32 3, i32 7, i32 11, i32 15, i32 19, i32 23, i32 27, i32 31>
  %a1 = fadd <8 x half> %s1, %s2
  %a2 = fadd <8 x half> %s3, %s4
  %a3 = fadd <8 x half> %a1, %a2
  store <8 x half> %a3, <8 x half> *%dst
  ret void
}

define void @vld4_v16f16(<64 x half> *%src, <16 x half> *%dst) {
; CHECK-LABEL: vld4_v16f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5}
; CHECK-NEXT:    push {r4, r5}
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    .pad #88
; CHECK-NEXT:    sub sp, #88
; CHECK-NEXT:    vld40.16 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld41.16 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld42.16 {q0, q1, q2, q3}, [r0]
; CHECK-NEXT:    vld43.16 {q0, q1, q2, q3}, [r0]!
; CHECK-NEXT:    vstmia sp, {d0, d1, d2, d3, d4, d5, d6, d7} @ 64-byte Spill
; CHECK-NEXT:    vld40.16 {q4, q5, q6, q7}, [r0]
; CHECK-NEXT:    vld41.16 {q4, q5, q6, q7}, [r0]
; CHECK-NEXT:    vld42.16 {q4, q5, q6, q7}, [r0]
; CHECK-NEXT:    vld43.16 {q4, q5, q6, q7}, [r0]
; CHECK-NEXT:    @ kill: def $q4 killed $q4 killed $q4_q5_q6_q7
; CHECK-NEXT:    vadd.f16 q0, q6, q7
; CHECK-NEXT:    vadd.f16 q4, q4, q5
; CHECK-NEXT:    vstrw.32 q0, [sp, #64] @ 16-byte Spill
; CHECK-NEXT:    vldrw.u32 q0, [sp, #64] @ 16-byte Reload
; CHECK-NEXT:    vadd.f16 q4, q4, q0
; CHECK-NEXT:    vldmia sp, {d0, d1, d2, d3, d4, d5, d6, d7} @ 64-byte Reload
; CHECK-NEXT:    @ kill: def $q0 killed $q0 killed $q0_q1_q2_q3
; CHECK-NEXT:    vstrw.32 q4, [r1, #16]
; CHECK-NEXT:    vadd.f16 q4, q2, q3
; CHECK-NEXT:    vadd.f16 q0, q0, q1
; CHECK-NEXT:    vadd.f16 q0, q0, q4
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    add sp, #88
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    pop {r4, r5}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <64 x half>, <64 x half>* %src, align 4
  %s1 = shufflevector <64 x half> %l1, <64 x half> undef, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 28, i32 32, i32 36, i32 40, i32 44, i32 48, i32 52, i32 56, i32 60>
  %s2 = shufflevector <64 x half> %l1, <64 x half> undef, <16 x i32> <i32 1, i32 5, i32 9, i32 13, i32 17, i32 21, i32 25, i32 29, i32 33, i32 37, i32 41, i32 45, i32 49, i32 53, i32 57, i32 61>
  %s3 = shufflevector <64 x half> %l1, <64 x half> undef, <16 x i32> <i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 30, i32 34, i32 38, i32 42, i32 46, i32 50, i32 54, i32 58, i32 62>
  %s4 = shufflevector <64 x half> %l1, <64 x half> undef, <16 x i32> <i32 3, i32 7, i32 11, i32 15, i32 19, i32 23, i32 27, i32 31, i32 35, i32 39, i32 43, i32 47, i32 51, i32 55, i32 59, i32 63>
  %a1 = fadd <16 x half> %s1, %s2
  %a2 = fadd <16 x half> %s3, %s4
  %a3 = fadd <16 x half> %a1, %a2
  store <16 x half> %a3, <16 x half> *%dst
  ret void
}

; f64

define void @vld4_v2f64(<8 x double> *%src, <2 x double> *%dst) {
; CHECK-LABEL: vld4_v2f64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrw.u32 q0, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q2, [r0]
; CHECK-NEXT:    vadd.f64 d0, d0, d1
; CHECK-NEXT:    vadd.f64 d1, d2, d3
; CHECK-NEXT:    vldrw.u32 q1, [r0, #16]
; CHECK-NEXT:    vadd.f64 d2, d2, d3
; CHECK-NEXT:    vadd.f64 d3, d4, d5
; CHECK-NEXT:    vadd.f64 d1, d1, d0
; CHECK-NEXT:    vadd.f64 d0, d3, d2
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <8 x double>, <8 x double>* %src, align 4
  %s1 = shufflevector <8 x double> %l1, <8 x double> undef, <2 x i32> <i32 0, i32 4>
  %s2 = shufflevector <8 x double> %l1, <8 x double> undef, <2 x i32> <i32 1, i32 5>
  %s3 = shufflevector <8 x double> %l1, <8 x double> undef, <2 x i32> <i32 2, i32 6>
  %s4 = shufflevector <8 x double> %l1, <8 x double> undef, <2 x i32> <i32 3, i32 7>
  %a1 = fadd <2 x double> %s1, %s2
  %a2 = fadd <2 x double> %s3, %s4
  %a3 = fadd <2 x double> %a1, %a2
  store <2 x double> %a3, <2 x double> *%dst
  ret void
}

define void @vld4_v4f64(<16 x double> *%src, <4 x double> *%dst) {
; CHECK-LABEL: vld4_v4f64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9}
; CHECK-NEXT:    vpush {d8, d9}
; CHECK-NEXT:    vldrw.u32 q0, [r0, #112]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #96]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #64]
; CHECK-NEXT:    vldrw.u32 q3, [r0, #32]
; CHECK-NEXT:    vadd.f64 d0, d0, d1
; CHECK-NEXT:    vldrw.u32 q4, [r0]
; CHECK-NEXT:    vadd.f64 d1, d2, d3
; CHECK-NEXT:    vldrw.u32 q1, [r0, #80]
; CHECK-NEXT:    vadd.f64 d2, d2, d3
; CHECK-NEXT:    vadd.f64 d3, d4, d5
; CHECK-NEXT:    vldrw.u32 q2, [r0, #48]
; CHECK-NEXT:    vadd.f64 d4, d4, d5
; CHECK-NEXT:    vadd.f64 d5, d6, d7
; CHECK-NEXT:    vldrw.u32 q3, [r0, #16]
; CHECK-NEXT:    vadd.f64 d6, d6, d7
; CHECK-NEXT:    vadd.f64 d7, d8, d9
; CHECK-NEXT:    vadd.f64 d1, d1, d0
; CHECK-NEXT:    vadd.f64 d0, d3, d2
; CHECK-NEXT:    vadd.f64 d3, d5, d4
; CHECK-NEXT:    vstrw.32 q0, [r1, #16]
; CHECK-NEXT:    vadd.f64 d2, d7, d6
; CHECK-NEXT:    vstrw.32 q1, [r1]
; CHECK-NEXT:    vpop {d8, d9}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <16 x double>, <16 x double>* %src, align 4
  %s1 = shufflevector <16 x double> %l1, <16 x double> undef, <4 x i32> <i32 0, i32 4, i32 8, i32 12>
  %s2 = shufflevector <16 x double> %l1, <16 x double> undef, <4 x i32> <i32 1, i32 5, i32 9, i32 13>
  %s3 = shufflevector <16 x double> %l1, <16 x double> undef, <4 x i32> <i32 2, i32 6, i32 10, i32 14>
  %s4 = shufflevector <16 x double> %l1, <16 x double> undef, <4 x i32> <i32 3, i32 7, i32 11, i32 15>
  %a1 = fadd <4 x double> %s1, %s2
  %a2 = fadd <4 x double> %s3, %s4
  %a3 = fadd <4 x double> %a1, %a2
  store <4 x double> %a3, <4 x double> *%dst
  ret void
}
