; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=tahiti -o - %s | FileCheck -check-prefix=GFX6 %s
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=fiji -o - %s | FileCheck -check-prefix=GFX8 %s
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=gfx900 -o - %s | FileCheck -check-prefix=GFX9 %s
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=gfx1010 -o - %s | FileCheck -check-prefix=GFX10 %s

define i7 @v_uaddsat_i7(i7 %lhs, i7 %rhs) {
; GFX6-LABEL: v_uaddsat_i7:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 25, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 25, v1
; GFX6-NEXT:    v_xor_b32_e32 v2, -1, v0
; GFX6-NEXT:    v_min_u32_e32 v1, v2, v1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, 25, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_uaddsat_i7:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b16_e32 v0, 9, v0
; GFX8-NEXT:    v_lshlrev_b16_e32 v1, 9, v1
; GFX8-NEXT:    v_add_u16_e64 v0, v0, v1 clamp
; GFX8-NEXT:    v_lshrrev_b16_e32 v0, 9, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uaddsat_i7:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 9, v0
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 9, v1
; GFX9-NEXT:    v_add_u16_e64 v0, v0, v1 clamp
; GFX9-NEXT:    v_lshrrev_b16_e32 v0, 9, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uaddsat_i7:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_lshlrev_b16 v0, 9, v0
; GFX10-NEXT:    v_lshlrev_b16 v1, 9, v1
; GFX10-NEXT:    v_add_nc_u16 v0, v0, v1 clamp
; GFX10-NEXT:    v_lshrrev_b16 v0, 9, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call i7 @llvm.uadd.sat.i7(i7 %lhs, i7 %rhs)
  ret i7 %result
}

define amdgpu_ps i7 @s_uaddsat_i7(i7 inreg %lhs, i7 inreg %rhs) {
; GFX6-LABEL: s_uaddsat_i7:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_lshl_b32 s0, s0, 25
; GFX6-NEXT:    s_lshl_b32 s1, s1, 25
; GFX6-NEXT:    s_not_b32 s2, s0
; GFX6-NEXT:    s_min_u32 s1, s2, s1
; GFX6-NEXT:    s_add_i32 s0, s0, s1
; GFX6-NEXT:    s_lshr_b32 s0, s0, 25
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_uaddsat_i7:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_bfe_u32 s2, 9, 0x100000
; GFX8-NEXT:    s_lshl_b32 s1, s1, s2
; GFX8-NEXT:    s_lshl_b32 s0, s0, s2
; GFX8-NEXT:    v_mov_b32_e32 v0, s1
; GFX8-NEXT:    v_add_u16_e64 v0, s0, v0 clamp
; GFX8-NEXT:    v_lshrrev_b16_e32 v0, 9, v0
; GFX8-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_uaddsat_i7:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_bfe_u32 s2, 9, 0x100000
; GFX9-NEXT:    s_lshl_b32 s1, s1, s2
; GFX9-NEXT:    s_lshl_b32 s0, s0, s2
; GFX9-NEXT:    v_mov_b32_e32 v0, s1
; GFX9-NEXT:    v_add_u16_e64 v0, s0, v0 clamp
; GFX9-NEXT:    v_lshrrev_b16_e32 v0, 9, v0
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_uaddsat_i7:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_bfe_u32 s2, 9, 0x100000
; GFX10-NEXT:    s_lshl_b32 s0, s0, s2
; GFX10-NEXT:    s_lshl_b32 s1, s1, s2
; GFX10-NEXT:    v_add_nc_u16 v0, s0, s1 clamp
; GFX10-NEXT:    v_lshrrev_b16 v0, 9, v0
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    ; return to shader part epilog
  %result = call i7 @llvm.uadd.sat.i7(i7 %lhs, i7 %rhs)
  ret i7 %result
}

define i8 @v_uaddsat_i8(i8 %lhs, i8 %rhs) {
; GFX6-LABEL: v_uaddsat_i8:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX6-NEXT:    v_xor_b32_e32 v2, -1, v0
; GFX6-NEXT:    v_min_u32_e32 v1, v2, v1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_uaddsat_i8:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b16_e32 v0, 8, v0
; GFX8-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX8-NEXT:    v_add_u16_e64 v0, v0, v1 clamp
; GFX8-NEXT:    v_lshrrev_b16_e32 v0, 8, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uaddsat_i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v0
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-NEXT:    v_add_u16_e64 v0, v0, v1 clamp
; GFX9-NEXT:    v_lshrrev_b16_e32 v0, 8, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uaddsat_i8:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_lshlrev_b16 v0, 8, v0
; GFX10-NEXT:    v_lshlrev_b16 v1, 8, v1
; GFX10-NEXT:    v_add_nc_u16 v0, v0, v1 clamp
; GFX10-NEXT:    v_lshrrev_b16 v0, 8, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call i8 @llvm.uadd.sat.i8(i8 %lhs, i8 %rhs)
  ret i8 %result
}

define amdgpu_ps i8 @s_uaddsat_i8(i8 inreg %lhs, i8 inreg %rhs) {
; GFX6-LABEL: s_uaddsat_i8:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_lshl_b32 s0, s0, 24
; GFX6-NEXT:    s_lshl_b32 s1, s1, 24
; GFX6-NEXT:    s_not_b32 s2, s0
; GFX6-NEXT:    s_min_u32 s1, s2, s1
; GFX6-NEXT:    s_add_i32 s0, s0, s1
; GFX6-NEXT:    s_lshr_b32 s0, s0, 24
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_uaddsat_i8:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_bfe_u32 s2, 8, 0x100000
; GFX8-NEXT:    s_lshl_b32 s1, s1, s2
; GFX8-NEXT:    s_lshl_b32 s0, s0, s2
; GFX8-NEXT:    v_mov_b32_e32 v0, s1
; GFX8-NEXT:    v_add_u16_e64 v0, s0, v0 clamp
; GFX8-NEXT:    v_lshrrev_b16_e32 v0, 8, v0
; GFX8-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_uaddsat_i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_bfe_u32 s2, 8, 0x100000
; GFX9-NEXT:    s_lshl_b32 s1, s1, s2
; GFX9-NEXT:    s_lshl_b32 s0, s0, s2
; GFX9-NEXT:    v_mov_b32_e32 v0, s1
; GFX9-NEXT:    v_add_u16_e64 v0, s0, v0 clamp
; GFX9-NEXT:    v_lshrrev_b16_e32 v0, 8, v0
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_uaddsat_i8:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_bfe_u32 s2, 8, 0x100000
; GFX10-NEXT:    s_lshl_b32 s0, s0, s2
; GFX10-NEXT:    s_lshl_b32 s1, s1, s2
; GFX10-NEXT:    v_add_nc_u16 v0, s0, s1 clamp
; GFX10-NEXT:    v_lshrrev_b16 v0, 8, v0
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    ; return to shader part epilog
  %result = call i8 @llvm.uadd.sat.i8(i8 %lhs, i8 %rhs)
  ret i8 %result
}

define i16 @v_uaddsat_v2i8(i16 %lhs.arg, i16 %rhs.arg) {
; GFX6-LABEL: v_uaddsat_v2i8:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, 8, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX6-NEXT:    v_xor_b32_e32 v4, -1, v0
; GFX6-NEXT:    v_min_u32_e32 v1, v4, v1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 24, v2
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 24, v3
; GFX6-NEXT:    v_xor_b32_e32 v3, -1, v1
; GFX6-NEXT:    v_min_u32_e32 v2, v3, v2
; GFX6-NEXT:    v_add_i32_e32 v1, vcc, v1, v2
; GFX6-NEXT:    v_lshrrev_b32_e32 v1, 24, v1
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX6-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_uaddsat_v2i8:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, 8
; GFX8-NEXT:    v_lshrrev_b32_sdwa v3, v2, v0 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_lshrrev_b32_sdwa v2, v2, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b16_e32 v0, 8, v0
; GFX8-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX8-NEXT:    v_add_u16_e64 v0, v0, v1 clamp
; GFX8-NEXT:    v_add_u16_e64 v1, v3, v2 clamp
; GFX8-NEXT:    v_lshrrev_b16_e32 v1, 8, v1
; GFX8-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uaddsat_v2i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s4, 8
; GFX9-NEXT:    v_lshrrev_b32_sdwa v2, s4, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_lshrrev_b32_sdwa v3, s4, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_mov_b32_e32 v4, 0xffff
; GFX9-NEXT:    v_and_or_b32 v0, v0, v4, v2
; GFX9-NEXT:    v_and_or_b32 v1, v1, v4, v3
; GFX9-NEXT:    v_pk_lshlrev_b16 v0, 8, v0 op_sel_hi:[0,1]
; GFX9-NEXT:    v_pk_lshlrev_b16 v1, 8, v1 op_sel_hi:[0,1]
; GFX9-NEXT:    v_pk_add_u16 v0, v0, v1 clamp
; GFX9-NEXT:    v_pk_lshrrev_b16 v0, 8, v0 op_sel_hi:[0,1]
; GFX9-NEXT:    s_movk_i32 s4, 0xff
; GFX9-NEXT:    v_and_b32_sdwa v1, v0, s4 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uaddsat_v2i8:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    s_mov_b32 s4, 8
; GFX10-NEXT:    v_mov_b32_e32 v2, 0xffff
; GFX10-NEXT:    v_lshrrev_b32_sdwa v3, s4, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_lshrrev_b32_sdwa v4, s4, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    s_movk_i32 s4, 0xff
; GFX10-NEXT:    v_and_or_b32 v0, v0, v2, v3
; GFX10-NEXT:    v_and_or_b32 v1, v1, v2, v4
; GFX10-NEXT:    v_pk_lshlrev_b16 v0, 8, v0 op_sel_hi:[0,1]
; GFX10-NEXT:    v_pk_lshlrev_b16 v1, 8, v1 op_sel_hi:[0,1]
; GFX10-NEXT:    v_pk_add_u16 v0, v0, v1 clamp
; GFX10-NEXT:    v_pk_lshrrev_b16 v0, 8, v0 op_sel_hi:[0,1]
; GFX10-NEXT:    v_and_b32_sdwa v1, v0, s4 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %lhs = bitcast i16 %lhs.arg to <2 x i8>
  %rhs = bitcast i16 %rhs.arg to <2 x i8>
  %result = call <2 x i8> @llvm.uadd.sat.v2i8(<2 x i8> %lhs, <2 x i8> %rhs)
  %cast.result = bitcast <2 x i8> %result to i16
  ret i16 %cast.result
}

define amdgpu_ps i16 @s_uaddsat_v2i8(i16 inreg %lhs.arg, i16 inreg %rhs.arg) {
; GFX6-LABEL: s_uaddsat_v2i8:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_lshr_b32 s2, s0, 8
; GFX6-NEXT:    s_lshl_b32 s0, s0, 24
; GFX6-NEXT:    s_lshr_b32 s3, s1, 8
; GFX6-NEXT:    s_lshl_b32 s1, s1, 24
; GFX6-NEXT:    s_not_b32 s4, s0
; GFX6-NEXT:    s_min_u32 s1, s4, s1
; GFX6-NEXT:    s_add_i32 s0, s0, s1
; GFX6-NEXT:    s_lshl_b32 s1, s2, 24
; GFX6-NEXT:    s_lshl_b32 s2, s3, 24
; GFX6-NEXT:    s_not_b32 s3, s1
; GFX6-NEXT:    s_min_u32 s2, s3, s2
; GFX6-NEXT:    s_add_i32 s1, s1, s2
; GFX6-NEXT:    s_lshr_b32 s1, s1, 24
; GFX6-NEXT:    s_lshr_b32 s0, s0, 24
; GFX6-NEXT:    s_lshl_b32 s1, s1, 8
; GFX6-NEXT:    s_or_b32 s0, s0, s1
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_uaddsat_v2i8:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_bfe_u32 s4, 8, 0x100000
; GFX8-NEXT:    s_lshr_b32 s3, s1, 8
; GFX8-NEXT:    s_lshl_b32 s1, s1, s4
; GFX8-NEXT:    s_lshr_b32 s2, s0, 8
; GFX8-NEXT:    s_lshl_b32 s0, s0, s4
; GFX8-NEXT:    v_mov_b32_e32 v0, s1
; GFX8-NEXT:    s_lshl_b32 s1, s3, s4
; GFX8-NEXT:    v_add_u16_e64 v0, s0, v0 clamp
; GFX8-NEXT:    s_lshl_b32 s0, s2, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u16_e64 v1, s0, v1 clamp
; GFX8-NEXT:    v_lshrrev_b16_e32 v1, 8, v1
; GFX8-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
; GFX8-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_uaddsat_v2i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_lshr_b32 s2, s0, 8
; GFX9-NEXT:    s_lshr_b32 s3, s1, 8
; GFX9-NEXT:    s_pack_ll_b32_b16 s0, s0, s2
; GFX9-NEXT:    s_pack_ll_b32_b16 s1, s1, s3
; GFX9-NEXT:    s_mov_b32 s2, 0x80008
; GFX9-NEXT:    s_lshr_b32 s3, s0, 16
; GFX9-NEXT:    s_lshl_b32 s0, s0, s2
; GFX9-NEXT:    s_lshl_b32 s3, s3, 8
; GFX9-NEXT:    s_pack_ll_b32_b16 s0, s0, s3
; GFX9-NEXT:    s_lshr_b32 s3, s1, 16
; GFX9-NEXT:    s_lshl_b32 s1, s1, s2
; GFX9-NEXT:    s_lshl_b32 s2, s3, 8
; GFX9-NEXT:    s_pack_ll_b32_b16 s1, s1, s2
; GFX9-NEXT:    v_mov_b32_e32 v0, s1
; GFX9-NEXT:    v_pk_add_u16 v0, s0, v0 clamp
; GFX9-NEXT:    v_pk_lshrrev_b16 v0, 8, v0 op_sel_hi:[0,1]
; GFX9-NEXT:    s_movk_i32 s0, 0xff
; GFX9-NEXT:    v_and_b32_sdwa v1, v0, s0 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_uaddsat_v2i8:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_lshr_b32 s2, s0, 8
; GFX10-NEXT:    s_lshr_b32 s3, s1, 8
; GFX10-NEXT:    s_pack_ll_b32_b16 s0, s0, s2
; GFX10-NEXT:    s_pack_ll_b32_b16 s1, s1, s3
; GFX10-NEXT:    s_mov_b32 s2, 0x80008
; GFX10-NEXT:    s_lshr_b32 s3, s0, 16
; GFX10-NEXT:    s_lshr_b32 s4, s1, 16
; GFX10-NEXT:    s_lshl_b32 s0, s0, s2
; GFX10-NEXT:    s_lshl_b32 s3, s3, 8
; GFX10-NEXT:    s_lshl_b32 s1, s1, s2
; GFX10-NEXT:    s_lshl_b32 s2, s4, 8
; GFX10-NEXT:    s_pack_ll_b32_b16 s0, s0, s3
; GFX10-NEXT:    s_pack_ll_b32_b16 s1, s1, s2
; GFX10-NEXT:    v_pk_add_u16 v0, s0, s1 clamp
; GFX10-NEXT:    s_movk_i32 s0, 0xff
; GFX10-NEXT:    v_pk_lshrrev_b16 v0, 8, v0 op_sel_hi:[0,1]
; GFX10-NEXT:    v_and_b32_sdwa v1, v0, s0 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    ; return to shader part epilog
  %lhs = bitcast i16 %lhs.arg to <2 x i8>
  %rhs = bitcast i16 %rhs.arg to <2 x i8>
  %result = call <2 x i8> @llvm.uadd.sat.v2i8(<2 x i8> %lhs, <2 x i8> %rhs)
  %cast.result = bitcast <2 x i8> %result to i16
  ret i16 %cast.result
}

define i32 @v_uaddsat_v4i8(i32 %lhs.arg, i32 %rhs.arg) {
; GFX6-LABEL: v_uaddsat_v4i8:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX6-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; GFX6-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; GFX6-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; GFX6-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX6-NEXT:    v_xor_b32_e32 v8, -1, v0
; GFX6-NEXT:    v_min_u32_e32 v1, v8, v1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 24, v2
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 24, v5
; GFX6-NEXT:    v_xor_b32_e32 v5, -1, v1
; GFX6-NEXT:    v_min_u32_e32 v2, v5, v2
; GFX6-NEXT:    v_add_i32_e32 v1, vcc, v1, v2
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 24, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, 24, v6
; GFX6-NEXT:    v_xor_b32_e32 v5, -1, v2
; GFX6-NEXT:    v_min_u32_e32 v3, v5, v3
; GFX6-NEXT:    v_add_i32_e32 v2, vcc, v2, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, 24, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 24, v7
; GFX6-NEXT:    v_xor_b32_e32 v5, -1, v3
; GFX6-NEXT:    v_lshrrev_b32_e32 v1, 24, v1
; GFX6-NEXT:    v_min_u32_e32 v4, v5, v4
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GFX6-NEXT:    v_add_i32_e32 v3, vcc, v3, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, 24, v3
; GFX6-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX6-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX6-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_uaddsat_v4i8:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, 8
; GFX8-NEXT:    v_lshrrev_b32_sdwa v3, v2, v0 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 16, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 24, v0
; GFX8-NEXT:    v_lshrrev_b32_sdwa v2, v2, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX8-NEXT:    v_lshlrev_b16_e32 v0, 8, v0
; GFX8-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX8-NEXT:    v_add_u16_e64 v0, v0, v1 clamp
; GFX8-NEXT:    v_add_u16_e64 v1, v3, v2 clamp
; GFX8-NEXT:    v_lshlrev_b16_e32 v2, 8, v4
; GFX8-NEXT:    v_lshlrev_b16_e32 v3, 8, v6
; GFX8-NEXT:    v_add_u16_e64 v2, v2, v3 clamp
; GFX8-NEXT:    v_lshlrev_b16_e32 v3, 8, v5
; GFX8-NEXT:    v_lshlrev_b16_e32 v4, 8, v7
; GFX8-NEXT:    v_add_u16_e64 v3, v3, v4 clamp
; GFX8-NEXT:    v_mov_b32_e32 v4, 0xff
; GFX8-NEXT:    v_and_b32_sdwa v1, v1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v0, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_and_b32_sdwa v1, v2, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_and_b32_sdwa v1, v3, v4 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uaddsat_v4i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s4, 8
; GFX9-NEXT:    v_lshrrev_b32_sdwa v2, s4, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX9-NEXT:    v_mov_b32_e32 v8, 0xffff
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX9-NEXT:    v_lshrrev_b32_sdwa v5, s4, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX9-NEXT:    v_and_or_b32 v0, v0, v8, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; GFX9-NEXT:    v_and_or_b32 v2, v3, v8, v2
; GFX9-NEXT:    v_and_or_b32 v1, v1, v8, v5
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, 16, v7
; GFX9-NEXT:    v_pk_lshlrev_b16 v0, 8, v0 op_sel_hi:[0,1]
; GFX9-NEXT:    v_and_or_b32 v3, v6, v8, v3
; GFX9-NEXT:    v_pk_lshlrev_b16 v1, 8, v1 op_sel_hi:[0,1]
; GFX9-NEXT:    v_pk_lshlrev_b16 v2, 8, v2 op_sel_hi:[0,1]
; GFX9-NEXT:    v_pk_lshlrev_b16 v3, 8, v3 op_sel_hi:[0,1]
; GFX9-NEXT:    v_pk_add_u16 v0, v0, v1 clamp
; GFX9-NEXT:    v_pk_add_u16 v1, v2, v3 clamp
; GFX9-NEXT:    v_pk_lshrrev_b16 v0, 8, v0 op_sel_hi:[0,1]
; GFX9-NEXT:    v_mov_b32_e32 v2, 8
; GFX9-NEXT:    v_pk_lshrrev_b16 v1, 8, v1 op_sel_hi:[0,1]
; GFX9-NEXT:    s_movk_i32 s4, 0xff
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v0, s4, v2
; GFX9-NEXT:    v_and_b32_e32 v2, s4, v1
; GFX9-NEXT:    v_mov_b32_e32 v3, 24
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v1, v3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_or3_b32 v0, v0, v2, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uaddsat_v4i8:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX10-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX10-NEXT:    s_mov_b32 s4, 8
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX10-NEXT:    v_lshrrev_b32_sdwa v2, s4, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_lshrrev_b32_sdwa v6, s4, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_mov_b32_e32 v7, 0xffff
; GFX10-NEXT:    v_lshrrev_b32_e32 v8, 16, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX10-NEXT:    s_movk_i32 s4, 0xff
; GFX10-NEXT:    v_and_or_b32 v0, v0, v7, v2
; GFX10-NEXT:    v_and_or_b32 v1, v1, v7, v6
; GFX10-NEXT:    v_and_or_b32 v2, v3, v7, v4
; GFX10-NEXT:    v_and_or_b32 v3, v8, v7, v5
; GFX10-NEXT:    v_mov_b32_e32 v4, 24
; GFX10-NEXT:    v_pk_lshlrev_b16 v0, 8, v0 op_sel_hi:[0,1]
; GFX10-NEXT:    v_pk_lshlrev_b16 v1, 8, v1 op_sel_hi:[0,1]
; GFX10-NEXT:    v_pk_lshlrev_b16 v2, 8, v2 op_sel_hi:[0,1]
; GFX10-NEXT:    v_pk_lshlrev_b16 v3, 8, v3 op_sel_hi:[0,1]
; GFX10-NEXT:    v_pk_add_u16 v0, v0, v1 clamp
; GFX10-NEXT:    v_pk_add_u16 v1, v2, v3 clamp
; GFX10-NEXT:    v_mov_b32_e32 v2, 8
; GFX10-NEXT:    v_pk_lshrrev_b16 v0, 8, v0 op_sel_hi:[0,1]
; GFX10-NEXT:    v_pk_lshrrev_b16 v1, 8, v1 op_sel_hi:[0,1]
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_b32_e32 v3, s4, v1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, v0, s4, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX10-NEXT:    v_or3_b32 v0, v0, v2, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %lhs = bitcast i32 %lhs.arg to <4 x i8>
  %rhs = bitcast i32 %rhs.arg to <4 x i8>
  %result = call <4 x i8> @llvm.uadd.sat.v4i8(<4 x i8> %lhs, <4 x i8> %rhs)
  %cast.result = bitcast <4 x i8> %result to i32
  ret i32 %cast.result
}

define amdgpu_ps i32 @s_uaddsat_v4i8(i32 inreg %lhs.arg, i32 inreg %rhs.arg) {
; GFX6-LABEL: s_uaddsat_v4i8:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_lshr_b32 s2, s0, 8
; GFX6-NEXT:    s_lshr_b32 s3, s0, 16
; GFX6-NEXT:    s_lshr_b32 s4, s0, 24
; GFX6-NEXT:    s_lshl_b32 s0, s0, 24
; GFX6-NEXT:    s_lshr_b32 s5, s1, 8
; GFX6-NEXT:    s_lshr_b32 s6, s1, 16
; GFX6-NEXT:    s_lshr_b32 s7, s1, 24
; GFX6-NEXT:    s_lshl_b32 s1, s1, 24
; GFX6-NEXT:    s_not_b32 s8, s0
; GFX6-NEXT:    s_min_u32 s1, s8, s1
; GFX6-NEXT:    s_add_i32 s0, s0, s1
; GFX6-NEXT:    s_lshl_b32 s1, s2, 24
; GFX6-NEXT:    s_lshl_b32 s2, s5, 24
; GFX6-NEXT:    s_not_b32 s5, s1
; GFX6-NEXT:    s_min_u32 s2, s5, s2
; GFX6-NEXT:    s_add_i32 s1, s1, s2
; GFX6-NEXT:    s_lshl_b32 s2, s3, 24
; GFX6-NEXT:    s_lshl_b32 s3, s6, 24
; GFX6-NEXT:    s_not_b32 s5, s2
; GFX6-NEXT:    s_min_u32 s3, s5, s3
; GFX6-NEXT:    s_add_i32 s2, s2, s3
; GFX6-NEXT:    s_lshl_b32 s3, s4, 24
; GFX6-NEXT:    s_lshl_b32 s4, s7, 24
; GFX6-NEXT:    s_not_b32 s5, s3
; GFX6-NEXT:    s_lshr_b32 s1, s1, 24
; GFX6-NEXT:    s_min_u32 s4, s5, s4
; GFX6-NEXT:    s_lshr_b32 s0, s0, 24
; GFX6-NEXT:    s_lshr_b32 s2, s2, 24
; GFX6-NEXT:    s_add_i32 s3, s3, s4
; GFX6-NEXT:    s_lshl_b32 s1, s1, 8
; GFX6-NEXT:    s_lshr_b32 s3, s3, 24
; GFX6-NEXT:    s_or_b32 s0, s0, s1
; GFX6-NEXT:    s_lshl_b32 s1, s2, 16
; GFX6-NEXT:    s_or_b32 s0, s0, s1
; GFX6-NEXT:    s_lshl_b32 s1, s3, 24
; GFX6-NEXT:    s_or_b32 s0, s0, s1
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_uaddsat_v4i8:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_bfe_u32 s8, 8, 0x100000
; GFX8-NEXT:    s_lshr_b32 s5, s1, 8
; GFX8-NEXT:    s_lshr_b32 s6, s1, 16
; GFX8-NEXT:    s_lshr_b32 s7, s1, 24
; GFX8-NEXT:    s_lshl_b32 s1, s1, s8
; GFX8-NEXT:    s_lshr_b32 s2, s0, 8
; GFX8-NEXT:    s_lshr_b32 s3, s0, 16
; GFX8-NEXT:    s_lshr_b32 s4, s0, 24
; GFX8-NEXT:    s_lshl_b32 s0, s0, s8
; GFX8-NEXT:    v_mov_b32_e32 v0, s1
; GFX8-NEXT:    s_lshl_b32 s1, s5, s8
; GFX8-NEXT:    v_add_u16_e64 v0, s0, v0 clamp
; GFX8-NEXT:    s_lshl_b32 s0, s2, s8
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u16_e64 v1, s0, v1 clamp
; GFX8-NEXT:    s_lshl_b32 s1, s6, s8
; GFX8-NEXT:    v_mov_b32_e32 v4, 0xff
; GFX8-NEXT:    s_lshl_b32 s0, s3, s8
; GFX8-NEXT:    v_mov_b32_e32 v2, s1
; GFX8-NEXT:    s_lshl_b32 s1, s7, s8
; GFX8-NEXT:    v_and_b32_sdwa v1, v1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
; GFX8-NEXT:    v_add_u16_e64 v2, s0, v2 clamp
; GFX8-NEXT:    s_lshl_b32 s0, s4, s8
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_and_b32_sdwa v0, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX8-NEXT:    v_add_u16_e64 v3, s0, v3 clamp
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_and_b32_sdwa v1, v2, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_and_b32_sdwa v1, v3, v4 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_uaddsat_v4i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_lshr_b32 s3, s0, 8
; GFX9-NEXT:    s_lshr_b32 s4, s0, 16
; GFX9-NEXT:    s_lshr_b32 s6, s0, 24
; GFX9-NEXT:    s_pack_ll_b32_b16 s0, s0, s3
; GFX9-NEXT:    s_pack_ll_b32_b16 s3, s4, s6
; GFX9-NEXT:    s_mov_b32 s4, 0x80008
; GFX9-NEXT:    s_lshr_b32 s6, s0, 16
; GFX9-NEXT:    s_lshr_b32 s7, s1, 8
; GFX9-NEXT:    s_lshl_b32 s0, s0, s4
; GFX9-NEXT:    s_lshl_b32 s6, s6, 8
; GFX9-NEXT:    s_lshr_b32 s8, s1, 16
; GFX9-NEXT:    s_lshr_b32 s9, s1, 24
; GFX9-NEXT:    s_pack_ll_b32_b16 s0, s0, s6
; GFX9-NEXT:    s_lshr_b32 s6, s3, 16
; GFX9-NEXT:    s_pack_ll_b32_b16 s1, s1, s7
; GFX9-NEXT:    s_lshl_b32 s3, s3, s4
; GFX9-NEXT:    s_lshl_b32 s6, s6, 8
; GFX9-NEXT:    s_lshr_b32 s7, s1, 16
; GFX9-NEXT:    s_pack_ll_b32_b16 s3, s3, s6
; GFX9-NEXT:    s_pack_ll_b32_b16 s6, s8, s9
; GFX9-NEXT:    s_lshl_b32 s1, s1, s4
; GFX9-NEXT:    s_lshl_b32 s7, s7, 8
; GFX9-NEXT:    s_pack_ll_b32_b16 s1, s1, s7
; GFX9-NEXT:    s_lshr_b32 s7, s6, 16
; GFX9-NEXT:    s_lshl_b32 s4, s6, s4
; GFX9-NEXT:    s_lshl_b32 s6, s7, 8
; GFX9-NEXT:    s_pack_ll_b32_b16 s4, s4, s6
; GFX9-NEXT:    v_mov_b32_e32 v0, s1
; GFX9-NEXT:    v_pk_add_u16 v0, s0, v0 clamp
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:    s_mov_b32 s2, 8
; GFX9-NEXT:    v_pk_add_u16 v1, s3, v1 clamp
; GFX9-NEXT:    v_pk_lshrrev_b16 v0, 8, v0 op_sel_hi:[0,1]
; GFX9-NEXT:    v_pk_lshrrev_b16 v1, 8, v1 op_sel_hi:[0,1]
; GFX9-NEXT:    s_movk_i32 s0, 0xff
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, s2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    s_mov_b32 s5, 24
; GFX9-NEXT:    v_and_or_b32 v0, v0, s0, v2
; GFX9-NEXT:    v_and_b32_e32 v2, s0, v1
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v1, s5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_or3_b32 v0, v0, v2, v1
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_uaddsat_v4i8:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_lshr_b32 s2, s0, 8
; GFX10-NEXT:    s_lshr_b32 s3, s0, 16
; GFX10-NEXT:    s_lshr_b32 s4, s0, 24
; GFX10-NEXT:    s_pack_ll_b32_b16 s0, s0, s2
; GFX10-NEXT:    s_pack_ll_b32_b16 s2, s3, s4
; GFX10-NEXT:    s_mov_b32 s3, 0x80008
; GFX10-NEXT:    s_lshr_b32 s4, s0, 16
; GFX10-NEXT:    s_lshr_b32 s5, s1, 8
; GFX10-NEXT:    s_lshr_b32 s6, s1, 16
; GFX10-NEXT:    s_lshr_b32 s7, s1, 24
; GFX10-NEXT:    s_lshl_b32 s0, s0, s3
; GFX10-NEXT:    s_lshl_b32 s4, s4, 8
; GFX10-NEXT:    s_pack_ll_b32_b16 s1, s1, s5
; GFX10-NEXT:    s_pack_ll_b32_b16 s0, s0, s4
; GFX10-NEXT:    s_pack_ll_b32_b16 s4, s6, s7
; GFX10-NEXT:    s_lshr_b32 s8, s2, 16
; GFX10-NEXT:    s_lshr_b32 s5, s1, 16
; GFX10-NEXT:    s_lshr_b32 s6, s4, 16
; GFX10-NEXT:    s_lshl_b32 s2, s2, s3
; GFX10-NEXT:    s_lshl_b32 s8, s8, 8
; GFX10-NEXT:    s_lshl_b32 s1, s1, s3
; GFX10-NEXT:    s_lshl_b32 s5, s5, 8
; GFX10-NEXT:    s_lshl_b32 s3, s4, s3
; GFX10-NEXT:    s_lshl_b32 s4, s6, 8
; GFX10-NEXT:    s_pack_ll_b32_b16 s2, s2, s8
; GFX10-NEXT:    s_pack_ll_b32_b16 s1, s1, s5
; GFX10-NEXT:    s_pack_ll_b32_b16 s3, s3, s4
; GFX10-NEXT:    v_pk_add_u16 v0, s0, s1 clamp
; GFX10-NEXT:    v_pk_add_u16 v1, s2, s3 clamp
; GFX10-NEXT:    s_mov_b32 s0, 8
; GFX10-NEXT:    s_movk_i32 s1, 0xff
; GFX10-NEXT:    v_pk_lshrrev_b16 v0, 8, v0 op_sel_hi:[0,1]
; GFX10-NEXT:    v_pk_lshrrev_b16 v1, 8, v1 op_sel_hi:[0,1]
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_b32_e32 v3, s1, v1
; GFX10-NEXT:    s_mov_b32 s0, 24
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, s0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, v0, s1, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX10-NEXT:    v_or3_b32 v0, v0, v2, v1
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    ; return to shader part epilog
  %lhs = bitcast i32 %lhs.arg to <4 x i8>
  %rhs = bitcast i32 %rhs.arg to <4 x i8>
  %result = call <4 x i8> @llvm.uadd.sat.v4i8(<4 x i8> %lhs, <4 x i8> %rhs)
  %cast.result = bitcast <4 x i8> %result to i32
  ret i32 %cast.result
}

define i24 @v_uaddsat_i24(i24 %lhs, i24 %rhs) {
; GFX6-LABEL: v_uaddsat_i24:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX6-NEXT:    v_xor_b32_e32 v2, -1, v0
; GFX6-NEXT:    v_min_u32_e32 v1, v2, v1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_uaddsat_i24:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX8-NEXT:    v_add_u32_e64 v0, s[4:5], v0, v1 clamp
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uaddsat_i24:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX9-NEXT:    v_add_u32_e64 v0, v0, v1 clamp
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uaddsat_i24:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX10-NEXT:    v_add_nc_u32_e64 v0, v0, v1 clamp
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call i24 @llvm.uadd.sat.i24(i24 %lhs, i24 %rhs)
  ret i24 %result
}

define amdgpu_ps i24 @s_uaddsat_i24(i24 inreg %lhs, i24 inreg %rhs) {
; GFX6-LABEL: s_uaddsat_i24:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_lshl_b32 s0, s0, 8
; GFX6-NEXT:    s_lshl_b32 s1, s1, 8
; GFX6-NEXT:    s_not_b32 s2, s0
; GFX6-NEXT:    s_min_u32 s1, s2, s1
; GFX6-NEXT:    s_add_i32 s0, s0, s1
; GFX6-NEXT:    s_lshr_b32 s0, s0, 8
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_uaddsat_i24:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_lshl_b32 s1, s1, 8
; GFX8-NEXT:    s_lshl_b32 s0, s0, 8
; GFX8-NEXT:    v_mov_b32_e32 v0, s1
; GFX8-NEXT:    v_add_u32_e64 v0, s[0:1], s0, v0 clamp
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX8-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_uaddsat_i24:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_lshl_b32 s1, s1, 8
; GFX9-NEXT:    s_lshl_b32 s0, s0, 8
; GFX9-NEXT:    v_mov_b32_e32 v0, s1
; GFX9-NEXT:    v_add_u32_e64 v0, s0, v0 clamp
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_uaddsat_i24:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_lshl_b32 s0, s0, 8
; GFX10-NEXT:    s_lshl_b32 s1, s1, 8
; GFX10-NEXT:    v_add_nc_u32_e64 v0, s0, s1 clamp
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    ; return to shader part epilog
  %result = call i24 @llvm.uadd.sat.i24(i24 %lhs, i24 %rhs)
  ret i24 %result
}

define i32 @v_uaddsat_i32(i32 %lhs, i32 %rhs) {
; GFX6-LABEL: v_uaddsat_i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_xor_b32_e32 v2, -1, v0
; GFX6-NEXT:    v_min_u32_e32 v1, v2, v1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_uaddsat_i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e64 v0, s[4:5], v0, v1 clamp
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uaddsat_i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_u32_e64 v0, v0, v1 clamp
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uaddsat_i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_nc_u32_e64 v0, v0, v1 clamp
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call i32 @llvm.uadd.sat.i32(i32 %lhs, i32 %rhs)
  ret i32 %result
}

define amdgpu_ps i32 @s_uaddsat_i32(i32 inreg %lhs, i32 inreg %rhs) {
; GFX6-LABEL: s_uaddsat_i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_not_b32 s2, s0
; GFX6-NEXT:    s_min_u32 s1, s2, s1
; GFX6-NEXT:    s_add_i32 s0, s0, s1
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_uaddsat_i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v0, s1
; GFX8-NEXT:    v_add_u32_e64 v0, s[0:1], s0, v0 clamp
; GFX8-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_uaddsat_i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v0, s1
; GFX9-NEXT:    v_add_u32_e64 v0, s0, v0 clamp
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_uaddsat_i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_add_nc_u32_e64 v0, s0, s1 clamp
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    ; return to shader part epilog
  %result = call i32 @llvm.uadd.sat.i32(i32 %lhs, i32 %rhs)
  ret i32 %result
}

define amdgpu_ps float @uaddsat_i32_sv(i32 inreg %lhs, i32 %rhs) {
; GFX6-LABEL: uaddsat_i32_sv:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_not_b32 s1, s0
; GFX6-NEXT:    v_min_u32_e32 v0, s1, v0
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, s0, v0
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: uaddsat_i32_sv:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_add_u32_e64 v0, s[0:1], s0, v0 clamp
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: uaddsat_i32_sv:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_add_u32_e64 v0, s0, v0 clamp
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: uaddsat_i32_sv:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_add_nc_u32_e64 v0, s0, v0 clamp
; GFX10-NEXT:    ; return to shader part epilog
  %result = call i32 @llvm.uadd.sat.i32(i32 %lhs, i32 %rhs)
  %cast = bitcast i32 %result to float
  ret float %cast
}

define amdgpu_ps float @uaddsat_i32_vs(i32 %lhs, i32 inreg %rhs) {
; GFX6-LABEL: uaddsat_i32_vs:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_xor_b32_e32 v1, -1, v0
; GFX6-NEXT:    v_min_u32_e32 v1, s0, v1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: uaddsat_i32_vs:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_add_u32_e64 v0, s[0:1], v0, s0 clamp
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: uaddsat_i32_vs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_add_u32_e64 v0, v0, s0 clamp
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: uaddsat_i32_vs:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_add_nc_u32_e64 v0, v0, s0 clamp
; GFX10-NEXT:    ; return to shader part epilog
  %result = call i32 @llvm.uadd.sat.i32(i32 %lhs, i32 %rhs)
  %cast = bitcast i32 %result to float
  ret float %cast
}

define <2 x i32> @v_uaddsat_v2i32(<2 x i32> %lhs, <2 x i32> %rhs) {
; GFX6-LABEL: v_uaddsat_v2i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_xor_b32_e32 v4, -1, v0
; GFX6-NEXT:    v_min_u32_e32 v2, v4, v2
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX6-NEXT:    v_xor_b32_e32 v2, -1, v1
; GFX6-NEXT:    v_min_u32_e32 v2, v2, v3
; GFX6-NEXT:    v_add_i32_e32 v1, vcc, v1, v2
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_uaddsat_v2i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e64 v0, s[4:5], v0, v2 clamp
; GFX8-NEXT:    v_add_u32_e64 v1, s[4:5], v1, v3 clamp
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uaddsat_v2i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_u32_e64 v0, v0, v2 clamp
; GFX9-NEXT:    v_add_u32_e64 v1, v1, v3 clamp
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uaddsat_v2i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_nc_u32_e64 v0, v0, v2 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v1, v1, v3 clamp
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call <2 x i32> @llvm.uadd.sat.v2i32(<2 x i32> %lhs, <2 x i32> %rhs)
  ret <2 x i32> %result
}

define amdgpu_ps <2 x i32> @s_uaddsat_v2i32(<2 x i32> inreg %lhs, <2 x i32> inreg %rhs) {
; GFX6-LABEL: s_uaddsat_v2i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_not_b32 s4, s0
; GFX6-NEXT:    s_min_u32 s2, s4, s2
; GFX6-NEXT:    s_add_i32 s0, s0, s2
; GFX6-NEXT:    s_not_b32 s2, s1
; GFX6-NEXT:    s_min_u32 s2, s2, s3
; GFX6-NEXT:    s_add_i32 s1, s1, s2
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_uaddsat_v2i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_add_u32_e64 v0, s[4:5], s0, v0 clamp
; GFX8-NEXT:    v_add_u32_e64 v1, s[0:1], s1, v1 clamp
; GFX8-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-NEXT:    v_readfirstlane_b32 s1, v1
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_uaddsat_v2i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    v_add_u32_e64 v0, s0, v0 clamp
; GFX9-NEXT:    v_add_u32_e64 v1, s1, v1 clamp
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    v_readfirstlane_b32 s1, v1
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_uaddsat_v2i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_add_nc_u32_e64 v0, s0, s2 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v1, s1, s3 clamp
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    v_readfirstlane_b32 s1, v1
; GFX10-NEXT:    ; return to shader part epilog
  %result = call <2 x i32> @llvm.uadd.sat.v2i32(<2 x i32> %lhs, <2 x i32> %rhs)
  ret <2 x i32> %result
}

define <3 x i32> @v_uaddsat_v3i32(<3 x i32> %lhs, <3 x i32> %rhs) {
; GFX6-LABEL: v_uaddsat_v3i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_xor_b32_e32 v6, -1, v0
; GFX6-NEXT:    v_min_u32_e32 v3, v6, v3
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v3
; GFX6-NEXT:    v_xor_b32_e32 v3, -1, v1
; GFX6-NEXT:    v_min_u32_e32 v3, v3, v4
; GFX6-NEXT:    v_add_i32_e32 v1, vcc, v1, v3
; GFX6-NEXT:    v_xor_b32_e32 v3, -1, v2
; GFX6-NEXT:    v_min_u32_e32 v3, v3, v5
; GFX6-NEXT:    v_add_i32_e32 v2, vcc, v2, v3
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_uaddsat_v3i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e64 v0, s[4:5], v0, v3 clamp
; GFX8-NEXT:    v_add_u32_e64 v1, s[4:5], v1, v4 clamp
; GFX8-NEXT:    v_add_u32_e64 v2, s[4:5], v2, v5 clamp
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uaddsat_v3i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_u32_e64 v0, v0, v3 clamp
; GFX9-NEXT:    v_add_u32_e64 v1, v1, v4 clamp
; GFX9-NEXT:    v_add_u32_e64 v2, v2, v5 clamp
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uaddsat_v3i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_nc_u32_e64 v0, v0, v3 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v1, v1, v4 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v2, v2, v5 clamp
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call <3 x i32> @llvm.uadd.sat.v3i32(<3 x i32> %lhs, <3 x i32> %rhs)
  ret <3 x i32> %result
}

define amdgpu_ps <3 x i32> @s_uaddsat_v3i32(<3 x i32> inreg %lhs, <3 x i32> inreg %rhs) {
; GFX6-LABEL: s_uaddsat_v3i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_not_b32 s6, s0
; GFX6-NEXT:    s_min_u32 s3, s6, s3
; GFX6-NEXT:    s_add_i32 s0, s0, s3
; GFX6-NEXT:    s_not_b32 s3, s1
; GFX6-NEXT:    s_min_u32 s3, s3, s4
; GFX6-NEXT:    s_add_i32 s1, s1, s3
; GFX6-NEXT:    s_not_b32 s3, s2
; GFX6-NEXT:    s_min_u32 s3, s3, s5
; GFX6-NEXT:    s_add_i32 s2, s2, s3
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_uaddsat_v3i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v0, s3
; GFX8-NEXT:    v_mov_b32_e32 v1, s4
; GFX8-NEXT:    v_mov_b32_e32 v2, s5
; GFX8-NEXT:    v_add_u32_e64 v0, s[6:7], s0, v0 clamp
; GFX8-NEXT:    v_add_u32_e64 v1, s[0:1], s1, v1 clamp
; GFX8-NEXT:    v_add_u32_e64 v2, s[0:1], s2, v2 clamp
; GFX8-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-NEXT:    v_readfirstlane_b32 s1, v1
; GFX8-NEXT:    v_readfirstlane_b32 s2, v2
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_uaddsat_v3i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:    v_mov_b32_e32 v2, s5
; GFX9-NEXT:    v_add_u32_e64 v0, s0, v0 clamp
; GFX9-NEXT:    v_add_u32_e64 v1, s1, v1 clamp
; GFX9-NEXT:    v_add_u32_e64 v2, s2, v2 clamp
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    v_readfirstlane_b32 s1, v1
; GFX9-NEXT:    v_readfirstlane_b32 s2, v2
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_uaddsat_v3i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_add_nc_u32_e64 v0, s0, s3 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v1, s1, s4 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v2, s2, s5 clamp
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    v_readfirstlane_b32 s1, v1
; GFX10-NEXT:    v_readfirstlane_b32 s2, v2
; GFX10-NEXT:    ; return to shader part epilog
  %result = call <3 x i32> @llvm.uadd.sat.v3i32(<3 x i32> %lhs, <3 x i32> %rhs)
  ret <3 x i32> %result
}

define <4 x i32> @v_uaddsat_v4i32(<4 x i32> %lhs, <4 x i32> %rhs) {
; GFX6-LABEL: v_uaddsat_v4i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_xor_b32_e32 v8, -1, v0
; GFX6-NEXT:    v_min_u32_e32 v4, v8, v4
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v4
; GFX6-NEXT:    v_xor_b32_e32 v4, -1, v1
; GFX6-NEXT:    v_min_u32_e32 v4, v4, v5
; GFX6-NEXT:    v_add_i32_e32 v1, vcc, v1, v4
; GFX6-NEXT:    v_xor_b32_e32 v4, -1, v2
; GFX6-NEXT:    v_min_u32_e32 v4, v4, v6
; GFX6-NEXT:    v_add_i32_e32 v2, vcc, v2, v4
; GFX6-NEXT:    v_xor_b32_e32 v4, -1, v3
; GFX6-NEXT:    v_min_u32_e32 v4, v4, v7
; GFX6-NEXT:    v_add_i32_e32 v3, vcc, v3, v4
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_uaddsat_v4i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e64 v0, s[4:5], v0, v4 clamp
; GFX8-NEXT:    v_add_u32_e64 v1, s[4:5], v1, v5 clamp
; GFX8-NEXT:    v_add_u32_e64 v2, s[4:5], v2, v6 clamp
; GFX8-NEXT:    v_add_u32_e64 v3, s[4:5], v3, v7 clamp
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uaddsat_v4i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_u32_e64 v0, v0, v4 clamp
; GFX9-NEXT:    v_add_u32_e64 v1, v1, v5 clamp
; GFX9-NEXT:    v_add_u32_e64 v2, v2, v6 clamp
; GFX9-NEXT:    v_add_u32_e64 v3, v3, v7 clamp
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uaddsat_v4i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_nc_u32_e64 v0, v0, v4 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v1, v1, v5 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v2, v2, v6 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v3, v3, v7 clamp
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call <4 x i32> @llvm.uadd.sat.v4i32(<4 x i32> %lhs, <4 x i32> %rhs)
  ret <4 x i32> %result
}

define amdgpu_ps <4 x i32> @s_uaddsat_v4i32(<4 x i32> inreg %lhs, <4 x i32> inreg %rhs) {
; GFX6-LABEL: s_uaddsat_v4i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_not_b32 s8, s0
; GFX6-NEXT:    s_min_u32 s4, s8, s4
; GFX6-NEXT:    s_add_i32 s0, s0, s4
; GFX6-NEXT:    s_not_b32 s4, s1
; GFX6-NEXT:    s_min_u32 s4, s4, s5
; GFX6-NEXT:    s_add_i32 s1, s1, s4
; GFX6-NEXT:    s_not_b32 s4, s2
; GFX6-NEXT:    s_min_u32 s4, s4, s6
; GFX6-NEXT:    s_add_i32 s2, s2, s4
; GFX6-NEXT:    s_not_b32 s4, s3
; GFX6-NEXT:    s_min_u32 s4, s4, s7
; GFX6-NEXT:    s_add_i32 s3, s3, s4
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_uaddsat_v4i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_mov_b32_e32 v2, s6
; GFX8-NEXT:    v_mov_b32_e32 v3, s7
; GFX8-NEXT:    v_add_u32_e64 v0, s[8:9], s0, v0 clamp
; GFX8-NEXT:    v_add_u32_e64 v1, s[0:1], s1, v1 clamp
; GFX8-NEXT:    v_add_u32_e64 v2, s[0:1], s2, v2 clamp
; GFX8-NEXT:    v_add_u32_e64 v3, s[0:1], s3, v3 clamp
; GFX8-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-NEXT:    v_readfirstlane_b32 s1, v1
; GFX8-NEXT:    v_readfirstlane_b32 s2, v2
; GFX8-NEXT:    v_readfirstlane_b32 s3, v3
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_uaddsat_v4i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-NEXT:    v_mov_b32_e32 v3, s7
; GFX9-NEXT:    v_add_u32_e64 v0, s0, v0 clamp
; GFX9-NEXT:    v_add_u32_e64 v1, s1, v1 clamp
; GFX9-NEXT:    v_add_u32_e64 v2, s2, v2 clamp
; GFX9-NEXT:    v_add_u32_e64 v3, s3, v3 clamp
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    v_readfirstlane_b32 s1, v1
; GFX9-NEXT:    v_readfirstlane_b32 s2, v2
; GFX9-NEXT:    v_readfirstlane_b32 s3, v3
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_uaddsat_v4i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_add_nc_u32_e64 v0, s0, s4 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v1, s1, s5 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v2, s2, s6 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v3, s3, s7 clamp
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    v_readfirstlane_b32 s1, v1
; GFX10-NEXT:    v_readfirstlane_b32 s2, v2
; GFX10-NEXT:    v_readfirstlane_b32 s3, v3
; GFX10-NEXT:    ; return to shader part epilog
  %result = call <4 x i32> @llvm.uadd.sat.v4i32(<4 x i32> %lhs, <4 x i32> %rhs)
  ret <4 x i32> %result
}

define <5 x i32> @v_uaddsat_v5i32(<5 x i32> %lhs, <5 x i32> %rhs) {
; GFX6-LABEL: v_uaddsat_v5i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_xor_b32_e32 v10, -1, v0
; GFX6-NEXT:    v_min_u32_e32 v5, v10, v5
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v5
; GFX6-NEXT:    v_xor_b32_e32 v5, -1, v1
; GFX6-NEXT:    v_min_u32_e32 v5, v5, v6
; GFX6-NEXT:    v_add_i32_e32 v1, vcc, v1, v5
; GFX6-NEXT:    v_xor_b32_e32 v5, -1, v2
; GFX6-NEXT:    v_min_u32_e32 v5, v5, v7
; GFX6-NEXT:    v_add_i32_e32 v2, vcc, v2, v5
; GFX6-NEXT:    v_xor_b32_e32 v5, -1, v3
; GFX6-NEXT:    v_min_u32_e32 v5, v5, v8
; GFX6-NEXT:    v_add_i32_e32 v3, vcc, v3, v5
; GFX6-NEXT:    v_xor_b32_e32 v5, -1, v4
; GFX6-NEXT:    v_min_u32_e32 v5, v5, v9
; GFX6-NEXT:    v_add_i32_e32 v4, vcc, v4, v5
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_uaddsat_v5i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e64 v0, s[4:5], v0, v5 clamp
; GFX8-NEXT:    v_add_u32_e64 v1, s[4:5], v1, v6 clamp
; GFX8-NEXT:    v_add_u32_e64 v2, s[4:5], v2, v7 clamp
; GFX8-NEXT:    v_add_u32_e64 v3, s[4:5], v3, v8 clamp
; GFX8-NEXT:    v_add_u32_e64 v4, s[4:5], v4, v9 clamp
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uaddsat_v5i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_u32_e64 v0, v0, v5 clamp
; GFX9-NEXT:    v_add_u32_e64 v1, v1, v6 clamp
; GFX9-NEXT:    v_add_u32_e64 v2, v2, v7 clamp
; GFX9-NEXT:    v_add_u32_e64 v3, v3, v8 clamp
; GFX9-NEXT:    v_add_u32_e64 v4, v4, v9 clamp
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uaddsat_v5i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_nc_u32_e64 v0, v0, v5 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v1, v1, v6 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v2, v2, v7 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v3, v3, v8 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v4, v4, v9 clamp
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call <5 x i32> @llvm.uadd.sat.v5i32(<5 x i32> %lhs, <5 x i32> %rhs)
  ret <5 x i32> %result
}

define amdgpu_ps <5 x i32> @s_uaddsat_v5i32(<5 x i32> inreg %lhs, <5 x i32> inreg %rhs) {
; GFX6-LABEL: s_uaddsat_v5i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_not_b32 s10, s0
; GFX6-NEXT:    s_min_u32 s5, s10, s5
; GFX6-NEXT:    s_add_i32 s0, s0, s5
; GFX6-NEXT:    s_not_b32 s5, s1
; GFX6-NEXT:    s_min_u32 s5, s5, s6
; GFX6-NEXT:    s_add_i32 s1, s1, s5
; GFX6-NEXT:    s_not_b32 s5, s2
; GFX6-NEXT:    s_min_u32 s5, s5, s7
; GFX6-NEXT:    s_add_i32 s2, s2, s5
; GFX6-NEXT:    s_not_b32 s5, s3
; GFX6-NEXT:    s_min_u32 s5, s5, s8
; GFX6-NEXT:    s_add_i32 s3, s3, s5
; GFX6-NEXT:    s_not_b32 s5, s4
; GFX6-NEXT:    s_min_u32 s5, s5, s9
; GFX6-NEXT:    s_add_i32 s4, s4, s5
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_uaddsat_v5i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v0, s5
; GFX8-NEXT:    v_mov_b32_e32 v1, s6
; GFX8-NEXT:    v_mov_b32_e32 v2, s7
; GFX8-NEXT:    v_mov_b32_e32 v3, s8
; GFX8-NEXT:    v_mov_b32_e32 v4, s9
; GFX8-NEXT:    v_add_u32_e64 v0, s[10:11], s0, v0 clamp
; GFX8-NEXT:    v_add_u32_e64 v1, s[0:1], s1, v1 clamp
; GFX8-NEXT:    v_add_u32_e64 v2, s[0:1], s2, v2 clamp
; GFX8-NEXT:    v_add_u32_e64 v3, s[0:1], s3, v3 clamp
; GFX8-NEXT:    v_add_u32_e64 v4, s[0:1], s4, v4 clamp
; GFX8-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-NEXT:    v_readfirstlane_b32 s1, v1
; GFX8-NEXT:    v_readfirstlane_b32 s2, v2
; GFX8-NEXT:    v_readfirstlane_b32 s3, v3
; GFX8-NEXT:    v_readfirstlane_b32 s4, v4
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_uaddsat_v5i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v0, s5
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    v_mov_b32_e32 v2, s7
; GFX9-NEXT:    v_mov_b32_e32 v3, s8
; GFX9-NEXT:    v_mov_b32_e32 v4, s9
; GFX9-NEXT:    v_add_u32_e64 v0, s0, v0 clamp
; GFX9-NEXT:    v_add_u32_e64 v1, s1, v1 clamp
; GFX9-NEXT:    v_add_u32_e64 v2, s2, v2 clamp
; GFX9-NEXT:    v_add_u32_e64 v3, s3, v3 clamp
; GFX9-NEXT:    v_add_u32_e64 v4, s4, v4 clamp
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    v_readfirstlane_b32 s1, v1
; GFX9-NEXT:    v_readfirstlane_b32 s2, v2
; GFX9-NEXT:    v_readfirstlane_b32 s3, v3
; GFX9-NEXT:    v_readfirstlane_b32 s4, v4
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_uaddsat_v5i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_add_nc_u32_e64 v0, s0, s5 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v1, s1, s6 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v2, s2, s7 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v3, s3, s8 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v4, s4, s9 clamp
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    v_readfirstlane_b32 s1, v1
; GFX10-NEXT:    v_readfirstlane_b32 s2, v2
; GFX10-NEXT:    v_readfirstlane_b32 s3, v3
; GFX10-NEXT:    v_readfirstlane_b32 s4, v4
; GFX10-NEXT:    ; return to shader part epilog
  %result = call <5 x i32> @llvm.uadd.sat.v5i32(<5 x i32> %lhs, <5 x i32> %rhs)
  ret <5 x i32> %result
}

define <16 x i32> @v_uaddsat_v16i32(<16 x i32> %lhs, <16 x i32> %rhs) {
; GFX6-LABEL: v_uaddsat_v16i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_xor_b32_e32 v31, -1, v0
; GFX6-NEXT:    v_min_u32_e32 v16, v31, v16
; GFX6-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v16
; GFX6-NEXT:    v_xor_b32_e32 v16, -1, v1
; GFX6-NEXT:    v_min_u32_e32 v16, v16, v17
; GFX6-NEXT:    v_add_i32_e32 v1, vcc, v1, v16
; GFX6-NEXT:    v_xor_b32_e32 v16, -1, v2
; GFX6-NEXT:    v_min_u32_e32 v16, v16, v18
; GFX6-NEXT:    v_add_i32_e32 v2, vcc, v2, v16
; GFX6-NEXT:    v_xor_b32_e32 v16, -1, v3
; GFX6-NEXT:    v_min_u32_e32 v16, v16, v19
; GFX6-NEXT:    v_add_i32_e32 v3, vcc, v3, v16
; GFX6-NEXT:    v_xor_b32_e32 v16, -1, v4
; GFX6-NEXT:    v_min_u32_e32 v16, v16, v20
; GFX6-NEXT:    v_add_i32_e32 v4, vcc, v4, v16
; GFX6-NEXT:    v_xor_b32_e32 v16, -1, v5
; GFX6-NEXT:    v_min_u32_e32 v16, v16, v21
; GFX6-NEXT:    v_add_i32_e32 v5, vcc, v5, v16
; GFX6-NEXT:    v_xor_b32_e32 v16, -1, v6
; GFX6-NEXT:    v_min_u32_e32 v16, v16, v22
; GFX6-NEXT:    v_add_i32_e32 v6, vcc, v6, v16
; GFX6-NEXT:    v_xor_b32_e32 v16, -1, v7
; GFX6-NEXT:    v_min_u32_e32 v16, v16, v23
; GFX6-NEXT:    v_add_i32_e32 v7, vcc, v7, v16
; GFX6-NEXT:    v_xor_b32_e32 v16, -1, v8
; GFX6-NEXT:    v_min_u32_e32 v16, v16, v24
; GFX6-NEXT:    v_add_i32_e32 v8, vcc, v8, v16
; GFX6-NEXT:    v_xor_b32_e32 v16, -1, v9
; GFX6-NEXT:    v_min_u32_e32 v16, v16, v25
; GFX6-NEXT:    v_add_i32_e32 v9, vcc, v9, v16
; GFX6-NEXT:    v_xor_b32_e32 v16, -1, v10
; GFX6-NEXT:    v_min_u32_e32 v16, v16, v26
; GFX6-NEXT:    v_add_i32_e32 v10, vcc, v10, v16
; GFX6-NEXT:    v_xor_b32_e32 v16, -1, v11
; GFX6-NEXT:    v_min_u32_e32 v16, v16, v27
; GFX6-NEXT:    v_add_i32_e32 v11, vcc, v11, v16
; GFX6-NEXT:    v_xor_b32_e32 v16, -1, v12
; GFX6-NEXT:    v_min_u32_e32 v16, v16, v28
; GFX6-NEXT:    v_add_i32_e32 v12, vcc, v12, v16
; GFX6-NEXT:    v_xor_b32_e32 v16, -1, v13
; GFX6-NEXT:    v_min_u32_e32 v16, v16, v29
; GFX6-NEXT:    v_add_i32_e32 v13, vcc, v13, v16
; GFX6-NEXT:    v_xor_b32_e32 v16, -1, v14
; GFX6-NEXT:    v_min_u32_e32 v16, v16, v30
; GFX6-NEXT:    v_add_i32_e32 v14, vcc, v14, v16
; GFX6-NEXT:    v_xor_b32_e32 v16, -1, v15
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_min_u32_e32 v16, v16, v31
; GFX6-NEXT:    v_add_i32_e32 v15, vcc, v15, v16
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_uaddsat_v16i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e64 v0, s[4:5], v0, v16 clamp
; GFX8-NEXT:    buffer_load_dword v16, off, s[0:3], s32
; GFX8-NEXT:    v_add_u32_e64 v1, s[4:5], v1, v17 clamp
; GFX8-NEXT:    v_add_u32_e64 v2, s[4:5], v2, v18 clamp
; GFX8-NEXT:    v_add_u32_e64 v3, s[4:5], v3, v19 clamp
; GFX8-NEXT:    v_add_u32_e64 v4, s[4:5], v4, v20 clamp
; GFX8-NEXT:    v_add_u32_e64 v5, s[4:5], v5, v21 clamp
; GFX8-NEXT:    v_add_u32_e64 v6, s[4:5], v6, v22 clamp
; GFX8-NEXT:    v_add_u32_e64 v7, s[4:5], v7, v23 clamp
; GFX8-NEXT:    v_add_u32_e64 v8, s[4:5], v8, v24 clamp
; GFX8-NEXT:    v_add_u32_e64 v9, s[4:5], v9, v25 clamp
; GFX8-NEXT:    v_add_u32_e64 v10, s[4:5], v10, v26 clamp
; GFX8-NEXT:    v_add_u32_e64 v11, s[4:5], v11, v27 clamp
; GFX8-NEXT:    v_add_u32_e64 v12, s[4:5], v12, v28 clamp
; GFX8-NEXT:    v_add_u32_e64 v13, s[4:5], v13, v29 clamp
; GFX8-NEXT:    v_add_u32_e64 v14, s[4:5], v14, v30 clamp
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_u32_e64 v15, s[4:5], v15, v16 clamp
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uaddsat_v16i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_u32_e64 v0, v0, v16 clamp
; GFX9-NEXT:    buffer_load_dword v16, off, s[0:3], s32
; GFX9-NEXT:    v_add_u32_e64 v1, v1, v17 clamp
; GFX9-NEXT:    v_add_u32_e64 v2, v2, v18 clamp
; GFX9-NEXT:    v_add_u32_e64 v3, v3, v19 clamp
; GFX9-NEXT:    v_add_u32_e64 v4, v4, v20 clamp
; GFX9-NEXT:    v_add_u32_e64 v5, v5, v21 clamp
; GFX9-NEXT:    v_add_u32_e64 v6, v6, v22 clamp
; GFX9-NEXT:    v_add_u32_e64 v7, v7, v23 clamp
; GFX9-NEXT:    v_add_u32_e64 v8, v8, v24 clamp
; GFX9-NEXT:    v_add_u32_e64 v9, v9, v25 clamp
; GFX9-NEXT:    v_add_u32_e64 v10, v10, v26 clamp
; GFX9-NEXT:    v_add_u32_e64 v11, v11, v27 clamp
; GFX9-NEXT:    v_add_u32_e64 v12, v12, v28 clamp
; GFX9-NEXT:    v_add_u32_e64 v13, v13, v29 clamp
; GFX9-NEXT:    v_add_u32_e64 v14, v14, v30 clamp
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u32_e64 v15, v15, v16 clamp
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uaddsat_v16i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; GFX10-NEXT:    v_add_nc_u32_e64 v0, v0, v16 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v1, v1, v17 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v2, v2, v18 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v3, v3, v19 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v4, v4, v20 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v5, v5, v21 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v6, v6, v22 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v7, v7, v23 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v8, v8, v24 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v9, v9, v25 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v10, v10, v26 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v11, v11, v27 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v12, v12, v28 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v13, v13, v29 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v14, v14, v30 clamp
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_add_nc_u32_e64 v15, v15, v31 clamp
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call <16 x i32> @llvm.uadd.sat.v16i32(<16 x i32> %lhs, <16 x i32> %rhs)
  ret <16 x i32> %result
}

define amdgpu_ps <16 x i32> @s_uaddsat_v16i32(<16 x i32> inreg %lhs, <16 x i32> inreg %rhs) {
; GFX6-LABEL: s_uaddsat_v16i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_not_b32 s32, s0
; GFX6-NEXT:    s_min_u32 s16, s32, s16
; GFX6-NEXT:    s_add_i32 s0, s0, s16
; GFX6-NEXT:    s_not_b32 s16, s1
; GFX6-NEXT:    s_min_u32 s16, s16, s17
; GFX6-NEXT:    s_add_i32 s1, s1, s16
; GFX6-NEXT:    s_not_b32 s16, s2
; GFX6-NEXT:    s_min_u32 s16, s16, s18
; GFX6-NEXT:    s_add_i32 s2, s2, s16
; GFX6-NEXT:    s_not_b32 s16, s3
; GFX6-NEXT:    s_min_u32 s16, s16, s19
; GFX6-NEXT:    s_add_i32 s3, s3, s16
; GFX6-NEXT:    s_not_b32 s16, s4
; GFX6-NEXT:    s_min_u32 s16, s16, s20
; GFX6-NEXT:    s_add_i32 s4, s4, s16
; GFX6-NEXT:    s_not_b32 s16, s5
; GFX6-NEXT:    s_min_u32 s16, s16, s21
; GFX6-NEXT:    s_add_i32 s5, s5, s16
; GFX6-NEXT:    s_not_b32 s16, s6
; GFX6-NEXT:    s_min_u32 s16, s16, s22
; GFX6-NEXT:    s_add_i32 s6, s6, s16
; GFX6-NEXT:    s_not_b32 s16, s7
; GFX6-NEXT:    s_min_u32 s16, s16, s23
; GFX6-NEXT:    s_add_i32 s7, s7, s16
; GFX6-NEXT:    s_not_b32 s16, s8
; GFX6-NEXT:    s_min_u32 s16, s16, s24
; GFX6-NEXT:    s_add_i32 s8, s8, s16
; GFX6-NEXT:    s_not_b32 s16, s9
; GFX6-NEXT:    s_min_u32 s16, s16, s25
; GFX6-NEXT:    s_add_i32 s9, s9, s16
; GFX6-NEXT:    s_not_b32 s16, s10
; GFX6-NEXT:    s_min_u32 s16, s16, s26
; GFX6-NEXT:    s_add_i32 s10, s10, s16
; GFX6-NEXT:    s_not_b32 s16, s11
; GFX6-NEXT:    s_min_u32 s16, s16, s27
; GFX6-NEXT:    s_add_i32 s11, s11, s16
; GFX6-NEXT:    s_not_b32 s16, s12
; GFX6-NEXT:    s_min_u32 s16, s16, s28
; GFX6-NEXT:    s_add_i32 s12, s12, s16
; GFX6-NEXT:    s_not_b32 s16, s13
; GFX6-NEXT:    s_min_u32 s16, s16, s29
; GFX6-NEXT:    s_add_i32 s13, s13, s16
; GFX6-NEXT:    s_not_b32 s16, s14
; GFX6-NEXT:    s_min_u32 s16, s16, s30
; GFX6-NEXT:    s_add_i32 s14, s14, s16
; GFX6-NEXT:    s_not_b32 s16, s15
; GFX6-NEXT:    s_min_u32 s16, s16, s31
; GFX6-NEXT:    s_add_i32 s15, s15, s16
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_uaddsat_v16i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v0, s16
; GFX8-NEXT:    v_mov_b32_e32 v1, s17
; GFX8-NEXT:    v_mov_b32_e32 v2, s18
; GFX8-NEXT:    v_mov_b32_e32 v3, s19
; GFX8-NEXT:    v_mov_b32_e32 v4, s20
; GFX8-NEXT:    v_mov_b32_e32 v5, s21
; GFX8-NEXT:    v_mov_b32_e32 v6, s22
; GFX8-NEXT:    v_mov_b32_e32 v7, s23
; GFX8-NEXT:    v_mov_b32_e32 v8, s24
; GFX8-NEXT:    v_mov_b32_e32 v9, s25
; GFX8-NEXT:    v_mov_b32_e32 v10, s26
; GFX8-NEXT:    v_mov_b32_e32 v11, s27
; GFX8-NEXT:    v_mov_b32_e32 v12, s28
; GFX8-NEXT:    v_mov_b32_e32 v13, s29
; GFX8-NEXT:    v_mov_b32_e32 v14, s30
; GFX8-NEXT:    v_mov_b32_e32 v15, s31
; GFX8-NEXT:    v_add_u32_e64 v0, s[32:33], s0, v0 clamp
; GFX8-NEXT:    v_add_u32_e64 v1, s[16:17], s1, v1 clamp
; GFX8-NEXT:    v_add_u32_e64 v2, s[16:17], s2, v2 clamp
; GFX8-NEXT:    v_add_u32_e64 v3, s[2:3], s3, v3 clamp
; GFX8-NEXT:    v_add_u32_e64 v4, s[2:3], s4, v4 clamp
; GFX8-NEXT:    v_add_u32_e64 v5, s[2:3], s5, v5 clamp
; GFX8-NEXT:    v_add_u32_e64 v6, s[2:3], s6, v6 clamp
; GFX8-NEXT:    v_add_u32_e64 v7, s[2:3], s7, v7 clamp
; GFX8-NEXT:    v_add_u32_e64 v8, s[2:3], s8, v8 clamp
; GFX8-NEXT:    v_add_u32_e64 v9, s[2:3], s9, v9 clamp
; GFX8-NEXT:    v_add_u32_e64 v10, s[2:3], s10, v10 clamp
; GFX8-NEXT:    v_add_u32_e64 v11, s[2:3], s11, v11 clamp
; GFX8-NEXT:    v_add_u32_e64 v12, s[2:3], s12, v12 clamp
; GFX8-NEXT:    v_add_u32_e64 v13, s[2:3], s13, v13 clamp
; GFX8-NEXT:    v_add_u32_e64 v14, s[2:3], s14, v14 clamp
; GFX8-NEXT:    v_add_u32_e64 v15, s[2:3], s15, v15 clamp
; GFX8-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-NEXT:    v_readfirstlane_b32 s1, v1
; GFX8-NEXT:    v_readfirstlane_b32 s2, v2
; GFX8-NEXT:    v_readfirstlane_b32 s3, v3
; GFX8-NEXT:    v_readfirstlane_b32 s4, v4
; GFX8-NEXT:    v_readfirstlane_b32 s5, v5
; GFX8-NEXT:    v_readfirstlane_b32 s6, v6
; GFX8-NEXT:    v_readfirstlane_b32 s7, v7
; GFX8-NEXT:    v_readfirstlane_b32 s8, v8
; GFX8-NEXT:    v_readfirstlane_b32 s9, v9
; GFX8-NEXT:    v_readfirstlane_b32 s10, v10
; GFX8-NEXT:    v_readfirstlane_b32 s11, v11
; GFX8-NEXT:    v_readfirstlane_b32 s12, v12
; GFX8-NEXT:    v_readfirstlane_b32 s13, v13
; GFX8-NEXT:    v_readfirstlane_b32 s14, v14
; GFX8-NEXT:    v_readfirstlane_b32 s15, v15
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_uaddsat_v16i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    v_mov_b32_e32 v14, s30
; GFX9-NEXT:    v_mov_b32_e32 v15, s31
; GFX9-NEXT:    v_add_u32_e64 v0, s0, v0 clamp
; GFX9-NEXT:    v_add_u32_e64 v1, s1, v1 clamp
; GFX9-NEXT:    v_add_u32_e64 v2, s2, v2 clamp
; GFX9-NEXT:    v_add_u32_e64 v3, s3, v3 clamp
; GFX9-NEXT:    v_add_u32_e64 v4, s4, v4 clamp
; GFX9-NEXT:    v_add_u32_e64 v5, s5, v5 clamp
; GFX9-NEXT:    v_add_u32_e64 v6, s6, v6 clamp
; GFX9-NEXT:    v_add_u32_e64 v7, s7, v7 clamp
; GFX9-NEXT:    v_add_u32_e64 v8, s8, v8 clamp
; GFX9-NEXT:    v_add_u32_e64 v9, s9, v9 clamp
; GFX9-NEXT:    v_add_u32_e64 v10, s10, v10 clamp
; GFX9-NEXT:    v_add_u32_e64 v11, s11, v11 clamp
; GFX9-NEXT:    v_add_u32_e64 v12, s12, v12 clamp
; GFX9-NEXT:    v_add_u32_e64 v13, s13, v13 clamp
; GFX9-NEXT:    v_add_u32_e64 v14, s14, v14 clamp
; GFX9-NEXT:    v_add_u32_e64 v15, s15, v15 clamp
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    v_readfirstlane_b32 s1, v1
; GFX9-NEXT:    v_readfirstlane_b32 s2, v2
; GFX9-NEXT:    v_readfirstlane_b32 s3, v3
; GFX9-NEXT:    v_readfirstlane_b32 s4, v4
; GFX9-NEXT:    v_readfirstlane_b32 s5, v5
; GFX9-NEXT:    v_readfirstlane_b32 s6, v6
; GFX9-NEXT:    v_readfirstlane_b32 s7, v7
; GFX9-NEXT:    v_readfirstlane_b32 s8, v8
; GFX9-NEXT:    v_readfirstlane_b32 s9, v9
; GFX9-NEXT:    v_readfirstlane_b32 s10, v10
; GFX9-NEXT:    v_readfirstlane_b32 s11, v11
; GFX9-NEXT:    v_readfirstlane_b32 s12, v12
; GFX9-NEXT:    v_readfirstlane_b32 s13, v13
; GFX9-NEXT:    v_readfirstlane_b32 s14, v14
; GFX9-NEXT:    v_readfirstlane_b32 s15, v15
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_uaddsat_v16i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_add_nc_u32_e64 v0, s0, s16 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v1, s1, s17 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v2, s2, s18 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v3, s3, s19 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v4, s4, s20 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v5, s5, s21 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v6, s6, s22 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v7, s7, s23 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v8, s8, s24 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v9, s9, s25 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v10, s10, s26 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v11, s11, s27 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v12, s12, s28 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v13, s13, s29 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v14, s14, s30 clamp
; GFX10-NEXT:    v_add_nc_u32_e64 v15, s15, s31 clamp
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    v_readfirstlane_b32 s1, v1
; GFX10-NEXT:    v_readfirstlane_b32 s2, v2
; GFX10-NEXT:    v_readfirstlane_b32 s3, v3
; GFX10-NEXT:    v_readfirstlane_b32 s4, v4
; GFX10-NEXT:    v_readfirstlane_b32 s5, v5
; GFX10-NEXT:    v_readfirstlane_b32 s6, v6
; GFX10-NEXT:    v_readfirstlane_b32 s7, v7
; GFX10-NEXT:    v_readfirstlane_b32 s8, v8
; GFX10-NEXT:    v_readfirstlane_b32 s9, v9
; GFX10-NEXT:    v_readfirstlane_b32 s10, v10
; GFX10-NEXT:    v_readfirstlane_b32 s11, v11
; GFX10-NEXT:    v_readfirstlane_b32 s12, v12
; GFX10-NEXT:    v_readfirstlane_b32 s13, v13
; GFX10-NEXT:    v_readfirstlane_b32 s14, v14
; GFX10-NEXT:    v_readfirstlane_b32 s15, v15
; GFX10-NEXT:    ; return to shader part epilog
  %result = call <16 x i32> @llvm.uadd.sat.v16i32(<16 x i32> %lhs, <16 x i32> %rhs)
  ret <16 x i32> %result
}

define i16 @v_uaddsat_i16(i16 %lhs, i16 %rhs) {
; GFX6-LABEL: v_uaddsat_i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_xor_b32_e32 v2, -1, v0
; GFX6-NEXT:    v_min_u32_e32 v1, v2, v1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_uaddsat_i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u16_e64 v0, v0, v1 clamp
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uaddsat_i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_u16_e64 v0, v0, v1 clamp
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uaddsat_i16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_nc_u16 v0, v0, v1 clamp
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call i16 @llvm.uadd.sat.i16(i16 %lhs, i16 %rhs)
  ret i16 %result
}

define amdgpu_ps i16 @s_uaddsat_i16(i16 inreg %lhs, i16 inreg %rhs) {
; GFX6-LABEL: s_uaddsat_i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_lshl_b32 s0, s0, 16
; GFX6-NEXT:    s_lshl_b32 s1, s1, 16
; GFX6-NEXT:    s_not_b32 s2, s0
; GFX6-NEXT:    s_min_u32 s1, s2, s1
; GFX6-NEXT:    s_add_i32 s0, s0, s1
; GFX6-NEXT:    s_lshr_b32 s0, s0, 16
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_uaddsat_i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v0, s1
; GFX8-NEXT:    v_add_u16_e64 v0, s0, v0 clamp
; GFX8-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_uaddsat_i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v0, s1
; GFX9-NEXT:    v_add_u16_e64 v0, s0, v0 clamp
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_uaddsat_i16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_add_nc_u16 v0, s0, s1 clamp
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    ; return to shader part epilog
  %result = call i16 @llvm.uadd.sat.i16(i16 %lhs, i16 %rhs)
  ret i16 %result
}

define amdgpu_ps half @uaddsat_i16_sv(i16 inreg %lhs, i16 %rhs) {
; GFX6-LABEL: uaddsat_i16_sv:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_lshl_b32 s0, s0, 16
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    s_not_b32 s1, s0
; GFX6-NEXT:    v_min_u32_e32 v0, s1, v0
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, s0, v0
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: uaddsat_i16_sv:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_add_u16_e64 v0, s0, v0 clamp
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: uaddsat_i16_sv:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_add_u16_e64 v0, s0, v0 clamp
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: uaddsat_i16_sv:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_add_nc_u16 v0, s0, v0 clamp
; GFX10-NEXT:    ; return to shader part epilog
  %result = call i16 @llvm.uadd.sat.i16(i16 %lhs, i16 %rhs)
  %cast = bitcast i16 %result to half
  ret half %cast
}

define amdgpu_ps half @uaddsat_i16_vs(i16 %lhs, i16 inreg %rhs) {
; GFX6-LABEL: uaddsat_i16_vs:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    s_lshl_b32 s0, s0, 16
; GFX6-NEXT:    v_xor_b32_e32 v1, -1, v0
; GFX6-NEXT:    v_min_u32_e32 v1, s0, v1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: uaddsat_i16_vs:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_add_u16_e64 v0, v0, s0 clamp
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: uaddsat_i16_vs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_add_u16_e64 v0, v0, s0 clamp
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: uaddsat_i16_vs:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_add_nc_u16 v0, v0, s0 clamp
; GFX10-NEXT:    ; return to shader part epilog
  %result = call i16 @llvm.uadd.sat.i16(i16 %lhs, i16 %rhs)
  %cast = bitcast i16 %result to half
  ret half %cast
}

define <2 x i16> @v_uaddsat_v2i16(<2 x i16> %lhs, <2 x i16> %rhs) {
; GFX6-LABEL: v_uaddsat_v2i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    v_xor_b32_e32 v4, -1, v0
; GFX6-NEXT:    v_min_u32_e32 v2, v4, v2
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX6-NEXT:    v_xor_b32_e32 v3, -1, v1
; GFX6-NEXT:    v_min_u32_e32 v2, v3, v2
; GFX6-NEXT:    v_add_i32_e32 v1, vcc, v1, v2
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_uaddsat_v2i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u16_e64 v2, v0, v1 clamp
; GFX8-NEXT:    v_add_u16_sdwa v0, v0, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_mov_b32_e32 v1, 16
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uaddsat_v2i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_add_u16 v0, v0, v1 clamp
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uaddsat_v2i16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_pk_add_u16 v0, v0, v1 clamp
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call <2 x i16> @llvm.uadd.sat.v2i16(<2 x i16> %lhs, <2 x i16> %rhs)
  ret <2 x i16> %result
}

define amdgpu_ps i32 @s_uaddsat_v2i16(<2 x i16> inreg %lhs, <2 x i16> inreg %rhs) {
; GFX6-LABEL: s_uaddsat_v2i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_lshl_b32 s0, s0, 16
; GFX6-NEXT:    s_lshl_b32 s2, s2, 16
; GFX6-NEXT:    s_not_b32 s4, s0
; GFX6-NEXT:    s_min_u32 s2, s4, s2
; GFX6-NEXT:    s_lshl_b32 s1, s1, 16
; GFX6-NEXT:    s_add_i32 s0, s0, s2
; GFX6-NEXT:    s_lshl_b32 s2, s3, 16
; GFX6-NEXT:    s_not_b32 s3, s1
; GFX6-NEXT:    s_min_u32 s2, s3, s2
; GFX6-NEXT:    s_add_i32 s1, s1, s2
; GFX6-NEXT:    s_lshr_b32 s1, s1, 16
; GFX6-NEXT:    s_lshr_b32 s0, s0, 16
; GFX6-NEXT:    s_lshl_b32 s1, s1, 16
; GFX6-NEXT:    s_or_b32 s0, s0, s1
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_uaddsat_v2i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_lshr_b32 s3, s1, 16
; GFX8-NEXT:    s_lshr_b32 s2, s0, 16
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_mov_b32_e32 v0, s1
; GFX8-NEXT:    v_add_u16_e64 v1, s2, v1 clamp
; GFX8-NEXT:    v_mov_b32_e32 v2, 16
; GFX8-NEXT:    v_add_u16_e64 v0, s0, v0 clamp
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_uaddsat_v2i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v0, s1
; GFX9-NEXT:    v_pk_add_u16 v0, s0, v0 clamp
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_uaddsat_v2i16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_pk_add_u16 v0, s0, s1 clamp
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    ; return to shader part epilog
  %result = call <2 x i16> @llvm.uadd.sat.v2i16(<2 x i16> %lhs, <2 x i16> %rhs)
  %cast = bitcast <2 x i16> %result to i32
  ret i32 %cast
}

define amdgpu_ps float @uaddsat_v2i16_sv(<2 x i16> inreg %lhs, <2 x i16> %rhs) {
; GFX6-LABEL: uaddsat_v2i16_sv:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_lshl_b32 s0, s0, 16
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    s_not_b32 s2, s0
; GFX6-NEXT:    v_min_u32_e32 v0, s2, v0
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, s0, v0
; GFX6-NEXT:    s_lshl_b32 s0, s1, 16
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    s_not_b32 s1, s0
; GFX6-NEXT:    v_min_u32_e32 v1, s1, v1
; GFX6-NEXT:    v_add_i32_e32 v1, vcc, s0, v1
; GFX6-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: uaddsat_v2i16_sv:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_lshr_b32 s1, s0, 16
; GFX8-NEXT:    v_mov_b32_e32 v2, s1
; GFX8-NEXT:    v_add_u16_e64 v1, s0, v0 clamp
; GFX8-NEXT:    v_add_u16_sdwa v0, v2, v0 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_mov_b32_e32 v2, 16
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: uaddsat_v2i16_sv:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_pk_add_u16 v0, s0, v0 clamp
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: uaddsat_v2i16_sv:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_pk_add_u16 v0, s0, v0 clamp
; GFX10-NEXT:    ; return to shader part epilog
  %result = call <2 x i16> @llvm.uadd.sat.v2i16(<2 x i16> %lhs, <2 x i16> %rhs)
  %cast = bitcast <2 x i16> %result to float
  ret float %cast
}

define amdgpu_ps float @uaddsat_v2i16_vs(<2 x i16> %lhs, <2 x i16> inreg %rhs) {
; GFX6-LABEL: uaddsat_v2i16_vs:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    s_lshl_b32 s0, s0, 16
; GFX6-NEXT:    v_xor_b32_e32 v2, -1, v0
; GFX6-NEXT:    v_min_u32_e32 v2, s0, v2
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX6-NEXT:    s_lshl_b32 s0, s1, 16
; GFX6-NEXT:    v_xor_b32_e32 v2, -1, v1
; GFX6-NEXT:    v_min_u32_e32 v2, s0, v2
; GFX6-NEXT:    v_add_i32_e32 v1, vcc, v1, v2
; GFX6-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: uaddsat_v2i16_vs:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_lshr_b32 s1, s0, 16
; GFX8-NEXT:    v_mov_b32_e32 v2, s1
; GFX8-NEXT:    v_add_u16_e64 v1, v0, s0 clamp
; GFX8-NEXT:    v_add_u16_sdwa v0, v0, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_mov_b32_e32 v2, 16
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: uaddsat_v2i16_vs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_pk_add_u16 v0, v0, s0 clamp
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: uaddsat_v2i16_vs:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_pk_add_u16 v0, v0, s0 clamp
; GFX10-NEXT:    ; return to shader part epilog
  %result = call <2 x i16> @llvm.uadd.sat.v2i16(<2 x i16> %lhs, <2 x i16> %rhs)
  %cast = bitcast <2 x i16> %result to float
  ret float %cast
}

; FIXME: v3i16 insert/extract
; define <3 x i16> @v_uaddsat_v3i16(<3 x i16> %lhs, <3 x i16> %rhs) {
;   %result = call <3 x i16> @llvm.uadd.sat.v3i16(<3 x i16> %lhs, <3 x i16> %rhs)
;   ret <3 x i16> %result
; }

; define amdgpu_ps <3 x i16> @s_uaddsat_v3i16(<3 x i16> inreg %lhs, <3 x i16> inreg %rhs) {
;   %result = call <3 x i16> @llvm.uadd.sat.v3i16(<3 x i16> %lhs, <3 x i16> %rhs)
;   ret <3 x i16> %result
; }

define <2 x float> @v_uaddsat_v4i16(<4 x i16> %lhs, <4 x i16> %rhs) {
; GFX6-LABEL: v_uaddsat_v4i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX6-NEXT:    v_xor_b32_e32 v8, -1, v0
; GFX6-NEXT:    v_min_u32_e32 v4, v8, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 16, v5
; GFX6-NEXT:    v_xor_b32_e32 v5, -1, v1
; GFX6-NEXT:    v_min_u32_e32 v4, v5, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    v_add_i32_e32 v1, vcc, v1, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 16, v6
; GFX6-NEXT:    v_xor_b32_e32 v5, -1, v2
; GFX6-NEXT:    v_min_u32_e32 v4, v5, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX6-NEXT:    v_add_i32_e32 v2, vcc, v2, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 16, v7
; GFX6-NEXT:    v_xor_b32_e32 v5, -1, v3
; GFX6-NEXT:    v_min_u32_e32 v4, v5, v4
; GFX6-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_add_i32_e32 v3, vcc, v3, v4
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; GFX6-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_uaddsat_v4i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u16_e64 v4, v0, v2 clamp
; GFX8-NEXT:    v_add_u16_sdwa v0, v0, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_add_u16_e64 v2, v1, v3 clamp
; GFX8-NEXT:    v_add_u16_sdwa v1, v1, v3 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_mov_b32_e32 v3, 16
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    v_or_b32_sdwa v0, v4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uaddsat_v4i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_add_u16 v0, v0, v2 clamp
; GFX9-NEXT:    v_pk_add_u16 v1, v1, v3 clamp
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uaddsat_v4i16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_pk_add_u16 v0, v0, v2 clamp
; GFX10-NEXT:    v_pk_add_u16 v1, v1, v3 clamp
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call <4 x i16> @llvm.uadd.sat.v4i16(<4 x i16> %lhs, <4 x i16> %rhs)
  %cast = bitcast <4 x i16> %result to <2 x float>
  ret <2 x float> %cast
}

define amdgpu_ps <2 x i32> @s_uaddsat_v4i16(<4 x i16> inreg %lhs, <4 x i16> inreg %rhs) {
; GFX6-LABEL: s_uaddsat_v4i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_lshl_b32 s0, s0, 16
; GFX6-NEXT:    s_lshl_b32 s4, s4, 16
; GFX6-NEXT:    s_not_b32 s8, s0
; GFX6-NEXT:    s_min_u32 s4, s8, s4
; GFX6-NEXT:    s_lshl_b32 s1, s1, 16
; GFX6-NEXT:    s_add_i32 s0, s0, s4
; GFX6-NEXT:    s_lshl_b32 s4, s5, 16
; GFX6-NEXT:    s_not_b32 s5, s1
; GFX6-NEXT:    s_min_u32 s4, s5, s4
; GFX6-NEXT:    s_lshl_b32 s2, s2, 16
; GFX6-NEXT:    s_add_i32 s1, s1, s4
; GFX6-NEXT:    s_lshl_b32 s4, s6, 16
; GFX6-NEXT:    s_not_b32 s5, s2
; GFX6-NEXT:    s_min_u32 s4, s5, s4
; GFX6-NEXT:    s_lshl_b32 s3, s3, 16
; GFX6-NEXT:    s_add_i32 s2, s2, s4
; GFX6-NEXT:    s_lshl_b32 s4, s7, 16
; GFX6-NEXT:    s_not_b32 s5, s3
; GFX6-NEXT:    s_min_u32 s4, s5, s4
; GFX6-NEXT:    s_lshr_b32 s1, s1, 16
; GFX6-NEXT:    s_add_i32 s3, s3, s4
; GFX6-NEXT:    s_lshr_b32 s0, s0, 16
; GFX6-NEXT:    s_lshr_b32 s3, s3, 16
; GFX6-NEXT:    s_lshl_b32 s1, s1, 16
; GFX6-NEXT:    s_lshr_b32 s2, s2, 16
; GFX6-NEXT:    s_or_b32 s0, s0, s1
; GFX6-NEXT:    s_lshl_b32 s1, s3, 16
; GFX6-NEXT:    s_or_b32 s1, s2, s1
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_uaddsat_v4i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_lshr_b32 s6, s2, 16
; GFX8-NEXT:    s_lshr_b32 s4, s0, 16
; GFX8-NEXT:    s_lshr_b32 s7, s3, 16
; GFX8-NEXT:    v_mov_b32_e32 v1, s6
; GFX8-NEXT:    s_lshr_b32 s5, s1, 16
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_add_u16_e64 v1, s4, v1 clamp
; GFX8-NEXT:    v_mov_b32_e32 v3, s7
; GFX8-NEXT:    v_mov_b32_e32 v4, 16
; GFX8-NEXT:    v_add_u16_e64 v0, s0, v0 clamp
; GFX8-NEXT:    v_mov_b32_e32 v2, s3
; GFX8-NEXT:    v_add_u16_e64 v3, s5, v3 clamp
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    v_add_u16_e64 v2, s1, v2 clamp
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v4, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-NEXT:    v_readfirstlane_b32 s1, v1
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_uaddsat_v4i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    v_pk_add_u16 v0, s0, v0 clamp
; GFX9-NEXT:    v_pk_add_u16 v1, s1, v1 clamp
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    v_readfirstlane_b32 s1, v1
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_uaddsat_v4i16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_pk_add_u16 v0, s0, s2 clamp
; GFX10-NEXT:    v_pk_add_u16 v1, s1, s3 clamp
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    v_readfirstlane_b32 s1, v1
; GFX10-NEXT:    ; return to shader part epilog
  %result = call <4 x i16> @llvm.uadd.sat.v4i16(<4 x i16> %lhs, <4 x i16> %rhs)
  %cast = bitcast <4 x i16> %result to <2 x i32>
  ret <2 x i32> %cast
}

; FIXME
; define <5 x i16> @v_uaddsat_v5i16(<5 x i16> %lhs, <5 x i16> %rhs) {
;   %result = call <5 x i16> @llvm.uadd.sat.v5i16(<5 x i16> %lhs, <5 x i16> %rhs)
;   ret <5 x i16> %result
; }

; define amdgpu_ps <5 x i16> @s_uaddsat_v5i16(<5 x i16> inreg %lhs, <5 x i16> inreg %rhs) {
;   %result = call <5 x i16> @llvm.uadd.sat.v5i16(<5 x i16> %lhs, <5 x i16> %rhs)
;   ret <5 x i16> %result
; }

define <3 x float> @v_uaddsat_v6i16(<6 x i16> %lhs, <6 x i16> %rhs) {
; GFX6-LABEL: v_uaddsat_v6i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX6-NEXT:    v_xor_b32_e32 v12, -1, v0
; GFX6-NEXT:    v_min_u32_e32 v6, v12, v6
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v6
; GFX6-NEXT:    v_lshlrev_b32_e32 v6, 16, v7
; GFX6-NEXT:    v_xor_b32_e32 v7, -1, v1
; GFX6-NEXT:    v_min_u32_e32 v6, v7, v6
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    v_add_i32_e32 v1, vcc, v1, v6
; GFX6-NEXT:    v_lshlrev_b32_e32 v6, 16, v8
; GFX6-NEXT:    v_xor_b32_e32 v7, -1, v2
; GFX6-NEXT:    v_min_u32_e32 v6, v7, v6
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX6-NEXT:    v_add_i32_e32 v2, vcc, v2, v6
; GFX6-NEXT:    v_lshlrev_b32_e32 v6, 16, v9
; GFX6-NEXT:    v_xor_b32_e32 v7, -1, v3
; GFX6-NEXT:    v_min_u32_e32 v6, v7, v6
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX6-NEXT:    v_add_i32_e32 v3, vcc, v3, v6
; GFX6-NEXT:    v_lshlrev_b32_e32 v6, 16, v10
; GFX6-NEXT:    v_xor_b32_e32 v7, -1, v4
; GFX6-NEXT:    v_min_u32_e32 v6, v7, v6
; GFX6-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX6-NEXT:    v_add_i32_e32 v4, vcc, v4, v6
; GFX6-NEXT:    v_lshlrev_b32_e32 v6, 16, v11
; GFX6-NEXT:    v_xor_b32_e32 v7, -1, v5
; GFX6-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_min_u32_e32 v6, v7, v6
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX6-NEXT:    v_add_i32_e32 v5, vcc, v5, v6
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX6-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; GFX6-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX6-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 16, v5
; GFX6-NEXT:    v_or_b32_e32 v2, v4, v2
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_uaddsat_v6i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u16_e64 v6, v0, v3 clamp
; GFX8-NEXT:    v_add_u16_sdwa v0, v0, v3 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_add_u16_e64 v3, v1, v4 clamp
; GFX8-NEXT:    v_add_u16_sdwa v1, v1, v4 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_add_u16_e64 v4, v2, v5 clamp
; GFX8-NEXT:    v_add_u16_sdwa v2, v2, v5 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_mov_b32_e32 v5, 16
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    v_or_b32_sdwa v1, v3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_mov_b32_e32 v3, 16
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v5, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    v_or_b32_sdwa v0, v6, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uaddsat_v6i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_add_u16 v0, v0, v3 clamp
; GFX9-NEXT:    v_pk_add_u16 v1, v1, v4 clamp
; GFX9-NEXT:    v_pk_add_u16 v2, v2, v5 clamp
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uaddsat_v6i16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_pk_add_u16 v0, v0, v3 clamp
; GFX10-NEXT:    v_pk_add_u16 v1, v1, v4 clamp
; GFX10-NEXT:    v_pk_add_u16 v2, v2, v5 clamp
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call <6 x i16> @llvm.uadd.sat.v6i16(<6 x i16> %lhs, <6 x i16> %rhs)
  %cast = bitcast <6 x i16> %result to <3 x float>
  ret <3 x float> %cast
}

define amdgpu_ps <3 x i32> @s_uaddsat_v6i16(<6 x i16> inreg %lhs, <6 x i16> inreg %rhs) {
; GFX6-LABEL: s_uaddsat_v6i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_lshl_b32 s0, s0, 16
; GFX6-NEXT:    s_lshl_b32 s6, s6, 16
; GFX6-NEXT:    s_not_b32 s12, s0
; GFX6-NEXT:    s_min_u32 s6, s12, s6
; GFX6-NEXT:    s_lshl_b32 s1, s1, 16
; GFX6-NEXT:    s_add_i32 s0, s0, s6
; GFX6-NEXT:    s_lshl_b32 s6, s7, 16
; GFX6-NEXT:    s_not_b32 s7, s1
; GFX6-NEXT:    s_min_u32 s6, s7, s6
; GFX6-NEXT:    s_lshl_b32 s2, s2, 16
; GFX6-NEXT:    s_add_i32 s1, s1, s6
; GFX6-NEXT:    s_lshl_b32 s6, s8, 16
; GFX6-NEXT:    s_not_b32 s7, s2
; GFX6-NEXT:    s_min_u32 s6, s7, s6
; GFX6-NEXT:    s_lshl_b32 s3, s3, 16
; GFX6-NEXT:    s_add_i32 s2, s2, s6
; GFX6-NEXT:    s_lshl_b32 s6, s9, 16
; GFX6-NEXT:    s_not_b32 s7, s3
; GFX6-NEXT:    s_min_u32 s6, s7, s6
; GFX6-NEXT:    s_lshl_b32 s4, s4, 16
; GFX6-NEXT:    s_add_i32 s3, s3, s6
; GFX6-NEXT:    s_lshl_b32 s6, s10, 16
; GFX6-NEXT:    s_not_b32 s7, s4
; GFX6-NEXT:    s_min_u32 s6, s7, s6
; GFX6-NEXT:    s_lshl_b32 s5, s5, 16
; GFX6-NEXT:    s_add_i32 s4, s4, s6
; GFX6-NEXT:    s_lshl_b32 s6, s11, 16
; GFX6-NEXT:    s_not_b32 s7, s5
; GFX6-NEXT:    s_lshr_b32 s1, s1, 16
; GFX6-NEXT:    s_min_u32 s6, s7, s6
; GFX6-NEXT:    s_lshr_b32 s0, s0, 16
; GFX6-NEXT:    s_lshr_b32 s3, s3, 16
; GFX6-NEXT:    s_add_i32 s5, s5, s6
; GFX6-NEXT:    s_lshl_b32 s1, s1, 16
; GFX6-NEXT:    s_lshr_b32 s2, s2, 16
; GFX6-NEXT:    s_lshr_b32 s5, s5, 16
; GFX6-NEXT:    s_or_b32 s0, s0, s1
; GFX6-NEXT:    s_lshl_b32 s1, s3, 16
; GFX6-NEXT:    s_lshr_b32 s4, s4, 16
; GFX6-NEXT:    s_or_b32 s1, s2, s1
; GFX6-NEXT:    s_lshl_b32 s2, s5, 16
; GFX6-NEXT:    s_or_b32 s2, s4, s2
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_uaddsat_v6i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_lshr_b32 s9, s3, 16
; GFX8-NEXT:    s_lshr_b32 s6, s0, 16
; GFX8-NEXT:    s_lshr_b32 s10, s4, 16
; GFX8-NEXT:    v_mov_b32_e32 v1, s9
; GFX8-NEXT:    s_lshr_b32 s7, s1, 16
; GFX8-NEXT:    s_lshr_b32 s11, s5, 16
; GFX8-NEXT:    v_mov_b32_e32 v0, s3
; GFX8-NEXT:    v_add_u16_e64 v1, s6, v1 clamp
; GFX8-NEXT:    v_mov_b32_e32 v3, s10
; GFX8-NEXT:    v_mov_b32_e32 v6, 16
; GFX8-NEXT:    s_lshr_b32 s8, s2, 16
; GFX8-NEXT:    v_add_u16_e64 v0, s0, v0 clamp
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    v_add_u16_e64 v3, s7, v3 clamp
; GFX8-NEXT:    v_mov_b32_e32 v5, s11
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v6, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    v_add_u16_e64 v2, s1, v2 clamp
; GFX8-NEXT:    v_mov_b32_e32 v4, s5
; GFX8-NEXT:    v_add_u16_e64 v5, s8, v5 clamp
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v6, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    v_add_u16_e64 v4, s2, v4 clamp
; GFX8-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v6, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    v_or_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-NEXT:    v_readfirstlane_b32 s1, v1
; GFX8-NEXT:    v_readfirstlane_b32 s2, v2
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_uaddsat_v6i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:    v_mov_b32_e32 v2, s5
; GFX9-NEXT:    v_pk_add_u16 v0, s0, v0 clamp
; GFX9-NEXT:    v_pk_add_u16 v1, s1, v1 clamp
; GFX9-NEXT:    v_pk_add_u16 v2, s2, v2 clamp
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    v_readfirstlane_b32 s1, v1
; GFX9-NEXT:    v_readfirstlane_b32 s2, v2
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_uaddsat_v6i16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_pk_add_u16 v0, s0, s3 clamp
; GFX10-NEXT:    v_pk_add_u16 v1, s1, s4 clamp
; GFX10-NEXT:    v_pk_add_u16 v2, s2, s5 clamp
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    v_readfirstlane_b32 s1, v1
; GFX10-NEXT:    v_readfirstlane_b32 s2, v2
; GFX10-NEXT:    ; return to shader part epilog
  %result = call <6 x i16> @llvm.uadd.sat.v6i16(<6 x i16> %lhs, <6 x i16> %rhs)
  %cast = bitcast <6 x i16> %result to <3 x i32>
  ret <3 x i32> %cast
}

define <4 x float> @v_uaddsat_v8i16(<8 x i16> %lhs, <8 x i16> %rhs) {
; GFX6-LABEL: v_uaddsat_v8i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX6-NEXT:    v_xor_b32_e32 v16, -1, v0
; GFX6-NEXT:    v_min_u32_e32 v8, v16, v8
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v8
; GFX6-NEXT:    v_lshlrev_b32_e32 v8, 16, v9
; GFX6-NEXT:    v_xor_b32_e32 v9, -1, v1
; GFX6-NEXT:    v_min_u32_e32 v8, v9, v8
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    v_add_i32_e32 v1, vcc, v1, v8
; GFX6-NEXT:    v_lshlrev_b32_e32 v8, 16, v10
; GFX6-NEXT:    v_xor_b32_e32 v9, -1, v2
; GFX6-NEXT:    v_min_u32_e32 v8, v9, v8
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX6-NEXT:    v_add_i32_e32 v2, vcc, v2, v8
; GFX6-NEXT:    v_lshlrev_b32_e32 v8, 16, v11
; GFX6-NEXT:    v_xor_b32_e32 v9, -1, v3
; GFX6-NEXT:    v_min_u32_e32 v8, v9, v8
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX6-NEXT:    v_add_i32_e32 v3, vcc, v3, v8
; GFX6-NEXT:    v_lshlrev_b32_e32 v8, 16, v12
; GFX6-NEXT:    v_xor_b32_e32 v9, -1, v4
; GFX6-NEXT:    v_min_u32_e32 v8, v9, v8
; GFX6-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX6-NEXT:    v_add_i32_e32 v4, vcc, v4, v8
; GFX6-NEXT:    v_lshlrev_b32_e32 v8, 16, v13
; GFX6-NEXT:    v_xor_b32_e32 v9, -1, v5
; GFX6-NEXT:    v_min_u32_e32 v8, v9, v8
; GFX6-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX6-NEXT:    v_add_i32_e32 v5, vcc, v5, v8
; GFX6-NEXT:    v_lshlrev_b32_e32 v8, 16, v14
; GFX6-NEXT:    v_xor_b32_e32 v9, -1, v6
; GFX6-NEXT:    v_min_u32_e32 v8, v9, v8
; GFX6-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; GFX6-NEXT:    v_add_i32_e32 v6, vcc, v6, v8
; GFX6-NEXT:    v_lshlrev_b32_e32 v8, 16, v15
; GFX6-NEXT:    v_xor_b32_e32 v9, -1, v7
; GFX6-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_min_u32_e32 v8, v9, v8
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX6-NEXT:    v_add_i32_e32 v7, vcc, v7, v8
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX6-NEXT:    v_lshrrev_b32_e32 v7, 16, v7
; GFX6-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; GFX6-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX6-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; GFX6-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 16, v5
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, 16, v7
; GFX6-NEXT:    v_or_b32_e32 v2, v4, v2
; GFX6-NEXT:    v_or_b32_e32 v3, v6, v3
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_uaddsat_v8i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u16_e64 v8, v0, v4 clamp
; GFX8-NEXT:    v_add_u16_sdwa v0, v0, v4 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_add_u16_e64 v4, v1, v5 clamp
; GFX8-NEXT:    v_add_u16_sdwa v1, v1, v5 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_add_u16_e64 v5, v2, v6 clamp
; GFX8-NEXT:    v_add_u16_sdwa v2, v2, v6 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_add_u16_e64 v6, v3, v7 clamp
; GFX8-NEXT:    v_add_u16_sdwa v3, v3, v7 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_mov_b32_e32 v7, 16
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v7, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    v_mov_b32_e32 v7, 16
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v7, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v7, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v3, v7, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    v_or_b32_sdwa v0, v8, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v1, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v2, v5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v3, v6, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uaddsat_v8i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_add_u16 v0, v0, v4 clamp
; GFX9-NEXT:    v_pk_add_u16 v1, v1, v5 clamp
; GFX9-NEXT:    v_pk_add_u16 v2, v2, v6 clamp
; GFX9-NEXT:    v_pk_add_u16 v3, v3, v7 clamp
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uaddsat_v8i16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_pk_add_u16 v0, v0, v4 clamp
; GFX10-NEXT:    v_pk_add_u16 v1, v1, v5 clamp
; GFX10-NEXT:    v_pk_add_u16 v2, v2, v6 clamp
; GFX10-NEXT:    v_pk_add_u16 v3, v3, v7 clamp
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call <8 x i16> @llvm.uadd.sat.v8i16(<8 x i16> %lhs, <8 x i16> %rhs)
  %cast = bitcast <8 x i16> %result to <4 x float>
  ret <4 x float> %cast
}

define amdgpu_ps <4 x i32> @s_uaddsat_v8i16(<8 x i16> inreg %lhs, <8 x i16> inreg %rhs) {
; GFX6-LABEL: s_uaddsat_v8i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_lshl_b32 s0, s0, 16
; GFX6-NEXT:    s_lshl_b32 s8, s8, 16
; GFX6-NEXT:    s_not_b32 s16, s0
; GFX6-NEXT:    s_min_u32 s8, s16, s8
; GFX6-NEXT:    s_lshl_b32 s1, s1, 16
; GFX6-NEXT:    s_add_i32 s0, s0, s8
; GFX6-NEXT:    s_lshl_b32 s8, s9, 16
; GFX6-NEXT:    s_not_b32 s9, s1
; GFX6-NEXT:    s_min_u32 s8, s9, s8
; GFX6-NEXT:    s_lshl_b32 s2, s2, 16
; GFX6-NEXT:    s_add_i32 s1, s1, s8
; GFX6-NEXT:    s_lshl_b32 s8, s10, 16
; GFX6-NEXT:    s_not_b32 s9, s2
; GFX6-NEXT:    s_min_u32 s8, s9, s8
; GFX6-NEXT:    s_lshl_b32 s3, s3, 16
; GFX6-NEXT:    s_add_i32 s2, s2, s8
; GFX6-NEXT:    s_lshl_b32 s8, s11, 16
; GFX6-NEXT:    s_not_b32 s9, s3
; GFX6-NEXT:    s_min_u32 s8, s9, s8
; GFX6-NEXT:    s_lshl_b32 s4, s4, 16
; GFX6-NEXT:    s_add_i32 s3, s3, s8
; GFX6-NEXT:    s_lshl_b32 s8, s12, 16
; GFX6-NEXT:    s_not_b32 s9, s4
; GFX6-NEXT:    s_min_u32 s8, s9, s8
; GFX6-NEXT:    s_lshl_b32 s5, s5, 16
; GFX6-NEXT:    s_add_i32 s4, s4, s8
; GFX6-NEXT:    s_lshl_b32 s8, s13, 16
; GFX6-NEXT:    s_not_b32 s9, s5
; GFX6-NEXT:    s_min_u32 s8, s9, s8
; GFX6-NEXT:    s_lshl_b32 s6, s6, 16
; GFX6-NEXT:    s_add_i32 s5, s5, s8
; GFX6-NEXT:    s_lshl_b32 s8, s14, 16
; GFX6-NEXT:    s_not_b32 s9, s6
; GFX6-NEXT:    s_min_u32 s8, s9, s8
; GFX6-NEXT:    s_lshl_b32 s7, s7, 16
; GFX6-NEXT:    s_add_i32 s6, s6, s8
; GFX6-NEXT:    s_lshl_b32 s8, s15, 16
; GFX6-NEXT:    s_not_b32 s9, s7
; GFX6-NEXT:    s_lshr_b32 s1, s1, 16
; GFX6-NEXT:    s_min_u32 s8, s9, s8
; GFX6-NEXT:    s_lshr_b32 s0, s0, 16
; GFX6-NEXT:    s_lshr_b32 s3, s3, 16
; GFX6-NEXT:    s_add_i32 s7, s7, s8
; GFX6-NEXT:    s_lshl_b32 s1, s1, 16
; GFX6-NEXT:    s_lshr_b32 s2, s2, 16
; GFX6-NEXT:    s_lshr_b32 s5, s5, 16
; GFX6-NEXT:    s_lshr_b32 s7, s7, 16
; GFX6-NEXT:    s_or_b32 s0, s0, s1
; GFX6-NEXT:    s_lshl_b32 s1, s3, 16
; GFX6-NEXT:    s_lshr_b32 s4, s4, 16
; GFX6-NEXT:    s_lshr_b32 s6, s6, 16
; GFX6-NEXT:    s_or_b32 s1, s2, s1
; GFX6-NEXT:    s_lshl_b32 s2, s5, 16
; GFX6-NEXT:    s_lshl_b32 s3, s7, 16
; GFX6-NEXT:    s_or_b32 s2, s4, s2
; GFX6-NEXT:    s_or_b32 s3, s6, s3
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_uaddsat_v8i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_lshr_b32 s12, s4, 16
; GFX8-NEXT:    s_lshr_b32 s8, s0, 16
; GFX8-NEXT:    s_lshr_b32 s13, s5, 16
; GFX8-NEXT:    v_mov_b32_e32 v1, s12
; GFX8-NEXT:    s_lshr_b32 s9, s1, 16
; GFX8-NEXT:    s_lshr_b32 s14, s6, 16
; GFX8-NEXT:    s_lshr_b32 s15, s7, 16
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_add_u16_e64 v1, s8, v1 clamp
; GFX8-NEXT:    v_mov_b32_e32 v3, s13
; GFX8-NEXT:    v_mov_b32_e32 v8, 16
; GFX8-NEXT:    s_lshr_b32 s10, s2, 16
; GFX8-NEXT:    s_lshr_b32 s11, s3, 16
; GFX8-NEXT:    v_add_u16_e64 v0, s0, v0 clamp
; GFX8-NEXT:    v_mov_b32_e32 v2, s5
; GFX8-NEXT:    v_add_u16_e64 v3, s9, v3 clamp
; GFX8-NEXT:    v_mov_b32_e32 v5, s14
; GFX8-NEXT:    v_mov_b32_e32 v7, s15
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v8, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    v_add_u16_e64 v2, s1, v2 clamp
; GFX8-NEXT:    v_mov_b32_e32 v4, s6
; GFX8-NEXT:    v_add_u16_e64 v5, s10, v5 clamp
; GFX8-NEXT:    v_mov_b32_e32 v6, s7
; GFX8-NEXT:    v_add_u16_e64 v7, s11, v7 clamp
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v8, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    v_add_u16_e64 v4, s2, v4 clamp
; GFX8-NEXT:    v_add_u16_e64 v6, s3, v6 clamp
; GFX8-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v8, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v3, v8, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX8-NEXT:    v_or_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v3, v6, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-NEXT:    v_readfirstlane_b32 s1, v1
; GFX8-NEXT:    v_readfirstlane_b32 s2, v2
; GFX8-NEXT:    v_readfirstlane_b32 s3, v3
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_uaddsat_v8i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-NEXT:    v_mov_b32_e32 v3, s7
; GFX9-NEXT:    v_pk_add_u16 v0, s0, v0 clamp
; GFX9-NEXT:    v_pk_add_u16 v1, s1, v1 clamp
; GFX9-NEXT:    v_pk_add_u16 v2, s2, v2 clamp
; GFX9-NEXT:    v_pk_add_u16 v3, s3, v3 clamp
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    v_readfirstlane_b32 s1, v1
; GFX9-NEXT:    v_readfirstlane_b32 s2, v2
; GFX9-NEXT:    v_readfirstlane_b32 s3, v3
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_uaddsat_v8i16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_pk_add_u16 v0, s0, s4 clamp
; GFX10-NEXT:    v_pk_add_u16 v1, s1, s5 clamp
; GFX10-NEXT:    v_pk_add_u16 v2, s2, s6 clamp
; GFX10-NEXT:    v_pk_add_u16 v3, s3, s7 clamp
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    v_readfirstlane_b32 s1, v1
; GFX10-NEXT:    v_readfirstlane_b32 s2, v2
; GFX10-NEXT:    v_readfirstlane_b32 s3, v3
; GFX10-NEXT:    ; return to shader part epilog
  %result = call <8 x i16> @llvm.uadd.sat.v8i16(<8 x i16> %lhs, <8 x i16> %rhs)
  %cast = bitcast <8 x i16> %result to <4 x i32>
  ret <4 x i32> %cast
}

; FIXME: i48 broken because i48 add broken
; define i48 @v_uaddsat_i48(i48 %lhs, i48 %rhs) {
;   %result = call i48 @llvm.uadd.sat.i48(i48 %lhs, i48 %rhs)
;   ret i48 %result
; }

; define amdgpu_ps i48 @s_uaddsat_i48(i48 inreg %lhs, i48 inreg %rhs) {
;   %result = call i48 @llvm.uadd.sat.i48(i48 %lhs, i48 %rhs)
;   ret i48 %result
; }

; define amdgpu_ps <2 x float> @uaddsat_i48_sv(i48 inreg %lhs, i48 %rhs) {
;   %result = call i48 @llvm.uadd.sat.i48(i48 %lhs, i48 %rhs)
;   %ext.result = zext i48 %result to i64
;   %cast = bitcast i64 %ext.result to <2 x float>
;   ret <2 x float> %cast
; }

; define amdgpu_ps <2 x float> @uaddsat_i48_vs(i48 %lhs, i48 inreg %rhs) {
;   %result = call i48 @llvm.uadd.sat.i48(i48 %lhs, i48 %rhs)
;   %ext.result = zext i48 %result to i64
;   %cast = bitcast i64 %ext.result to <2 x float>
;   ret <2 x float> %cast
; }

define i64 @v_uaddsat_i64(i64 %lhs, i64 %rhs) {
; GFX6-LABEL: v_uaddsat_i64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX6-NEXT:    v_cmp_lt_u64_e32 vcc, v[0:1], v[2:3]
; GFX6-NEXT:    v_cndmask_b32_e64 v0, v0, -1, vcc
; GFX6-NEXT:    v_cndmask_b32_e64 v1, v1, -1, vcc
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_uaddsat_i64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX8-NEXT:    v_cmp_lt_u64_e32 vcc, v[0:1], v[2:3]
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, -1, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v1, -1, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uaddsat_i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, v0, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, -1, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, -1, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uaddsat_i64:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX10-NEXT:    v_cmp_lt_u64_e32 vcc_lo, v[0:1], v[2:3]
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, -1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, -1, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call i64 @llvm.uadd.sat.i64(i64 %lhs, i64 %rhs)
  ret i64 %result
}

define amdgpu_ps i64 @s_uaddsat_i64(i64 inreg %lhs, i64 inreg %rhs) {
; GFX6-LABEL: s_uaddsat_i64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_add_u32 s0, s0, s2
; GFX6-NEXT:    s_cselect_b32 s4, 1, 0
; GFX6-NEXT:    s_and_b32 s4, s4, 1
; GFX6-NEXT:    s_cmp_lg_u32 s4, 0
; GFX6-NEXT:    v_mov_b32_e32 v0, s2
; GFX6-NEXT:    s_addc_u32 s1, s1, s3
; GFX6-NEXT:    v_mov_b32_e32 v1, s3
; GFX6-NEXT:    v_cmp_lt_u64_e32 vcc, s[0:1], v[0:1]
; GFX6-NEXT:    v_mov_b32_e32 v2, s0
; GFX6-NEXT:    v_mov_b32_e32 v3, s1
; GFX6-NEXT:    v_cndmask_b32_e64 v0, v2, -1, vcc
; GFX6-NEXT:    v_cndmask_b32_e64 v1, v3, -1, vcc
; GFX6-NEXT:    v_readfirstlane_b32 s0, v0
; GFX6-NEXT:    v_readfirstlane_b32 s1, v1
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_uaddsat_i64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_add_u32 s0, s0, s2
; GFX8-NEXT:    s_cselect_b32 s4, 1, 0
; GFX8-NEXT:    s_and_b32 s4, s4, 1
; GFX8-NEXT:    s_cmp_lg_u32 s4, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    s_addc_u32 s1, s1, s3
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_cmp_lt_u64_e32 vcc, s[0:1], v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v2, -1, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v3, -1, vcc
; GFX8-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-NEXT:    v_readfirstlane_b32 s1, v1
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_uaddsat_i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_add_u32 s0, s0, s2
; GFX9-NEXT:    s_cselect_b32 s4, 1, 0
; GFX9-NEXT:    s_and_b32 s4, s4, 1
; GFX9-NEXT:    s_cmp_lg_u32 s4, 0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    s_addc_u32 s1, s1, s3
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, s[0:1], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v2, s0
; GFX9-NEXT:    v_mov_b32_e32 v3, s1
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v2, -1, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v3, -1, vcc
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    v_readfirstlane_b32 s1, v1
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_uaddsat_i64:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_add_u32 s0, s0, s2
; GFX10-NEXT:    s_cselect_b32 s4, 1, 0
; GFX10-NEXT:    s_and_b32 s4, s4, 1
; GFX10-NEXT:    s_cmp_lg_u32 s4, 0
; GFX10-NEXT:    s_addc_u32 s1, s1, s3
; GFX10-NEXT:    v_cmp_lt_u64_e64 s2, s[0:1], s[2:3]
; GFX10-NEXT:    v_cndmask_b32_e64 v0, s0, -1, s2
; GFX10-NEXT:    v_cndmask_b32_e64 v1, s1, -1, s2
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    v_readfirstlane_b32 s1, v1
; GFX10-NEXT:    ; return to shader part epilog
  %result = call i64 @llvm.uadd.sat.i64(i64 %lhs, i64 %rhs)
  ret i64 %result
}

define amdgpu_ps <2 x float> @uaddsat_i64_sv(i64 inreg %lhs, i64 %rhs) {
; GFX6-LABEL: uaddsat_i64_sv:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_mov_b32_e32 v3, s1
; GFX6-NEXT:    v_add_i32_e32 v2, vcc, s0, v0
; GFX6-NEXT:    v_addc_u32_e32 v3, vcc, v3, v1, vcc
; GFX6-NEXT:    v_cmp_lt_u64_e32 vcc, v[2:3], v[0:1]
; GFX6-NEXT:    v_cndmask_b32_e64 v0, v2, -1, vcc
; GFX6-NEXT:    v_cndmask_b32_e64 v1, v3, -1, vcc
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: uaddsat_i64_sv:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, s0, v0
; GFX8-NEXT:    v_addc_u32_e32 v3, vcc, v3, v1, vcc
; GFX8-NEXT:    v_cmp_lt_u64_e32 vcc, v[2:3], v[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v2, -1, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v3, -1, vcc
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: uaddsat_i64_sv:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v3, s1
; GFX9-NEXT:    v_add_co_u32_e32 v2, vcc, s0, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, v3, v1, vcc
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, v[2:3], v[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v2, -1, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v3, -1, vcc
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: uaddsat_i64_sv:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_add_co_u32 v2, vcc_lo, s0, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v3, vcc_lo, s1, v1, vcc_lo
; GFX10-NEXT:    v_cmp_lt_u64_e32 vcc_lo, v[2:3], v[0:1]
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v2, -1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v3, -1, vcc_lo
; GFX10-NEXT:    ; return to shader part epilog
  %result = call i64 @llvm.uadd.sat.i64(i64 %lhs, i64 %rhs)
  %cast = bitcast i64 %result to <2 x float>
  ret <2 x float> %cast
}

define amdgpu_ps <2 x float> @uaddsat_i64_vs(i64 %lhs, i64 inreg %rhs) {
; GFX6-LABEL: uaddsat_i64_vs:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_mov_b32_e32 v2, s1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, s0, v0
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, v1, v2, vcc
; GFX6-NEXT:    v_cmp_gt_u64_e32 vcc, s[0:1], v[0:1]
; GFX6-NEXT:    v_cndmask_b32_e64 v0, v0, -1, vcc
; GFX6-NEXT:    v_cndmask_b32_e64 v1, v1, -1, vcc
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: uaddsat_i64_vs:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v2, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, v1, v2, vcc
; GFX8-NEXT:    v_cmp_gt_u64_e32 vcc, s[0:1], v[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, -1, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v1, -1, vcc
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: uaddsat_i64_vs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, s0, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v2, vcc
; GFX9-NEXT:    v_cmp_gt_u64_e32 vcc, s[0:1], v[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, -1, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, -1, vcc
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: uaddsat_i64_vs:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, v0, s0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, s1, v1, vcc_lo
; GFX10-NEXT:    v_cmp_gt_u64_e32 vcc_lo, s[0:1], v[0:1]
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, -1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, -1, vcc_lo
; GFX10-NEXT:    ; return to shader part epilog
  %result = call i64 @llvm.uadd.sat.i64(i64 %lhs, i64 %rhs)
  %cast = bitcast i64 %result to <2 x float>
  ret <2 x float> %cast
}

define <2 x i64> @v_uaddsat_v2i64(<2 x i64> %lhs, <2 x i64> %rhs) {
; GFX6-LABEL: v_uaddsat_v2i64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v4
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, v1, v5, vcc
; GFX6-NEXT:    v_cmp_lt_u64_e32 vcc, v[0:1], v[4:5]
; GFX6-NEXT:    v_cndmask_b32_e64 v0, v0, -1, vcc
; GFX6-NEXT:    v_cndmask_b32_e64 v1, v1, -1, vcc
; GFX6-NEXT:    v_add_i32_e32 v2, vcc, v2, v6
; GFX6-NEXT:    v_addc_u32_e32 v3, vcc, v3, v7, vcc
; GFX6-NEXT:    v_cmp_lt_u64_e32 vcc, v[2:3], v[6:7]
; GFX6-NEXT:    v_cndmask_b32_e64 v2, v2, -1, vcc
; GFX6-NEXT:    v_cndmask_b32_e64 v3, v3, -1, vcc
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_uaddsat_v2i64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, v0, v4
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, v1, v5, vcc
; GFX8-NEXT:    v_cmp_lt_u64_e32 vcc, v[0:1], v[4:5]
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, -1, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v1, -1, vcc
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, v2, v6
; GFX8-NEXT:    v_addc_u32_e32 v3, vcc, v3, v7, vcc
; GFX8-NEXT:    v_cmp_lt_u64_e32 vcc, v[2:3], v[6:7]
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, -1, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v3, -1, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uaddsat_v2i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, v0, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v5, vcc
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, v[0:1], v[4:5]
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, -1, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, -1, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v2, vcc, v2, v6
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, v3, v7, vcc
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, v[2:3], v[6:7]
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, -1, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, -1, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uaddsat_v2i64:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v4
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v5, vcc_lo
; GFX10-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v6
; GFX10-NEXT:    v_add_co_ci_u32_e32 v3, vcc_lo, v3, v7, vcc_lo
; GFX10-NEXT:    v_cmp_lt_u64_e32 vcc_lo, v[0:1], v[4:5]
; GFX10-NEXT:    v_cmp_lt_u64_e64 s4, v[2:3], v[6:7]
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, -1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, -1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v2, -1, s4
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v3, -1, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call <2 x i64> @llvm.uadd.sat.v2i64(<2 x i64> %lhs, <2 x i64> %rhs)
  ret <2 x i64> %result
}

define amdgpu_ps <2 x i64> @s_uaddsat_v2i64(<2 x i64> inreg %lhs, <2 x i64> inreg %rhs) {
; GFX6-LABEL: s_uaddsat_v2i64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_add_u32 s0, s0, s4
; GFX6-NEXT:    s_cselect_b32 s8, 1, 0
; GFX6-NEXT:    s_and_b32 s8, s8, 1
; GFX6-NEXT:    s_cmp_lg_u32 s8, 0
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    s_addc_u32 s1, s1, s5
; GFX6-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-NEXT:    v_mov_b32_e32 v2, s0
; GFX6-NEXT:    v_cmp_lt_u64_e32 vcc, s[0:1], v[0:1]
; GFX6-NEXT:    s_add_u32 s0, s2, s6
; GFX6-NEXT:    v_mov_b32_e32 v3, s1
; GFX6-NEXT:    s_cselect_b32 s1, 1, 0
; GFX6-NEXT:    s_and_b32 s1, s1, 1
; GFX6-NEXT:    s_cmp_lg_u32 s1, 0
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    s_addc_u32 s1, s3, s7
; GFX6-NEXT:    v_mov_b32_e32 v1, s7
; GFX6-NEXT:    v_cndmask_b32_e64 v2, v2, -1, vcc
; GFX6-NEXT:    v_cndmask_b32_e64 v3, v3, -1, vcc
; GFX6-NEXT:    v_cmp_lt_u64_e32 vcc, s[0:1], v[0:1]
; GFX6-NEXT:    v_mov_b32_e32 v4, s0
; GFX6-NEXT:    v_mov_b32_e32 v5, s1
; GFX6-NEXT:    v_cndmask_b32_e64 v0, v4, -1, vcc
; GFX6-NEXT:    v_cndmask_b32_e64 v1, v5, -1, vcc
; GFX6-NEXT:    v_readfirstlane_b32 s0, v2
; GFX6-NEXT:    v_readfirstlane_b32 s1, v3
; GFX6-NEXT:    v_readfirstlane_b32 s2, v0
; GFX6-NEXT:    v_readfirstlane_b32 s3, v1
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_uaddsat_v2i64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_add_u32 s0, s0, s4
; GFX8-NEXT:    s_cselect_b32 s8, 1, 0
; GFX8-NEXT:    s_and_b32 s8, s8, 1
; GFX8-NEXT:    s_cmp_lg_u32 s8, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    s_addc_u32 s1, s1, s5
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    v_cmp_lt_u64_e32 vcc, s[0:1], v[0:1]
; GFX8-NEXT:    s_add_u32 s0, s2, s6
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    s_cselect_b32 s1, 1, 0
; GFX8-NEXT:    s_and_b32 s1, s1, 1
; GFX8-NEXT:    s_cmp_lg_u32 s1, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    s_addc_u32 s1, s3, s7
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, -1, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v3, -1, vcc
; GFX8-NEXT:    v_cmp_lt_u64_e32 vcc, s[0:1], v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v4, s0
; GFX8-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v4, -1, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v5, -1, vcc
; GFX8-NEXT:    v_readfirstlane_b32 s0, v2
; GFX8-NEXT:    v_readfirstlane_b32 s1, v3
; GFX8-NEXT:    v_readfirstlane_b32 s2, v0
; GFX8-NEXT:    v_readfirstlane_b32 s3, v1
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_uaddsat_v2i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_add_u32 s0, s0, s4
; GFX9-NEXT:    s_cselect_b32 s8, 1, 0
; GFX9-NEXT:    s_and_b32 s8, s8, 1
; GFX9-NEXT:    s_cmp_lg_u32 s8, 0
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    s_addc_u32 s1, s1, s5
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mov_b32_e32 v2, s0
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, s[0:1], v[0:1]
; GFX9-NEXT:    s_add_u32 s0, s2, s6
; GFX9-NEXT:    v_mov_b32_e32 v3, s1
; GFX9-NEXT:    s_cselect_b32 s1, 1, 0
; GFX9-NEXT:    s_and_b32 s1, s1, 1
; GFX9-NEXT:    s_cmp_lg_u32 s1, 0
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    s_addc_u32 s1, s3, s7
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, -1, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, -1, vcc
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, s[0:1], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v4, s0
; GFX9-NEXT:    v_mov_b32_e32 v5, s1
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v4, -1, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v5, -1, vcc
; GFX9-NEXT:    v_readfirstlane_b32 s0, v2
; GFX9-NEXT:    v_readfirstlane_b32 s1, v3
; GFX9-NEXT:    v_readfirstlane_b32 s2, v0
; GFX9-NEXT:    v_readfirstlane_b32 s3, v1
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_uaddsat_v2i64:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_add_u32 s0, s0, s4
; GFX10-NEXT:    s_cselect_b32 s8, 1, 0
; GFX10-NEXT:    s_and_b32 s8, s8, 1
; GFX10-NEXT:    s_cmp_lg_u32 s8, 0
; GFX10-NEXT:    s_addc_u32 s1, s1, s5
; GFX10-NEXT:    s_add_u32 s2, s2, s6
; GFX10-NEXT:    s_cselect_b32 s8, 1, 0
; GFX10-NEXT:    v_cmp_lt_u64_e64 s4, s[0:1], s[4:5]
; GFX10-NEXT:    s_and_b32 s8, s8, 1
; GFX10-NEXT:    s_cmp_lg_u32 s8, 0
; GFX10-NEXT:    s_addc_u32 s3, s3, s7
; GFX10-NEXT:    v_cndmask_b32_e64 v0, s0, -1, s4
; GFX10-NEXT:    v_cmp_lt_u64_e64 s5, s[2:3], s[6:7]
; GFX10-NEXT:    v_cndmask_b32_e64 v1, s1, -1, s4
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    v_readfirstlane_b32 s1, v1
; GFX10-NEXT:    v_cndmask_b32_e64 v2, s2, -1, s5
; GFX10-NEXT:    v_cndmask_b32_e64 v3, s3, -1, s5
; GFX10-NEXT:    v_readfirstlane_b32 s2, v2
; GFX10-NEXT:    v_readfirstlane_b32 s3, v3
; GFX10-NEXT:    ; return to shader part epilog
  %result = call <2 x i64> @llvm.uadd.sat.v2i64(<2 x i64> %lhs, <2 x i64> %rhs)
  ret <2 x i64> %result
}

define amdgpu_ps i128 @s_uaddsat_i128(i128 inreg %lhs, i128 inreg %rhs) {
; GFX6-LABEL: s_uaddsat_i128:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_add_u32 s0, s0, s4
; GFX6-NEXT:    s_cselect_b32 s8, 1, 0
; GFX6-NEXT:    s_and_b32 s8, s8, 1
; GFX6-NEXT:    s_cmp_lg_u32 s8, 0
; GFX6-NEXT:    s_addc_u32 s1, s1, s5
; GFX6-NEXT:    s_cselect_b32 s8, 1, 0
; GFX6-NEXT:    s_and_b32 s8, s8, 1
; GFX6-NEXT:    s_cmp_lg_u32 s8, 0
; GFX6-NEXT:    s_addc_u32 s2, s2, s6
; GFX6-NEXT:    s_cselect_b32 s8, 1, 0
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    s_and_b32 s8, s8, 1
; GFX6-NEXT:    v_mov_b32_e32 v3, s5
; GFX6-NEXT:    s_cmp_lg_u32 s8, 0
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    v_cmp_lt_u64_e32 vcc, s[0:1], v[2:3]
; GFX6-NEXT:    s_addc_u32 s3, s3, s7
; GFX6-NEXT:    v_mov_b32_e32 v1, s7
; GFX6-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX6-NEXT:    v_cmp_lt_u64_e32 vcc, s[2:3], v[0:1]
; GFX6-NEXT:    v_cndmask_b32_e64 v3, 0, 1, vcc
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, s[2:3], v[0:1]
; GFX6-NEXT:    v_mov_b32_e32 v1, s0
; GFX6-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX6-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX6-NEXT:    v_mov_b32_e32 v2, s1
; GFX6-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX6-NEXT:    v_cndmask_b32_e64 v0, v1, -1, vcc
; GFX6-NEXT:    v_cndmask_b32_e64 v1, v2, -1, vcc
; GFX6-NEXT:    v_mov_b32_e32 v2, s2
; GFX6-NEXT:    v_mov_b32_e32 v3, s3
; GFX6-NEXT:    v_cndmask_b32_e64 v2, v2, -1, vcc
; GFX6-NEXT:    v_cndmask_b32_e64 v3, v3, -1, vcc
; GFX6-NEXT:    v_readfirstlane_b32 s0, v0
; GFX6-NEXT:    v_readfirstlane_b32 s1, v1
; GFX6-NEXT:    v_readfirstlane_b32 s2, v2
; GFX6-NEXT:    v_readfirstlane_b32 s3, v3
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_uaddsat_i128:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_add_u32 s0, s0, s4
; GFX8-NEXT:    s_cselect_b32 s8, 1, 0
; GFX8-NEXT:    s_and_b32 s8, s8, 1
; GFX8-NEXT:    s_cmp_lg_u32 s8, 0
; GFX8-NEXT:    s_addc_u32 s1, s1, s5
; GFX8-NEXT:    s_cselect_b32 s8, 1, 0
; GFX8-NEXT:    s_and_b32 s8, s8, 1
; GFX8-NEXT:    s_cmp_lg_u32 s8, 0
; GFX8-NEXT:    s_addc_u32 s2, s2, s6
; GFX8-NEXT:    s_cselect_b32 s8, 1, 0
; GFX8-NEXT:    s_and_b32 s8, s8, 1
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    s_cmp_lg_u32 s8, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s5
; GFX8-NEXT:    s_addc_u32 s3, s3, s7
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    v_cmp_lt_u64_e32 vcc, s[0:1], v[2:3]
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    s_cmp_eq_u64 s[2:3], s[6:7]
; GFX8-NEXT:    s_cselect_b32 s6, 1, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX8-NEXT:    v_cmp_lt_u64_e32 vcc, s[2:3], v[0:1]
; GFX8-NEXT:    s_and_b32 s4, 1, s6
; GFX8-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s4
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX8-NEXT:    v_mov_b32_e32 v1, s0
; GFX8-NEXT:    v_mov_b32_e32 v2, s1
; GFX8-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v1, -1, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v2, -1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, -1, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v3, -1, vcc
; GFX8-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-NEXT:    v_readfirstlane_b32 s1, v1
; GFX8-NEXT:    v_readfirstlane_b32 s2, v2
; GFX8-NEXT:    v_readfirstlane_b32 s3, v3
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_uaddsat_i128:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_add_u32 s0, s0, s4
; GFX9-NEXT:    s_cselect_b32 s8, 1, 0
; GFX9-NEXT:    s_and_b32 s8, s8, 1
; GFX9-NEXT:    s_cmp_lg_u32 s8, 0
; GFX9-NEXT:    s_addc_u32 s1, s1, s5
; GFX9-NEXT:    s_cselect_b32 s8, 1, 0
; GFX9-NEXT:    s_and_b32 s8, s8, 1
; GFX9-NEXT:    s_cmp_lg_u32 s8, 0
; GFX9-NEXT:    s_addc_u32 s2, s2, s6
; GFX9-NEXT:    s_cselect_b32 s8, 1, 0
; GFX9-NEXT:    s_and_b32 s8, s8, 1
; GFX9-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-NEXT:    s_cmp_lg_u32 s8, 0
; GFX9-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-NEXT:    s_addc_u32 s3, s3, s7
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, s[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_cmp_eq_u64 s[2:3], s[6:7]
; GFX9-NEXT:    s_cselect_b32 s6, 1, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, s[2:3], v[0:1]
; GFX9-NEXT:    s_and_b32 s4, 1, s6
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s4
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX9-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v1, -1, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v2, -1, vcc
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    v_mov_b32_e32 v3, s3
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, -1, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, -1, vcc
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    v_readfirstlane_b32 s1, v1
; GFX9-NEXT:    v_readfirstlane_b32 s2, v2
; GFX9-NEXT:    v_readfirstlane_b32 s3, v3
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_uaddsat_i128:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_add_u32 s0, s0, s4
; GFX10-NEXT:    s_cselect_b32 s8, 1, 0
; GFX10-NEXT:    s_and_b32 s8, s8, 1
; GFX10-NEXT:    s_cmp_lg_u32 s8, 0
; GFX10-NEXT:    s_addc_u32 s1, s1, s5
; GFX10-NEXT:    s_cselect_b32 s8, 1, 0
; GFX10-NEXT:    v_cmp_lt_u64_e64 s4, s[0:1], s[4:5]
; GFX10-NEXT:    s_and_b32 s8, s8, 1
; GFX10-NEXT:    s_cmp_lg_u32 s8, 0
; GFX10-NEXT:    s_addc_u32 s2, s2, s6
; GFX10-NEXT:    s_cselect_b32 s8, 1, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s4
; GFX10-NEXT:    s_and_b32 s8, s8, 1
; GFX10-NEXT:    s_cmp_lg_u32 s8, 0
; GFX10-NEXT:    s_addc_u32 s3, s3, s7
; GFX10-NEXT:    s_cmp_eq_u64 s[2:3], s[6:7]
; GFX10-NEXT:    v_cmp_lt_u64_e64 s5, s[2:3], s[6:7]
; GFX10-NEXT:    s_cselect_b32 s4, 1, 0
; GFX10-NEXT:    s_and_b32 s4, 1, s4
; GFX10-NEXT:    v_cmp_ne_u32_e64 vcc_lo, 0, s4
; GFX10-NEXT:    v_cndmask_b32_e64 v1, 0, 1, s5
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc_lo
; GFX10-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX10-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, s0, -1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v1, s1, -1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, s2, -1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v3, s3, -1, vcc_lo
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    v_readfirstlane_b32 s1, v1
; GFX10-NEXT:    v_readfirstlane_b32 s2, v2
; GFX10-NEXT:    v_readfirstlane_b32 s3, v3
; GFX10-NEXT:    ; return to shader part epilog
  %result = call i128 @llvm.uadd.sat.i128(i128 %lhs, i128 %rhs)
  ret i128 %result
}

define amdgpu_ps <4 x float> @uaddsat_i128_sv(i128 inreg %lhs, i128 %rhs) {
; GFX6-LABEL: uaddsat_i128_sv:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_mov_b32_e32 v5, s1
; GFX6-NEXT:    v_add_i32_e32 v4, vcc, s0, v0
; GFX6-NEXT:    v_addc_u32_e32 v5, vcc, v5, v1, vcc
; GFX6-NEXT:    v_mov_b32_e32 v6, s2
; GFX6-NEXT:    v_mov_b32_e32 v7, s3
; GFX6-NEXT:    v_addc_u32_e32 v6, vcc, v6, v2, vcc
; GFX6-NEXT:    v_addc_u32_e32 v7, vcc, v7, v3, vcc
; GFX6-NEXT:    v_cmp_lt_u64_e32 vcc, v[4:5], v[0:1]
; GFX6-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX6-NEXT:    v_cmp_lt_u64_e32 vcc, v[6:7], v[2:3]
; GFX6-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, v[6:7], v[2:3]
; GFX6-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX6-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX6-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX6-NEXT:    v_cndmask_b32_e64 v0, v4, -1, vcc
; GFX6-NEXT:    v_cndmask_b32_e64 v1, v5, -1, vcc
; GFX6-NEXT:    v_cndmask_b32_e64 v2, v6, -1, vcc
; GFX6-NEXT:    v_cndmask_b32_e64 v3, v7, -1, vcc
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: uaddsat_i128_sv:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, s0, v0
; GFX8-NEXT:    v_addc_u32_e32 v5, vcc, v5, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v6, s2
; GFX8-NEXT:    v_mov_b32_e32 v7, s3
; GFX8-NEXT:    v_addc_u32_e32 v6, vcc, v6, v2, vcc
; GFX8-NEXT:    v_addc_u32_e32 v7, vcc, v7, v3, vcc
; GFX8-NEXT:    v_cmp_lt_u64_e32 vcc, v[4:5], v[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8-NEXT:    v_cmp_lt_u64_e32 vcc, v[6:7], v[2:3]
; GFX8-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, v[6:7], v[2:3]
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX8-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v4, -1, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v5, -1, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v6, -1, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v7, -1, vcc
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: uaddsat_i128_sv:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v5, s1
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, s0, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, v5, v1, vcc
; GFX9-NEXT:    v_mov_b32_e32 v6, s2
; GFX9-NEXT:    v_mov_b32_e32 v7, s3
; GFX9-NEXT:    v_addc_co_u32_e32 v6, vcc, v6, v2, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v7, vcc, v7, v3, vcc
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, v[4:5], v[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, v[6:7], v[2:3]
; GFX9-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[6:7], v[2:3]
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX9-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v4, -1, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v5, -1, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v6, -1, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v7, -1, vcc
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: uaddsat_i128_sv:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_add_co_u32 v4, vcc_lo, s0, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v5, vcc_lo, s1, v1, vcc_lo
; GFX10-NEXT:    v_add_co_ci_u32_e32 v6, vcc_lo, s2, v2, vcc_lo
; GFX10-NEXT:    v_add_co_ci_u32_e32 v7, vcc_lo, s3, v3, vcc_lo
; GFX10-NEXT:    v_cmp_lt_u64_e32 vcc_lo, v[4:5], v[0:1]
; GFX10-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10-NEXT:    v_cmp_lt_u64_e32 vcc_lo, v[6:7], v[2:3]
; GFX10-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[6:7], v[2:3]
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc_lo
; GFX10-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX10-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v4, -1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v5, -1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v6, -1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v7, -1, vcc_lo
; GFX10-NEXT:    ; return to shader part epilog
  %result = call i128 @llvm.uadd.sat.i128(i128 %lhs, i128 %rhs)
  %cast = bitcast i128 %result to <4 x float>
  ret <4 x float> %cast
}

define amdgpu_ps <4 x float> @uaddsat_i128_vs(i128 %lhs, i128 inreg %rhs) {
; GFX6-LABEL: uaddsat_i128_vs:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_mov_b32_e32 v4, s1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, s0, v0
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, v1, v4, vcc
; GFX6-NEXT:    v_mov_b32_e32 v4, s2
; GFX6-NEXT:    v_mov_b32_e32 v5, s3
; GFX6-NEXT:    v_addc_u32_e32 v2, vcc, v2, v4, vcc
; GFX6-NEXT:    v_addc_u32_e32 v3, vcc, v3, v5, vcc
; GFX6-NEXT:    v_cmp_gt_u64_e32 vcc, s[0:1], v[0:1]
; GFX6-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; GFX6-NEXT:    v_cmp_gt_u64_e32 vcc, s[2:3], v[2:3]
; GFX6-NEXT:    v_cndmask_b32_e64 v5, 0, 1, vcc
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, s[2:3], v[2:3]
; GFX6-NEXT:    v_cndmask_b32_e32 v4, v5, v4, vcc
; GFX6-NEXT:    v_and_b32_e32 v4, 1, v4
; GFX6-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; GFX6-NEXT:    v_cndmask_b32_e64 v0, v0, -1, vcc
; GFX6-NEXT:    v_cndmask_b32_e64 v1, v1, -1, vcc
; GFX6-NEXT:    v_cndmask_b32_e64 v2, v2, -1, vcc
; GFX6-NEXT:    v_cndmask_b32_e64 v3, v3, -1, vcc
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: uaddsat_i128_vs:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v4, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, v1, v4, vcc
; GFX8-NEXT:    v_mov_b32_e32 v4, s2
; GFX8-NEXT:    v_mov_b32_e32 v5, s3
; GFX8-NEXT:    v_addc_u32_e32 v2, vcc, v2, v4, vcc
; GFX8-NEXT:    v_addc_u32_e32 v3, vcc, v3, v5, vcc
; GFX8-NEXT:    v_cmp_gt_u64_e32 vcc, s[0:1], v[0:1]
; GFX8-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; GFX8-NEXT:    v_cmp_gt_u64_e32 vcc, s[2:3], v[2:3]
; GFX8-NEXT:    v_cndmask_b32_e64 v5, 0, 1, vcc
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, s[2:3], v[2:3]
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v5, v4, vcc
; GFX8-NEXT:    v_and_b32_e32 v4, 1, v4
; GFX8-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, -1, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v1, -1, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, -1, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v3, -1, vcc
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: uaddsat_i128_vs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v4, s1
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, s0, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v4, vcc
; GFX9-NEXT:    v_mov_b32_e32 v4, s2
; GFX9-NEXT:    v_mov_b32_e32 v5, s3
; GFX9-NEXT:    v_addc_co_u32_e32 v2, vcc, v2, v4, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, v3, v5, vcc
; GFX9-NEXT:    v_cmp_gt_u64_e32 vcc, s[0:1], v[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; GFX9-NEXT:    v_cmp_gt_u64_e32 vcc, s[2:3], v[2:3]
; GFX9-NEXT:    v_cndmask_b32_e64 v5, 0, 1, vcc
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, s[2:3], v[2:3]
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v5, v4, vcc
; GFX9-NEXT:    v_and_b32_e32 v4, 1, v4
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, -1, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, -1, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, -1, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, -1, vcc
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: uaddsat_i128_vs:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, v0, s0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, s1, v1, vcc_lo
; GFX10-NEXT:    v_add_co_ci_u32_e32 v2, vcc_lo, s2, v2, vcc_lo
; GFX10-NEXT:    v_add_co_ci_u32_e32 v3, vcc_lo, s3, v3, vcc_lo
; GFX10-NEXT:    v_cmp_gt_u64_e32 vcc_lo, s[0:1], v[0:1]
; GFX10-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc_lo
; GFX10-NEXT:    v_cmp_gt_u64_e32 vcc_lo, s[2:3], v[2:3]
; GFX10-NEXT:    v_cndmask_b32_e64 v5, 0, 1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[2:3], v[2:3]
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v5, v4, vcc_lo
; GFX10-NEXT:    v_and_b32_e32 v4, 1, v4
; GFX10-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v4
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, -1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, -1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v2, -1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v3, -1, vcc_lo
; GFX10-NEXT:    ; return to shader part epilog
  %result = call i128 @llvm.uadd.sat.i128(i128 %lhs, i128 %rhs)
  %cast = bitcast i128 %result to <4 x float>
  ret <4 x float> %cast
}

define <2 x i128> @v_uaddsat_v2i128(<2 x i128> %lhs, <2 x i128> %rhs) {
; GFX6-LABEL: v_uaddsat_v2i128:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v8
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, v1, v9, vcc
; GFX6-NEXT:    v_addc_u32_e32 v2, vcc, v2, v10, vcc
; GFX6-NEXT:    v_addc_u32_e32 v3, vcc, v3, v11, vcc
; GFX6-NEXT:    v_cmp_lt_u64_e32 vcc, v[0:1], v[8:9]
; GFX6-NEXT:    v_cndmask_b32_e64 v8, 0, 1, vcc
; GFX6-NEXT:    v_cmp_lt_u64_e32 vcc, v[2:3], v[10:11]
; GFX6-NEXT:    v_cndmask_b32_e64 v9, 0, 1, vcc
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, v[2:3], v[10:11]
; GFX6-NEXT:    v_cndmask_b32_e32 v8, v9, v8, vcc
; GFX6-NEXT:    v_and_b32_e32 v8, 1, v8
; GFX6-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX6-NEXT:    v_cndmask_b32_e64 v0, v0, -1, vcc
; GFX6-NEXT:    v_cndmask_b32_e64 v1, v1, -1, vcc
; GFX6-NEXT:    v_cndmask_b32_e64 v2, v2, -1, vcc
; GFX6-NEXT:    v_cndmask_b32_e64 v3, v3, -1, vcc
; GFX6-NEXT:    v_add_i32_e32 v4, vcc, v4, v12
; GFX6-NEXT:    v_addc_u32_e32 v5, vcc, v5, v13, vcc
; GFX6-NEXT:    v_addc_u32_e32 v6, vcc, v6, v14, vcc
; GFX6-NEXT:    v_addc_u32_e32 v7, vcc, v7, v15, vcc
; GFX6-NEXT:    v_cmp_lt_u64_e32 vcc, v[4:5], v[12:13]
; GFX6-NEXT:    v_cndmask_b32_e64 v8, 0, 1, vcc
; GFX6-NEXT:    v_cmp_lt_u64_e32 vcc, v[6:7], v[14:15]
; GFX6-NEXT:    v_cndmask_b32_e64 v9, 0, 1, vcc
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, v[6:7], v[14:15]
; GFX6-NEXT:    v_cndmask_b32_e32 v8, v9, v8, vcc
; GFX6-NEXT:    v_and_b32_e32 v8, 1, v8
; GFX6-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX6-NEXT:    v_cndmask_b32_e64 v4, v4, -1, vcc
; GFX6-NEXT:    v_cndmask_b32_e64 v5, v5, -1, vcc
; GFX6-NEXT:    v_cndmask_b32_e64 v6, v6, -1, vcc
; GFX6-NEXT:    v_cndmask_b32_e64 v7, v7, -1, vcc
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_uaddsat_v2i128:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, v0, v8
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, v1, v9, vcc
; GFX8-NEXT:    v_addc_u32_e32 v2, vcc, v2, v10, vcc
; GFX8-NEXT:    v_addc_u32_e32 v3, vcc, v3, v11, vcc
; GFX8-NEXT:    v_cmp_lt_u64_e32 vcc, v[0:1], v[8:9]
; GFX8-NEXT:    v_cndmask_b32_e64 v8, 0, 1, vcc
; GFX8-NEXT:    v_cmp_lt_u64_e32 vcc, v[2:3], v[10:11]
; GFX8-NEXT:    v_cndmask_b32_e64 v9, 0, 1, vcc
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, v[2:3], v[10:11]
; GFX8-NEXT:    v_cndmask_b32_e32 v8, v9, v8, vcc
; GFX8-NEXT:    v_and_b32_e32 v8, 1, v8
; GFX8-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, -1, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v1, -1, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, -1, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v3, -1, vcc
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, v4, v12
; GFX8-NEXT:    v_addc_u32_e32 v5, vcc, v5, v13, vcc
; GFX8-NEXT:    v_addc_u32_e32 v6, vcc, v6, v14, vcc
; GFX8-NEXT:    v_addc_u32_e32 v7, vcc, v7, v15, vcc
; GFX8-NEXT:    v_cmp_lt_u64_e32 vcc, v[4:5], v[12:13]
; GFX8-NEXT:    v_cndmask_b32_e64 v8, 0, 1, vcc
; GFX8-NEXT:    v_cmp_lt_u64_e32 vcc, v[6:7], v[14:15]
; GFX8-NEXT:    v_cndmask_b32_e64 v9, 0, 1, vcc
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, v[6:7], v[14:15]
; GFX8-NEXT:    v_cndmask_b32_e32 v8, v9, v8, vcc
; GFX8-NEXT:    v_and_b32_e32 v8, 1, v8
; GFX8-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX8-NEXT:    v_cndmask_b32_e64 v4, v4, -1, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v5, v5, -1, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v6, v6, -1, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v7, v7, -1, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_uaddsat_v2i128:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, v0, v8
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v9, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v2, vcc, v2, v10, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, v3, v11, vcc
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, v[0:1], v[8:9]
; GFX9-NEXT:    v_cndmask_b32_e64 v8, 0, 1, vcc
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, v[2:3], v[10:11]
; GFX9-NEXT:    v_cndmask_b32_e64 v9, 0, 1, vcc
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[2:3], v[10:11]
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v9, v8, vcc
; GFX9-NEXT:    v_and_b32_e32 v8, 1, v8
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, -1, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, -1, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, -1, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, -1, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, v4, v12
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, v5, v13, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v6, vcc, v6, v14, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v7, vcc, v7, v15, vcc
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, v[4:5], v[12:13]
; GFX9-NEXT:    v_cndmask_b32_e64 v8, 0, 1, vcc
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, v[6:7], v[14:15]
; GFX9-NEXT:    v_cndmask_b32_e64 v9, 0, 1, vcc
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[6:7], v[14:15]
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v9, v8, vcc
; GFX9-NEXT:    v_and_b32_e32 v8, 1, v8
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    v_cndmask_b32_e64 v4, v4, -1, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v5, v5, -1, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v6, v6, -1, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v7, v7, -1, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_uaddsat_v2i128:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v8
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v9, vcc_lo
; GFX10-NEXT:    v_add_co_ci_u32_e32 v2, vcc_lo, v2, v10, vcc_lo
; GFX10-NEXT:    v_add_co_ci_u32_e32 v3, vcc_lo, v3, v11, vcc_lo
; GFX10-NEXT:    v_cmp_lt_u64_e32 vcc_lo, v[0:1], v[8:9]
; GFX10-NEXT:    v_cndmask_b32_e64 v8, 0, 1, vcc_lo
; GFX10-NEXT:    v_add_co_u32 v4, vcc_lo, v4, v12
; GFX10-NEXT:    v_add_co_ci_u32_e32 v5, vcc_lo, v5, v13, vcc_lo
; GFX10-NEXT:    v_add_co_ci_u32_e32 v6, vcc_lo, v6, v14, vcc_lo
; GFX10-NEXT:    v_add_co_ci_u32_e32 v7, vcc_lo, v7, v15, vcc_lo
; GFX10-NEXT:    v_cmp_lt_u64_e32 vcc_lo, v[2:3], v[10:11]
; GFX10-NEXT:    v_cndmask_b32_e64 v9, 0, 1, vcc_lo
; GFX10-NEXT:    v_cmp_lt_u64_e32 vcc_lo, v[4:5], v[12:13]
; GFX10-NEXT:    v_cndmask_b32_e64 v12, 0, 1, vcc_lo
; GFX10-NEXT:    v_cmp_lt_u64_e32 vcc_lo, v[6:7], v[14:15]
; GFX10-NEXT:    v_cndmask_b32_e64 v13, 0, 1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[2:3], v[10:11]
; GFX10-NEXT:    v_cndmask_b32_e32 v8, v9, v8, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[6:7], v[14:15]
; GFX10-NEXT:    v_and_b32_e32 v8, 1, v8
; GFX10-NEXT:    v_cndmask_b32_e32 v9, v13, v12, vcc_lo
; GFX10-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v8
; GFX10-NEXT:    v_and_b32_e32 v9, 1, v9
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, -1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, -1, vcc_lo
; GFX10-NEXT:    v_cmp_ne_u32_e64 s4, 0, v9
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v2, -1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v3, -1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v4, v4, -1, s4
; GFX10-NEXT:    v_cndmask_b32_e64 v5, v5, -1, s4
; GFX10-NEXT:    v_cndmask_b32_e64 v6, v6, -1, s4
; GFX10-NEXT:    v_cndmask_b32_e64 v7, v7, -1, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call <2 x i128> @llvm.uadd.sat.v2i128(<2 x i128> %lhs, <2 x i128> %rhs)
  ret <2 x i128> %result
}

define amdgpu_ps <2 x i128> @s_uaddsat_v2i128(<2 x i128> inreg %lhs, <2 x i128> inreg %rhs) {
; GFX6-LABEL: s_uaddsat_v2i128:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_add_u32 s0, s0, s8
; GFX6-NEXT:    s_cselect_b32 s16, 1, 0
; GFX6-NEXT:    s_and_b32 s16, s16, 1
; GFX6-NEXT:    s_cmp_lg_u32 s16, 0
; GFX6-NEXT:    s_addc_u32 s1, s1, s9
; GFX6-NEXT:    s_cselect_b32 s16, 1, 0
; GFX6-NEXT:    s_and_b32 s16, s16, 1
; GFX6-NEXT:    s_cmp_lg_u32 s16, 0
; GFX6-NEXT:    s_addc_u32 s2, s2, s10
; GFX6-NEXT:    s_cselect_b32 s16, 1, 0
; GFX6-NEXT:    v_mov_b32_e32 v2, s8
; GFX6-NEXT:    s_and_b32 s16, s16, 1
; GFX6-NEXT:    v_mov_b32_e32 v3, s9
; GFX6-NEXT:    s_cmp_lg_u32 s16, 0
; GFX6-NEXT:    v_mov_b32_e32 v0, s10
; GFX6-NEXT:    v_cmp_lt_u64_e32 vcc, s[0:1], v[2:3]
; GFX6-NEXT:    s_addc_u32 s3, s3, s11
; GFX6-NEXT:    v_mov_b32_e32 v1, s11
; GFX6-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX6-NEXT:    v_cmp_lt_u64_e32 vcc, s[2:3], v[0:1]
; GFX6-NEXT:    v_cndmask_b32_e64 v3, 0, 1, vcc
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, s[2:3], v[0:1]
; GFX6-NEXT:    v_mov_b32_e32 v1, s0
; GFX6-NEXT:    s_add_u32 s0, s4, s12
; GFX6-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX6-NEXT:    v_mov_b32_e32 v2, s1
; GFX6-NEXT:    s_cselect_b32 s1, 1, 0
; GFX6-NEXT:    s_and_b32 s1, s1, 1
; GFX6-NEXT:    s_cmp_lg_u32 s1, 0
; GFX6-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX6-NEXT:    s_addc_u32 s1, s5, s13
; GFX6-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX6-NEXT:    v_mov_b32_e32 v0, s2
; GFX6-NEXT:    s_cselect_b32 s2, 1, 0
; GFX6-NEXT:    s_and_b32 s2, s2, 1
; GFX6-NEXT:    s_cmp_lg_u32 s2, 0
; GFX6-NEXT:    s_addc_u32 s2, s6, s14
; GFX6-NEXT:    v_cndmask_b32_e64 v4, v1, -1, vcc
; GFX6-NEXT:    v_cndmask_b32_e64 v5, v2, -1, vcc
; GFX6-NEXT:    v_mov_b32_e32 v1, s3
; GFX6-NEXT:    s_cselect_b32 s3, 1, 0
; GFX6-NEXT:    v_mov_b32_e32 v2, s12
; GFX6-NEXT:    s_and_b32 s3, s3, 1
; GFX6-NEXT:    v_mov_b32_e32 v3, s13
; GFX6-NEXT:    v_cndmask_b32_e64 v6, v0, -1, vcc
; GFX6-NEXT:    v_cndmask_b32_e64 v7, v1, -1, vcc
; GFX6-NEXT:    s_cmp_lg_u32 s3, 0
; GFX6-NEXT:    v_mov_b32_e32 v0, s14
; GFX6-NEXT:    v_cmp_lt_u64_e32 vcc, s[0:1], v[2:3]
; GFX6-NEXT:    s_addc_u32 s3, s7, s15
; GFX6-NEXT:    v_mov_b32_e32 v1, s15
; GFX6-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX6-NEXT:    v_cmp_lt_u64_e32 vcc, s[2:3], v[0:1]
; GFX6-NEXT:    v_cndmask_b32_e64 v3, 0, 1, vcc
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, s[2:3], v[0:1]
; GFX6-NEXT:    v_mov_b32_e32 v1, s0
; GFX6-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX6-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX6-NEXT:    v_mov_b32_e32 v2, s1
; GFX6-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX6-NEXT:    v_cndmask_b32_e64 v0, v1, -1, vcc
; GFX6-NEXT:    v_cndmask_b32_e64 v1, v2, -1, vcc
; GFX6-NEXT:    v_mov_b32_e32 v2, s2
; GFX6-NEXT:    v_mov_b32_e32 v3, s3
; GFX6-NEXT:    v_cndmask_b32_e64 v2, v2, -1, vcc
; GFX6-NEXT:    v_cndmask_b32_e64 v3, v3, -1, vcc
; GFX6-NEXT:    v_readfirstlane_b32 s0, v4
; GFX6-NEXT:    v_readfirstlane_b32 s1, v5
; GFX6-NEXT:    v_readfirstlane_b32 s2, v6
; GFX6-NEXT:    v_readfirstlane_b32 s3, v7
; GFX6-NEXT:    v_readfirstlane_b32 s4, v0
; GFX6-NEXT:    v_readfirstlane_b32 s5, v1
; GFX6-NEXT:    v_readfirstlane_b32 s6, v2
; GFX6-NEXT:    v_readfirstlane_b32 s7, v3
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_uaddsat_v2i128:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_add_u32 s0, s0, s8
; GFX8-NEXT:    s_cselect_b32 s16, 1, 0
; GFX8-NEXT:    s_and_b32 s16, s16, 1
; GFX8-NEXT:    s_cmp_lg_u32 s16, 0
; GFX8-NEXT:    s_addc_u32 s1, s1, s9
; GFX8-NEXT:    s_cselect_b32 s16, 1, 0
; GFX8-NEXT:    s_and_b32 s16, s16, 1
; GFX8-NEXT:    s_cmp_lg_u32 s16, 0
; GFX8-NEXT:    s_addc_u32 s2, s2, s10
; GFX8-NEXT:    s_cselect_b32 s16, 1, 0
; GFX8-NEXT:    s_and_b32 s16, s16, 1
; GFX8-NEXT:    v_mov_b32_e32 v2, s8
; GFX8-NEXT:    s_cmp_lg_u32 s16, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s9
; GFX8-NEXT:    s_addc_u32 s3, s3, s11
; GFX8-NEXT:    v_mov_b32_e32 v0, s10
; GFX8-NEXT:    v_cmp_lt_u64_e32 vcc, s[0:1], v[2:3]
; GFX8-NEXT:    v_mov_b32_e32 v1, s11
; GFX8-NEXT:    s_cmp_eq_u64 s[2:3], s[10:11]
; GFX8-NEXT:    s_cselect_b32 s10, 1, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX8-NEXT:    v_cmp_lt_u64_e32 vcc, s[2:3], v[0:1]
; GFX8-NEXT:    s_and_b32 s8, 1, s10
; GFX8-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s8
; GFX8-NEXT:    v_mov_b32_e32 v1, s0
; GFX8-NEXT:    s_add_u32 s0, s4, s12
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    v_mov_b32_e32 v2, s1
; GFX8-NEXT:    s_cselect_b32 s1, 1, 0
; GFX8-NEXT:    s_and_b32 s1, s1, 1
; GFX8-NEXT:    s_cmp_lg_u32 s1, 0
; GFX8-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX8-NEXT:    s_addc_u32 s1, s5, s13
; GFX8-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    s_cselect_b32 s2, 1, 0
; GFX8-NEXT:    s_and_b32 s2, s2, 1
; GFX8-NEXT:    s_cmp_lg_u32 s2, 0
; GFX8-NEXT:    s_addc_u32 s2, s6, s14
; GFX8-NEXT:    v_cndmask_b32_e64 v4, v1, -1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_cselect_b32 s3, 1, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v5, v2, -1, vcc
; GFX8-NEXT:    s_and_b32 s3, s3, 1
; GFX8-NEXT:    v_mov_b32_e32 v2, s12
; GFX8-NEXT:    s_cmp_lg_u32 s3, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s13
; GFX8-NEXT:    v_cndmask_b32_e64 v6, v0, -1, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v7, v1, -1, vcc
; GFX8-NEXT:    s_addc_u32 s3, s7, s15
; GFX8-NEXT:    v_mov_b32_e32 v0, s14
; GFX8-NEXT:    v_cmp_lt_u64_e32 vcc, s[0:1], v[2:3]
; GFX8-NEXT:    v_mov_b32_e32 v1, s15
; GFX8-NEXT:    s_cmp_eq_u64 s[2:3], s[14:15]
; GFX8-NEXT:    s_cselect_b32 s4, 1, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX8-NEXT:    v_cmp_lt_u64_e32 vcc, s[2:3], v[0:1]
; GFX8-NEXT:    s_and_b32 s4, 1, s4
; GFX8-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s4
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX8-NEXT:    v_mov_b32_e32 v1, s0
; GFX8-NEXT:    v_mov_b32_e32 v2, s1
; GFX8-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v1, -1, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v2, -1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v2, -1, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v3, -1, vcc
; GFX8-NEXT:    v_readfirstlane_b32 s0, v4
; GFX8-NEXT:    v_readfirstlane_b32 s1, v5
; GFX8-NEXT:    v_readfirstlane_b32 s2, v6
; GFX8-NEXT:    v_readfirstlane_b32 s3, v7
; GFX8-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8-NEXT:    v_readfirstlane_b32 s5, v1
; GFX8-NEXT:    v_readfirstlane_b32 s6, v2
; GFX8-NEXT:    v_readfirstlane_b32 s7, v3
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_uaddsat_v2i128:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_add_u32 s0, s0, s8
; GFX9-NEXT:    s_cselect_b32 s16, 1, 0
; GFX9-NEXT:    s_and_b32 s16, s16, 1
; GFX9-NEXT:    s_cmp_lg_u32 s16, 0
; GFX9-NEXT:    s_addc_u32 s1, s1, s9
; GFX9-NEXT:    s_cselect_b32 s16, 1, 0
; GFX9-NEXT:    s_and_b32 s16, s16, 1
; GFX9-NEXT:    s_cmp_lg_u32 s16, 0
; GFX9-NEXT:    s_addc_u32 s2, s2, s10
; GFX9-NEXT:    s_cselect_b32 s16, 1, 0
; GFX9-NEXT:    s_and_b32 s16, s16, 1
; GFX9-NEXT:    v_mov_b32_e32 v2, s8
; GFX9-NEXT:    s_cmp_lg_u32 s16, 0
; GFX9-NEXT:    v_mov_b32_e32 v3, s9
; GFX9-NEXT:    s_addc_u32 s3, s3, s11
; GFX9-NEXT:    v_mov_b32_e32 v0, s10
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, s[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, s11
; GFX9-NEXT:    s_cmp_eq_u64 s[2:3], s[10:11]
; GFX9-NEXT:    s_cselect_b32 s10, 1, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, s[2:3], v[0:1]
; GFX9-NEXT:    s_and_b32 s8, 1, s10
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-NEXT:    s_add_u32 s0, s4, s12
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX9-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-NEXT:    s_cselect_b32 s1, 1, 0
; GFX9-NEXT:    s_and_b32 s1, s1, 1
; GFX9-NEXT:    s_cmp_lg_u32 s1, 0
; GFX9-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX9-NEXT:    s_addc_u32 s1, s5, s13
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    s_cselect_b32 s2, 1, 0
; GFX9-NEXT:    s_and_b32 s2, s2, 1
; GFX9-NEXT:    s_cmp_lg_u32 s2, 0
; GFX9-NEXT:    s_addc_u32 s2, s6, s14
; GFX9-NEXT:    v_cndmask_b32_e64 v4, v1, -1, vcc
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    s_cselect_b32 s3, 1, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v5, v2, -1, vcc
; GFX9-NEXT:    s_and_b32 s3, s3, 1
; GFX9-NEXT:    v_mov_b32_e32 v2, s12
; GFX9-NEXT:    s_cmp_lg_u32 s3, 0
; GFX9-NEXT:    v_mov_b32_e32 v3, s13
; GFX9-NEXT:    v_cndmask_b32_e64 v6, v0, -1, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v7, v1, -1, vcc
; GFX9-NEXT:    s_addc_u32 s3, s7, s15
; GFX9-NEXT:    v_mov_b32_e32 v0, s14
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, s[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, s15
; GFX9-NEXT:    s_cmp_eq_u64 s[2:3], s[14:15]
; GFX9-NEXT:    s_cselect_b32 s4, 1, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, s[2:3], v[0:1]
; GFX9-NEXT:    s_and_b32 s4, 1, s4
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s4
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX9-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v1, -1, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v2, -1, vcc
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    v_mov_b32_e32 v3, s3
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, -1, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, -1, vcc
; GFX9-NEXT:    v_readfirstlane_b32 s0, v4
; GFX9-NEXT:    v_readfirstlane_b32 s1, v5
; GFX9-NEXT:    v_readfirstlane_b32 s2, v6
; GFX9-NEXT:    v_readfirstlane_b32 s3, v7
; GFX9-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9-NEXT:    v_readfirstlane_b32 s5, v1
; GFX9-NEXT:    v_readfirstlane_b32 s6, v2
; GFX9-NEXT:    v_readfirstlane_b32 s7, v3
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_uaddsat_v2i128:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_add_u32 s0, s0, s8
; GFX10-NEXT:    s_cselect_b32 s16, 1, 0
; GFX10-NEXT:    s_and_b32 s16, s16, 1
; GFX10-NEXT:    s_cmp_lg_u32 s16, 0
; GFX10-NEXT:    s_addc_u32 s1, s1, s9
; GFX10-NEXT:    s_cselect_b32 s16, 1, 0
; GFX10-NEXT:    v_cmp_lt_u64_e64 s8, s[0:1], s[8:9]
; GFX10-NEXT:    s_and_b32 s16, s16, 1
; GFX10-NEXT:    s_cmp_lg_u32 s16, 0
; GFX10-NEXT:    s_addc_u32 s2, s2, s10
; GFX10-NEXT:    s_cselect_b32 s16, 1, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s8
; GFX10-NEXT:    s_and_b32 s16, s16, 1
; GFX10-NEXT:    s_cmp_lg_u32 s16, 0
; GFX10-NEXT:    s_addc_u32 s3, s3, s11
; GFX10-NEXT:    s_cmp_eq_u64 s[2:3], s[10:11]
; GFX10-NEXT:    v_cmp_lt_u64_e64 s10, s[2:3], s[10:11]
; GFX10-NEXT:    s_cselect_b32 s16, 1, 0
; GFX10-NEXT:    s_and_b32 s8, 1, s16
; GFX10-NEXT:    s_add_u32 s4, s4, s12
; GFX10-NEXT:    s_cselect_b32 s9, 1, 0
; GFX10-NEXT:    v_cmp_ne_u32_e64 vcc_lo, 0, s8
; GFX10-NEXT:    s_and_b32 s9, s9, 1
; GFX10-NEXT:    v_cndmask_b32_e64 v1, 0, 1, s10
; GFX10-NEXT:    s_cmp_lg_u32 s9, 0
; GFX10-NEXT:    s_addc_u32 s5, s5, s13
; GFX10-NEXT:    s_cselect_b32 s9, 1, 0
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc_lo
; GFX10-NEXT:    s_and_b32 s9, s9, 1
; GFX10-NEXT:    s_cmp_lg_u32 s9, 0
; GFX10-NEXT:    v_cmp_lt_u64_e64 s9, s[4:5], s[12:13]
; GFX10-NEXT:    s_addc_u32 s6, s6, s14
; GFX10-NEXT:    s_cselect_b32 s8, 1, 0
; GFX10-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX10-NEXT:    s_and_b32 s8, s8, 1
; GFX10-NEXT:    v_cndmask_b32_e64 v1, 0, 1, s9
; GFX10-NEXT:    s_cmp_lg_u32 s8, 0
; GFX10-NEXT:    s_addc_u32 s7, s7, s15
; GFX10-NEXT:    s_cmp_eq_u64 s[6:7], s[14:15]
; GFX10-NEXT:    v_cmp_lt_u64_e64 s9, s[6:7], s[14:15]
; GFX10-NEXT:    s_cselect_b32 s8, 1, 0
; GFX10-NEXT:    s_and_b32 s8, 1, s8
; GFX10-NEXT:    v_cmp_ne_u32_e64 vcc_lo, 0, s8
; GFX10-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s9
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc_lo
; GFX10-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v0
; GFX10-NEXT:    v_and_b32_e32 v0, 1, v1
; GFX10-NEXT:    v_cndmask_b32_e64 v1, s0, -1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, s1, -1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v3, s2, -1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v4, s3, -1, vcc_lo
; GFX10-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v0
; GFX10-NEXT:    v_readfirstlane_b32 s0, v1
; GFX10-NEXT:    v_readfirstlane_b32 s1, v2
; GFX10-NEXT:    v_readfirstlane_b32 s2, v3
; GFX10-NEXT:    v_readfirstlane_b32 s3, v4
; GFX10-NEXT:    v_cndmask_b32_e64 v0, s4, -1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v1, s5, -1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, s6, -1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v3, s7, -1, vcc_lo
; GFX10-NEXT:    v_readfirstlane_b32 s4, v0
; GFX10-NEXT:    v_readfirstlane_b32 s5, v1
; GFX10-NEXT:    v_readfirstlane_b32 s6, v2
; GFX10-NEXT:    v_readfirstlane_b32 s7, v3
; GFX10-NEXT:    ; return to shader part epilog
  %result = call <2 x i128> @llvm.uadd.sat.v2i128(<2 x i128> %lhs, <2 x i128> %rhs)
  ret <2 x i128> %result
}

declare i7 @llvm.uadd.sat.i7(i7, i7) #0
declare i8 @llvm.uadd.sat.i8(i8, i8) #0
declare <2 x i8> @llvm.uadd.sat.v2i8(<2 x i8>, <2 x i8>) #0
declare <4 x i8> @llvm.uadd.sat.v4i8(<4 x i8>, <4 x i8>) #0

declare i16 @llvm.uadd.sat.i16(i16, i16) #0
declare <2 x i16> @llvm.uadd.sat.v2i16(<2 x i16>, <2 x i16>) #0
declare <3 x i16> @llvm.uadd.sat.v3i16(<3 x i16>, <3 x i16>) #0
declare <4 x i16> @llvm.uadd.sat.v4i16(<4 x i16>, <4 x i16>) #0
declare <5 x i16> @llvm.uadd.sat.v5i16(<5 x i16>, <5 x i16>) #0
declare <6 x i16> @llvm.uadd.sat.v6i16(<6 x i16>, <6 x i16>) #0
declare <8 x i16> @llvm.uadd.sat.v8i16(<8 x i16>, <8 x i16>) #0

declare i24 @llvm.uadd.sat.i24(i24, i24) #0

declare i32 @llvm.uadd.sat.i32(i32, i32) #0
declare <2 x i32> @llvm.uadd.sat.v2i32(<2 x i32>, <2 x i32>) #0
declare <3 x i32> @llvm.uadd.sat.v3i32(<3 x i32>, <3 x i32>) #0
declare <4 x i32> @llvm.uadd.sat.v4i32(<4 x i32>, <4 x i32>) #0
declare <5 x i32> @llvm.uadd.sat.v5i32(<5 x i32>, <5 x i32>) #0
declare <16 x i32> @llvm.uadd.sat.v16i32(<16 x i32>, <16 x i32>) #0

declare i48 @llvm.uadd.sat.i48(i48, i48) #0

declare i64 @llvm.uadd.sat.i64(i64, i64) #0
declare <2 x i64> @llvm.uadd.sat.v2i64(<2 x i64>, <2 x i64>) #0

declare i128 @llvm.uadd.sat.i128(i128, i128) #0
declare <2 x i128> @llvm.uadd.sat.v2i128(<2 x i128>, <2 x i128>) #0

attributes #0 = { nounwind readnone speculatable willreturn }
