// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --function-signature --include-generated-funcs --replace-value-regex "__omp_offloading_[0-9a-z]+_[0-9a-z]+" "reduction_size[.].+[.]" "pl_cond[.].+[.|,]" --prefix-filecheck-ir-name _
// RUN: %clang_cc1 -verify -fopenmp -x c++ -triple x86_64-apple-darwin10 -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK1
// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple x86_64-apple-darwin10 -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp -x c++ -triple x86_64-apple-darwin10 -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK2
// RUN: %clang_cc1 -verify -fopenmp -x c++ -std=c++11 -DLAMBDA -triple x86_64-apple-darwin10 -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK3
// RUN: %clang_cc1 -verify -fopenmp -x c++ -fblocks -DBLOCKS -triple x86_64-apple-darwin10 -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK4

// RUN: %clang_cc1 -verify -fopenmp-simd -x c++ -triple x86_64-apple-darwin10 -emit-llvm %s -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -fopenmp-simd -x c++ -std=c++11 -triple x86_64-apple-darwin10 -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp-simd -x c++ -triple x86_64-apple-darwin10 -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -verify -fopenmp-simd -x c++ -std=c++11 -DLAMBDA -triple x86_64-apple-darwin10 -emit-llvm %s -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -verify -fopenmp-simd -x c++ -fblocks -DBLOCKS -triple x86_64-apple-darwin10 -emit-llvm %s -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// expected-no-diagnostics
#ifndef HEADER
#define HEADER

enum omp_allocator_handle_t {
  omp_null_allocator = 0,
  omp_default_mem_alloc = 1,
  omp_large_cap_mem_alloc = 2,
  omp_const_mem_alloc = 3,
  omp_high_bw_mem_alloc = 4,
  omp_low_lat_mem_alloc = 5,
  omp_cgroup_mem_alloc = 6,
  omp_pteam_mem_alloc = 7,
  omp_thread_mem_alloc = 8,
  KMP_ALLOCATOR_MAX_HANDLE = __UINTPTR_MAX__
};

template <class T>
struct S {
  T f;
  S(T a) : f(a) {}
  S() : f() {}
  S<T> &operator=(const S<T> &);
  operator T() { return T(); }
  ~S() {}
};

volatile int g = 1212;
volatile int &g1 = g;
float f;
char cnt;

struct SS {
  int a;
  int b : 4;
  int &c;
  SS(int &d) : a(0), b(0), c(d) {
#pragma omp parallel
#pragma omp for linear(a, b, c)
    for (int i = 0; i < 2; ++i)
#ifdef LAMBDA
      [&]() {
        ++this->a, --b, (this)->c /= 1;
#pragma omp parallel
#pragma omp for linear(a, b) linear(ref(c))
        for (int i = 0; i < 2; ++i)
          ++(this)->a, --b, this->c /= 1;
      }();
#elif defined(BLOCKS)
      ^{
        ++a;
        --this->b;
        (this)->c /= 1;
#pragma omp parallel
#pragma omp for linear(a, b) linear(uval(c))
        for (int i = 0; i < 2; ++i)
          ++(this)->a, --b, this->c /= 1;
      }();
#else
      ++this->a, --b, c /= 1;
#endif
  }
};

template <typename T>
struct SST {
  T a;
  SST() : a(T()) {
#pragma omp parallel
#pragma omp for linear(a)
    for (int i = 0; i < 2; ++i)
#ifdef LAMBDA
      [&]() {
        [&]() {
          ++this->a;
#pragma omp parallel
#pragma omp for linear(a)
          for (int i = 0; i < 2; ++i)
            ++(this)->a;
        }();
      }();
#elif defined(BLOCKS)
      ^{
        ^{
          ++a;
#pragma omp parallel
#pragma omp for linear(a)
          for (int i = 0; i < 2; ++i)
            ++(this)->a;
        }();
      }();
#else
      ++(this)->a;
#endif
  }
};

template <typename T>
T tmain() {
  S<T> test;
  SST<T> sst;
  T *pvar = &test.f;
  T &lvar = test.f;
#pragma omp parallel
#pragma omp for linear(pvar, lvar)
  for (int i = 0; i < 2; ++i) {
    ++pvar, ++lvar;
  }
  return T();
}

int main() {
  static int sivar;
  SS ss(sivar);
#ifdef LAMBDA
  [&]() {
#pragma omp parallel
#pragma omp for linear(g, g1:5)
  for (int i = 0; i < 2; ++i) {



    g += 5;
    g1 += 5;
    [&]() {
      g = 2;
      g1 = 2;
    }();
  }
  }();
  return 0;
#elif defined(BLOCKS)
  ^{
#pragma omp parallel
#pragma omp for linear(g, g1:5)
  for (int i = 0; i < 2; ++i) {
    g += 5;
    g1 += 5;
    g = 1;
    g1 = 5;
    ^{
      g = 2;
      g1 = 2;
    }();
  }
  }();
  return 0;


#else
  S<float> test;
  float *pvar = &test.f;
  long long lvar = 0;
#pragma omp parallel
#pragma omp for linear(pvar, lvar : 3) allocate(omp_low_lat_mem_alloc: lvar)
  for (int i = 0; i < 2; ++i) {
    pvar += 3, lvar += 3;
  }
  return tmain<int>();
#endif
}



// Check for default initialization.





// Check for default initialization.

#endif

// CHECK1-LABEL: define {{[^@]+}}@main
// CHECK1-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[SS:%.*]] = alloca [[STRUCT_SS:%.*]], align 8
// CHECK1-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S:%.*]], align 4
// CHECK1-NEXT:    [[PVAR:%.*]] = alloca float*, align 8
// CHECK1-NEXT:    [[LVAR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK1-NEXT:    call void @_ZN2SSC1ERi(%struct.SS* nonnull align 8 dereferenceable(16) [[SS]], i32* nonnull align 4 dereferenceable(4) @_ZZ4mainE5sivar)
// CHECK1-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* nonnull align 4 dereferenceable(4) [[TEST]])
// CHECK1-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[TEST]], i32 0, i32 0
// CHECK1-NEXT:    store float* [[F]], float** [[PVAR]], align 8
// CHECK1-NEXT:    store i64 0, i64* [[LVAR]], align 8
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3:[0-9]+]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, i64*)* @.omp_outlined. to void (i32*, i32*, ...)*), float** [[PVAR]], i64* [[LVAR]])
// CHECK1-NEXT:    [[CALL:%.*]] = call i32 @_Z5tmainIiET_v()
// CHECK1-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK1-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* nonnull align 4 dereferenceable(4) [[TEST]]) #[[ATTR4:[0-9]+]]
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK1-NEXT:    ret i32 [[TMP0]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN2SSC1ERi
// CHECK1-SAME: (%struct.SS* nonnull align 8 dereferenceable(16) [[THIS:%.*]], i32* nonnull align 4 dereferenceable(4) [[D:%.*]]) unnamed_addr #[[ATTR1:[0-9]+]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK1-NEXT:    [[D_ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store i32* [[D]], i32** [[D_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[D_ADDR]], align 8
// CHECK1-NEXT:    call void @_ZN2SSC2ERi(%struct.SS* nonnull align 8 dereferenceable(16) [[THIS1]], i32* nonnull align 4 dereferenceable(4) [[TMP0]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN1SIfEC1Ev
// CHECK1-SAME: (%struct.S* nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK1-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    call void @_ZN1SIfEC2Ev(%struct.S* nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK1-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 8 dereferenceable(8) [[PVAR:%.*]], i64* nonnull align 8 dereferenceable(8) [[LVAR:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[PVAR_ADDR:%.*]] = alloca float**, align 8
// CHECK1-NEXT:    [[LVAR_ADDR:%.*]] = alloca i64*, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTLINEAR_START:%.*]] = alloca float*, align 8
// CHECK1-NEXT:    [[DOTLINEAR_START1:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[PVAR2:%.*]] = alloca float*, align 8
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store float** [[PVAR]], float*** [[PVAR_ADDR]], align 8
// CHECK1-NEXT:    store i64* [[LVAR]], i64** [[LVAR_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load float**, float*** [[PVAR_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i64*, i64** [[LVAR_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load float*, float** [[TMP0]], align 8
// CHECK1-NEXT:    store float* [[TMP2]], float** [[DOTLINEAR_START]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load i64, i64* [[TMP1]], align 8
// CHECK1-NEXT:    store i64 [[TMP3]], i64* [[DOTLINEAR_START1]], align 8
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK1-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP5]])
// CHECK1-NEXT:    [[DOTLVAR__VOID_ADDR:%.*]] = call i8* @__kmpc_alloc(i32 [[TMP5]], i64 8, i8* inttoptr (i64 5 to i8*))
// CHECK1-NEXT:    [[DOTLVAR__ADDR:%.*]] = bitcast i8* [[DOTLVAR__VOID_ADDR]] to i64*
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP5]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 1
// CHECK1-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP3:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK1-NEXT:    br i1 [[CMP3]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK1:       omp.inner.for.cond.cleanup:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[I]], align 4
// CHECK1-NEXT:    [[TMP12:%.*]] = load float*, float** [[DOTLINEAR_START]], align 8
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[MUL4:%.*]] = mul nsw i32 [[TMP13]], 3
// CHECK1-NEXT:    [[IDX_EXT:%.*]] = sext i32 [[MUL4]] to i64
// CHECK1-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds float, float* [[TMP12]], i64 [[IDX_EXT]]
// CHECK1-NEXT:    store float* [[ADD_PTR]], float** [[PVAR2]], align 8
// CHECK1-NEXT:    [[TMP14:%.*]] = load i64, i64* [[DOTLINEAR_START1]], align 8
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[MUL5:%.*]] = mul nsw i32 [[TMP15]], 3
// CHECK1-NEXT:    [[CONV:%.*]] = sext i32 [[MUL5]] to i64
// CHECK1-NEXT:    [[ADD6:%.*]] = add nsw i64 [[TMP14]], [[CONV]]
// CHECK1-NEXT:    store i64 [[ADD6]], i64* [[DOTLVAR__ADDR]], align 8
// CHECK1-NEXT:    [[TMP16:%.*]] = load float*, float** [[PVAR2]], align 8
// CHECK1-NEXT:    [[ADD_PTR7:%.*]] = getelementptr inbounds float, float* [[TMP16]], i64 3
// CHECK1-NEXT:    store float* [[ADD_PTR7]], float** [[PVAR2]], align 8
// CHECK1-NEXT:    [[TMP17:%.*]] = load i64, i64* [[DOTLVAR__ADDR]], align 8
// CHECK1-NEXT:    [[ADD8:%.*]] = add nsw i64 [[TMP17]], 3
// CHECK1-NEXT:    store i64 [[ADD8]], i64* [[DOTLVAR__ADDR]], align 8
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK1-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB2]], i32 [[TMP5]])
// CHECK1-NEXT:    [[TMP19:%.*]] = bitcast i64* [[DOTLVAR__ADDR]] to i8*
// CHECK1-NEXT:    call void @__kmpc_free(i32 [[TMP5]], i8* [[TMP19]], i8* inttoptr (i64 5 to i8*))
// CHECK1-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP21:%.*]] = icmp ne i32 [[TMP20]], 0
// CHECK1-NEXT:    br i1 [[TMP21]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK1:       .omp.linear.pu:
// CHECK1-NEXT:    [[TMP22:%.*]] = load float*, float** [[PVAR2]], align 8
// CHECK1-NEXT:    store float* [[TMP22]], float** [[TMP0]], align 8
// CHECK1-NEXT:    [[TMP23:%.*]] = load i64, i64* [[DOTLVAR__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[TMP23]], i64* [[TMP1]], align 8
// CHECK1-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK1:       .omp.linear.pu.done:
// CHECK1-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_Z5tmainIiET_v
// CHECK1-SAME: () #[[ATTR5:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S_0:%.*]], align 4
// CHECK1-NEXT:    [[SST:%.*]] = alloca [[STRUCT_SST:%.*]], align 4
// CHECK1-NEXT:    [[PVAR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[LVAR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* nonnull align 4 dereferenceable(4) [[TEST]])
// CHECK1-NEXT:    call void @_ZN3SSTIiEC1Ev(%struct.SST* nonnull align 4 dereferenceable(4) [[SST]])
// CHECK1-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[TEST]], i32 0, i32 0
// CHECK1-NEXT:    store i32* [[F]], i32** [[PVAR]], align 8
// CHECK1-NEXT:    [[F1:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[TEST]], i32 0, i32 0
// CHECK1-NEXT:    store i32* [[F1]], i32** [[LVAR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[LVAR]], align 8
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32**, i32*)* @.omp_outlined..2 to void (i32*, i32*, ...)*), i32** [[PVAR]], i32* [[TMP0]])
// CHECK1-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* nonnull align 4 dereferenceable(4) [[TEST]]) #[[ATTR4]]
// CHECK1-NEXT:    ret i32 0
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN1SIfED1Ev
// CHECK1-SAME: (%struct.S* nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK1-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    call void @_ZN1SIfED2Ev(%struct.S* nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR4]]
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN2SSC2ERi
// CHECK1-SAME: (%struct.SS* nonnull align 8 dereferenceable(16) [[THIS:%.*]], i32* nonnull align 4 dereferenceable(4) [[D:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK1-NEXT:    [[D_ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store i32* [[D]], i32** [[D_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK1-NEXT:    store i32 0, i32* [[A]], align 8
// CHECK1-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 1
// CHECK1-NEXT:    [[BF_LOAD:%.*]] = load i8, i8* [[B]], align 4
// CHECK1-NEXT:    [[BF_CLEAR:%.*]] = and i8 [[BF_LOAD]], -16
// CHECK1-NEXT:    store i8 [[BF_CLEAR]], i8* [[B]], align 4
// CHECK1-NEXT:    [[C:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[D_ADDR]], align 8
// CHECK1-NEXT:    store i32* [[TMP0]], i32** [[C]], align 8
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, %struct.SS*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), %struct.SS* [[THIS1]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK1-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], %struct.SS* [[THIS:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK1-NEXT:    [[A:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[B:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[C:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[_TMP3:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[_TMP4:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTLINEAR_START5:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTLINEAR_START6:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[A7:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[_TMP8:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[B9:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[C10:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[_TMP11:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[_TMP20:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[_TMP21:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[A1:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[TMP0]], i32 0, i32 0
// CHECK1-NEXT:    store i32* [[A1]], i32** [[A]], align 8
// CHECK1-NEXT:    [[C2:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[TMP0]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[C2]], align 8
// CHECK1-NEXT:    store i32* [[TMP1]], i32** [[C]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[A]], align 8
// CHECK1-NEXT:    store i32* [[TMP2]], i32** [[TMP]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[C]], align 8
// CHECK1-NEXT:    store i32* [[TMP3]], i32** [[_TMP3]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[TMP]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK1-NEXT:    store i32 [[TMP5]], i32* [[DOTLINEAR_START]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[B]], align 4
// CHECK1-NEXT:    store i32 [[TMP6]], i32* [[DOTLINEAR_START5]], align 4
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[_TMP3]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK1-NEXT:    store i32 [[TMP8]], i32* [[DOTLINEAR_START6]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[TMP9]], align 4
// CHECK1-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB1]], i32 [[TMP10]])
// CHECK1-NEXT:    store i32* [[A7]], i32** [[_TMP8]], align 8
// CHECK1-NEXT:    store i32* [[C10]], i32** [[_TMP11]], align 8
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP10]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP11]], 1
// CHECK1-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP12:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK1-NEXT:    br i1 [[CMP12]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP16]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[I]], align 4
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTLINEAR_START]], align 4
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[MUL13:%.*]] = mul nsw i32 [[TMP18]], 1
// CHECK1-NEXT:    [[ADD14:%.*]] = add nsw i32 [[TMP17]], [[MUL13]]
// CHECK1-NEXT:    store i32 [[ADD14]], i32* [[A7]], align 4
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTLINEAR_START5]], align 4
// CHECK1-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[MUL15:%.*]] = mul nsw i32 [[TMP20]], 1
// CHECK1-NEXT:    [[ADD16:%.*]] = add nsw i32 [[TMP19]], [[MUL15]]
// CHECK1-NEXT:    store i32 [[ADD16]], i32* [[B9]], align 4
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTLINEAR_START6]], align 4
// CHECK1-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[MUL17:%.*]] = mul nsw i32 [[TMP22]], 1
// CHECK1-NEXT:    [[ADD18:%.*]] = add nsw i32 [[TMP21]], [[MUL17]]
// CHECK1-NEXT:    store i32 [[ADD18]], i32* [[C10]], align 4
// CHECK1-NEXT:    [[TMP23:%.*]] = load i32*, i32** [[_TMP8]], align 8
// CHECK1-NEXT:    [[TMP24:%.*]] = load i32, i32* [[TMP23]], align 4
// CHECK1-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK1-NEXT:    store i32 [[INC]], i32* [[TMP23]], align 4
// CHECK1-NEXT:    [[TMP25:%.*]] = load i32, i32* [[B9]], align 4
// CHECK1-NEXT:    [[DEC:%.*]] = add nsw i32 [[TMP25]], -1
// CHECK1-NEXT:    store i32 [[DEC]], i32* [[B9]], align 4
// CHECK1-NEXT:    [[TMP26:%.*]] = load i32*, i32** [[_TMP11]], align 8
// CHECK1-NEXT:    [[TMP27:%.*]] = load i32, i32* [[TMP26]], align 4
// CHECK1-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP27]], 1
// CHECK1-NEXT:    store i32 [[DIV]], i32* [[TMP26]], align 4
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[ADD19:%.*]] = add nsw i32 [[TMP28]], 1
// CHECK1-NEXT:    store i32 [[ADD19]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB2]], i32 [[TMP10]])
// CHECK1-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP30:%.*]] = icmp ne i32 [[TMP29]], 0
// CHECK1-NEXT:    br i1 [[TMP30]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK1:       .omp.linear.pu:
// CHECK1-NEXT:    [[TMP31:%.*]] = load i32*, i32** [[TMP]], align 8
// CHECK1-NEXT:    store i32* [[TMP31]], i32** [[_TMP20]], align 8
// CHECK1-NEXT:    [[TMP32:%.*]] = load i32, i32* [[A7]], align 4
// CHECK1-NEXT:    [[TMP33:%.*]] = load i32*, i32** [[_TMP20]], align 8
// CHECK1-NEXT:    store i32 [[TMP32]], i32* [[TMP33]], align 4
// CHECK1-NEXT:    [[TMP34:%.*]] = load i32, i32* [[B9]], align 4
// CHECK1-NEXT:    store i32 [[TMP34]], i32* [[B]], align 4
// CHECK1-NEXT:    [[TMP35:%.*]] = load i32*, i32** [[_TMP3]], align 8
// CHECK1-NEXT:    store i32* [[TMP35]], i32** [[_TMP21]], align 8
// CHECK1-NEXT:    [[TMP36:%.*]] = load i32, i32* [[C10]], align 4
// CHECK1-NEXT:    [[TMP37:%.*]] = load i32*, i32** [[_TMP21]], align 8
// CHECK1-NEXT:    store i32 [[TMP36]], i32* [[TMP37]], align 4
// CHECK1-NEXT:    [[TMP38:%.*]] = load i32, i32* [[B]], align 4
// CHECK1-NEXT:    [[B22:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[TMP0]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP39:%.*]] = trunc i32 [[TMP38]] to i8
// CHECK1-NEXT:    [[BF_LOAD:%.*]] = load i8, i8* [[B22]], align 4
// CHECK1-NEXT:    [[BF_VALUE:%.*]] = and i8 [[TMP39]], 15
// CHECK1-NEXT:    [[BF_CLEAR:%.*]] = and i8 [[BF_LOAD]], -16
// CHECK1-NEXT:    [[BF_SET:%.*]] = or i8 [[BF_CLEAR]], [[BF_VALUE]]
// CHECK1-NEXT:    store i8 [[BF_SET]], i8* [[B22]], align 4
// CHECK1-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK1:       .omp.linear.pu.done:
// CHECK1-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB1]], i32 [[TMP10]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN1SIfEC2Ev
// CHECK1-SAME: (%struct.S* nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK1-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], %struct.S* [[THIS1]], i32 0, i32 0
// CHECK1-NEXT:    store float 0.000000e+00, float* [[F]], align 4
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ev
// CHECK1-SAME: (%struct.S.0* nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK1-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    call void @_ZN1SIiEC2Ev(%struct.S.0* nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN3SSTIiEC1Ev
// CHECK1-SAME: (%struct.SST* nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SST*, align 8
// CHECK1-NEXT:    store %struct.SST* [[THIS]], %struct.SST** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load %struct.SST*, %struct.SST** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    call void @_ZN3SSTIiEC2Ev(%struct.SST* nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK1-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32** nonnull align 8 dereferenceable(8) [[PVAR:%.*]], i32* nonnull align 4 dereferenceable(4) [[LVAR:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[PVAR_ADDR:%.*]] = alloca i32**, align 8
// CHECK1-NEXT:    [[LVAR_ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[_TMP1:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[_TMP2:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTLINEAR_START3:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[PVAR4:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[LVAR5:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[_TMP6:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[_TMP12:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32** [[PVAR]], i32*** [[PVAR_ADDR]], align 8
// CHECK1-NEXT:    store i32* [[LVAR]], i32** [[LVAR_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32**, i32*** [[PVAR_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[LVAR_ADDR]], align 8
// CHECK1-NEXT:    store i32* [[TMP1]], i32** [[TMP]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[TMP]], align 8
// CHECK1-NEXT:    store i32* [[TMP2]], i32** [[_TMP1]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[TMP0]], align 8
// CHECK1-NEXT:    store i32* [[TMP3]], i32** [[DOTLINEAR_START]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[_TMP1]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK1-NEXT:    store i32 [[TMP5]], i32* [[DOTLINEAR_START3]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[TMP6]], align 4
// CHECK1-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB1]], i32 [[TMP7]])
// CHECK1-NEXT:    store i32* [[LVAR5]], i32** [[_TMP6]], align 8
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP7]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP8]], 1
// CHECK1-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP9]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP10]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP11]], [[TMP12]]
// CHECK1-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP13]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[I]], align 4
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32*, i32** [[DOTLINEAR_START]], align 8
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[MUL8:%.*]] = mul nsw i32 [[TMP15]], 1
// CHECK1-NEXT:    [[IDX_EXT:%.*]] = sext i32 [[MUL8]] to i64
// CHECK1-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds i32, i32* [[TMP14]], i64 [[IDX_EXT]]
// CHECK1-NEXT:    store i32* [[ADD_PTR]], i32** [[PVAR4]], align 8
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTLINEAR_START3]], align 4
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[MUL9:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK1-NEXT:    [[ADD10:%.*]] = add nsw i32 [[TMP16]], [[MUL9]]
// CHECK1-NEXT:    store i32 [[ADD10]], i32* [[LVAR5]], align 4
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32*, i32** [[PVAR4]], align 8
// CHECK1-NEXT:    [[INCDEC_PTR:%.*]] = getelementptr inbounds i32, i32* [[TMP18]], i32 1
// CHECK1-NEXT:    store i32* [[INCDEC_PTR]], i32** [[PVAR4]], align 8
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32*, i32** [[_TMP6]], align 8
// CHECK1-NEXT:    [[TMP20:%.*]] = load i32, i32* [[TMP19]], align 4
// CHECK1-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP20]], 1
// CHECK1-NEXT:    store i32 [[INC]], i32* [[TMP19]], align 4
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP21]], 1
// CHECK1-NEXT:    store i32 [[ADD11]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB2]], i32 [[TMP7]])
// CHECK1-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK1-NEXT:    br i1 [[TMP23]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK1:       .omp.linear.pu:
// CHECK1-NEXT:    [[TMP24:%.*]] = load i32*, i32** [[PVAR4]], align 8
// CHECK1-NEXT:    store i32* [[TMP24]], i32** [[TMP0]], align 8
// CHECK1-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[_TMP1]], align 8
// CHECK1-NEXT:    store i32* [[TMP25]], i32** [[_TMP12]], align 8
// CHECK1-NEXT:    [[TMP26:%.*]] = load i32, i32* [[LVAR5]], align 4
// CHECK1-NEXT:    [[TMP27:%.*]] = load i32*, i32** [[_TMP12]], align 8
// CHECK1-NEXT:    store i32 [[TMP26]], i32* [[TMP27]], align 4
// CHECK1-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK1:       .omp.linear.pu.done:
// CHECK1-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB1]], i32 [[TMP7]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN1SIiED1Ev
// CHECK1-SAME: (%struct.S.0* nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK1-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    call void @_ZN1SIiED2Ev(%struct.S.0* nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR4]]
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ev
// CHECK1-SAME: (%struct.S.0* nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK1-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], %struct.S.0* [[THIS1]], i32 0, i32 0
// CHECK1-NEXT:    store i32 0, i32* [[F]], align 4
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN3SSTIiEC2Ev
// CHECK1-SAME: (%struct.SST* nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SST*, align 8
// CHECK1-NEXT:    store %struct.SST* [[THIS]], %struct.SST** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load %struct.SST*, %struct.SST** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SST:%.*]], %struct.SST* [[THIS1]], i32 0, i32 0
// CHECK1-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, %struct.SST*)* @.omp_outlined..3 to void (i32*, i32*, ...)*), %struct.SST* [[THIS1]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK1-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], %struct.SST* [[THIS:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SST*, align 8
// CHECK1-NEXT:    [[A:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[_TMP2:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[A3:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[_TMP4:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[_TMP9:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store %struct.SST* [[THIS]], %struct.SST** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load %struct.SST*, %struct.SST** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[A1:%.*]] = getelementptr inbounds [[STRUCT_SST:%.*]], %struct.SST* [[TMP0]], i32 0, i32 0
// CHECK1-NEXT:    store i32* [[A1]], i32** [[A]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[A]], align 8
// CHECK1-NEXT:    store i32* [[TMP1]], i32** [[TMP]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[TMP]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK1-NEXT:    store i32 [[TMP3]], i32* [[DOTLINEAR_START]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK1-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK1-NEXT:    store i32* [[A3]], i32** [[_TMP4]], align 8
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP5]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 1
// CHECK1-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK1-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[I]], align 4
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTLINEAR_START]], align 4
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[MUL6:%.*]] = mul nsw i32 [[TMP13]], 1
// CHECK1-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP12]], [[MUL6]]
// CHECK1-NEXT:    store i32 [[ADD7]], i32* [[A3]], align 4
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32*, i32** [[_TMP4]], align 8
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, i32* [[TMP14]], align 4
// CHECK1-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP15]], 1
// CHECK1-NEXT:    store i32 [[INC]], i32* [[TMP14]], align 4
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK1-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB2]], i32 [[TMP5]])
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP18:%.*]] = icmp ne i32 [[TMP17]], 0
// CHECK1-NEXT:    br i1 [[TMP18]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK1:       .omp.linear.pu:
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32*, i32** [[TMP]], align 8
// CHECK1-NEXT:    store i32* [[TMP19]], i32** [[_TMP9]], align 8
// CHECK1-NEXT:    [[TMP20:%.*]] = load i32, i32* [[A3]], align 4
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32*, i32** [[_TMP9]], align 8
// CHECK1-NEXT:    store i32 [[TMP20]], i32* [[TMP21]], align 4
// CHECK1-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK1:       .omp.linear.pu.done:
// CHECK1-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN1SIiED2Ev
// CHECK1-SAME: (%struct.S.0* nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK1-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN1SIfED2Ev
// CHECK1-SAME: (%struct.S* nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK1-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@main
// CHECK2-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[SS:%.*]] = alloca [[STRUCT_SS:%.*]], align 8
// CHECK2-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S:%.*]], align 4
// CHECK2-NEXT:    [[PVAR:%.*]] = alloca float*, align 8
// CHECK2-NEXT:    [[LVAR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK2-NEXT:    call void @_ZN2SSC1ERi(%struct.SS* nonnull align 8 dereferenceable(16) [[SS]], i32* nonnull align 4 dereferenceable(4) @_ZZ4mainE5sivar)
// CHECK2-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* nonnull align 4 dereferenceable(4) [[TEST]])
// CHECK2-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[TEST]], i32 0, i32 0
// CHECK2-NEXT:    store float* [[F]], float** [[PVAR]], align 8
// CHECK2-NEXT:    store i64 0, i64* [[LVAR]], align 8
// CHECK2-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3:[0-9]+]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, i64*)* @.omp_outlined. to void (i32*, i32*, ...)*), float** [[PVAR]], i64* [[LVAR]])
// CHECK2-NEXT:    [[CALL:%.*]] = call i32 @_Z5tmainIiET_v()
// CHECK2-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK2-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* nonnull align 4 dereferenceable(4) [[TEST]]) #[[ATTR4:[0-9]+]]
// CHECK2-NEXT:    [[TMP0:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK2-NEXT:    ret i32 [[TMP0]]
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN2SSC1ERi
// CHECK2-SAME: (%struct.SS* nonnull align 8 dereferenceable(16) [[THIS:%.*]], i32* nonnull align 4 dereferenceable(4) [[D:%.*]]) unnamed_addr #[[ATTR1:[0-9]+]] align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK2-NEXT:    [[D_ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK2-NEXT:    store i32* [[D]], i32** [[D_ADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[D_ADDR]], align 8
// CHECK2-NEXT:    call void @_ZN2SSC2ERi(%struct.SS* nonnull align 8 dereferenceable(16) [[THIS1]], i32* nonnull align 4 dereferenceable(4) [[TMP0]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN1SIfEC1Ev
// CHECK2-SAME: (%struct.S* nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK2-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 8
// CHECK2-NEXT:    call void @_ZN1SIfEC2Ev(%struct.S* nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK2-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 8 dereferenceable(8) [[PVAR:%.*]], i64* nonnull align 8 dereferenceable(8) [[LVAR:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[PVAR_ADDR:%.*]] = alloca float**, align 8
// CHECK2-NEXT:    [[LVAR_ADDR:%.*]] = alloca i64*, align 8
// CHECK2-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTLINEAR_START:%.*]] = alloca float*, align 8
// CHECK2-NEXT:    [[DOTLINEAR_START1:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[PVAR2:%.*]] = alloca float*, align 8
// CHECK2-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK2-NEXT:    store float** [[PVAR]], float*** [[PVAR_ADDR]], align 8
// CHECK2-NEXT:    store i64* [[LVAR]], i64** [[LVAR_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load float**, float*** [[PVAR_ADDR]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load i64*, i64** [[LVAR_ADDR]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load float*, float** [[TMP0]], align 8
// CHECK2-NEXT:    store float* [[TMP2]], float** [[DOTLINEAR_START]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = load i64, i64* [[TMP1]], align 8
// CHECK2-NEXT:    store i64 [[TMP3]], i64* [[DOTLINEAR_START1]], align 8
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK2-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP5]])
// CHECK2-NEXT:    [[DOTLVAR__VOID_ADDR:%.*]] = call i8* @__kmpc_alloc(i32 [[TMP5]], i64 8, i8* inttoptr (i64 5 to i8*))
// CHECK2-NEXT:    [[DOTLVAR__ADDR:%.*]] = bitcast i8* [[DOTLVAR__VOID_ADDR]] to i64*
// CHECK2-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP5]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK2-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 1
// CHECK2-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK2:       cond.true:
// CHECK2-NEXT:    br label [[COND_END:%.*]]
// CHECK2:       cond.false:
// CHECK2-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    br label [[COND_END]]
// CHECK2:       cond.end:
// CHECK2-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK2-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK2:       omp.inner.for.cond:
// CHECK2-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[CMP3:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK2-NEXT:    br i1 [[CMP3]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK2:       omp.inner.for.cond.cleanup:
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK2:       omp.inner.for.body:
// CHECK2-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK2-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK2-NEXT:    store i32 [[ADD]], i32* [[I]], align 4
// CHECK2-NEXT:    [[TMP12:%.*]] = load float*, float** [[DOTLINEAR_START]], align 8
// CHECK2-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[MUL4:%.*]] = mul nsw i32 [[TMP13]], 3
// CHECK2-NEXT:    [[IDX_EXT:%.*]] = sext i32 [[MUL4]] to i64
// CHECK2-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds float, float* [[TMP12]], i64 [[IDX_EXT]]
// CHECK2-NEXT:    store float* [[ADD_PTR]], float** [[PVAR2]], align 8
// CHECK2-NEXT:    [[TMP14:%.*]] = load i64, i64* [[DOTLINEAR_START1]], align 8
// CHECK2-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[MUL5:%.*]] = mul nsw i32 [[TMP15]], 3
// CHECK2-NEXT:    [[CONV:%.*]] = sext i32 [[MUL5]] to i64
// CHECK2-NEXT:    [[ADD6:%.*]] = add nsw i64 [[TMP14]], [[CONV]]
// CHECK2-NEXT:    store i64 [[ADD6]], i64* [[DOTLVAR__ADDR]], align 8
// CHECK2-NEXT:    [[TMP16:%.*]] = load float*, float** [[PVAR2]], align 8
// CHECK2-NEXT:    [[ADD_PTR7:%.*]] = getelementptr inbounds float, float* [[TMP16]], i64 3
// CHECK2-NEXT:    store float* [[ADD_PTR7]], float** [[PVAR2]], align 8
// CHECK2-NEXT:    [[TMP17:%.*]] = load i64, i64* [[DOTLVAR__ADDR]], align 8
// CHECK2-NEXT:    [[ADD8:%.*]] = add nsw i64 [[TMP17]], 3
// CHECK2-NEXT:    store i64 [[ADD8]], i64* [[DOTLVAR__ADDR]], align 8
// CHECK2-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK2:       omp.body.continue:
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK2:       omp.inner.for.inc:
// CHECK2-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK2-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK2:       omp.inner.for.end:
// CHECK2-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK2:       omp.loop.exit:
// CHECK2-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB2]], i32 [[TMP5]])
// CHECK2-NEXT:    [[TMP19:%.*]] = bitcast i64* [[DOTLVAR__ADDR]] to i8*
// CHECK2-NEXT:    call void @__kmpc_free(i32 [[TMP5]], i8* [[TMP19]], i8* inttoptr (i64 5 to i8*))
// CHECK2-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP21:%.*]] = icmp ne i32 [[TMP20]], 0
// CHECK2-NEXT:    br i1 [[TMP21]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK2:       .omp.linear.pu:
// CHECK2-NEXT:    [[TMP22:%.*]] = load float*, float** [[PVAR2]], align 8
// CHECK2-NEXT:    store float* [[TMP22]], float** [[TMP0]], align 8
// CHECK2-NEXT:    [[TMP23:%.*]] = load i64, i64* [[DOTLVAR__ADDR]], align 8
// CHECK2-NEXT:    store i64 [[TMP23]], i64* [[TMP1]], align 8
// CHECK2-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK2:       .omp.linear.pu.done:
// CHECK2-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_Z5tmainIiET_v
// CHECK2-SAME: () #[[ATTR5:[0-9]+]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S_0:%.*]], align 4
// CHECK2-NEXT:    [[SST:%.*]] = alloca [[STRUCT_SST:%.*]], align 4
// CHECK2-NEXT:    [[PVAR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[LVAR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* nonnull align 4 dereferenceable(4) [[TEST]])
// CHECK2-NEXT:    call void @_ZN3SSTIiEC1Ev(%struct.SST* nonnull align 4 dereferenceable(4) [[SST]])
// CHECK2-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[TEST]], i32 0, i32 0
// CHECK2-NEXT:    store i32* [[F]], i32** [[PVAR]], align 8
// CHECK2-NEXT:    [[F1:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[TEST]], i32 0, i32 0
// CHECK2-NEXT:    store i32* [[F1]], i32** [[LVAR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[LVAR]], align 8
// CHECK2-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32**, i32*)* @.omp_outlined..2 to void (i32*, i32*, ...)*), i32** [[PVAR]], i32* [[TMP0]])
// CHECK2-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* nonnull align 4 dereferenceable(4) [[TEST]]) #[[ATTR4]]
// CHECK2-NEXT:    ret i32 0
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN1SIfED1Ev
// CHECK2-SAME: (%struct.S* nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK2-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 8
// CHECK2-NEXT:    call void @_ZN1SIfED2Ev(%struct.S* nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR4]]
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN2SSC2ERi
// CHECK2-SAME: (%struct.SS* nonnull align 8 dereferenceable(16) [[THIS:%.*]], i32* nonnull align 4 dereferenceable(4) [[D:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK2-NEXT:    [[D_ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK2-NEXT:    store i32* [[D]], i32** [[D_ADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK2-NEXT:    store i32 0, i32* [[A]], align 8
// CHECK2-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 1
// CHECK2-NEXT:    [[BF_LOAD:%.*]] = load i8, i8* [[B]], align 4
// CHECK2-NEXT:    [[BF_CLEAR:%.*]] = and i8 [[BF_LOAD]], -16
// CHECK2-NEXT:    store i8 [[BF_CLEAR]], i8* [[B]], align 4
// CHECK2-NEXT:    [[C:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 2
// CHECK2-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[D_ADDR]], align 8
// CHECK2-NEXT:    store i32* [[TMP0]], i32** [[C]], align 8
// CHECK2-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, %struct.SS*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), %struct.SS* [[THIS1]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK2-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], %struct.SS* [[THIS:%.*]]) #[[ATTR2]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK2-NEXT:    [[A:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[B:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[C:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[TMP:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[_TMP3:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[_TMP4:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTLINEAR_START5:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTLINEAR_START6:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[A7:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[_TMP8:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[B9:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[C10:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[_TMP11:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[_TMP20:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[_TMP21:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK2-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[A1:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[TMP0]], i32 0, i32 0
// CHECK2-NEXT:    store i32* [[A1]], i32** [[A]], align 8
// CHECK2-NEXT:    [[C2:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[TMP0]], i32 0, i32 2
// CHECK2-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[C2]], align 8
// CHECK2-NEXT:    store i32* [[TMP1]], i32** [[C]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[A]], align 8
// CHECK2-NEXT:    store i32* [[TMP2]], i32** [[TMP]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[C]], align 8
// CHECK2-NEXT:    store i32* [[TMP3]], i32** [[_TMP3]], align 8
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[TMP]], align 8
// CHECK2-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK2-NEXT:    store i32 [[TMP5]], i32* [[DOTLINEAR_START]], align 4
// CHECK2-NEXT:    [[TMP6:%.*]] = load i32, i32* [[B]], align 4
// CHECK2-NEXT:    store i32 [[TMP6]], i32* [[DOTLINEAR_START5]], align 4
// CHECK2-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[_TMP3]], align 8
// CHECK2-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK2-NEXT:    store i32 [[TMP8]], i32* [[DOTLINEAR_START6]], align 4
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP9:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP10:%.*]] = load i32, i32* [[TMP9]], align 4
// CHECK2-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB1]], i32 [[TMP10]])
// CHECK2-NEXT:    store i32* [[A7]], i32** [[_TMP8]], align 8
// CHECK2-NEXT:    store i32* [[C10]], i32** [[_TMP11]], align 8
// CHECK2-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP10]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK2-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP11]], 1
// CHECK2-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK2:       cond.true:
// CHECK2-NEXT:    br label [[COND_END:%.*]]
// CHECK2:       cond.false:
// CHECK2-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    br label [[COND_END]]
// CHECK2:       cond.end:
// CHECK2-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK2-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK2:       omp.inner.for.cond:
// CHECK2-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[CMP12:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK2-NEXT:    br i1 [[CMP12]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK2:       omp.inner.for.body:
// CHECK2-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP16]], 1
// CHECK2-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK2-NEXT:    store i32 [[ADD]], i32* [[I]], align 4
// CHECK2-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTLINEAR_START]], align 4
// CHECK2-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[MUL13:%.*]] = mul nsw i32 [[TMP18]], 1
// CHECK2-NEXT:    [[ADD14:%.*]] = add nsw i32 [[TMP17]], [[MUL13]]
// CHECK2-NEXT:    store i32 [[ADD14]], i32* [[A7]], align 4
// CHECK2-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTLINEAR_START5]], align 4
// CHECK2-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[MUL15:%.*]] = mul nsw i32 [[TMP20]], 1
// CHECK2-NEXT:    [[ADD16:%.*]] = add nsw i32 [[TMP19]], [[MUL15]]
// CHECK2-NEXT:    store i32 [[ADD16]], i32* [[B9]], align 4
// CHECK2-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTLINEAR_START6]], align 4
// CHECK2-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[MUL17:%.*]] = mul nsw i32 [[TMP22]], 1
// CHECK2-NEXT:    [[ADD18:%.*]] = add nsw i32 [[TMP21]], [[MUL17]]
// CHECK2-NEXT:    store i32 [[ADD18]], i32* [[C10]], align 4
// CHECK2-NEXT:    [[TMP23:%.*]] = load i32*, i32** [[_TMP8]], align 8
// CHECK2-NEXT:    [[TMP24:%.*]] = load i32, i32* [[TMP23]], align 4
// CHECK2-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK2-NEXT:    store i32 [[INC]], i32* [[TMP23]], align 4
// CHECK2-NEXT:    [[TMP25:%.*]] = load i32, i32* [[B9]], align 4
// CHECK2-NEXT:    [[DEC:%.*]] = add nsw i32 [[TMP25]], -1
// CHECK2-NEXT:    store i32 [[DEC]], i32* [[B9]], align 4
// CHECK2-NEXT:    [[TMP26:%.*]] = load i32*, i32** [[_TMP11]], align 8
// CHECK2-NEXT:    [[TMP27:%.*]] = load i32, i32* [[TMP26]], align 4
// CHECK2-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP27]], 1
// CHECK2-NEXT:    store i32 [[DIV]], i32* [[TMP26]], align 4
// CHECK2-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK2:       omp.body.continue:
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK2:       omp.inner.for.inc:
// CHECK2-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[ADD19:%.*]] = add nsw i32 [[TMP28]], 1
// CHECK2-NEXT:    store i32 [[ADD19]], i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK2:       omp.inner.for.end:
// CHECK2-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK2:       omp.loop.exit:
// CHECK2-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB2]], i32 [[TMP10]])
// CHECK2-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP30:%.*]] = icmp ne i32 [[TMP29]], 0
// CHECK2-NEXT:    br i1 [[TMP30]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK2:       .omp.linear.pu:
// CHECK2-NEXT:    [[TMP31:%.*]] = load i32*, i32** [[TMP]], align 8
// CHECK2-NEXT:    store i32* [[TMP31]], i32** [[_TMP20]], align 8
// CHECK2-NEXT:    [[TMP32:%.*]] = load i32, i32* [[A7]], align 4
// CHECK2-NEXT:    [[TMP33:%.*]] = load i32*, i32** [[_TMP20]], align 8
// CHECK2-NEXT:    store i32 [[TMP32]], i32* [[TMP33]], align 4
// CHECK2-NEXT:    [[TMP34:%.*]] = load i32, i32* [[B9]], align 4
// CHECK2-NEXT:    store i32 [[TMP34]], i32* [[B]], align 4
// CHECK2-NEXT:    [[TMP35:%.*]] = load i32*, i32** [[_TMP3]], align 8
// CHECK2-NEXT:    store i32* [[TMP35]], i32** [[_TMP21]], align 8
// CHECK2-NEXT:    [[TMP36:%.*]] = load i32, i32* [[C10]], align 4
// CHECK2-NEXT:    [[TMP37:%.*]] = load i32*, i32** [[_TMP21]], align 8
// CHECK2-NEXT:    store i32 [[TMP36]], i32* [[TMP37]], align 4
// CHECK2-NEXT:    [[TMP38:%.*]] = load i32, i32* [[B]], align 4
// CHECK2-NEXT:    [[B22:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[TMP0]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP39:%.*]] = trunc i32 [[TMP38]] to i8
// CHECK2-NEXT:    [[BF_LOAD:%.*]] = load i8, i8* [[B22]], align 4
// CHECK2-NEXT:    [[BF_VALUE:%.*]] = and i8 [[TMP39]], 15
// CHECK2-NEXT:    [[BF_CLEAR:%.*]] = and i8 [[BF_LOAD]], -16
// CHECK2-NEXT:    [[BF_SET:%.*]] = or i8 [[BF_CLEAR]], [[BF_VALUE]]
// CHECK2-NEXT:    store i8 [[BF_SET]], i8* [[B22]], align 4
// CHECK2-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK2:       .omp.linear.pu.done:
// CHECK2-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB1]], i32 [[TMP10]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN1SIfEC2Ev
// CHECK2-SAME: (%struct.S* nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK2-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], %struct.S* [[THIS1]], i32 0, i32 0
// CHECK2-NEXT:    store float 0.000000e+00, float* [[F]], align 4
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ev
// CHECK2-SAME: (%struct.S.0* nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK2-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 8
// CHECK2-NEXT:    call void @_ZN1SIiEC2Ev(%struct.S.0* nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN3SSTIiEC1Ev
// CHECK2-SAME: (%struct.SST* nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SST*, align 8
// CHECK2-NEXT:    store %struct.SST* [[THIS]], %struct.SST** [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load %struct.SST*, %struct.SST** [[THIS_ADDR]], align 8
// CHECK2-NEXT:    call void @_ZN3SSTIiEC2Ev(%struct.SST* nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK2-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32** nonnull align 8 dereferenceable(8) [[PVAR:%.*]], i32* nonnull align 4 dereferenceable(4) [[LVAR:%.*]]) #[[ATTR2]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[PVAR_ADDR:%.*]] = alloca i32**, align 8
// CHECK2-NEXT:    [[LVAR_ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[TMP:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[_TMP1:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[_TMP2:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[DOTLINEAR_START3:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[PVAR4:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[LVAR5:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[_TMP6:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[_TMP12:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK2-NEXT:    store i32** [[PVAR]], i32*** [[PVAR_ADDR]], align 8
// CHECK2-NEXT:    store i32* [[LVAR]], i32** [[LVAR_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load i32**, i32*** [[PVAR_ADDR]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[LVAR_ADDR]], align 8
// CHECK2-NEXT:    store i32* [[TMP1]], i32** [[TMP]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[TMP]], align 8
// CHECK2-NEXT:    store i32* [[TMP2]], i32** [[_TMP1]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[TMP0]], align 8
// CHECK2-NEXT:    store i32* [[TMP3]], i32** [[DOTLINEAR_START]], align 8
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[_TMP1]], align 8
// CHECK2-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK2-NEXT:    store i32 [[TMP5]], i32* [[DOTLINEAR_START3]], align 4
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP6:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP7:%.*]] = load i32, i32* [[TMP6]], align 4
// CHECK2-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB1]], i32 [[TMP7]])
// CHECK2-NEXT:    store i32* [[LVAR5]], i32** [[_TMP6]], align 8
// CHECK2-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP7]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK2-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP8]], 1
// CHECK2-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK2:       cond.true:
// CHECK2-NEXT:    br label [[COND_END:%.*]]
// CHECK2:       cond.false:
// CHECK2-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    br label [[COND_END]]
// CHECK2:       cond.end:
// CHECK2-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP9]], [[COND_FALSE]] ]
// CHECK2-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    store i32 [[TMP10]], i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK2:       omp.inner.for.cond:
// CHECK2-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP11]], [[TMP12]]
// CHECK2-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK2:       omp.inner.for.body:
// CHECK2-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP13]], 1
// CHECK2-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK2-NEXT:    store i32 [[ADD]], i32* [[I]], align 4
// CHECK2-NEXT:    [[TMP14:%.*]] = load i32*, i32** [[DOTLINEAR_START]], align 8
// CHECK2-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[MUL8:%.*]] = mul nsw i32 [[TMP15]], 1
// CHECK2-NEXT:    [[IDX_EXT:%.*]] = sext i32 [[MUL8]] to i64
// CHECK2-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds i32, i32* [[TMP14]], i64 [[IDX_EXT]]
// CHECK2-NEXT:    store i32* [[ADD_PTR]], i32** [[PVAR4]], align 8
// CHECK2-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTLINEAR_START3]], align 4
// CHECK2-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[MUL9:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK2-NEXT:    [[ADD10:%.*]] = add nsw i32 [[TMP16]], [[MUL9]]
// CHECK2-NEXT:    store i32 [[ADD10]], i32* [[LVAR5]], align 4
// CHECK2-NEXT:    [[TMP18:%.*]] = load i32*, i32** [[PVAR4]], align 8
// CHECK2-NEXT:    [[INCDEC_PTR:%.*]] = getelementptr inbounds i32, i32* [[TMP18]], i32 1
// CHECK2-NEXT:    store i32* [[INCDEC_PTR]], i32** [[PVAR4]], align 8
// CHECK2-NEXT:    [[TMP19:%.*]] = load i32*, i32** [[_TMP6]], align 8
// CHECK2-NEXT:    [[TMP20:%.*]] = load i32, i32* [[TMP19]], align 4
// CHECK2-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP20]], 1
// CHECK2-NEXT:    store i32 [[INC]], i32* [[TMP19]], align 4
// CHECK2-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK2:       omp.body.continue:
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK2:       omp.inner.for.inc:
// CHECK2-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP21]], 1
// CHECK2-NEXT:    store i32 [[ADD11]], i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK2:       omp.inner.for.end:
// CHECK2-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK2:       omp.loop.exit:
// CHECK2-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB2]], i32 [[TMP7]])
// CHECK2-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK2-NEXT:    br i1 [[TMP23]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK2:       .omp.linear.pu:
// CHECK2-NEXT:    [[TMP24:%.*]] = load i32*, i32** [[PVAR4]], align 8
// CHECK2-NEXT:    store i32* [[TMP24]], i32** [[TMP0]], align 8
// CHECK2-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[_TMP1]], align 8
// CHECK2-NEXT:    store i32* [[TMP25]], i32** [[_TMP12]], align 8
// CHECK2-NEXT:    [[TMP26:%.*]] = load i32, i32* [[LVAR5]], align 4
// CHECK2-NEXT:    [[TMP27:%.*]] = load i32*, i32** [[_TMP12]], align 8
// CHECK2-NEXT:    store i32 [[TMP26]], i32* [[TMP27]], align 4
// CHECK2-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK2:       .omp.linear.pu.done:
// CHECK2-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB1]], i32 [[TMP7]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN1SIiED1Ev
// CHECK2-SAME: (%struct.S.0* nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK2-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 8
// CHECK2-NEXT:    call void @_ZN1SIiED2Ev(%struct.S.0* nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR4]]
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ev
// CHECK2-SAME: (%struct.S.0* nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK2-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], %struct.S.0* [[THIS1]], i32 0, i32 0
// CHECK2-NEXT:    store i32 0, i32* [[F]], align 4
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN3SSTIiEC2Ev
// CHECK2-SAME: (%struct.SST* nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SST*, align 8
// CHECK2-NEXT:    store %struct.SST* [[THIS]], %struct.SST** [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load %struct.SST*, %struct.SST** [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SST:%.*]], %struct.SST* [[THIS1]], i32 0, i32 0
// CHECK2-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK2-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, %struct.SST*)* @.omp_outlined..3 to void (i32*, i32*, ...)*), %struct.SST* [[THIS1]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK2-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], %struct.SST* [[THIS:%.*]]) #[[ATTR2]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SST*, align 8
// CHECK2-NEXT:    [[A:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[TMP:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[_TMP2:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[A3:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[_TMP4:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[_TMP9:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK2-NEXT:    store %struct.SST* [[THIS]], %struct.SST** [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load %struct.SST*, %struct.SST** [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[A1:%.*]] = getelementptr inbounds [[STRUCT_SST:%.*]], %struct.SST* [[TMP0]], i32 0, i32 0
// CHECK2-NEXT:    store i32* [[A1]], i32** [[A]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[A]], align 8
// CHECK2-NEXT:    store i32* [[TMP1]], i32** [[TMP]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[TMP]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK2-NEXT:    store i32 [[TMP3]], i32* [[DOTLINEAR_START]], align 4
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK2-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK2-NEXT:    store i32* [[A3]], i32** [[_TMP4]], align 8
// CHECK2-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP5]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK2-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 1
// CHECK2-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK2:       cond.true:
// CHECK2-NEXT:    br label [[COND_END:%.*]]
// CHECK2:       cond.false:
// CHECK2-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    br label [[COND_END]]
// CHECK2:       cond.end:
// CHECK2-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK2-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK2:       omp.inner.for.cond:
// CHECK2-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK2-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK2:       omp.inner.for.body:
// CHECK2-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK2-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK2-NEXT:    store i32 [[ADD]], i32* [[I]], align 4
// CHECK2-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTLINEAR_START]], align 4
// CHECK2-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[MUL6:%.*]] = mul nsw i32 [[TMP13]], 1
// CHECK2-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP12]], [[MUL6]]
// CHECK2-NEXT:    store i32 [[ADD7]], i32* [[A3]], align 4
// CHECK2-NEXT:    [[TMP14:%.*]] = load i32*, i32** [[_TMP4]], align 8
// CHECK2-NEXT:    [[TMP15:%.*]] = load i32, i32* [[TMP14]], align 4
// CHECK2-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP15]], 1
// CHECK2-NEXT:    store i32 [[INC]], i32* [[TMP14]], align 4
// CHECK2-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK2:       omp.body.continue:
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK2:       omp.inner.for.inc:
// CHECK2-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK2-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK2:       omp.inner.for.end:
// CHECK2-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK2:       omp.loop.exit:
// CHECK2-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB2]], i32 [[TMP5]])
// CHECK2-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP18:%.*]] = icmp ne i32 [[TMP17]], 0
// CHECK2-NEXT:    br i1 [[TMP18]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK2:       .omp.linear.pu:
// CHECK2-NEXT:    [[TMP19:%.*]] = load i32*, i32** [[TMP]], align 8
// CHECK2-NEXT:    store i32* [[TMP19]], i32** [[_TMP9]], align 8
// CHECK2-NEXT:    [[TMP20:%.*]] = load i32, i32* [[A3]], align 4
// CHECK2-NEXT:    [[TMP21:%.*]] = load i32*, i32** [[_TMP9]], align 8
// CHECK2-NEXT:    store i32 [[TMP20]], i32* [[TMP21]], align 4
// CHECK2-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK2:       .omp.linear.pu.done:
// CHECK2-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN1SIiED2Ev
// CHECK2-SAME: (%struct.S.0* nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK2-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 8
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN1SIfED2Ev
// CHECK2-SAME: (%struct.S* nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK2-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 8
// CHECK2-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@main
// CHECK3-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[SS:%.*]] = alloca [[STRUCT_SS:%.*]], align 8
// CHECK3-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON:%.*]], align 1
// CHECK3-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK3-NEXT:    call void @_ZN2SSC1ERi(%struct.SS* nonnull align 8 dereferenceable(16) [[SS]], i32* nonnull align 4 dereferenceable(4) @_ZZ4mainE5sivar)
// CHECK3-NEXT:    call void @"_ZZ4mainENK3$_0clEv"(%class.anon* nonnull align 1 dereferenceable(1) [[REF_TMP]])
// CHECK3-NEXT:    ret i32 0
//
//
// CHECK3-LABEL: define {{[^@]+}}@_ZN2SSC1ERi
// CHECK3-SAME: (%struct.SS* nonnull align 8 dereferenceable(16) [[THIS:%.*]], i32* nonnull align 4 dereferenceable(4) [[D:%.*]]) unnamed_addr #[[ATTR1:[0-9]+]] align 2 {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK3-NEXT:    [[D_ADDR:%.*]] = alloca i32*, align 8
// CHECK3-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK3-NEXT:    store i32* [[D]], i32** [[D_ADDR]], align 8
// CHECK3-NEXT:    [[THIS1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[D_ADDR]], align 8
// CHECK3-NEXT:    call void @_ZN2SSC2ERi(%struct.SS* nonnull align 8 dereferenceable(16) [[THIS1]], i32* nonnull align 4 dereferenceable(4) [[TMP0]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@_ZN2SSC2ERi
// CHECK3-SAME: (%struct.SS* nonnull align 8 dereferenceable(16) [[THIS:%.*]], i32* nonnull align 4 dereferenceable(4) [[D:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK3-NEXT:    [[D_ADDR:%.*]] = alloca i32*, align 8
// CHECK3-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK3-NEXT:    store i32* [[D]], i32** [[D_ADDR]], align 8
// CHECK3-NEXT:    [[THIS1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK3-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK3-NEXT:    store i32 0, i32* [[A]], align 8
// CHECK3-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 1
// CHECK3-NEXT:    [[BF_LOAD:%.*]] = load i8, i8* [[B]], align 4
// CHECK3-NEXT:    [[BF_CLEAR:%.*]] = and i8 [[BF_LOAD]], -16
// CHECK3-NEXT:    store i8 [[BF_CLEAR]], i8* [[B]], align 4
// CHECK3-NEXT:    [[C:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[D_ADDR]], align 8
// CHECK3-NEXT:    store i32* [[TMP0]], i32** [[C]], align 8
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3:[0-9]+]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, %struct.SS*)* @.omp_outlined. to void (i32*, i32*, ...)*), %struct.SS* [[THIS1]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK3-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], %struct.SS* [[THIS:%.*]]) #[[ATTR3:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK3-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK3-NEXT:    [[A:%.*]] = alloca i32*, align 8
// CHECK3-NEXT:    [[B:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[C:%.*]] = alloca i32*, align 8
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32*, align 8
// CHECK3-NEXT:    [[_TMP3:%.*]] = alloca i32*, align 8
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[_TMP4:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTLINEAR_START5:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTLINEAR_START6:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A7:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[_TMP8:%.*]] = alloca i32*, align 8
// CHECK3-NEXT:    [[B9:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[C10:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[_TMP11:%.*]] = alloca i32*, align 8
// CHECK3-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON_0:%.*]], align 8
// CHECK3-NEXT:    [[_TMP20:%.*]] = alloca i32*, align 8
// CHECK3-NEXT:    [[_TMP21:%.*]] = alloca i32*, align 8
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK3-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK3-NEXT:    [[TMP0:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK3-NEXT:    [[A1:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[TMP0]], i32 0, i32 0
// CHECK3-NEXT:    store i32* [[A1]], i32** [[A]], align 8
// CHECK3-NEXT:    [[C2:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[TMP0]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[C2]], align 8
// CHECK3-NEXT:    store i32* [[TMP1]], i32** [[C]], align 8
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[A]], align 8
// CHECK3-NEXT:    store i32* [[TMP2]], i32** [[TMP]], align 8
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[C]], align 8
// CHECK3-NEXT:    store i32* [[TMP3]], i32** [[_TMP3]], align 8
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[TMP]], align 8
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK3-NEXT:    store i32 [[TMP5]], i32* [[DOTLINEAR_START]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[B]], align 4
// CHECK3-NEXT:    store i32 [[TMP6]], i32* [[DOTLINEAR_START5]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[_TMP3]], align 8
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK3-NEXT:    store i32 [[TMP8]], i32* [[DOTLINEAR_START6]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[TMP9]], align 4
// CHECK3-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP10]])
// CHECK3-NEXT:    store i32* [[A7]], i32** [[_TMP8]], align 8
// CHECK3-NEXT:    store i32* [[C10]], i32** [[_TMP11]], align 8
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP10]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP11]], 1
// CHECK3-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP12:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK3-NEXT:    br i1 [[CMP12]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP16]], 1
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[I]], align 4
// CHECK3-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTLINEAR_START]], align 4
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[MUL13:%.*]] = mul nsw i32 [[TMP18]], 1
// CHECK3-NEXT:    [[ADD14:%.*]] = add nsw i32 [[TMP17]], [[MUL13]]
// CHECK3-NEXT:    store i32 [[ADD14]], i32* [[A7]], align 4
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTLINEAR_START5]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[MUL15:%.*]] = mul nsw i32 [[TMP20]], 1
// CHECK3-NEXT:    [[ADD16:%.*]] = add nsw i32 [[TMP19]], [[MUL15]]
// CHECK3-NEXT:    store i32 [[ADD16]], i32* [[B9]], align 4
// CHECK3-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTLINEAR_START6]], align 4
// CHECK3-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[MUL17:%.*]] = mul nsw i32 [[TMP22]], 1
// CHECK3-NEXT:    [[ADD18:%.*]] = add nsw i32 [[TMP21]], [[MUL17]]
// CHECK3-NEXT:    store i32 [[ADD18]], i32* [[C10]], align 4
// CHECK3-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[REF_TMP]], i32 0, i32 0
// CHECK3-NEXT:    store %struct.SS* [[TMP0]], %struct.SS** [[TMP23]], align 8
// CHECK3-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[REF_TMP]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[_TMP8]], align 8
// CHECK3-NEXT:    store i32* [[TMP25]], i32** [[TMP24]], align 8
// CHECK3-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[REF_TMP]], i32 0, i32 2
// CHECK3-NEXT:    store i32* [[B9]], i32** [[TMP26]], align 8
// CHECK3-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[REF_TMP]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP28:%.*]] = load i32*, i32** [[_TMP11]], align 8
// CHECK3-NEXT:    store i32* [[TMP28]], i32** [[TMP27]], align 8
// CHECK3-NEXT:    call void @_ZZN2SSC1ERiENKUlvE_clEv(%class.anon.0* nonnull align 8 dereferenceable(32) [[REF_TMP]])
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[ADD19:%.*]] = add nsw i32 [[TMP29]], 1
// CHECK3-NEXT:    store i32 [[ADD19]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB2]], i32 [[TMP10]])
// CHECK3-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP31:%.*]] = icmp ne i32 [[TMP30]], 0
// CHECK3-NEXT:    br i1 [[TMP31]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK3:       .omp.linear.pu:
// CHECK3-NEXT:    [[TMP32:%.*]] = load i32*, i32** [[TMP]], align 8
// CHECK3-NEXT:    store i32* [[TMP32]], i32** [[_TMP20]], align 8
// CHECK3-NEXT:    [[TMP33:%.*]] = load i32, i32* [[A7]], align 4
// CHECK3-NEXT:    [[TMP34:%.*]] = load i32*, i32** [[_TMP20]], align 8
// CHECK3-NEXT:    store i32 [[TMP33]], i32* [[TMP34]], align 4
// CHECK3-NEXT:    [[TMP35:%.*]] = load i32, i32* [[B9]], align 4
// CHECK3-NEXT:    store i32 [[TMP35]], i32* [[B]], align 4
// CHECK3-NEXT:    [[TMP36:%.*]] = load i32*, i32** [[_TMP3]], align 8
// CHECK3-NEXT:    store i32* [[TMP36]], i32** [[_TMP21]], align 8
// CHECK3-NEXT:    [[TMP37:%.*]] = load i32, i32* [[C10]], align 4
// CHECK3-NEXT:    [[TMP38:%.*]] = load i32*, i32** [[_TMP21]], align 8
// CHECK3-NEXT:    store i32 [[TMP37]], i32* [[TMP38]], align 4
// CHECK3-NEXT:    [[TMP39:%.*]] = load i32, i32* [[B]], align 4
// CHECK3-NEXT:    [[B22:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[TMP0]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP40:%.*]] = trunc i32 [[TMP39]] to i8
// CHECK3-NEXT:    [[BF_LOAD:%.*]] = load i8, i8* [[B22]], align 4
// CHECK3-NEXT:    [[BF_VALUE:%.*]] = and i8 [[TMP40]], 15
// CHECK3-NEXT:    [[BF_CLEAR:%.*]] = and i8 [[BF_LOAD]], -16
// CHECK3-NEXT:    [[BF_SET:%.*]] = or i8 [[BF_CLEAR]], [[BF_VALUE]]
// CHECK3-NEXT:    store i8 [[BF_SET]], i8* [[B22]], align 4
// CHECK3-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK3:       .omp.linear.pu.done:
// CHECK3-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB1]], i32 [[TMP10]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@_ZZN2SSC1ERiENKUlvE_clEv
// CHECK3-SAME: (%class.anon.0* nonnull align 8 dereferenceable(32) [[THIS:%.*]]) #[[ATTR2:[0-9]+]] align 2 {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[THIS_ADDR:%.*]] = alloca %class.anon.0*, align 8
// CHECK3-NEXT:    store %class.anon.0* [[THIS]], %class.anon.0** [[THIS_ADDR]], align 8
// CHECK3-NEXT:    [[THIS1:%.*]] = load %class.anon.0*, %class.anon.0** [[THIS_ADDR]], align 8
// CHECK3-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [[CLASS_ANON_0:%.*]], %class.anon.0* [[THIS1]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP1:%.*]] = load %struct.SS*, %struct.SS** [[TMP0]], align 8
// CHECK3-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[THIS1]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[TMP2]], align 8
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP3]], align 4
// CHECK3-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP4]], 1
// CHECK3-NEXT:    store i32 [[INC]], i32* [[TMP3]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[THIS1]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32*, i32** [[TMP5]], align 8
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[TMP6]], align 4
// CHECK3-NEXT:    [[DEC:%.*]] = add nsw i32 [[TMP7]], -1
// CHECK3-NEXT:    store i32 [[DEC]], i32* [[TMP6]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[THIS1]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32*, i32** [[TMP8]], align 8
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[TMP9]], align 4
// CHECK3-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP10]], 1
// CHECK3-NEXT:    store i32 [[DIV]], i32* [[TMP9]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[THIS1]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32*, i32** [[TMP11]], align 8
// CHECK3-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[THIS1]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32*, i32** [[TMP13]], align 8
// CHECK3-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[THIS1]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32*, i32** [[TMP15]], align 8
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, %struct.SS*, i32*, i32*, i32*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), %struct.SS* [[TMP1]], i32* [[TMP12]], i32* [[TMP14]], i32* [[TMP16]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK3-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], %struct.SS* [[THIS:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]], i32* nonnull align 4 dereferenceable(4) [[B:%.*]], i32* nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR3]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK3-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca i32*, align 8
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca i32*, align 8
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32*, align 8
// CHECK3-NEXT:    [[_TMP1:%.*]] = alloca i32*, align 8
// CHECK3-NEXT:    [[_TMP2:%.*]] = alloca i32*, align 8
// CHECK3-NEXT:    [[_TMP3:%.*]] = alloca i32*, align 8
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[_TMP4:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTLINEAR_START5:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTLINEAR_START6:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A7:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[_TMP8:%.*]] = alloca i32*, align 8
// CHECK3-NEXT:    [[B9:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[C10:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[_TMP11:%.*]] = alloca i32*, align 8
// CHECK3-NEXT:    [[_TMP20:%.*]] = alloca i32*, align 8
// CHECK3-NEXT:    [[_TMP21:%.*]] = alloca i32*, align 8
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK3-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK3-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK3-NEXT:    store i32* [[B]], i32** [[B_ADDR]], align 8
// CHECK3-NEXT:    store i32* [[C]], i32** [[C_ADDR]], align 8
// CHECK3-NEXT:    [[TMP0:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[A_ADDR]], align 8
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[B_ADDR]], align 8
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[C_ADDR]], align 8
// CHECK3-NEXT:    store i32* [[TMP1]], i32** [[TMP]], align 8
// CHECK3-NEXT:    store i32* [[TMP3]], i32** [[_TMP1]], align 8
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[TMP]], align 8
// CHECK3-NEXT:    store i32* [[TMP4]], i32** [[_TMP2]], align 8
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32*, i32** [[_TMP1]], align 8
// CHECK3-NEXT:    store i32* [[TMP5]], i32** [[_TMP3]], align 8
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32*, i32** [[_TMP2]], align 8
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[TMP6]], align 4
// CHECK3-NEXT:    store i32 [[TMP7]], i32* [[DOTLINEAR_START]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK3-NEXT:    store i32 [[TMP8]], i32* [[DOTLINEAR_START5]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32*, i32** [[_TMP3]], align 8
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[TMP9]], align 4
// CHECK3-NEXT:    store i32 [[TMP10]], i32* [[DOTLINEAR_START6]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[TMP11]], align 4
// CHECK3-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB1]], i32 [[TMP12]])
// CHECK3-NEXT:    store i32* [[A7]], i32** [[_TMP8]], align 8
// CHECK3-NEXT:    store i32* [[C10]], i32** [[_TMP11]], align 8
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP12]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP13]], 1
// CHECK3-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP14]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP15]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP12:%.*]] = icmp sle i32 [[TMP16]], [[TMP17]]
// CHECK3-NEXT:    br i1 [[CMP12]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP18]], 1
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[I]], align 4
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTLINEAR_START]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[MUL13:%.*]] = mul nsw i32 [[TMP20]], 1
// CHECK3-NEXT:    [[ADD14:%.*]] = add nsw i32 [[TMP19]], [[MUL13]]
// CHECK3-NEXT:    store i32 [[ADD14]], i32* [[A7]], align 4
// CHECK3-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTLINEAR_START5]], align 4
// CHECK3-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[MUL15:%.*]] = mul nsw i32 [[TMP22]], 1
// CHECK3-NEXT:    [[ADD16:%.*]] = add nsw i32 [[TMP21]], [[MUL15]]
// CHECK3-NEXT:    store i32 [[ADD16]], i32* [[B9]], align 4
// CHECK3-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTLINEAR_START6]], align 4
// CHECK3-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[MUL17:%.*]] = mul nsw i32 [[TMP24]], 1
// CHECK3-NEXT:    [[ADD18:%.*]] = add nsw i32 [[TMP23]], [[MUL17]]
// CHECK3-NEXT:    store i32 [[ADD18]], i32* [[C10]], align 4
// CHECK3-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[_TMP8]], align 8
// CHECK3-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK3-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP26]], 1
// CHECK3-NEXT:    store i32 [[INC]], i32* [[TMP25]], align 4
// CHECK3-NEXT:    [[TMP27:%.*]] = load i32, i32* [[B9]], align 4
// CHECK3-NEXT:    [[DEC:%.*]] = add nsw i32 [[TMP27]], -1
// CHECK3-NEXT:    store i32 [[DEC]], i32* [[B9]], align 4
// CHECK3-NEXT:    [[TMP28:%.*]] = load i32*, i32** [[_TMP11]], align 8
// CHECK3-NEXT:    [[TMP29:%.*]] = load i32, i32* [[TMP28]], align 4
// CHECK3-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP29]], 1
// CHECK3-NEXT:    store i32 [[DIV]], i32* [[TMP28]], align 4
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[ADD19:%.*]] = add nsw i32 [[TMP30]], 1
// CHECK3-NEXT:    store i32 [[ADD19]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB2]], i32 [[TMP12]])
// CHECK3-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP32:%.*]] = icmp ne i32 [[TMP31]], 0
// CHECK3-NEXT:    br i1 [[TMP32]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK3:       .omp.linear.pu:
// CHECK3-NEXT:    [[TMP33:%.*]] = load i32*, i32** [[_TMP2]], align 8
// CHECK3-NEXT:    store i32* [[TMP33]], i32** [[_TMP20]], align 8
// CHECK3-NEXT:    [[TMP34:%.*]] = load i32, i32* [[A7]], align 4
// CHECK3-NEXT:    [[TMP35:%.*]] = load i32*, i32** [[_TMP20]], align 8
// CHECK3-NEXT:    store i32 [[TMP34]], i32* [[TMP35]], align 4
// CHECK3-NEXT:    [[TMP36:%.*]] = load i32, i32* [[B9]], align 4
// CHECK3-NEXT:    store i32 [[TMP36]], i32* [[TMP2]], align 4
// CHECK3-NEXT:    [[TMP37:%.*]] = load i32*, i32** [[_TMP3]], align 8
// CHECK3-NEXT:    store i32* [[TMP37]], i32** [[_TMP21]], align 8
// CHECK3-NEXT:    [[TMP38:%.*]] = load i32, i32* [[C10]], align 4
// CHECK3-NEXT:    [[TMP39:%.*]] = load i32*, i32** [[_TMP21]], align 8
// CHECK3-NEXT:    store i32 [[TMP38]], i32* [[TMP39]], align 4
// CHECK3-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK3:       .omp.linear.pu.done:
// CHECK3-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB1]], i32 [[TMP12]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK3-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]]) #[[ATTR3]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32*, align 8
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTLINEAR_START2:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[G:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[G1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[_TMP3:%.*]] = alloca i32*, align 8
// CHECK3-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON_1:%.*]], align 8
// CHECK3-NEXT:    [[_TMP12:%.*]] = alloca i32*, align 8
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32*, i32** @g1, align 8
// CHECK3-NEXT:    store i32* [[TMP0]], i32** [[TMP]], align 8
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* @g, align 4
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[DOTLINEAR_START]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* @g, align 4
// CHECK3-NEXT:    store i32 [[TMP2]], i32* [[DOTLINEAR_START2]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP3]], align 4
// CHECK3-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB1]], i32 [[TMP4]])
// CHECK3-NEXT:    store i32* [[G1]], i32** [[_TMP3]], align 8
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP4]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP5]], 1
// CHECK3-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP6]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP4:%.*]] = icmp sle i32 [[TMP8]], [[TMP9]]
// CHECK3-NEXT:    br i1 [[CMP4]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP10]], 1
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[I]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTLINEAR_START]], align 4
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[MUL5:%.*]] = mul nsw i32 [[TMP12]], 5
// CHECK3-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP11]], [[MUL5]]
// CHECK3-NEXT:    store i32 [[ADD6]], i32* [[G]], align 4
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTLINEAR_START2]], align 4
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[MUL7:%.*]] = mul nsw i32 [[TMP14]], 5
// CHECK3-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP13]], [[MUL7]]
// CHECK3-NEXT:    store i32 [[ADD8]], i32* [[G1]], align 4
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, i32* [[G]], align 4
// CHECK3-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP15]], 5
// CHECK3-NEXT:    store i32 [[ADD9]], i32* [[G]], align 4
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32*, i32** [[_TMP3]], align 8
// CHECK3-NEXT:    [[TMP17:%.*]] = load volatile i32, i32* [[TMP16]], align 4
// CHECK3-NEXT:    [[ADD10:%.*]] = add nsw i32 [[TMP17]], 5
// CHECK3-NEXT:    store volatile i32 [[ADD10]], i32* [[TMP16]], align 4
// CHECK3-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], %class.anon.1* [[REF_TMP]], i32 0, i32 0
// CHECK3-NEXT:    store i32* [[G]], i32** [[TMP18]], align 8
// CHECK3-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], %class.anon.1* [[REF_TMP]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP20:%.*]] = load i32*, i32** [[_TMP3]], align 8
// CHECK3-NEXT:    store i32* [[TMP20]], i32** [[TMP19]], align 8
// CHECK3-NEXT:    call void @"_ZZZ4mainENK3$_0clEvENKUlvE_clEv"(%class.anon.1* nonnull align 8 dereferenceable(16) [[REF_TMP]])
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP21]], 1
// CHECK3-NEXT:    store i32 [[ADD11]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB2]], i32 [[TMP4]])
// CHECK3-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK3-NEXT:    br i1 [[TMP23]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK3:       .omp.linear.pu:
// CHECK3-NEXT:    [[TMP24:%.*]] = load i32, i32* [[G]], align 4
// CHECK3-NEXT:    store i32 [[TMP24]], i32* @g, align 4
// CHECK3-NEXT:    [[TMP25:%.*]] = load i32*, i32** @g1, align 8
// CHECK3-NEXT:    store i32* [[TMP25]], i32** [[_TMP12]], align 8
// CHECK3-NEXT:    [[TMP26:%.*]] = load i32, i32* [[G1]], align 4
// CHECK3-NEXT:    [[TMP27:%.*]] = load i32*, i32** [[_TMP12]], align 8
// CHECK3-NEXT:    store volatile i32 [[TMP26]], i32* [[TMP27]], align 4
// CHECK3-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK3:       .omp.linear.pu.done:
// CHECK3-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB1]], i32 [[TMP4]])
// CHECK3-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@main
// CHECK4-SAME: () #[[ATTR1:[0-9]+]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[SS:%.*]] = alloca [[STRUCT_SS:%.*]], align 8
// CHECK4-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK4-NEXT:    call void @_ZN2SSC1ERi(%struct.SS* nonnull align 8 dereferenceable(16) [[SS]], i32* nonnull align 4 dereferenceable(4) @_ZZ4mainE5sivar)
// CHECK4-NEXT:    [[TMP0:%.*]] = load i8*, i8** getelementptr inbounds ([[STRUCT___BLOCK_LITERAL_GENERIC:%.*]], %struct.__block_literal_generic* bitcast ({ i8**, i32, i32, i8*, %struct.__block_descriptor* }* @__block_literal_global to %struct.__block_literal_generic*), i32 0, i32 3), align 8
// CHECK4-NEXT:    [[TMP1:%.*]] = bitcast i8* [[TMP0]] to void (i8*)*
// CHECK4-NEXT:    call void [[TMP1]](i8* bitcast ({ i8**, i32, i32, i8*, %struct.__block_descriptor* }* @__block_literal_global to i8*))
// CHECK4-NEXT:    ret i32 0
//
//
// CHECK4-LABEL: define {{[^@]+}}@_ZN2SSC1ERi
// CHECK4-SAME: (%struct.SS* nonnull align 8 dereferenceable(16) [[THIS:%.*]], i32* nonnull align 4 dereferenceable(4) [[D:%.*]]) unnamed_addr #[[ATTR2:[0-9]+]] align 2 {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK4-NEXT:    [[D_ADDR:%.*]] = alloca i32*, align 8
// CHECK4-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK4-NEXT:    store i32* [[D]], i32** [[D_ADDR]], align 8
// CHECK4-NEXT:    [[THIS1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK4-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[D_ADDR]], align 8
// CHECK4-NEXT:    call void @_ZN2SSC2ERi(%struct.SS* nonnull align 8 dereferenceable(16) [[THIS1]], i32* nonnull align 4 dereferenceable(4) [[TMP0]])
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@__main_block_invoke
// CHECK4-SAME: (i8* [[DOTBLOCK_DESCRIPTOR:%.*]]) #[[ATTR2]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTBLOCK_DESCRIPTOR_ADDR:%.*]] = alloca i8*, align 8
// CHECK4-NEXT:    [[BLOCK_ADDR:%.*]] = alloca <{ i8*, i32, i32, i8*, %struct.__block_descriptor* }>*, align 8
// CHECK4-NEXT:    store i8* [[DOTBLOCK_DESCRIPTOR]], i8** [[DOTBLOCK_DESCRIPTOR_ADDR]], align 8
// CHECK4-NEXT:    [[BLOCK:%.*]] = bitcast i8* [[DOTBLOCK_DESCRIPTOR]] to <{ i8*, i32, i32, i8*, %struct.__block_descriptor* }>*
// CHECK4-NEXT:    store <{ i8*, i32, i32, i8*, %struct.__block_descriptor* }>* [[BLOCK]], <{ i8*, i32, i32, i8*, %struct.__block_descriptor* }>** [[BLOCK_ADDR]], align 8
// CHECK4-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3:[0-9]+]], i32 0, void (i32*, i32*, ...)* bitcast (void (i32*, i32*)* @.omp_outlined. to void (i32*, i32*, ...)*))
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK4-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]]) #[[ATTR3:[0-9]+]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK4-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK4-NEXT:    [[TMP:%.*]] = alloca i32*, align 8
// CHECK4-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTLINEAR_START2:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[G:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[G1:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[_TMP3:%.*]] = alloca i32*, align 8
// CHECK4-NEXT:    [[BLOCK:%.*]] = alloca <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, i32*, i32 }>, align 8
// CHECK4-NEXT:    [[_TMP13:%.*]] = alloca i32*, align 8
// CHECK4-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK4-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK4-NEXT:    [[TMP0:%.*]] = load i32*, i32** @g1, align 8
// CHECK4-NEXT:    store i32* [[TMP0]], i32** [[TMP]], align 8
// CHECK4-NEXT:    [[TMP1:%.*]] = load i32, i32* @g, align 4
// CHECK4-NEXT:    store i32 [[TMP1]], i32* [[DOTLINEAR_START]], align 4
// CHECK4-NEXT:    [[TMP2:%.*]] = load i32, i32* @g, align 4
// CHECK4-NEXT:    store i32 [[TMP2]], i32* [[DOTLINEAR_START2]], align 4
// CHECK4-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK4-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK4-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK4-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP3]], align 4
// CHECK4-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP4]])
// CHECK4-NEXT:    store i32* [[G1]], i32** [[_TMP3]], align 8
// CHECK4-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP4]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK4-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP5]], 1
// CHECK4-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK4:       cond.true:
// CHECK4-NEXT:    br label [[COND_END:%.*]]
// CHECK4:       cond.false:
// CHECK4-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    br label [[COND_END]]
// CHECK4:       cond.end:
// CHECK4-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP6]], [[COND_FALSE]] ]
// CHECK4-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK4-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK4:       omp.inner.for.cond:
// CHECK4-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[CMP4:%.*]] = icmp sle i32 [[TMP8]], [[TMP9]]
// CHECK4-NEXT:    br i1 [[CMP4]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK4:       omp.inner.for.body:
// CHECK4-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP10]], 1
// CHECK4-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK4-NEXT:    store i32 [[ADD]], i32* [[I]], align 4
// CHECK4-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTLINEAR_START]], align 4
// CHECK4-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[MUL5:%.*]] = mul nsw i32 [[TMP12]], 5
// CHECK4-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP11]], [[MUL5]]
// CHECK4-NEXT:    store i32 [[ADD6]], i32* [[G]], align 4
// CHECK4-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTLINEAR_START2]], align 4
// CHECK4-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[MUL7:%.*]] = mul nsw i32 [[TMP14]], 5
// CHECK4-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP13]], [[MUL7]]
// CHECK4-NEXT:    store i32 [[ADD8]], i32* [[G1]], align 4
// CHECK4-NEXT:    [[TMP15:%.*]] = load i32, i32* [[G]], align 4
// CHECK4-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP15]], 5
// CHECK4-NEXT:    store i32 [[ADD9]], i32* [[G]], align 4
// CHECK4-NEXT:    [[TMP16:%.*]] = load i32*, i32** [[_TMP3]], align 8
// CHECK4-NEXT:    [[TMP17:%.*]] = load volatile i32, i32* [[TMP16]], align 4
// CHECK4-NEXT:    [[ADD10:%.*]] = add nsw i32 [[TMP17]], 5
// CHECK4-NEXT:    store volatile i32 [[ADD10]], i32* [[TMP16]], align 4
// CHECK4-NEXT:    store i32 1, i32* [[G]], align 4
// CHECK4-NEXT:    [[TMP18:%.*]] = load i32*, i32** [[_TMP3]], align 8
// CHECK4-NEXT:    store volatile i32 5, i32* [[TMP18]], align 4
// CHECK4-NEXT:    [[BLOCK_ISA:%.*]] = getelementptr inbounds <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, i32*, i32 }>, <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, i32*, i32 }>* [[BLOCK]], i32 0, i32 0
// CHECK4-NEXT:    store i8* bitcast (i8** @_NSConcreteStackBlock to i8*), i8** [[BLOCK_ISA]], align 8
// CHECK4-NEXT:    [[BLOCK_FLAGS:%.*]] = getelementptr inbounds <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, i32*, i32 }>, <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, i32*, i32 }>* [[BLOCK]], i32 0, i32 1
// CHECK4-NEXT:    store i32 1073741824, i32* [[BLOCK_FLAGS]], align 8
// CHECK4-NEXT:    [[BLOCK_RESERVED:%.*]] = getelementptr inbounds <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, i32*, i32 }>, <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, i32*, i32 }>* [[BLOCK]], i32 0, i32 2
// CHECK4-NEXT:    store i32 0, i32* [[BLOCK_RESERVED]], align 4
// CHECK4-NEXT:    [[BLOCK_INVOKE:%.*]] = getelementptr inbounds <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, i32*, i32 }>, <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, i32*, i32 }>* [[BLOCK]], i32 0, i32 3
// CHECK4-NEXT:    store i8* bitcast (void (i8*)* @g1_block_invoke to i8*), i8** [[BLOCK_INVOKE]], align 8
// CHECK4-NEXT:    [[BLOCK_DESCRIPTOR:%.*]] = getelementptr inbounds <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, i32*, i32 }>, <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, i32*, i32 }>* [[BLOCK]], i32 0, i32 4
// CHECK4-NEXT:    store %struct.__block_descriptor* bitcast ({ i64, i64, i8*, i8* }* @__block_descriptor_tmp.1 to %struct.__block_descriptor*), %struct.__block_descriptor** [[BLOCK_DESCRIPTOR]], align 8
// CHECK4-NEXT:    [[BLOCK_CAPTURED:%.*]] = getelementptr inbounds <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, i32*, i32 }>, <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, i32*, i32 }>* [[BLOCK]], i32 0, i32 6
// CHECK4-NEXT:    [[TMP19:%.*]] = load volatile i32, i32* [[G]], align 4
// CHECK4-NEXT:    store volatile i32 [[TMP19]], i32* [[BLOCK_CAPTURED]], align 8
// CHECK4-NEXT:    [[BLOCK_CAPTURED11:%.*]] = getelementptr inbounds <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, i32*, i32 }>, <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, i32*, i32 }>* [[BLOCK]], i32 0, i32 5
// CHECK4-NEXT:    [[TMP20:%.*]] = load i32*, i32** [[_TMP3]], align 8
// CHECK4-NEXT:    store i32* [[TMP20]], i32** [[BLOCK_CAPTURED11]], align 8
// CHECK4-NEXT:    [[TMP21:%.*]] = bitcast <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, i32*, i32 }>* [[BLOCK]] to void ()*
// CHECK4-NEXT:    [[BLOCK_LITERAL:%.*]] = bitcast void ()* [[TMP21]] to %struct.__block_literal_generic*
// CHECK4-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [[STRUCT___BLOCK_LITERAL_GENERIC:%.*]], %struct.__block_literal_generic* [[BLOCK_LITERAL]], i32 0, i32 3
// CHECK4-NEXT:    [[TMP23:%.*]] = bitcast %struct.__block_literal_generic* [[BLOCK_LITERAL]] to i8*
// CHECK4-NEXT:    [[TMP24:%.*]] = load i8*, i8** [[TMP22]], align 8
// CHECK4-NEXT:    [[TMP25:%.*]] = bitcast i8* [[TMP24]] to void (i8*)*
// CHECK4-NEXT:    call void [[TMP25]](i8* [[TMP23]])
// CHECK4-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK4:       omp.body.continue:
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK4:       omp.inner.for.inc:
// CHECK4-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP26]], 1
// CHECK4-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK4:       omp.inner.for.end:
// CHECK4-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK4:       omp.loop.exit:
// CHECK4-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB2]], i32 [[TMP4]])
// CHECK4-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP28:%.*]] = icmp ne i32 [[TMP27]], 0
// CHECK4-NEXT:    br i1 [[TMP28]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK4:       .omp.linear.pu:
// CHECK4-NEXT:    [[TMP29:%.*]] = load i32, i32* [[G]], align 4
// CHECK4-NEXT:    store i32 [[TMP29]], i32* @g, align 4
// CHECK4-NEXT:    [[TMP30:%.*]] = load i32*, i32** @g1, align 8
// CHECK4-NEXT:    store i32* [[TMP30]], i32** [[_TMP13]], align 8
// CHECK4-NEXT:    [[TMP31:%.*]] = load i32, i32* [[G1]], align 4
// CHECK4-NEXT:    [[TMP32:%.*]] = load i32*, i32** [[_TMP13]], align 8
// CHECK4-NEXT:    store volatile i32 [[TMP31]], i32* [[TMP32]], align 4
// CHECK4-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK4:       .omp.linear.pu.done:
// CHECK4-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB1]], i32 [[TMP4]])
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@g1_block_invoke
// CHECK4-SAME: (i8* [[DOTBLOCK_DESCRIPTOR:%.*]]) #[[ATTR2]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTBLOCK_DESCRIPTOR_ADDR:%.*]] = alloca i8*, align 8
// CHECK4-NEXT:    [[BLOCK_ADDR:%.*]] = alloca <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, i32*, i32 }>*, align 8
// CHECK4-NEXT:    store i8* [[DOTBLOCK_DESCRIPTOR]], i8** [[DOTBLOCK_DESCRIPTOR_ADDR]], align 8
// CHECK4-NEXT:    [[BLOCK:%.*]] = bitcast i8* [[DOTBLOCK_DESCRIPTOR]] to <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, i32*, i32 }>*
// CHECK4-NEXT:    store <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, i32*, i32 }>* [[BLOCK]], <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, i32*, i32 }>** [[BLOCK_ADDR]], align 8
// CHECK4-NEXT:    [[BLOCK_CAPTURE_ADDR:%.*]] = getelementptr inbounds <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, i32*, i32 }>, <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, i32*, i32 }>* [[BLOCK]], i32 0, i32 6
// CHECK4-NEXT:    store i32 2, i32* [[BLOCK_CAPTURE_ADDR]], align 8
// CHECK4-NEXT:    [[BLOCK_CAPTURE_ADDR1:%.*]] = getelementptr inbounds <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, i32*, i32 }>, <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, i32*, i32 }>* [[BLOCK]], i32 0, i32 5
// CHECK4-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[BLOCK_CAPTURE_ADDR1]], align 8
// CHECK4-NEXT:    store i32 2, i32* [[TMP0]], align 4
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@_ZN2SSC2ERi
// CHECK4-SAME: (%struct.SS* nonnull align 8 dereferenceable(16) [[THIS:%.*]], i32* nonnull align 4 dereferenceable(4) [[D:%.*]]) unnamed_addr #[[ATTR2]] align 2 {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK4-NEXT:    [[D_ADDR:%.*]] = alloca i32*, align 8
// CHECK4-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK4-NEXT:    store i32* [[D]], i32** [[D_ADDR]], align 8
// CHECK4-NEXT:    [[THIS1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK4-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK4-NEXT:    store i32 0, i32* [[A]], align 8
// CHECK4-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 1
// CHECK4-NEXT:    [[BF_LOAD:%.*]] = load i8, i8* [[B]], align 4
// CHECK4-NEXT:    [[BF_CLEAR:%.*]] = and i8 [[BF_LOAD]], -16
// CHECK4-NEXT:    store i8 [[BF_CLEAR]], i8* [[B]], align 4
// CHECK4-NEXT:    [[C:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 2
// CHECK4-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[D_ADDR]], align 8
// CHECK4-NEXT:    store i32* [[TMP0]], i32** [[C]], align 8
// CHECK4-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, %struct.SS*)* @.omp_outlined..2 to void (i32*, i32*, ...)*), %struct.SS* [[THIS1]])
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK4-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], %struct.SS* [[THIS:%.*]]) #[[ATTR3]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK4-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK4-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK4-NEXT:    [[A:%.*]] = alloca i32*, align 8
// CHECK4-NEXT:    [[B:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[C:%.*]] = alloca i32*, align 8
// CHECK4-NEXT:    [[TMP:%.*]] = alloca i32*, align 8
// CHECK4-NEXT:    [[_TMP3:%.*]] = alloca i32*, align 8
// CHECK4-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[_TMP4:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTLINEAR_START5:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTLINEAR_START6:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[A7:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[_TMP8:%.*]] = alloca i32*, align 8
// CHECK4-NEXT:    [[B9:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[C10:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[_TMP11:%.*]] = alloca i32*, align 8
// CHECK4-NEXT:    [[BLOCK:%.*]] = alloca <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>, align 8
// CHECK4-NEXT:    [[_TMP22:%.*]] = alloca i32*, align 8
// CHECK4-NEXT:    [[_TMP23:%.*]] = alloca i32*, align 8
// CHECK4-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK4-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK4-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK4-NEXT:    [[TMP0:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK4-NEXT:    [[A1:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[TMP0]], i32 0, i32 0
// CHECK4-NEXT:    store i32* [[A1]], i32** [[A]], align 8
// CHECK4-NEXT:    [[C2:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[TMP0]], i32 0, i32 2
// CHECK4-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[C2]], align 8
// CHECK4-NEXT:    store i32* [[TMP1]], i32** [[C]], align 8
// CHECK4-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[A]], align 8
// CHECK4-NEXT:    store i32* [[TMP2]], i32** [[TMP]], align 8
// CHECK4-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[C]], align 8
// CHECK4-NEXT:    store i32* [[TMP3]], i32** [[_TMP3]], align 8
// CHECK4-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[TMP]], align 8
// CHECK4-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK4-NEXT:    store i32 [[TMP5]], i32* [[DOTLINEAR_START]], align 4
// CHECK4-NEXT:    [[TMP6:%.*]] = load i32, i32* [[B]], align 4
// CHECK4-NEXT:    store i32 [[TMP6]], i32* [[DOTLINEAR_START5]], align 4
// CHECK4-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[_TMP3]], align 8
// CHECK4-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK4-NEXT:    store i32 [[TMP8]], i32* [[DOTLINEAR_START6]], align 4
// CHECK4-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK4-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK4-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP9:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK4-NEXT:    [[TMP10:%.*]] = load i32, i32* [[TMP9]], align 4
// CHECK4-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB1]], i32 [[TMP10]])
// CHECK4-NEXT:    store i32* [[A7]], i32** [[_TMP8]], align 8
// CHECK4-NEXT:    store i32* [[C10]], i32** [[_TMP11]], align 8
// CHECK4-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP10]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK4-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP11]], 1
// CHECK4-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK4:       cond.true:
// CHECK4-NEXT:    br label [[COND_END:%.*]]
// CHECK4:       cond.false:
// CHECK4-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    br label [[COND_END]]
// CHECK4:       cond.end:
// CHECK4-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK4-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK4-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK4:       omp.inner.for.cond:
// CHECK4-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[CMP12:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK4-NEXT:    br i1 [[CMP12]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK4:       omp.inner.for.body:
// CHECK4-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP16]], 1
// CHECK4-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK4-NEXT:    store i32 [[ADD]], i32* [[I]], align 4
// CHECK4-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTLINEAR_START]], align 4
// CHECK4-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[MUL13:%.*]] = mul nsw i32 [[TMP18]], 1
// CHECK4-NEXT:    [[ADD14:%.*]] = add nsw i32 [[TMP17]], [[MUL13]]
// CHECK4-NEXT:    store i32 [[ADD14]], i32* [[A7]], align 4
// CHECK4-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTLINEAR_START5]], align 4
// CHECK4-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[MUL15:%.*]] = mul nsw i32 [[TMP20]], 1
// CHECK4-NEXT:    [[ADD16:%.*]] = add nsw i32 [[TMP19]], [[MUL15]]
// CHECK4-NEXT:    store i32 [[ADD16]], i32* [[B9]], align 4
// CHECK4-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTLINEAR_START6]], align 4
// CHECK4-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[MUL17:%.*]] = mul nsw i32 [[TMP22]], 1
// CHECK4-NEXT:    [[ADD18:%.*]] = add nsw i32 [[TMP21]], [[MUL17]]
// CHECK4-NEXT:    store i32 [[ADD18]], i32* [[C10]], align 4
// CHECK4-NEXT:    [[BLOCK_ISA:%.*]] = getelementptr inbounds <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>, <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>* [[BLOCK]], i32 0, i32 0
// CHECK4-NEXT:    store i8* bitcast (i8** @_NSConcreteStackBlock to i8*), i8** [[BLOCK_ISA]], align 8
// CHECK4-NEXT:    [[BLOCK_FLAGS:%.*]] = getelementptr inbounds <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>, <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>* [[BLOCK]], i32 0, i32 1
// CHECK4-NEXT:    store i32 1073741824, i32* [[BLOCK_FLAGS]], align 8
// CHECK4-NEXT:    [[BLOCK_RESERVED:%.*]] = getelementptr inbounds <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>, <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>* [[BLOCK]], i32 0, i32 2
// CHECK4-NEXT:    store i32 0, i32* [[BLOCK_RESERVED]], align 4
// CHECK4-NEXT:    [[BLOCK_INVOKE:%.*]] = getelementptr inbounds <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>, <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>* [[BLOCK]], i32 0, i32 3
// CHECK4-NEXT:    store i8* bitcast (void (i8*)* @g1_block_invoke_2 to i8*), i8** [[BLOCK_INVOKE]], align 8
// CHECK4-NEXT:    [[BLOCK_DESCRIPTOR:%.*]] = getelementptr inbounds <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>, <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>* [[BLOCK]], i32 0, i32 4
// CHECK4-NEXT:    store %struct.__block_descriptor* bitcast ({ i64, i64, i8*, i8* }* @__block_descriptor_tmp.4 to %struct.__block_descriptor*), %struct.__block_descriptor** [[BLOCK_DESCRIPTOR]], align 8
// CHECK4-NEXT:    [[BLOCK_CAPTURED_THIS_ADDR:%.*]] = getelementptr inbounds <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>, <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>* [[BLOCK]], i32 0, i32 5
// CHECK4-NEXT:    store %struct.SS* [[TMP0]], %struct.SS** [[BLOCK_CAPTURED_THIS_ADDR]], align 8
// CHECK4-NEXT:    [[BLOCK_CAPTURED:%.*]] = getelementptr inbounds <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>, <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>* [[BLOCK]], i32 0, i32 6
// CHECK4-NEXT:    [[TMP23:%.*]] = load i32*, i32** [[_TMP8]], align 8
// CHECK4-NEXT:    store i32* [[TMP23]], i32** [[BLOCK_CAPTURED]], align 8
// CHECK4-NEXT:    [[BLOCK_CAPTURED19:%.*]] = getelementptr inbounds <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>, <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>* [[BLOCK]], i32 0, i32 8
// CHECK4-NEXT:    [[TMP24:%.*]] = load i32, i32* [[B9]], align 4
// CHECK4-NEXT:    store i32 [[TMP24]], i32* [[BLOCK_CAPTURED19]], align 8
// CHECK4-NEXT:    [[BLOCK_CAPTURED20:%.*]] = getelementptr inbounds <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>, <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>* [[BLOCK]], i32 0, i32 7
// CHECK4-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[_TMP11]], align 8
// CHECK4-NEXT:    store i32* [[TMP25]], i32** [[BLOCK_CAPTURED20]], align 8
// CHECK4-NEXT:    [[TMP26:%.*]] = bitcast <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>* [[BLOCK]] to void ()*
// CHECK4-NEXT:    [[BLOCK_LITERAL:%.*]] = bitcast void ()* [[TMP26]] to %struct.__block_literal_generic*
// CHECK4-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [[STRUCT___BLOCK_LITERAL_GENERIC:%.*]], %struct.__block_literal_generic* [[BLOCK_LITERAL]], i32 0, i32 3
// CHECK4-NEXT:    [[TMP28:%.*]] = bitcast %struct.__block_literal_generic* [[BLOCK_LITERAL]] to i8*
// CHECK4-NEXT:    [[TMP29:%.*]] = load i8*, i8** [[TMP27]], align 8
// CHECK4-NEXT:    [[TMP30:%.*]] = bitcast i8* [[TMP29]] to void (i8*)*
// CHECK4-NEXT:    call void [[TMP30]](i8* [[TMP28]])
// CHECK4-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK4:       omp.body.continue:
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK4:       omp.inner.for.inc:
// CHECK4-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[ADD21:%.*]] = add nsw i32 [[TMP31]], 1
// CHECK4-NEXT:    store i32 [[ADD21]], i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK4:       omp.inner.for.end:
// CHECK4-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK4:       omp.loop.exit:
// CHECK4-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB2]], i32 [[TMP10]])
// CHECK4-NEXT:    [[TMP32:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP33:%.*]] = icmp ne i32 [[TMP32]], 0
// CHECK4-NEXT:    br i1 [[TMP33]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK4:       .omp.linear.pu:
// CHECK4-NEXT:    [[TMP34:%.*]] = load i32*, i32** [[TMP]], align 8
// CHECK4-NEXT:    store i32* [[TMP34]], i32** [[_TMP22]], align 8
// CHECK4-NEXT:    [[TMP35:%.*]] = load i32, i32* [[A7]], align 4
// CHECK4-NEXT:    [[TMP36:%.*]] = load i32*, i32** [[_TMP22]], align 8
// CHECK4-NEXT:    store i32 [[TMP35]], i32* [[TMP36]], align 4
// CHECK4-NEXT:    [[TMP37:%.*]] = load i32, i32* [[B9]], align 4
// CHECK4-NEXT:    store i32 [[TMP37]], i32* [[B]], align 4
// CHECK4-NEXT:    [[TMP38:%.*]] = load i32*, i32** [[_TMP3]], align 8
// CHECK4-NEXT:    store i32* [[TMP38]], i32** [[_TMP23]], align 8
// CHECK4-NEXT:    [[TMP39:%.*]] = load i32, i32* [[C10]], align 4
// CHECK4-NEXT:    [[TMP40:%.*]] = load i32*, i32** [[_TMP23]], align 8
// CHECK4-NEXT:    store i32 [[TMP39]], i32* [[TMP40]], align 4
// CHECK4-NEXT:    [[TMP41:%.*]] = load i32, i32* [[B]], align 4
// CHECK4-NEXT:    [[B24:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[TMP0]], i32 0, i32 1
// CHECK4-NEXT:    [[TMP42:%.*]] = trunc i32 [[TMP41]] to i8
// CHECK4-NEXT:    [[BF_LOAD:%.*]] = load i8, i8* [[B24]], align 4
// CHECK4-NEXT:    [[BF_VALUE:%.*]] = and i8 [[TMP42]], 15
// CHECK4-NEXT:    [[BF_CLEAR:%.*]] = and i8 [[BF_LOAD]], -16
// CHECK4-NEXT:    [[BF_SET:%.*]] = or i8 [[BF_CLEAR]], [[BF_VALUE]]
// CHECK4-NEXT:    store i8 [[BF_SET]], i8* [[B24]], align 4
// CHECK4-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK4:       .omp.linear.pu.done:
// CHECK4-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB1]], i32 [[TMP10]])
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@g1_block_invoke_2
// CHECK4-SAME: (i8* [[DOTBLOCK_DESCRIPTOR:%.*]]) #[[ATTR2]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTBLOCK_DESCRIPTOR_ADDR:%.*]] = alloca i8*, align 8
// CHECK4-NEXT:    [[BLOCK_ADDR:%.*]] = alloca <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>*, align 8
// CHECK4-NEXT:    store i8* [[DOTBLOCK_DESCRIPTOR]], i8** [[DOTBLOCK_DESCRIPTOR_ADDR]], align 8
// CHECK4-NEXT:    [[BLOCK:%.*]] = bitcast i8* [[DOTBLOCK_DESCRIPTOR]] to <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>*
// CHECK4-NEXT:    store <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>* [[BLOCK]], <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>** [[BLOCK_ADDR]], align 8
// CHECK4-NEXT:    [[BLOCK_CAPTURED_THIS:%.*]] = getelementptr inbounds <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>, <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>* [[BLOCK]], i32 0, i32 5
// CHECK4-NEXT:    [[THIS:%.*]] = load %struct.SS*, %struct.SS** [[BLOCK_CAPTURED_THIS]], align 8
// CHECK4-NEXT:    [[BLOCK_CAPTURE_ADDR:%.*]] = getelementptr inbounds <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>, <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>* [[BLOCK]], i32 0, i32 6
// CHECK4-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[BLOCK_CAPTURE_ADDR]], align 8
// CHECK4-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK4-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP1]], 1
// CHECK4-NEXT:    store i32 [[INC]], i32* [[TMP0]], align 4
// CHECK4-NEXT:    [[BLOCK_CAPTURE_ADDR1:%.*]] = getelementptr inbounds <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>, <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>* [[BLOCK]], i32 0, i32 8
// CHECK4-NEXT:    [[TMP2:%.*]] = load i32, i32* [[BLOCK_CAPTURE_ADDR1]], align 8
// CHECK4-NEXT:    [[DEC:%.*]] = add nsw i32 [[TMP2]], -1
// CHECK4-NEXT:    store i32 [[DEC]], i32* [[BLOCK_CAPTURE_ADDR1]], align 8
// CHECK4-NEXT:    [[BLOCK_CAPTURE_ADDR2:%.*]] = getelementptr inbounds <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>, <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>* [[BLOCK]], i32 0, i32 7
// CHECK4-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[BLOCK_CAPTURE_ADDR2]], align 8
// CHECK4-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP3]], align 4
// CHECK4-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP4]], 1
// CHECK4-NEXT:    store i32 [[DIV]], i32* [[TMP3]], align 4
// CHECK4-NEXT:    [[BLOCK_CAPTURE_ADDR3:%.*]] = getelementptr inbounds <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>, <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>* [[BLOCK]], i32 0, i32 6
// CHECK4-NEXT:    [[TMP5:%.*]] = load i32*, i32** [[BLOCK_CAPTURE_ADDR3]], align 8
// CHECK4-NEXT:    [[BLOCK_CAPTURE_ADDR4:%.*]] = getelementptr inbounds <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>, <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>* [[BLOCK]], i32 0, i32 8
// CHECK4-NEXT:    [[BLOCK_CAPTURE_ADDR5:%.*]] = getelementptr inbounds <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>, <{ i8*, i32, i32, i8*, %struct.__block_descriptor*, %struct.SS*, i32*, i32*, i32 }>* [[BLOCK]], i32 0, i32 7
// CHECK4-NEXT:    [[TMP6:%.*]] = load i32*, i32** [[BLOCK_CAPTURE_ADDR5]], align 8
// CHECK4-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, %struct.SS*, i32*, i32*, i32*)* @.omp_outlined..3 to void (i32*, i32*, ...)*), %struct.SS* [[THIS]], i32* [[TMP5]], i32* [[BLOCK_CAPTURE_ADDR4]], i32* [[TMP6]])
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK4-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], %struct.SS* [[THIS:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]], i32* nonnull align 4 dereferenceable(4) [[B:%.*]], i32* nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR3]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK4-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK4-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK4-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK4-NEXT:    [[B_ADDR:%.*]] = alloca i32*, align 8
// CHECK4-NEXT:    [[C_ADDR:%.*]] = alloca i32*, align 8
// CHECK4-NEXT:    [[TMP:%.*]] = alloca i32*, align 8
// CHECK4-NEXT:    [[_TMP1:%.*]] = alloca i32*, align 8
// CHECK4-NEXT:    [[_TMP2:%.*]] = alloca i32*, align 8
// CHECK4-NEXT:    [[_TMP3:%.*]] = alloca i32*, align 8
// CHECK4-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[_TMP4:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTLINEAR_START5:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTLINEAR_START6:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[A7:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[_TMP8:%.*]] = alloca i32*, align 8
// CHECK4-NEXT:    [[B9:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[C10:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[_TMP11:%.*]] = alloca i32*, align 8
// CHECK4-NEXT:    [[_TMP20:%.*]] = alloca i32*, align 8
// CHECK4-NEXT:    [[_TMP21:%.*]] = alloca i32*, align 8
// CHECK4-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK4-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK4-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK4-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK4-NEXT:    store i32* [[B]], i32** [[B_ADDR]], align 8
// CHECK4-NEXT:    store i32* [[C]], i32** [[C_ADDR]], align 8
// CHECK4-NEXT:    [[TMP0:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK4-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[A_ADDR]], align 8
// CHECK4-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[B_ADDR]], align 8
// CHECK4-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[C_ADDR]], align 8
// CHECK4-NEXT:    store i32* [[TMP1]], i32** [[TMP]], align 8
// CHECK4-NEXT:    store i32* [[TMP3]], i32** [[_TMP1]], align 8
// CHECK4-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[TMP]], align 8
// CHECK4-NEXT:    store i32* [[TMP4]], i32** [[_TMP2]], align 8
// CHECK4-NEXT:    [[TMP5:%.*]] = load i32*, i32** [[_TMP1]], align 8
// CHECK4-NEXT:    store i32* [[TMP5]], i32** [[_TMP3]], align 8
// CHECK4-NEXT:    [[TMP6:%.*]] = load i32*, i32** [[_TMP2]], align 8
// CHECK4-NEXT:    [[TMP7:%.*]] = load i32, i32* [[TMP6]], align 4
// CHECK4-NEXT:    store i32 [[TMP7]], i32* [[DOTLINEAR_START]], align 4
// CHECK4-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK4-NEXT:    store i32 [[TMP8]], i32* [[DOTLINEAR_START5]], align 4
// CHECK4-NEXT:    [[TMP9:%.*]] = load i32*, i32** [[_TMP3]], align 8
// CHECK4-NEXT:    [[TMP10:%.*]] = load i32, i32* [[TMP9]], align 4
// CHECK4-NEXT:    store i32 [[TMP10]], i32* [[DOTLINEAR_START6]], align 4
// CHECK4-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK4-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK4-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP11:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK4-NEXT:    [[TMP12:%.*]] = load i32, i32* [[TMP11]], align 4
// CHECK4-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB1]], i32 [[TMP12]])
// CHECK4-NEXT:    store i32* [[A7]], i32** [[_TMP8]], align 8
// CHECK4-NEXT:    store i32* [[C10]], i32** [[_TMP11]], align 8
// CHECK4-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP12]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK4-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP13]], 1
// CHECK4-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK4:       cond.true:
// CHECK4-NEXT:    br label [[COND_END:%.*]]
// CHECK4:       cond.false:
// CHECK4-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    br label [[COND_END]]
// CHECK4:       cond.end:
// CHECK4-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP14]], [[COND_FALSE]] ]
// CHECK4-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK4-NEXT:    store i32 [[TMP15]], i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK4:       omp.inner.for.cond:
// CHECK4-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[CMP12:%.*]] = icmp sle i32 [[TMP16]], [[TMP17]]
// CHECK4-NEXT:    br i1 [[CMP12]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK4:       omp.inner.for.body:
// CHECK4-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP18]], 1
// CHECK4-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK4-NEXT:    store i32 [[ADD]], i32* [[I]], align 4
// CHECK4-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTLINEAR_START]], align 4
// CHECK4-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[MUL13:%.*]] = mul nsw i32 [[TMP20]], 1
// CHECK4-NEXT:    [[ADD14:%.*]] = add nsw i32 [[TMP19]], [[MUL13]]
// CHECK4-NEXT:    store i32 [[ADD14]], i32* [[A7]], align 4
// CHECK4-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTLINEAR_START5]], align 4
// CHECK4-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[MUL15:%.*]] = mul nsw i32 [[TMP22]], 1
// CHECK4-NEXT:    [[ADD16:%.*]] = add nsw i32 [[TMP21]], [[MUL15]]
// CHECK4-NEXT:    store i32 [[ADD16]], i32* [[B9]], align 4
// CHECK4-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTLINEAR_START6]], align 4
// CHECK4-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[MUL17:%.*]] = mul nsw i32 [[TMP24]], 1
// CHECK4-NEXT:    [[ADD18:%.*]] = add nsw i32 [[TMP23]], [[MUL17]]
// CHECK4-NEXT:    store i32 [[ADD18]], i32* [[C10]], align 4
// CHECK4-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[_TMP8]], align 8
// CHECK4-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK4-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP26]], 1
// CHECK4-NEXT:    store i32 [[INC]], i32* [[TMP25]], align 4
// CHECK4-NEXT:    [[TMP27:%.*]] = load i32, i32* [[B9]], align 4
// CHECK4-NEXT:    [[DEC:%.*]] = add nsw i32 [[TMP27]], -1
// CHECK4-NEXT:    store i32 [[DEC]], i32* [[B9]], align 4
// CHECK4-NEXT:    [[TMP28:%.*]] = load i32*, i32** [[_TMP11]], align 8
// CHECK4-NEXT:    [[TMP29:%.*]] = load i32, i32* [[TMP28]], align 4
// CHECK4-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP29]], 1
// CHECK4-NEXT:    store i32 [[DIV]], i32* [[TMP28]], align 4
// CHECK4-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK4:       omp.body.continue:
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK4:       omp.inner.for.inc:
// CHECK4-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[ADD19:%.*]] = add nsw i32 [[TMP30]], 1
// CHECK4-NEXT:    store i32 [[ADD19]], i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK4:       omp.inner.for.end:
// CHECK4-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK4:       omp.loop.exit:
// CHECK4-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB2]], i32 [[TMP12]])
// CHECK4-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP32:%.*]] = icmp ne i32 [[TMP31]], 0
// CHECK4-NEXT:    br i1 [[TMP32]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK4:       .omp.linear.pu:
// CHECK4-NEXT:    [[TMP33:%.*]] = load i32*, i32** [[_TMP2]], align 8
// CHECK4-NEXT:    store i32* [[TMP33]], i32** [[_TMP20]], align 8
// CHECK4-NEXT:    [[TMP34:%.*]] = load i32, i32* [[A7]], align 4
// CHECK4-NEXT:    [[TMP35:%.*]] = load i32*, i32** [[_TMP20]], align 8
// CHECK4-NEXT:    store i32 [[TMP34]], i32* [[TMP35]], align 4
// CHECK4-NEXT:    [[TMP36:%.*]] = load i32, i32* [[B9]], align 4
// CHECK4-NEXT:    store i32 [[TMP36]], i32* [[TMP2]], align 4
// CHECK4-NEXT:    [[TMP37:%.*]] = load i32*, i32** [[_TMP3]], align 8
// CHECK4-NEXT:    store i32* [[TMP37]], i32** [[_TMP21]], align 8
// CHECK4-NEXT:    [[TMP38:%.*]] = load i32, i32* [[C10]], align 4
// CHECK4-NEXT:    [[C22:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[TMP0]], i32 0, i32 2
// CHECK4-NEXT:    [[TMP39:%.*]] = load i32*, i32** [[C22]], align 8
// CHECK4-NEXT:    store i32 [[TMP38]], i32* [[TMP39]], align 4
// CHECK4-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK4:       .omp.linear.pu.done:
// CHECK4-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB1]], i32 [[TMP12]])
// CHECK4-NEXT:    ret void
//
